// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudhsm provides a client for Amazon CloudHSM.
package cloudhsm

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTagsToResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTagsToResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToResourceOutput{}
	req.Data = output
	return
}

// AddTagsToResource API operation for Amazon CloudHSM.
//
// Adds or overwrites one or more tags for the specified AWS CloudHSM resource.
//
// Each tag consists of a key and a value. Tag keys must be unique to each resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHapg = "CreateHapg"

// CreateHapgRequest generates a "aws/request.Request" representing the
// client's request for the CreateHapg operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHapg for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHapg method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHapgRequest method.
//    req, resp := client.CreateHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) CreateHapgRequest(input *CreateHapgInput) (req *request.Request, output *CreateHapgOutput) {
	op := &request.Operation{
		Name:       opCreateHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHapgInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHapgOutput{}
	req.Data = output
	return
}

// CreateHapg API operation for Amazon CloudHSM.
//
// Creates a high-availability partition group. A high-availability partition
// group is a group of partitions that spans multiple physical HSMs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateHapg for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) CreateHapg(input *CreateHapgInput) (*CreateHapgOutput, error) {
	req, out := c.CreateHapgRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHsm = "CreateHsm"

// CreateHsmRequest generates a "aws/request.Request" representing the
// client's request for the CreateHsm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateHsm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateHsm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateHsmRequest method.
//    req, resp := client.CreateHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) CreateHsmRequest(input *CreateHsmInput) (req *request.Request, output *CreateHsmOutput) {
	op := &request.Operation{
		Name:       opCreateHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHsmOutput{}
	req.Data = output
	return
}

// CreateHsm API operation for Amazon CloudHSM.
//
// Creates an uninitialized HSM instance.
//
// There is an upfront fee charged for each HSM instance that you create with
// the CreateHsm operation. If you accidentally provision an HSM and want to
// request a refund, delete the instance using the DeleteHsm operation, go to
// the AWS Support Center (https://console.aws.amazon.com/support/home#/), create
// a new case, and select Account and Billing Support.
//
// It can take up to 20 minutes to create and provision an HSM. You can monitor
// the status of the HSM with the DescribeHsm operation. The HSM is ready to
// be initialized when the status changes to RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateHsm for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) CreateHsm(input *CreateHsmInput) (*CreateHsmOutput, error) {
	req, out := c.CreateHsmRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLunaClient = "CreateLunaClient"

// CreateLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the CreateLunaClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateLunaClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateLunaClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateLunaClientRequest method.
//    req, resp := client.CreateLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) CreateLunaClientRequest(input *CreateLunaClientInput) (req *request.Request, output *CreateLunaClientOutput) {
	op := &request.Operation{
		Name:       opCreateLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLunaClientOutput{}
	req.Data = output
	return
}

// CreateLunaClient API operation for Amazon CloudHSM.
//
// Creates an HSM client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation CreateLunaClient for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) CreateLunaClient(input *CreateLunaClientInput) (*CreateLunaClientOutput, error) {
	req, out := c.CreateLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHapg = "DeleteHapg"

// DeleteHapgRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHapg operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHapg for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHapg method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHapgRequest method.
//    req, resp := client.DeleteHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DeleteHapgRequest(input *DeleteHapgInput) (req *request.Request, output *DeleteHapgOutput) {
	op := &request.Operation{
		Name:       opDeleteHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHapgInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHapgOutput{}
	req.Data = output
	return
}

// DeleteHapg API operation for Amazon CloudHSM.
//
// Deletes a high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteHapg for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DeleteHapg(input *DeleteHapgInput) (*DeleteHapgOutput, error) {
	req, out := c.DeleteHapgRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHsm = "DeleteHsm"

// DeleteHsmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHsm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteHsm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteHsm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteHsmRequest method.
//    req, resp := client.DeleteHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DeleteHsmRequest(input *DeleteHsmInput) (req *request.Request, output *DeleteHsmOutput) {
	op := &request.Operation{
		Name:       opDeleteHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHsmInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHsmOutput{}
	req.Data = output
	return
}

// DeleteHsm API operation for Amazon CloudHSM.
//
// Deletes an HSM. After completion, this operation cannot be undone and your
// key material cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteHsm for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DeleteHsm(input *DeleteHsmInput) (*DeleteHsmOutput, error) {
	req, out := c.DeleteHsmRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLunaClient = "DeleteLunaClient"

// DeleteLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLunaClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteLunaClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteLunaClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteLunaClientRequest method.
//    req, resp := client.DeleteLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DeleteLunaClientRequest(input *DeleteLunaClientInput) (req *request.Request, output *DeleteLunaClientOutput) {
	op := &request.Operation{
		Name:       opDeleteLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLunaClientOutput{}
	req.Data = output
	return
}

// DeleteLunaClient API operation for Amazon CloudHSM.
//
// Deletes a client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DeleteLunaClient for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DeleteLunaClient(input *DeleteLunaClientInput) (*DeleteLunaClientOutput, error) {
	req, out := c.DeleteLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHapg = "DescribeHapg"

// DescribeHapgRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHapg operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHapg for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHapg method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHapgRequest method.
//    req, resp := client.DescribeHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DescribeHapgRequest(input *DescribeHapgInput) (req *request.Request, output *DescribeHapgOutput) {
	op := &request.Operation{
		Name:       opDescribeHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHapgInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHapgOutput{}
	req.Data = output
	return
}

// DescribeHapg API operation for Amazon CloudHSM.
//
// Retrieves information about a high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeHapg for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DescribeHapg(input *DescribeHapgInput) (*DescribeHapgOutput, error) {
	req, out := c.DescribeHapgRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeHsm = "DescribeHsm"

// DescribeHsmRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHsm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeHsm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeHsm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeHsmRequest method.
//    req, resp := client.DescribeHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DescribeHsmRequest(input *DescribeHsmInput) (req *request.Request, output *DescribeHsmOutput) {
	op := &request.Operation{
		Name:       opDescribeHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeHsmInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeHsmOutput{}
	req.Data = output
	return
}

// DescribeHsm API operation for Amazon CloudHSM.
//
// Retrieves information about an HSM. You can identify the HSM by its ARN or
// its serial number.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeHsm for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DescribeHsm(input *DescribeHsmInput) (*DescribeHsmOutput, error) {
	req, out := c.DescribeHsmRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLunaClient = "DescribeLunaClient"

// DescribeLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLunaClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLunaClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLunaClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLunaClientRequest method.
//    req, resp := client.DescribeLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) DescribeLunaClientRequest(input *DescribeLunaClientInput) (req *request.Request, output *DescribeLunaClientOutput) {
	op := &request.Operation{
		Name:       opDescribeLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLunaClientOutput{}
	req.Data = output
	return
}

// DescribeLunaClient API operation for Amazon CloudHSM.
//
// Retrieves information about an HSM client.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation DescribeLunaClient for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) DescribeLunaClient(input *DescribeLunaClientInput) (*DescribeLunaClientOutput, error) {
	req, out := c.DescribeLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opGetConfig = "GetConfig"

// GetConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetConfigRequest method.
//    req, resp := client.GetConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) GetConfigRequest(input *GetConfigInput) (req *request.Request, output *GetConfigOutput) {
	op := &request.Operation{
		Name:       opGetConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetConfigOutput{}
	req.Data = output
	return
}

// GetConfig API operation for Amazon CloudHSM.
//
// Gets the configuration files necessary to connect to all high availability
// partition groups the client is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation GetConfig for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) GetConfig(input *GetConfigInput) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	err := req.Send()
	return out, err
}

const opListAvailableZones = "ListAvailableZones"

// ListAvailableZonesRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableZones operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAvailableZones for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAvailableZones method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAvailableZonesRequest method.
//    req, resp := client.ListAvailableZonesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ListAvailableZonesRequest(input *ListAvailableZonesInput) (req *request.Request, output *ListAvailableZonesOutput) {
	op := &request.Operation{
		Name:       opListAvailableZones,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAvailableZonesOutput{}
	req.Data = output
	return
}

// ListAvailableZones API operation for Amazon CloudHSM.
//
// Lists the Availability Zones that have available AWS CloudHSM capacity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListAvailableZones for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ListAvailableZones(input *ListAvailableZonesInput) (*ListAvailableZonesOutput, error) {
	req, out := c.ListAvailableZonesRequest(input)
	err := req.Send()
	return out, err
}

const opListHapgs = "ListHapgs"

// ListHapgsRequest generates a "aws/request.Request" representing the
// client's request for the ListHapgs operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHapgs for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHapgs method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHapgsRequest method.
//    req, resp := client.ListHapgsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ListHapgsRequest(input *ListHapgsInput) (req *request.Request, output *ListHapgsOutput) {
	op := &request.Operation{
		Name:       opListHapgs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHapgsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHapgsOutput{}
	req.Data = output
	return
}

// ListHapgs API operation for Amazon CloudHSM.
//
// Lists the high-availability partition groups for the account.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHapgs to retrieve the next
// set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListHapgs for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ListHapgs(input *ListHapgsInput) (*ListHapgsOutput, error) {
	req, out := c.ListHapgsRequest(input)
	err := req.Send()
	return out, err
}

const opListHsms = "ListHsms"

// ListHsmsRequest generates a "aws/request.Request" representing the
// client's request for the ListHsms operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListHsms for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListHsms method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListHsmsRequest method.
//    req, resp := client.ListHsmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ListHsmsRequest(input *ListHsmsInput) (req *request.Request, output *ListHsmsOutput) {
	op := &request.Operation{
		Name:       opListHsms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListHsmsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHsmsOutput{}
	req.Data = output
	return
}

// ListHsms API operation for Amazon CloudHSM.
//
// Retrieves the identifiers of all of the HSMs provisioned for the current
// customer.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListHsms to retrieve the next set
// of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListHsms for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ListHsms(input *ListHsmsInput) (*ListHsmsOutput, error) {
	req, out := c.ListHsmsRequest(input)
	err := req.Send()
	return out, err
}

const opListLunaClients = "ListLunaClients"

// ListLunaClientsRequest generates a "aws/request.Request" representing the
// client's request for the ListLunaClients operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListLunaClients for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListLunaClients method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListLunaClientsRequest method.
//    req, resp := client.ListLunaClientsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ListLunaClientsRequest(input *ListLunaClientsInput) (req *request.Request, output *ListLunaClientsOutput) {
	op := &request.Operation{
		Name:       opListLunaClients,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLunaClientsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListLunaClientsOutput{}
	req.Data = output
	return
}

// ListLunaClients API operation for Amazon CloudHSM.
//
// Lists all of the clients.
//
// This operation supports pagination with the use of the NextToken member.
// If more results are available, the NextToken member of the response contains
// a token that you pass in the next call to ListLunaClients to retrieve the
// next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListLunaClients for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ListLunaClients(input *ListLunaClientsInput) (*ListLunaClientsOutput, error) {
	req, out := c.ListLunaClientsRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// ListTagsForResource API operation for Amazon CloudHSM.
//
// Returns a list of all tags for the specified AWS CloudHSM resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHapg = "ModifyHapg"

// ModifyHapgRequest generates a "aws/request.Request" representing the
// client's request for the ModifyHapg operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyHapg for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyHapg method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyHapgRequest method.
//    req, resp := client.ModifyHapgRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ModifyHapgRequest(input *ModifyHapgInput) (req *request.Request, output *ModifyHapgOutput) {
	op := &request.Operation{
		Name:       opModifyHapg,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHapgInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyHapgOutput{}
	req.Data = output
	return
}

// ModifyHapg API operation for Amazon CloudHSM.
//
// Modifies an existing high-availability partition group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyHapg for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ModifyHapg(input *ModifyHapgInput) (*ModifyHapgOutput, error) {
	req, out := c.ModifyHapgRequest(input)
	err := req.Send()
	return out, err
}

const opModifyHsm = "ModifyHsm"

// ModifyHsmRequest generates a "aws/request.Request" representing the
// client's request for the ModifyHsm operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyHsm for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyHsm method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyHsmRequest method.
//    req, resp := client.ModifyHsmRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ModifyHsmRequest(input *ModifyHsmInput) (req *request.Request, output *ModifyHsmOutput) {
	op := &request.Operation{
		Name:       opModifyHsm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyHsmInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyHsmOutput{}
	req.Data = output
	return
}

// ModifyHsm API operation for Amazon CloudHSM.
//
// Modifies an HSM.
//
// This operation can result in the HSM being offline for up to 15 minutes while
// the AWS CloudHSM service is reconfigured. If you are modifying a production
// HSM, you should ensure that your AWS CloudHSM service is configured for high
// availability, and consider executing this operation during a maintenance
// window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyHsm for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) ModifyHsm(input *ModifyHsmInput) (*ModifyHsmOutput, error) {
	req, out := c.ModifyHsmRequest(input)
	err := req.Send()
	return out, err
}

const opModifyLunaClient = "ModifyLunaClient"

// ModifyLunaClientRequest generates a "aws/request.Request" representing the
// client's request for the ModifyLunaClient operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyLunaClient for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyLunaClient method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyLunaClientRequest method.
//    req, resp := client.ModifyLunaClientRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) ModifyLunaClientRequest(input *ModifyLunaClientInput) (req *request.Request, output *ModifyLunaClientOutput) {
	op := &request.Operation{
		Name:       opModifyLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLunaClientInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyLunaClientOutput{}
	req.Data = output
	return
}

// ModifyLunaClient API operation for Amazon CloudHSM.
//
// Modifies the certificate used by the client.
//
// This action can potentially start a workflow to install the new certificate
// on the client's HSMs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation ModifyLunaClient for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
func (c *CloudHSM) ModifyLunaClient(input *ModifyLunaClientInput) (*ModifyLunaClientOutput, error) {
	req, out := c.ModifyLunaClientRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTagsFromResource for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTagsFromResource method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CloudHSM) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromResourceOutput{}
	req.Data = output
	return
}

// RemoveTagsFromResource API operation for Amazon CloudHSM.
//
// Removes one or more tags from the specified AWS CloudHSM resource.
//
// To remove a tag, specify only the tag key to remove (not the value). To overwrite
// the value for an existing tag, use AddTagsToResource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudHSM's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Codes:
//   * CloudHsmServiceException
//   Indicates that an exception occurred in the AWS CloudHSM service.
//
//   * CloudHsmInternalException
//   Indicates that an internal error occurred.
//
//   * InvalidRequestException
//   Indicates that one or more of the request parameters are not valid.
//
func (c *CloudHSM) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	err := req.Send()
	return out, err
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// One or more tags.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateHapgRequest action.
type CreateHapgInput struct {
	_ struct{} `type:"structure"`

	// The label of the new high-availability partition group.
	//
	// Label is a required field
	Label *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHapgInput"}
	if s.Label == nil {
		invalidParams.Add(request.NewErrParamRequired("Label"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the CreateHAPartitionGroup action.
type CreateHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`
}

// String returns the string representation
func (s CreateHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHapgOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateHsm operation.
type CreateHsmInput struct {
	_ struct{} `locationName:"CreateHsmRequest" type:"structure"`

	// A user-defined token to ensure idempotence. Subsequent calls to this operation
	// with the same token will be ignored.
	ClientToken *string `locationName:"ClientToken" type:"string"`

	// The IP address to assign to the HSM's ENI.
	//
	// If an IP address is not specified, an IP address will be randomly chosen
	// from the CIDR range of the subnet.
	EniIp *string `locationName:"EniIp" type:"string"`

	// The external ID from IamRoleArn, if present.
	ExternalId *string `locationName:"ExternalId" type:"string"`

	// The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
	// ENI on your behalf.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `locationName:"IamRoleArn" type:"string" required:"true"`

	// The SSH public key to install on the HSM.
	//
	// SshKey is a required field
	SshKey *string `locationName:"SshKey" type:"string" required:"true"`

	// The identifier of the subnet in your VPC in which to place the HSM.
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"SubnetId" type:"string" required:"true"`

	// Specifies the type of subscription for the HSM.
	//
	//    * PRODUCTION - The HSM is being used in a production environment.
	//    * TRIAL - The HSM is being used in a product trial.
	//
	// SubscriptionType is a required field
	SubscriptionType *string `locationName:"SubscriptionType" type:"string" required:"true" enum:"SubscriptionType"`

	// The IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIp *string `locationName:"SyslogIp" type:"string"`
}

// String returns the string representation
func (s CreateHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHsmInput"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.SshKey == nil {
		invalidParams.Add(request.NewErrParamRequired("SshKey"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubscriptionType == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the CreateHsm operation.
type CreateHsmOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`
}

// String returns the string representation
func (s CreateHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHsmOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateLunaClient action.
type CreateLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The contents of a Base64-Encoded X.509 v3 certificate to be installed on
	// the HSMs used by this client.
	//
	// Certificate is a required field
	Certificate *string `min:"600" type:"string" required:"true"`

	// The label for the client.
	Label *string `type:"string"`
}

// String returns the string representation
func (s CreateLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLunaClientInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 600 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 600))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the CreateLunaClient action.
type CreateLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s CreateLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLunaClientOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteHapg action.
type DeleteHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to delete.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DeleteHapg action.
type DeleteHapgOutput struct {
	_ struct{} `type:"structure"`

	// The status of the action.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHapgOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteHsm operation.
type DeleteHsmInput struct {
	_ struct{} `locationName:"DeleteHsmRequest" type:"structure"`

	// The ARN of the HSM to delete.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHsmInput"}
	if s.HsmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DeleteHsm operation.
type DeleteHsmOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHsmOutput) GoString() string {
	return s.String()
}

type DeleteLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client to delete.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLunaClientInput"}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The status of the action.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLunaClientOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeHapg action.
type DescribeHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to describe.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the DescribeHapg action.
type DescribeHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`

	// The serial number of the high-availability partition group.
	HapgSerial *string `type:"string"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsLastActionFailed []*string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingDeletion []*string `type:"list"`

	// Contains a list of ARNs that identify the HSMs.
	HsmsPendingRegistration []*string `type:"list"`

	// The label for the high-availability partition group.
	Label *string `type:"string"`

	// The date and time the high-availability partition group was last modified.
	LastModifiedTimestamp *string `type:"string"`

	// The list of partition serial numbers that belong to the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`

	// The state of the high-availability partition group.
	State *string `type:"string" enum:"CloudHsmObjectState"`
}

// String returns the string representation
func (s DescribeHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHapgOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeHsm operation.
type DescribeHsmInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must
	// be specified.
	HsmArn *string `type:"string"`

	// The serial number of the HSM. Either the HsmArn or the HsmSerialNumber parameter
	// must be specified.
	HsmSerialNumber *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmInput) GoString() string {
	return s.String()
}

// Contains the output of the DescribeHsm operation.
type DescribeHsmOutput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the HSM is in.
	AvailabilityZone *string `type:"string"`

	// The identifier of the elastic network interface (ENI) attached to the HSM.
	EniId *string `type:"string"`

	// The IP address assigned to the HSM's ENI.
	EniIp *string `type:"string"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`

	// The HSM model type.
	HsmType *string `type:"string"`

	// The ARN of the IAM role assigned to the HSM.
	IamRoleArn *string `type:"string"`

	// The list of partitions on the HSM.
	Partitions []*string `type:"list"`

	// The serial number of the HSM.
	SerialNumber *string `type:"string"`

	// The date and time that the server certificate was last updated.
	ServerCertLastUpdated *string `type:"string"`

	// The URI of the certificate server.
	ServerCertUri *string `type:"string"`

	// The HSM software version.
	SoftwareVersion *string `type:"string"`

	// The date and time that the SSH key was last updated.
	SshKeyLastUpdated *string `type:"string"`

	// The public SSH key.
	SshPublicKey *string `type:"string"`

	// The status of the HSM.
	Status *string `type:"string" enum:"HsmStatus"`

	// Contains additional information about the status of the HSM.
	StatusDetails *string `type:"string"`

	// The identifier of the subnet that the HSM is in.
	SubnetId *string `type:"string"`

	// The subscription end date.
	SubscriptionEndDate *string `type:"string"`

	// The subscription start date.
	SubscriptionStartDate *string `type:"string"`

	// Specifies the type of subscription for the HSM.
	//
	//    * PRODUCTION - The HSM is being used in a production environment.
	//    * TRIAL - The HSM is being used in a product trial.
	SubscriptionType *string `type:"string" enum:"SubscriptionType"`

	// The name of the HSM vendor.
	VendorName *string `type:"string"`

	// The identifier of the VPC that the HSM is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DescribeHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeHsmOutput) GoString() string {
	return s.String()
}

type DescribeLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientInput) GoString() string {
	return s.String()
}

type DescribeLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The certificate installed on the HSMs used by this client.
	Certificate *string `min:"600" type:"string"`

	// The certificate fingerprint.
	CertificateFingerprint *string `type:"string"`

	// The ARN of the client.
	ClientArn *string `type:"string"`

	// The label of the client.
	Label *string `type:"string"`

	// The date and time the client was last modified.
	LastModifiedTimestamp *string `type:"string"`
}

// String returns the string representation
func (s DescribeLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLunaClientOutput) GoString() string {
	return s.String()
}

type GetConfigInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`

	// The client version.
	//
	// ClientVersion is a required field
	ClientVersion *string `type:"string" required:"true" enum:"ClientVersion"`

	// A list of ARNs that identify the high-availability partition groups that
	// are associated with the client.
	//
	// HapgList is a required field
	HapgList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigInput"}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}
	if s.ClientVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientVersion"))
	}
	if s.HapgList == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetConfigOutput struct {
	_ struct{} `type:"structure"`

	// The certificate file containing the server.pem files of the HSMs.
	ConfigCred *string `type:"string"`

	// The chrystoki.conf configuration file.
	ConfigFile *string `type:"string"`

	// The type of credentials.
	ConfigType *string `type:"string"`
}

// String returns the string representation
func (s GetConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the ListAvailableZones action.
type ListAvailableZonesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListAvailableZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesInput) GoString() string {
	return s.String()
}

type ListAvailableZonesOutput struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones that have available AWS CloudHSM capacity.
	AZList []*string `type:"list"`
}

// String returns the string representation
func (s ListAvailableZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableZonesOutput) GoString() string {
	return s.String()
}

type ListHapgsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListHapgs. Pass null if this
	// is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHapgsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsInput) GoString() string {
	return s.String()
}

type ListHapgsOutput struct {
	_ struct{} `type:"structure"`

	// The list of high-availability partition groups.
	//
	// HapgList is a required field
	HapgList []*string `type:"list" required:"true"`

	// If not null, more results are available. Pass this value to ListHapgs to
	// retrieve the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHapgsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHapgsOutput) GoString() string {
	return s.String()
}

type ListHsmsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListHsms. Pass null if this is
	// the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHsmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHsmsInput) GoString() string {
	return s.String()
}

// Contains the output of the ListHsms operation.
type ListHsmsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ARNs that identify the HSMs.
	HsmList []*string `type:"list"`

	// If not null, more results are available. Pass this value to ListHsms to retrieve
	// the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListHsmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHsmsOutput) GoString() string {
	return s.String()
}

type ListLunaClientsInput struct {
	_ struct{} `type:"structure"`

	// The NextToken value from a previous call to ListLunaClients. Pass null if
	// this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsInput) GoString() string {
	return s.String()
}

type ListLunaClientsOutput struct {
	_ struct{} `type:"structure"`

	// The list of clients.
	//
	// ClientList is a required field
	ClientList []*string `type:"list" required:"true"`

	// If not null, more results are available. Pass this to ListLunaClients to
	// retrieve the next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLunaClientsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLunaClientsOutput) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

type ModifyHapgInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group to modify.
	//
	// HapgArn is a required field
	HapgArn *string `type:"string" required:"true"`

	// The new label for the high-availability partition group.
	Label *string `type:"string"`

	// The list of partition serial numbers to make members of the high-availability
	// partition group.
	PartitionSerialList []*string `type:"list"`
}

// String returns the string representation
func (s ModifyHapgInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHapgInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHapgInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyHapgInput"}
	if s.HapgArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HapgArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyHapgOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the high-availability partition group.
	HapgArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHapgOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHapgOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the ModifyHsm operation.
type ModifyHsmInput struct {
	_ struct{} `locationName:"ModifyHsmRequest" type:"structure"`

	// The new IP address for the elastic network interface (ENI) attached to the
	// HSM.
	//
	// If the HSM is moved to a different subnet, and an IP address is not specified,
	// an IP address will be randomly chosen from the CIDR range of the new subnet.
	EniIp *string `locationName:"EniIp" type:"string"`

	// The new external ID.
	ExternalId *string `locationName:"ExternalId" type:"string"`

	// The ARN of the HSM to modify.
	//
	// HsmArn is a required field
	HsmArn *string `locationName:"HsmArn" type:"string" required:"true"`

	// The new IAM role ARN.
	IamRoleArn *string `locationName:"IamRoleArn" type:"string"`

	// The new identifier of the subnet that the HSM is in. The new subnet must
	// be in the same Availability Zone as the current subnet.
	SubnetId *string `locationName:"SubnetId" type:"string"`

	// The new IP address for the syslog monitoring server. The AWS CloudHSM service
	// only supports one syslog monitoring server.
	SyslogIp *string `locationName:"SyslogIp" type:"string"`
}

// String returns the string representation
func (s ModifyHsmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHsmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyHsmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyHsmInput"}
	if s.HsmArn == nil {
		invalidParams.Add(request.NewErrParamRequired("HsmArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of the ModifyHsm operation.
type ModifyHsmOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the HSM.
	HsmArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyHsmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyHsmOutput) GoString() string {
	return s.String()
}

type ModifyLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The new certificate for the client.
	//
	// Certificate is a required field
	Certificate *string `min:"600" type:"string" required:"true"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyLunaClientInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyLunaClientInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 600 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 600))
	}
	if s.ClientArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyLunaClientOutput) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag key or keys to remove.
	//
	// Specify only the tag key to remove (not the value). To overwrite the value
	// for an existing tag, use AddTagsToResource.
	//
	// TagKeyList is a required field
	TagKeyList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeyList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeyList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`

	// The status of the operation.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// A key-value pair that identifies or specifies metadata about an AWS CloudHSM
// resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

const (
	// ClientVersion51 is a ClientVersion enum value
	ClientVersion51 = "5.1"

	// ClientVersion53 is a ClientVersion enum value
	ClientVersion53 = "5.3"
)

const (
	// CloudHsmObjectStateReady is a CloudHsmObjectState enum value
	CloudHsmObjectStateReady = "READY"

	// CloudHsmObjectStateUpdating is a CloudHsmObjectState enum value
	CloudHsmObjectStateUpdating = "UPDATING"

	// CloudHsmObjectStateDegraded is a CloudHsmObjectState enum value
	CloudHsmObjectStateDegraded = "DEGRADED"
)

const (
	// HsmStatusPending is a HsmStatus enum value
	HsmStatusPending = "PENDING"

	// HsmStatusRunning is a HsmStatus enum value
	HsmStatusRunning = "RUNNING"

	// HsmStatusUpdating is a HsmStatus enum value
	HsmStatusUpdating = "UPDATING"

	// HsmStatusSuspended is a HsmStatus enum value
	HsmStatusSuspended = "SUSPENDED"

	// HsmStatusTerminating is a HsmStatus enum value
	HsmStatusTerminating = "TERMINATING"

	// HsmStatusTerminated is a HsmStatus enum value
	HsmStatusTerminated = "TERMINATED"

	// HsmStatusDegraded is a HsmStatus enum value
	HsmStatusDegraded = "DEGRADED"
)

// Specifies the type of subscription for the HSM.
//
//    * PRODUCTION - The HSM is being used in a production environment.
//    * TRIAL - The HSM is being used in a product trial.
const (
	// SubscriptionTypeProduction is a SubscriptionType enum value
	SubscriptionTypeProduction = "PRODUCTION"
)
