// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An object that represents the access logging information for a virtual node.
//
// The following types satisfy this interface:
//
//	AccessLogMemberFile
type AccessLog interface {
	isAccessLog()
}

// The file object to send virtual node access logs to.
type AccessLogMemberFile struct {
	Value FileAccessLog

	noSmithyDocumentSerde
}

func (*AccessLogMemberFile) isAccessLog() {}

// An object that represents the Cloud Map attribute information for your virtual
// node.
//
// Cloud Map is not available in the eu-south-1 Region.
type AwsCloudMapInstanceAttribute struct {

	// The name of an Cloud Map service instance attribute key. Any Cloud Map service
	// instance that contains the specified key and value is returned.
	//
	// This member is required.
	Key *string

	// The value of an Cloud Map service instance attribute key. Any Cloud Map service
	// instance that contains the specified key and value is returned.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that represents the Cloud Map service discovery information for your
// virtual node.
//
// Cloud Map is not available in the eu-south-1 Region.
type AwsCloudMapServiceDiscovery struct {

	// The name of the Cloud Map namespace to use.
	//
	// This member is required.
	NamespaceName *string

	// The name of the Cloud Map service to use.
	//
	// This member is required.
	ServiceName *string

	// A string map that contains attributes with values that you can use to filter
	// instances by any custom attribute that you specified when you registered the
	// instance. Only instances that match all of the specified key/value pairs will be
	// returned.
	Attributes []AwsCloudMapInstanceAttribute

	// The preferred IP version that this virtual node uses. Setting the IP preference
	// on the virtual node only overrides the IP preference set for the mesh on this
	// specific node.
	IpPreference IpPreference

	noSmithyDocumentSerde
}

// An object that represents the backends that a virtual node is expected to send
// outbound traffic to.
//
// The following types satisfy this interface:
//
//	BackendMemberVirtualService
type Backend interface {
	isBackend()
}

// Specifies a virtual service to use as a backend.
type BackendMemberVirtualService struct {
	Value VirtualServiceBackend

	noSmithyDocumentSerde
}

func (*BackendMemberVirtualService) isBackend() {}

// An object that represents the default properties for a backend.
type BackendDefaults struct {

	// A reference to an object that represents a client policy.
	ClientPolicy *ClientPolicy

	noSmithyDocumentSerde
}

// An object that represents a client policy.
type ClientPolicy struct {

	// A reference to an object that represents a Transport Layer Security (TLS)
	// client policy.
	Tls *ClientPolicyTls

	noSmithyDocumentSerde
}

// A reference to an object that represents a Transport Layer Security (TLS)
// client policy.
type ClientPolicyTls struct {

	// A reference to an object that represents a TLS validation context.
	//
	// This member is required.
	Validation *TlsValidationContext

	// A reference to an object that represents a client's TLS certificate.
	Certificate ClientTlsCertificate

	// Whether the policy is enforced. The default is True , if a value isn't specified.
	Enforce *bool

	// One or more ports that the policy is enforced for.
	Ports []int32

	noSmithyDocumentSerde
}

// An object that represents the client's certificate.
//
// The following types satisfy this interface:
//
//	ClientTlsCertificateMemberFile
//	ClientTlsCertificateMemberSds
type ClientTlsCertificate interface {
	isClientTlsCertificate()
}

// An object that represents a local file certificate. The certificate must meet
// specific requirements and you must have proxy authorization enabled. For more
// information, see [Transport Layer Security (TLS)].
//
// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type ClientTlsCertificateMemberFile struct {
	Value ListenerTlsFileCertificate

	noSmithyDocumentSerde
}

func (*ClientTlsCertificateMemberFile) isClientTlsCertificate() {}

// A reference to an object that represents a client's TLS Secret Discovery
// Service certificate.
type ClientTlsCertificateMemberSds struct {
	Value ListenerTlsSdsCertificate

	noSmithyDocumentSerde
}

func (*ClientTlsCertificateMemberSds) isClientTlsCertificate() {}

// An object that represents the DNS service discovery information for your
// virtual node.
type DnsServiceDiscovery struct {

	// Specifies the DNS service discovery hostname for the virtual node.
	//
	// This member is required.
	Hostname *string

	// The preferred IP version that this virtual node uses. Setting the IP preference
	// on the virtual node only overrides the IP preference set for the mesh on this
	// specific node.
	IpPreference IpPreference

	// Specifies the DNS response type for the virtual node.
	ResponseType DnsResponseType

	noSmithyDocumentSerde
}

// An object that represents a duration of time.
type Duration struct {

	// A unit of time.
	Unit DurationUnit

	// A number of time units.
	Value *int64

	noSmithyDocumentSerde
}

// An object that represents the egress filter rules for a service mesh.
type EgressFilter struct {

	// The egress filter type. By default, the type is DROP_ALL , which allows egress
	// only from virtual nodes to other defined resources in the service mesh (and any
	// traffic to *.amazonaws.com for Amazon Web Services API calls). You can set the
	// egress filter type to ALLOW_ALL to allow egress to any endpoint inside or
	// outside of the service mesh.
	//
	// This member is required.
	Type EgressFilterType

	noSmithyDocumentSerde
}

// An object that represents an access log file.
type FileAccessLog struct {

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs , to export the access logs to a log storage service such as
	// Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// The Envoy process must have write permissions to the path that you specify
	// here. Otherwise, Envoy fails to bootstrap properly.
	//
	// This member is required.
	Path *string

	// The specified format for the logs. The format is either json_format or
	// text_format .
	Format LoggingFormat

	noSmithyDocumentSerde
}

// An object that represents a gateway route returned by a describe operation.
type GatewayRouteData struct {

	// The name of the gateway route.
	//
	// This member is required.
	GatewayRouteName *string

	// The name of the service mesh that the resource resides in.
	//
	// This member is required.
	MeshName *string

	// An object that represents metadata for a resource.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The specifications of the gateway route.
	//
	// This member is required.
	Spec *GatewayRouteSpec

	// The status of the gateway route.
	//
	// This member is required.
	Status *GatewayRouteStatus

	// The virtual gateway that the gateway route is associated with.
	//
	// This member is required.
	VirtualGatewayName *string

	noSmithyDocumentSerde
}

// An object representing the gateway route host name to match.
type GatewayRouteHostnameMatch struct {

	// The exact host name to match on.
	Exact *string

	// The specified ending characters of the host name to match on.
	Suffix *string

	noSmithyDocumentSerde
}

// An object representing the gateway route host name to rewrite.
type GatewayRouteHostnameRewrite struct {

	// The default target host name to write to.
	DefaultTargetHostname DefaultGatewayRouteRewrite

	noSmithyDocumentSerde
}

// An object that represents a gateway route returned by a list operation.
type GatewayRouteRef struct {

	// The full Amazon Resource Name (ARN) for the gateway route.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the gateway route.
	//
	// This member is required.
	GatewayRouteName *string

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the resource resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The virtual gateway that the gateway route is associated with.
	//
	// This member is required.
	VirtualGatewayName *string

	noSmithyDocumentSerde
}

// An object that represents a gateway route specification. Specify one gateway
// route type.
type GatewayRouteSpec struct {

	// An object that represents the specification of a gRPC gateway route.
	GrpcRoute *GrpcGatewayRoute

	// An object that represents the specification of an HTTP/2 gateway route.
	Http2Route *HttpGatewayRoute

	// An object that represents the specification of an HTTP gateway route.
	HttpRoute *HttpGatewayRoute

	// The ordering of the gateway routes spec.
	Priority *int32

	noSmithyDocumentSerde
}

// An object that represents the current status of a gateway route.
type GatewayRouteStatus struct {

	// The current status for the gateway route.
	//
	// This member is required.
	Status GatewayRouteStatusCode

	noSmithyDocumentSerde
}

// An object that represents a gateway route target.
type GatewayRouteTarget struct {

	// An object that represents a virtual service gateway route target.
	//
	// This member is required.
	VirtualService *GatewayRouteVirtualService

	// The port number of the gateway route target.
	Port *int32

	noSmithyDocumentSerde
}

// An object that represents the virtual service that traffic is routed to.
type GatewayRouteVirtualService struct {

	// The name of the virtual service that traffic is routed to.
	//
	// This member is required.
	VirtualServiceName *string

	noSmithyDocumentSerde
}

// An object that represents a gRPC gateway route.
type GrpcGatewayRoute struct {

	// An object that represents the action to take if a match is determined.
	//
	// This member is required.
	Action *GrpcGatewayRouteAction

	// An object that represents the criteria for determining a request match.
	//
	// This member is required.
	Match *GrpcGatewayRouteMatch

	noSmithyDocumentSerde
}

// An object that represents the action to take if a match is determined.
type GrpcGatewayRouteAction struct {

	// An object that represents the target that traffic is routed to when a request
	// matches the gateway route.
	//
	// This member is required.
	Target *GatewayRouteTarget

	// The gateway route action to rewrite.
	Rewrite *GrpcGatewayRouteRewrite

	noSmithyDocumentSerde
}

// An object that represents the criteria for determining a request match.
type GrpcGatewayRouteMatch struct {

	// The gateway route host name to be matched on.
	Hostname *GatewayRouteHostnameMatch

	// The gateway route metadata to be matched on.
	Metadata []GrpcGatewayRouteMetadata

	// The gateway route port to be matched on.
	Port *int32

	// The fully qualified domain name for the service to match from the request.
	ServiceName *string

	noSmithyDocumentSerde
}

// An object representing the metadata of the gateway route.
type GrpcGatewayRouteMetadata struct {

	// A name for the gateway route metadata.
	//
	// This member is required.
	Name *string

	// Specify True to match anything except the match criteria. The default value is
	// False .
	Invert *bool

	// The criteria for determining a metadata match.
	Match GrpcMetadataMatchMethod

	noSmithyDocumentSerde
}

// An object that represents the gateway route to rewrite.
type GrpcGatewayRouteRewrite struct {

	// The host name of the gateway route to rewrite.
	Hostname *GatewayRouteHostnameRewrite

	noSmithyDocumentSerde
}

// An object representing the method header to be matched.
//
// The following types satisfy this interface:
//
//	GrpcMetadataMatchMethodMemberExact
//	GrpcMetadataMatchMethodMemberPrefix
//	GrpcMetadataMatchMethodMemberRange
//	GrpcMetadataMatchMethodMemberRegex
//	GrpcMetadataMatchMethodMemberSuffix
type GrpcMetadataMatchMethod interface {
	isGrpcMetadataMatchMethod()
}

// The exact method header to be matched on.
type GrpcMetadataMatchMethodMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcMetadataMatchMethodMemberExact) isGrpcMetadataMatchMethod() {}

// The specified beginning characters of the method header to be matched on.
type GrpcMetadataMatchMethodMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcMetadataMatchMethodMemberPrefix) isGrpcMetadataMatchMethod() {}

// An object that represents the range of values to match on. The first character
// of the range is included in the range, though the last character is not. For
// example, if the range specified were 1-100, only values 1-99 would be matched.
type GrpcMetadataMatchMethodMemberRange struct {
	Value MatchRange

	noSmithyDocumentSerde
}

func (*GrpcMetadataMatchMethodMemberRange) isGrpcMetadataMatchMethod() {}

// The regex used to match the method header.
type GrpcMetadataMatchMethodMemberRegex struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcMetadataMatchMethodMemberRegex) isGrpcMetadataMatchMethod() {}

// The specified ending characters of the method header to match on.
type GrpcMetadataMatchMethodMemberSuffix struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcMetadataMatchMethodMemberSuffix) isGrpcMetadataMatchMethod() {}

// An object that represents a retry policy. Specify at least one value for at
// least one of the types of RetryEvents , a value for maxRetries , and a value for
// perRetryTimeout . Both server-error and gateway-error under httpRetryEvents
// include the Envoy reset policy. For more information on the reset policy, see
// the [Envoy documentation].
//
// [Envoy documentation]: https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on
type GrpcRetryPolicy struct {

	// The maximum number of retry attempts.
	//
	// This member is required.
	MaxRetries *int64

	// The timeout for each retry attempt.
	//
	// This member is required.
	PerRetryTimeout *Duration

	// Specify at least one of the valid values.
	GrpcRetryEvents []GrpcRetryPolicyEvent

	// Specify at least one of the following values.
	//
	//   - server-error – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507,
	//   508, 510, and 511
	//
	//   - gateway-error – HTTP status codes 502, 503, and 504
	//
	//   - client-error – HTTP status code 409
	//
	//   - stream-error – Retry on refused stream
	HttpRetryEvents []string

	// Specify a valid value. The event occurs before any processing of a request has
	// started and is encountered when the upstream is temporarily or permanently
	// unavailable.
	TcpRetryEvents []TcpRetryPolicyEvent

	noSmithyDocumentSerde
}

// An object that represents a gRPC route type.
type GrpcRoute struct {

	// An object that represents the action to take if a match is determined.
	//
	// This member is required.
	Action *GrpcRouteAction

	// An object that represents the criteria for determining a request match.
	//
	// This member is required.
	Match *GrpcRouteMatch

	// An object that represents a retry policy.
	RetryPolicy *GrpcRetryPolicy

	// An object that represents types of timeouts.
	Timeout *GrpcTimeout

	noSmithyDocumentSerde
}

// An object that represents the action to take if a match is determined.
type GrpcRouteAction struct {

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// This member is required.
	WeightedTargets []WeightedTarget

	noSmithyDocumentSerde
}

// An object that represents the criteria for determining a request match.
type GrpcRouteMatch struct {

	// An object that represents the data to match from the request.
	Metadata []GrpcRouteMetadata

	// The method name to match from the request. If you specify a name, you must also
	// specify a serviceName .
	MethodName *string

	// The port number to match on.
	Port *int32

	// The fully qualified domain name for the service to match from the request.
	ServiceName *string

	noSmithyDocumentSerde
}

// An object that represents the match metadata for the route.
type GrpcRouteMetadata struct {

	// The name of the route.
	//
	// This member is required.
	Name *string

	// Specify True to match anything except the match criteria. The default value is
	// False .
	Invert *bool

	// An object that represents the data to match from the request.
	Match GrpcRouteMetadataMatchMethod

	noSmithyDocumentSerde
}

// An object that represents the match method. Specify one of the match values.
//
// The following types satisfy this interface:
//
//	GrpcRouteMetadataMatchMethodMemberExact
//	GrpcRouteMetadataMatchMethodMemberPrefix
//	GrpcRouteMetadataMatchMethodMemberRange
//	GrpcRouteMetadataMatchMethodMemberRegex
//	GrpcRouteMetadataMatchMethodMemberSuffix
type GrpcRouteMetadataMatchMethod interface {
	isGrpcRouteMetadataMatchMethod()
}

// The value sent by the client must match the specified value exactly.
type GrpcRouteMetadataMatchMethodMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcRouteMetadataMatchMethodMemberExact) isGrpcRouteMetadataMatchMethod() {}

// The value sent by the client must begin with the specified characters.
type GrpcRouteMetadataMatchMethodMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcRouteMetadataMatchMethodMemberPrefix) isGrpcRouteMetadataMatchMethod() {}

// An object that represents the range of values to match on.
type GrpcRouteMetadataMatchMethodMemberRange struct {
	Value MatchRange

	noSmithyDocumentSerde
}

func (*GrpcRouteMetadataMatchMethodMemberRange) isGrpcRouteMetadataMatchMethod() {}

// The value sent by the client must include the specified characters.
type GrpcRouteMetadataMatchMethodMemberRegex struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcRouteMetadataMatchMethodMemberRegex) isGrpcRouteMetadataMatchMethod() {}

// The value sent by the client must end with the specified characters.
type GrpcRouteMetadataMatchMethodMemberSuffix struct {
	Value string

	noSmithyDocumentSerde
}

func (*GrpcRouteMetadataMatchMethodMemberSuffix) isGrpcRouteMetadataMatchMethod() {}

// An object that represents types of timeouts.
type GrpcTimeout struct {

	// An object that represents an idle timeout. An idle timeout bounds the amount of
	// time that a connection may be idle. The default value is none.
	Idle *Duration

	// An object that represents a per request timeout. The default value is 15
	// seconds. If you set a higher timeout, then make sure that the higher value is
	// set for each App Mesh resource in a conversation. For example, if a virtual node
	// backend uses a virtual router provider to route to another virtual node, then
	// the timeout should be greater than 15 seconds for the source and destination
	// virtual node and the route.
	PerRequest *Duration

	noSmithyDocumentSerde
}

// An object that represents the method and value to match with the header value
// sent in a request. Specify one match method.
//
// The following types satisfy this interface:
//
//	HeaderMatchMethodMemberExact
//	HeaderMatchMethodMemberPrefix
//	HeaderMatchMethodMemberRange
//	HeaderMatchMethodMemberRegex
//	HeaderMatchMethodMemberSuffix
type HeaderMatchMethod interface {
	isHeaderMatchMethod()
}

// The value sent by the client must match the specified value exactly.
type HeaderMatchMethodMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchMethodMemberExact) isHeaderMatchMethod() {}

// The value sent by the client must begin with the specified characters.
type HeaderMatchMethodMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchMethodMemberPrefix) isHeaderMatchMethod() {}

// An object that represents the range of values to match on.
type HeaderMatchMethodMemberRange struct {
	Value MatchRange

	noSmithyDocumentSerde
}

func (*HeaderMatchMethodMemberRange) isHeaderMatchMethod() {}

// The value sent by the client must include the specified characters.
type HeaderMatchMethodMemberRegex struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchMethodMemberRegex) isHeaderMatchMethod() {}

// The value sent by the client must end with the specified characters.
type HeaderMatchMethodMemberSuffix struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchMethodMemberSuffix) isHeaderMatchMethod() {}

// An object that represents the health check policy for a virtual node's listener.
type HealthCheckPolicy struct {

	// The number of consecutive successful health checks that must occur before
	// declaring listener healthy.
	//
	// This member is required.
	HealthyThreshold *int32

	// The time period in milliseconds between each health check execution.
	//
	// This member is required.
	IntervalMillis *int64

	// The protocol for the health check request. If you specify grpc , then your
	// service must conform to the [GRPC Health Checking Protocol].
	//
	// [GRPC Health Checking Protocol]: https://github.com/grpc/grpc/blob/master/doc/health-checking.md
	//
	// This member is required.
	Protocol PortProtocol

	// The amount of time to wait when receiving a response from the health check, in
	// milliseconds.
	//
	// This member is required.
	TimeoutMillis *int64

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual node unhealthy.
	//
	// This member is required.
	UnhealthyThreshold *int32

	// The destination path for the health check request. This value is only used if
	// the specified protocol is HTTP or HTTP/2. For any other protocol, this value is
	// ignored.
	Path *string

	// The destination port for the health check request. This port must match the
	// port defined in the PortMappingfor the listener.
	Port *int32

	noSmithyDocumentSerde
}

// An object that represents an HTTP gateway route.
type HttpGatewayRoute struct {

	// An object that represents the action to take if a match is determined.
	//
	// This member is required.
	Action *HttpGatewayRouteAction

	// An object that represents the criteria for determining a request match.
	//
	// This member is required.
	Match *HttpGatewayRouteMatch

	noSmithyDocumentSerde
}

// An object that represents the action to take if a match is determined.
type HttpGatewayRouteAction struct {

	// An object that represents the target that traffic is routed to when a request
	// matches the gateway route.
	//
	// This member is required.
	Target *GatewayRouteTarget

	// The gateway route action to rewrite.
	Rewrite *HttpGatewayRouteRewrite

	noSmithyDocumentSerde
}

// An object that represents the HTTP header in the gateway route.
type HttpGatewayRouteHeader struct {

	// A name for the HTTP header in the gateway route that will be matched on.
	//
	// This member is required.
	Name *string

	// Specify True to match anything except the match criteria. The default value is
	// False .
	Invert *bool

	// An object that represents the method and value to match with the header value
	// sent in a request. Specify one match method.
	Match HeaderMatchMethod

	noSmithyDocumentSerde
}

// An object that represents the criteria for determining a request match.
type HttpGatewayRouteMatch struct {

	// The client request headers to match on.
	Headers []HttpGatewayRouteHeader

	// The host name to match on.
	Hostname *GatewayRouteHostnameMatch

	// The method to match on.
	Method HttpMethod

	// The path to match on.
	Path *HttpPathMatch

	// The port number to match on.
	Port *int32

	// Specifies the path to match requests with. This parameter must always start
	// with / , which by itself matches all requests to the virtual service name. You
	// can also match for path-based routing of requests. For example, if your virtual
	// service name is my-service.local and you want the route to match requests to
	// my-service.local/metrics , your prefix should be /metrics .
	Prefix *string

	// The query parameter to match on.
	QueryParameters []HttpQueryParameter

	noSmithyDocumentSerde
}

// An object that represents the path to rewrite.
type HttpGatewayRoutePathRewrite struct {

	// The exact path to rewrite.
	Exact *string

	noSmithyDocumentSerde
}

// An object representing the beginning characters of the route to rewrite.
type HttpGatewayRoutePrefixRewrite struct {

	// The default prefix used to replace the incoming route prefix when rewritten.
	DefaultPrefix DefaultGatewayRouteRewrite

	// The value used to replace the incoming route prefix when rewritten.
	Value *string

	noSmithyDocumentSerde
}

// An object representing the gateway route to rewrite.
type HttpGatewayRouteRewrite struct {

	// The host name to rewrite.
	Hostname *GatewayRouteHostnameRewrite

	// The path to rewrite.
	Path *HttpGatewayRoutePathRewrite

	// The specified beginning characters to rewrite.
	Prefix *HttpGatewayRoutePrefixRewrite

	noSmithyDocumentSerde
}

// An object representing the path to match in the request.
type HttpPathMatch struct {

	// The exact path to match on.
	Exact *string

	// The regex used to match the path.
	Regex *string

	noSmithyDocumentSerde
}

// An object that represents the query parameter in the request.
type HttpQueryParameter struct {

	// A name for the query parameter that will be matched on.
	//
	// This member is required.
	Name *string

	// The query parameter to match on.
	Match *QueryParameterMatch

	noSmithyDocumentSerde
}

// An object that represents a retry policy. Specify at least one value for at
// least one of the types of RetryEvents , a value for maxRetries , and a value for
// perRetryTimeout . Both server-error and gateway-error under httpRetryEvents
// include the Envoy reset policy. For more information on the reset policy, see
// the [Envoy documentation].
//
// [Envoy documentation]: https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on
type HttpRetryPolicy struct {

	// The maximum number of retry attempts.
	//
	// This member is required.
	MaxRetries *int64

	// The timeout for each retry attempt.
	//
	// This member is required.
	PerRetryTimeout *Duration

	// Specify at least one of the following values.
	//
	//   - server-error – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507,
	//   508, 510, and 511
	//
	//   - gateway-error – HTTP status codes 502, 503, and 504
	//
	//   - client-error – HTTP status code 409
	//
	//   - stream-error – Retry on refused stream
	HttpRetryEvents []string

	// Specify a valid value. The event occurs before any processing of a request has
	// started and is encountered when the upstream is temporarily or permanently
	// unavailable.
	TcpRetryEvents []TcpRetryPolicyEvent

	noSmithyDocumentSerde
}

// An object that represents an HTTP or HTTP/2 route type.
type HttpRoute struct {

	// An object that represents the action to take if a match is determined.
	//
	// This member is required.
	Action *HttpRouteAction

	// An object that represents the criteria for determining a request match.
	//
	// This member is required.
	Match *HttpRouteMatch

	// An object that represents a retry policy.
	RetryPolicy *HttpRetryPolicy

	// An object that represents types of timeouts.
	Timeout *HttpTimeout

	noSmithyDocumentSerde
}

// An object that represents the action to take if a match is determined.
type HttpRouteAction struct {

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// This member is required.
	WeightedTargets []WeightedTarget

	noSmithyDocumentSerde
}

// An object that represents the HTTP header in the request.
type HttpRouteHeader struct {

	// A name for the HTTP header in the client request that will be matched on.
	//
	// This member is required.
	Name *string

	// Specify True to match anything except the match criteria. The default value is
	// False .
	Invert *bool

	// The HeaderMatchMethod object.
	Match HeaderMatchMethod

	noSmithyDocumentSerde
}

// An object that represents the requirements for a route to match HTTP requests
// for a virtual router.
type HttpRouteMatch struct {

	// The client request headers to match on.
	Headers []HttpRouteHeader

	// The client request method to match on. Specify only one.
	Method HttpMethod

	// The client request path to match on.
	Path *HttpPathMatch

	// The port number to match on.
	Port *int32

	// Specifies the path to match requests with. This parameter must always start
	// with / , which by itself matches all requests to the virtual service name. You
	// can also match for path-based routing of requests. For example, if your virtual
	// service name is my-service.local and you want the route to match requests to
	// my-service.local/metrics , your prefix should be /metrics .
	Prefix *string

	// The client request query parameters to match on.
	QueryParameters []HttpQueryParameter

	// The client request scheme to match on. Specify only one. Applicable only for
	// HTTP2 routes.
	Scheme HttpScheme

	noSmithyDocumentSerde
}

// An object that represents types of timeouts.
type HttpTimeout struct {

	// An object that represents an idle timeout. An idle timeout bounds the amount of
	// time that a connection may be idle. The default value is none.
	Idle *Duration

	// An object that represents a per request timeout. The default value is 15
	// seconds. If you set a higher timeout, then make sure that the higher value is
	// set for each App Mesh resource in a conversation. For example, if a virtual node
	// backend uses a virtual router provider to route to another virtual node, then
	// the timeout should be greater than 15 seconds for the source and destination
	// virtual node and the route.
	PerRequest *Duration

	noSmithyDocumentSerde
}

// An object that represents the key value pairs for the JSON.
type JsonFormatRef struct {

	// The specified key for the JSON.
	//
	// This member is required.
	Key *string

	// The specified value for the JSON.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that represents a listener for a virtual node.
type Listener struct {

	// The port mapping information for the listener.
	//
	// This member is required.
	PortMapping *PortMapping

	// The connection pool information for the listener.
	ConnectionPool VirtualNodeConnectionPool

	// The health check information for the listener.
	HealthCheck *HealthCheckPolicy

	// The outlier detection information for the listener.
	OutlierDetection *OutlierDetection

	// An object that represents timeouts for different protocols.
	Timeout ListenerTimeout

	// A reference to an object that represents the Transport Layer Security (TLS)
	// properties for a listener.
	Tls *ListenerTls

	noSmithyDocumentSerde
}

// An object that represents timeouts for different protocols.
//
// The following types satisfy this interface:
//
//	ListenerTimeoutMemberGrpc
//	ListenerTimeoutMemberHttp
//	ListenerTimeoutMemberHttp2
//	ListenerTimeoutMemberTcp
type ListenerTimeout interface {
	isListenerTimeout()
}

// An object that represents types of timeouts.
type ListenerTimeoutMemberGrpc struct {
	Value GrpcTimeout

	noSmithyDocumentSerde
}

func (*ListenerTimeoutMemberGrpc) isListenerTimeout() {}

// An object that represents types of timeouts.
type ListenerTimeoutMemberHttp struct {
	Value HttpTimeout

	noSmithyDocumentSerde
}

func (*ListenerTimeoutMemberHttp) isListenerTimeout() {}

// An object that represents types of timeouts.
type ListenerTimeoutMemberHttp2 struct {
	Value HttpTimeout

	noSmithyDocumentSerde
}

func (*ListenerTimeoutMemberHttp2) isListenerTimeout() {}

// An object that represents types of timeouts.
type ListenerTimeoutMemberTcp struct {
	Value TcpTimeout

	noSmithyDocumentSerde
}

func (*ListenerTimeoutMemberTcp) isListenerTimeout() {}

// An object that represents the Transport Layer Security (TLS) properties for a
// listener.
type ListenerTls struct {

	// A reference to an object that represents a listener's Transport Layer Security
	// (TLS) certificate.
	//
	// This member is required.
	Certificate ListenerTlsCertificate

	// Specify one of the following modes.
	//
	//   - STRICT – Listener only accepts connections with TLS enabled.
	//
	//   - PERMISSIVE – Listener accepts connections with or without TLS enabled.
	//
	//   - DISABLED – Listener only accepts connections without TLS.
	//
	// This member is required.
	Mode ListenerTlsMode

	// A reference to an object that represents a listener's Transport Layer Security
	// (TLS) validation context.
	Validation *ListenerTlsValidationContext

	noSmithyDocumentSerde
}

// An object that represents an Certificate Manager certificate.
type ListenerTlsAcmCertificate struct {

	// The Amazon Resource Name (ARN) for the certificate. The certificate must meet
	// specific requirements and you must have proxy authorization enabled. For more
	// information, see [Transport Layer Security (TLS)].
	//
	// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites
	//
	// This member is required.
	CertificateArn *string

	noSmithyDocumentSerde
}

// An object that represents a listener's Transport Layer Security (TLS)
// certificate.
//
// The following types satisfy this interface:
//
//	ListenerTlsCertificateMemberAcm
//	ListenerTlsCertificateMemberFile
//	ListenerTlsCertificateMemberSds
type ListenerTlsCertificate interface {
	isListenerTlsCertificate()
}

// A reference to an object that represents an Certificate Manager certificate.
type ListenerTlsCertificateMemberAcm struct {
	Value ListenerTlsAcmCertificate

	noSmithyDocumentSerde
}

func (*ListenerTlsCertificateMemberAcm) isListenerTlsCertificate() {}

// A reference to an object that represents a local file certificate.
type ListenerTlsCertificateMemberFile struct {
	Value ListenerTlsFileCertificate

	noSmithyDocumentSerde
}

func (*ListenerTlsCertificateMemberFile) isListenerTlsCertificate() {}

// A reference to an object that represents a listener's Secret Discovery Service
// certificate.
type ListenerTlsCertificateMemberSds struct {
	Value ListenerTlsSdsCertificate

	noSmithyDocumentSerde
}

func (*ListenerTlsCertificateMemberSds) isListenerTlsCertificate() {}

// An object that represents a local file certificate. The certificate must meet
// specific requirements and you must have proxy authorization enabled. For more
// information, see [Transport Layer Security (TLS)].
//
// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites
type ListenerTlsFileCertificate struct {

	// The certificate chain for the certificate.
	//
	// This member is required.
	CertificateChain *string

	// The private key for a certificate stored on the file system of the virtual node
	// that the proxy is running on.
	//
	// This member is required.
	PrivateKey *string

	noSmithyDocumentSerde
}

// An object that represents the listener's Secret Discovery Service certificate.
// The proxy must be configured with a local SDS provider via a Unix Domain Socket.
// See App Mesh [TLS documentation]for more info.
//
// [TLS documentation]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type ListenerTlsSdsCertificate struct {

	// A reference to an object that represents the name of the secret requested from
	// the Secret Discovery Service provider representing Transport Layer Security
	// (TLS) materials like a certificate or certificate chain.
	//
	// This member is required.
	SecretName *string

	noSmithyDocumentSerde
}

// An object that represents a listener's Transport Layer Security (TLS)
// validation context.
type ListenerTlsValidationContext struct {

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// This member is required.
	Trust ListenerTlsValidationContextTrust

	// A reference to an object that represents the SANs for a listener's Transport
	// Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames

	noSmithyDocumentSerde
}

// An object that represents a listener's Transport Layer Security (TLS)
// validation context trust.
//
// The following types satisfy this interface:
//
//	ListenerTlsValidationContextTrustMemberFile
//	ListenerTlsValidationContextTrustMemberSds
type ListenerTlsValidationContextTrust interface {
	isListenerTlsValidationContextTrust()
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type ListenerTlsValidationContextTrustMemberFile struct {
	Value TlsValidationContextFileTrust

	noSmithyDocumentSerde
}

func (*ListenerTlsValidationContextTrustMemberFile) isListenerTlsValidationContextTrust() {}

// A reference to an object that represents a listener's Transport Layer Security
// (TLS) Secret Discovery Service validation context trust.
type ListenerTlsValidationContextTrustMemberSds struct {
	Value TlsValidationContextSdsTrust

	noSmithyDocumentSerde
}

func (*ListenerTlsValidationContextTrustMemberSds) isListenerTlsValidationContextTrust() {}

// An object that represents the logging information for a virtual node.
type Logging struct {

	// The access log configuration for a virtual node.
	AccessLog AccessLog

	noSmithyDocumentSerde
}

// An object that represents the format for the logs.
//
// The following types satisfy this interface:
//
//	LoggingFormatMemberJson
//	LoggingFormatMemberText
type LoggingFormat interface {
	isLoggingFormat()
}

type LoggingFormatMemberJson struct {
	Value []JsonFormatRef

	noSmithyDocumentSerde
}

func (*LoggingFormatMemberJson) isLoggingFormat() {}

type LoggingFormatMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*LoggingFormatMemberText) isLoggingFormat() {}

// An object that represents the range of values to match on. The first character
// of the range is included in the range, though the last character is not. For
// example, if the range specified were 1-100, only values 1-99 would be matched.
type MatchRange struct {

	// The end of the range.
	//
	// This member is required.
	End *int64

	// The start of the range.
	//
	// This member is required.
	Start *int64

	noSmithyDocumentSerde
}

// An object that represents a service mesh returned by a describe operation.
type MeshData struct {

	// The name of the service mesh.
	//
	// This member is required.
	MeshName *string

	// The associated metadata for the service mesh.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The associated specification for the service mesh.
	//
	// This member is required.
	Spec *MeshSpec

	// The status of the service mesh.
	//
	// This member is required.
	Status *MeshStatus

	noSmithyDocumentSerde
}

// An object that represents a service mesh returned by a list operation.
type MeshRef struct {

	// The full Amazon Resource Name (ARN) of the service mesh.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	noSmithyDocumentSerde
}

// An object that represents the service discovery information for a service mesh.
type MeshServiceDiscovery struct {

	// The IP version to use to control traffic within the mesh.
	IpPreference IpPreference

	noSmithyDocumentSerde
}

// An object that represents the specification of a service mesh.
type MeshSpec struct {

	// The egress filter rules for the service mesh.
	EgressFilter *EgressFilter

	// An object that represents the service discovery information for a service mesh.
	ServiceDiscovery *MeshServiceDiscovery

	noSmithyDocumentSerde
}

// An object that represents the status of a service mesh.
type MeshStatus struct {

	// The current mesh status.
	Status MeshStatusCode

	noSmithyDocumentSerde
}

// An object that represents the outlier detection for a virtual node's listener.
type OutlierDetection struct {

	// The base amount of time for which a host is ejected.
	//
	// This member is required.
	BaseEjectionDuration *Duration

	// The time interval between ejection sweep analysis.
	//
	// This member is required.
	Interval *Duration

	// Maximum percentage of hosts in load balancing pool for upstream service that
	// can be ejected. Will eject at least one host regardless of the value.
	//
	// This member is required.
	MaxEjectionPercent *int32

	// Number of consecutive 5xx errors required for ejection.
	//
	// This member is required.
	MaxServerErrors *int64

	noSmithyDocumentSerde
}

// An object that represents a port mapping.
type PortMapping struct {

	// The port used for the port mapping.
	//
	// This member is required.
	Port *int32

	// The protocol used for the port mapping. Specify one protocol.
	//
	// This member is required.
	Protocol PortProtocol

	noSmithyDocumentSerde
}

// An object representing the query parameter to match.
type QueryParameterMatch struct {

	// The exact query parameter to match on.
	Exact *string

	noSmithyDocumentSerde
}

// An object that represents metadata for a resource.
type ResourceMetadata struct {

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The unique identifier for the resource.
	//
	// This member is required.
	Uid *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	noSmithyDocumentSerde
}

// An object that represents a route returned by a describe operation.
type RouteData struct {

	// The name of the service mesh that the route resides in.
	//
	// This member is required.
	MeshName *string

	// The associated metadata for the route.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The name of the route.
	//
	// This member is required.
	RouteName *string

	// The specifications of the route.
	//
	// This member is required.
	Spec *RouteSpec

	// The status of the route.
	//
	// This member is required.
	Status *RouteStatus

	// The virtual router that the route is associated with.
	//
	// This member is required.
	VirtualRouterName *string

	noSmithyDocumentSerde
}

// An object that represents a route returned by a list operation.
type RouteRef struct {

	// The full Amazon Resource Name (ARN) for the route.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the route resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The name of the route.
	//
	// This member is required.
	RouteName *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The virtual router that the route is associated with.
	//
	// This member is required.
	VirtualRouterName *string

	noSmithyDocumentSerde
}

// An object that represents a route specification. Specify one route type.
type RouteSpec struct {

	// An object that represents the specification of a gRPC route.
	GrpcRoute *GrpcRoute

	// An object that represents the specification of an HTTP/2 route.
	Http2Route *HttpRoute

	// An object that represents the specification of an HTTP route.
	HttpRoute *HttpRoute

	// The priority for the route. Routes are matched based on the specified value,
	// where 0 is the highest priority.
	Priority *int32

	// An object that represents the specification of a TCP route.
	TcpRoute *TcpRoute

	noSmithyDocumentSerde
}

// An object that represents the current status of a route.
type RouteStatus struct {

	// The current status for the route.
	//
	// This member is required.
	Status RouteStatusCode

	noSmithyDocumentSerde
}

// An object that represents the service discovery information for a virtual node.
//
// The following types satisfy this interface:
//
//	ServiceDiscoveryMemberAwsCloudMap
//	ServiceDiscoveryMemberDns
type ServiceDiscovery interface {
	isServiceDiscovery()
}

// Specifies any Cloud Map information for the virtual node.
type ServiceDiscoveryMemberAwsCloudMap struct {
	Value AwsCloudMapServiceDiscovery

	noSmithyDocumentSerde
}

func (*ServiceDiscoveryMemberAwsCloudMap) isServiceDiscovery() {}

// Specifies the DNS information for the virtual node.
type ServiceDiscoveryMemberDns struct {
	Value DnsServiceDiscovery

	noSmithyDocumentSerde
}

func (*ServiceDiscoveryMemberDns) isServiceDiscovery() {}

// An object that represents the methods by which a subject alternative name on a
// peer Transport Layer Security (TLS) certificate can be matched.
type SubjectAlternativeNameMatchers struct {

	// The values sent must match the specified values exactly.
	//
	// This member is required.
	Exact []string

	noSmithyDocumentSerde
}

// An object that represents the subject alternative names secured by the
// certificate.
type SubjectAlternativeNames struct {

	// An object that represents the criteria for determining a SANs match.
	//
	// This member is required.
	Match *SubjectAlternativeNameMatchers

	noSmithyDocumentSerde
}

// Optional metadata that you apply to a resource to assist with categorization
// and organization. Each tag consists of a key and an optional value, both of
// which you define. Tag keys can have a maximum character length of 128
// characters, and tag values can have a maximum length of 256 characters.
type TagRef struct {

	// One part of a key-value pair that make up a tag. A key is a general label that
	// acts like a category for more specific tag values.
	//
	// This member is required.
	Key *string

	// The optional part of a key-value pair that make up a tag. A value acts as a
	// descriptor within a tag category (key).
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that represents a TCP route type.
type TcpRoute struct {

	// The action to take if a match is determined.
	//
	// This member is required.
	Action *TcpRouteAction

	// An object that represents the criteria for determining a request match.
	Match *TcpRouteMatch

	// An object that represents types of timeouts.
	Timeout *TcpTimeout

	noSmithyDocumentSerde
}

// An object that represents the action to take if a match is determined.
type TcpRouteAction struct {

	// An object that represents the targets that traffic is routed to when a request
	// matches the route.
	//
	// This member is required.
	WeightedTargets []WeightedTarget

	noSmithyDocumentSerde
}

// An object representing the TCP route to match.
type TcpRouteMatch struct {

	// The port number to match on.
	Port *int32

	noSmithyDocumentSerde
}

// An object that represents types of timeouts.
type TcpTimeout struct {

	// An object that represents an idle timeout. An idle timeout bounds the amount of
	// time that a connection may be idle. The default value is none.
	Idle *Duration

	noSmithyDocumentSerde
}

// An object that represents how the proxy will validate its peer during Transport
// Layer Security (TLS) negotiation.
type TlsValidationContext struct {

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// This member is required.
	Trust TlsValidationContextTrust

	// A reference to an object that represents the SANs for a Transport Layer
	// Security (TLS) validation context. If you don't specify SANs on the terminating
	// mesh endpoint, the Envoy proxy for that node doesn't verify the SAN on a peer
	// client certificate. If you don't specify SANs on the originating mesh endpoint,
	// the SAN on the certificate provided by the terminating endpoint must match the
	// mesh endpoint service discovery configuration. Since SPIRE vended certificates
	// have a SPIFFE ID as a name, you must set the SAN since the name doesn't match
	// the service discovery name.
	SubjectAlternativeNames *SubjectAlternativeNames

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for an Certificate Manager certificate.
type TlsValidationContextAcmTrust struct {

	// One or more ACM Amazon Resource Name (ARN)s.
	//
	// This member is required.
	CertificateAuthorityArns []string

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type TlsValidationContextFileTrust struct {

	// The certificate trust chain for a certificate stored on the file system of the
	// virtual node that the proxy is running on.
	//
	// This member is required.
	CertificateChain *string

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) Secret Discovery
// Service validation context trust. The proxy must be configured with a local SDS
// provider via a Unix Domain Socket. See App Mesh [TLS documentation]for more info.
//
// [TLS documentation]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type TlsValidationContextSdsTrust struct {

	// A reference to an object that represents the name of the secret for a Transport
	// Layer Security (TLS) Secret Discovery Service validation context trust.
	//
	// This member is required.
	SecretName *string

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust.
//
// The following types satisfy this interface:
//
//	TlsValidationContextTrustMemberAcm
//	TlsValidationContextTrustMemberFile
//	TlsValidationContextTrustMemberSds
type TlsValidationContextTrust interface {
	isTlsValidationContextTrust()
}

// A reference to an object that represents a Transport Layer Security (TLS)
// validation context trust for an Certificate Manager certificate.
type TlsValidationContextTrustMemberAcm struct {
	Value TlsValidationContextAcmTrust

	noSmithyDocumentSerde
}

func (*TlsValidationContextTrustMemberAcm) isTlsValidationContextTrust() {}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type TlsValidationContextTrustMemberFile struct {
	Value TlsValidationContextFileTrust

	noSmithyDocumentSerde
}

func (*TlsValidationContextTrustMemberFile) isTlsValidationContextTrust() {}

// A reference to an object that represents a Transport Layer Security (TLS)
// Secret Discovery Service validation context trust.
type TlsValidationContextTrustMemberSds struct {
	Value TlsValidationContextSdsTrust

	noSmithyDocumentSerde
}

func (*TlsValidationContextTrustMemberSds) isTlsValidationContextTrust() {}

// The access log configuration for a virtual gateway.
//
// The following types satisfy this interface:
//
//	VirtualGatewayAccessLogMemberFile
type VirtualGatewayAccessLog interface {
	isVirtualGatewayAccessLog()
}

// The file object to send virtual gateway access logs to.
type VirtualGatewayAccessLogMemberFile struct {
	Value VirtualGatewayFileAccessLog

	noSmithyDocumentSerde
}

func (*VirtualGatewayAccessLogMemberFile) isVirtualGatewayAccessLog() {}

// An object that represents the default properties for a backend.
type VirtualGatewayBackendDefaults struct {

	// A reference to an object that represents a client policy.
	ClientPolicy *VirtualGatewayClientPolicy

	noSmithyDocumentSerde
}

// An object that represents a client policy.
type VirtualGatewayClientPolicy struct {

	// A reference to an object that represents a Transport Layer Security (TLS)
	// client policy.
	Tls *VirtualGatewayClientPolicyTls

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) client policy.
type VirtualGatewayClientPolicyTls struct {

	// A reference to an object that represents a Transport Layer Security (TLS)
	// validation context.
	//
	// This member is required.
	Validation *VirtualGatewayTlsValidationContext

	// A reference to an object that represents a virtual gateway's client's Transport
	// Layer Security (TLS) certificate.
	Certificate VirtualGatewayClientTlsCertificate

	// Whether the policy is enforced. The default is True , if a value isn't specified.
	Enforce *bool

	// One or more ports that the policy is enforced for.
	Ports []int32

	noSmithyDocumentSerde
}

// An object that represents the virtual gateway's client's Transport Layer
// Security (TLS) certificate.
//
// The following types satisfy this interface:
//
//	VirtualGatewayClientTlsCertificateMemberFile
//	VirtualGatewayClientTlsCertificateMemberSds
type VirtualGatewayClientTlsCertificate interface {
	isVirtualGatewayClientTlsCertificate()
}

// An object that represents a local file certificate. The certificate must meet
// specific requirements and you must have proxy authorization enabled. For more
// information, see [Transport Layer Security (TLS)].
//
// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type VirtualGatewayClientTlsCertificateMemberFile struct {
	Value VirtualGatewayListenerTlsFileCertificate

	noSmithyDocumentSerde
}

func (*VirtualGatewayClientTlsCertificateMemberFile) isVirtualGatewayClientTlsCertificate() {}

// A reference to an object that represents a virtual gateway's client's Secret
// Discovery Service certificate.
type VirtualGatewayClientTlsCertificateMemberSds struct {
	Value VirtualGatewayListenerTlsSdsCertificate

	noSmithyDocumentSerde
}

func (*VirtualGatewayClientTlsCertificateMemberSds) isVirtualGatewayClientTlsCertificate() {}

// An object that represents the type of virtual gateway connection pool.
//
// Only one protocol is used at a time and should be the same protocol as the one
// chosen under port mapping.
//
// If not present the default value for maxPendingRequests is 2147483647 .
//
// The following types satisfy this interface:
//
//	VirtualGatewayConnectionPoolMemberGrpc
//	VirtualGatewayConnectionPoolMemberHttp
//	VirtualGatewayConnectionPoolMemberHttp2
type VirtualGatewayConnectionPool interface {
	isVirtualGatewayConnectionPool()
}

// An object that represents a type of connection pool.
type VirtualGatewayConnectionPoolMemberGrpc struct {
	Value VirtualGatewayGrpcConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualGatewayConnectionPoolMemberGrpc) isVirtualGatewayConnectionPool() {}

// An object that represents a type of connection pool.
type VirtualGatewayConnectionPoolMemberHttp struct {
	Value VirtualGatewayHttpConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualGatewayConnectionPoolMemberHttp) isVirtualGatewayConnectionPool() {}

// An object that represents a type of connection pool.
type VirtualGatewayConnectionPoolMemberHttp2 struct {
	Value VirtualGatewayHttp2ConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualGatewayConnectionPoolMemberHttp2) isVirtualGatewayConnectionPool() {}

// An object that represents a virtual gateway returned by a describe operation.
type VirtualGatewayData struct {

	// The name of the service mesh that the virtual gateway resides in.
	//
	// This member is required.
	MeshName *string

	// An object that represents metadata for a resource.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The specifications of the virtual gateway.
	//
	// This member is required.
	Spec *VirtualGatewaySpec

	// The current status of the virtual gateway.
	//
	// This member is required.
	Status *VirtualGatewayStatus

	// The name of the virtual gateway.
	//
	// This member is required.
	VirtualGatewayName *string

	noSmithyDocumentSerde
}

// An object that represents an access log file.
type VirtualGatewayFileAccessLog struct {

	// The file path to write access logs to. You can use /dev/stdout to send access
	// logs to standard out and configure your Envoy container to use a log driver,
	// such as awslogs , to export the access logs to a log storage service such as
	// Amazon CloudWatch Logs. You can also specify a path in the Envoy container's
	// file system to write the files to disk.
	//
	// This member is required.
	Path *string

	// The specified format for the virtual gateway access logs. It can be either
	// json_format or text_format .
	Format LoggingFormat

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualGatewayGrpcConnectionPool struct {

	// Maximum number of inflight requests Envoy can concurrently support across hosts
	// in upstream cluster.
	//
	// This member is required.
	MaxRequests *int32

	noSmithyDocumentSerde
}

// An object that represents the health check policy for a virtual gateway's
// listener.
type VirtualGatewayHealthCheckPolicy struct {

	// The number of consecutive successful health checks that must occur before
	// declaring the listener healthy.
	//
	// This member is required.
	HealthyThreshold *int32

	// The time period in milliseconds between each health check execution.
	//
	// This member is required.
	IntervalMillis *int64

	// The protocol for the health check request. If you specify grpc , then your
	// service must conform to the [GRPC Health Checking Protocol].
	//
	// [GRPC Health Checking Protocol]: https://github.com/grpc/grpc/blob/master/doc/health-checking.md
	//
	// This member is required.
	Protocol VirtualGatewayPortProtocol

	// The amount of time to wait when receiving a response from the health check, in
	// milliseconds.
	//
	// This member is required.
	TimeoutMillis *int64

	// The number of consecutive failed health checks that must occur before declaring
	// a virtual gateway unhealthy.
	//
	// This member is required.
	UnhealthyThreshold *int32

	// The destination path for the health check request. This value is only used if
	// the specified protocol is HTTP or HTTP/2. For any other protocol, this value is
	// ignored.
	Path *string

	// The destination port for the health check request. This port must match the
	// port defined in the PortMappingfor the listener.
	Port *int32

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualGatewayHttp2ConnectionPool struct {

	// Maximum number of inflight requests Envoy can concurrently support across hosts
	// in upstream cluster.
	//
	// This member is required.
	MaxRequests *int32

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualGatewayHttpConnectionPool struct {

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// This member is required.
	MaxConnections *int32

	// Number of overflowing requests after max_connections Envoy will queue to
	// upstream cluster.
	MaxPendingRequests *int32

	noSmithyDocumentSerde
}

// An object that represents a listener for a virtual gateway.
type VirtualGatewayListener struct {

	// The port mapping information for the listener.
	//
	// This member is required.
	PortMapping *VirtualGatewayPortMapping

	// The connection pool information for the virtual gateway listener.
	ConnectionPool VirtualGatewayConnectionPool

	// The health check information for the listener.
	HealthCheck *VirtualGatewayHealthCheckPolicy

	// A reference to an object that represents the Transport Layer Security (TLS)
	// properties for the listener.
	Tls *VirtualGatewayListenerTls

	noSmithyDocumentSerde
}

// An object that represents the Transport Layer Security (TLS) properties for a
// listener.
type VirtualGatewayListenerTls struct {

	// An object that represents a Transport Layer Security (TLS) certificate.
	//
	// This member is required.
	Certificate VirtualGatewayListenerTlsCertificate

	// Specify one of the following modes.
	//
	//   - STRICT – Listener only accepts connections with TLS enabled.
	//
	//   - PERMISSIVE – Listener accepts connections with or without TLS enabled.
	//
	//   - DISABLED – Listener only accepts connections without TLS.
	//
	// This member is required.
	Mode VirtualGatewayListenerTlsMode

	// A reference to an object that represents a virtual gateway's listener's
	// Transport Layer Security (TLS) validation context.
	Validation *VirtualGatewayListenerTlsValidationContext

	noSmithyDocumentSerde
}

// An object that represents an Certificate Manager certificate.
type VirtualGatewayListenerTlsAcmCertificate struct {

	// The Amazon Resource Name (ARN) for the certificate. The certificate must meet
	// specific requirements and you must have proxy authorization enabled. For more
	// information, see [Transport Layer Security (TLS)].
	//
	// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites
	//
	// This member is required.
	CertificateArn *string

	noSmithyDocumentSerde
}

// An object that represents a listener's Transport Layer Security (TLS)
// certificate.
//
// The following types satisfy this interface:
//
//	VirtualGatewayListenerTlsCertificateMemberAcm
//	VirtualGatewayListenerTlsCertificateMemberFile
//	VirtualGatewayListenerTlsCertificateMemberSds
type VirtualGatewayListenerTlsCertificate interface {
	isVirtualGatewayListenerTlsCertificate()
}

// A reference to an object that represents an Certificate Manager certificate.
type VirtualGatewayListenerTlsCertificateMemberAcm struct {
	Value VirtualGatewayListenerTlsAcmCertificate

	noSmithyDocumentSerde
}

func (*VirtualGatewayListenerTlsCertificateMemberAcm) isVirtualGatewayListenerTlsCertificate() {}

// A reference to an object that represents a local file certificate.
type VirtualGatewayListenerTlsCertificateMemberFile struct {
	Value VirtualGatewayListenerTlsFileCertificate

	noSmithyDocumentSerde
}

func (*VirtualGatewayListenerTlsCertificateMemberFile) isVirtualGatewayListenerTlsCertificate() {}

// A reference to an object that represents a virtual gateway's listener's Secret
// Discovery Service certificate.
type VirtualGatewayListenerTlsCertificateMemberSds struct {
	Value VirtualGatewayListenerTlsSdsCertificate

	noSmithyDocumentSerde
}

func (*VirtualGatewayListenerTlsCertificateMemberSds) isVirtualGatewayListenerTlsCertificate() {}

// An object that represents a local file certificate. The certificate must meet
// specific requirements and you must have proxy authorization enabled. For more
// information, see [Transport Layer Security (TLS)].
//
// [Transport Layer Security (TLS)]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html#virtual-node-tls-prerequisites
type VirtualGatewayListenerTlsFileCertificate struct {

	// The certificate chain for the certificate.
	//
	// This member is required.
	CertificateChain *string

	// The private key for a certificate stored on the file system of the mesh
	// endpoint that the proxy is running on.
	//
	// This member is required.
	PrivateKey *string

	noSmithyDocumentSerde
}

// An object that represents the virtual gateway's listener's Secret Discovery
// Service certificate.The proxy must be configured with a local SDS provider via a
// Unix Domain Socket. See App Mesh[TLS documentation] for more info.
//
// [TLS documentation]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type VirtualGatewayListenerTlsSdsCertificate struct {

	// A reference to an object that represents the name of the secret secret
	// requested from the Secret Discovery Service provider representing Transport
	// Layer Security (TLS) materials like a certificate or certificate chain.
	//
	// This member is required.
	SecretName *string

	noSmithyDocumentSerde
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) validation context.
type VirtualGatewayListenerTlsValidationContext struct {

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// This member is required.
	Trust VirtualGatewayListenerTlsValidationContextTrust

	// A reference to an object that represents the SANs for a virtual gateway
	// listener's Transport Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames

	noSmithyDocumentSerde
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) validation context trust.
//
// The following types satisfy this interface:
//
//	VirtualGatewayListenerTlsValidationContextTrustMemberFile
//	VirtualGatewayListenerTlsValidationContextTrustMemberSds
type VirtualGatewayListenerTlsValidationContextTrust interface {
	isVirtualGatewayListenerTlsValidationContextTrust()
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type VirtualGatewayListenerTlsValidationContextTrustMemberFile struct {
	Value VirtualGatewayTlsValidationContextFileTrust

	noSmithyDocumentSerde
}

func (*VirtualGatewayListenerTlsValidationContextTrustMemberFile) isVirtualGatewayListenerTlsValidationContextTrust() {
}

// A reference to an object that represents a virtual gateway's listener's
// Transport Layer Security (TLS) Secret Discovery Service validation context
// trust.
type VirtualGatewayListenerTlsValidationContextTrustMemberSds struct {
	Value VirtualGatewayTlsValidationContextSdsTrust

	noSmithyDocumentSerde
}

func (*VirtualGatewayListenerTlsValidationContextTrustMemberSds) isVirtualGatewayListenerTlsValidationContextTrust() {
}

// An object that represents logging information.
type VirtualGatewayLogging struct {

	// The access log configuration.
	AccessLog VirtualGatewayAccessLog

	noSmithyDocumentSerde
}

// An object that represents a port mapping.
type VirtualGatewayPortMapping struct {

	// The port used for the port mapping. Specify one protocol.
	//
	// This member is required.
	Port *int32

	// The protocol used for the port mapping.
	//
	// This member is required.
	Protocol VirtualGatewayPortProtocol

	noSmithyDocumentSerde
}

// An object that represents a virtual gateway returned by a list operation.
type VirtualGatewayRef struct {

	// The full Amazon Resource Name (ARN) for the resource.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the resource resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The name of the resource.
	//
	// This member is required.
	VirtualGatewayName *string

	noSmithyDocumentSerde
}

// An object that represents the specification of a service mesh resource.
type VirtualGatewaySpec struct {

	// The listeners that the mesh endpoint is expected to receive inbound traffic
	// from. You can specify one listener.
	//
	// This member is required.
	Listeners []VirtualGatewayListener

	// A reference to an object that represents the defaults for backends.
	BackendDefaults *VirtualGatewayBackendDefaults

	// An object that represents logging information.
	Logging *VirtualGatewayLogging

	noSmithyDocumentSerde
}

// An object that represents the status of the mesh resource.
type VirtualGatewayStatus struct {

	// The current status.
	//
	// This member is required.
	Status VirtualGatewayStatusCode

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context.
type VirtualGatewayTlsValidationContext struct {

	// A reference to where to retrieve the trust chain when validating a peer’s
	// Transport Layer Security (TLS) certificate.
	//
	// This member is required.
	Trust VirtualGatewayTlsValidationContextTrust

	// A reference to an object that represents the SANs for a virtual gateway's
	// listener's Transport Layer Security (TLS) validation context.
	SubjectAlternativeNames *SubjectAlternativeNames

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for an Certificate Manager certificate.
type VirtualGatewayTlsValidationContextAcmTrust struct {

	// One or more ACM Amazon Resource Name (ARN)s.
	//
	// This member is required.
	CertificateAuthorityArns []string

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type VirtualGatewayTlsValidationContextFileTrust struct {

	// The certificate trust chain for a certificate stored on the file system of the
	// virtual node that the proxy is running on.
	//
	// This member is required.
	CertificateChain *string

	noSmithyDocumentSerde
}

// An object that represents a virtual gateway's listener's Transport Layer
// Security (TLS) Secret Discovery Service validation context trust. The proxy must
// be configured with a local SDS provider via a Unix Domain Socket. See App Mesh [TLS documentation]
// for more info.
//
// [TLS documentation]: https://docs.aws.amazon.com/app-mesh/latest/userguide/tls.html
type VirtualGatewayTlsValidationContextSdsTrust struct {

	// A reference to an object that represents the name of the secret for a virtual
	// gateway's Transport Layer Security (TLS) Secret Discovery Service validation
	// context trust.
	//
	// This member is required.
	SecretName *string

	noSmithyDocumentSerde
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust.
//
// The following types satisfy this interface:
//
//	VirtualGatewayTlsValidationContextTrustMemberAcm
//	VirtualGatewayTlsValidationContextTrustMemberFile
//	VirtualGatewayTlsValidationContextTrustMemberSds
type VirtualGatewayTlsValidationContextTrust interface {
	isVirtualGatewayTlsValidationContextTrust()
}

// A reference to an object that represents a Transport Layer Security (TLS)
// validation context trust for an Certificate Manager certificate.
type VirtualGatewayTlsValidationContextTrustMemberAcm struct {
	Value VirtualGatewayTlsValidationContextAcmTrust

	noSmithyDocumentSerde
}

func (*VirtualGatewayTlsValidationContextTrustMemberAcm) isVirtualGatewayTlsValidationContextTrust() {
}

// An object that represents a Transport Layer Security (TLS) validation context
// trust for a local file.
type VirtualGatewayTlsValidationContextTrustMemberFile struct {
	Value VirtualGatewayTlsValidationContextFileTrust

	noSmithyDocumentSerde
}

func (*VirtualGatewayTlsValidationContextTrustMemberFile) isVirtualGatewayTlsValidationContextTrust() {
}

// A reference to an object that represents a virtual gateway's Transport Layer
// Security (TLS) Secret Discovery Service validation context trust.
type VirtualGatewayTlsValidationContextTrustMemberSds struct {
	Value VirtualGatewayTlsValidationContextSdsTrust

	noSmithyDocumentSerde
}

func (*VirtualGatewayTlsValidationContextTrustMemberSds) isVirtualGatewayTlsValidationContextTrust() {
}

// An object that represents the type of virtual node connection pool.
//
// Only one protocol is used at a time and should be the same protocol as the one
// chosen under port mapping.
//
// If not present the default value for maxPendingRequests is 2147483647 .
//
// The following types satisfy this interface:
//
//	VirtualNodeConnectionPoolMemberGrpc
//	VirtualNodeConnectionPoolMemberHttp
//	VirtualNodeConnectionPoolMemberHttp2
//	VirtualNodeConnectionPoolMemberTcp
type VirtualNodeConnectionPool interface {
	isVirtualNodeConnectionPool()
}

// An object that represents a type of connection pool.
type VirtualNodeConnectionPoolMemberGrpc struct {
	Value VirtualNodeGrpcConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualNodeConnectionPoolMemberGrpc) isVirtualNodeConnectionPool() {}

// An object that represents a type of connection pool.
type VirtualNodeConnectionPoolMemberHttp struct {
	Value VirtualNodeHttpConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualNodeConnectionPoolMemberHttp) isVirtualNodeConnectionPool() {}

// An object that represents a type of connection pool.
type VirtualNodeConnectionPoolMemberHttp2 struct {
	Value VirtualNodeHttp2ConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualNodeConnectionPoolMemberHttp2) isVirtualNodeConnectionPool() {}

// An object that represents a type of connection pool.
type VirtualNodeConnectionPoolMemberTcp struct {
	Value VirtualNodeTcpConnectionPool

	noSmithyDocumentSerde
}

func (*VirtualNodeConnectionPoolMemberTcp) isVirtualNodeConnectionPool() {}

// An object that represents a virtual node returned by a describe operation.
type VirtualNodeData struct {

	// The name of the service mesh that the virtual node resides in.
	//
	// This member is required.
	MeshName *string

	// The associated metadata for the virtual node.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The specifications of the virtual node.
	//
	// This member is required.
	Spec *VirtualNodeSpec

	// The current status for the virtual node.
	//
	// This member is required.
	Status *VirtualNodeStatus

	// The name of the virtual node.
	//
	// This member is required.
	VirtualNodeName *string

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualNodeGrpcConnectionPool struct {

	// Maximum number of inflight requests Envoy can concurrently support across hosts
	// in upstream cluster.
	//
	// This member is required.
	MaxRequests *int32

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualNodeHttp2ConnectionPool struct {

	// Maximum number of inflight requests Envoy can concurrently support across hosts
	// in upstream cluster.
	//
	// This member is required.
	MaxRequests *int32

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualNodeHttpConnectionPool struct {

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// This member is required.
	MaxConnections *int32

	// Number of overflowing requests after max_connections Envoy will queue to
	// upstream cluster.
	MaxPendingRequests *int32

	noSmithyDocumentSerde
}

// An object that represents a virtual node returned by a list operation.
type VirtualNodeRef struct {

	// The full Amazon Resource Name (ARN) for the virtual node.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the virtual node resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The name of the virtual node.
	//
	// This member is required.
	VirtualNodeName *string

	noSmithyDocumentSerde
}

// An object that represents a virtual node service provider.
type VirtualNodeServiceProvider struct {

	// The name of the virtual node that is acting as a service provider.
	//
	// This member is required.
	VirtualNodeName *string

	noSmithyDocumentSerde
}

// An object that represents the specification of a virtual node.
type VirtualNodeSpec struct {

	// A reference to an object that represents the defaults for backends.
	BackendDefaults *BackendDefaults

	// The backends that the virtual node is expected to send outbound traffic to.
	Backends []Backend

	// The listener that the virtual node is expected to receive inbound traffic from.
	// You can specify one listener.
	Listeners []Listener

	// The inbound and outbound access logging information for the virtual node.
	Logging *Logging

	// The service discovery information for the virtual node. If your virtual node
	// does not expect ingress traffic, you can omit this parameter. If you specify a
	// listener , then you must specify service discovery information.
	ServiceDiscovery ServiceDiscovery

	noSmithyDocumentSerde
}

// An object that represents the current status of the virtual node.
type VirtualNodeStatus struct {

	// The current status of the virtual node.
	//
	// This member is required.
	Status VirtualNodeStatusCode

	noSmithyDocumentSerde
}

// An object that represents a type of connection pool.
type VirtualNodeTcpConnectionPool struct {

	// Maximum number of outbound TCP connections Envoy can establish concurrently
	// with all hosts in upstream cluster.
	//
	// This member is required.
	MaxConnections *int32

	noSmithyDocumentSerde
}

// An object that represents a virtual router returned by a describe operation.
type VirtualRouterData struct {

	// The name of the service mesh that the virtual router resides in.
	//
	// This member is required.
	MeshName *string

	// The associated metadata for the virtual router.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The specifications of the virtual router.
	//
	// This member is required.
	Spec *VirtualRouterSpec

	// The current status of the virtual router.
	//
	// This member is required.
	Status *VirtualRouterStatus

	// The name of the virtual router.
	//
	// This member is required.
	VirtualRouterName *string

	noSmithyDocumentSerde
}

// An object that represents a virtual router listener.
type VirtualRouterListener struct {

	// An object that represents a port mapping.
	//
	// This member is required.
	PortMapping *PortMapping

	noSmithyDocumentSerde
}

// An object that represents a virtual router returned by a list operation.
type VirtualRouterRef struct {

	// The full Amazon Resource Name (ARN) for the virtual router.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the virtual router resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The name of the virtual router.
	//
	// This member is required.
	VirtualRouterName *string

	noSmithyDocumentSerde
}

// An object that represents a virtual node service provider.
type VirtualRouterServiceProvider struct {

	// The name of the virtual router that is acting as a service provider.
	//
	// This member is required.
	VirtualRouterName *string

	noSmithyDocumentSerde
}

// An object that represents the specification of a virtual router.
type VirtualRouterSpec struct {

	// The listeners that the virtual router is expected to receive inbound traffic
	// from. You can specify one listener.
	Listeners []VirtualRouterListener

	noSmithyDocumentSerde
}

// An object that represents the status of a virtual router.
type VirtualRouterStatus struct {

	// The current status of the virtual router.
	//
	// This member is required.
	Status VirtualRouterStatusCode

	noSmithyDocumentSerde
}

// An object that represents a virtual service backend for a virtual node.
type VirtualServiceBackend struct {

	// The name of the virtual service that is acting as a virtual node backend.
	//
	// This member is required.
	VirtualServiceName *string

	// A reference to an object that represents the client policy for a backend.
	ClientPolicy *ClientPolicy

	noSmithyDocumentSerde
}

// An object that represents a virtual service returned by a describe operation.
type VirtualServiceData struct {

	// The name of the service mesh that the virtual service resides in.
	//
	// This member is required.
	MeshName *string

	// An object that represents metadata for a resource.
	//
	// This member is required.
	Metadata *ResourceMetadata

	// The specifications of the virtual service.
	//
	// This member is required.
	Spec *VirtualServiceSpec

	// The current status of the virtual service.
	//
	// This member is required.
	Status *VirtualServiceStatus

	// The name of the virtual service.
	//
	// This member is required.
	VirtualServiceName *string

	noSmithyDocumentSerde
}

// An object that represents the provider for a virtual service.
//
// The following types satisfy this interface:
//
//	VirtualServiceProviderMemberVirtualNode
//	VirtualServiceProviderMemberVirtualRouter
type VirtualServiceProvider interface {
	isVirtualServiceProvider()
}

// The virtual node associated with a virtual service.
type VirtualServiceProviderMemberVirtualNode struct {
	Value VirtualNodeServiceProvider

	noSmithyDocumentSerde
}

func (*VirtualServiceProviderMemberVirtualNode) isVirtualServiceProvider() {}

// The virtual router associated with a virtual service.
type VirtualServiceProviderMemberVirtualRouter struct {
	Value VirtualRouterServiceProvider

	noSmithyDocumentSerde
}

func (*VirtualServiceProviderMemberVirtualRouter) isVirtualServiceProvider() {}

// An object that represents a virtual service returned by a list operation.
type VirtualServiceRef struct {

	// The full Amazon Resource Name (ARN) for the virtual service.
	//
	// This member is required.
	Arn *string

	// The Unix epoch timestamp in seconds for when the resource was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Unix epoch timestamp in seconds for when the resource was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the service mesh that the virtual service resides in.
	//
	// This member is required.
	MeshName *string

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	MeshOwner *string

	// The Amazon Web Services IAM account ID of the resource owner. If the account ID
	// is not your own, then it's the ID of the mesh owner or of another account that
	// the mesh is shared with. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	//
	// This member is required.
	ResourceOwner *string

	// The version of the resource. Resources are created at version 1, and this
	// version is incremented each time that they're updated.
	//
	// This member is required.
	Version *int64

	// The name of the virtual service.
	//
	// This member is required.
	VirtualServiceName *string

	noSmithyDocumentSerde
}

// An object that represents the specification of a virtual service.
type VirtualServiceSpec struct {

	// The App Mesh object that is acting as the provider for a virtual service. You
	// can specify a single virtual node or virtual router.
	Provider VirtualServiceProvider

	noSmithyDocumentSerde
}

// An object that represents the status of a virtual service.
type VirtualServiceStatus struct {

	// The current status of the virtual service.
	//
	// This member is required.
	Status VirtualServiceStatusCode

	noSmithyDocumentSerde
}

// An object that represents a target and its relative weight. Traffic is
// distributed across targets according to their relative weight. For example, a
// weighted target with a relative weight of 50 receives five times as much traffic
// as one with a relative weight of 10. The total weight for all targets combined
// must be less than or equal to 100.
type WeightedTarget struct {

	// The virtual node to associate with the weighted target.
	//
	// This member is required.
	VirtualNode *string

	// The relative weight of the weighted target.
	//
	// This member is required.
	Weight int32

	// The targeted port of the weighted object.
	Port *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAccessLog()                                       {}
func (*UnknownUnionMember) isBackend()                                         {}
func (*UnknownUnionMember) isClientTlsCertificate()                            {}
func (*UnknownUnionMember) isGrpcMetadataMatchMethod()                         {}
func (*UnknownUnionMember) isGrpcRouteMetadataMatchMethod()                    {}
func (*UnknownUnionMember) isHeaderMatchMethod()                               {}
func (*UnknownUnionMember) isListenerTimeout()                                 {}
func (*UnknownUnionMember) isListenerTlsCertificate()                          {}
func (*UnknownUnionMember) isListenerTlsValidationContextTrust()               {}
func (*UnknownUnionMember) isLoggingFormat()                                   {}
func (*UnknownUnionMember) isServiceDiscovery()                                {}
func (*UnknownUnionMember) isTlsValidationContextTrust()                       {}
func (*UnknownUnionMember) isVirtualGatewayAccessLog()                         {}
func (*UnknownUnionMember) isVirtualGatewayClientTlsCertificate()              {}
func (*UnknownUnionMember) isVirtualGatewayConnectionPool()                    {}
func (*UnknownUnionMember) isVirtualGatewayListenerTlsCertificate()            {}
func (*UnknownUnionMember) isVirtualGatewayListenerTlsValidationContextTrust() {}
func (*UnknownUnionMember) isVirtualGatewayTlsValidationContextTrust()         {}
func (*UnknownUnionMember) isVirtualNodeConnectionPool()                       {}
func (*UnknownUnionMember) isVirtualServiceProvider()                          {}
