#!/bin/sh
### BEGIN INIT INFO
# Provides:          gogoc
# Required-Start:    $network $remote_fs 
# Required-Stop:     $network $remote_fs 
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Gateway6 client
### END INIT INFO

# Author: Craig Small <csmall@debian.org>

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DESC="IPv6 TSP Client" 
NAME=gogoc
DAEMON=/usr/sbin/gogoc 
DAEMON_OPTS=
GOGOC_CONFIG=/etc/gogoc/gogoc.conf
GOGOC_KEYS=/var/lib/gogoc/gogockeys.pub
PIDDIR=/var/run/gogoc
RADVDDIR=/var/run/radvd
SCRIPTNAME=/etc/init.d/$NAME

CHECK_KEYFILE="yes"	
DIETIME=5

[ -x "$DAEMON" ] || exit 0

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
  if [ "$CHECK_KEYFILE" = "yes" ] ; then
  		  check_server_key || return $?
	fi
  [ -d $PIDDIR ] || mkdir -p $PIDDIR
	# RADVD if installed may not have its rundir
	if [ ! -e $RADVDDIR ] && [ -e /usr/sbin/radvd ] ; then
	  install -d -o radvd -g root -m 4755 $RADVDDIR
	fi
	start-stop-daemon --start --quiet --exec $DAEMON --test > /dev/null \
		|| return 1
	start-stop-daemon --start --quiet --exec $DAEMON -- $DAEMON_OPTS \
		|| return 2
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
  start-stop-daemon --stop --signal HUP --exec $DAEMON 
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2
	return "$RETVAL"
}


check_server_key() {
		# Check for config file, if there isn't one then exit
		test -f $GOGOC_CONFIG || return 1

		# Extract the server from config file, mandatory config line
		GOGOC_SERVER=$(sed '/^server/!d; s/.*[=#]\(.*\)/\1/; q' $GOGOC_CONFIG)
		if [ -z $GOGOC_SERVER ]; then
			log_warning_msg "Not starting gogoc - no server line in $GOGOC_CONFIG"
			return 1
		fi
		# Extract authentication type from config file
		GOGOC_AUTHTYPE=$(sed '/^auth_method/!d; s/.*[=#]\(.*\)/\1/; q' $GOGOC_CONFIG)
		# We only care if the method is any or passdss-3des-1
		if [ -z $GOGOC_AUTHTYPE ]; then
		  return 0
		fi
		if [ "$GOGOC_AUTHTYPE" != "any" ] && [ "$GOGOC_AUTHTYPE" != "passdss-3des-1-md5"  ]; then
		  return 0
		fi
		

		# Check for cached server key
		if [ ! -r $GOGOC_KEYS ] || ! grep -q "^$GOGOC_SERVER[[:space:]]" $GOGOC_KEYS ; then
			log_warning_msg "Not starting gogoc - no server key"
			return 1
		fi
		return 0
}

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  status)
       status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
       ;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	log_daemon_msg "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
    [ -n "$DIETIME" ] && sleep $DIETIME
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac
	;;
  *)
	#echo "Usage: $SCRIPTNAME {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

:
