/* retro-gamepad.c generated by valac 0.36.12.13-3ae08, the Vala compiler
 * generated from retro-gamepad.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <retro-gtk.h>
#include <libmanette.h>
#include <linux/input-event-codes.h>
#include <float.h>
#include <math.h>


#define GAMES_TYPE_RETRO_GAMEPAD (games_retro_gamepad_get_type ())
#define GAMES_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad))
#define GAMES_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))
#define GAMES_IS_RETRO_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_IS_RETRO_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_GAMEPAD))
#define GAMES_RETRO_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadClass))

typedef struct _GamesRetroGamepad GamesRetroGamepad;
typedef struct _GamesRetroGamepadClass GamesRetroGamepadClass;
typedef struct _GamesRetroGamepadPrivate GamesRetroGamepadPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesRetroGamepad {
	GObject parent_instance;
	GamesRetroGamepadPrivate * priv;
};

struct _GamesRetroGamepadClass {
	GObjectClass parent_class;
};

struct _GamesRetroGamepadPrivate {
	ManetteDevice* _device;
	gboolean _present_analog_sticks;
	gboolean* buttons;
	gint buttons_length1;
	gint _buttons_size_;
	gint16* axes;
	gint axes_length1;
	gint _axes_size_;
	guint16 rumble_effect[2];
};


static gpointer games_retro_gamepad_parent_class = NULL;
static RetroControllerInterface * games_retro_gamepad_retro_controller_parent_iface = NULL;

GType games_retro_gamepad_get_type (void) G_GNUC_CONST;
#define GAMES_RETRO_GAMEPAD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepadPrivate))
enum  {
	GAMES_RETRO_GAMEPAD_0_PROPERTY,
	GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY,
	GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS_PROPERTY
};
GamesRetroGamepad* games_retro_gamepad_new (ManetteDevice* device, gboolean present_analog_sticks);
GamesRetroGamepad* games_retro_gamepad_construct (GType object_type, ManetteDevice* device, gboolean present_analog_sticks);
static void games_retro_gamepad_real_poll (RetroController* base);
static gint16 games_retro_gamepad_real_get_input_state (RetroController* base, RetroInput* input);
static gboolean games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self, RetroJoypadId button);
static gint16 games_retro_gamepad_get_analog_value (GamesRetroGamepad* self, RetroAnalogIndex index, RetroAnalogId id);
static RetroControllerType games_retro_gamepad_real_get_controller_type (RetroController* base);
gboolean games_retro_gamepad_get_present_analog_sticks (GamesRetroGamepad* self);
static guint64 games_retro_gamepad_real_get_capabilities (RetroController* base);
static gboolean games_retro_gamepad_real_set_rumble_state (RetroController* base, RetroRumbleEffect effect, guint16 strength);
ManetteDevice* games_retro_gamepad_get_device (GamesRetroGamepad* self);
static void games_retro_gamepad_on_button_press_event (GamesRetroGamepad* self, ManetteEvent* event);
static void games_retro_gamepad_on_button_release_event (GamesRetroGamepad* self, ManetteEvent* event);
static void games_retro_gamepad_on_absolute_axis_event (GamesRetroGamepad* self, ManetteEvent* event);
static void games_retro_gamepad_set_device (GamesRetroGamepad* self, ManetteDevice* value);
static void games_retro_gamepad_set_present_analog_sticks (GamesRetroGamepad* self, gboolean value);
static GObject * games_retro_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _games_retro_gamepad_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self);
static void _games_retro_gamepad_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self);
static void _games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self);
static void games_retro_gamepad_finalize (GObject * obj);
static void _vala_games_retro_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_retro_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GamesRetroGamepad* games_retro_gamepad_construct (GType object_type, ManetteDevice* device, gboolean present_analog_sticks) {
	GamesRetroGamepad * self = NULL;
	ManetteDevice* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = present_analog_sticks;
	self = (GamesRetroGamepad*) g_object_new (object_type, "device", _tmp0_, "present-analog-sticks", _tmp1_, NULL);
	return self;
}


GamesRetroGamepad* games_retro_gamepad_new (ManetteDevice* device, gboolean present_analog_sticks) {
	return games_retro_gamepad_construct (GAMES_TYPE_RETRO_GAMEPAD, device, present_analog_sticks);
}


static void games_retro_gamepad_real_poll (RetroController* base) {
	GamesRetroGamepad * self;
	self = (GamesRetroGamepad*) base;
}


static gint16 games_retro_gamepad_real_get_input_state (RetroController* base, RetroInput* input) {
	GamesRetroGamepad * self;
	gint16 result = 0;
	RetroInput* _tmp0_;
	RetroControllerType _tmp1_;
	self = (GamesRetroGamepad*) base;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp1_ = retro_input_get_controller_type (_tmp0_);
	switch (_tmp1_) {
		case RETRO_CONTROLLER_TYPE_JOYPAD:
		{
			RetroJoypadId id = 0;
			RetroInput* _tmp2_;
			RetroJoypadId _tmp3_ = 0;
			gboolean _tmp4_;
			gint16 _tmp5_ = 0;
			RetroJoypadId _tmp6_;
			gboolean _tmp7_;
			_tmp2_ = input;
			_tmp4_ = retro_input_get_joypad (_tmp2_, &_tmp3_);
			id = _tmp3_;
			if (!_tmp4_) {
				result = (gint16) 0;
				return result;
			}
			_tmp6_ = id;
			_tmp7_ = games_retro_gamepad_get_button_pressed (self, _tmp6_);
			if (_tmp7_) {
				_tmp5_ = G_MAXINT16;
			} else {
				_tmp5_ = (gint16) 0;
			}
			result = _tmp5_;
			return result;
		}
		case RETRO_CONTROLLER_TYPE_ANALOG:
		{
			RetroAnalogId id = 0;
			RetroAnalogIndex index = 0;
			RetroInput* _tmp8_;
			RetroAnalogId _tmp9_ = 0;
			RetroAnalogIndex _tmp10_ = 0;
			gboolean _tmp11_;
			RetroAnalogIndex _tmp12_;
			RetroAnalogId _tmp13_;
			gint16 _tmp14_;
			_tmp8_ = input;
			_tmp11_ = retro_input_get_analog (_tmp8_, &_tmp9_, &_tmp10_);
			id = _tmp9_;
			index = _tmp10_;
			if (!_tmp11_) {
				result = (gint16) 0;
				return result;
			}
			_tmp12_ = index;
			_tmp13_ = id;
			_tmp14_ = games_retro_gamepad_get_analog_value (self, _tmp12_, _tmp13_);
			result = _tmp14_;
			return result;
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}


static RetroControllerType games_retro_gamepad_real_get_controller_type (RetroController* base) {
	GamesRetroGamepad * self;
	RetroControllerType result = 0;
	gboolean _tmp0_;
	self = (GamesRetroGamepad*) base;
	_tmp0_ = self->priv->_present_analog_sticks;
	if (_tmp0_) {
		result = RETRO_CONTROLLER_TYPE_ANALOG;
		return result;
	}
	result = RETRO_CONTROLLER_TYPE_JOYPAD;
	return result;
}


static guint64 games_retro_gamepad_real_get_capabilities (RetroController* base) {
	GamesRetroGamepad * self;
	guint64 result = 0ULL;
	self = (GamesRetroGamepad*) base;
	result = (guint64) ((1 << RETRO_CONTROLLER_TYPE_JOYPAD) | (1 << RETRO_CONTROLLER_TYPE_ANALOG));
	return result;
}


static gboolean games_retro_gamepad_real_set_rumble_state (RetroController* base, RetroRumbleEffect effect, guint16 strength) {
	GamesRetroGamepad * self;
	gboolean result = FALSE;
	RetroRumbleEffect _tmp0_;
	guint16 _tmp1_;
	guint16 _tmp2_;
	ManetteDevice* _tmp3_;
	gboolean _tmp4_;
	ManetteDevice* _tmp5_;
	guint16 _tmp6_;
	guint16 _tmp7_;
	self = (GamesRetroGamepad*) base;
	_tmp0_ = effect;
	_tmp1_ = strength;
	self->priv->rumble_effect[_tmp0_] = _tmp1_;
	_tmp2_ = self->priv->rumble_effect[_tmp0_];
	_tmp3_ = self->priv->_device;
	_tmp4_ = manette_device_has_rumble (_tmp3_);
	if (!_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_device;
	_tmp6_ = self->priv->rumble_effect[RETRO_RUMBLE_EFFECT_STRONG];
	_tmp7_ = self->priv->rumble_effect[RETRO_RUMBLE_EFFECT_WEAK];
	manette_device_rumble (_tmp5_, _tmp6_, _tmp7_, G_MAXUINT16);
	result = TRUE;
	return result;
}


static gboolean games_retro_gamepad_get_button_pressed (GamesRetroGamepad* self, RetroJoypadId button) {
	gboolean result = FALSE;
	RetroJoypadId _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = button;
	switch (_tmp0_) {
		case RETRO_JOYPAD_ID_B:
		{
			gboolean* _tmp1_;
			gint _tmp1__length1;
			gboolean _tmp2_;
			_tmp1_ = self->priv->buttons;
			_tmp1__length1 = self->priv->buttons_length1;
			_tmp2_ = _tmp1_[BTN_A];
			result = _tmp2_;
			return result;
		}
		case RETRO_JOYPAD_ID_Y:
		{
			gboolean* _tmp3_;
			gint _tmp3__length1;
			gboolean _tmp4_;
			_tmp3_ = self->priv->buttons;
			_tmp3__length1 = self->priv->buttons_length1;
			_tmp4_ = _tmp3_[BTN_Y];
			result = _tmp4_;
			return result;
		}
		case RETRO_JOYPAD_ID_SELECT:
		{
			gboolean* _tmp5_;
			gint _tmp5__length1;
			gboolean _tmp6_;
			_tmp5_ = self->priv->buttons;
			_tmp5__length1 = self->priv->buttons_length1;
			_tmp6_ = _tmp5_[BTN_SELECT];
			result = _tmp6_;
			return result;
		}
		case RETRO_JOYPAD_ID_START:
		{
			gboolean* _tmp7_;
			gint _tmp7__length1;
			gboolean _tmp8_;
			_tmp7_ = self->priv->buttons;
			_tmp7__length1 = self->priv->buttons_length1;
			_tmp8_ = _tmp7_[BTN_START];
			result = _tmp8_;
			return result;
		}
		case RETRO_JOYPAD_ID_UP:
		{
			gboolean* _tmp9_;
			gint _tmp9__length1;
			gboolean _tmp10_;
			_tmp9_ = self->priv->buttons;
			_tmp9__length1 = self->priv->buttons_length1;
			_tmp10_ = _tmp9_[BTN_DPAD_UP];
			result = _tmp10_;
			return result;
		}
		case RETRO_JOYPAD_ID_DOWN:
		{
			gboolean* _tmp11_;
			gint _tmp11__length1;
			gboolean _tmp12_;
			_tmp11_ = self->priv->buttons;
			_tmp11__length1 = self->priv->buttons_length1;
			_tmp12_ = _tmp11_[BTN_DPAD_DOWN];
			result = _tmp12_;
			return result;
		}
		case RETRO_JOYPAD_ID_LEFT:
		{
			gboolean* _tmp13_;
			gint _tmp13__length1;
			gboolean _tmp14_;
			_tmp13_ = self->priv->buttons;
			_tmp13__length1 = self->priv->buttons_length1;
			_tmp14_ = _tmp13_[BTN_DPAD_LEFT];
			result = _tmp14_;
			return result;
		}
		case RETRO_JOYPAD_ID_RIGHT:
		{
			gboolean* _tmp15_;
			gint _tmp15__length1;
			gboolean _tmp16_;
			_tmp15_ = self->priv->buttons;
			_tmp15__length1 = self->priv->buttons_length1;
			_tmp16_ = _tmp15_[BTN_DPAD_RIGHT];
			result = _tmp16_;
			return result;
		}
		case RETRO_JOYPAD_ID_A:
		{
			gboolean* _tmp17_;
			gint _tmp17__length1;
			gboolean _tmp18_;
			_tmp17_ = self->priv->buttons;
			_tmp17__length1 = self->priv->buttons_length1;
			_tmp18_ = _tmp17_[BTN_B];
			result = _tmp18_;
			return result;
		}
		case RETRO_JOYPAD_ID_X:
		{
			gboolean* _tmp19_;
			gint _tmp19__length1;
			gboolean _tmp20_;
			_tmp19_ = self->priv->buttons;
			_tmp19__length1 = self->priv->buttons_length1;
			_tmp20_ = _tmp19_[BTN_X];
			result = _tmp20_;
			return result;
		}
		case RETRO_JOYPAD_ID_L:
		{
			gboolean* _tmp21_;
			gint _tmp21__length1;
			gboolean _tmp22_;
			_tmp21_ = self->priv->buttons;
			_tmp21__length1 = self->priv->buttons_length1;
			_tmp22_ = _tmp21_[BTN_TL];
			result = _tmp22_;
			return result;
		}
		case RETRO_JOYPAD_ID_R:
		{
			gboolean* _tmp23_;
			gint _tmp23__length1;
			gboolean _tmp24_;
			_tmp23_ = self->priv->buttons;
			_tmp23__length1 = self->priv->buttons_length1;
			_tmp24_ = _tmp23_[BTN_TR];
			result = _tmp24_;
			return result;
		}
		case RETRO_JOYPAD_ID_L2:
		{
			gboolean* _tmp25_;
			gint _tmp25__length1;
			gboolean _tmp26_;
			_tmp25_ = self->priv->buttons;
			_tmp25__length1 = self->priv->buttons_length1;
			_tmp26_ = _tmp25_[BTN_TL2];
			result = _tmp26_;
			return result;
		}
		case RETRO_JOYPAD_ID_R2:
		{
			gboolean* _tmp27_;
			gint _tmp27__length1;
			gboolean _tmp28_;
			_tmp27_ = self->priv->buttons;
			_tmp27__length1 = self->priv->buttons_length1;
			_tmp28_ = _tmp27_[BTN_TR2];
			result = _tmp28_;
			return result;
		}
		case RETRO_JOYPAD_ID_L3:
		{
			gboolean* _tmp29_;
			gint _tmp29__length1;
			gboolean _tmp30_;
			_tmp29_ = self->priv->buttons;
			_tmp29__length1 = self->priv->buttons_length1;
			_tmp30_ = _tmp29_[BTN_THUMBL];
			result = _tmp30_;
			return result;
		}
		case RETRO_JOYPAD_ID_R3:
		{
			gboolean* _tmp31_;
			gint _tmp31__length1;
			gboolean _tmp32_;
			_tmp31_ = self->priv->buttons;
			_tmp31__length1 = self->priv->buttons_length1;
			_tmp32_ = _tmp31_[BTN_THUMBR];
			result = _tmp32_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gint16 games_retro_gamepad_get_analog_value (GamesRetroGamepad* self, RetroAnalogIndex index, RetroAnalogId id) {
	gint16 result = 0;
	RetroAnalogIndex _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	switch (_tmp0_) {
		case RETRO_ANALOG_INDEX_LEFT:
		{
			RetroAnalogId _tmp1_;
			_tmp1_ = id;
			switch (_tmp1_) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp2_;
					gint _tmp2__length1;
					gint16 _tmp3_;
					_tmp2_ = self->priv->axes;
					_tmp2__length1 = self->priv->axes_length1;
					_tmp3_ = _tmp2_[ABS_X];
					result = _tmp3_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp4_;
					gint _tmp4__length1;
					gint16 _tmp5_;
					_tmp4_ = self->priv->axes;
					_tmp4__length1 = self->priv->axes_length1;
					_tmp5_ = _tmp4_[ABS_Y];
					result = _tmp5_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		case RETRO_ANALOG_INDEX_RIGHT:
		{
			RetroAnalogId _tmp6_;
			_tmp6_ = id;
			switch (_tmp6_) {
				case RETRO_ANALOG_ID_X:
				{
					gint16* _tmp7_;
					gint _tmp7__length1;
					gint16 _tmp8_;
					_tmp7_ = self->priv->axes;
					_tmp7__length1 = self->priv->axes_length1;
					_tmp8_ = _tmp7_[ABS_RX];
					result = _tmp8_;
					return result;
				}
				case RETRO_ANALOG_ID_Y:
				{
					gint16* _tmp9_;
					gint _tmp9__length1;
					gint16 _tmp10_;
					_tmp9_ = self->priv->axes;
					_tmp9__length1 = self->priv->axes_length1;
					_tmp10_ = _tmp9_[ABS_RY];
					result = _tmp10_;
					return result;
				}
				default:
				{
					result = (gint16) 0;
					return result;
				}
			}
		}
		default:
		{
			result = (gint16) 0;
			return result;
		}
	}
}


static void games_retro_gamepad_on_button_press_event (GamesRetroGamepad* self, ManetteEvent* event) {
	guint16 button = 0U;
	ManetteEvent* _tmp0_;
	guint16 _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp2_ = manette_event_get_button (_tmp0_, &_tmp1_);
	button = _tmp1_;
	if (_tmp2_) {
		gboolean* _tmp3_;
		gint _tmp3__length1;
		guint16 _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->buttons;
		_tmp3__length1 = self->priv->buttons_length1;
		_tmp4_ = button;
		_tmp3_[_tmp4_] = TRUE;
		_tmp5_ = _tmp3_[_tmp4_];
	}
}


static void games_retro_gamepad_on_button_release_event (GamesRetroGamepad* self, ManetteEvent* event) {
	guint16 button = 0U;
	ManetteEvent* _tmp0_;
	guint16 _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp2_ = manette_event_get_button (_tmp0_, &_tmp1_);
	button = _tmp1_;
	if (_tmp2_) {
		gboolean* _tmp3_;
		gint _tmp3__length1;
		guint16 _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->buttons;
		_tmp3__length1 = self->priv->buttons_length1;
		_tmp4_ = button;
		_tmp3_[_tmp4_] = FALSE;
		_tmp5_ = _tmp3_[_tmp4_];
	}
}


static void games_retro_gamepad_on_absolute_axis_event (GamesRetroGamepad* self, ManetteEvent* event) {
	guint16 axis = 0U;
	gdouble value = 0.0;
	ManetteEvent* _tmp0_;
	guint16 _tmp1_ = 0U;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = event;
	_tmp3_ = manette_event_get_absolute (_tmp0_, &_tmp1_, &_tmp2_);
	axis = _tmp1_;
	value = _tmp2_;
	if (_tmp3_) {
		gint16* _tmp4_;
		gint _tmp4__length1;
		guint16 _tmp5_;
		gdouble _tmp6_;
		gint16 _tmp7_;
		_tmp4_ = self->priv->axes;
		_tmp4__length1 = self->priv->axes_length1;
		_tmp5_ = axis;
		_tmp6_ = value;
		_tmp4_[_tmp5_] = (gint16) (_tmp6_ * G_MAXINT16);
		_tmp7_ = _tmp4_[_tmp5_];
	}
}


ManetteDevice* games_retro_gamepad_get_device (GamesRetroGamepad* self) {
	ManetteDevice* result;
	ManetteDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_retro_gamepad_set_device (GamesRetroGamepad* self, ManetteDevice* value) {
	g_return_if_fail (self != NULL);
	if (games_retro_gamepad_get_device (self) != value) {
		ManetteDevice* _tmp0_;
		ManetteDevice* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp1_;
		g_object_notify ((GObject *) self, "device");
	}
}


gboolean games_retro_gamepad_get_present_analog_sticks (GamesRetroGamepad* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_present_analog_sticks;
	result = _tmp0_;
	return result;
}


static void games_retro_gamepad_set_present_analog_sticks (GamesRetroGamepad* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (games_retro_gamepad_get_present_analog_sticks (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_present_analog_sticks = _tmp0_;
		g_object_notify ((GObject *) self, "present-analog-sticks");
	}
}


static void _games_retro_gamepad_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self) {
	games_retro_gamepad_on_button_press_event ((GamesRetroGamepad*) self, event);
}


static void _games_retro_gamepad_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self) {
	games_retro_gamepad_on_button_release_event ((GamesRetroGamepad*) self, event);
}


static void _games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender, ManetteEvent* event, gpointer self) {
	games_retro_gamepad_on_absolute_axis_event ((GamesRetroGamepad*) self, event);
}


static GObject * games_retro_gamepad_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroGamepad * self;
	gboolean* _tmp0_;
	gint16* _tmp1_;
	ManetteDevice* _tmp2_;
	ManetteDevice* _tmp3_;
	ManetteDevice* _tmp4_;
	parent_class = G_OBJECT_CLASS (games_retro_gamepad_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_tmp0_ = g_new0 (gboolean, KEY_MAX + 1);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->buttons = _tmp0_;
	self->priv->buttons_length1 = KEY_MAX + 1;
	self->priv->_buttons_size_ = self->priv->buttons_length1;
	_tmp1_ = g_new0 (gint16, ABS_MAX + 1);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	self->priv->axes = _tmp1_;
	self->priv->axes_length1 = ABS_MAX + 1;
	self->priv->_axes_size_ = self->priv->axes_length1;
	_tmp2_ = self->priv->_device;
	g_signal_connect_object (_tmp2_, "button-press-event", (GCallback) _games_retro_gamepad_on_button_press_event_manette_device_button_press_event, self, 0);
	_tmp3_ = self->priv->_device;
	g_signal_connect_object (_tmp3_, "button-release-event", (GCallback) _games_retro_gamepad_on_button_release_event_manette_device_button_release_event, self, 0);
	_tmp4_ = self->priv->_device;
	g_signal_connect_object (_tmp4_, "absolute-axis-event", (GCallback) _games_retro_gamepad_on_absolute_axis_event_manette_device_absolute_axis_event, self, 0);
	return obj;
}


static void games_retro_gamepad_class_init (GamesRetroGamepadClass * klass) {
	games_retro_gamepad_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesRetroGamepadPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_gamepad_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_gamepad_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_gamepad_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_gamepad_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY, g_param_spec_object ("device", "device", "device", manette_device_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS_PROPERTY, g_param_spec_boolean ("present-analog-sticks", "present-analog-sticks", "present-analog-sticks", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void games_retro_gamepad_retro_controller_interface_init (RetroControllerInterface * iface) {
	games_retro_gamepad_retro_controller_parent_iface = g_type_interface_peek_parent (iface);
	iface->poll = (void (*) (RetroController *)) games_retro_gamepad_real_poll;
	iface->get_input_state = (gint16 (*) (RetroController *, RetroInput*)) games_retro_gamepad_real_get_input_state;
	iface->get_controller_type = (RetroControllerType (*) (RetroController *)) games_retro_gamepad_real_get_controller_type;
	iface->get_capabilities = (guint64 (*) (RetroController *)) games_retro_gamepad_real_get_capabilities;
	iface->set_rumble_state = (gboolean (*) (RetroController *, RetroRumbleEffect, guint16)) games_retro_gamepad_real_set_rumble_state;
}


static void games_retro_gamepad_instance_init (GamesRetroGamepad * self) {
	self->priv = GAMES_RETRO_GAMEPAD_GET_PRIVATE (self);
}


static void games_retro_gamepad_finalize (GObject * obj) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	_g_object_unref0 (self->priv->_device);
	self->priv->buttons = (g_free (self->priv->buttons), NULL);
	self->priv->axes = (g_free (self->priv->axes), NULL);
	G_OBJECT_CLASS (games_retro_gamepad_parent_class)->finalize (obj);
}


GType games_retro_gamepad_get_type (void) {
	static volatile gsize games_retro_gamepad_type_id__volatile = 0;
	if (g_once_init_enter (&games_retro_gamepad_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesRetroGamepadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_gamepad_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroGamepad), 0, (GInstanceInitFunc) games_retro_gamepad_instance_init, NULL };
		static const GInterfaceInfo retro_controller_info = { (GInterfaceInitFunc) games_retro_gamepad_retro_controller_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType games_retro_gamepad_type_id;
		games_retro_gamepad_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroGamepad", &g_define_type_info, 0);
		g_type_add_interface_static (games_retro_gamepad_type_id, retro_controller_get_type (), &retro_controller_info);
		g_once_init_leave (&games_retro_gamepad_type_id__volatile, games_retro_gamepad_type_id);
	}
	return games_retro_gamepad_type_id__volatile;
}


static void _vala_games_retro_gamepad_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY:
		g_value_set_object (value, games_retro_gamepad_get_device (self));
		break;
		case GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS_PROPERTY:
		g_value_set_boolean (value, games_retro_gamepad_get_present_analog_sticks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_games_retro_gamepad_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesRetroGamepad * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_GAMEPAD, GamesRetroGamepad);
	switch (property_id) {
		case GAMES_RETRO_GAMEPAD_DEVICE_PROPERTY:
		games_retro_gamepad_set_device (self, g_value_get_object (value));
		break;
		case GAMES_RETRO_GAMEPAD_PRESENT_ANALOG_STICKS_PROPERTY:
		games_retro_gamepad_set_present_analog_sticks (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



