/* utils.c generated by valac 0.22.0.21-8a007, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "config.h"
#include <float.h>
#include <math.h>
#include "libgnome-desktop/gnome-wall-clock.h"
#include <glib/gi18n-lib.h>
#include <canberra.h>
#include <libnotify/notify.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CLOCKS_UTILS_TYPE_WALL_CLOCK (clocks_utils_wall_clock_get_type ())
#define CLOCKS_UTILS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock))
#define CLOCKS_UTILS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))
#define CLOCKS_UTILS_IS_WALL_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_IS_WALL_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WALL_CLOCK))
#define CLOCKS_UTILS_WALL_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockClass))

typedef struct _ClocksUtilsWallClock ClocksUtilsWallClock;
typedef struct _ClocksUtilsWallClockClass ClocksUtilsWallClockClass;
typedef struct _ClocksUtilsWallClockPrivate ClocksUtilsWallClockPrivate;

#define CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT (clocks_utils_wall_clock_format_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;
typedef struct _ClocksUtilsWeekdaysPrivate ClocksUtilsWeekdaysPrivate;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))
typedef struct _ClocksUtilsParamSpecWeekdays ClocksUtilsParamSpecWeekdays;

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
typedef struct _ClocksUtilsBellPrivate ClocksUtilsBellPrivate;
#define _ca_context_destroy0(var) ((var == NULL) ? NULL : (var = (ca_context_destroy (var), NULL)))
#define _ca_proplist_destroy0(var) ((var == NULL) ? NULL : (var = (ca_proplist_destroy (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ClocksUtilsWallClock {
	GObject parent_instance;
	ClocksUtilsWallClockPrivate * priv;
};

struct _ClocksUtilsWallClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR
} ClocksUtilsWallClockFormat;

struct _ClocksUtilsWallClockPrivate {
	GDateTime* _date_time;
	GTimeZone* _timezone;
	ClocksUtilsWallClockFormat _format;
	GSettings* settings;
	GnomeWallClock* wc;
};

struct _ClocksUtilsWeekdays {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ClocksUtilsWeekdaysPrivate * priv;
};

struct _ClocksUtilsWeekdaysClass {
	GTypeClass parent_class;
	void (*finalize) (ClocksUtilsWeekdays *self);
};

struct _ClocksUtilsWeekdaysPrivate {
	gboolean* days;
	gint days_length1;
	gint _days_size_;
};

typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

struct _ClocksUtilsParamSpecWeekdays {
	GParamSpec parent_instance;
};

struct _ClocksUtilsBell {
	GObject parent_instance;
	ClocksUtilsBellPrivate * priv;
};

struct _ClocksUtilsBellClass {
	GObjectClass parent_class;
};

struct _ClocksUtilsBellPrivate {
	GSettings* settings;
	ca_context* canberra;
	gchar* soundtheme;
	gchar* sound;
	NotifyNotification* notification;
};

typedef void (*ClocksUtilsBellActionCallback) (void* user_data);
struct _Block6Data {
	int _ref_count_;
	ClocksUtilsBell * self;
	ClocksUtilsBellActionCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};


static gpointer clocks_utils_wall_clock_parent_class = NULL;
static ClocksUtilsWallClock* clocks_utils_wall_clock_instance;
static ClocksUtilsWallClock* clocks_utils_wall_clock_instance = NULL;
static gpointer clocks_utils_weekdays_parent_class = NULL;
static gchar** clocks_utils_weekdays_abbreviations;
static gint clocks_utils_weekdays_abbreviations_length1;
static gchar** clocks_utils_weekdays_abbreviations = NULL;
static gint clocks_utils_weekdays_abbreviations_length1 = 0;
static gint _clocks_utils_weekdays_abbreviations_size_ = 0;
static gpointer clocks_utils_bell_parent_class = NULL;

gint clocks_cutils_get_week_start (void);
GtkCssProvider* clocks_utils_load_css (const gchar* css);
GtkBuilder* clocks_utils_load_ui (const gchar* ui);
GdkPixbuf* clocks_utils_load_image (const gchar* image);
void clocks_utils_time_to_hms (gdouble t, gint* h, gint* m, gint* s, gdouble* remainder);
GType clocks_utils_wall_clock_get_type (void) G_GNUC_CONST;
GType clocks_utils_wall_clock_format_get_type (void) G_GNUC_CONST;
#define CLOCKS_UTILS_WALL_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClockPrivate))
enum  {
	CLOCKS_UTILS_WALL_CLOCK_DUMMY_PROPERTY,
	CLOCKS_UTILS_WALL_CLOCK_DATE_TIME,
	CLOCKS_UTILS_WALL_CLOCK_TIMEZONE,
	CLOCKS_UTILS_WALL_CLOCK_FORMAT
};
ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void);
static ClocksUtilsWallClock* clocks_utils_wall_clock_new (void);
static ClocksUtilsWallClock* clocks_utils_wall_clock_construct (GType object_type);
static void __lambda15_ (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_update (ClocksUtilsWallClock* self);
static void ___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void clocks_utils_wall_clock_set_timezone (ClocksUtilsWallClock* self, GTimeZone* value);
static void __lambda16_ (ClocksUtilsWallClock* self);
static void ___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda17_ (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_update_format (ClocksUtilsWallClock* self);
static void ___lambda17__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void clocks_utils_wall_clock_set_format (ClocksUtilsWallClock* self, ClocksUtilsWallClockFormat value);
GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_set_date_time (ClocksUtilsWallClock* self, GDateTime* value);
gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time);
ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self);
GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self);
static void clocks_utils_wall_clock_finalize (GObject* obj);
static void _vala_clocks_utils_wall_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_utils_wall_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer clocks_utils_weekdays_ref (gpointer instance);
void clocks_utils_weekdays_unref (gpointer instance);
GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void clocks_utils_value_set_weekdays (GValue* value, gpointer v_object);
void clocks_utils_value_take_weekdays (GValue* value, gpointer v_object);
gpointer clocks_utils_value_get_weekdays (const GValue* value);
GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST;
#define CLOCKS_UTILS_WEEKDAYS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysPrivate))
enum  {
	CLOCKS_UTILS_WEEKDAYS_DUMMY_PROPERTY
};
GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST;
ClocksUtilsWeekdaysDay clocks_utils_weekdays_get_first_weekday (void);
gchar* clocks_utils_weekdays_plural (ClocksUtilsWeekdaysDay d);
gchar* clocks_utils_weekdays_abbreviation (ClocksUtilsWeekdaysDay d);
ClocksUtilsWeekdays* clocks_utils_weekdays_new (void);
ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type);
static gboolean clocks_utils_weekdays_days_equal (ClocksUtilsWeekdays* self, gboolean* d, int d_length1);
gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d);
void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d, gboolean on);
gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self);
ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant);
gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self);
static void clocks_utils_weekdays_finalize (ClocksUtilsWeekdays* obj);
GType clocks_utils_bell_get_type (void) G_GNUC_CONST;
#define CLOCKS_UTILS_BELL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellPrivate))
enum  {
	CLOCKS_UTILS_BELL_DUMMY_PROPERTY
};
ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid, const gchar* title, const gchar* msg);
ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid, const gchar* title, const gchar* msg);
static gboolean clocks_utils_bell_keep_ringing (ClocksUtilsBell* self);
static void __lambda28_ (ClocksUtilsBell* self, ca_context* c, guint32 id, gint code);
static gboolean _clocks_utils_bell_keep_ringing_gsource_func (gpointer self);
static void ___lambda28__ca_finishcallback (ca_context* c, guint32 id, gint code, gpointer self);
static void clocks_utils_bell_ring_real (ClocksUtilsBell* self, gboolean once);
void clocks_utils_bell_ring_once (ClocksUtilsBell* self);
void clocks_utils_bell_ring (ClocksUtilsBell* self);
void clocks_utils_bell_stop (ClocksUtilsBell* self);
void clocks_utils_bell_add_action (ClocksUtilsBell* self, const gchar* action, const gchar* label, ClocksUtilsBellActionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda29_ (Block6Data* _data6_, NotifyNotification* n, const gchar* a);
static void ____lambda29__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self);
static void clocks_utils_bell_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gboolean CLOCKS_UTILS_WEEKDAYS_weekdays[7] = {TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, FALSE};
static const gboolean CLOCKS_UTILS_WEEKDAYS_weekends[7] = {FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE};
static const gchar* CLOCKS_UTILS_WEEKDAYS_plurals[7] = {"Mondays", "Tuesdays", "Wednesdays", "Thursdays", "Fridays", "Saturdays", "Sundays"};

GtkCssProvider* clocks_utils_load_css (const gchar* css) {
	GtkCssProvider* result = NULL;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (css != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	{
		GFile* file = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		_tmp1_ = css;
		_tmp2_ = g_strconcat ("resource:///org/gnome/clocks/css/", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		file = _tmp5_;
		gtk_css_provider_load_from_file (provider, file, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch2_g_error;
		}
		_g_object_unref0 (file);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("utils.vala:30: loading css: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = provider;
	return result;
}


GtkBuilder* clocks_utils_load_ui (const gchar* ui) {
	GtkBuilder* result = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ui != NULL, NULL);
	_tmp0_ = gtk_builder_new ();
	builder = _tmp0_;
	{
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = ui;
		_tmp2_ = g_strconcat ("/org/gnome/clocks/ui/", _tmp1_, NULL, NULL);
		_tmp3_ = _tmp2_;
		gtk_builder_add_from_resource (builder, _tmp3_, &_inner_error_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e->message;
		g_error ("utils.vala:40: loading main builder file: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = builder;
	return result;
}


GdkPixbuf* clocks_utils_load_image (const gchar* image) {
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (image != NULL, NULL);
	{
		gchar* path = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		_tmp0_ = image;
		_tmp1_ = g_build_filename (DATADIR, "gnome-clocks", "images", _tmp0_, NULL);
		path = _tmp1_;
		_tmp3_ = gdk_pixbuf_new_from_file (path, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_free0 (path);
			goto __catch4_g_error;
		}
		result = _tmp2_;
		_g_free0 (path);
		return result;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("utils.vala:50: loading image file: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	return result;
}


void clocks_utils_time_to_hms (gdouble t, gint* h, gint* m, gint* s, gdouble* remainder) {
	gint _vala_h = 0;
	gint _vala_m = 0;
	gint _vala_s = 0;
	gdouble _vala_remainder = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	_tmp0_ = t;
	_vala_h = ((gint) _tmp0_) / 3600;
	_tmp1_ = t;
	t = fmod (_tmp1_, 3600);
	_tmp2_ = t;
	_vala_m = ((gint) _tmp2_) / 60;
	_tmp3_ = t;
	t = fmod (_tmp3_, 60);
	_tmp4_ = t;
	_vala_s = (gint) _tmp4_;
	_tmp5_ = t;
	_vala_remainder = _tmp5_ - _vala_s;
	if (h) {
		*h = _vala_h;
	}
	if (m) {
		*m = _vala_m;
	}
	if (s) {
		*s = _vala_s;
	}
	if (remainder) {
		*remainder = _vala_remainder;
	}
}


GType clocks_utils_wall_clock_format_get_type (void) {
	static volatile gsize clocks_utils_wall_clock_format_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_utils_wall_clock_format_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE, "CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE", "twelve"}, {CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR, "CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR", "twentyfour"}, {0, NULL, NULL}};
		GType clocks_utils_wall_clock_format_type_id;
		clocks_utils_wall_clock_format_type_id = g_enum_register_static ("ClocksUtilsWallClockFormat", values);
		g_once_init_leave (&clocks_utils_wall_clock_format_type_id__volatile, clocks_utils_wall_clock_format_type_id);
	}
	return clocks_utils_wall_clock_format_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ClocksUtilsWallClock* clocks_utils_wall_clock_get_default (void) {
	ClocksUtilsWallClock* result = NULL;
	ClocksUtilsWallClock* _tmp0_ = NULL;
	ClocksUtilsWallClock* _tmp2_ = NULL;
	ClocksUtilsWallClock* _tmp3_ = NULL;
	_tmp0_ = clocks_utils_wall_clock_instance;
	if (_tmp0_ == NULL) {
		ClocksUtilsWallClock* _tmp1_ = NULL;
		_tmp1_ = clocks_utils_wall_clock_new ();
		_g_object_unref0 (clocks_utils_wall_clock_instance);
		clocks_utils_wall_clock_instance = _tmp1_;
	}
	_tmp2_ = clocks_utils_wall_clock_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void __lambda15_ (ClocksUtilsWallClock* self) {
	clocks_utils_wall_clock_update (self);
	g_signal_emit_by_name (self, "tick");
}


static void ___lambda15__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda15_ (self);
}


static void __lambda16_ (ClocksUtilsWallClock* self) {
	GnomeWallClock* _tmp0_ = NULL;
	GTimeZone* _tmp1_ = NULL;
	GTimeZone* _tmp2_ = NULL;
	GTimeZone* _tmp3_ = NULL;
	_tmp0_ = self->priv->wc;
	g_object_get (_tmp0_, "timezone", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	clocks_utils_wall_clock_set_timezone (self, _tmp3_);
	_g_time_zone_unref0 (_tmp3_);
}


static void ___lambda16__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda16_ (self);
}


static void __lambda17_ (ClocksUtilsWallClock* self) {
	clocks_utils_wall_clock_update_format (self);
}


static void ___lambda17__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda17_ (self);
}


static ClocksUtilsWallClock* clocks_utils_wall_clock_construct (GType object_type) {
	ClocksUtilsWallClock * self = NULL;
	GnomeWallClock* _tmp0_ = NULL;
	GnomeWallClock* _tmp1_ = NULL;
	GnomeWallClock* _tmp2_ = NULL;
	GTimeZone* _tmp3_ = NULL;
	GTimeZone* _tmp4_ = NULL;
	GTimeZone* _tmp5_ = NULL;
	GnomeWallClock* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GSettings* _tmp8_ = NULL;
	self = (ClocksUtilsWallClock*) g_object_new (object_type, NULL);
	_tmp0_ = gnome_wall_clock_new ();
	_g_object_unref0 (self->priv->wc);
	self->priv->wc = _tmp0_;
	_tmp1_ = self->priv->wc;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::clock", (GCallback) ___lambda15__g_object_notify, self, 0);
	_tmp2_ = self->priv->wc;
	g_object_get (_tmp2_, "timezone", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	clocks_utils_wall_clock_set_timezone (self, _tmp5_);
	_g_time_zone_unref0 (_tmp5_);
	_tmp6_ = self->priv->wc;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::timezone", (GCallback) ___lambda16__g_object_notify, self, 0);
	_tmp7_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	_tmp8_ = self->priv->settings;
	g_signal_connect_object (_tmp8_, "changed::clock-format", (GCallback) ___lambda17__g_settings_changed, self, 0);
	clocks_utils_wall_clock_update_format (self);
	clocks_utils_wall_clock_update (self);
	return self;
}


static ClocksUtilsWallClock* clocks_utils_wall_clock_new (void) {
	return clocks_utils_wall_clock_construct (CLOCKS_UTILS_TYPE_WALL_CLOCK);
}


static void clocks_utils_wall_clock_update_format (ClocksUtilsWallClock* self) {
	gchar* sys_format = NULL;
	GSettings* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ClocksUtilsWallClockFormat _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	ClocksUtilsWallClockFormat _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "clock-format");
	sys_format = _tmp1_;
	_tmp3_ = sys_format;
	if (g_strcmp0 (_tmp3_, "12h") == 0) {
		_tmp2_ = CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE;
	} else {
		_tmp2_ = CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWENTYFOUR;
	}
	_tmp4_ = _tmp2_;
	clocks_utils_wall_clock_set_format (self, _tmp4_);
	_g_free0 (sys_format);
}


static void clocks_utils_wall_clock_update (ClocksUtilsWallClock* self) {
	GTimeZone* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timezone;
	_tmp1_ = g_date_time_new_now (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_utils_wall_clock_set_date_time (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* clocks_utils_wall_clock_format_time (ClocksUtilsWallClock* self, GDateTime* date_time) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksUtilsWallClockFormat _tmp1_ = 0;
	gchar* time = NULL;
	GDateTime* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	ClocksUtilsWallClockFormat _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date_time != NULL, NULL);
	_tmp1_ = self->priv->_format;
	if (_tmp1_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		_tmp0_ = "%I:%M %p";
	} else {
		_tmp0_ = "%H:%M";
	}
	_tmp2_ = date_time;
	_tmp3_ = _tmp0_;
	_tmp4_ = g_date_time_format (_tmp2_, _tmp3_);
	time = _tmp4_;
	_tmp5_ = time;
	_tmp6_ = string_replace (_tmp5_, ":", "\xE2\x80\x8E\xE2\x88\xB6");
	_g_free0 (time);
	time = _tmp6_;
	_tmp7_ = self->priv->_format;
	if (_tmp7_ == CLOCKS_UTILS_WALL_CLOCK_FORMAT_TWELVE) {
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp8_ = time;
		_tmp9_ = string_replace (_tmp8_, " ", "\xE2\x80\x89");
		_g_free0 (time);
		time = _tmp9_;
	}
	result = time;
	return result;
}


GDateTime* clocks_utils_wall_clock_get_date_time (ClocksUtilsWallClock* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_date_time;
	result = _tmp0_;
	return result;
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void clocks_utils_wall_clock_set_date_time (ClocksUtilsWallClock* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	_g_date_time_unref0 (self->priv->_date_time);
	self->priv->_date_time = _tmp1_;
	g_object_notify ((GObject *) self, "date-time");
}


GTimeZone* clocks_utils_wall_clock_get_timezone (ClocksUtilsWallClock* self) {
	GTimeZone* result;
	GTimeZone* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_timezone;
	result = _tmp0_;
	return result;
}


static gpointer _g_time_zone_ref0 (gpointer self) {
	return self ? g_time_zone_ref (self) : NULL;
}


static void clocks_utils_wall_clock_set_timezone (ClocksUtilsWallClock* self, GTimeZone* value) {
	GTimeZone* _tmp0_ = NULL;
	GTimeZone* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_time_zone_ref0 (_tmp0_);
	_g_time_zone_unref0 (self->priv->_timezone);
	self->priv->_timezone = _tmp1_;
	g_object_notify ((GObject *) self, "timezone");
}


ClocksUtilsWallClockFormat clocks_utils_wall_clock_get_format (ClocksUtilsWallClock* self) {
	ClocksUtilsWallClockFormat result;
	ClocksUtilsWallClockFormat _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_format;
	result = _tmp0_;
	return result;
}


static void clocks_utils_wall_clock_set_format (ClocksUtilsWallClock* self, ClocksUtilsWallClockFormat value) {
	ClocksUtilsWallClockFormat _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_format = _tmp0_;
	g_object_notify ((GObject *) self, "format");
}


static void clocks_utils_wall_clock_class_init (ClocksUtilsWallClockClass * klass) {
	clocks_utils_wall_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksUtilsWallClockPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_utils_wall_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_utils_wall_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_utils_wall_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_DATE_TIME, g_param_spec_boxed ("date-time", "date-time", "date-time", G_TYPE_DATE_TIME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_TIMEZONE, g_param_spec_pointer ("timezone", "timezone", "timezone", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_UTILS_WALL_CLOCK_FORMAT, g_param_spec_enum ("format", "format", "format", CLOCKS_UTILS_WALL_CLOCK_TYPE_FORMAT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("tick", CLOCKS_UTILS_TYPE_WALL_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void clocks_utils_wall_clock_instance_init (ClocksUtilsWallClock * self) {
	self->priv = CLOCKS_UTILS_WALL_CLOCK_GET_PRIVATE (self);
}


static void clocks_utils_wall_clock_finalize (GObject* obj) {
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	_g_date_time_unref0 (self->priv->_date_time);
	_g_time_zone_unref0 (self->priv->_timezone);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->wc);
	G_OBJECT_CLASS (clocks_utils_wall_clock_parent_class)->finalize (obj);
}


GType clocks_utils_wall_clock_get_type (void) {
	static volatile gsize clocks_utils_wall_clock_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_utils_wall_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsWallClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_wall_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsWallClock), 0, (GInstanceInitFunc) clocks_utils_wall_clock_instance_init, NULL };
		GType clocks_utils_wall_clock_type_id;
		clocks_utils_wall_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksUtilsWallClock", &g_define_type_info, 0);
		g_once_init_leave (&clocks_utils_wall_clock_type_id__volatile, clocks_utils_wall_clock_type_id);
	}
	return clocks_utils_wall_clock_type_id__volatile;
}


static void _vala_clocks_utils_wall_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	switch (property_id) {
		case CLOCKS_UTILS_WALL_CLOCK_DATE_TIME:
		g_value_set_boxed (value, clocks_utils_wall_clock_get_date_time (self));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_TIMEZONE:
		g_value_set_pointer (value, clocks_utils_wall_clock_get_timezone (self));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_FORMAT:
		g_value_set_enum (value, clocks_utils_wall_clock_get_format (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_utils_wall_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksUtilsWallClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_UTILS_TYPE_WALL_CLOCK, ClocksUtilsWallClock);
	switch (property_id) {
		case CLOCKS_UTILS_WALL_CLOCK_DATE_TIME:
		clocks_utils_wall_clock_set_date_time (self, g_value_get_boxed (value));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_TIMEZONE:
		clocks_utils_wall_clock_set_timezone (self, g_value_get_pointer (value));
		break;
		case CLOCKS_UTILS_WALL_CLOCK_FORMAT:
		clocks_utils_wall_clock_set_format (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType clocks_utils_weekdays_day_get_type (void) {
	static volatile gsize clocks_utils_weekdays_day_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_utils_weekdays_day_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_UTILS_WEEKDAYS_DAY_MON, "CLOCKS_UTILS_WEEKDAYS_DAY_MON", "mon"}, {CLOCKS_UTILS_WEEKDAYS_DAY_TUE, "CLOCKS_UTILS_WEEKDAYS_DAY_TUE", "tue"}, {CLOCKS_UTILS_WEEKDAYS_DAY_WED, "CLOCKS_UTILS_WEEKDAYS_DAY_WED", "wed"}, {CLOCKS_UTILS_WEEKDAYS_DAY_THU, "CLOCKS_UTILS_WEEKDAYS_DAY_THU", "thu"}, {CLOCKS_UTILS_WEEKDAYS_DAY_FRI, "CLOCKS_UTILS_WEEKDAYS_DAY_FRI", "fri"}, {CLOCKS_UTILS_WEEKDAYS_DAY_SAT, "CLOCKS_UTILS_WEEKDAYS_DAY_SAT", "sat"}, {CLOCKS_UTILS_WEEKDAYS_DAY_SUN, "CLOCKS_UTILS_WEEKDAYS_DAY_SUN", "sun"}, {0, NULL, NULL}};
		GType clocks_utils_weekdays_day_type_id;
		clocks_utils_weekdays_day_type_id = g_enum_register_static ("ClocksUtilsWeekdaysDay", values);
		g_once_init_leave (&clocks_utils_weekdays_day_type_id__volatile, clocks_utils_weekdays_day_type_id);
	}
	return clocks_utils_weekdays_day_type_id__volatile;
}


ClocksUtilsWeekdaysDay clocks_utils_weekdays_get_first_weekday (void) {
	ClocksUtilsWeekdaysDay result = 0;
	gint d = 0;
	gint _tmp0_ = 0;
	_tmp0_ = clocks_cutils_get_week_start ();
	d = _tmp0_;
	result = (ClocksUtilsWeekdaysDay) ((d + 6) % 7);
	return result;
}


gchar* clocks_utils_weekdays_plural (ClocksUtilsWeekdaysDay d) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ClocksUtilsWeekdaysDay _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	ClocksUtilsWeekdaysDay _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp1_ = d;
	if (_tmp1_ >= 0) {
		ClocksUtilsWeekdaysDay _tmp2_ = 0;
		_tmp2_ = d;
		_tmp0_ = _tmp2_ < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "d >= 0 && d < 7");
	_tmp4_ = d;
	_tmp5_ = CLOCKS_UTILS_WEEKDAYS_plurals[_tmp4_];
	_tmp6_ = _ (_tmp5_);
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}


gchar* clocks_utils_weekdays_abbreviation (ClocksUtilsWeekdaysDay d) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ClocksUtilsWeekdaysDay _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	ClocksUtilsWeekdaysDay _tmp28_ = 0;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	_tmp1_ = d;
	if (_tmp1_ >= 0) {
		ClocksUtilsWeekdaysDay _tmp2_ = 0;
		_tmp2_ = d;
		_tmp0_ = _tmp2_ < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "d >= 0 && d < 7");
	_tmp4_ = clocks_utils_weekdays_abbreviations;
	_tmp4__length1 = clocks_utils_weekdays_abbreviations_length1;
	if (_tmp4_ == NULL) {
		GDateTime* _tmp5_ = NULL;
		GDateTime* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GDateTime* _tmp8_ = NULL;
		GDateTime* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GDateTime* _tmp11_ = NULL;
		GDateTime* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		GDateTime* _tmp14_ = NULL;
		GDateTime* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GDateTime* _tmp17_ = NULL;
		GDateTime* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		GDateTime* _tmp20_ = NULL;
		GDateTime* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GDateTime* _tmp23_ = NULL;
		GDateTime* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		_tmp5_ = g_date_time_new_utc (1, 1, 1, 0, 0, (gdouble) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_date_time_format (_tmp6_, "%a");
		_tmp8_ = g_date_time_new_utc (1, 1, 2, 0, 0, (gdouble) 0);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_date_time_format (_tmp9_, "%a");
		_tmp11_ = g_date_time_new_utc (1, 1, 3, 0, 0, (gdouble) 0);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_date_time_format (_tmp12_, "%a");
		_tmp14_ = g_date_time_new_utc (1, 1, 4, 0, 0, (gdouble) 0);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_date_time_format (_tmp15_, "%a");
		_tmp17_ = g_date_time_new_utc (1, 1, 5, 0, 0, (gdouble) 0);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_date_time_format (_tmp18_, "%a");
		_tmp20_ = g_date_time_new_utc (1, 1, 6, 0, 0, (gdouble) 0);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_date_time_format (_tmp21_, "%a");
		_tmp23_ = g_date_time_new_utc (1, 1, 7, 0, 0, (gdouble) 0);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_date_time_format (_tmp24_, "%a");
		_tmp26_ = g_new0 (gchar*, 7 + 1);
		_tmp26_[0] = _tmp7_;
		_tmp26_[1] = _tmp10_;
		_tmp26_[2] = _tmp13_;
		_tmp26_[3] = _tmp16_;
		_tmp26_[4] = _tmp19_;
		_tmp26_[5] = _tmp22_;
		_tmp26_[6] = _tmp25_;
		clocks_utils_weekdays_abbreviations = (_vala_array_free (clocks_utils_weekdays_abbreviations, clocks_utils_weekdays_abbreviations_length1, (GDestroyNotify) g_free), NULL);
		clocks_utils_weekdays_abbreviations = _tmp26_;
		clocks_utils_weekdays_abbreviations_length1 = 7;
		_clocks_utils_weekdays_abbreviations_size_ = clocks_utils_weekdays_abbreviations_length1;
		_g_date_time_unref0 (_tmp24_);
		_g_date_time_unref0 (_tmp21_);
		_g_date_time_unref0 (_tmp18_);
		_g_date_time_unref0 (_tmp15_);
		_g_date_time_unref0 (_tmp12_);
		_g_date_time_unref0 (_tmp9_);
		_g_date_time_unref0 (_tmp6_);
	}
	_tmp27_ = clocks_utils_weekdays_abbreviations;
	_tmp27__length1 = clocks_utils_weekdays_abbreviations_length1;
	_tmp28_ = d;
	_tmp29_ = _tmp27_[_tmp28_];
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	return result;
}


ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type) {
	ClocksUtilsWeekdays* self = NULL;
	self = (ClocksUtilsWeekdays*) g_type_create_instance (object_type);
	return self;
}


ClocksUtilsWeekdays* clocks_utils_weekdays_new (void) {
	return clocks_utils_weekdays_construct (CLOCKS_UTILS_TYPE_WEEKDAYS);
}


static gboolean clocks_utils_weekdays_days_equal (ClocksUtilsWeekdays* self, gboolean* d, int d_length1) {
	gboolean result = FALSE;
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gboolean* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = d;
	_tmp0__length1 = d_length1;
	_vala_assert (_tmp0__length1 == 7, "d.length == 7");
	_tmp1_ = d;
	_tmp1__length1 = d_length1;
	_tmp2_ = self->priv->days;
	_tmp2__length1 = self->priv->days_length1;
	_tmp3_ = self->priv->days;
	_tmp3__length1 = self->priv->days_length1;
	_tmp4_ = memcmp (_tmp1_, _tmp2_, (gsize) (_tmp3__length1 * sizeof (gboolean)));
	result = _tmp4_ == 0;
	return result;
}


gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ClocksUtilsWeekdaysDay _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	ClocksUtilsWeekdaysDay _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = d;
	if (_tmp1_ >= 0) {
		ClocksUtilsWeekdaysDay _tmp2_ = 0;
		_tmp2_ = d;
		_tmp0_ = _tmp2_ < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "d >= 0 && d < 7");
	_tmp4_ = self->priv->days;
	_tmp4__length1 = self->priv->days_length1;
	_tmp5_ = d;
	_tmp6_ = _tmp4_[_tmp5_];
	result = _tmp6_;
	return result;
}


void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self, ClocksUtilsWeekdaysDay d, gboolean on) {
	gboolean _tmp0_ = FALSE;
	ClocksUtilsWeekdaysDay _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	ClocksUtilsWeekdaysDay _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = d;
	if (_tmp1_ >= 0) {
		ClocksUtilsWeekdaysDay _tmp2_ = 0;
		_tmp2_ = d;
		_tmp0_ = _tmp2_ < 7;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "d >= 0 && d < 7");
	_tmp4_ = self->priv->days;
	_tmp4__length1 = self->priv->days_length1;
	_tmp5_ = d;
	_tmp6_ = on;
	_tmp4_[_tmp5_] = _tmp6_;
	_tmp7_ = _tmp4_[_tmp5_];
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar* clocks_utils_weekdays_get_label (ClocksUtilsWeekdays* self) {
	gchar* result = NULL;
	gchar* r = NULL;
	gint n = 0;
	gint first = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	n = 0;
	first = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gboolean _tmp5_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 7)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = clocks_utils_weekdays_get (self, (ClocksUtilsWeekdaysDay) _tmp4_);
				if (_tmp5_) {
					gint _tmp6_ = 0;
					gint _tmp8_ = 0;
					_tmp6_ = first;
					if (_tmp6_ < 0) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						first = _tmp7_;
					}
					_tmp8_ = n;
					n = _tmp8_ + 1;
				}
			}
		}
	}
	_tmp9_ = n;
	if (_tmp9_ == 0) {
		gchar* _tmp10_ = NULL;
		_tmp10_ = g_strdup ("");
		_g_free0 (r);
		r = _tmp10_;
	} else {
		gint _tmp11_ = 0;
		_tmp11_ = n;
		if (_tmp11_ == 1) {
			gint _tmp12_ = 0;
			gchar* _tmp13_ = NULL;
			_tmp12_ = first;
			_tmp13_ = clocks_utils_weekdays_plural ((ClocksUtilsWeekdaysDay) _tmp12_);
			_g_free0 (r);
			r = _tmp13_;
		} else {
			gint _tmp14_ = 0;
			_tmp14_ = n;
			if (_tmp14_ == 7) {
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp15_ = _ ("Every Day");
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (r);
				r = _tmp16_;
			} else {
				gboolean _tmp17_ = FALSE;
				_tmp17_ = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_weekdays, G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_weekdays));
				if (_tmp17_) {
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp18_ = _ ("Weekdays");
					_tmp19_ = g_strdup (_tmp18_);
					_g_free0 (r);
					r = _tmp19_;
				} else {
					gboolean _tmp20_ = FALSE;
					_tmp20_ = clocks_utils_weekdays_days_equal (self, CLOCKS_UTILS_WEEKDAYS_weekends, G_N_ELEMENTS (CLOCKS_UTILS_WEEKDAYS_weekends));
					if (_tmp20_) {
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						_tmp21_ = _ ("Weekends");
						_tmp22_ = g_strdup (_tmp21_);
						_g_free0 (r);
						r = _tmp22_;
					} else {
						gchar** abbrs = NULL;
						gchar** _tmp23_ = NULL;
						gint abbrs_length1 = 0;
						gint _abbrs_size_ = 0;
						gchar** _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gchar* _tmp36_ = NULL;
						_tmp23_ = g_new0 (gchar*, 0 + 1);
						abbrs = _tmp23_;
						abbrs_length1 = 0;
						_abbrs_size_ = abbrs_length1;
						{
							gint i = 0;
							i = 0;
							{
								gboolean _tmp24_ = FALSE;
								_tmp24_ = TRUE;
								while (TRUE) {
									gboolean _tmp25_ = FALSE;
									gint _tmp27_ = 0;
									ClocksUtilsWeekdaysDay d = 0;
									ClocksUtilsWeekdaysDay _tmp28_ = 0;
									gint _tmp29_ = 0;
									ClocksUtilsWeekdaysDay _tmp30_ = 0;
									gboolean _tmp31_ = FALSE;
									_tmp25_ = _tmp24_;
									if (!_tmp25_) {
										gint _tmp26_ = 0;
										_tmp26_ = i;
										i = _tmp26_ + 1;
									}
									_tmp24_ = FALSE;
									_tmp27_ = i;
									if (!(_tmp27_ < 7)) {
										break;
									}
									_tmp28_ = clocks_utils_weekdays_get_first_weekday ();
									_tmp29_ = i;
									d = (_tmp28_ + _tmp29_) % 7;
									_tmp30_ = d;
									_tmp31_ = clocks_utils_weekdays_get (self, _tmp30_);
									if (_tmp31_) {
										gchar** _tmp32_ = NULL;
										gint _tmp32__length1 = 0;
										ClocksUtilsWeekdaysDay _tmp33_ = 0;
										gchar* _tmp34_ = NULL;
										_tmp32_ = abbrs;
										_tmp32__length1 = abbrs_length1;
										_tmp33_ = d;
										_tmp34_ = clocks_utils_weekdays_abbreviation (_tmp33_);
										_vala_array_add1 (&abbrs, &abbrs_length1, &_abbrs_size_, _tmp34_);
									}
								}
							}
						}
						_tmp35_ = abbrs;
						_tmp35__length1 = abbrs_length1;
						_tmp36_ = g_strjoinv (", ", _tmp35_);
						_g_free0 (r);
						r = _tmp36_;
						abbrs = (_vala_array_free (abbrs, abbrs_length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
		}
	}
	result = r;
	return result;
}


GVariant* clocks_utils_weekdays_serialize (ClocksUtilsWeekdays* self) {
	GVariant* result = NULL;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp0_ = NULL;
	GVariantType* _tmp1_ = NULL;
	GVariantBuilder* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_ = NULL;
	gint32 i = 0;
	gboolean* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GVariantBuilder* _tmp9_ = NULL;
	GVariant* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("ai");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	i = (gint32) 1;
	_tmp4_ = self->priv->days;
	_tmp4__length1 = self->priv->days_length1;
	{
		gboolean* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp4_;
		d_collection_length1 = _tmp4__length1;
		for (d_it = 0; d_it < _tmp4__length1; d_it = d_it + 1) {
			gboolean d = FALSE;
			d = d_collection[d_it];
			{
				gboolean _tmp5_ = FALSE;
				gint32 _tmp8_ = 0;
				_tmp5_ = d;
				if (_tmp5_) {
					GVariantBuilder* _tmp6_ = NULL;
					gint32 _tmp7_ = 0;
					_tmp6_ = builder;
					_tmp7_ = i;
					g_variant_builder_add (_tmp6_, "i", _tmp7_, NULL);
				}
				_tmp8_ = i;
				i = _tmp8_ + 1;
			}
		}
	}
	_tmp9_ = builder;
	_tmp10_ = g_variant_builder_end (_tmp9_);
	g_variant_ref_sink (_tmp10_);
	result = _tmp10_;
	_g_variant_builder_unref0 (builder);
	return result;
}


ClocksUtilsWeekdays* clocks_utils_weekdays_deserialize (GVariant* days_variant) {
	ClocksUtilsWeekdays* result = NULL;
	ClocksUtilsWeekdays* d = NULL;
	ClocksUtilsWeekdays* _tmp0_ = NULL;
	g_return_val_if_fail (days_variant != NULL, NULL);
	_tmp0_ = clocks_utils_weekdays_new ();
	d = _tmp0_;
	{
		GVariantIter* _v_it = NULL;
		GVariant* _tmp1_ = NULL;
		GVariantIter* _tmp2_ = NULL;
		GVariant* v = NULL;
		_tmp1_ = days_variant;
		_tmp2_ = g_variant_iter_new (_tmp1_);
		_v_it = _tmp2_;
		while (TRUE) {
			GVariantIter* _tmp3_ = NULL;
			GVariant* _tmp4_ = NULL;
			GVariant* _tmp5_ = NULL;
			gint32 i = 0;
			GVariant* _tmp6_ = NULL;
			gint32 _tmp7_ = 0;
			gboolean _tmp8_ = FALSE;
			gint32 _tmp9_ = 0;
			gboolean _tmp11_ = FALSE;
			_tmp3_ = _v_it;
			_tmp4_ = g_variant_iter_next_value (_tmp3_);
			_g_variant_unref0 (v);
			v = _tmp4_;
			_tmp5_ = v;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			_tmp6_ = v;
			_tmp7_ = g_variant_get_int32 (_tmp6_);
			i = _tmp7_;
			_tmp9_ = i;
			if (_tmp9_ > ((gint32) 0)) {
				gint32 _tmp10_ = 0;
				_tmp10_ = i;
				_tmp8_ = _tmp10_ <= ((gint32) 7);
			} else {
				_tmp8_ = FALSE;
			}
			_tmp11_ = _tmp8_;
			if (_tmp11_) {
				ClocksUtilsWeekdays* _tmp12_ = NULL;
				gint32 _tmp13_ = 0;
				_tmp12_ = d;
				_tmp13_ = i;
				clocks_utils_weekdays_set (_tmp12_, (ClocksUtilsWeekdaysDay) (_tmp13_ - 1), TRUE);
			} else {
				gint32 _tmp14_ = 0;
				_tmp14_ = i;
				g_warning ("utils.vala:289: Invalid days %d", (gint) _tmp14_);
			}
		}
		_g_variant_unref0 (v);
		_g_variant_iter_free0 (_v_it);
	}
	result = d;
	return result;
}


gboolean clocks_utils_weekdays_get_empty (ClocksUtilsWeekdays* self) {
	gboolean result;
	gboolean* _tmp0_ = NULL;
	gboolean* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_new0 (gboolean, 7);
	_tmp0_[0] = FALSE;
	_tmp0_[1] = FALSE;
	_tmp0_[2] = FALSE;
	_tmp0_[3] = FALSE;
	_tmp0_[4] = FALSE;
	_tmp0_[5] = FALSE;
	_tmp0_[6] = FALSE;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 7;
	_tmp2_ = clocks_utils_weekdays_days_equal (self, _tmp1_, 7);
	_tmp3_ = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp3_;
	return result;
}


static void clocks_utils_value_weekdays_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void clocks_utils_value_weekdays_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		clocks_utils_weekdays_unref (value->data[0].v_pointer);
	}
}


static void clocks_utils_value_weekdays_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = clocks_utils_weekdays_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer clocks_utils_value_weekdays_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* clocks_utils_value_weekdays_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ClocksUtilsWeekdays* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = clocks_utils_weekdays_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* clocks_utils_value_weekdays_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ClocksUtilsWeekdays** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = clocks_utils_weekdays_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ClocksUtilsParamSpecWeekdays* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CLOCKS_UTILS_TYPE_WEEKDAYS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer clocks_utils_value_get_weekdays (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS), NULL);
	return value->data[0].v_pointer;
}


void clocks_utils_value_set_weekdays (GValue* value, gpointer v_object) {
	ClocksUtilsWeekdays* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CLOCKS_UTILS_TYPE_WEEKDAYS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		clocks_utils_weekdays_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		clocks_utils_weekdays_unref (old);
	}
}


void clocks_utils_value_take_weekdays (GValue* value, gpointer v_object) {
	ClocksUtilsWeekdays* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CLOCKS_UTILS_TYPE_WEEKDAYS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CLOCKS_UTILS_TYPE_WEEKDAYS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		clocks_utils_weekdays_unref (old);
	}
}


static void clocks_utils_weekdays_class_init (ClocksUtilsWeekdaysClass * klass) {
	clocks_utils_weekdays_parent_class = g_type_class_peek_parent (klass);
	CLOCKS_UTILS_WEEKDAYS_CLASS (klass)->finalize = clocks_utils_weekdays_finalize;
	g_type_class_add_private (klass, sizeof (ClocksUtilsWeekdaysPrivate));
}


static void clocks_utils_weekdays_instance_init (ClocksUtilsWeekdays * self) {
	gboolean* _tmp0_ = NULL;
	self->priv = CLOCKS_UTILS_WEEKDAYS_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gboolean, 7);
	_tmp0_[0] = FALSE;
	_tmp0_[1] = FALSE;
	_tmp0_[2] = FALSE;
	_tmp0_[3] = FALSE;
	_tmp0_[4] = FALSE;
	_tmp0_[5] = FALSE;
	_tmp0_[6] = FALSE;
	self->priv->days = _tmp0_;
	self->priv->days_length1 = 7;
	self->priv->_days_size_ = self->priv->days_length1;
	self->ref_count = 1;
}


static void clocks_utils_weekdays_finalize (ClocksUtilsWeekdays* obj) {
	ClocksUtilsWeekdays * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays);
	self->priv->days = (g_free (self->priv->days), NULL);
}


GType clocks_utils_weekdays_get_type (void) {
	static volatile gsize clocks_utils_weekdays_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_utils_weekdays_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { clocks_utils_value_weekdays_init, clocks_utils_value_weekdays_free_value, clocks_utils_value_weekdays_copy_value, clocks_utils_value_weekdays_peek_pointer, "p", clocks_utils_value_weekdays_collect_value, "p", clocks_utils_value_weekdays_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsWeekdaysClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_weekdays_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsWeekdays), 0, (GInstanceInitFunc) clocks_utils_weekdays_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType clocks_utils_weekdays_type_id;
		clocks_utils_weekdays_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ClocksUtilsWeekdays", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&clocks_utils_weekdays_type_id__volatile, clocks_utils_weekdays_type_id);
	}
	return clocks_utils_weekdays_type_id__volatile;
}


gpointer clocks_utils_weekdays_ref (gpointer instance) {
	ClocksUtilsWeekdays* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void clocks_utils_weekdays_unref (gpointer instance) {
	ClocksUtilsWeekdays* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CLOCKS_UTILS_WEEKDAYS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid, const gchar* title, const gchar* msg) {
	ClocksUtilsBell * self = NULL;
	GSettings* _tmp0_ = NULL;
	ca_context* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (soundid != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (msg != NULL, NULL);
	self = (ClocksUtilsBell*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.sound");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp2_ = ca_context_create (&_tmp1_);
	_ca_context_destroy0 (self->priv->canberra);
	self->priv->canberra = _tmp1_;
	if (_tmp2_ < 0) {
		g_warning ("utils.vala:309: Sound will not be available");
		_ca_context_destroy0 (self->priv->canberra);
		self->priv->canberra = NULL;
	}
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "theme-name");
	_g_free0 (self->priv->soundtheme);
	self->priv->soundtheme = _tmp4_;
	_tmp5_ = soundid;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->sound);
	self->priv->sound = _tmp6_;
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = NULL;
	_tmp8_ = notify_is_initted ();
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = notify_init ("GNOME Clocks");
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		NotifyNotification* _tmp13_ = NULL;
		NotifyNotification* _tmp14_ = NULL;
		_tmp11_ = title;
		_tmp12_ = msg;
		_tmp13_ = notify_notification_new (_tmp11_, _tmp12_, "gnome-clocks");
		_g_object_unref0 (self->priv->notification);
		self->priv->notification = _tmp13_;
		_tmp14_ = self->priv->notification;
		notify_notification_set_hint_string (_tmp14_, "desktop-entry", "gnome-clocks");
	} else {
		g_warning ("utils.vala:321: Could not initialize notification");
	}
	return self;
}


ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid, const gchar* title, const gchar* msg) {
	return clocks_utils_bell_construct (CLOCKS_UTILS_TYPE_BELL, soundid, title, msg);
}


static gboolean _clocks_utils_bell_keep_ringing_gsource_func (gpointer self) {
	gboolean result;
	result = clocks_utils_bell_keep_ringing (self);
	return result;
}


static void __lambda28_ (ClocksUtilsBell* self, ca_context* c, guint32 id, gint code) {
	gint _tmp0_ = 0;
	g_return_if_fail (c != NULL);
	_tmp0_ = code;
	if (_tmp0_ == CA_SUCCESS) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _clocks_utils_bell_keep_ringing_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void ___lambda28__ca_finishcallback (ca_context* c, guint32 id, gint code, gpointer self) {
	__lambda28_ (self, c, id, code);
}


static gboolean clocks_utils_bell_keep_ringing (ClocksUtilsBell* self) {
	gboolean result = FALSE;
	ca_proplist* pl = NULL;
	ca_proplist* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ca_context* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	ca_proplist_create (&_tmp0_);
	_ca_proplist_destroy0 (pl);
	pl = _tmp0_;
	_tmp1_ = self->priv->sound;
	ca_proplist_sets (pl, CA_PROP_EVENT_ID, _tmp1_);
	_tmp2_ = self->priv->soundtheme;
	ca_proplist_sets (pl, CA_PROP_CANBERRA_XDG_THEME_NAME, _tmp2_);
	ca_proplist_sets (pl, CA_PROP_MEDIA_ROLE, "alarm");
	_tmp3_ = self->priv->canberra;
	ca_context_play_full (_tmp3_, (guint32) 1, pl, ___lambda28__ca_finishcallback, self);
	result = FALSE;
	_ca_proplist_destroy0 (pl);
	return result;
}


static void clocks_utils_bell_ring_real (ClocksUtilsBell* self, gboolean once) {
	ca_context* _tmp0_ = NULL;
	NotifyNotification* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->canberra;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = once;
		if (_tmp1_) {
			ca_context* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			_tmp2_ = self->priv->canberra;
			_tmp3_ = self->priv->sound;
			_tmp4_ = self->priv->soundtheme;
			ca_context_play (_tmp2_, (guint32) 1, CA_PROP_EVENT_ID, _tmp3_, CA_PROP_CANBERRA_XDG_THEME_NAME, _tmp4_, CA_PROP_MEDIA_ROLE, "alarm", NULL);
		} else {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _clocks_utils_bell_keep_ringing_gsource_func, g_object_ref (self), g_object_unref);
		}
	}
	_tmp5_ = self->priv->notification;
	if (_tmp5_ != NULL) {
		{
			NotifyNotification* _tmp6_ = NULL;
			_tmp6_ = self->priv->notification;
			notify_notification_show (_tmp6_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = _error_;
			_tmp8_ = _tmp7_->message;
			g_warning ("utils.vala:357: %s", _tmp8_);
			_g_error_free0 (_error_);
		}
		__finally6:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void clocks_utils_bell_ring_once (ClocksUtilsBell* self) {
	g_return_if_fail (self != NULL);
	clocks_utils_bell_ring_real (self, TRUE);
}


void clocks_utils_bell_ring (ClocksUtilsBell* self) {
	g_return_if_fail (self != NULL);
	clocks_utils_bell_ring_real (self, FALSE);
}


void clocks_utils_bell_stop (ClocksUtilsBell* self) {
	ca_context* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->canberra;
	if (_tmp0_ != NULL) {
		ca_context* _tmp1_ = NULL;
		_tmp1_ = self->priv->canberra;
		ca_context_cancel (_tmp1_, (guint32) 1);
	}
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		ClocksUtilsBell * self;
		self = _data6_->self;
		(_data6_->callback_target_destroy_notify == NULL) ? NULL : (_data6_->callback_target_destroy_notify (_data6_->callback_target), NULL);
		_data6_->callback = NULL;
		_data6_->callback_target = NULL;
		_data6_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void ___lambda29_ (Block6Data* _data6_, NotifyNotification* n, const gchar* a) {
	ClocksUtilsBell * self;
	ClocksUtilsBellActionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data6_->self;
	g_return_if_fail (n != NULL);
	g_return_if_fail (a != NULL);
	_tmp0_ = _data6_->callback;
	_tmp0__target = _data6_->callback_target;
	_tmp0_ (_tmp0__target);
}


static void ____lambda29__notify_action_callback (NotifyNotification* notification, const gchar* action, gpointer self) {
	___lambda29_ (self, notification, action);
}


void clocks_utils_bell_add_action (ClocksUtilsBell* self, const gchar* action, const gchar* label, ClocksUtilsBellActionCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify) {
	Block6Data* _data6_;
	ClocksUtilsBellActionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	NotifyNotification* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (label != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = callback;
	_tmp0__target = callback_target;
	(_data6_->callback_target_destroy_notify == NULL) ? NULL : (_data6_->callback_target_destroy_notify (_data6_->callback_target), NULL);
	_data6_->callback = NULL;
	_data6_->callback_target = NULL;
	_data6_->callback_target_destroy_notify = NULL;
	_data6_->callback = _tmp0_;
	_data6_->callback_target = _tmp0__target;
	_data6_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp1_ = self->priv->notification;
	if (_tmp1_ != NULL) {
		NotifyNotification* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->notification;
		_tmp3_ = action;
		_tmp4_ = label;
		notify_notification_add_action (_tmp2_, _tmp3_, _tmp4_, ____lambda29__notify_action_callback, block6_data_ref (_data6_), block6_data_unref);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void clocks_utils_bell_class_init (ClocksUtilsBellClass * klass) {
	clocks_utils_bell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksUtilsBellPrivate));
	G_OBJECT_CLASS (klass)->finalize = clocks_utils_bell_finalize;
}


static void clocks_utils_bell_instance_init (ClocksUtilsBell * self) {
	self->priv = CLOCKS_UTILS_BELL_GET_PRIVATE (self);
}


static void clocks_utils_bell_finalize (GObject* obj) {
	ClocksUtilsBell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell);
	_g_object_unref0 (self->priv->settings);
	_ca_context_destroy0 (self->priv->canberra);
	_g_free0 (self->priv->soundtheme);
	_g_free0 (self->priv->sound);
	_g_object_unref0 (self->priv->notification);
	G_OBJECT_CLASS (clocks_utils_bell_parent_class)->finalize (obj);
}


GType clocks_utils_bell_get_type (void) {
	static volatile gsize clocks_utils_bell_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_utils_bell_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksUtilsBellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_utils_bell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksUtilsBell), 0, (GInstanceInitFunc) clocks_utils_bell_instance_init, NULL };
		GType clocks_utils_bell_type_id;
		clocks_utils_bell_type_id = g_type_register_static (G_TYPE_OBJECT, "ClocksUtilsBell", &g_define_type_info, 0);
		g_once_init_leave (&clocks_utils_bell_type_id__volatile, clocks_utils_bell_type_id);
	}
	return clocks_utils_bell_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



