// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

/* This file is part of the GMOD package */

#ifndef __structsH
#define __structsH

struct noteInfo
{
  unsigned char note;
  unsigned char sample;
  unsigned char command[2];
  unsigned char parm1[2], parm2[2];
};

struct voiceInfo
{
  short position;		/* for "pattern-loop" command */
  short pattern;		/* for "pattern-loop" command */
  unsigned char loopTimes;	/* for "pattern-loop" command */
  unsigned char lastInfo;
};

struct effectInfo
{
  short pattern;		/* position in pattern for jumps, etc */
  short position;		/* position in song for jumps, etc */
  unsigned char delayNotes;	/* for "pattern delay" command */
  unsigned char loopChan;	/* for "pattern loop" command */
};

struct songInfo
{
  short nrTracks;
  short songlength;
  unsigned int nrSamples;
  unsigned int nrPatterns;
  unsigned char type;
  unsigned char nrChannels;
  unsigned char lowestNote;
  unsigned char highestNote;
  unsigned char playSpeed;
  unsigned char tempo;
  unsigned char volType;
  unsigned char volOnZero;
  unsigned char slideType;
  unsigned char panning[MAX_TRACK];
  unsigned char globalVol;
  unsigned char clockSpeed;
  unsigned char commentLineLen;
  char name[NAME_LEN];
  char desc[DESC_LEN];
  char *comment;
};

struct optionsInfo
{
  unsigned char mainVolume;
#ifndef USE_X
  unsigned char loopBreaker;
#endif
  unsigned char showEmptySamples;
  unsigned char bpmTempos;
  unsigned char compress;
  unsigned char tolerant;
  unsigned char repeat;
  unsigned char ntsc;
  unsigned char mixer;
  unsigned char extendOct;
  unsigned char randomize;
  signed char panFactor;
  unsigned char use_50hz;
  unsigned char checkMagic;
};

struct xStruct
{
  char **fileStrings;
  int nrFileStrings;
};

#endif
