/* dbus.h
 *
 * Copyright 2024 Christopher Talbot
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gio/gio.h>

#define GEOCLUE_STUMBLER_SERVICE     "org.kop316.geoclue_stumbler_http"
#define GEOCLUE_STUMBLER_PATH        "/org/kop316/geoclue_stumbler_http"

#define GEOCLUE_STUMBLER_SERVICE_INTERFACE   GEOCLUE_STUMBLER_SERVICE ".Service"

GDBusConnection *geoclue_stumbler_dbus_get_connection (void);
GDBusNodeInfo   *geoclue_stumbler_dbus_get_introspection_data (void);
void __geoclue_stumbler_dbus_set_connection (GDBusConnection *conn);
void __geoclue_stumbler_dbus_set_introspection_data (void);
void __geoclue_stumbler_dbus_unref_introspection_data (void);

/* ---------------------------------------------------------------------------------------------------- */

/*
 * GIO Dbus Server modified from here:
 * https://gitlab.gnome.org/GNOME/glib/-/blob/master/gio/tests/gdbus-example-server.c
 */

/* Introspection data for the service we are exporting */
static const gchar introspection_xml[] =
  "<node>"
  "  <interface name='org.kop316.geoclue_stumbler_http.Service'>"
  "    <method name='SubmitSubmissions'>"
  "      <arg type='s' name='property' direction='in'/>"
  "      <arg type='v' name='value' direction='in'/>"
  "    </method>"
  "    <signal name='SubmissionAdded'>"
  "      <arg type='s' name='name'/>"
  "      <arg type='v' name='value'/>"
  "    </signal>"
  "    <signal name='UploadError'>"
  "    </signal>"
  "    <signal name='UploadSuccess'>"
  "    </signal>"
  "  </interface>"
  "</node>";

/* ---------------------------------------------------------------------------------------------------- */
