#
# Class for a recurrence rule.
#
class RRule:

    DAY = 0
    WEEK = 1
    MONTH = 2
    YEAR = 3

    SECOND = 4
    MIN = 5
    HOUR = 6

    MONTHDAY = 7
    YEARDAY = 8
    WEEKNO = 9
    SETPOS = 10


    def __init__(self):

        self.__interval = 1
        self.__freq = None
        self.__count = 0
        self.__until = None
        self.__deltas = {}
        self.__by = {}



    def set_interval(self, interval): self.__interval = interval
    def get_interval(self): return self.__interval

    def set_frequency(self, freq): self.__freq = freq
    def get_frequency(self): return self.__freq

    def set_count(self, c): self.__count = c
    def get_count(self): return self.__count

    def set_until(self, date): self.__until = date
    def get_until(self): return self.__until

    def set_delta(self, key, value): self.__deltas[key] = value
    def get_delta(self, key):
        return self.__deltas.get(key, 0) * self.__interval

    def set_by(self, key, value): self.__by[key] = value
    def get_by(self, key): return self.__by.get(key, [])
