// { dg-do run { target c++11 } }
// { dg-require-effective-target rtti }

// 2010-09-22  Paolo Carlini  <paolo.carlini@oracle.com>
//
// Copyright (C) 2010-2023 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

#include <typeindex>
#include <testsuite_hooks.h>

#define TEST3(TI1, TI2, TO1, TO2)               \
  VERIFY( (TI1 == TI2) == (TO1 == TO2) );       \
  VERIFY( (TI1 != TI2) == (TO1 != TO2) );	\
  VERIFY( (TI1 < TI2) == (TO1.before(TO2)) );   \
  VERIFY( (TI1 <= TI2) == (!TO2.before(TO1)) ); \
  VERIFY( (TI1 > TI2) == (TO2.before(TO1)) );	\
  VERIFY( (TI1 >= TI2) == (!TO1.before(TO2)) );

#define TEST2(TI, TO)	  \
  TEST3(TI, ti1, TO, to1) \
  TEST3(TI, ti2, TO, to2) \
  TEST3(TI, ti3, TO, to3) \
  TEST3(TI, ti4, TO, to4) \
  TEST3(TI, ti5, TO, to5) \
  TEST3(TI, ti6, TO, to6) \
  TEST3(TI, ti7, TO, to7)

#define TEST      \
  TEST2(ti1, to1) \
  TEST2(ti2, to2) \
  TEST2(ti3, to3) \
  TEST2(ti4, to4) \
  TEST2(ti5, to5) \
  TEST2(ti6, to6) \
  TEST2(ti7, to7)

void test01()
{
  using namespace std;

  class Abraca { };
  Abraca a1, a2_;
  const Abraca a2 = a2_;

  const type_info& to1 = typeid(int);
  const type_index ti1(to1);

  const type_info& to2 = typeid(double);
  const type_index ti2(to2);

  const type_info& to3 = typeid(Abraca);
  const type_index ti3(to3);

  const type_info& to4 = typeid(const Abraca);
  const type_index ti4(to4);

  const type_info& to5 = typeid(const Abraca&);
  const type_index ti5(to5);

  const type_info& to6 = typeid(a1);
  const type_index ti6(to6);

  const type_info& to7 = typeid(a2);
  const type_index ti7(to7);

  TEST
}

int main()
{
  test01();
  return 0;
}
