/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.Complex;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.ModelVector;

public class ComplexVector
implements ModelVector {
    public Complex base;
    public Complex v;

    public ComplexVector() {
        this(null, null);
    }

    public ComplexVector(Complex complex, Complex complex2) {
        if (complex == null) {
            complex = new Complex();
        }
        if (complex2 == null) {
            complex2 = new Complex();
        }
        this.base = complex;
        this.v = complex2;
    }

    public void setBase(ModelPoint modelPoint) {
        this.base = (Complex)modelPoint;
        this.v = new Complex();
    }

    public ModelPoint getBase() {
        return this.base;
    }

    public void scale(double d) {
        this.v.real *= d;
        this.v.imag *= d;
    }

    public void setTo(ModelVector modelVector) {
        this.base.real = ((ComplexVector)modelVector).base.real;
        this.base.imag = ((ComplexVector)modelVector).base.imag;
        this.v.real = ((ComplexVector)modelVector).v.real;
        this.v.imag = ((ComplexVector)modelVector).v.imag;
    }

    public Object clone() {
        return new ComplexVector((Complex)this.base.clone(), (Complex)this.v.clone());
    }

    public String toString() {
        return "(" + this.base + ";" + this.v + ")";
    }
}

