/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.visualnet;

import hypergraph.graphApi.Graph;
import hypergraph.graphApi.GraphEvent;
import hypergraph.graphApi.GraphListener;
import hypergraph.graphApi.Node;
import hypergraph.graphApi.algorithms.GraphUtilities;
import hypergraph.visualnet.GenericMDSLayout;
import java.util.Iterator;
import java.util.Set;

public class ForceDirectedWeight
implements GenericMDSLayout.MDSWeight,
GraphListener {
    private double connectedDisparity;
    private double repulsingForce;
    private double repulsingForceCutOff;
    private Graph graph;
    private Set connectedComponents;
    private double cut = 1.0;

    public void setGraph(Graph graph) {
        this.graph = graph;
        graph.addGraphListener(this);
    }

    private Set getConnectedComponent(Node node) {
        if (this.connectedComponents == null) {
            this.connectedComponents = GraphUtilities.getConnectedComponents(this.graph);
        }
        Iterator iterator = this.connectedComponents.iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            if (!set.contains(node)) continue;
            return set;
        }
        return null;
    }

    public double getWeight(Node node) {
        return 1.0;
    }

    public double getWeight(Node node, Node node2, double d) {
        if (this.graph.isConnected(node, node2)) {
            return (d - this.getConnectedDisparity()) * (d - this.getConnectedDisparity());
        }
        if (this.getConnectedComponent(node).contains(node2)) {
            if (d < this.getRepulsingForceCutOff()) {
                return this.getRepulsingForce() / d - this.getRepulsingForce() / this.getRepulsingForceCutOff();
            }
        } else if (d < this.cut) {
            return this.getRepulsingForce() / d - this.getRepulsingForce() / this.cut;
        }
        return 0.0;
    }

    public double getWeightDerivative(Node node, Node node2, double d) {
        if (this.graph.isConnected(node, node2)) {
            return 2.0 * (d - this.getConnectedDisparity());
        }
        if (this.getConnectedComponent(node).contains(node2) ? d < this.getRepulsingForceCutOff() : d < this.cut) {
            return -this.getRepulsingForce() / (d * d);
        }
        return 0.0;
    }

    public double getRepulsingForce() {
        return this.repulsingForce;
    }

    public void setRepulsingForce(double d) {
        this.repulsingForce = d;
    }

    public double getRepulsingForceCutOff() {
        return this.repulsingForceCutOff;
    }

    public void setRepulsingForceCutOff(double d) {
        this.repulsingForceCutOff = d;
    }

    public double getConnectedDisparity() {
        return this.connectedDisparity;
    }

    public void setConnectedDisparity(double d) {
        this.connectedDisparity = d;
    }

    public void elementsAdded(GraphEvent graphEvent) {
        this.connectedComponents = null;
    }

    public void elementsRemoved(GraphEvent graphEvent) {
        this.connectedComponents = null;
    }

    public void structureChanged(GraphEvent graphEvent) {
        this.connectedComponents = null;
    }
}

