/* ambientlight.c generated by valac 0.16.1, the Vala compiler
 * generated from ambientlight.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <freesmartphone.h>
#include <fsoframework.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <time.h>


#define AMBIENT_LIGHT_TYPE_N900 (ambient_light_n900_get_type ())
#define AMBIENT_LIGHT_N900(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AMBIENT_LIGHT_TYPE_N900, AmbientLightN900))
#define AMBIENT_LIGHT_N900_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AMBIENT_LIGHT_TYPE_N900, AmbientLightN900Class))
#define AMBIENT_LIGHT_IS_N900(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AMBIENT_LIGHT_TYPE_N900))
#define AMBIENT_LIGHT_IS_N900_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AMBIENT_LIGHT_TYPE_N900))
#define AMBIENT_LIGHT_N900_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AMBIENT_LIGHT_TYPE_N900, AmbientLightN900Class))

typedef struct _AmbientLightN900 AmbientLightN900;
typedef struct _AmbientLightN900Class AmbientLightN900Class;
typedef struct _AmbientLightN900Private AmbientLightN900Private;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AmbientLightN900GetAmbientLightBrightnessData AmbientLightN900GetAmbientLightBrightnessData;

struct _AmbientLightN900 {
	FsoFrameworkAbstractObject parent_instance;
	AmbientLightN900Private * priv;
};

struct _AmbientLightN900Class {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _AmbientLightN900Private {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	gchar* luxnode;
	gint maxvalue;
	gint minvalue;
};

struct _AmbientLightN900GetAmbientLightBrightnessData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AmbientLightN900* self;
	gint brightness;
	gint timestamp;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint lux;
	time_t _tmp5_;
	gint t;
};


static gpointer ambient_light_n900_parent_class = NULL;
static FreeSmartphoneDeviceAmbientLightIface* ambient_light_n900_free_smartphone_device_ambient_light_parent_iface = NULL;
static GType ambient_light_n900_type_id = 0;

#define AMBIENT_LIGHT_DEFAULT_NODE "class/i2c-adapter/i2c-2/2-0029/"
#define AMBIENT_LIGHT_DARKNESS 0
#define AMBIENT_LIGHT_SUNLIGHT 100
GType ambient_light_n900_get_type (void) G_GNUC_CONST;
GType ambient_light_n900_register_type (GTypeModule * module);
#define AMBIENT_LIGHT_N900_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), AMBIENT_LIGHT_TYPE_N900, AmbientLightN900Private))
enum  {
	AMBIENT_LIGHT_N900_DUMMY_PROPERTY
};
AmbientLightN900* ambient_light_n900_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
AmbientLightN900* ambient_light_n900_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static gchar* ambient_light_n900_real_repr (FsoFrameworkAbstractObject* base);
static gint _ambient_light_n900_valueToPercent (AmbientLightN900* self, gint value);
static void ambient_light_n900_real_get_ambient_light_brightness_data_free (gpointer _data);
static void ambient_light_n900_real_get_ambient_light_brightness (FreeSmartphoneDeviceAmbientLight* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean ambient_light_n900_real_get_ambient_light_brightness_co (AmbientLightN900GetAmbientLightBrightnessData* _data_);
static void ambient_light_n900_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


AmbientLightN900* ambient_light_n900_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	AmbientLightN900 * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	FsoFrameworkSubsystem* _tmp13_;
	FsoFrameworkLogger* _tmp14_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (AmbientLightN900*) fso_framework_abstract_object_construct (object_type);
	self->priv->minvalue = AMBIENT_LIGHT_DARKNESS;
	self->priv->maxvalue = AMBIENT_LIGHT_SUNLIGHT;
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = sysfsnode;
	_tmp5_ = g_strconcat (_tmp4_, "/lux", NULL);
	_g_free0 (self->priv->luxnode);
	self->priv->luxnode = _tmp5_;
	_tmp6_ = self->priv->luxnode;
	_tmp7_ = fso_framework_file_handling_isPresent (_tmp6_);
	if (!_tmp7_) {
		FsoFrameworkLogger* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp8_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp9_ = self->priv->luxnode;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Sysfs class is damaged, missing ", _tmp10_, "; skipping.", NULL);
		_tmp12_ = _tmp11_;
		fso_framework_logger_error (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
		return self;
	}
	_tmp13_ = subsystem;
	fso_framework_subsystem_registerObjectForServiceWithPrefix (_tmp13_, FREE_SMARTPHONE_DEVICE_TYPE_AMBIENT_LIGHT, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, FSO_FRAMEWORK_DEVICE_AmbientLightServicePath, (FreeSmartphoneDeviceAmbientLight*) self);
	_tmp14_ = ((FsoFrameworkAbstractObject*) self)->logger;
	fso_framework_logger_info (_tmp14_, "Created");
	return self;
}


AmbientLightN900* ambient_light_n900_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return ambient_light_n900_construct (AMBIENT_LIGHT_TYPE_N900, subsystem, sysfsnode);
}


static gchar* ambient_light_n900_real_repr (FsoFrameworkAbstractObject* base) {
	AmbientLightN900 * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (AmbientLightN900*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static gint _ambient_light_n900_valueToPercent (AmbientLightN900* self, gint value) {
	gint result = 0;
	gint _tmp0_;
	gdouble v;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = value;
	v = (gdouble) _tmp0_;
	_tmp1_ = self->priv->maxvalue;
	_tmp2_ = self->priv->minvalue;
	_tmp3_ = self->priv->minvalue;
	result = (gint) ((100.0 / (_tmp1_ - _tmp2_)) * (v - _tmp3_));
	return result;
}


static void ambient_light_n900_real_get_ambient_light_brightness_data_free (gpointer _data) {
	AmbientLightN900GetAmbientLightBrightnessData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AmbientLightN900GetAmbientLightBrightnessData, _data_);
}


static void ambient_light_n900_real_get_ambient_light_brightness (FreeSmartphoneDeviceAmbientLight* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AmbientLightN900 * self;
	AmbientLightN900GetAmbientLightBrightnessData* _data_;
	AmbientLightN900* _tmp0_;
	self = (AmbientLightN900*) base;
	_data_ = g_slice_new0 (AmbientLightN900GetAmbientLightBrightnessData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, ambient_light_n900_real_get_ambient_light_brightness);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, ambient_light_n900_real_get_ambient_light_brightness_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	ambient_light_n900_real_get_ambient_light_brightness_co (_data_);
}


static void ambient_light_n900_real_get_ambient_light_brightness_finish (FreeSmartphoneDeviceAmbientLight* base, GAsyncResult* _res_, gint* brightness, gint* timestamp, GError** error) {
	AmbientLightN900GetAmbientLightBrightnessData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (brightness) {
		*brightness = _data_->brightness;
	}
	if (timestamp) {
		*timestamp = _data_->timestamp;
	}
}


static gboolean ambient_light_n900_real_get_ambient_light_brightness_co (AmbientLightN900GetAmbientLightBrightnessData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->luxnode;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = fso_framework_file_handling_read (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = 0;
	_data_->_tmp3_ = atoi (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->lux = _data_->_tmp4_;
	_data_->brightness = _data_->lux;
	_data_->_tmp5_ = time (NULL);
	_data_->t = (gint) _data_->_tmp5_;
	_data_->timestamp = _data_->t;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ambient_light_n900_class_init (AmbientLightN900Class * klass) {
	ambient_light_n900_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AmbientLightN900Private));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = ambient_light_n900_real_repr;
	G_OBJECT_CLASS (klass)->finalize = ambient_light_n900_finalize;
}


static void ambient_light_n900_free_smartphone_device_ambient_light_interface_init (FreeSmartphoneDeviceAmbientLightIface * iface) {
	ambient_light_n900_free_smartphone_device_ambient_light_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_ambient_light_brightness = (void (*)(FreeSmartphoneDeviceAmbientLight*, gint*, gint*, GError**)) ambient_light_n900_real_get_ambient_light_brightness;
	iface->get_ambient_light_brightness_finish = ambient_light_n900_real_get_ambient_light_brightness_finish;
}


static void ambient_light_n900_instance_init (AmbientLightN900 * self) {
	self->priv = AMBIENT_LIGHT_N900_GET_PRIVATE (self);
}


static void ambient_light_n900_finalize (GObject* obj) {
	AmbientLightN900 * self;
	self = AMBIENT_LIGHT_N900 (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	_g_free0 (self->priv->luxnode);
	G_OBJECT_CLASS (ambient_light_n900_parent_class)->finalize (obj);
}


GType ambient_light_n900_get_type (void) {
	return ambient_light_n900_type_id;
}


GType ambient_light_n900_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (AmbientLightN900Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ambient_light_n900_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AmbientLightN900), 0, (GInstanceInitFunc) ambient_light_n900_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_ambient_light_info = { (GInterfaceInitFunc) ambient_light_n900_free_smartphone_device_ambient_light_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ambient_light_n900_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "AmbientLightN900", &g_define_type_info, 0);
	g_type_module_add_interface (module, ambient_light_n900_type_id, FREE_SMARTPHONE_DEVICE_TYPE_AMBIENT_LIGHT, &free_smartphone_device_ambient_light_info);
	return ambient_light_n900_type_id;
}



