from pubnub.callbacks import SubscribeCallback
from pubnub.enums import PNStatusCategory
from pubnub.pnconfiguration import PNConfiguration
from pubnub.pubnub import PubNub

pnconfig = PNConfiguration()

pnconfig.subscribe_key = "sub-c-a41be4e8-b620-11e5-a916-0619f8945a4f"
pnconfig.publish_key = "pub-c-b525a8c0-3301-432e-a37b-d8fec5583788"
pnconfig.subscribe_key = "demo"
pnconfig.publish_key = "demo"

pubnub = PubNub(pnconfig)


def my_publish_callback(envelope, status):
    # Check whether request successfully completed or not
    if not status.is_error():
        pass  # Message successfully published to specified channel.
    else:
        pass  # Handle message publish error. Check 'category' property to find out possible issue


# because of which request did fail.
# Request can be resent using: [status retry];


class MySubscribeCallback(SubscribeCallback):
    def presence(self, pubnub, presence):
        pass  # handle incoming presence data

    def status(self, pubnub, status):
        print("Status category", status.category)
        if status.category == PNStatusCategory.PNUnexpectedDisconnectCategory:
            pass  # This event happens when radio / connectivity is lost

        elif status.category == PNStatusCategory.PNConnectedCategory:
            # Connect event. You can do stuff like publish, and know you'll get it.
            # Or just use the connected event to confirm you are subscribed for
            # UI / internal notifications, etc
            pubnub.publish().channel("someChannel").message("Hi...").pn_async(
                my_publish_callback
            )
        elif status.category == PNStatusCategory.PNReconnectedCategory:
            pass
        # Happens as part of our regular operation. This event happens when
        # radio / connectivity is lost, then regained.
        elif status.category == PNStatusCategory.PNDecryptionErrorCategory:
            pass
            # Handle message decryption error. Probably client configured to

    # encrypt messages and on live data feed it received plain text.

    def message(self, pubnub, message):
        # Handle new message stored in message.message
        print(message)
        pubnub.unsubscribe().channels("someChannel").execute()


pubnub.add_listener(MySubscribeCallback())
pubnub.subscribe().channels("someChannel").execute()
