use strict;
use warnings;
use Path::Tiny qw/ path /;
use FindBin ();
use lib "$FindBin::Bin/../t/lib";
use FC_Solve::MoveFuncs;

my $move_funcs          = FC_Solve::MoveFuncs::move_funcs();
my $declared_move_funcs = FC_Solve::MoveFuncs::declared_move_funcs();
my $aliases             = FC_Solve::MoveFuncs::aliases();

my $move_funcs_decl =
"fc_solve_solve_for_state_move_func fc_solve_sfs_move_funcs[FCS_MOVE_FUNCS_NUM]";
my $aliases_decl =
    "fcs_move_func_aliases_mapping fc_solve_sfs_move_funcs_aliases[256]";

my $GEN =
    "// This file is generated by gen-move-funcs.pl.\n// Do not edit by hand!";

path('move_funcs_maps.h')->spew_utf8(<<"EOF");
$GEN
#pragma once
#define FCS_MOVE_FUNCS_NUM @{[0+@$move_funcs]}
#define FCS_MOVE_FUNCS_ALIASES_NUM @{[0+keys%$aliases]}

typedef uint8_t fcs_move_func_aliases_mapping;

extern $move_funcs_decl;
extern $aliases_decl;
EOF

sub func_name
{
    my $f = shift;
    my $s = "fc_solve_sfs_$f";
    return
          $f =~ /simple_simon/  ? "WRAP_SIMPSIM($s)"
        : $f =~ /freecell|_fc_/ ? "WRAP_ZEROFC($s)"
        :                         $s;
}

my $move_funcs_string = join( ",\n",
    ( map { "    " . func_name( $_->{'function'} ) } @$move_funcs ) );
my $aliases_string = join(
    ',',
    map {
        my $c = $aliases->{ chr($_) };
        defined($c) ? $declared_move_funcs->{$c} : 0
    } 0 .. ( 256 - 1 )
);
path('move_funcs_maps.c')->spew_utf8(<<"EOF");
$GEN
#include "freecell.h"
#include "simpsim.h"

#ifdef FCS_DISABLE_SIMPLE_SIMON
#define WRAP_SIMPSIM(f) fc_solve_sfs_move_top_stack_cards_to_founds
#else
#define WRAP_SIMPSIM(f) f
#endif

#if MAX_NUM_FREECELLS > 0
#define WRAP_ZEROFC(f) f
#else
#define WRAP_ZEROFC(f) fc_solve_sfs_null_move_func
#endif

$move_funcs_decl =
{
$move_funcs_string
};

$aliases_decl =
{
$aliases_string
};
EOF
