FreeCAD
-------

![screenshot](http://www.freecadweb.org/wiki/images/thumb/7/72/Freecad016_screenshot1.jpg/800px-Freecad016_screenshot1.jpg)

FreeCAD is a general purpose feature-based, parametric 3D modeler for 
CAD, MCAD, CAx, CAE and PLM, aimed directly at mechanical engineering 
and product design but also fits a wider range of uses in engineering, 
such as architecture or other engineering specialties. It is 100% Open 
Source (LGPL2+ license) and extremely modular, allowing for very 
advanced extension and customization.

FreeCAD is based on OpenCasCade, a powerful geometry kernel, features an 
Open Inventor-compliant 3D scene representation model provided by the 
Coin 3D library, and a broad Python API. The interface is built with Qt. 
FreeCAD runs exactly the same way on Windows, Mac OSX, BSD and Linux 
platforms.

Home page:          http://www.freecadweb.org

Documentation wiki: http://www.freecadweb.org/wiki/

Forum:              http://forum.freecadweb.org/

Bug tracker:        http://www.freecadweb.org/tracker/

Git repository:     https://github.com/FreeCAD/FreeCAD

Installing
----------

Precompiled (installable) packages are available for Windows and Mac on the
releases page at https://github.com/FreeCAD/FreeCAD/releases

On most Linux distributions, FreeCAD is directly installable from the 
software center application.

Other options are described at http://www.freecadweb.org/wiki/index.php?title=Download

Build Status <img src="https://cdn.travis-ci.org/images/travis-mascot-150-3791701416eeee8479e23fe4bb7edf4f.png" height="30"/>
------------

| Master | 0.16 |
|:------:|:----:|
|[![Master][freecad-master-status]][travis-branches]|[![0.16][freecad-0.16-status]][travis-branches]|

[freecad-0.16-status]: https://travis-ci.org/FreeCAD/FreeCAD.svg?branch=0.16
[freecad-master-status]: https://travis-ci.org/FreeCAD/FreeCAD.svg?branch=master
[travis-branches]: https://travis-ci.org/FreeCAD/FreeCAD/branches
[travis-builds]: https://travis-ci.org/FreeCAD/FreeCAD/builds

Compiling
---------

Compiling FreeCAD requires installation of several libraries and their 
development files such as OpenCasCADe, Coin and Qt, listed in the 
pages below. Once this is done, FreeCAD can be simply compiled with 
cMake. On Windows, these libraries are bundled and offered by the 
FreeCAD team in a convenience package, on Linux they are usually found 
in your distribution's repositories and on Mac OSX and other platforms 
you will usually need to compile them yourself.

The pages below contain up-to-date build instructions:

For Linux:   http://www.freecadweb.org/wiki/?title=CompileOnUnix

For Windows: http://www.freecadweb.org/wiki/?title=CompileOnWindows

For Mac OSX: http://www.freecadweb.org/wiki/?title=CompileOnMac

For Cygwin:  http://www.freecadweb.org/wiki/?title=CompileOnCygwin

For MinGW:   http://www.freecadweb.org/wiki/?title=CompileOnMinGW

Usage & Getting help
--------------------

The FreeCAD documentation wiki contains a lot of documentation on 
general FreeCAD usage, python scripting, and development. The following
pages might help you get started:

Getting started:    http://www.freecadweb.org/wiki/?title=Getting_started

Features list:      http://www.freecadweb.org/wiki/?title=Feature_list

Frequent questions: http://www.freecadweb.org/wiki/?title=FAQ

Workbenches:        http://www.freecadweb.org/wiki/?title=Workbench_Concept

Scripting:          http://www.freecadweb.org/wiki/?title=Power_users_hub

Development:        http://www.freecadweb.org/wiki/?title=Developer_hub

The FreeCAD forum at http://forum.freecadweb.org is also a great place
to find help and solve specific problems you might encounter when
learning to use FreeCAD.
