/***************************************************************************
 *   Copyright (c) 2009 Jrgen Riegel <juergen.riegel@web.de>              *
 *                                                                         *
 *   This file is part of the FreeCAD CAx development system.              *
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Library General Public           *
 *   License as published by the Free Software Foundation; either          *
 *   version 2 of the License, or (at your option) any later version.      *
 *                                                                         *
 *   This library  is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Library General Public License for more details.                  *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this library; see the file COPYING.LIB. If not,    *
 *   write to the Free Software Foundation, Inc., 59 Temple Place,         *
 *   Suite 330, Boston, MA  02111-1307, USA                                *
 *                                                                         *
 ***************************************************************************/


#ifndef GUI_TASKVIEW_TaskSketcherConstrains_H
#define GUI_TASKVIEW_TaskSketcherConstrains_H

#include <Gui/TaskView/TaskView.h>
#include <Gui/Selection.h>
#include <boost/signals.hpp>

class Ui_TaskSketcherConstrains;

namespace App {
class Property;
}

namespace SketcherGui {

class ViewProviderSketch;

class TaskSketcherConstrains : public Gui::TaskView::TaskBox, public Gui::SelectionObserver
{
    Q_OBJECT

public:
    TaskSketcherConstrains(ViewProviderSketch *sketchView);
    ~TaskSketcherConstrains();

    /// Observer message from the Selection
    void onSelectionChanged(const Gui::SelectionChanges& msg);

    void slotConstraintsChanged(void);

public Q_SLOTS:
    void on_comboBoxFilter_currentIndexChanged(int);
    void on_listWidgetConstraints_itemSelectionChanged(void); 
    void on_listWidgetConstraints_itemActivated(QListWidgetItem *item); 
    //void on_listWidgetConstraints_entered(const QModelIndex &index); 

protected:
    void changeEvent(QEvent *e);
    ViewProviderSketch *sketchView;
    typedef boost::BOOST_SIGNALS_NAMESPACE::connection Connection;
    Connection connectionConstraintsChanged;

private:
    QWidget* proxy;
    Ui_TaskSketcherConstrains* ui;
};

} //namespace SketcherGui

#endif // GUI_TASKVIEW_TASKAPPERANCE_H
