'\" t
.\"     fhist - file history and comparison tools
.\"     Copyright (C) 1993-1995, 1998, 2000, 2008-2010 Peter Miller
.\"
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 3 of the License, or
.\"     (at your option) any later version.
.\"
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\"
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program. If not, see
.\"     <http://www.gnu.org/licenses/>.
.\"
.if n .ftr CW R
.if n .ftr C R
.if n .ftr CB B
.if n .ftr CI I
.TH ReadMe FHist FHist "Reference Manual"
.so etc/version.so
.if n .ad l
.if n .hy 0
.ds n) fhist
.SH NAME
fhist \- file history and comparison tools
.XX "" "The README File"
.br
.if t .ds C) \(co
.if n .ds C) (C)
Copyright \*(C)
.nr d) \n(.d
\*(Y) Peter Miller;
.if '\n(d)'\n(.d' .br
.PP
Portions of this program are
.br
Copyright \*(C) 1990 David I. Bell.
.PP
The
.I fhist
package is distributed under the terms of the
GNU General Public License,
see the
.I LICENSE
section,
below,
for more information.
.br
.ne 2i
.SH DESCRIPTION
The FHist package contains 3 utilities,
a file history tool \[lq]\fIfhist\fP\[rq],
a file comparison tool \[lq]\fIfcomp\fP\[rq], and
a file merging tool \[lq]\fIfmerge\fP\[rq].
All three are bundled together,
because they all use the same minimal-difference algorithm.
.TP 8n
fhist
.br
Keeps track of versions of a file.
It works correctly when given binary files as input.
See
.IR fhist (1)
for more information.
.TP 8n
fcomp
.br
Compares two versions of a file, usually line-for-line textual comparison.
It is capable of comparing two binary files byte-for-byte.
See
.IR fcomp (1)
for more information.
.TP 8n
fmerge
.br
Merges together edits from two descendants of a file.
See
.IR fmerge (1)
for more information.
.PP
The history tool presented here, fhist, is a \fIminimal\fP history tool.
It provides no locking or branching.  This can be useful in contexts
where the configuration management or change control be being provided
by some other tool.
.so lib/en/man1/z_ref.so
.br
.ne 2i
.SH BUILDING
For complete instructions for host to build these programs,
see the
.I BUILDING
file included in this distribution.
.br
.ne 1i
.SH ARCHIVE SITE
The latest version of
.I fhist
is available on the Web from:
.RS
.TS
center,tab(;);
l l s
l l l.
URL:;http://fhist.sourceforge.net/
File:;index.html;# The FHist page.
File:;fhist-\*(v).README;# Description, from the tar file
File:;fhist-\*(v).lsm;# Description, in LSM format
File:;fhist-\*(v).spec;# RedHat package spec
File:;fhist-\*(v).tar.Z;# The complete source.
.TE
.RE
FHist is also carried by sunsite.unc.edu in its Linux archives.
You will be able to find FHist on any of its mirrors.
.RS
.TS
center,tab(;);
l l s
l l l.
URL:;ftp://sunsite.unc.edu/pub/Linux/devel/vc/
File:;fhist-\*(v).README;# Description, from the tar file
File:;fhist-\*(v).lsm;# Description, in LSM format
File:;fhist-\*(v).spec;# RedHat package spec
File:;fhist-\*(v).tar.Z;# The complete source.
.TE
.RE
This site is extensively mirrored around the world, so look for a copy
near you (you will get much better response).
.so lib/en/man1/z_cr.so
.br
.bp
.SH RELEASE NOTES
.XX "" "Release Notes"
For excruciating detail,
and also acknowledgements of those who generously sent me feedback,
please see the
.I etc/CHANGES.\*(v)
file included in this distribution.
.PP
A number of features and bug fixes have been added to
.I fhist
with this release.
A few of them are detailed here:
.so lib/en/readme/new.so
