#!/bin/sh
#
#       fhist - file history and comparison tools
#       Copyright (C) 2005, 2008 Peter Miller
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 3 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program. If not, see
#       <http://www.gnu.org/licenses/>.
#
set -x
here=`pwd`
tmp=/tmp/fhist.check.tarball.$$

fail()
{
    cd $here
    rm -rf $tmp
    exit 1
}

trap "fail" 1 2 3 15

mkdir $tmp

zcat < $1 | ( cd $tmp ; tar xf - )
cd $tmp/fhist*

./configure
test $? -eq 0 || fail

make
test $? -eq 0 || fail

make sure
test $? -eq 0 || fail

cd $here
rm -rf $tmp

exit 0
