/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.SI;
import visad.Unit;
import visad.VisADException;

public class AlbersCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{SI.meter, SI.meter};
    private CoordinateSystem c;
    private double n;
    private double C;
    private double rho0;
    private double lat0;
    private double lon0;
    private double par1;
    private double par2;
    private double false_easting;
    private double false_northing;
    private double R = 6371229.0;

    public AlbersCoordinateSystem(double la0, double lo0, double p1, double p2, double false_easting, double false_northing) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.lat0 = la0 * (Math.PI / 180);
        this.lon0 = lo0 * (Math.PI / 180);
        this.par1 = p1 * (Math.PI / 180);
        this.par2 = p2 * (Math.PI / 180);
        this.false_easting = false_easting;
        this.false_northing = false_northing;
        this.n = (Math.sin(this.par1) + Math.sin(this.par2)) / 2.0;
        this.C = Math.pow(Math.cos(this.par1), 2.0) + 2.0 * this.n * Math.sin(this.par1);
        this.rho0 = this.R * Math.sqrt(this.C - 2.0 * this.n * Math.sin(this.lat0)) / this.n;
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AlbersCoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] latlon = new double[2][tuples[0].length];
        for (int i = 0; i < tuples[0].length; ++i) {
            double x = tuples[0][i] - this.false_easting;
            double y = tuples[1][i] - this.false_northing;
            double rrho0 = this.rho0;
            if (this.n < 0.0) {
                x = -1.0;
                y = -1.0;
                rrho0 = -1.0;
            }
            double yd = rrho0 - y;
            double rho = Math.sqrt(x * x + yd * yd);
            double theta = Math.atan2(x, yd);
            if (this.n < 0.0) {
                rho -= 1.0;
            }
            latlon[0][i] = 57.29577951308232 * Math.asin((this.C - Math.pow(rho * this.n / this.R, 2.0)) / (2.0 * this.n));
            latlon[1][i] = 57.29577951308232 * (theta / this.n + this.lon0);
        }
        return latlon;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("AlbersCoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] xy = new double[2][tuples[0].length];
        for (int i = 0; i < tuples[0].length; ++i) {
            double rho = this.R * Math.sqrt(this.C - 2.0 * this.n * Math.sin(tuples[0][i] * (Math.PI / 180))) / this.n;
            double theta = this.n * (tuples[1][i] * (Math.PI / 180) - this.lon0);
            xy[0][i] = this.false_easting + rho * Math.sin(theta);
            xy[1][i] = this.false_northing + this.rho0 - rho * Math.cos(theta);
        }
        return xy;
    }

    public boolean equals(Object cs) {
        return cs instanceof AlbersCoordinateSystem;
    }

    public static void main(String[] args) {
        try {
            AlbersCoordinateSystem nc = new AlbersCoordinateSystem(23.0, -96.0, 29.5, 45.5, 0.0, 0.0);
            double[][] latlon = new double[2][1];
            double[][] xy = new double[2][1];
            latlon[0][0] = 35.0;
            latlon[1][0] = -75.0;
            xy = nc.fromReference(latlon);
            System.out.println(" ll=35,75 .. x=" + xy[0][0] + " y=" + xy[1][0]);
            latlon = nc.toReference(xy);
            System.out.println(" inverse lat=" + latlon[0][0] + " lon=" + latlon[1][0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

