/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.Set;
import visad.SetException;
import visad.UnimplementedException;
import visad.VisADError;
import visad.VisADException;

public abstract class Delaunay
implements Serializable {
    public int[][] Tri = null;
    public int[][] Vertices = null;
    public int[][] Walk = null;
    public int[][] Edges = null;
    public int NumEdges = 0;
    private boolean nonConvex = false;

    public void setNonConvex() {
        this.nonConvex = true;
    }

    public boolean getNonConvex() {
        return this.nonConvex;
    }

    public Object clone() {
        try {
            return new DelaunayCustom(null, this.Tri, this.Vertices, this.Walk, this.Edges, this.NumEdges);
        }
        catch (VisADException e) {
            throw new VisADError("Delaunay.clone: " + e.toString());
        }
    }

    public static Delaunay factory(float[][] samples, boolean exact) throws VisADException {
        block11: {
            int choice;
            int FAST = 0;
            int CLARKSON = 1;
            int WATSON = 2;
            int dim = samples.length;
            if (dim < 2) {
                throw new VisADException("Delaunay.factory: dimension must be 2 or higher");
            }
            if (dim > 3) {
                choice = CLARKSON;
            } else {
                int nrs = samples[0].length;
                for (int i = 1; i < dim; ++i) {
                    nrs = Math.min(nrs, samples[i].length);
                }
                choice = dim == 2 && !exact && nrs > 10000 ? FAST : (nrs > 3000 ? CLARKSON : WATSON);
            }
            try {
                if (choice == FAST) {
                    DelaunayFast delan = new DelaunayFast(samples);
                    delan.improve(samples, 1);
                    return delan;
                }
                if (choice == CLARKSON) {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                if (choice == WATSON) {
                    DelaunayWatson delan = new DelaunayWatson(samples);
                    return delan;
                }
            }
            catch (Exception e) {
                if (choice == CLARKSON) break block11;
                try {
                    DelaunayClarkson delan = new DelaunayClarkson(samples);
                    return delan;
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static float[][] scale(float[][] samples, float mult, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        for (int i = 1; i < dim; ++i) {
            if (samples[i].length >= nrs) continue;
            nrs = samples[i].length;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i];
                int n = j++;
                fArray[n] = fArray[n] * mult;
            }
        }
        return samp;
    }

    public static float[][] perturb(float[][] samples, float epsilon, boolean copy) {
        int dim = samples.length;
        int nrs = samples[0].length;
        for (int i = 1; i < dim; ++i) {
            if (samples[i].length >= nrs) continue;
            nrs = samples[i].length;
        }
        float[][] samp = copy ? Set.copyFloats(samples) : samples;
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while (j < nrs) {
                float[] fArray = samp[i];
                int n = j++;
                fArray[n] = fArray[n] + (float)((double)(2.0f * epsilon) * (Math.random() - 0.5));
            }
        }
        return samp;
    }

    public boolean test(float[][] samples) {
        return this.test(samples, false);
    }

    public boolean test(float[][] samples, boolean printErrors) {
        int k;
        int k2;
        int j;
        int i;
        int i2;
        int dim = samples.length;
        int dim1 = dim + 1;
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        for (i2 = 1; i2 < dim; ++i2) {
            nrs = Math.min(nrs, samples[i2].length);
        }
        for (i2 = 0; i2 < ntris; ++i2) {
            if (this.Tri[i2].length >= dim1) continue;
            if (printErrors) {
                System.err.println("Delaunay.test: invalid triangulation dimension (Tri[" + i2 + "].length=" + this.Tri[i2].length + "; dim1=" + dim1 + ")");
            }
            return false;
        }
        for (i2 = 0; i2 < ntris; ++i2) {
            for (int j2 = 0; j2 < dim1; ++j2) {
                if (this.Tri[i2][j2] >= 0 && this.Tri[i2][j2] < nrs) continue;
                if (printErrors) {
                    System.err.println("Delaunay.test: illegal triangle vertex (Tri[" + i2 + "][" + j2 + "]=" + this.Tri[i2][j2] + "; nrs=" + nrs + ")");
                }
                return false;
            }
        }
        int[] nverts = new int[nrs];
        for (i = 0; i < nrs; ++i) {
            nverts[i] = 0;
        }
        for (i = 0; i < ntris; ++i) {
            for (j = 0; j < dim1; ++j) {
                int n = this.Tri[i][j];
                nverts[n] = nverts[n] + 1;
            }
        }
        for (i = 0; i < nrs; ++i) {
            if (nverts[i] != 0) continue;
            if (printErrors) {
                System.err.println("Delaunay.test: point not in triangle (nverts[" + i + "]=0)");
            }
            return false;
        }
        for (i = 0; i < ntris; ++i) {
            for (j = i + 1; j < ntris; ++j) {
                boolean[] m = new boolean[dim1];
                for (int mi = 0; mi < dim1; ++mi) {
                    m[mi] = false;
                }
                for (k2 = 0; k2 < dim1; ++k2) {
                    for (int l = 0; l < dim1; ++l) {
                        if (this.Tri[i][k2] != this.Tri[j][l] || m[l]) continue;
                        m[l] = true;
                    }
                }
                boolean mtot = true;
                for (k = 0; k < dim1; ++k) {
                    if (m[k]) continue;
                    mtot = false;
                }
                if (!mtot) continue;
                if (printErrors) {
                    System.err.println("Delaunay.test: duplicate triangles (i=" + i + "; j=" + j + ")");
                }
                return false;
            }
        }
        for (i = 0; i < ntris; ++i) {
            for (j = 0; j < dim1; ++j) {
                if (this.Walk[i][j] == -1) continue;
                boolean found = false;
                for (k2 = 0; k2 < dim1; ++k2) {
                    if (this.Walk[this.Walk[i][j]][k2] != i) continue;
                    found = true;
                }
                if (!found) {
                    if (printErrors) {
                        System.err.println("Delaunay.test: error in Walk array (i=" + i + "; j=" + j + ")");
                    }
                    return false;
                }
                int sb = 0;
                for (k = 0; k < dim1; ++k) {
                    for (int l = 0; l < dim1; ++l) {
                        if (this.Tri[i][k] != this.Tri[this.Walk[i][j]][l]) continue;
                        ++sb;
                    }
                }
                if (sb == dim) continue;
                if (printErrors) {
                    System.err.println("Delaunay.test: error in Walk array (i=" + i + "; j=" + j + "; sb=" + sb + "; dim=" + dim + ")");
                }
                return false;
            }
        }
        return true;
    }

    public void improve(float[][] samples, int pass) throws VisADException {
        int dim = samples.length;
        int dim1 = dim + 1;
        if (this.Tri[0].length != dim1) {
            throw new SetException("Delaunay.improve: samples dimension does not match");
        }
        if (dim > 2) {
            throw new UnimplementedException("Delaunay.improve: dimension must be 2!");
        }
        int ntris = this.Tri.length;
        int nrs = samples[0].length;
        for (int i = 1; i < dim; ++i) {
            nrs = Math.min(nrs, samples[i].length);
        }
        float[] samp0 = samples[0];
        float[] samp1 = samples[1];
        boolean eflipped = false;
        for (int p = 0; p < pass; ++p) {
            eflipped = false;
            boolean[] edge = new boolean[this.NumEdges];
            for (int i = 0; i < this.NumEdges; ++i) {
                edge[i] = true;
            }
            for (int t = 0; t < ntris; ++t) {
                int[] trit = this.Tri[t];
                int[] walkt = this.Walk[t];
                int[] edgest = this.Edges[t];
                for (int e = 0; e < 2; ++e) {
                    int curedge = edgest[e];
                    if (!edge[curedge]) continue;
                    int t2 = walkt[e];
                    if (t2 >= 0) {
                        boolean sig;
                        int[] trit2 = this.Tri[t2];
                        int[] walkt2 = this.Walk[t2];
                        int[] edgest2 = this.Edges[t2];
                        int f = walkt2[0] == t ? 0 : (walkt2[1] == t ? 1 : 2);
                        int A = (e + 2) % 3;
                        int B = (A + 1) % 3;
                        int C = (B + 1) % 3;
                        int D = (f + 2) % 3;
                        float ax = samp0[trit[A]];
                        float ay = samp1[trit[A]];
                        float bx = samp0[trit[B]];
                        float by = samp1[trit[B]];
                        float cx = samp0[trit[C]];
                        float cy = samp1[trit[C]];
                        float dx = samp0[trit2[D]];
                        float dy = samp1[trit2[D]];
                        float abx = ax - bx;
                        float aby = ay - by;
                        float acx = ax - cx;
                        float acy = ay - cy;
                        float dbx = dx - bx;
                        float dby = dy - by;
                        float dcx = dx - cx;
                        float dcy = dy - cy;
                        float Q = abx * acx + aby * acy;
                        float R = dbx * abx + dby * aby;
                        float S = acx * dcx + acy * dcy;
                        float T = dbx * dcx + dby * dcy;
                        boolean QD = abx * acy - aby * acx >= 0.0f;
                        boolean RD = dbx * aby - dby * abx >= 0.0f;
                        boolean SD = acx * dcy - acy * dcx >= 0.0f;
                        boolean TD = dcx * dby - dcy * dbx >= 0.0f;
                        boolean bl = sig = (QD ? 1 : 0) + (RD ? 1 : 0) + (SD ? 1 : 0) + (TD ? 1 : 0) < 2;
                        boolean d = QD == sig ? true : (RD == sig ? false : (SD == sig ? false : (TD == sig ? true : (Q < 0.0f && T < 0.0f || R > 0.0f && S > 0.0f ? true : (R < 0.0f && S < 0.0f || Q > 0.0f && T > 0.0f ? false : (Q < 0.0f ? Q : T) < (R < 0.0f ? R : S))))));
                        if (d) {
                            int i;
                            int val;
                            int e4;
                            int e3;
                            int w4;
                            int w3;
                            eflipped = true;
                            int n1 = trit[A];
                            int n2 = trit[B];
                            int n3 = trit[C];
                            int n4 = trit2[D];
                            int w1 = walkt[A];
                            int w2 = walkt[C];
                            int e1 = edgest[A];
                            int e2 = edgest[C];
                            if (trit2[(D + 1) % 3] == trit[C]) {
                                w3 = walkt2[D];
                                w4 = walkt2[(D + 2) % 3];
                                e3 = edgest2[D];
                                e4 = edgest2[(D + 2) % 3];
                            } else {
                                w3 = walkt2[(D + 2) % 3];
                                w4 = walkt2[D];
                                e3 = edgest2[(D + 2) % 3];
                                e4 = edgest2[D];
                            }
                            trit[0] = n1;
                            trit[1] = n2;
                            trit[2] = n4;
                            trit2[0] = n1;
                            trit2[1] = n4;
                            trit2[2] = n3;
                            walkt[0] = w1;
                            walkt[1] = w4;
                            walkt[2] = t2;
                            walkt2[0] = t;
                            walkt2[1] = w3;
                            walkt2[2] = w2;
                            if (w2 >= 0) {
                                val = this.Walk[w2][0] == t ? 0 : (this.Walk[w2][1] == t ? 1 : 2);
                                this.Walk[w2][val] = t2;
                            }
                            if (w4 >= 0) {
                                val = this.Walk[w4][0] == t2 ? 0 : (this.Walk[w4][1] == t2 ? 1 : 2);
                                this.Walk[w4][val] = t;
                            }
                            edgest[0] = e1;
                            edgest[1] = e4;
                            edgest2[1] = e3;
                            edgest2[2] = e2;
                            int[] vertn1 = this.Vertices[n1];
                            int[] vertn2 = this.Vertices[n2];
                            int[] vertn3 = this.Vertices[n3];
                            int[] vertn4 = this.Vertices[n4];
                            int ln1 = vertn1.length;
                            int ln2 = vertn2.length;
                            int ln3 = vertn3.length;
                            int ln4 = vertn4.length;
                            int[] tn1 = new int[ln1 + 1];
                            int[] tn2 = new int[ln2 - 1];
                            int[] tn3 = new int[ln3 - 1];
                            int[] tn4 = new int[ln4 + 1];
                            System.arraycopy(vertn1, 0, tn1, 0, ln1);
                            tn1[ln1] = t2;
                            int c = 0;
                            for (i = 0; i < ln2; ++i) {
                                if (vertn2[i] == t2) continue;
                                tn2[c++] = vertn2[i];
                            }
                            c = 0;
                            for (i = 0; i < ln3; ++i) {
                                if (vertn3[i] == t) continue;
                                tn3[c++] = vertn3[i];
                            }
                            System.arraycopy(vertn4, 0, tn4, 0, ln4);
                            tn4[ln4] = t;
                            this.Vertices[n1] = tn1;
                            this.Vertices[n2] = tn2;
                            this.Vertices[n3] = tn3;
                            this.Vertices[n4] = tn4;
                        }
                    }
                    edge[curedge] = false;
                }
            }
            if (!eflipped) break;
        }
    }

    public void finish_triang(float[][] samples) throws VisADException {
        block30: {
            int j;
            int i;
            int i2;
            int mdim = this.Tri[0].length - 1;
            int mdim1 = mdim + 1;
            int dim = samples.length;
            int dim1 = dim + 1;
            int ntris = this.Tri.length;
            int nrs = samples[0].length;
            for (i2 = 1; i2 < dim; ++i2) {
                nrs = Math.min(nrs, samples[i2].length);
            }
            if (this.Vertices == null) {
                this.Vertices = new int[nrs][];
                int[] nverts = new int[nrs];
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < mdim1; ++j) {
                        int n = this.Tri[i][j];
                        nverts[n] = nverts[n] + 1;
                    }
                }
                for (i = 0; i < nrs; ++i) {
                    this.Vertices[i] = new int[nverts[i]];
                    nverts[i] = 0;
                }
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < mdim1; ++j) {
                        int n = this.Tri[i][j];
                        int n2 = nverts[n];
                        nverts[n] = n2 + 1;
                        this.Vertices[this.Tri[i][j]][n2] = i;
                    }
                }
            }
            if (this.Walk == null && mdim <= 3) {
                this.Walk = new int[ntris][mdim1];
                for (i2 = 0; i2 < ntris; ++i2) {
                    block7: for (int j2 = 0; j2 < mdim1; ++j2) {
                        int v1 = j2;
                        int v2 = (v1 + 1) % mdim1;
                        this.Walk[i2][j2] = -1;
                        for (int k = 0; k < this.Vertices[this.Tri[i2][v1]].length; ++k) {
                            int temp = this.Vertices[this.Tri[i2][v1]][k];
                            if (temp == i2) continue;
                            for (int l = 0; l < this.Vertices[this.Tri[i2][v2]].length; ++l) {
                                if (mdim == 2) {
                                    if (temp != this.Vertices[this.Tri[i2][v2]][l]) continue;
                                    this.Walk[i2][j2] = temp;
                                    continue block7;
                                }
                                int temp2 = this.Vertices[this.Tri[i2][v2]][l];
                                int v3 = (v2 + 1) % mdim1;
                                if (temp != temp2) continue;
                                for (int m = 0; m < this.Vertices[this.Tri[i2][v3]].length; ++m) {
                                    if (temp != this.Vertices[this.Tri[i2][v3]][m]) continue;
                                    this.Walk[i2][j2] = temp;
                                    continue block7;
                                }
                            }
                        }
                    }
                }
            }
            if (this.Edges != null || mdim > 3) break block30;
            int edim = 3 * (mdim - 1);
            this.Edges = new int[ntris][edim];
            for (i = 0; i < ntris; ++i) {
                for (j = 0; j < edim; ++j) {
                    this.Edges[i][j] = -1;
                }
            }
            this.NumEdges = 0;
            if (mdim == 2) {
                for (i = 0; i < ntris; ++i) {
                    for (j = 0; j < 3; ++j) {
                        if (this.Edges[i][j] >= 0) continue;
                        int othtri = this.Walk[i][j];
                        if (othtri >= 0) {
                            int cside = -1;
                            for (int k = 0; k < 3; ++k) {
                                if (this.Walk[othtri][k] != i) continue;
                                cside = k;
                            }
                            if (cside != -1) {
                                this.Edges[othtri][cside] = this.NumEdges;
                            } else {
                                throw new SetException("Delaunay.finish_triang: error in triangulation!");
                            }
                        }
                        this.Edges[i][j] = this.NumEdges++;
                    }
                }
            } else {
                int[] ptlook1 = new int[]{0, 0, 0, 1, 1, 2};
                int[] ptlook2 = new int[]{1, 2, 3, 2, 3, 3};
                for (int i3 = 0; i3 < ntris; ++i3) {
                    for (int j3 = 0; j3 < 6; ++j3) {
                        if (this.Edges[i3][j3] >= 0) continue;
                        int endpt1 = this.Tri[i3][ptlook1[j3]];
                        int endpt2 = this.Tri[i3][ptlook2[j3]];
                        int[] set = new int[this.Vertices[endpt1].length];
                        int setlen = 0;
                        block18: for (int p1 = 0; p1 < this.Vertices[endpt1].length; ++p1) {
                            int temp = this.Vertices[endpt1][p1];
                            for (int p2 = 0; p2 < this.Vertices[endpt2].length; ++p2) {
                                if (temp != this.Vertices[endpt2][p2]) continue;
                                set[setlen++] = temp;
                                continue block18;
                            }
                        }
                        for (int kk = 0; kk < setlen; ++kk) {
                            int k = set[kk];
                            for (int l = 0; l < edim; ++l) {
                                if ((this.Tri[k][ptlook1[l]] != endpt1 || this.Tri[k][ptlook2[l]] != endpt2) && (this.Tri[k][ptlook1[l]] != endpt2 || this.Tri[k][ptlook2[l]] != endpt1)) continue;
                                this.Edges[k][l] = this.NumEdges;
                            }
                        }
                        this.Edges[i3][j3] = this.NumEdges++;
                    }
                }
            }
        }
    }

    public String toString() {
        return this.sampleString(null);
    }

    public String sampleString(float[][] samples) {
        int j;
        int i;
        StringBuffer s = new StringBuffer("");
        if (samples != null) {
            s.append("\nsamples " + samples[0].length + "\n");
            for (i = 0; i < samples[0].length; ++i) {
                s.append("  " + i + " -> " + samples[0][i] + " " + samples[1][i] + " " + samples[2][i] + "\n");
            }
            s.append("\n");
        }
        s.append("\nTri (triangles -> vertices) " + this.Tri.length + "\n");
        for (i = 0; i < this.Tri.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.Tri[i].length; ++j) {
                s.append(" " + this.Tri[i][j]);
            }
            s.append("\n");
        }
        s.append("\nVertices (vertices -> triangles) " + this.Vertices.length + "\n");
        for (i = 0; i < this.Vertices.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.Vertices[i].length; ++j) {
                s.append(" " + this.Vertices[i][j]);
            }
            s.append("\n");
        }
        s.append("\nWalk (triangles -> triangles) " + this.Walk.length + "\n");
        for (i = 0; i < this.Walk.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.Walk[i].length; ++j) {
                s.append(" " + this.Walk[i][j]);
            }
            s.append("\n");
        }
        s.append("\nEdges (triangles -> global edges) " + this.Edges.length + "\n");
        for (i = 0; i < this.Edges.length; ++i) {
            s.append("  " + i + " -> ");
            for (j = 0; j < this.Edges[i].length; ++j) {
                s.append(" " + this.Edges[i][j]);
            }
            s.append("\n");
        }
        return s.toString();
    }
}

