/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2015 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <fcml_assembler.h>
#include "instructions_p_t.h"
#include "instructions_base_t.h"

fcml_bool fcml_tf_instructions_p_suite_init(void) {
	return FCML_TRUE;
}

fcml_bool fcml_tf_instructions_p_suite_cleanup(void) {
	return FCML_TRUE;
}

void fcml_tf_instruction_PABS(void) {

    FCML_I64( "pabsb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1C, 0x00 );
    FCML_I32( "pabsb mm0,mm1", 0x0F, 0x38, 0x1C, 0xC1 );
    FCML_I64( "pabsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1D, 0x00 );
    FCML_I32( "pabsw mm0,mm1", 0x0F, 0x38, 0x1D, 0xC1 );
    FCML_I64( "pabsd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x1E, 0x00 );
    FCML_I32( "pabsd mm0,mm1", 0x0F, 0x38, 0x1E, 0xC1 );

    FCML_I64( "pabsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1C, 0x00 );
    FCML_I32( "pabsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1C, 0xC1 );
    FCML_I64( "pabsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1D, 0x00 );
    FCML_I32( "pabsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1D, 0xC1 );
    FCML_I64( "pabsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x1E, 0x00 );
    FCML_I32( "pabsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x1E, 0xC1 );

    FCML_I64( "vpabsb xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x1C, 0x00 );
    FCML_I32( "vpabsb xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x1C, 0xC1 );
    FCML_I64( "vpabsw xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x1D, 0x00 );
    FCML_I32( "vpabsw xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x1D, 0xC1 );
    FCML_I64( "vpabsd xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x1E, 0x00 );
    FCML_I32( "vpabsd xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x1E, 0xC1 );

    FCML_I64( "vpabsb ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x1C, 0x00 );
    FCML_I32( "vpabsb ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x1C, 0xC1 );
    FCML_I64( "vpabsw ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x1D, 0x00 );
    FCML_I32( "vpabsw ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x1D, 0xC1 );
    FCML_I64( "vpabsd ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x1E, 0x00 );
    FCML_I32( "vpabsd ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x1E, 0xC1 );

    FCML_A64( "pabsb (%rax),%mm0", 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %mm1,%mm0", 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsw (%rax),%mm0", 0x0f, 0x38, 0x1d, 0x00 );
    FCML_A64( "pabsw %mm1,%mm0", 0x0f, 0x38, 0x1d, 0xc1 );
    FCML_A64( "pabsd (%rax),%mm0", 0x0f, 0x38, 0x1e, 0x00 );
    FCML_A64( "pabsd %mm1,%mm0", 0x0f, 0x38, 0x1e, 0xc1 );
    FCML_A64( "pabsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1d, 0x00 );
    FCML_A64( "pabsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1d, 0xc1 );
    FCML_A64( "pabsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1e, 0x00 );
    FCML_A64( "pabsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1e, 0xc1 );
    FCML_A64( "vpabsb (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x1c, 0x00 );
    FCML_A64( "vpabsb %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x1c, 0xc1 );
    FCML_A64( "vpabsw (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x1d, 0x00 );
    FCML_A64( "vpabsw %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x1d, 0xc1 );
    FCML_A64( "vpabsd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x1e, 0x00 );
    FCML_A64( "vpabsd %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x1e, 0xc1 );
    FCML_A64( "vpabsb (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x1c, 0x00 );
    FCML_A64( "vpabsb %ymm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x1c, 0xc1 );
    FCML_A64( "vpabsw (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x1d, 0x00 );
    FCML_A64( "vpabsw %ymm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x1d, 0xc1 );
    FCML_A64( "vpabsd (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x1e, 0x00 );
    FCML_A64( "vpabsd %ymm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x1e, 0xc1 );
    FCML_A64( "pabsb (%rax),%mm0", 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %mm1,%mm0", 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "pabsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0x00 );
    FCML_A64( "pabsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x1c, 0xc1 );
    FCML_A64( "vpabsb (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x1c, 0x00 );
    FCML_A64( "vpabsb %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x1c, 0xc1 );
    FCML_A64( "vpabsb (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x1c, 0x00 );
    FCML_A64( "vpabsb %ymm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x1c, 0xc1 );
}

void fcml_tf_instruction_PACKSS(void) {

    FCML_I64( "packsswb mm0,mmword ptr [rax]", 0x0F, 0x63, 0x00 );
    FCML_I32( "packsswb mm0,mm1", 0x0F, 0x63, 0xC1 );

    FCML_I64( "packssdw mm0,mmword ptr [rax]", 0x0F, 0x6B, 0x00 );
    FCML_I32( "packssdw mm0,mm1", 0x0F, 0x6B, 0xC1 );

    FCML_I64( "packsswb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x63, 0x00 );
    FCML_I32( "packsswb xmm0,xmm1", 0x66, 0x0F, 0x63, 0xC1 );
    FCML_I64( "packssdw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6b, 0x00 );
    FCML_I32( "packssdw xmm0,xmm1", 0x66, 0x0F, 0x6b, 0xC1 );

    FCML_I64( "vpacksswb xmm0,xmm3,xmmword ptr [rax]", 0xc5, 0xe1, 0x63, 0x00 );
    FCML_I32( "vpacksswb xmm0,xmm3,xmm1", 0xc5, 0xe1, 0x63, 0xc1 );
    FCML_I64( "vpackssdw xmm0,xmm3,xmmword ptr [rax]", 0xc5, 0xe1, 0x6b, 0x00 );
    FCML_I32( "vpackssdw xmm0,xmm3,xmm1", 0xc5, 0xe1, 0x6b, 0xc1 );

    FCML_I64( "vpacksswb ymm0,ymm3,ymmword ptr [rax]", 0xc5, 0xe5, 0x63, 0x00 );
    FCML_I64( "vpackssdw ymm0,ymm3,ymmword ptr [rax]", 0xc5, 0xe5, 0x6b, 0x00 );
    FCML_I32( "vpacksswb ymm0,ymm3,ymm1", 0xc5, 0xe5, 0x63, 0xc1 );
    FCML_I32( "vpackssdw ymm0,ymm3,ymm1", 0xc5, 0xe5, 0x6b, 0xc1 );

    FCML_A64( "packsswb (%rax),%mm0", 0x0f, 0x63, 0x00 );
    FCML_A64( "packsswb %mm1,%mm0", 0x0f, 0x63, 0xc1 );
    FCML_A64( "packssdw (%rax),%mm0", 0x0f, 0x6b, 0x00 );
    FCML_A64( "packssdw %mm1,%mm0", 0x0f, 0x6b, 0xc1 );
    FCML_A64( "packsswb (%rax),%xmm0", 0x66, 0x0f, 0x63, 0x00 );
    FCML_A64( "packsswb %xmm1,%xmm0", 0x66, 0x0f, 0x63, 0xc1 );
    FCML_A64( "vpacksswb (%rax),%xmm3,%xmm0", 0xc5, 0xe1, 0x63, 0x00 );
    FCML_A64( "vpacksswb %xmm1,%xmm3,%xmm0", 0xc5, 0xe1, 0x63, 0xc1 );
    FCML_A64( "vpacksswb (%rax),%ymm3,%ymm0", 0xc5, 0xe5, 0x63, 0x00 );
    FCML_A64( "vpackssdw %ymm1,%ymm3,%ymm0", 0xc5, 0xe5, 0x6b, 0xc1 );
}

void fcml_tf_instruction_PACKUSD(void) {

    FCML_I64( "packusdw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x2B, 0x00 );
    FCML_I32( "packusdw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x2B, 0xC1 );

    FCML_I64( "vpackusdw xmm0,xmm3,xmmword ptr [rax]", 0xC4, 0xE2, 0x61, 0x2B, 0x00 );
    FCML_I32( "vpackusdw xmm0,xmm3,xmm1", 0xC4, 0xE2, 0x61, 0x2B, 0xC1 );

    FCML_I64( "vpackusdw ymm0,ymm3,ymmword ptr [rax]", 0xC4, 0xE2, 0x65, 0x2B, 0x00 );
    FCML_I32( "vpackusdw ymm0,ymm3,ymm1", 0xC4, 0xE2, 0x65, 0x2B, 0xC1 );

    FCML_A64( "packusdw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x2b, 0x00 );
    FCML_A64( "packusdw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x2b, 0xc1 );
    FCML_A64( "vpackusdw (%rax),%xmm3,%xmm0", 0xc4, 0xe2, 0x61, 0x2b, 0x00 );
    FCML_A64( "vpackusdw %xmm1,%xmm3,%xmm0", 0xc4, 0xe2, 0x61, 0x2b, 0xc1 );
    FCML_A64( "vpackusdw (%rax),%ymm3,%ymm0", 0xc4, 0xe2, 0x65, 0x2b, 0x00 );
    FCML_A64( "vpackusdw %ymm1,%ymm3,%ymm0", 0xc4, 0xe2, 0x65, 0x2b, 0xc1 );
}

void fcml_tf_instruction_PACKUSW(void) {

    FCML_I64( "packuswb mm0,mmword ptr [rax]", 0x0F, 0x67, 0x00 );
    FCML_I32( "packuswb mm0,mm1", 0x0F, 0x67, 0xC1 );

    FCML_I64( "packuswb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x67, 0x00 );
    FCML_I32( "packuswb xmm0,xmm1", 0x66, 0x0F, 0x67, 0xC1 );

    FCML_I64( "vpackuswb xmm0,xmm3,xmmword ptr [rax]", 0xc5, 0xe1, 0x67, 0x00 );
    FCML_I32( "vpackuswb xmm0,xmm3,xmm1", 0xc5, 0xe1, 0x67, 0xc1 );

    FCML_I64( "vpackuswb ymm0,ymm3,ymmword ptr [rax]", 0xc5, 0xe5, 0x67, 0x00 );
    FCML_I32( "vpackuswb ymm0,ymm3,ymm1", 0xc5, 0xe5, 0x67, 0xc1 );

    FCML_A64( "packuswb (%rax),%mm0", 0x0f, 0x67, 0x00 );
    FCML_A64( "packuswb %mm1,%mm0", 0x0f, 0x67, 0xc1 );
    FCML_A64( "packuswb (%rax),%xmm0", 0x66, 0x0f, 0x67, 0x00 );
    FCML_A64( "packuswb %xmm1,%xmm0", 0x66, 0x0f, 0x67, 0xc1 );
    FCML_A64( "vpackuswb (%rax),%xmm3,%xmm0", 0xc5, 0xe1, 0x67, 0x00 );
    FCML_A64( "vpackuswb %xmm1,%xmm3,%xmm0", 0xc5, 0xe1, 0x67, 0xc1 );
    FCML_A64( "vpackuswb (%rax),%ymm3,%ymm0", 0xc5, 0xe5, 0x67, 0x00 );
    FCML_A64( "vpackuswb %ymm1,%ymm3,%ymm0", 0xc5, 0xe5, 0x67, 0xc1 );
}

void fcml_tf_instruction_PADD(void) {

    FCML_I64( "paddb mm0,mmword ptr [rax]", 0x0F, 0xFC, 0x00 );
    FCML_I32( "paddb mm0,mm1", 0x0F, 0xFC, 0xC1 );
    FCML_I64( "paddw mm0,mmword ptr [rax]", 0x0F, 0xFD, 0x00 );
    FCML_I32( "paddw mm0,mm1", 0x0F, 0xFD, 0xC1 );
    FCML_I64( "paddd mm0,mmword ptr [rax]", 0x0F, 0xFE, 0x00 );
    FCML_I32( "paddd mm0,mm1", 0x0F, 0xFE, 0xC1 );

    FCML_I64( "paddb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFC, 0x00 );
    FCML_I32( "paddb xmm0,xmm1", 0x66, 0x0F, 0xFC, 0xC1 );
    FCML_I64( "paddw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFD, 0x00 );
    FCML_I32( "paddw xmm0,xmm1", 0x66, 0x0F, 0xFD, 0xC1 );
    FCML_I64( "paddd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFE, 0x00 );
    FCML_I32( "paddd xmm0,xmm1", 0x66, 0x0F, 0xFE, 0xC1 );

    FCML_I64( "vpaddb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xfc, 0x00 );
    FCML_I32( "vpaddb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xfc, 0xc1 );
    FCML_I64( "vpaddw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xfd, 0x00 );
    FCML_I32( "vpaddw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xfd, 0xc1 );
    FCML_I64( "vpaddd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xfe, 0x00 );
    FCML_I32( "vpaddd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xfe, 0xc1 );

    FCML_I64( "vpaddb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xfc, 0x00 );
    FCML_I32( "vpaddb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xfc, 0xc1 );
    FCML_I64( "vpaddw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xfd, 0x00 );
    FCML_I32( "vpaddw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xfd, 0xc1 );
    FCML_I64( "vpaddd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xfe, 0x00 );
    FCML_I32( "vpaddd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xfe, 0xc1 );
    FCML_I64( "vpaddq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xd4, 0x00 );
    FCML_I32( "vpaddq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xd4, 0xc1 );

    FCML_A64( "paddb (%rax),%mm0", 0x0f, 0xfc, 0x00 );
    FCML_A64( "paddb %mm1,%mm0", 0x0f, 0xfc, 0xc1 );
    FCML_A64( "paddw (%rax),%mm0", 0x0f, 0xfd, 0x00 );
    FCML_A64( "paddw %mm1,%mm0", 0x0f, 0xfd, 0xc1 );
    FCML_A64( "paddd (%rax),%mm0", 0x0f, 0xfe, 0x00 );
    FCML_A64( "paddd %mm1,%mm0", 0x0f, 0xfe, 0xc1 );
    FCML_A64( "paddb (%rax),%xmm0", 0x66, 0x0f, 0xfc, 0x00 );
    FCML_A64( "paddb %xmm1,%xmm0", 0x66, 0x0f, 0xfc, 0xc1 );
    FCML_A64( "paddw (%rax),%xmm0", 0x66, 0x0f, 0xfd, 0x00 );
    FCML_A64( "paddw %xmm1,%xmm0", 0x66, 0x0f, 0xfd, 0xc1 );
    FCML_A64( "paddd (%rax),%xmm0", 0x66, 0x0f, 0xfe, 0x00 );
    FCML_A64( "paddd %xmm1,%xmm0", 0x66, 0x0f, 0xfe, 0xc1 );
    FCML_A64( "vpaddb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xfc, 0x00 );
    FCML_A64( "vpaddb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xfc, 0xc1 );
    FCML_A64( "vpaddw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xfd, 0x00 );
    FCML_A64( "vpaddw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xfd, 0xc1 );
    FCML_A64( "vpaddd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xfe, 0x00 );
    FCML_A64( "vpaddd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xfe, 0xc1 );
    FCML_A64( "vpaddb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xfc, 0x00 );
    FCML_A64( "vpaddb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xfc, 0xc1 );
    FCML_A64( "vpaddw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xfd, 0x00 );
    FCML_A64( "vpaddw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xfd, 0xc1 );
    FCML_A64( "vpaddd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xfe, 0x00 );
    FCML_A64( "vpaddd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xfe, 0xc1 );
    FCML_A64( "vpaddq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd4, 0x00 );
    FCML_A64( "vpaddq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd4, 0xc1 );
}

void fcml_tf_instruction_PADDS(void) {

    FCML_I64( "paddsb mm0,mmword ptr [rax]", 0x0F, 0xEC, 0x00 );
    FCML_I32( "paddsb mm0,mm1", 0x0F, 0xEC, 0xC1 );

    FCML_I64( "paddsw mm0,mmword ptr [rax]", 0x0F, 0xED, 0x00 );
    FCML_I32( "paddsw mm0,mm1", 0x0F, 0xED, 0xC1 );

    FCML_I64( "paddsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEC, 0x00 );
    FCML_I32( "paddsb xmm0,xmm1", 0x66, 0x0F, 0xEC, 0xC1 );

    FCML_I64( "paddsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xED, 0x00 );
    FCML_I32( "paddsw xmm0,xmm1", 0x66, 0x0F, 0xED, 0xC1 );

    FCML_I64( "vpaddsb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xec, 0x00 );
    FCML_I32( "vpaddsb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xec, 0xc1 );
    FCML_I64( "vpaddsw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xed, 0x00 );
    FCML_I32( "vpaddsw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xed, 0xc1 );

    FCML_I64( "vpaddsb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xec, 0x00 );
    FCML_I32( "vpaddsb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xec, 0xc1 );
    FCML_I64( "vpaddsw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xed, 0x00 );
    FCML_I32( "vpaddsw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xed, 0xc1 );

    FCML_A64( "paddsb (%rax),%mm0", 0x0f, 0xec, 0x00 );
    FCML_A64( "paddsb %mm1,%mm0", 0x0f, 0xec, 0xc1 );
    FCML_A64( "paddsw (%rax),%mm0", 0x0f, 0xed, 0x00 );
    FCML_A64( "paddsw %mm1,%mm0", 0x0f, 0xed, 0xc1 );
    FCML_A64( "paddsb (%rax),%xmm0", 0x66, 0x0f, 0xec, 0x00 );
    FCML_A64( "paddsb %xmm1,%xmm0", 0x66, 0x0f, 0xec, 0xc1 );
    FCML_A64( "paddsw (%rax),%xmm0", 0x66, 0x0f, 0xed, 0x00 );
    FCML_A64( "paddsw %xmm1,%xmm0", 0x66, 0x0f, 0xed, 0xc1 );
    FCML_A64( "vpaddsb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xec, 0x00 );
    FCML_A64( "vpaddsb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xec, 0xc1 );
    FCML_A64( "vpaddsw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xed, 0x00 );
    FCML_A64( "vpaddsw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xed, 0xc1 );
    FCML_A64( "vpaddsb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xec, 0x00 );
    FCML_A64( "vpaddsb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xec, 0xc1 );
    FCML_A64( "vpaddsw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xed, 0x00 );
    FCML_A64( "vpaddsw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xed, 0xc1 );
}

void fcml_tf_instruction_PADDUS(void) {

    FCML_I64( "paddusb mm0,mmword ptr [rax]", 0x0F, 0xDC, 0x00 );
    FCML_I32( "paddusb mm0,mm1", 0x0F, 0xDC, 0xC1 );

    FCML_I64( "paddusw mm0,mmword ptr [rax]", 0x0F, 0xDD, 0x00 );
    FCML_I32( "paddusw mm0,mm1", 0x0F, 0xDD, 0xC1 );

    FCML_I64( "paddusb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDC, 0x00 );
    FCML_I32( "paddusb xmm0,xmm1", 0x66, 0x0F, 0xDC, 0xC1 );

    FCML_I64( "paddusw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDD, 0x00 );
    FCML_I32( "paddusw xmm0,xmm1", 0x66, 0x0F, 0xDD, 0xC1 );

    FCML_I64( "vpaddusb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xdc, 0x00 );
    FCML_I32( "vpaddusb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xdc, 0xc1 );
    FCML_I64( "vpaddusw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xdd, 0x00 );
    FCML_I32( "vpaddusw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xdd, 0xc1 );

    FCML_I64( "vpaddusb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xdc, 0x00 );
    FCML_I32( "vpaddusb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xdc, 0xc1 );
    FCML_I64( "vpaddusw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xdd, 0x00 );
    FCML_I32( "vpaddusw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xdd, 0xc1 );

    FCML_A64( "paddusb (%rax),%mm0", 0x0f, 0xdc, 0x00 );
    FCML_A64( "paddusb %mm1,%mm0", 0x0f, 0xdc, 0xc1 );
    FCML_A64( "paddusw (%rax),%mm0", 0x0f, 0xdd, 0x00 );
    FCML_A64( "paddusw %mm1,%mm0", 0x0f, 0xdd, 0xc1 );
    FCML_A64( "paddusb (%rax),%xmm0", 0x66, 0x0f, 0xdc, 0x00 );
    FCML_A64( "paddusb %xmm1,%xmm0", 0x66, 0x0f, 0xdc, 0xc1 );
    FCML_A64( "paddusw (%rax),%xmm0", 0x66, 0x0f, 0xdd, 0x00 );
    FCML_A64( "paddusw %xmm1,%xmm0", 0x66, 0x0f, 0xdd, 0xc1 );
    FCML_A64( "vpaddusb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xdc, 0x00 );
    FCML_A64( "vpaddusb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xdc, 0xc1 );
    FCML_A64( "vpaddusw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xdd, 0x00 );
    FCML_A64( "vpaddusw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xdd, 0xc1 );
    FCML_A64( "vpaddusb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xdc, 0x00 );
    FCML_A64( "vpaddusb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xdc, 0xc1 );
    FCML_A64( "vpaddusw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xdd, 0x00 );
    FCML_A64( "vpaddusw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xdd, 0xc1 );
}

void fcml_tf_instruction_PADDQ(void) {

    FCML_I64( "paddq mm0,mmword ptr [rax]", 0x0F, 0xD4, 0x00 );
    FCML_I32( "paddq mm0,mm1", 0x0F, 0xD4, 0xC1 );

    FCML_I64( "paddq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD4, 0x00 );
    FCML_I32( "paddq xmm0,xmm1", 0x66, 0x0F, 0xD4, 0xC1 );

    FCML_I64_D( "vpaddq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE1, 0x79, 0xD4, 0x00 );
    FCML_I32_D( "vpaddq xmm0,xmm0,xmm1", 0xC4, 0xE1, 0x79, 0xD4, 0xC1 );
    FCML_I64( "vpaddq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd4, 0x00 );
    FCML_I32( "vpaddq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd4, 0xc1 );

    FCML_A64( "paddq (%rax),%mm0", 0x0f, 0xd4, 0x00 );
    FCML_A64( "paddq %mm1,%mm0", 0x0f, 0xd4, 0xc1 );
    FCML_A64( "paddq (%rax),%xmm0", 0x66, 0x0f, 0xd4, 0x00 );
    FCML_A64( "paddq %xmm1,%xmm0", 0x66, 0x0f, 0xd4, 0xc1 );
    FCML_A64( "vpaddq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd4, 0x00 );
    FCML_A64( "vpaddq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd4, 0xc1 );
    FCML_A64( "vpaddq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd4, 0x00 );
    FCML_A64( "vpaddq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd4, 0xc1 );
}

void fcml_tf_instruction_PALIGNR(void) {

    FCML_I64( "palignr mm0,mmword ptr [rax],0ffh", 0x0F, 0x3A, 0x0F, 0x00, 0xFF );
    FCML_I32( "palignr mm0,mm1,0ffh", 0x0F, 0x3A, 0x0F, 0xC1, 0xFF );

    FCML_I64( "palignr xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x0F, 0x00, 0xFF );
    FCML_I32( "palignr xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x0F, 0xC1, 0xFF );

    FCML_I64( "vpalignr xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x0F, 0x00, 0xFF );
    FCML_I32( "vpalignr xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x0F, 0xC1, 0xFF );

    FCML_I64( "vpalignr ymm0,ymm0,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x7D, 0x0F, 0x00, 0xFF );
    FCML_I32( "vpalignr ymm0,ymm0,ymm1,0ffh", 0xC4, 0xE3, 0x7D, 0x0F, 0xC1, 0xFF );

    FCML_A64( "palignr $0xff,(%rax),%mm0", 0x0f, 0x3a, 0x0f, 0x00, 0xff );
    FCML_A64( "palignr $0xff,%mm1,%mm0", 0x0f, 0x3a, 0x0f, 0xc1, 0xff );
    FCML_A64( "palignr $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x0f, 0x00, 0xff );
    FCML_A64( "palignr $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x0f, 0xc1, 0xff );
    FCML_A64( "vpalignr $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0f, 0x00, 0xff );
    FCML_A64( "vpalignr $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0f, 0xc1, 0xff );
    FCML_A64( "vpalignr $0xff,(%rax),%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0f, 0x00, 0xff );
    FCML_A64( "vpalignr $0xff,%ymm1,%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0f, 0xc1, 0xff );
}

void fcml_tf_instruction_PAND(void) {

    FCML_I64( "pand mm0,mmword ptr [rax]", 0x0F, 0xDB, 0x00 );
    FCML_I32( "pand mm0,mm1", 0x0F, 0xDB, 0xC1 );

    FCML_I64( "pand xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDB, 0x00 );
    FCML_I32( "pand xmm0,xmm1", 0x66, 0x0F, 0xDB, 0xC1 );

    FCML_I64( "vpand xmm0,xmm2,xmmword ptr [rax]", 0xc5, 0xe9, 0xdb, 0x00 );
    FCML_I32( "vpand xmm0,xmm2,xmm1", 0xc5, 0xe9, 0xdb, 0xc1 );

    FCML_I64( "vpand ymm0,ymm2,ymmword ptr [rax]", 0xc5, 0xed, 0xdb, 0x00 );
    FCML_I32( "vpand ymm0,ymm2,ymm1", 0xc5, 0xed, 0xdb, 0xc1 );

    FCML_A64( "pand (%rax),%mm0", 0x0f, 0xdb, 0x00 );
    FCML_A64( "pand %mm1,%mm0", 0x0f, 0xdb, 0xc1 );
    FCML_A64( "pand (%rax),%xmm0", 0x66, 0x0f, 0xdb, 0x00 );
    FCML_A64( "pand %xmm1,%xmm0", 0x66, 0x0f, 0xdb, 0xc1 );
    FCML_A64( "vpand (%rax),%xmm2,%xmm0", 0xc5, 0xe9, 0xdb, 0x00 );
    FCML_A64( "vpand %xmm1,%xmm2,%xmm0", 0xc5, 0xe9, 0xdb, 0xc1 );
    FCML_A64( "vpand (%rax),%ymm2,%ymm0", 0xc5, 0xed, 0xdb, 0x00 );
    FCML_A64( "vpand %ymm1,%ymm2,%ymm0", 0xc5, 0xed, 0xdb, 0xc1 );
}

void fcml_tf_instruction_PANDN(void) {

    FCML_I64( "pandn mm0,mmword ptr [rax]", 0x0F, 0xDF, 0x00 );
    FCML_I32( "pandn mm0,mm1", 0x0F, 0xDF, 0xC1 );

    FCML_I64( "pandn xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDF, 0x00 );
    FCML_I32( "pandn xmm0,xmm1", 0x66, 0x0F, 0xDF, 0xC1 );

    FCML_I64( "vpandn xmm0,xmm2,xmmword ptr [rax]", 0xc5, 0xe9, 0xdf, 0x00 );
    FCML_I32( "vpandn xmm0,xmm2,xmm1", 0xc5, 0xe9, 0xdf, 0xc1 );

    FCML_I64( "vpandn ymm0,ymm2,ymmword ptr [rax]", 0xc5, 0xed, 0xdf, 0x00 );
    FCML_I32( "vpandn ymm0,ymm2,ymm1", 0xc5, 0xed, 0xdf, 0xc1 );

    FCML_A64( "pandn (%rax),%mm0", 0x0f, 0xdf, 0x00 );
    FCML_A64( "pandn %mm1,%mm0", 0x0f, 0xdf, 0xc1 );
    FCML_A64( "pandn (%rax),%xmm0", 0x66, 0x0f, 0xdf, 0x00 );
    FCML_A64( "pandn %xmm1,%xmm0", 0x66, 0x0f, 0xdf, 0xc1 );
    FCML_A64( "vpandn (%rax),%xmm2,%xmm0", 0xc5, 0xe9, 0xdf, 0x00 );
    FCML_A64( "vpandn %xmm1,%xmm2,%xmm0", 0xc5, 0xe9, 0xdf, 0xc1 );
    FCML_A64( "vpandn (%rax),%ymm2,%ymm0", 0xc5, 0xed, 0xdf, 0x00 );
    FCML_A64( "vpandn %ymm1,%ymm2,%ymm0", 0xc5, 0xed, 0xdf, 0xc1 );

}

void fcml_tf_instruction_PAUSE(void) {

    FCML_I3264( "pause", 0xF3, 0x90 );

    FCML_A64( "pause", 0xf3, 0x90 );

}

void fcml_tf_instruction_PAVGB(void) {

    FCML_I64( "pavgb mm0,mmword ptr [rax]", 0x0F, 0xE0, 0x00 );
    FCML_I32( "pavgb mm0,mm1", 0x0F, 0xE0, 0xC1 );

    FCML_I64( "pavgw mm0,mmword ptr [rax]", 0x0F, 0xE3, 0x00 );
    FCML_I32( "pavgw mm0,mm1", 0x0F, 0xE3, 0xC1 );

    FCML_I64( "pavgb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE0, 0x00 );
    FCML_I32( "pavgb xmm0,xmm1", 0x66, 0x0F, 0xE0, 0xC1 );

    FCML_I64( "pavgw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE3, 0x00 );
    FCML_I32( "pavgw xmm0,xmm1", 0x66, 0x0F, 0xE3, 0xC1 );

    FCML_I64( "vpavgb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe0, 0x00 );
    FCML_I32( "vpavgb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe0, 0xc1 );
    FCML_I64( "vpavgw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe3, 0x00 );
    FCML_I32( "vpavgw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe3, 0xc1 );

    FCML_A64( "pavgb (%rax),%mm0", 0x0f, 0xe0, 0x00 );
    FCML_A64( "pavgb %mm1,%mm0", 0x0f, 0xe0, 0xc1 );
    FCML_A64( "pavgw (%rax),%mm0", 0x0f, 0xe3, 0x00 );
    FCML_A64( "pavgw %mm1,%mm0", 0x0f, 0xe3, 0xc1 );
    FCML_A64( "pavgb (%rax),%xmm0", 0x66, 0x0f, 0xe0, 0x00 );
    FCML_A64( "pavgb %xmm1,%xmm0", 0x66, 0x0f, 0xe0, 0xc1 );
    FCML_A64( "pavgw (%rax),%xmm0", 0x66, 0x0f, 0xe3, 0x00 );
    FCML_A64( "pavgw %xmm1,%xmm0", 0x66, 0x0f, 0xe3, 0xc1 );
    FCML_A64( "vpavgb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe0, 0x00 );
    FCML_A64( "vpavgb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe0, 0xc1 );
    FCML_A64( "vpavgw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe3, 0x00 );
    FCML_A64( "vpavgw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe3, 0xc1 );
}

void fcml_tf_instruction_PBLENDVB(void) {

    FCML_I32( "pblendvb xmm2,xmmword ptr [ecx+eax],xmm0", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_I64( "pblendvb xmm2,xmmword ptr [rcx+rax],xmm0", 0x66, 0x0F, 0x38, 0x10, 0x14, 0x01 );

    FCML_I32( "vpblendvb xmm2,xmm7,xmmword ptr [ecx+eax],xmm2", 0xc4, 0xe3, 0x41, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I32( "vpblendvb xmm2,xmm2,xmmword ptr [ecx+eax],xmm2", 0xc4, 0xe3, 0x69, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I64( "vpblendvb xmm2,xmm2,xmmword ptr [r9+rax],xmm10", 0xC4, 0xC3, 0x69, 0x4C, 0x14, 0x01, 0xA0 );

    FCML_I32( "vpblendvb ymm2,ymm7,ymmword ptr [ecx+eax],ymm2", 0xc4, 0xe3, 0x45, 0x4c, 0x14, 0x01, 0x20 );
    FCML_I64( "vpblendvb ymm2,ymm2,ymmword ptr [r9+rax],ymm10", 0xC4, 0xC3, 0x6D, 0x4C, 0x14, 0x01, 0xA0 );

    FCML_A64( "pblendvb %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_A64( "pblendvb %xmm0,(%rcx,%rax),%xmm2", 0x66, 0x0f, 0x38, 0x10, 0x14, 0x01 );
    FCML_A64( "vpblendvb %xmm2,(%rcx,%rax),%xmm7,%xmm2", 0xc4, 0xe3, 0x41, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %xmm2,(%rcx,%rax),%xmm2,%xmm2", 0xc4, 0xe3, 0x69, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %xmm10,(%r9,%rax),%xmm2,%xmm2", 0xc4, 0xc3, 0x69, 0x4c, 0x14, 0x01, 0xa0 );
    FCML_A64( "vpblendvb %ymm2,(%rcx,%rax),%ymm7,%ymm2", 0xc4, 0xe3, 0x45, 0x4c, 0x14, 0x01, 0x20 );
    FCML_A64( "vpblendvb %ymm10,(%r9,%rax),%ymm2,%ymm2", 0xc4, 0xc3, 0x6d, 0x4c, 0x14, 0x01, 0xa0 );
}

void fcml_tf_instruction_PBLENDW(void) {

    FCML_I64( "pblendw xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x0E, 0x00, 0xFF );
    FCML_I32( "pblendw xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x0E, 0xC1, 0xFF );

    FCML_I64( "vpblendw xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x0E, 0x00, 0xFF );
    FCML_I32( "vpblendw xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x0E, 0xC1, 0xFF );

    FCML_I64( "vpblendw ymm0,ymm0,ymmword ptr [rax],0ffh", 0xC4, 0xE3, 0x7D, 0x0E, 0x00, 0xFF );
    FCML_I32( "vpblendw ymm0,ymm0,ymm1,0ffh", 0xC4, 0xE3, 0x7D, 0x0E, 0xC1, 0xFF );

    FCML_A64( "pblendw $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x0e, 0x00, 0xff );
    FCML_A64( "pblendw $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x0e, 0xc1, 0xff );
    FCML_A64( "vpblendw $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0e, 0x00, 0xff );
    FCML_A64( "vpblendw $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x0e, 0xc1, 0xff );
    FCML_A64( "vpblendw $0xff,(%rax),%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0e, 0x00, 0xff );
    FCML_A64( "vpblendw $0xff,%ymm1,%ymm0,%ymm0", 0xc4, 0xe3, 0x7d, 0x0e, 0xc1, 0xff );
}

void fcml_tf_instruction_PCLMULQDQ(void) {

    FCML_I64( "pclmulqdq xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x44, 0x00, 0xFF );
    FCML_I32( "pclmulqdq xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x44, 0xC1, 0xFF );

    FCML_I64( "vpclmulqdq xmm0,xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x44, 0x00, 0xFF );
    FCML_I32( "vpclmulqdq xmm0,xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x44, 0xC1, 0xFF );

    FCML_A64( "pclmulqdq $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x44, 0x00, 0xff );
    FCML_A64( "pclmulqdq $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x44, 0xc1, 0xff );
    FCML_A64( "vpclmulqdq $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x44, 0x00, 0xff );
    FCML_A64( "vpclmulqdq $0xff,%xmm1,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x44, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPEQ(void) {

    FCML_I64( "pcmpeqb mm0,mmword ptr [rax]", 0x0F, 0x74, 0x00 );
    FCML_I32( "pcmpeqb mm0,mm1", 0x0F, 0x74, 0xC1 );
    FCML_I64( "pcmpeqw mm0,mmword ptr [rax]", 0x0F, 0x75, 0x00 );
    FCML_I32( "pcmpeqw mm0,mm1", 0x0F, 0x75, 0xC1 );
    FCML_I64( "pcmpeqd mm0,mmword ptr [rax]", 0x0F, 0x76, 0x00 );
    FCML_I32( "pcmpeqd mm0,mm1", 0x0F, 0x76, 0xC1 );

    FCML_I64( "pcmpeqb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x74, 0x00 );
    FCML_I32( "pcmpeqb xmm0,xmm1", 0x66, 0x0F, 0x74, 0xC1 );
    FCML_I64( "pcmpeqw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x75, 0x00 );
    FCML_I32( "pcmpeqw xmm0,xmm1", 0x66, 0x0F, 0x75, 0xC1 );
    FCML_I64( "pcmpeqd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x76, 0x00 );
    FCML_I32( "pcmpeqd xmm0,xmm1", 0x66, 0x0F, 0x76, 0xC1 );

    FCML_I64( "vpcmpeqb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x74, 0x00 );
    FCML_I32( "vpcmpeqb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x74, 0xc1 );
    FCML_I64( "vpcmpeqw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x75, 0x00 );
    FCML_I32( "vpcmpeqw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x75, 0xc1 );
    FCML_I64( "vpcmpeqd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x76, 0x00 );
    FCML_I32( "vpcmpeqd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x76, 0xc1 );

    FCML_I64( "vpcmpeqb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x74, 0x00 );
    FCML_I32( "vpcmpeqb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x74, 0xc1 );
    FCML_I64( "vpcmpeqw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x75, 0x00 );
    FCML_I32( "vpcmpeqw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x75, 0xc1 );
    FCML_I64( "vpcmpeqd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x76, 0x00 );
    FCML_I32( "vpcmpeqd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x76, 0xc1 );

    FCML_A64( "pcmpeqb (%rax),%mm0", 0x0f, 0x74, 0x00 );
    FCML_A64( "pcmpeqb %mm1,%mm0", 0x0f, 0x74, 0xc1 );
    FCML_A64( "pcmpeqw (%rax),%mm0", 0x0f, 0x75, 0x00 );
    FCML_A64( "pcmpeqw %mm1,%mm0", 0x0f, 0x75, 0xc1 );
    FCML_A64( "pcmpeqd (%rax),%mm0", 0x0f, 0x76, 0x00 );
    FCML_A64( "pcmpeqd %mm1,%mm0", 0x0f, 0x76, 0xc1 );
    FCML_A64( "pcmpeqb (%rax),%xmm0", 0x66, 0x0f, 0x74, 0x00 );
    FCML_A64( "pcmpeqb %xmm1,%xmm0", 0x66, 0x0f, 0x74, 0xc1 );
    FCML_A64( "pcmpeqw (%rax),%xmm0", 0x66, 0x0f, 0x75, 0x00 );
    FCML_A64( "pcmpeqw %xmm1,%xmm0", 0x66, 0x0f, 0x75, 0xc1 );
    FCML_A64( "pcmpeqd (%rax),%xmm0", 0x66, 0x0f, 0x76, 0x00 );
    FCML_A64( "pcmpeqd %xmm1,%xmm0", 0x66, 0x0f, 0x76, 0xc1 );
    FCML_A64( "vpcmpeqb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x74, 0x00 );
    FCML_A64( "vpcmpeqb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x74, 0xc1 );
    FCML_A64( "vpcmpeqw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x75, 0x00 );
    FCML_A64( "vpcmpeqw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x75, 0xc1 );
    FCML_A64( "vpcmpeqd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x76, 0x00 );
    FCML_A64( "vpcmpeqd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x76, 0xc1 );
    FCML_A64( "vpcmpeqb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x74, 0x00 );
    FCML_A64( "vpcmpeqb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x74, 0xc1 );
    FCML_A64( "vpcmpeqw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x75, 0x00 );
    FCML_A64( "vpcmpeqw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x75, 0xc1 );
    FCML_A64( "vpcmpeqd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x76, 0x00 );
    FCML_A64( "vpcmpeqd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x76, 0xc1 );

}

void fcml_tf_instruction_PCMPEQQ(void) {

    FCML_I64( "pcmpeqq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x29, 0x00 );
    FCML_I32( "pcmpeqq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x29, 0xC1 );

    FCML_I64( "vpcmpeqq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x29, 0x00 );
    FCML_I32( "vpcmpeqq xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x29, 0xC1 );

    FCML_I64( "vpcmpeqq ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x29, 0x00 );
    FCML_I32( "vpcmpeqq ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x29, 0xC1 );

    FCML_A64( "pcmpeqq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x29, 0x00 );
    FCML_A64( "pcmpeqq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x29, 0xc1 );
    FCML_A64( "vpcmpeqq (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x29, 0x00 );
    FCML_A64( "vpcmpeqq %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x29, 0xc1 );
    FCML_A64( "vpcmpeqq (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x29, 0x00 );
    FCML_A64( "vpcmpeqq %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x29, 0xc1 );
}

void fcml_tf_instruction_PCMPESTRI(void) {

    FCML_I64( "pcmpestri xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x61, 0x00, 0xFF );
    FCML_I32( "pcmpestri xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x61, 0xC1, 0xFF );

    FCML_I64( "vpcmpestri xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x61, 0x00, 0xFF );
    FCML_I32( "vpcmpestri xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x61, 0xC1, 0xFF );

    FCML_A64( "pcmpestri $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x61, 0x00, 0xff );
    FCML_A64( "pcmpestri $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x61, 0xc1, 0xff );
    FCML_A64( "vpcmpestri $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x61, 0x00, 0xff );
    FCML_A64( "vpcmpestri $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x61, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPESTRM(void) {

    FCML_I64( "pcmpestrm xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x60, 0x00, 0xFF );
    FCML_I32( "pcmpestrm xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x60, 0xC1, 0xFF );

    FCML_I64( "vpcmpestrm xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x60, 0x00, 0xFF );
    FCML_I32( "vpcmpestrm xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x60, 0xC1, 0xFF );

    FCML_A64( "pcmpestrm $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x60, 0x00, 0xff );
    FCML_A64( "pcmpestrm $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x60, 0xc1, 0xff );
    FCML_A64( "vpcmpestrm $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x60, 0x00, 0xff );
    FCML_A64( "vpcmpestrm $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x60, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPGT(void) {

    FCML_I64( "pcmpgtb mm0,mmword ptr [rax]", 0x0F, 0x64, 0x00 );
    FCML_I32( "pcmpgtb mm0,mm1", 0x0F, 0x64, 0xC1 );
    FCML_I64( "pcmpgtw mm0,mmword ptr [rax]", 0x0F, 0x65, 0x00 );
    FCML_I32( "pcmpgtw mm0,mm1", 0x0F, 0x65, 0xC1 );
    FCML_I64( "pcmpgtd mm0,mmword ptr [rax]", 0x0F, 0x66, 0x00 );
    FCML_I32( "pcmpgtd mm0,mm1", 0x0F, 0x66, 0xC1 );

    FCML_I64( "pcmpgtb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x64, 0x00 );
    FCML_I32( "pcmpgtb xmm0,xmm1", 0x66, 0x0F, 0x64, 0xC1 );
    FCML_I64( "pcmpgtw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x65, 0x00 );
    FCML_I32( "pcmpgtw xmm0,xmm1", 0x66, 0x0F, 0x65, 0xC1 );
    FCML_I64( "pcmpgtd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x66, 0x00 );
    FCML_I32( "pcmpgtd xmm0,xmm1", 0x66, 0x0F, 0x66, 0xC1 );

    FCML_I64( "vpcmpgtb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x64, 0x00 );
    FCML_I32( "vpcmpgtb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x64, 0xc1 );
    FCML_I64( "vpcmpgtw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x65, 0x00 );
    FCML_I32( "vpcmpgtw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x65, 0xc1 );
    FCML_I64( "vpcmpgtd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x66, 0x00 );
    FCML_I32( "vpcmpgtd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x66, 0xc1 );

    FCML_I64( "vpcmpgtb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x64, 0x00 );
    FCML_I32( "vpcmpgtb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x64, 0xc1 );
    FCML_I64( "vpcmpgtw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x65, 0x00 );
    FCML_I32( "vpcmpgtw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x65, 0xc1 );
    FCML_I64( "vpcmpgtd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x66, 0x00 );
    FCML_I32( "vpcmpgtd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x66, 0xc1 );

    FCML_A64( "pcmpgtb (%rax),%mm0", 0x0f, 0x64, 0x00 );
    FCML_A64( "pcmpgtb %mm1,%mm0", 0x0f, 0x64, 0xc1 );
    FCML_A64( "pcmpgtw (%rax),%mm0", 0x0f, 0x65, 0x00 );
    FCML_A64( "pcmpgtw %mm1,%mm0", 0x0f, 0x65, 0xc1 );
    FCML_A64( "pcmpgtd (%rax),%mm0", 0x0f, 0x66, 0x00 );
    FCML_A64( "pcmpgtd %mm1,%mm0", 0x0f, 0x66, 0xc1 );
    FCML_A64( "pcmpgtb (%rax),%xmm0", 0x66, 0x0f, 0x64, 0x00 );
    FCML_A64( "pcmpgtb %xmm1,%xmm0", 0x66, 0x0f, 0x64, 0xc1 );
    FCML_A64( "pcmpgtw (%rax),%xmm0", 0x66, 0x0f, 0x65, 0x00 );
    FCML_A64( "pcmpgtw %xmm1,%xmm0", 0x66, 0x0f, 0x65, 0xc1 );
    FCML_A64( "pcmpgtd (%rax),%xmm0", 0x66, 0x0f, 0x66, 0x00 );
    FCML_A64( "pcmpgtd %xmm1,%xmm0", 0x66, 0x0f, 0x66, 0xc1 );
    FCML_A64( "vpcmpgtb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x64, 0x00 );
    FCML_A64( "vpcmpgtb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x64, 0xc1 );
    FCML_A64( "vpcmpgtw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x65, 0x00 );
    FCML_A64( "vpcmpgtw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x65, 0xc1 );
    FCML_A64( "vpcmpgtd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x66, 0x00 );
    FCML_A64( "vpcmpgtd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x66, 0xc1 );
    FCML_A64( "vpcmpgtb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x64, 0x00 );
    FCML_A64( "vpcmpgtb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x64, 0xc1 );
    FCML_A64( "vpcmpgtw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x65, 0x00 );
    FCML_A64( "vpcmpgtw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x65, 0xc1 );
    FCML_A64( "vpcmpgtd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x66, 0x00 );
    FCML_A64( "vpcmpgtd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x66, 0xc1 );
}

void fcml_tf_instruction_PCMPGTQ(void) {

    FCML_I64( "pcmpgtq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x37, 0x00 );
    FCML_I32( "pcmpgtq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x37, 0xC1 );

    FCML_I64( "vpcmpgtq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x37, 0x00 );
    FCML_I32( "vpcmpgtq xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x37, 0xC1 );

    FCML_I64( "vpcmpgtq ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x37, 0x00 );
    FCML_I32( "vpcmpgtq ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x37, 0xC1 );

    FCML_A64( "pcmpgtq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x37, 0x00 );
    FCML_A64( "pcmpgtq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x37, 0xc1 );
    FCML_A64( "vpcmpgtq (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x37, 0x00 );
    FCML_A64( "vpcmpgtq %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x37, 0xc1 );
    FCML_A64( "vpcmpgtq (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x37, 0x00 );
    FCML_A64( "vpcmpgtq %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x37, 0xc1 );
}

void fcml_tf_instruction_PCMPISTRI(void) {

    FCML_I64( "pcmpistri xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x63, 0x00, 0xFF );
    FCML_I32( "pcmpistri xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x63, 0xC1, 0xFF );

    FCML_I64( "vpcmpistri xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x63, 0x00, 0xFF );
    FCML_I32( "vpcmpistri xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x63, 0xC1, 0xFF );

    FCML_A64( "pcmpistri $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x63, 0x00, 0xff );
    FCML_A64( "pcmpistri $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x63, 0xc1, 0xff );
    FCML_A64( "vpcmpistri $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x63, 0x00, 0xff );
    FCML_A64( "vpcmpistri $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x63, 0xc1, 0xff );
}

void fcml_tf_instruction_PCMPISTRM(void) {

    FCML_I64( "pcmpistrm xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x62, 0x00, 0xFF );
    FCML_I32( "pcmpistrm xmm0,xmm1,0ffh", 0x66, 0x0F, 0x3A, 0x62, 0xC1, 0xFF );

    FCML_I64( "vpcmpistrm xmm0,xmmword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x62, 0x00, 0xFF );
    FCML_I32( "vpcmpistrm xmm0,xmm1,0ffh", 0xC4, 0xE3, 0x79, 0x62, 0xC1, 0xFF );

    FCML_A64( "pcmpistrm $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x62, 0x00, 0xff );
    FCML_A64( "pcmpistrm $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x3a, 0x62, 0xc1, 0xff );
    FCML_A64( "vpcmpistrm $0xff,(%rax),%xmm0", 0xc4, 0xe3, 0x79, 0x62, 0x00, 0xff );
    FCML_A64( "vpcmpistrm $0xff,%xmm1,%xmm0", 0xc4, 0xe3, 0x79, 0x62, 0xc1, 0xff );
}

void fcml_tf_instruction_PEXTRB(void) {

    FCML_I64( "pextrb byte ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0x00, 0xFF );
    FCML_I64( "pextrb rcx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0xC1, 0xFF );
    FCML_I32( "pextrb byte ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0x00, 0xFF );
    FCML_I32( "pextrb ecx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x14, 0xC1, 0xFF );

    FCML_I64( "pextrd dword ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I64( "pextrd rcx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );
    FCML_I32( "pextrd dword ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I32( "pextrd ecx,xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );

    FCML_I64( "pextrq qword ptr [rax],xmm0,0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x16, 0x00, 0xFF );
    FCML_I64( "pextrq rcx,xmm0,0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x16, 0xC1, 0xFF );

    FCML_I64( "vpextrb byte ptr [rax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x14, 0x00, 0xFF );
    FCML_I64( "vpextrb rcx,xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x14, 0xC1, 0xFF );
    FCML_I32( "vpextrb byte ptr [eax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x14, 0x00, 0xFF );
    FCML_I32( "vpextrb ecx,xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x14, 0xC1, 0xFF );

    FCML_I64( "vpextrd dword ptr [rax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x16, 0x00, 0xFF );
    FCML_I64( "vpextrd rcx,xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x16, 0xC1, 0xFF );
    FCML_I32( "vpextrd dword ptr [eax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x16, 0x00, 0xFF );
    FCML_I32( "vpextrd ecx,xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x16, 0xC1, 0xFF );

    FCML_I64( "vpextrq qword ptr [rax],xmm0,0ffh", 0xC4, 0xE3, 0xF9, 0x16, 0x00, 0xFF );
    FCML_I64( "vpextrq rcx,xmm0,0ffh", 0xC4, 0xE3, 0xF9, 0x16, 0xC1, 0xFF );

    FCML_A64( "pextrb $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x14, 0x00, 0xff );
    FCML_A64( "pextrb $0xff,%xmm0,%rcx", 0x66, 0x0f, 0x3a, 0x14, 0xc1, 0xff );
    FCML_A64( "pextrd $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x16, 0x00, 0xff );
    FCML_A64( "pextrd $0xff,%xmm0,%rcx", 0x66, 0x0f, 0x3a, 0x16, 0xc1, 0xff );
    FCML_A64( "pextrq $0xff,%xmm0,(%rax)", 0x66, 0x48, 0x0f, 0x3a, 0x16, 0x00, 0xff );
    FCML_A64( "pextrq $0xff,%xmm0,%rcx", 0x66, 0x48, 0x0f, 0x3a, 0x16, 0xc1, 0xff );
    FCML_A64( "vpextrb $0xff,%xmm0,(%rax)", 0xc4, 0xe3, 0x79, 0x14, 0x00, 0xff );
    FCML_A64( "vpextrb $0xff,%xmm0,%rcx", 0xc4, 0xe3, 0x79, 0x14, 0xc1, 0xff );
    FCML_A64( "vpextrd $0xff,%xmm0,(%rax)", 0xc4, 0xe3, 0x79, 0x16, 0x00, 0xff );
    FCML_A64( "vpextrd $0xff,%xmm0,%rcx", 0xc4, 0xe3, 0x79, 0x16, 0xc1, 0xff );
    FCML_A64( "vpextrq $0xff,%xmm0,(%rax)", 0xc4, 0xe3, 0xf9, 0x16, 0x00, 0xff );
    FCML_A64( "vpextrq $0xff,%xmm0,%rcx", 0xc4, 0xe3, 0xf9, 0x16, 0xc1, 0xff );
}

void fcml_tf_instruction_PEXTRW(void) {

    FCML_I64( "pextrw rax,mm1,0ffh", 0x0F, 0xC5, 0xC1, 0xFF );
    FCML_I32( "pextrw eax,mm1,0ffh", 0x0F, 0xC5, 0xC1, 0xFF );

    FCML_I64_M( "pextrw rax,xmm1,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_I32_M( "pextrw eax,xmm1,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );

    FCML_I64( "pextrw word ptr [rax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x15, 0x00, 0xFF );
    FCML_I64_M( "pextrw rcx,xmm0,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );
    FCML_I32( "pextrw word ptr [eax],xmm0,0ffh", 0x66, 0x0F, 0x3A, 0x15, 0x00, 0xFF );
    FCML_I32_M( "pextrw ecx,xmm0,0ffh", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );

    FCML_I64_M( "vpextrw rax,xmm1,0ffh", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc1, 0xff ) );
    FCML_I32_M( "vpextrw eax,xmm1,0ffh", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc1, 0xff ) );

    FCML_I64( "vpextrw word ptr [rax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x15, 0x00, 0xFF );
    FCML_I64_M( "vpextrw rcx,xmm0,0ffh", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc8, 0xff ) );
    FCML_I32( "vpextrw word ptr [eax],xmm0,0ffh", 0xC4, 0xE3, 0x79, 0x15, 0x00, 0xFF );
    FCML_I32_M( "vpextrw ecx,xmm0,0ffh", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc8, 0xff ) );

    FCML_A64( "pextrw $0xff,%mm1,%rax", 0x0f, 0xc5, 0xc1, 0xff );
    FCML_A64( "pextrw $0xff,%mm1,%rax", 0x0f, 0xc5, 0xc1, 0xff );
    FCML_A64( "pextrw $0xff,%xmm0,(%rax)", 0x66, 0x0f, 0x3a, 0x15, 0x00, 0xff );
    FCML_A64( "vpextrw $0xff,%xmm0,(%rax)", 0xc4, 0xe3, 0x79, 0x15, 0x00, 0xff );
    FCML_A64_M( "pextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc8, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm0,%rcx", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );
    FCML_A64_M( "pextrw $0xff,%xmm0,%rcx", 2, FCML_MI( 0x66, 0x0f, 0x3a, 0x15, 0xc1, 0xff ), FCML_MI( 0x66, 0x0f, 0xc5, 0xc8, 0xff ) );
    FCML_A64_M( "vpextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "vpextrw $0xff,%xmm1,%rax", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc8, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc1, 0xff ) );
    FCML_A64_M( "vpextrw $0xff,%xmm0,%rcx", 2, FCML_MI( 0xc4, 0xe3, 0x79, 0x15, 0xc1, 0xff ), FCML_MI( 0xc5, 0xf9, 0xc5, 0xc8, 0xff ) );
}

void fcml_tf_instruction_PHADDW(void) {

    FCML_I64( "phaddw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x01, 0x00 );
    FCML_I32( "phaddw mm0,mm1", 0x0F, 0x38, 0x01, 0xC1 );
    FCML_I64( "phaddd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x02, 0x00 );
    FCML_I32( "phaddd mm0,mm1", 0x0F, 0x38, 0x02, 0xC1 );

    FCML_I64( "phaddw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x01, 0x00 );
    FCML_I32( "phaddw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x01, 0xC1 );
    FCML_I64( "phaddd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x02, 0x00 );
    FCML_I32( "phaddd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x02, 0xC1 );

    FCML_I64( "vphaddw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x01, 0x00 );
    FCML_I32( "vphaddw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x01, 0xC1 );
    FCML_I64( "vphaddd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x02, 0x00 );
    FCML_I32( "vphaddd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x02, 0xC1 );

    FCML_I64( "vphaddw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x01, 0x00 );
    FCML_I32( "vphaddw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x01, 0xC1 );
    FCML_I64( "vphaddd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x02, 0x00 );
    FCML_I32( "vphaddd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x02, 0xC1 );

    FCML_A64( "phaddw (%rax),%mm0", 0x0f, 0x38, 0x01, 0x00 );
    FCML_A64( "phaddw %mm1,%mm0", 0x0f, 0x38, 0x01, 0xc1 );
    FCML_A64( "phaddd (%rax),%mm0", 0x0f, 0x38, 0x02, 0x00 );
    FCML_A64( "phaddd %mm1,%mm0", 0x0f, 0x38, 0x02, 0xc1 );
    FCML_A64( "phaddw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x01, 0x00 );
    FCML_A64( "phaddw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x01, 0xc1 );
    FCML_A64( "phaddd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x02, 0x00 );
    FCML_A64( "phaddd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x02, 0xc1 );
    FCML_A64( "vphaddw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x01, 0x00 );
    FCML_A64( "vphaddw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x01, 0xc1 );
    FCML_A64( "vphaddd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x02, 0x00 );
    FCML_A64( "vphaddd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x02, 0xc1 );
    FCML_A64( "vphaddw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x01, 0x00 );
    FCML_A64( "vphaddw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x01, 0xc1 );
    FCML_A64( "vphaddd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x02, 0x00 );
    FCML_A64( "vphaddd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x02, 0xc1 );
}

void fcml_tf_instruction_PHADDSW(void) {

    FCML_I64( "phaddsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x03, 0x00 );
    FCML_I32( "phaddsw mm0,mm1", 0x0F, 0x38, 0x03, 0xC1 );

    FCML_I64( "phaddsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x03, 0x00 );
    FCML_I32( "phaddsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x03, 0xC1 );

    FCML_I64( "vphaddsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x03, 0x00 );
    FCML_I32( "vphaddsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x03, 0xC1 );

    FCML_I64( "vphaddsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x03, 0x00 );
    FCML_I32( "vphaddsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x03, 0xC1 );

    FCML_A64( "phaddsw (%rax),%mm0", 0x0f, 0x38, 0x03, 0x00 );
    FCML_A64( "phaddsw %mm1,%mm0", 0x0f, 0x38, 0x03, 0xc1 );
    FCML_A64( "phaddsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x03, 0x00 );
    FCML_A64( "phaddsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x03, 0xc1 );
    FCML_A64( "vphaddsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x03, 0x00 );
    FCML_A64( "vphaddsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x03, 0xc1 );
    FCML_A64( "vphaddsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x03, 0x00 );
    FCML_A64( "vphaddsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x03, 0xc1 );
}

void fcml_tf_instruction_PHMINPOSUW(void) {

    FCML_I64( "phminposuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x41, 0x00 );
    FCML_I32( "phminposuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x41, 0xC1 );

    FCML_I64( "vphminposuw xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x41, 0x00 );
    FCML_I32( "vphminposuw xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x41, 0xC1 );

    FCML_A64( "phminposuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x41, 0x00 );
    FCML_A64( "phminposuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x41, 0xc1 );
    FCML_A64( "vphminposuw (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x41, 0x00 );
    FCML_A64( "vphminposuw %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x41, 0xc1 );
}

void fcml_tf_instruction_PHSUBW(void) {

    FCML_I64( "phsubw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x05, 0x00 );
    FCML_I32( "phsubw mm0,mm1", 0x0F, 0x38, 0x05, 0xC1 );
    FCML_I64( "phsubd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x06, 0x00 );
    FCML_I32( "phsubd mm0,mm1", 0x0F, 0x38, 0x06, 0xC1 );

    FCML_I64( "phsubw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x05, 0x00 );
    FCML_I32( "phsubw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x05, 0xC1 );
    FCML_I64( "phsubd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x06, 0x00 );
    FCML_I32( "phsubd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x06, 0xC1 );

    FCML_I64( "vphsubw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x05, 0x00 );
    FCML_I32( "vphsubw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x05, 0xC1 );
    FCML_I64( "vphsubd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x06, 0x00 );
    FCML_I32( "vphsubd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x06, 0xC1 );

    FCML_I64( "vphsubw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x05, 0x00 );
    FCML_I32( "vphsubw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x05, 0xC1 );
    FCML_I64( "vphsubd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x06, 0x00 );
    FCML_I32( "vphsubd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x06, 0xC1 );

    FCML_A64( "phsubw (%rax),%mm0", 0x0f, 0x38, 0x05, 0x00 );
    FCML_A64( "phsubw %mm1,%mm0", 0x0f, 0x38, 0x05, 0xc1 );
    FCML_A64( "phsubd (%rax),%mm0", 0x0f, 0x38, 0x06, 0x00 );
    FCML_A64( "phsubd %mm1,%mm0", 0x0f, 0x38, 0x06, 0xc1 );
    FCML_A64( "phsubw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x05, 0x00 );
    FCML_A64( "phsubw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x05, 0xc1 );
    FCML_A64( "phsubd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x06, 0x00 );
    FCML_A64( "phsubd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x06, 0xc1 );
    FCML_A64( "vphsubw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x05, 0x00 );
    FCML_A64( "vphsubw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x05, 0xc1 );
    FCML_A64( "vphsubd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x06, 0x00 );
    FCML_A64( "vphsubd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x06, 0xc1 );
    FCML_A64( "vphsubw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x05, 0x00 );
    FCML_A64( "vphsubw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x05, 0xc1 );
    FCML_A64( "vphsubd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x06, 0x00 );
    FCML_A64( "vphsubd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x06, 0xc1 );
}

void fcml_tf_instruction_PHSUBSW(void) {

    FCML_I64( "phsubsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x07, 0x00 );
    FCML_I32( "phsubsw mm0,mm1", 0x0F, 0x38, 0x07, 0xC1 );

    FCML_I64( "phsubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x07, 0x00 );
    FCML_I32( "phsubsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x07, 0xC1 );

    FCML_I64( "vphsubsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x07, 0x00 );
    FCML_I32( "vphsubsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x07, 0xC1 );

    FCML_I64( "vphsubsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x07, 0x00 );
    FCML_I32( "vphsubsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x07, 0xC1 );

    FCML_A64( "phsubsw (%rax),%mm0", 0x0f, 0x38, 0x07, 0x00 );
    FCML_A64( "phsubsw %mm1,%mm0", 0x0f, 0x38, 0x07, 0xc1 );
    FCML_A64( "phsubsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x07, 0x00 );
    FCML_A64( "phsubsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x07, 0xc1 );
    FCML_A64( "vphsubsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x07, 0x00 );
    FCML_A64( "vphsubsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x07, 0xc1 );
    FCML_A64( "vphsubsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x07, 0x00 );
    FCML_A64( "vphsubsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x07, 0xc1 );
}

void fcml_tf_instruction_PINSR(void) {

    FCML_I64( "pinsrb xmm0,byte ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x20, 0x00, 0xFF );
    FCML_I32( "pinsrb xmm0,ecx,0ffh", 0x66, 0x0F, 0x3A, 0x20, 0xC1, 0xFF );

    FCML_I64( "pinsrd xmm0,dword ptr [rax],0ffh", 0x66, 0x0F, 0x3A, 0x22, 0x00, 0xFF );
    FCML_I32( "pinsrd xmm0,ecx,0ffh", 0x66, 0x0F, 0x3A, 0x22, 0xC1, 0xFF );

    FCML_I64( "pinsrq xmm0,qword ptr [rax],0ffh", 0x66, 0x48, 0x0F, 0x3A, 0x22, 0x00, 0xFF );

    FCML_I64( "vpinsrb xmm0,xmm0,byte ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x20, 0x00, 0xFF );
    FCML_I32( "vpinsrb xmm0,xmm0,ecx,0ffh", 0xC4, 0xE3, 0x79, 0x20, 0xC1, 0xFF );
    FCML_I64( "vpinsrd xmm0,xmm0,dword ptr [rax],0ffh", 0xC4, 0xE3, 0x79, 0x22, 0x00, 0xFF );
    FCML_I32( "vpinsrd xmm0,xmm0,ecx,0ffh", 0xC4, 0xE3, 0x79, 0x22, 0xC1, 0xFF );
    FCML_I64( "vpinsrq xmm0,xmm0,qword ptr [rax],0ffh", 0xC4, 0xE3, 0xF9, 0x22, 0x00, 0xFF );

    FCML_A64( "pinsrb $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x20, 0x00, 0xff );
    FCML_A64( "pinsrb $0xff,%ecx,%xmm0", 0x66, 0x0f, 0x3a, 0x20, 0xc1, 0xff );
    FCML_A64( "pinsrd $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x3a, 0x22, 0x00, 0xff );
    FCML_A64( "pinsrd $0xff,%ecx,%xmm0", 0x66, 0x0f, 0x3a, 0x22, 0xc1, 0xff );
    FCML_A64( "pinsrq $0xff,(%rax),%xmm0", 0x66, 0x48, 0x0f, 0x3a, 0x22, 0x00, 0xff );
    FCML_A64( "vpinsrb $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x20, 0x00, 0xff );
    FCML_A64( "vpinsrb $0xff,%ecx,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x20, 0xc1, 0xff );
    FCML_A64( "vpinsrd $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x22, 0x00, 0xff );
    FCML_A64( "vpinsrd $0xff,%ecx,%xmm0,%xmm0", 0xc4, 0xe3, 0x79, 0x22, 0xc1, 0xff );
    FCML_A64( "vpinsrq $0xff,(%rax),%xmm0,%xmm0", 0xc4, 0xe3, 0xf9, 0x22, 0x00, 0xff );
}

void fcml_tf_instruction_PINSRW(void) {

    FCML_I64( "pinsrw mm0,word ptr [rax],0ffh", 0x0F, 0xC4, 0x00, 0xFF );
    FCML_I32( "pinsrw mm0,ecx,0ffh", 0x0F, 0xC4, 0xC1, 0xFF );

    FCML_I64( "pinsrw xmm0,word ptr [rax],0ffh", 0x66, 0x0F, 0xC4, 0x00, 0xFF );
    FCML_I32( "pinsrw xmm0,ecx,0ffh", 0x66, 0x0F, 0xC4, 0xC1, 0xFF );

    FCML_I64_D( "vpinsrw xmm0,xmm0,word ptr [rax],0ffh", 0xC4, 0xE1, 0x79, 0xC4, 0x00, 0xFF );
    FCML_I64( "vpinsrw xmm0,xmm0,word ptr [rax],0ffh", 0xc5, 0xf9, 0xc4, 0x00, 0xff );
    FCML_I32_D( "vpinsrw xmm0,xmm0,ecx,0ffh", 0xC4, 0xE1, 0x79, 0xC4, 0xC1, 0xFF );
    FCML_I32( "vpinsrw xmm0,xmm0,ecx,0ffh", 0xc5, 0xf9, 0xc4, 0xc1, 0xff );

    FCML_A64( "pinsrw $0xff,(%rax),%mm0", 0x0f, 0xc4, 0x00, 0xff );
    FCML_A64( "pinsrw $0xff,%ecx,%mm0", 0x0f, 0xc4, 0xc1, 0xff );
    FCML_A64( "pinsrw $0xff,(%rax),%xmm0", 0x66, 0x0f, 0xc4, 0x00, 0xff );
    FCML_A64( "pinsrw $0xff,%ecx,%xmm0", 0x66, 0x0f, 0xc4, 0xc1, 0xff );
    FCML_A64( "vpinsrw $0xff,(%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xc4, 0x00, 0xff );
    FCML_A64( "vpinsrw $0xff,%ecx,%xmm0,%xmm0", 0xc5, 0xf9, 0xc4, 0xc1, 0xff );
}

void fcml_tf_instruction_PMADDUBSW(void) {

    FCML_I64( "pmaddubsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x04, 0x00 );
    FCML_I32( "pmaddubsw mm0,mm1", 0x0F, 0x38, 0x04, 0xC1 );

    FCML_I64( "pmaddubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x04, 0x00 );
    FCML_I32( "pmaddubsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x04, 0xC1 );

    FCML_I64( "vpmaddubsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x04, 0x00 );
    FCML_I32( "vpmaddubsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x04, 0xC1 );

    FCML_I64( "vpmaddubsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x04, 0x00 );
    FCML_I32( "vpmaddubsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x04, 0xC1 );

    FCML_A64( "pmaddubsw (%rax),%mm0", 0x0f, 0x38, 0x04, 0x00 );
    FCML_A64( "pmaddubsw %mm1,%mm0", 0x0f, 0x38, 0x04, 0xc1 );
    FCML_A64( "pmaddubsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x04, 0x00 );
    FCML_A64( "pmaddubsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x04, 0xc1 );
    FCML_A64( "vpmaddubsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x04, 0x00 );
    FCML_A64( "vpmaddubsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x04, 0xc1 );
    FCML_A64( "vpmaddubsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x04, 0x00 );
    FCML_A64( "vpmaddubsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x04, 0xc1 );
}

void fcml_tf_instruction_PMADDWD(void) {

    FCML_I64( "pmaddwd mm0,mmword ptr [rax]", 0x0F, 0xF5, 0x00 );
    FCML_I32( "pmaddwd mm0,mm1", 0x0F, 0xF5, 0xC1 );

    FCML_I64( "pmaddwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF5, 0x00 );
    FCML_I32( "pmaddwd xmm0,xmm1", 0x66, 0x0F, 0xF5, 0xC1 );

    FCML_I64( "vpmaddwd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf5, 0x00 );
    FCML_I32( "vpmaddwd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf5, 0xc1 );

    FCML_I64( "vpmaddwd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xf5, 0x00 );
    FCML_I32( "vpmaddwd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xf5, 0xc1 );

    FCML_A64( "pmaddwd (%rax),%mm0", 0x0f, 0xf5, 0x00 );
    FCML_A64( "pmaddwd %mm1,%mm0", 0x0f, 0xf5, 0xc1 );
    FCML_A64( "pmaddwd (%rax),%xmm0", 0x66, 0x0f, 0xf5, 0x00 );
    FCML_A64( "pmaddwd %xmm1,%xmm0", 0x66, 0x0f, 0xf5, 0xc1 );
    FCML_A64( "vpmaddwd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf5, 0x00 );
    FCML_A64( "vpmaddwd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf5, 0xc1 );
    FCML_A64( "vpmaddwd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf5, 0x00 );
    FCML_A64( "vpmaddwd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf5, 0xc1 );
}

void fcml_tf_instruction_PMAXSB(void) {

    FCML_I64( "pmaxsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3C, 0x00 );
    FCML_I32( "pmaxsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3C, 0xC1 );

    FCML_I64( "vpmaxsb xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3C, 0x00 );
    FCML_I32( "vpmaxsb xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3C, 0xC1 );

    FCML_I64( "vpmaxsb ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3C, 0x00 );
    FCML_I32( "vpmaxsb ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3C, 0xC1 );

    FCML_A64( "pmaxsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3c, 0x00 );
    FCML_A64( "pmaxsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3c, 0xc1 );
    FCML_A64( "vpmaxsb (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3c, 0x00 );
    FCML_A64( "vpmaxsb %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3c, 0xc1 );
    FCML_A64( "vpmaxsb (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3c, 0x00 );
    FCML_A64( "vpmaxsb %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3c, 0xc1 );
}

void fcml_tf_instruction_PMAXSD(void) {

    FCML_I64( "pmaxsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3D, 0x00 );
    FCML_I32( "pmaxsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3D, 0xC1 );

    FCML_I64( "vpmaxsd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3D, 0x00 );
    FCML_I32( "vpmaxsd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3D, 0xC1 );

    FCML_I64( "vpmaxsd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3D, 0x00 );
    FCML_I32( "vpmaxsd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3D, 0xC1 );

    FCML_A64( "pmaxsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3d, 0x00 );
    FCML_A64( "pmaxsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3d, 0xc1 );
    FCML_A64( "vpmaxsd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3d, 0x00 );
    FCML_A64( "vpmaxsd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3d, 0xc1 );
    FCML_A64( "vpmaxsd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3d, 0x00 );
    FCML_A64( "vpmaxsd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3d, 0xc1 );
}

void fcml_tf_instruction_PMAXSW(void) {

    FCML_I64( "pmaxsw mm0,mmword ptr [rax]", 0x0F, 0xEE, 0x00 );
    FCML_I32( "pmaxsw mm0,mm1", 0x0F, 0xEE, 0xC1 );

    FCML_I64( "pmaxsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEE, 0x00 );
    FCML_I32( "pmaxsw xmm0,xmm1", 0x66, 0x0F, 0xEE, 0xC1 );

    FCML_I64( "vpmaxsw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xee, 0x00 );
    FCML_I32( "vpmaxsw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xee, 0xc1 );

    FCML_I64( "vpmaxsw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xee, 0x00 );
    FCML_I32( "vpmaxsw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xee, 0xc1 );

    FCML_A64( "pmaxsw (%rax),%mm0", 0x0f, 0xee, 0x00 );
    FCML_A64( "pmaxsw %mm1,%mm0", 0x0f, 0xee, 0xc1 );
    FCML_A64( "pmaxsw (%rax),%xmm0", 0x66, 0x0f, 0xee, 0x00 );
    FCML_A64( "pmaxsw %xmm1,%xmm0", 0x66, 0x0f, 0xee, 0xc1 );
    FCML_A64( "vpmaxsw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xee, 0x00 );
    FCML_A64( "vpmaxsw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xee, 0xc1 );
    FCML_A64( "vpmaxsw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xee, 0x00 );
    FCML_A64( "vpmaxsw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xee, 0xc1 );
}

void fcml_tf_instruction_PMAXUB(void) {

    FCML_I64( "pmaxub mm0,mmword ptr [rax]", 0x0F, 0xDE, 0x00 );
    FCML_I32( "pmaxub mm0,mm1", 0x0F, 0xDE, 0xC1 );

    FCML_I64( "pmaxub xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDE, 0x00 );
    FCML_I32( "pmaxub xmm0,xmm1", 0x66, 0x0F, 0xDE, 0xC1 );

    FCML_I64( "vpmaxub xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xde, 0x00 );
    FCML_I32( "vpmaxub xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xde, 0xc1 );

    FCML_I64( "vpmaxub ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xde, 0x00 );
    FCML_I32( "vpmaxub ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xde, 0xc1 );

    FCML_A64( "pmaxub (%rax),%mm0", 0x0f, 0xde, 0x00 );
    FCML_A64( "pmaxub %mm1,%mm0", 0x0f, 0xde, 0xc1 );
    FCML_A64( "pmaxub (%rax),%xmm0", 0x66, 0x0f, 0xde, 0x00 );
    FCML_A64( "pmaxub %xmm1,%xmm0", 0x66, 0x0f, 0xde, 0xc1 );
    FCML_A64( "vpmaxub (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xde, 0x00 );
    FCML_A64( "vpmaxub %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xde, 0xc1 );
    FCML_A64( "vpmaxub (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xde, 0x00 );
    FCML_A64( "vpmaxub %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xde, 0xc1 );
}

void fcml_tf_instruction_PMAXUD(void) {

    FCML_I64( "pmaxud xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3F, 0x00 );
    FCML_I32( "pmaxud xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3F, 0xC1 );

    FCML_I64( "vpmaxud xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3F, 0x00 );
    FCML_I32( "vpmaxud xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3F, 0xC1 );

    FCML_I64( "vpmaxud ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3F, 0x00 );
    FCML_I32( "vpmaxud ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3F, 0xC1 );

    FCML_A64( "pmaxud (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3f, 0x00 );
    FCML_A64( "pmaxud %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3f, 0xc1 );
    FCML_A64( "vpmaxud (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3f, 0x00 );
    FCML_A64( "vpmaxud %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3f, 0xc1 );
    FCML_A64( "vpmaxud (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3f, 0x00 );
    FCML_A64( "vpmaxud %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3f, 0xc1 );
}

void fcml_tf_instruction_PMAXUW(void) {

    FCML_I64( "pmaxuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3E, 0x00 );
    FCML_I32( "pmaxuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3E, 0xC1 );

    FCML_I64( "vpmaxuw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3E, 0x00 );
    FCML_I32( "vpmaxuw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3E, 0xC1 );

    FCML_I64( "vpmaxuw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3E, 0x00 );
    FCML_I32( "vpmaxuw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3E, 0xC1 );

    FCML_A64( "pmaxuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3e, 0x00 );
    FCML_A64( "pmaxuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3e, 0xc1 );
    FCML_A64( "vpmaxuw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3e, 0x00 );
    FCML_A64( "vpmaxuw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3e, 0xc1 );
    FCML_A64( "vpmaxuw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3e, 0x00 );
    FCML_A64( "vpmaxuw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3e, 0xc1 );
}

void fcml_tf_instruction_PMINSB(void) {

    FCML_I64( "pminsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x38, 0x00 );
    FCML_I32( "pminsb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x38, 0xC1 );

    FCML_I64( "vpminsb xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x38, 0x00 );
    FCML_I32( "vpminsb xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x38, 0xC1 );

    FCML_I64( "vpminsb ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x38, 0x00 );
    FCML_I32( "vpminsb ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x38, 0xC1 );

    FCML_A64( "pminsb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x38, 0x00 );
    FCML_A64( "pminsb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x38, 0xc1 );
    FCML_A64( "vpminsb (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x38, 0x00 );
    FCML_A64( "vpminsb %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x38, 0xc1 );
    FCML_A64( "vpminsb (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x38, 0x00 );
    FCML_A64( "vpminsb %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x38, 0xc1 );
}

void fcml_tf_instruction_PMINSD(void) {

    FCML_I64( "pminsd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x39, 0x00 );
    FCML_I32( "pminsd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x39, 0xC1 );

    FCML_I64( "vpminsd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x39, 0x00 );
    FCML_I32( "vpminsd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x39, 0xC1 );

    FCML_I64( "vpminsd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x39, 0x00 );
    FCML_I32( "vpminsd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x39, 0xC1 );

    FCML_A64( "pminsd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x39, 0x00 );
    FCML_A64( "pminsd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x39, 0xc1 );
    FCML_A64( "vpminsd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x39, 0x00 );
    FCML_A64( "vpminsd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x39, 0xc1 );
    FCML_A64( "vpminsd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x39, 0x00 );
    FCML_A64( "vpminsd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x39, 0xc1 );
}

void fcml_tf_instruction_PMINSW(void) {

    FCML_I64( "pminsw mm0,mmword ptr [rax]", 0x0F, 0xEA, 0x00 );
    FCML_I32( "pminsw mm0,mm1", 0x0F, 0xEA, 0xC1 );

    FCML_I64( "pminsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEA, 0x00 );
    FCML_I32( "pminsw xmm0,xmm1", 0x66, 0x0F, 0xEA, 0xC1 );

    FCML_I64( "vpminsw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xea, 0x00 );
    FCML_I32( "vpminsw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xea, 0xc1 );

    FCML_I64( "vpminsw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xea, 0x00 );
    FCML_I32( "vpminsw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xea, 0xc1 );

    FCML_A64( "pminsw (%rax),%mm0", 0x0f, 0xea, 0x00 );
    FCML_A64( "pminsw %mm1,%mm0", 0x0f, 0xea, 0xc1 );
    FCML_A64( "pminsw (%rax),%xmm0", 0x66, 0x0f, 0xea, 0x00 );
    FCML_A64( "pminsw %xmm1,%xmm0", 0x66, 0x0f, 0xea, 0xc1 );
    FCML_A64( "vpminsw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xea, 0x00 );
    FCML_A64( "vpminsw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xea, 0xc1 );
    FCML_A64( "vpminsw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xea, 0x00 );
    FCML_A64( "vpminsw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xea, 0xc1 );
}

void fcml_tf_instruction_PMINUB(void) {

    FCML_I64( "pminub mm0,mmword ptr [rax]", 0x0F, 0xDA, 0x00 );
    FCML_I32( "pminub mm0,mm1", 0x0F, 0xDA, 0xC1 );

    FCML_I64( "pminub xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xDA, 0x00 );
    FCML_I32( "pminub xmm0,xmm1", 0x66, 0x0F, 0xDA, 0xC1 );

    FCML_I64( "vpminub xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xda, 0x00 );
    FCML_I32( "vpminub xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xda, 0xc1 );

    FCML_I64( "vpminub ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xda, 0x00 );
    FCML_I32( "vpminub ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xda, 0xc1 );

    FCML_A64( "pminub (%rax),%mm0", 0x0f, 0xda, 0x00 );
    FCML_A64( "pminub %mm1,%mm0", 0x0f, 0xda, 0xc1 );
    FCML_A64( "pminub (%rax),%xmm0", 0x66, 0x0f, 0xda, 0x00 );
    FCML_A64( "pminub %xmm1,%xmm0", 0x66, 0x0f, 0xda, 0xc1 );
    FCML_A64( "vpminub (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xda, 0x00 );
    FCML_A64( "vpminub %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xda, 0xc1 );
    FCML_A64( "vpminub (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xda, 0x00 );
    FCML_A64( "vpminub %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xda, 0xc1 );
}

void fcml_tf_instruction_PMINUW(void) {

    FCML_I64( "pminuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3A, 0x00 );
    FCML_I32( "pminuw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3A, 0xC1 );

    FCML_I64( "vpminuw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3A, 0x00 );
    FCML_I32( "vpminuw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3A, 0xC1 );

    FCML_I64( "vpminuw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3A, 0x00 );
    FCML_I32( "vpminuw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3A, 0xC1 );

    FCML_A64( "pminuw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3a, 0x00 );
    FCML_A64( "pminuw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3a, 0xc1 );
    FCML_A64( "vpminuw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3a, 0x00 );
    FCML_A64( "vpminuw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3a, 0xc1 );
    FCML_A64( "vpminuw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3a, 0x00 );
    FCML_A64( "vpminuw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3a, 0xc1 );
}

void fcml_tf_instruction_PMINUD(void) {

    FCML_I64( "pminud xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x3B, 0x00 );
    FCML_I32( "pminud xmm0,xmm1", 0x66, 0x0F, 0x38, 0x3B, 0xC1 );

    FCML_I64( "vpminud xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x3B, 0x00 );
    FCML_I32( "vpminud xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x3B, 0xC1 );

    FCML_I64( "vpminud ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x3B, 0x00 );
    FCML_I32( "vpminud ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x3B, 0xC1 );

    FCML_A64( "pminud (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x3b, 0x00 );
    FCML_A64( "pminud %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x3b, 0xc1 );
    FCML_A64( "vpminud (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3b, 0x00 );
    FCML_A64( "vpminud %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x3b, 0xc1 );
    FCML_A64( "vpminud (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3b, 0x00 );
    FCML_A64( "vpminud %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x3b, 0xc1 );
}

void fcml_tf_instruction_PMOVMSKB(void) {

    FCML_I32( "pmovmskb eax,mm1", 0x0F, 0xD7, 0xC1 );
    FCML_I64( "pmovmskb rax,mm1", 0x0F, 0xD7, 0xC1 );

    FCML_I32( "pmovmskb eax,xmm1", 0x66, 0x0F, 0xD7, 0xC1 );
    FCML_I64( "pmovmskb rax,xmm1", 0x66, 0x0F, 0xD7, 0xC1 );

    FCML_I32( "vpmovmskb eax,xmm0", 0xc5, 0xf9, 0xd7, 0xc0 );
    FCML_I64( "vpmovmskb rcx,xmm0", 0xc5, 0xf9, 0xd7, 0xc8 );

    FCML_I32( "vpmovmskb ecx,ymm0", 0xc5, 0xfd, 0xd7, 0xc8 );
    FCML_I64( "vpmovmskb rax,ymm0", 0xc5, 0xfd, 0xd7, 0xc0 );

    FCML_A64( "pmovmskb %mm1,%rax", 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %mm1,%rax", 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %xmm1,%rax", 0x66, 0x0f, 0xd7, 0xc1 );
    FCML_A64( "pmovmskb %xmm1,%rax", 0x66, 0x0f, 0xd7, 0xc1 );
    FCML_A64( "vpmovmskb %xmm0,%rax", 0xc5, 0xf9, 0xd7, 0xc0 );
    FCML_A64( "vpmovmskb %xmm0,%rcx", 0xc5, 0xf9, 0xd7, 0xc8 );
    FCML_A64( "vpmovmskb %ymm0,%rcx", 0xc5, 0xfd, 0xd7, 0xc8 );
    FCML_A64( "vpmovmskb %ymm0,%rax", 0xc5, 0xfd, 0xd7, 0xc0 );
}

void fcml_tf_instruction_PMOVSX(void) {

    FCML_I64( "pmovsxbw xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x20, 0x00 );
    FCML_I32( "pmovsxbw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x20, 0xC1 );

    FCML_I64( "pmovsxbd xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x21, 0x00 );
    FCML_I32( "pmovsxbd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x21, 0xC1 );

    FCML_I64( "pmovsxbq xmm0,word ptr [rax]", 0x66, 0x0F, 0x38, 0x22, 0x00 );
    FCML_I32( "pmovsxbq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x22, 0xC1 );

    FCML_I64( "pmovsxwd xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x23, 0x00 );
    FCML_I32( "pmovsxwd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x23, 0xC1 );

    FCML_I64( "pmovsxwq xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x24, 0x00 );
    FCML_I32( "pmovsxwq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x24, 0xC1 );

    FCML_I64( "pmovsxdq xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x25, 0x00 );
    FCML_I32( "pmovsxdq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x25, 0xC1 );

    FCML_I32( "vpmovsxbw xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x20, 0x00 );
    FCML_I64( "vpmovsxbw xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x20, 0xC1 );

    FCML_I32( "vpmovsxbd xmm0,dword ptr [eax]", 0xC4, 0xE2, 0x79, 0x21, 0x00 );
    FCML_I64( "vpmovsxbd xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x21, 0xC1 );

    FCML_I32( "vpmovsxbq xmm0,word ptr [eax]", 0xC4, 0xE2, 0x79, 0x22, 0x00 );
    FCML_I64( "vpmovsxbq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x22, 0xC1 );

    FCML_I32( "vpmovsxwd xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x23, 0x00 );
    FCML_I64( "vpmovsxwd xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x23, 0xC1 );

    FCML_I32( "vpmovsxwq xmm0,dword ptr [eax]", 0xC4, 0xE2, 0x79, 0x24, 0x00 );
    FCML_I64( "vpmovsxwq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x24, 0xC1 );

    FCML_I32( "vpmovsxdq xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x25, 0x00 );
    FCML_I64( "vpmovsxdq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x25, 0xC1 );

    FCML_I32( "vpmovsxbw ymm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x20, 0x00 );
    FCML_I64( "vpmovsxbw ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x20, 0xC1 );

    FCML_I32( "vpmovsxbd ymm0,mmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x21, 0x00 );
    FCML_I64( "vpmovsxbd ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x21, 0xC1 );

    FCML_I32( "vpmovsxbq ymm0,dword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x22, 0x00 );
    FCML_I64( "vpmovsxbq ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x22, 0xC1 );

    FCML_A64( "pmovsxbw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x20, 0x00 );
    FCML_A64( "pmovsxbw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x20, 0xc1 );
    FCML_A64( "pmovsxbd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x21, 0x00 );
    FCML_A64( "pmovsxbd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x21, 0xc1 );
    FCML_A64( "pmovsxbq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x22, 0x00 );
    FCML_A64( "pmovsxbq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x22, 0xc1 );
    FCML_A64( "pmovsxwd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x23, 0x00 );
    FCML_A64( "pmovsxwd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x23, 0xc1 );
    FCML_A64( "pmovsxwq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x24, 0x00 );
    FCML_A64( "pmovsxwq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x24, 0xc1 );
    FCML_A64( "pmovsxdq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x25, 0x00 );
    FCML_A64( "pmovsxdq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x25, 0xc1 );
    FCML_A64( "vpmovsxbw (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x20, 0x00 );
    FCML_A64( "vpmovsxbw %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x20, 0xc1 );
    FCML_A64( "vpmovsxbd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x21, 0x00 );
    FCML_A64( "vpmovsxbd %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x21, 0xc1 );
    FCML_A64( "vpmovsxbq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x22, 0x00 );
    FCML_A64( "vpmovsxbq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x22, 0xc1 );
    FCML_A64( "vpmovsxwd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x23, 0x00 );
    FCML_A64( "vpmovsxwd %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x23, 0xc1 );
    FCML_A64( "vpmovsxwq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x24, 0x00 );
    FCML_A64( "vpmovsxwq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x24, 0xc1 );
    FCML_A64( "vpmovsxdq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x25, 0x00 );
    FCML_A64( "vpmovsxdq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x25, 0xc1 );
    FCML_A64( "vpmovsxbw (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x20, 0x00 );
    FCML_A64( "vpmovsxbw %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x20, 0xc1 );
    FCML_A64( "vpmovsxbd (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x21, 0x00 );
    FCML_A64( "vpmovsxbd %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x21, 0xc1 );
    FCML_A64( "vpmovsxbq (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x22, 0x00 );
    FCML_A64( "vpmovsxbq %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x22, 0xc1 );
}

void fcml_tf_instruction_PMOVZX(void) {

    FCML_I64( "pmovzxbw xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x30, 0x00 );
    FCML_I32( "pmovzxbw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x30, 0xC1 );

    FCML_I64( "pmovzxbd xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x31, 0x00 );
    FCML_I32( "pmovzxbd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x31, 0xC1 );

    FCML_I64( "pmovzxbq xmm0,word ptr [rax]", 0x66, 0x0F, 0x38, 0x32, 0x00 );
    FCML_I32( "pmovzxbq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x32, 0xC1 );

    FCML_I64( "pmovzxwd xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x33, 0x00 );
    FCML_I32( "pmovzxwd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x33, 0xC1 );

    FCML_I64( "pmovzxwq xmm0,dword ptr [rax]", 0x66, 0x0F, 0x38, 0x34, 0x00 );
    FCML_I32( "pmovzxwq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x34, 0xC1 );

    FCML_I64( "pmovzxdq xmm0,mmword ptr [rax]", 0x66, 0x0F, 0x38, 0x35, 0x00 );
    FCML_I32( "pmovzxdq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x35, 0xC1 );

    FCML_I32( "vpmovzxbw xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x30, 0x00 );
    FCML_I64( "vpmovzxbw xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x30, 0xC1 );

    FCML_I32( "vpmovzxbd xmm0,dword ptr [eax]", 0xC4, 0xE2, 0x79, 0x31, 0x00 );
    FCML_I64( "vpmovzxbd xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x31, 0xC1 );

    FCML_I32( "vpmovzxbq xmm0,word ptr [eax]", 0xC4, 0xE2, 0x79, 0x32, 0x00 );
    FCML_I64( "vpmovzxbq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x32, 0xC1 );

    FCML_I32( "vpmovzxwd xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x33, 0x00 );
    FCML_I64( "vpmovzxwd xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x33, 0xC1 );

    FCML_I32( "vpmovzxwq xmm0,dword ptr [eax]", 0xC4, 0xE2, 0x79, 0x34, 0x00 );
    FCML_I64( "vpmovzxwq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x34, 0xC1 );

    FCML_I32( "vpmovzxdq xmm0,mmword ptr [eax]", 0xC4, 0xE2, 0x79, 0x35, 0x00 );
    FCML_I64( "vpmovzxdq xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x35, 0xC1 );

    FCML_I32( "vpmovzxbw ymm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x30, 0x00 );
    FCML_I64( "vpmovzxbw ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x30, 0xC1 );

    FCML_I32( "vpmovzxbd ymm0,mmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x31, 0x00 );
    FCML_I64( "vpmovzxbd ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x31, 0xC1 );

    FCML_I32( "vpmovzxbq ymm0,dword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x32, 0x00 );
    FCML_I64( "vpmovzxbq ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x32, 0xC1 );

    FCML_I32( "vpmovzxwd ymm0,xmmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x33, 0x00 );
    FCML_I64( "vpmovzxwd ymm0,xmm1", 0xC4, 0xE2, 0x7D, 0x33, 0xC1 );

    FCML_A64( "pmovzxbw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x30, 0x00 );
    FCML_A64( "pmovzxbw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x30, 0xc1 );
    FCML_A64( "pmovzxbd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x31, 0x00 );
    FCML_A64( "pmovzxbd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x31, 0xc1 );
    FCML_A64( "pmovzxbq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x32, 0x00 );
    FCML_A64( "pmovzxbq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x32, 0xc1 );
    FCML_A64( "pmovzxwd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x33, 0x00 );
    FCML_A64( "pmovzxwd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x33, 0xc1 );
    FCML_A64( "pmovzxwq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x34, 0x00 );
    FCML_A64( "pmovzxwq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x34, 0xc1 );
    FCML_A64( "pmovzxdq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x35, 0x00 );
    FCML_A64( "pmovzxdq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x35, 0xc1 );
    FCML_A64( "vpmovzxbw (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x30, 0x00 );
    FCML_A64( "vpmovzxbw %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x30, 0xc1 );
    FCML_A64( "vpmovzxbd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x31, 0x00 );
    FCML_A64( "vpmovzxbd %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x31, 0xc1 );
    FCML_A64( "vpmovzxbq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x32, 0x00 );
    FCML_A64( "vpmovzxbq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x32, 0xc1 );
    FCML_A64( "vpmovzxwd (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x33, 0x00 );
    FCML_A64( "vpmovzxwd %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x33, 0xc1 );
    FCML_A64( "vpmovzxwq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x34, 0x00 );
    FCML_A64( "vpmovzxwq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x34, 0xc1 );
    FCML_A64( "vpmovzxdq (%rax),%xmm0", 0xc4, 0xe2, 0x79, 0x35, 0x00 );
    FCML_A64( "vpmovzxdq %xmm1,%xmm0", 0xc4, 0xe2, 0x79, 0x35, 0xc1 );
    FCML_A64( "vpmovzxbw (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x30, 0x00 );
    FCML_A64( "vpmovzxbw %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x30, 0xc1 );
    FCML_A64( "vpmovzxbd (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x31, 0x00 );
    FCML_A64( "vpmovzxbd %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x31, 0xc1 );
    FCML_A64( "vpmovzxbq (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x32, 0x00 );
    FCML_A64( "vpmovzxbq %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x32, 0xc1 );
    FCML_A64( "vpmovzxwd (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x33, 0x00 );
    FCML_A64( "vpmovzxwd %xmm1,%ymm0", 0xc4, 0xe2, 0x7d, 0x33, 0xc1 );
}

void fcml_tf_instruction_PMULDQ(void) {

    FCML_I64( "pmuldq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x28, 0x00 );
    FCML_I32( "pmuldq xmm0,xmm1", 0x66, 0x0F, 0x38, 0x28, 0xC1 );

    FCML_I64( "vpmuldq xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x28, 0x00 );
    FCML_I32( "vpmuldq xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x28, 0xC1 );

    FCML_I64( "vpmuldq ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x28, 0x00 );
    FCML_I32( "vpmuldq ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x28, 0xC1 );

    FCML_A64( "pmuldq (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x28, 0x00 );
    FCML_A64( "pmuldq %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x28, 0xc1 );
    FCML_A64( "vpmuldq (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x28, 0x00 );
    FCML_A64( "vpmuldq %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x28, 0xc1 );
    FCML_A64( "vpmuldq (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x28, 0x00 );
    FCML_A64( "vpmuldq %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x28, 0xc1 );
}

void fcml_tf_instruction_PMULHRSW(void) {

    FCML_I64( "pmulhrsw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x0B, 0x00 );
    FCML_I32( "pmulhrsw mm0,mm1", 0x0F, 0x38, 0x0B, 0xC1 );

    FCML_I64( "pmulhrsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x0B, 0x00 );
    FCML_I32( "pmulhrsw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x0B, 0xC1 );

    FCML_I64( "vpmulhrsw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x0B, 0x00 );
    FCML_I32( "vpmulhrsw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x0B, 0xC1 );

    FCML_I64( "vpmulhrsw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x0B, 0x00 );
    FCML_I32( "vpmulhrsw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x0B, 0xC1 );

    FCML_A64( "pmulhrsw (%rax),%mm0", 0x0f, 0x38, 0x0b, 0x00 );
    FCML_A64( "pmulhrsw %mm1,%mm0", 0x0f, 0x38, 0x0b, 0xc1 );
    FCML_A64( "pmulhrsw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x0b, 0x00 );
    FCML_A64( "pmulhrsw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x0b, 0xc1 );
    FCML_A64( "vpmulhrsw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0b, 0x00 );
    FCML_A64( "vpmulhrsw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0b, 0xc1 );
    FCML_A64( "vpmulhrsw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0b, 0x00 );
    FCML_A64( "vpmulhrsw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0b, 0xc1 );
}

void fcml_tf_instruction_PMULHUW(void) {

    FCML_I64( "pmulhuw mm0,mmword ptr [rax]", 0x0F, 0xE4, 0x00 );
    FCML_I32( "pmulhuw mm0,mm1", 0x0F, 0xE4, 0xC1 );

    FCML_I64( "pmulhuw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE4, 0x00 );
    FCML_I32( "pmulhuw xmm0,xmm1", 0x66, 0x0F, 0xE4, 0xC1 );

    FCML_I64( "vpmulhuw xmm1,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe4, 0x08 );
    FCML_I32( "vpmulhuw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe4, 0xc1 );

    FCML_I64( "vpmulhuw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xe4, 0x00 );
    FCML_I32( "vpmulhuw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xe4, 0xc1 );

    FCML_A64( "pmulhuw (%rax),%mm0", 0x0f, 0xe4, 0x00 );
    FCML_A64( "pmulhuw %mm1,%mm0", 0x0f, 0xe4, 0xc1 );
    FCML_A64( "pmulhuw (%rax),%xmm0", 0x66, 0x0f, 0xe4, 0x00 );
    FCML_A64( "pmulhuw %xmm1,%xmm0", 0x66, 0x0f, 0xe4, 0xc1 );
    FCML_A64( "vpmulhuw (%rax),%xmm0,%xmm1", 0xc5, 0xf9, 0xe4, 0x08 );
    FCML_A64( "vpmulhuw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe4, 0xc1 );
    FCML_A64( "vpmulhuw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xe4, 0x00 );
    FCML_A64( "vpmulhuw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe4, 0xc1 );
}

void fcml_tf_instruction_PMULHW(void) {

    FCML_I64( "pmulhw mm0,mmword ptr [rax]", 0x0F, 0xE5, 0x00 );
    FCML_I32( "pmulhw mm0,mm1", 0x0F, 0xE5, 0xC1 );

    FCML_I64( "pmulhw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE5, 0x00 );
    FCML_I32( "pmulhw xmm0,xmm1", 0x66, 0x0F, 0xE5, 0xC1 );

    FCML_I64( "vpmulhw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe5, 0x00 );
    FCML_I32( "vpmulhw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe5, 0xc1 );

    FCML_I64( "vpmulhw ymm0,ymm13,ymmword ptr [rax]", 0xc5, 0x95, 0xe5, 0x00 );
    FCML_I32( "vpmulhw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xe5, 0xc1 );

    FCML_A64( "pmulhw (%rax),%mm0", 0x0f, 0xe5, 0x00 );
    FCML_A64( "pmulhw %mm1,%mm0", 0x0f, 0xe5, 0xc1 );
    FCML_A64( "pmulhw (%rax),%xmm0", 0x66, 0x0f, 0xe5, 0x00 );
    FCML_A64( "pmulhw %xmm1,%xmm0", 0x66, 0x0f, 0xe5, 0xc1 );
    FCML_A64( "vpmulhw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe5, 0x00 );
    FCML_A64( "vpmulhw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe5, 0xc1 );
    FCML_A64( "vpmulhw (%rax),%ymm13,%ymm0", 0xc5, 0x95, 0xe5, 0x00 );
    FCML_A64( "vpmulhw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe5, 0xc1 );
}

void fcml_tf_instruction_PMULUDQ(void) {

    FCML_I64( "pmuludq mm0,mmword ptr [rax]", 0x0F, 0xF4, 0x00 );
    FCML_I32( "pmuludq mm0,mm1", 0x0F, 0xF4, 0xC1 );

    FCML_I64( "pmuludq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF4, 0x00 );
    FCML_I32( "pmuludq xmm0,xmm1", 0x66, 0x0F, 0xF4, 0xC1 );

    FCML_I64( "vpmuludq ymm8,ymm13,ymmword ptr [rax]", 0xc5, 0x15, 0xf4, 0x00 );
    FCML_I32( "vpmuludq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf4, 0xc1 );

    FCML_I64( "vpmuludq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xf4, 0x00 );
    FCML_I32( "vpmuludq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xf4, 0xc1 );

    FCML_A64( "pmuludq (%rax),%mm0", 0x0f, 0xf4, 0x00 );
    FCML_A64( "pmuludq %mm1,%mm0", 0x0f, 0xf4, 0xc1 );
    FCML_A64( "pmuludq (%rax),%xmm0", 0x66, 0x0f, 0xf4, 0x00 );
    FCML_A64( "pmuludq %xmm1,%xmm0", 0x66, 0x0f, 0xf4, 0xc1 );
    FCML_A64( "vpmuludq (%rax),%ymm13,%ymm8", 0xc5, 0x15, 0xf4, 0x00 );
    FCML_A64( "vpmuludq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf4, 0xc1 );
    FCML_A64( "vpmuludq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf4, 0x00 );
    FCML_A64( "vpmuludq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf4, 0xc1 );
}

void fcml_tf_instruction_PMULLW(void) {

    FCML_I64( "pmullw mm0,mmword ptr [rax]", 0x0F, 0xD5, 0x00 );
    FCML_I32( "pmullw mm0,mm1", 0x0F, 0xD5, 0xC1 );

    FCML_I64( "pmullw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD5, 0x00 );
    FCML_I32( "pmullw xmm0,xmm1", 0x66, 0x0F, 0xD5, 0xC1 );

    FCML_I64( "vpmullw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd5, 0x00 );
    FCML_I32( "vpmullw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd5, 0xc1 );

    FCML_I64( "vpmullw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xd5, 0x00 );
    FCML_I32( "vpmullw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xd5, 0xc1 );

    FCML_A64( "pmullw (%rax),%mm0", 0x0f, 0xd5, 0x00 );
    FCML_A64( "pmullw %mm1,%mm0", 0x0f, 0xd5, 0xc1 );
    FCML_A64( "pmullw (%rax),%xmm0", 0x66, 0x0f, 0xd5, 0x00 );
    FCML_A64( "pmullw %xmm1,%xmm0", 0x66, 0x0f, 0xd5, 0xc1 );
    FCML_A64( "vpmullw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd5, 0x00 );
    FCML_A64( "vpmullw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd5, 0xc1 );
    FCML_A64( "vpmullw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd5, 0x00 );
    FCML_A64( "vpmullw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd5, 0xc1 );
}

void fcml_tf_instruction_PMULLD(void) {

    FCML_I64( "pmulld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x40, 0x00 );
    FCML_I32( "pmulld xmm0,xmm1", 0x66, 0x0F, 0x38, 0x40, 0xC1 );

    FCML_I64( "vpmulld xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x40, 0x00 );
    FCML_I32( "vpmulld xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x40, 0xC1 );

    FCML_I64( "vpmulld ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x40, 0x00 );
    FCML_I32( "vpmulld ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x40, 0xC1 );

    FCML_A64( "pmulld (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x40, 0x00 );
    FCML_A64( "pmulld %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x40, 0xc1 );
    FCML_A64( "vpmulld (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x40, 0x00 );
    FCML_A64( "vpmulld %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x40, 0xc1 );
    FCML_A64( "vpmulld (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x40, 0x00 );
    FCML_A64( "vpmulld %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x40, 0xc1 );
}

void fcml_tf_instruction_POP(void) {

    FCML_I32( "pop dword ptr [eax]", 0x8F, 0x00 );
    FCML_I32_M( "pop eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I32( "pop word ptr [eax]", 0x66, 0x8F, 0x00 );
    FCML_I32_M( "pop dx", 2, FCML_MI( 0x66, 0x5a ), FCML_MI( 0x66, 0x8f, 0xc2 ) );
    FCML_I32( "pop dword ptr [bx+si]", 0x67, 0x8F, 0x00 );
    FCML_I32_D( "pop ecx", 0x67, 0x8F, 0xC1 );
    FCML_I32_M( "pop ecx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_I32( "pop word ptr [bx+si]", 0x66, 0x67, 0x8F, 0x00 );
    FCML_I32_M( "pop cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );

    FCML_A32( "popl (%eax)", 0x8f, 0x00 );

    FCML_I64( "pop qword ptr [rax]", 0x8F, 0x00 );
    FCML_I64_M( "pop rcx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_I64( "pop word ptr [rax]", 0x66, 0x8F, 0x00 );
    FCML_I64_M( "pop cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );
    FCML_I64( "pop qword ptr [eax]", 0x67, 0x8F, 0x00 );
    FCML_I64_D( "pop rcx", 0x67, 0x8F, 0xC1 );
    FCML_I64( "pop word ptr [eax]", 0x66, 0x67, 0x8F, 0x00 );
    FCML_I64_D( "pop cx", 0x66, 0x67, 0x8F, 0xC1 );
    FCML_I64_D( "pop qword ptr [rax]", 0x48, 0x8F, 0x00 );
    FCML_I64_D( "pop rcx", 0x48, 0x8F, 0xC1 );

    FCML_A64( "popq (%rax)", 0x8f, 0x00 );
    FCML_A64_M( "pop %rcx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_A32_M( "pop %ecx", 2, FCML_MI( 0x59 ), FCML_MI( 0x8f, 0xc1 ) );
    FCML_A64( "popw (%rax)", 0x66, 0x8f, 0x00 );
    FCML_A64_M( "pop %cx", 2, FCML_MI( 0x66, 0x59 ), FCML_MI( 0x66, 0x8f, 0xc1 ) );
    FCML_A64( "popq (%eax)", 0x67, 0x8f, 0x00 );
    FCML_A64_M( "pop %rcx", 2, FCML_MI( 0x67, 0x59 ), FCML_MI( 0x67, 0x8f, 0xc1 ) );
    FCML_A64( "popw (%eax)", 0x66, 0x67, 0x8f, 0x00 );
    FCML_A64_M( "pop %cx", 2, FCML_MI( 0x66, 0x67, 0x59 ), FCML_MI( 0x66, 0x67, 0x8f, 0xc1 ) );
    FCML_A64_D( "popq (%rax)", 0x48, 0x8f, 0x00 );
    FCML_A64_D( "pop %rcx", 0x48, 0x8f, 0xc1 );

    FCML_I32_M( "pop eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I32_M( "pop ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_I32_D( "pop eax", 0x67, 0x58 );
    FCML_I64_M( "pop rax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
    FCML_I64_M( "pop ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
    FCML_I64_D( "pop rax", 0x67, 0x58 );
    FCML_I64_D( "pop rax", 0x48, 0x58 );

    FCML_A32_M( "pop %eax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
	FCML_A32_M( "pop %ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
	FCML_A32_D( "pop %eax", 0x67, 0x58 );
	FCML_A64_M( "pop %rax", 2, FCML_MI( 0x58 ), FCML_MI( 0x8f, 0xc0 ) );
	FCML_A64_M( "pop %ax", 2, FCML_MI( 0x66, 0x58 ), FCML_MI( 0x66, 0x8f, 0xc0 ) );
	FCML_A64_D( "pop %rax", 0x67, 0x58 );
	FCML_A64_D( "pop %rax", 0x48, 0x58 );

    FCML_I32( "pop ds", 0x1F );
    FCML_I32( "pop es", 0x07 );
    FCML_I32( "pop ss", 0x17 );

    FCML_A32( "pop %ds", 0x1F );
	FCML_A32( "pop %es", 0x07 );
	FCML_A32( "pop %ss", 0x17 );

    FCML_I32( "pop fs", 0x0F, 0xA1 );
    FCML_I64( "pop fs", 0x0f, 0xa1 );

    FCML_A32( "popw %fs", 0x66, 0x0f, 0xa1 );
    FCML_A32( "popl %fs", 0x0f, 0xa1 );
    FCML_A32_A( "pop %fs", 0x0f, 0xa1 );
    FCML_A64( "popw %fs", 0x66, 0x0f, 0xa1 );
	FCML_A64( "popq %fs", 0x0f, 0xa1 );
	FCML_A64_A( "pop %fs", 0x0f, 0xa1 );

    FCML_I32( "pop gs", 0x0F, 0xA9 );
    FCML_I64( "pop gs", 0x0F, 0xA9 );

    FCML_A32( "popw %gs", 0x66, 0x0f, 0xa9 );
	FCML_A32( "popl %gs", 0x0f, 0xa9 );
	FCML_A32_A( "pop %gs", 0x0f, 0xa9 );
	FCML_A64( "popw %gs", 0x66, 0x0f, 0xa9 );
	FCML_A64( "popq %gs", 0x0f, 0xa9 );
	FCML_A64_A( "pop %gs", 0x0f, 0xa9 );
}

void fcml_tf_instruction_POPA(void) {

    FCML_I32( "popad", 0x61 );
    FCML_I64_FAILED( "popad", 0x61 );

    FCML_I32( "popa", 0x66, 0x61 );

    FCML_A32( "popa", 0x61 );
    FCML_A32( "popaw", 0x66, 0x61 );
}

void fcml_tf_instruction_POPCNT(void) {

    FCML_I32( "popcnt ax,word ptr [eax]", 0x66, 0xF3, 0x0F, 0xB8, 0x00 );
    FCML_I32( "popcnt ax,ax", 0x66, 0xF3, 0x0F, 0xB8, 0xC0 );

    FCML_I32( "popcnt eax,dword ptr [eax]", 0xF3, 0x0F, 0xB8, 0x00 );

    FCML_I64( "popcnt rax,qword ptr [rax]", 0xF3, 0x48, 0x0F, 0xB8, 0x00 );

    FCML_A64( "popcnt (%rax),%ax", 0x66, 0xf3, 0x0f, 0xb8, 0x00 );
    FCML_A64( "popcnt %ax,%ax", 0x66, 0xf3, 0x0f, 0xb8, 0xc0 );
    FCML_A64( "popcnt (%rax),%eax", 0xf3, 0x0f, 0xb8, 0x00 );
    FCML_A64( "popcnt (%rax),%rax", 0xf3, 0x48, 0x0f, 0xb8, 0x00 );
}

void fcml_tf_instruction_POPF(void) {

    FCML_I32( "popf", 0x66, 0x9D );
    FCML_I64( "popf", 0x66, 0x9D );

    FCML_I32( "popfd", 0x9D );
    FCML_I64_FAILED( "popfd", 0x9D );

    FCML_I64( "popfq", 0x48, 0x9D );

    FCML_A32( "popfw", 0x66, 0x9d );
    FCML_A32( "popf", 0x9D );
    FCML_A64( "popfw", 0x66, 0x9d );
    FCML_A64( "popfq", 0x48, 0x9d );
}

void fcml_tf_instruction_POR(void) {

    FCML_I64( "por mm0,mmword ptr [rax]", 0x0F, 0xEB, 0x00 );
    FCML_I32( "por mm0,mm1", 0x0F, 0xEB, 0xC1 );

    FCML_I64( "por xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEB, 0x00 );
    FCML_I32( "por xmm0,xmm1", 0x66, 0x0F, 0xEB, 0xC1 );

    FCML_I64( "vpor xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xeb, 0x00 );
    FCML_I32( "vpor xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xeb, 0xc1 );

    FCML_I64( "vpor ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xeb, 0x00 );
    FCML_I32( "vpor ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xeb, 0xc1 );

    FCML_A64( "por (%rax),%mm0", 0x0f, 0xeb, 0x00 );
    FCML_A64( "por %mm1,%mm0", 0x0f, 0xeb, 0xc1 );
    FCML_A64( "por (%rax),%xmm0", 0x66, 0x0f, 0xeb, 0x00 );
    FCML_A64( "por %xmm1,%xmm0", 0x66, 0x0f, 0xeb, 0xc1 );
    FCML_A64( "vpor (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xeb, 0x00 );
    FCML_A64( "vpor %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xeb, 0xc1 );
    FCML_A64( "vpor (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xeb, 0x00 );
    FCML_A64( "vpor %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xeb, 0xc1 );
}

void fcml_tf_instruction_PREFETCHT(void) {

    FCML_I32( "prefetcht0 byte ptr [eax]", 0x0F, 0x18, 0x08 );
    FCML_I64( "prefetcht0 byte ptr [rax]", 0x0F, 0x18, 0x08 );

    FCML_I32( "prefetcht1 byte ptr [eax]", 0x0F, 0x18, 0x10 );
    FCML_I64( "prefetcht1 byte ptr [rax]", 0x0F, 0x18, 0x10 );

    FCML_I32( "prefetcht2 byte ptr [eax]", 0x0F, 0x18, 0x18 );
    FCML_I64( "prefetcht2 byte ptr [rax]", 0x0F, 0x18, 0x18 );

    FCML_I32( "prefetchnta byte ptr [eax]", 0x0F, 0x18, 0x00 );
    FCML_I64( "prefetchnta byte ptr [rax]", 0x0F, 0x18, 0x00 );

    FCML_A64( "prefetcht0 (%rax)", 0x0f, 0x18, 0x08 );
    FCML_A32( "prefetcht0 (%eax)", 0x0f, 0x18, 0x08 );
    FCML_A64( "prefetcht1 (%rax)", 0x0f, 0x18, 0x10 );
    FCML_A32( "prefetcht1 (%eax)", 0x0f, 0x18, 0x10 );
    FCML_A64( "prefetcht2 (%rax)", 0x0f, 0x18, 0x18 );
    FCML_A32( "prefetcht2 (%eax)", 0x0f, 0x18, 0x18 );
    FCML_A64( "prefetchnta (%rax)", 0x0f, 0x18, 0x00 );
    FCML_A32( "prefetchnta (%eax)", 0x0f, 0x18, 0x00 );
}

void fcml_tf_instruction_PSADBW(void) {

    FCML_I64( "psadbw mm0,mmword ptr [rax]", 0x0F, 0xF6, 0x00 );
    FCML_I32( "psadbw mm0,mm1", 0x0F, 0xF6, 0xC1 );

    FCML_I64( "psadbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF6, 0x00 );
    FCML_I32( "psadbw xmm0,xmm1", 0x66, 0x0F, 0xF6, 0xC1 );

    FCML_I64( "vpsadbw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf6, 0x00 );
    FCML_I32( "vpsadbw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf6, 0xc1 );

    FCML_I64( "vpsadbw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xf6, 0x00 );
    FCML_I32( "vpsadbw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xf6, 0xc1 );

    FCML_A64( "psadbw (%rax),%mm0", 0x0f, 0xf6, 0x00 );
    FCML_A64( "psadbw %mm1,%mm0", 0x0f, 0xf6, 0xc1 );
    FCML_A64( "psadbw (%rax),%xmm0", 0x66, 0x0f, 0xf6, 0x00 );
    FCML_A64( "psadbw %xmm1,%xmm0", 0x66, 0x0f, 0xf6, 0xc1 );
    FCML_A64( "vpsadbw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf6, 0x00 );
    FCML_A64( "vpsadbw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf6, 0xc1 );
    FCML_A64( "vpsadbw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf6, 0x00 );
    FCML_A64( "vpsadbw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf6, 0xc1 );
}

void fcml_tf_instruction_PSHUFB(void) {

    FCML_I64( "pshufb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x00, 0x00 );
    FCML_I32( "pshufb mm0,mm1", 0x0F, 0x38, 0x00, 0xC1 );

    FCML_I64( "pshufb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x00, 0x00 );
    FCML_I32( "pshufb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x00, 0xC1 );

    FCML_I64( "vpshufb xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x00, 0x00 );
    FCML_I32( "vpshufb xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x00, 0xC1 );

    FCML_I64( "vpshufb ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x00, 0x00 );
    FCML_I32( "vpshufb ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x00, 0xC1 );

    FCML_A64( "pshufb (%rax),%mm0", 0x0f, 0x38, 0x00, 0x00 );
    FCML_A64( "pshufb %mm1,%mm0", 0x0f, 0x38, 0x00, 0xc1 );
    FCML_A64( "pshufb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x00, 0x00 );
    FCML_A64( "pshufb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x00, 0xc1 );
    FCML_A64( "vpshufb (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x00, 0x00 );
    FCML_A64( "vpshufb %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x00, 0xc1 );
    FCML_A64( "vpshufb (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x00, 0x00 );
    FCML_A64( "vpshufb %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x00, 0xc1 );
}

void fcml_tf_instruction_PSHUFD(void) {

    FCML_I64( "pshufd xmm0,xmmword ptr [rax],0ffh", 0x66, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufd xmm0,xmm1,0ffh", 0x66, 0x0F, 0x70, 0xC1, 0xFF );

    FCML_I64( "vpshufd xmm0,xmmword ptr [rax],0ffh", 0xc5, 0xf9, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufd xmm0,xmm1,0ffh", 0xc5, 0xf9, 0x70, 0xc1, 0xff );

    FCML_I64( "vpshufd ymm0,ymmword ptr [rax],0ffh", 0xc5, 0xfd, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufd ymm0,ymm1,0ffh", 0xc5, 0xfd, 0x70, 0xc1, 0xff );

    FCML_A64( "pshufd $0xff,(%rax),%xmm0", 0x66, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufd $0xff,%xmm1,%xmm0", 0x66, 0x0f, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufd $0xff,(%rax),%xmm0", 0xc5, 0xf9, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufd $0xff,%xmm1,%xmm0", 0xc5, 0xf9, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufd $0xff,(%rax),%ymm0", 0xc5, 0xfd, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufd $0xff,%ymm1,%ymm0", 0xc5, 0xfd, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSHUFHW(void) {

    FCML_I64( "pshufhw xmm0,xmmword ptr [rax],0ffh", 0xF3, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufhw xmm0,xmm1,0ffh", 0xF3, 0x0F, 0x70, 0xC1, 0xFF );

    FCML_I64( "vpshufhw xmm0,xmmword ptr [rax],0ffh", 0xc5, 0xfa, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufhw xmm0,xmm1,0ffh", 0xc5, 0xfa, 0x70, 0xc1, 0xff );

    FCML_I64( "vpshufhw ymm0,ymmword ptr [rax],0ffh", 0xc5, 0xfe, 0x70, 0x00, 0xff );
    FCML_I32( "vpshufhw ymm0,ymm1,0ffh", 0xc5, 0xfe, 0x70, 0xc1, 0xff );

    FCML_A64( "pshufhw $0xff,(%rax),%xmm0", 0xf3, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufhw $0xff,%xmm1,%xmm0", 0xf3, 0x0f, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufhw $0xff,(%rax),%xmm0", 0xc5, 0xfa, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufhw $0xff,%xmm1,%xmm0", 0xc5, 0xfa, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshufhw $0xff,(%rax),%ymm0", 0xc5, 0xfe, 0x70, 0x00, 0xff );
    FCML_A64( "vpshufhw $0xff,%ymm1,%ymm0", 0xc5, 0xfe, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSHUFLW(void) {

    FCML_I64( "pshuflw xmm0,xmmword ptr [rax],0ffh", 0xF2, 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshuflw xmm0,xmm1,0ffh", 0xF2, 0x0F, 0x70, 0xC1, 0xFF );

    FCML_I64( "vpshuflw xmm0,xmmword ptr [rax],0ffh", 0xc5, 0xfb, 0x70, 0x00, 0xff );
    FCML_I32( "vpshuflw xmm0,xmm1,0ffh", 0xc5, 0xfb, 0x70, 0xc1, 0xff );

    FCML_I64( "vpshuflw ymm0,ymmword ptr [rax],0ffh", 0xc5, 0xff, 0x70, 0x00, 0xff );
    FCML_I32( "vpshuflw ymm0,ymm1,0ffh", 0xc5, 0xff, 0x70, 0xc1, 0xff );

    FCML_A64( "pshuflw $0xff,(%rax),%xmm0", 0xf2, 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshuflw $0xff,%xmm1,%xmm0", 0xf2, 0x0f, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshuflw $0xff,(%rax),%xmm0", 0xc5, 0xfb, 0x70, 0x00, 0xff );
    FCML_A64( "vpshuflw $0xff,%xmm1,%xmm0", 0xc5, 0xfb, 0x70, 0xc1, 0xff );
    FCML_A64( "vpshuflw $0xff,(%rax),%ymm0", 0xc5, 0xff, 0x70, 0x00, 0xff );
    FCML_A64( "vpshuflw $0xff,%ymm1,%ymm0", 0xc5, 0xff, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSHUFW(void) {

    FCML_I64( "pshufw mm0,mmword ptr [rax],0ffh", 0x0F, 0x70, 0x00, 0xFF );
    FCML_I32( "pshufw mm0,mm1,0ffh", 0x0F, 0x70, 0xC1, 0xFF );

    FCML_A64( "pshufw $0xff,(%rax),%mm0", 0x0f, 0x70, 0x00, 0xff );
    FCML_A64( "pshufw $0xff,%mm1,%mm0", 0x0f, 0x70, 0xc1, 0xff );
}

void fcml_tf_instruction_PSIGN(void) {

    FCML_I64( "psignb mm0,mmword ptr [rax]", 0x0F, 0x38, 0x08, 0x00 );
    FCML_I32( "psignb mm0,mm1", 0x0F, 0x38, 0x08, 0xC1 );

    FCML_I64( "psignw mm0,mmword ptr [rax]", 0x0F, 0x38, 0x09, 0x00 );
    FCML_I32( "psignw mm0,mm1", 0x0F, 0x38, 0x09, 0xC1 );

    FCML_I64( "psignd mm0,mmword ptr [rax]", 0x0F, 0x38, 0x0A, 0x00 );
    FCML_I32( "psignd mm0,mm1", 0x0F, 0x38, 0x0A, 0xC1 );

    FCML_I64( "psignb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x08, 0x00 );
    FCML_I32( "psignb xmm0,xmm1", 0x66, 0x0F, 0x38, 0x08, 0xC1 );

    FCML_I64( "psignw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x09, 0x00 );
    FCML_I32( "psignw xmm0,xmm1", 0x66, 0x0F, 0x38, 0x09, 0xC1 );

    FCML_I64( "psignd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x0A, 0x00 );
    FCML_I32( "psignd xmm0,xmm1", 0x66, 0x0F, 0x38, 0x0A, 0xC1 );

    FCML_I64( "vpsignb xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x08, 0x00 );
    FCML_I32( "vpsignb xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x08, 0xC1 );

    FCML_I64( "vpsignw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x09, 0x00 );
    FCML_I32( "vpsignw xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x09, 0xC1 );

    FCML_I64( "vpsignd xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE2, 0x79, 0x0A, 0x00 );
    FCML_I32( "vpsignd xmm0,xmm0,xmm1", 0xC4, 0xE2, 0x79, 0x0A, 0xC1 );

    FCML_I64( "vpsignb ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x08, 0x00 );
    FCML_I32( "vpsignb ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x08, 0xC1 );

    FCML_I64( "vpsignw ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x09, 0x00 );
    FCML_I32( "vpsignw ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x09, 0xC1 );

    FCML_I64( "vpsignd ymm0,ymm0,ymmword ptr [rax]", 0xC4, 0xE2, 0x7D, 0x0A, 0x00 );
    FCML_I32( "vpsignd ymm0,ymm0,ymm1", 0xC4, 0xE2, 0x7D, 0x0A, 0xC1 );

    FCML_A64( "psignb (%rax),%mm0", 0x0f, 0x38, 0x08, 0x00 );
    FCML_A64( "psignb %mm1,%mm0", 0x0f, 0x38, 0x08, 0xc1 );
    FCML_A64( "psignw (%rax),%mm0", 0x0f, 0x38, 0x09, 0x00 );
    FCML_A64( "psignw %mm1,%mm0", 0x0f, 0x38, 0x09, 0xc1 );
    FCML_A64( "psignd (%rax),%mm0", 0x0f, 0x38, 0x0a, 0x00 );
    FCML_A64( "psignd %mm1,%mm0", 0x0f, 0x38, 0x0a, 0xc1 );
    FCML_A64( "psignb (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x08, 0x00 );
    FCML_A64( "psignb %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x08, 0xc1 );
    FCML_A64( "psignw (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x09, 0x00 );
    FCML_A64( "psignw %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x09, 0xc1 );
    FCML_A64( "psignd (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x0a, 0x00 );
    FCML_A64( "psignd %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x0a, 0xc1 );
    FCML_A64( "vpsignb (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x08, 0x00 );
    FCML_A64( "vpsignb %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x08, 0xc1 );
    FCML_A64( "vpsignw (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x09, 0x00 );
    FCML_A64( "vpsignw %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x09, 0xc1 );
    FCML_A64( "vpsignd (%rax),%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0a, 0x00 );
    FCML_A64( "vpsignd %xmm1,%xmm0,%xmm0", 0xc4, 0xe2, 0x79, 0x0a, 0xc1 );
    FCML_A64( "vpsignb (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x08, 0x00 );
    FCML_A64( "vpsignb %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x08, 0xc1 );
    FCML_A64( "vpsignw (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x09, 0x00 );
    FCML_A64( "vpsignw %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x09, 0xc1 );
    FCML_A64( "vpsignd (%rax),%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0a, 0x00 );
    FCML_A64( "vpsignd %ymm1,%ymm0,%ymm0", 0xc4, 0xe2, 0x7d, 0x0a, 0xc1 );
}

void fcml_tf_instruction_PSLLDQ(void) {

    FCML_I32( "pslldq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xF9, 0xFF );

    FCML_I32_D( "vpslldq xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x73, 0xF8, 0xFF );
    FCML_I32( "vpslldq xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x73, 0xf8, 0xff );

    FCML_I32_D( "vpslldq ymm3,ymm0,0ffh", 0xC4, 0xE1, 0x65, 0x73, 0xF8, 0xFF );
    FCML_I32( "vpslldq ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x73, 0xf8, 0xff );

    FCML_A64( "pslldq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xf9, 0xff );
    FCML_A64( "vpslldq $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x73, 0xf8, 0xff );
    FCML_A64( "vpslldq $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x73, 0xf8, 0xff );
}

void fcml_tf_instruction_PSLL(void) {

    FCML_I64( "psllw mm0,mmword ptr [rax]", 0x0F, 0xF1, 0x00 );
    FCML_I32( "psllw mm0,mm1", 0x0F, 0xF1, 0xC1 );
    FCML_I64( "pslld mm0,mmword ptr [rax]", 0x0F, 0xF2, 0x00 );
    FCML_I32( "pslld mm0,mm1", 0x0F, 0xF2, 0xC1 );
    FCML_I64( "psllq mm0,mmword ptr [rax]", 0x0F, 0xF3, 0x00 );
    FCML_I32( "psllq mm0,mm1", 0x0F, 0xF3, 0xC1 );

    FCML_I64( "psllw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF1, 0x00 );
    FCML_I32( "psllw xmm0,xmm1", 0x66, 0x0F, 0xF1, 0xC1 );
    FCML_I64( "pslld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF2, 0x00 );
    FCML_I32( "pslld xmm0,xmm1", 0x66, 0x0F, 0xF2, 0xC1 );
    FCML_I64( "psllq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF3, 0x00 );
    FCML_I32( "psllq xmm0,xmm1", 0x66, 0x0F, 0xF3, 0xC1 );

    FCML_I32( "psllw mm1,0ffh", 0x0F, 0x71, 0xF1, 0xFF );
    FCML_I32( "pslld mm2,0ffh", 0x0F, 0x72, 0xF2, 0xFF );
    FCML_I32( "psllq mm3,0ffh", 0x0F, 0x73, 0xf3, 0xFF );

    FCML_I32( "psllw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xF1, 0xFF );
    FCML_I32( "pslld xmm1,0ffh", 0x66, 0x0F, 0x72, 0xF1, 0xFF );
    FCML_I32( "psllq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xF1, 0xFF );

    FCML_I64( "vpsllw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf1, 0x00 );
    FCML_I64( "vpsllw ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xf1, 0x00 );
    FCML_I32( "vpsllw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf1, 0xc1 );
    FCML_I32( "vpsllw ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xf1, 0xc1 );
    FCML_I64( "vpslld xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf2, 0x00 );
    FCML_I64( "vpslld ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xf2, 0x00 );
    FCML_I32( "vpslld xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf2, 0xc1 );
    FCML_I32( "vpslld ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xf2, 0xc1 );
    FCML_I64( "vpsllq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf3, 0x00 );
    FCML_I64( "vpsllq ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xf3, 0x00 );
    FCML_I32( "vpsllq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf3, 0xc1 );
    FCML_I32( "vpsllq ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xf3, 0xc1 );

    FCML_I3264( "vpsllw xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x71, 0xf0, 0xff );
    FCML_I3264( "vpslld xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x72, 0xf0, 0xff );
    FCML_I3264( "vpsllq xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x73, 0xf0, 0xff );
    FCML_I3264( "vpsllw ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x71, 0xf0, 0xff );
    FCML_I3264( "vpslld ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x72, 0xf0, 0xff );
    FCML_I3264( "vpsllq ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x73, 0xf0, 0xff );

    FCML_A64( "psllw (%rax),%mm0", 0x0f, 0xf1, 0x00 );
    FCML_A64( "psllw %mm1,%mm0", 0x0f, 0xf1, 0xc1 );
    FCML_A64( "pslld (%rax),%mm0", 0x0f, 0xf2, 0x00 );
    FCML_A64( "pslld %mm1,%mm0", 0x0f, 0xf2, 0xc1 );
    FCML_A64( "psllq (%rax),%mm0", 0x0f, 0xf3, 0x00 );
    FCML_A64( "psllq %mm1,%mm0", 0x0f, 0xf3, 0xc1 );
    FCML_A64( "psllw (%rax),%xmm0", 0x66, 0x0f, 0xf1, 0x00 );
    FCML_A64( "psllw %xmm1,%xmm0", 0x66, 0x0f, 0xf1, 0xc1 );
    FCML_A64( "pslld (%rax),%xmm0", 0x66, 0x0f, 0xf2, 0x00 );
    FCML_A64( "pslld %xmm1,%xmm0", 0x66, 0x0f, 0xf2, 0xc1 );
    FCML_A64( "psllq (%rax),%xmm0", 0x66, 0x0f, 0xf3, 0x00 );
    FCML_A64( "psllq %xmm1,%xmm0", 0x66, 0x0f, 0xf3, 0xc1 );
    FCML_A64( "psllw $0xff,%mm1", 0x0f, 0x71, 0xf1, 0xff );
    FCML_A64( "pslld $0xff,%mm2", 0x0f, 0x72, 0xf2, 0xff );
    FCML_A64( "psllq $0xff,%mm3", 0x0f, 0x73, 0xf3, 0xff );
    FCML_A64( "psllw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xf1, 0xff );
    FCML_A64( "pslld $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xf1, 0xff );
    FCML_A64( "psllq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xf1, 0xff );
    FCML_A64( "vpsllw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf1, 0x00 );
    FCML_A64( "vpsllw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf1, 0x00 );
    FCML_A64( "vpsllw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf1, 0xc1 );
    FCML_A64( "vpsllw %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf1, 0xc1 );
    FCML_A64( "vpslld (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf2, 0x00 );
    FCML_A64( "vpslld (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf2, 0x00 );
    FCML_A64( "vpslld %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf2, 0xc1 );
    FCML_A64( "vpslld %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf2, 0xc1 );
    FCML_A64( "vpsllq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf3, 0x00 );
    FCML_A64( "vpsllq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf3, 0x00 );
    FCML_A64( "vpsllq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf3, 0xc1 );
    FCML_A64( "vpsllq %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf3, 0xc1 );
    FCML_A64( "vpsllw $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x71, 0xf0, 0xff );
    FCML_A64( "vpslld $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x72, 0xf0, 0xff );
    FCML_A64( "vpsllq $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x73, 0xf0, 0xff );
    FCML_A64( "vpsllw $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x71, 0xf0, 0xff );
    FCML_A64( "vpslld $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x72, 0xf0, 0xff );
    FCML_A64( "vpsllq $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x73, 0xf0, 0xff );
}

void fcml_tf_instruction_PSRA(void) {

    FCML_I64( "psraw mm0,mmword ptr [rax]", 0x0F, 0xE1, 0x00 );
    FCML_I32( "psraw mm0,mm1", 0x0F, 0xE1, 0xC1 );
    FCML_I64( "psrad mm0,mmword ptr [rax]", 0x0F, 0xE2, 0x00 );
    FCML_I32( "psrad mm0,mm1", 0x0F, 0xE2, 0xC1 );

    FCML_I64( "psraw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE1, 0x00 );
    FCML_I32( "psraw xmm0,xmm1", 0x66, 0x0F, 0xE1, 0xC1 );
    FCML_I64( "psrad xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE2, 0x00 );
    FCML_I32( "psrad xmm0,xmm1", 0x66, 0x0F, 0xE2, 0xC1 );

    FCML_I64( "vpsraw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe1, 0x00 );
    FCML_I32( "vpsraw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe1, 0xc1 );
    FCML_I64( "vpsrad xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe2, 0x00 );
    FCML_I32( "vpsrad xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe2, 0xc1 );

    FCML_I64( "vpsraw ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xe1, 0x00 );
    FCML_I32( "vpsraw ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xe1, 0xc1 );
    FCML_I64( "vpsrad ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xe2, 0x00 );
    FCML_I32( "vpsrad ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xe2, 0xc1 );

    FCML_I32( "psraw mm1,0ffh", 0x0F, 0x71, 0xE1, 0xFF );
    FCML_I32( "psrad mm2,0ffh", 0x0F, 0x72, 0xE2, 0xFF );

    FCML_I32( "psraw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xE1, 0xFF );
    FCML_I32( "psrad xmm1,0ffh", 0x66, 0x0F, 0x72, 0xE1, 0xFF );

    FCML_I32( "vpsraw xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x71, 0xe0, 0xff );
    FCML_I32( "vpsrad xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x72, 0xe0, 0xff );

    FCML_I32( "vpsraw ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x71, 0xe0, 0xff );
    FCML_I32( "vpsrad ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x72, 0xe0, 0xff );

    FCML_A64( "psraw (%rax),%mm0", 0x0f, 0xe1, 0x00 );
    FCML_A64( "psraw %mm1,%mm0", 0x0f, 0xe1, 0xc1 );
    FCML_A64( "psrad (%rax),%mm0", 0x0f, 0xe2, 0x00 );
    FCML_A64( "psrad %mm1,%mm0", 0x0f, 0xe2, 0xc1 );
    FCML_A64( "psraw (%rax),%xmm0", 0x66, 0x0f, 0xe1, 0x00 );
    FCML_A64( "psraw %xmm1,%xmm0", 0x66, 0x0f, 0xe1, 0xc1 );
    FCML_A64( "psrad (%rax),%xmm0", 0x66, 0x0f, 0xe2, 0x00 );
    FCML_A64( "psrad %xmm1,%xmm0", 0x66, 0x0f, 0xe2, 0xc1 );
    FCML_A64( "vpsraw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe1, 0x00 );
    FCML_A64( "vpsraw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe1, 0xc1 );
    FCML_A64( "vpsrad (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe2, 0x00 );
    FCML_A64( "vpsrad %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe2, 0xc1 );
    FCML_A64( "vpsraw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xe1, 0x00 );
    FCML_A64( "vpsraw %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe1, 0xc1 );
    FCML_A64( "vpsrad (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xe2, 0x00 );
    FCML_A64( "vpsrad %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe2, 0xc1 );
    FCML_A64( "psraw $0xff,%mm1", 0x0f, 0x71, 0xe1, 0xff );
    FCML_A64( "psrad $0xff,%mm2", 0x0f, 0x72, 0xe2, 0xff );
    FCML_A64( "psraw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xe1, 0xff );
    FCML_A64( "psrad $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xe1, 0xff );
    FCML_A64( "vpsraw $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x71, 0xe0, 0xff );
    FCML_A64( "vpsrad $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x72, 0xe0, 0xff );
    FCML_A64( "vpsraw $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x71, 0xe0, 0xff );
    FCML_A64( "vpsrad $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x72, 0xe0, 0xff );
}

void fcml_tf_instruction_PSRLDQ(void) {

    FCML_I32( "pslldq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xF9, 0xFF );

    FCML_I32( "vpslldq xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x73, 0xf8, 0xff );

    FCML_I32( "vpslldq ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x73, 0xf8, 0xff );

    FCML_A64( "pslldq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xf9, 0xff );
    FCML_A64( "vpslldq $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x73, 0xf8, 0xff );
    FCML_A64( "vpslldq $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x73, 0xf8, 0xff );
}

void fcml_tf_instruction_PSRL(void) {

    FCML_I64( "psrlw mm0,mmword ptr [rax]", 0x0F, 0xD1, 0x00 );
    FCML_I32( "psrlw mm0,mm1", 0x0F, 0xD1, 0xC1 );

    FCML_I64( "psrld mm0,mmword ptr [rax]", 0x0F, 0xD2, 0x00 );
    FCML_I32( "psrld mm0,mm1", 0x0F, 0xD2, 0xC1 );

    FCML_I64( "psrlq mm0,mmword ptr [rax]", 0x0F, 0xD3, 0x00 );
    FCML_I32( "psrlq mm0,mm1", 0x0F, 0xD3, 0xC1 );

    FCML_I64( "psrlw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD1, 0x00 );
    FCML_I32( "psrlw xmm0,xmm1", 0x66, 0x0F, 0xD1, 0xC1 );

    FCML_I64( "psrld xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD2, 0x00 );
    FCML_I32( "psrld xmm0,xmm1", 0x66, 0x0F, 0xD2, 0xC1 );

    FCML_I64( "psrlq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD3, 0x00 );
    FCML_I32( "psrlq xmm0,xmm1", 0x66, 0x0F, 0xD3, 0xC1 );

    FCML_I32( "psrlw mm1,0ffh", 0x0F, 0x71, 0xD1, 0xFF );

    FCML_I32( "psrld mm2,0ffh", 0x0F, 0x72, 0xD2, 0xFF );

    FCML_I32( "psrlq mm3,0ffh", 0x0F, 0x73, 0xD3, 0xFF );

    FCML_I32( "psrlw xmm1,0ffh", 0x66, 0x0F, 0x71, 0xD1, 0xFF );

    FCML_I32( "psrld xmm1,0ffh", 0x66, 0x0F, 0x72, 0xD1, 0xFF );

    FCML_I32( "psrlq xmm1,0ffh", 0x66, 0x0F, 0x73, 0xD1, 0xFF );

    FCML_I64_D( "vpsrlw xmm0,xmm0,xmmword ptr [rax]", 0xC4, 0xE1, 0x79, 0xD1, 0x00 );
    FCML_I64( "vpsrlw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd1, 0x00 );
    FCML_I32_D( "vpsrlw xmm0,xmm0,xmm1", 0xC4, 0xE1, 0x79, 0xD1, 0xC1 );
    FCML_I32( "vpsrlw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd1, 0xc1 );

    FCML_I64( "vpsrlw ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xd1, 0x00 );
    FCML_I32( "vpsrlw ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xd1, 0xc1 );

    FCML_I64( "vpsrld xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd2, 0x00 );
    FCML_I32( "vpsrld xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd2, 0xc1 );

    FCML_I64( "vpsrld ymm0,ymm0,xmmword ptr [rax]", 0xc5, 0xfd, 0xd2, 0x00 );
    FCML_I32( "vpsrld ymm0,ymm0,xmm1", 0xc5, 0xfd, 0xd2, 0xc1 );

    FCML_I64( "vpsrlq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd3, 0x00 );
    FCML_I32( "vpsrlq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd3, 0xc1 );

    FCML_I32_D( "vpsrlw xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x71, 0xD0, 0xFF );
    FCML_I32( "vpsrlw xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x71, 0xd0, 0xff );

    FCML_I32_D( "vpsrld xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x72, 0xD0, 0xFF );
    FCML_I32( "vpsrld xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x72, 0xd0, 0xff );

    FCML_I32_D( "vpsrlq xmm3,xmm0,0ffh", 0xC4, 0xE1, 0x61, 0x73, 0xD0, 0xFF );
    FCML_I32( "vpsrlq xmm3,xmm0,0ffh", 0xc5, 0xe1, 0x73, 0xd0, 0xff );

    FCML_I32_D( "vpsrlw ymm3,ymm0,0ffh", 0xC4, 0xE1, 0x65, 0x71, 0xD0, 0xFF );
    FCML_I32( "vpsrlw ymm3,ymm0,0ffh", 0xc5, 0xe5, 0x71, 0xd0, 0xff );

    FCML_A64( "psrlw (%rax),%mm0", 0x0f, 0xd1, 0x00 );
    FCML_A64( "psrlw %mm1,%mm0", 0x0f, 0xd1, 0xc1 );
    FCML_A64( "psrld (%rax),%mm0", 0x0f, 0xd2, 0x00 );
    FCML_A64( "psrld %mm1,%mm0", 0x0f, 0xd2, 0xc1 );
    FCML_A64( "psrlq (%rax),%mm0", 0x0f, 0xd3, 0x00 );
    FCML_A64( "psrlq %mm1,%mm0", 0x0f, 0xd3, 0xc1 );
    FCML_A64( "psrlw (%rax),%xmm0", 0x66, 0x0f, 0xd1, 0x00 );
    FCML_A64( "psrlw %xmm1,%xmm0", 0x66, 0x0f, 0xd1, 0xc1 );
    FCML_A64( "psrld (%rax),%xmm0", 0x66, 0x0f, 0xd2, 0x00 );
    FCML_A64( "psrld %xmm1,%xmm0", 0x66, 0x0f, 0xd2, 0xc1 );
    FCML_A64( "psrlq (%rax),%xmm0", 0x66, 0x0f, 0xd3, 0x00 );
    FCML_A64( "psrlq %xmm1,%xmm0", 0x66, 0x0f, 0xd3, 0xc1 );
    FCML_A64( "psrlw $0xff,%mm1", 0x0f, 0x71, 0xd1, 0xff );
    FCML_A64( "psrld $0xff,%mm2", 0x0f, 0x72, 0xd2, 0xff );
    FCML_A64( "psrlq $0xff,%mm3", 0x0f, 0x73, 0xd3, 0xff );
    FCML_A64( "psrlw $0xff,%xmm1", 0x66, 0x0f, 0x71, 0xd1, 0xff );
    FCML_A64( "psrld $0xff,%xmm1", 0x66, 0x0f, 0x72, 0xd1, 0xff );
    FCML_A64( "psrlq $0xff,%xmm1", 0x66, 0x0f, 0x73, 0xd1, 0xff );
    FCML_A64( "vpsrlw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd1, 0x00 );
    FCML_A64( "vpsrlw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd1, 0xc1 );
    FCML_A64( "vpsrlw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd1, 0x00 );
    FCML_A64( "vpsrlw %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd1, 0xc1 );
    FCML_A64( "vpsrld (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd2, 0x00 );
    FCML_A64( "vpsrld %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd2, 0xc1 );
    FCML_A64( "vpsrld (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd2, 0x00 );
    FCML_A64( "vpsrld %xmm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd2, 0xc1 );
    FCML_A64( "vpsrlq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd3, 0x00 );
    FCML_A64( "vpsrlq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd3, 0xc1 );
    FCML_A64( "vpsrlw $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x71, 0xd0, 0xff );
    FCML_A64( "vpsrld $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x72, 0xd0, 0xff );
    FCML_A64( "vpsrlq $0xff,%xmm0,%xmm3", 0xc5, 0xe1, 0x73, 0xd0, 0xff );
    FCML_A64( "vpsrlw $0xff,%ymm0,%ymm3", 0xc5, 0xe5, 0x71, 0xd0, 0xff );
}

void fcml_tf_instruction_PSUB(void) {

    FCML_I64( "psubb mm0,mmword ptr [rax]", 0x0F, 0xF8, 0x00 );
    FCML_I32( "psubb mm0,mm1", 0x0F, 0xF8, 0xC1 );

    FCML_I64( "psubw mm0,mmword ptr [rax]", 0x0F, 0xF9, 0x00 );
    FCML_I32( "psubw mm0,mm1", 0x0F, 0xF9, 0xC1 );

    FCML_I64( "psubd mm0,mmword ptr [rax]", 0x0F, 0xFA, 0x00 );
    FCML_I32( "psubd mm0,mm1", 0x0F, 0xFA, 0xC1 );

    FCML_I64( "psubb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF8, 0x00 );
    FCML_I32( "psubb xmm0,xmm1", 0x66, 0x0F, 0xF8, 0xC1 );

    FCML_I64( "psubw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xF9, 0x00 );
    FCML_I32( "psubw xmm0,xmm1", 0x66, 0x0F, 0xF9, 0xC1 );

    FCML_I64( "psubd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFA, 0x00 );
    FCML_I32( "psubd xmm0,xmm1", 0x66, 0x0F, 0xFA, 0xC1 );

    FCML_I64( "vpsubb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf8, 0x00 );
    FCML_I32( "vpsubb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf8, 0xc1 );

    FCML_I64( "vpsubw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xf9, 0x00 );
    FCML_I32( "vpsubw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xf9, 0xc1 );

    FCML_I64( "vpsubd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xfa, 0x00 );
    FCML_I32( "vpsubd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xfa, 0xc1 );

    FCML_I64( "vpsubb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xf8, 0x00 );
    FCML_I32( "vpsubb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xf8, 0xc1 );

    FCML_I64( "vpsubw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xf9, 0x00 );
    FCML_I32( "vpsubw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xf9, 0xc1 );

    FCML_I64( "vpsubd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xfa, 0x00 );
    FCML_I32( "vpsubd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xfa, 0xc1 );

    FCML_I64( "vpsubq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xfb, 0x00 );
    FCML_I32( "vpsubq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xfb, 0xc1 );

    FCML_A64( "psubb (%rax),%mm0", 0x0f, 0xf8, 0x00 );
    FCML_A64( "psubb %mm1,%mm0", 0x0f, 0xf8, 0xc1 );
    FCML_A64( "psubw (%rax),%mm0", 0x0f, 0xf9, 0x00 );
    FCML_A64( "psubw %mm1,%mm0", 0x0f, 0xf9, 0xc1 );
    FCML_A64( "psubd (%rax),%mm0", 0x0f, 0xfa, 0x00 );
    FCML_A64( "psubd %mm1,%mm0", 0x0f, 0xfa, 0xc1 );
    FCML_A64( "psubb (%rax),%xmm0", 0x66, 0x0f, 0xf8, 0x00 );
    FCML_A64( "psubb %xmm1,%xmm0", 0x66, 0x0f, 0xf8, 0xc1 );
    FCML_A64( "psubw (%rax),%xmm0", 0x66, 0x0f, 0xf9, 0x00 );
    FCML_A64( "psubw %xmm1,%xmm0", 0x66, 0x0f, 0xf9, 0xc1 );
    FCML_A64( "psubd (%rax),%xmm0", 0x66, 0x0f, 0xfa, 0x00 );
    FCML_A64( "psubd %xmm1,%xmm0", 0x66, 0x0f, 0xfa, 0xc1 );
    FCML_A64( "vpsubb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf8, 0x00 );
    FCML_A64( "vpsubb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf8, 0xc1 );
    FCML_A64( "vpsubw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xf9, 0x00 );
    FCML_A64( "vpsubw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xf9, 0xc1 );
    FCML_A64( "vpsubd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xfa, 0x00 );
    FCML_A64( "vpsubd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xfa, 0xc1 );
    FCML_A64( "vpsubb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf8, 0x00 );
    FCML_A64( "vpsubb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf8, 0xc1 );
    FCML_A64( "vpsubw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xf9, 0x00 );
    FCML_A64( "vpsubw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xf9, 0xc1 );
    FCML_A64( "vpsubd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xfa, 0x00 );
    FCML_A64( "vpsubd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xfa, 0xc1 );
    FCML_A64( "vpsubq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xfb, 0x00 );
    FCML_A64( "vpsubq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xfb, 0xc1 );
}

void fcml_tf_instruction_PSUBQ(void) {

    FCML_I64( "psubq mm0,mmword ptr [rax]", 0x0F, 0xFB, 0x00 );
    FCML_I32( "psubq mm0,mm1", 0x0F, 0xFB, 0xC1 );

    FCML_I64( "psubq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xFB, 0x00 );
    FCML_I32( "psubq xmm0,xmm1", 0x66, 0x0F, 0xFB, 0xC1 );

    FCML_I64( "vpsubq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xfb, 0x00 );
    FCML_I32( "vpsubq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xfb, 0xc1 );

    FCML_A64( "psubq (%rax),%mm0", 0x0f, 0xfb, 0x00 );
    FCML_A64( "psubq %mm1,%mm0", 0x0f, 0xfb, 0xc1 );
    FCML_A64( "psubq (%rax),%xmm0", 0x66, 0x0f, 0xfb, 0x00 );
    FCML_A64( "psubq %xmm1,%xmm0", 0x66, 0x0f, 0xfb, 0xc1 );
    FCML_A64( "vpsubq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xfb, 0x00 );
    FCML_A64( "vpsubq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xfb, 0xc1 );
}

void fcml_tf_instruction_PSUBS(void) {

    FCML_I64( "psubsb mm0,mmword ptr [rax]", 0x0F, 0xE8, 0x00 );
    FCML_I32( "psubsb mm0,mm1", 0x0F, 0xE8, 0xC1 );

    FCML_I64( "psubsw mm0,mmword ptr [rax]", 0x0F, 0xE9, 0x00 );
    FCML_I32( "psubsw mm0,mm1", 0x0F, 0xE9, 0xC1 );

    FCML_I64( "psubsb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE8, 0x00 );
    FCML_I32( "psubsb xmm0,xmm1", 0x66, 0x0F, 0xE8, 0xC1 );

    FCML_I64( "psubsw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xE9, 0x00 );
    FCML_I32( "psubsw xmm0,xmm1", 0x66, 0x0F, 0xE9, 0xC1 );

    FCML_I64( "vpsubsb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe8, 0x00 );
    FCML_I32( "vpsubsb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe8, 0xc1 );

    FCML_I64( "vpsubsw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xe9, 0x00 );
    FCML_I32( "vpsubsw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xe9, 0xc1 );

    FCML_I64( "vpsubsb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xe8, 0x00 );
    FCML_I32( "vpsubsb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xe8, 0xc1 );

    FCML_I64( "vpsubsw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xe9, 0x00 );
    FCML_I32( "vpsubsw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xe9, 0xc1 );

    FCML_A64( "psubsb (%rax),%mm0", 0x0f, 0xe8, 0x00 );
    FCML_A64( "psubsb %mm1,%mm0", 0x0f, 0xe8, 0xc1 );
    FCML_A64( "psubsw (%rax),%mm0", 0x0f, 0xe9, 0x00 );
    FCML_A64( "psubsw %mm1,%mm0", 0x0f, 0xe9, 0xc1 );
    FCML_A64( "psubsb (%rax),%xmm0", 0x66, 0x0f, 0xe8, 0x00 );
    FCML_A64( "psubsb %xmm1,%xmm0", 0x66, 0x0f, 0xe8, 0xc1 );
    FCML_A64( "psubsw (%rax),%xmm0", 0x66, 0x0f, 0xe9, 0x00 );
    FCML_A64( "psubsw %xmm1,%xmm0", 0x66, 0x0f, 0xe9, 0xc1 );
    FCML_A64( "vpsubsb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe8, 0x00 );
    FCML_A64( "vpsubsb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe8, 0xc1 );
    FCML_A64( "vpsubsw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xe9, 0x00 );
    FCML_A64( "vpsubsw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xe9, 0xc1 );
    FCML_A64( "vpsubsb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xe8, 0x00 );
    FCML_A64( "vpsubsb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe8, 0xc1 );
    FCML_A64( "vpsubsw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xe9, 0x00 );
    FCML_A64( "vpsubsw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xe9, 0xc1 );
}

void fcml_tf_instruction_PSUBUS(void) {

    FCML_I64( "psubusb mm0,mmword ptr [rax]", 0x0F, 0xD8, 0x00 );
    FCML_I32( "psubusb mm0,mm1", 0x0F, 0xD8, 0xC1 );

    FCML_I64( "psubusw mm0,mmword ptr [rax]", 0x0F, 0xD9, 0x00 );
    FCML_I32( "psubusw mm0,mm1", 0x0F, 0xD9, 0xC1 );

    FCML_I64( "psubusb xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD8, 0x00 );
    FCML_I32( "psubusb xmm0,xmm1", 0x66, 0x0F, 0xD8, 0xC1 );

    FCML_I64( "psubusw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xD9, 0x00 );
    FCML_I32( "psubusw xmm0,xmm1", 0x66, 0x0F, 0xD9, 0xC1 );

    FCML_I64( "vpsubusb xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd8, 0x00 );
    FCML_I32( "vpsubusb xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd8, 0xc1 );

    FCML_I64( "vpsubusw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xd9, 0x00 );
    FCML_I32( "vpsubusw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xd9, 0xc1 );

    FCML_I64( "vpsubusb ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xd8, 0x00 );
    FCML_I32( "vpsubusb ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xd8, 0xc1 );

    FCML_I64( "vpsubusw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xd9, 0x00 );
    FCML_I32( "vpsubusw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xd9, 0xc1 );

    FCML_A64( "psubusb (%rax),%mm0", 0x0f, 0xd8, 0x00 );
    FCML_A64( "psubusb %mm1,%mm0", 0x0f, 0xd8, 0xc1 );
    FCML_A64( "psubusw (%rax),%mm0", 0x0f, 0xd9, 0x00 );
    FCML_A64( "psubusw %mm1,%mm0", 0x0f, 0xd9, 0xc1 );
    FCML_A64( "psubusb (%rax),%xmm0", 0x66, 0x0f, 0xd8, 0x00 );
    FCML_A64( "psubusb %xmm1,%xmm0", 0x66, 0x0f, 0xd8, 0xc1 );
    FCML_A64( "psubusw (%rax),%xmm0", 0x66, 0x0f, 0xd9, 0x00 );
    FCML_A64( "psubusw %xmm1,%xmm0", 0x66, 0x0f, 0xd9, 0xc1 );
    FCML_A64( "vpsubusb (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd8, 0x00 );
    FCML_A64( "vpsubusb %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd8, 0xc1 );
    FCML_A64( "vpsubusw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xd9, 0x00 );
    FCML_A64( "vpsubusw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xd9, 0xc1 );
    FCML_A64( "vpsubusb (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd8, 0x00 );
    FCML_A64( "vpsubusb %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd8, 0xc1 );
    FCML_A64( "vpsubusw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xd9, 0x00 );
    FCML_A64( "vpsubusw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xd9, 0xc1 );
}

void fcml_tf_instruction_PTEST(void) {

    FCML_I64( "ptest xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x38, 0x17, 0x00 );
    FCML_I32( "ptest xmm0,xmm1", 0x66, 0x0F, 0x38, 0x17, 0xC1 );

    FCML_I64( "vptest xmm3,xmm0", 0xC4, 0xE2, 0x79, 0x17, 0xD8 );
    FCML_I32( "vptest xmm3,xmm0", 0xC4, 0xE2, 0x79, 0x17, 0xD8 );
    FCML_I32( "vptest ymm0,ymmword ptr [eax]", 0xC4, 0xE2, 0x7D, 0x17, 0x00 );

    FCML_A64( "ptest (%rax),%xmm0", 0x66, 0x0f, 0x38, 0x17, 0x00 );
    FCML_A64( "ptest %xmm1,%xmm0", 0x66, 0x0f, 0x38, 0x17, 0xc1 );
    FCML_A64( "vptest %xmm0,%xmm3", 0xc4, 0xe2, 0x79, 0x17, 0xd8 );
    FCML_A64( "vptest %xmm0,%xmm3", 0xc4, 0xe2, 0x79, 0x17, 0xd8 );
    FCML_A64( "vptest (%rax),%ymm0", 0xc4, 0xe2, 0x7d, 0x17, 0x00 );
}

void fcml_tf_instruction_PUNPCKLB(void) {

    FCML_I64( "punpcklbw mm0,dword ptr [rax]", 0x0F, 0x60, 0x00 );
    FCML_I32( "punpcklbw mm0,mm1", 0x0F, 0x60, 0xC1 );

    FCML_I64( "punpcklwd mm0,dword ptr [rax]", 0x0F, 0x61, 0x00 );
    FCML_I32( "punpcklwd mm0,mm1", 0x0F, 0x61, 0xC1 );

    FCML_I64( "punpckldq mm0,dword ptr [rax]", 0x0F, 0x62, 0x00 );
    FCML_I32( "punpckldq mm0,mm1", 0x0F, 0x62, 0xC1 );

    FCML_I64( "punpcklbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x60, 0x00 );
    FCML_I32( "punpcklbw xmm0,xmm1", 0x66, 0x0F, 0x60, 0xC1 );

    FCML_I64( "punpcklwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x61, 0x00 );
    FCML_I32( "punpcklwd xmm0,xmm1", 0x66, 0x0F, 0x61, 0xC1 );

    FCML_I64( "punpckldq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x62, 0x00 );
    FCML_I32( "punpckldq xmm0,xmm1", 0x66, 0x0F, 0x62, 0xC1 );

    FCML_I64( "punpcklqdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6c, 0x00 );
    FCML_I32( "punpcklqdq xmm0,xmm1", 0x66, 0x0F, 0x6c, 0xC1 );

    FCML_I64( "vpunpcklbw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x60, 0x00 );
    FCML_I32( "vpunpcklbw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x60, 0xc1 );

    FCML_I64( "vpunpcklwd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x61, 0x00 );
    FCML_I32( "vpunpcklwd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x61, 0xc1 );

    FCML_I64( "vpunpckldq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x62, 0x00 );
    FCML_I32( "vpunpckldq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x62, 0xc1 );

    FCML_I64( "vpunpcklqdq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x6c, 0x00 );
    FCML_I32( "vpunpcklqdq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x6c, 0xc1 );

    FCML_I64( "vpunpcklbw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x60, 0x00 );
    FCML_I32( "vpunpcklbw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x60, 0xc1 );

    FCML_I64( "vpunpcklwd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x61, 0x00 );
    FCML_I32( "vpunpcklwd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x61, 0xc1 );

    FCML_I64( "vpunpckldq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x62, 0x00 );
    FCML_I32( "vpunpckldq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x62, 0xc1 );

    FCML_I64( "vpunpcklqdq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x6c, 0x00 );
    FCML_I32( "vpunpcklqdq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x6c, 0xc1 );

    FCML_A64( "punpcklbw (%rax),%mm0", 0x0f, 0x60, 0x00 );
    FCML_A64( "punpcklbw %mm1,%mm0", 0x0f, 0x60, 0xc1 );
    FCML_A64( "punpcklwd (%rax),%mm0", 0x0f, 0x61, 0x00 );
    FCML_A64( "punpcklwd %mm1,%mm0", 0x0f, 0x61, 0xc1 );
    FCML_A64( "punpckldq (%rax),%mm0", 0x0f, 0x62, 0x00 );
    FCML_A64( "punpckldq %mm1,%mm0", 0x0f, 0x62, 0xc1 );
    FCML_A64( "punpcklbw (%rax),%xmm0", 0x66, 0x0f, 0x60, 0x00 );
    FCML_A64( "punpcklbw %xmm1,%xmm0", 0x66, 0x0f, 0x60, 0xc1 );
    FCML_A64( "punpcklwd (%rax),%xmm0", 0x66, 0x0f, 0x61, 0x00 );
    FCML_A64( "punpcklwd %xmm1,%xmm0", 0x66, 0x0f, 0x61, 0xc1 );
    FCML_A64( "punpckldq (%rax),%xmm0", 0x66, 0x0f, 0x62, 0x00 );
    FCML_A64( "punpckldq %xmm1,%xmm0", 0x66, 0x0f, 0x62, 0xc1 );
    FCML_A64( "punpcklqdq (%rax),%xmm0", 0x66, 0x0f, 0x6c, 0x00 );
    FCML_A64( "punpcklqdq %xmm1,%xmm0", 0x66, 0x0f, 0x6c, 0xc1 );
    FCML_A64( "vpunpcklbw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x60, 0x00 );
    FCML_A64( "vpunpcklbw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x60, 0xc1 );
    FCML_A64( "vpunpcklwd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x61, 0x00 );
    FCML_A64( "vpunpcklwd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x61, 0xc1 );
    FCML_A64( "vpunpckldq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x62, 0x00 );
    FCML_A64( "vpunpckldq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x62, 0xc1 );
    FCML_A64( "vpunpcklqdq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x6c, 0x00 );
    FCML_A64( "vpunpcklqdq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x6c, 0xc1 );
    FCML_A64( "vpunpcklbw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x60, 0x00 );
    FCML_A64( "vpunpcklbw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x60, 0xc1 );
    FCML_A64( "vpunpcklwd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x61, 0x00 );
    FCML_A64( "vpunpcklwd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x61, 0xc1 );
    FCML_A64( "vpunpckldq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x62, 0x00 );
    FCML_A64( "vpunpckldq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x62, 0xc1 );
    FCML_A64( "vpunpcklqdq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x6c, 0x00 );
    FCML_A64( "vpunpcklqdq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x6c, 0xc1 );
}

void fcml_tf_instruction_PUNPCKHB(void) {

    FCML_I64( "punpckhbw mm0,mmword ptr [rax]", 0x0F, 0x68, 0x00 );
    FCML_I32( "punpckhbw mm0,mm1", 0x0F, 0x68, 0xC1 );

    FCML_I64( "punpckhwd mm0,mmword ptr [rax]", 0x0F, 0x69, 0x00 );
    FCML_I32( "punpckhwd mm0,mm1", 0x0F, 0x69, 0xC1 );

    FCML_I64( "punpckhdq mm0,mmword ptr [rax]", 0x0F, 0x6A, 0x00 );
    FCML_I32( "punpckhdq mm0,mm1", 0x0F, 0x6A, 0xC1 );

    FCML_I64( "punpckhbw xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x68, 0x00 );
    FCML_I32( "punpckhbw xmm0,xmm1", 0x66, 0x0F, 0x68, 0xC1 );

    FCML_I64( "punpckhwd xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x69, 0x00 );
    FCML_I32( "punpckhwd xmm0,xmm1", 0x66, 0x0F, 0x69, 0xC1 );

    FCML_I64( "punpckhdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6A, 0x00 );
    FCML_I32( "punpckhdq xmm0,xmm1", 0x66, 0x0F, 0x6A, 0xC1 );

    FCML_I64( "punpckhqdq xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0x6D, 0x00 );
    FCML_I32( "punpckhqdq xmm0,xmm1", 0x66, 0x0F, 0x6D, 0xC1 );

    FCML_I64( "vpunpckhbw xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x68, 0x00 );
    FCML_I32( "vpunpckhbw xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x68, 0xc1 );

    FCML_I64( "vpunpckhwd xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x69, 0x00 );
    FCML_I32( "vpunpckhwd xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x69, 0xc1 );

    FCML_I64( "vpunpckhdq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x6a, 0x00 );
    FCML_I32( "vpunpckhdq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x6a, 0xc1 );

    FCML_I64( "vpunpckhqdq xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0x6d, 0x00 );
    FCML_I32( "vpunpckhqdq xmm0,xmm0,xmm1", 0xc5, 0xf9, 0x6d, 0xc1 );

    FCML_I64( "vpunpckhbw ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x68, 0x00 );
    FCML_I32( "vpunpckhbw ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x68, 0xc1 );

    FCML_I64( "vpunpckhwd ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x69, 0x00 );
    FCML_I32( "vpunpckhwd ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x69, 0xc1 );

    FCML_I64( "vpunpckhdq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x6a, 0x00 );
    FCML_I32( "vpunpckhdq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x6a, 0xc1 );

    FCML_I64( "vpunpckhqdq ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0x6d, 0x00 );
    FCML_I32( "vpunpckhqdq ymm0,ymm0,ymm1", 0xc5, 0xfd, 0x6d, 0xc1 );

    FCML_A64( "punpckhbw (%rax),%mm0", 0x0f, 0x68, 0x00 );
    FCML_A64( "punpckhbw %mm1,%mm0", 0x0f, 0x68, 0xc1 );
    FCML_A64( "punpckhwd (%rax),%mm0", 0x0f, 0x69, 0x00 );
    FCML_A64( "punpckhwd %mm1,%mm0", 0x0f, 0x69, 0xc1 );
    FCML_A64( "punpckhdq (%rax),%mm0", 0x0f, 0x6a, 0x00 );
    FCML_A64( "punpckhdq %mm1,%mm0", 0x0f, 0x6a, 0xc1 );
    FCML_A64( "punpckhbw (%rax),%xmm0", 0x66, 0x0f, 0x68, 0x00 );
    FCML_A64( "punpckhbw %xmm1,%xmm0", 0x66, 0x0f, 0x68, 0xc1 );
    FCML_A64( "punpckhwd (%rax),%xmm0", 0x66, 0x0f, 0x69, 0x00 );
    FCML_A64( "punpckhwd %xmm1,%xmm0", 0x66, 0x0f, 0x69, 0xc1 );
    FCML_A64( "punpckhdq (%rax),%xmm0", 0x66, 0x0f, 0x6a, 0x00 );
    FCML_A64( "punpckhdq %xmm1,%xmm0", 0x66, 0x0f, 0x6a, 0xc1 );
    FCML_A64( "punpckhqdq (%rax),%xmm0", 0x66, 0x0f, 0x6d, 0x00 );
    FCML_A64( "punpckhqdq %xmm1,%xmm0", 0x66, 0x0f, 0x6d, 0xc1 );
    FCML_A64( "vpunpckhbw (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x68, 0x00 );
    FCML_A64( "vpunpckhbw %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x68, 0xc1 );
    FCML_A64( "vpunpckhwd (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x69, 0x00 );
    FCML_A64( "vpunpckhwd %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x69, 0xc1 );
    FCML_A64( "vpunpckhdq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x6a, 0x00 );
    FCML_A64( "vpunpckhdq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x6a, 0xc1 );
    FCML_A64( "vpunpckhqdq (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0x6d, 0x00 );
    FCML_A64( "vpunpckhqdq %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0x6d, 0xc1 );
    FCML_A64( "vpunpckhbw (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x68, 0x00 );
    FCML_A64( "vpunpckhbw %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x68, 0xc1 );
    FCML_A64( "vpunpckhwd (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x69, 0x00 );
    FCML_A64( "vpunpckhwd %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x69, 0xc1 );
    FCML_A64( "vpunpckhdq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x6a, 0x00 );
    FCML_A64( "vpunpckhdq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x6a, 0xc1 );
    FCML_A64( "vpunpckhqdq (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0x6d, 0x00 );
    FCML_A64( "vpunpckhqdq %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0x6d, 0xc1 );
}

void fcml_tf_instruction_PUSH(void) {

    FCML_I32( "push dword ptr [eax]", 0xFF, 0x30 );
    FCML_I32_M( "push ecx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_I32( "push word ptr [eax]", 0x66, 0xFF, 0x30 );
    FCML_I32_M( "push cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_I32( "push dword ptr [bx+si]", 0x67, 0xFF, 0x30 );
    FCML_I32_D( "push ecx", 0x67, 0xFF, 0xF1 );
    FCML_I32( "push word ptr [bx+si]", 0x66, 0x67, 0xFF, 0x30 );
    FCML_I32_D( "push cx", 0x66, 0x67, 0xFF, 0xF1 );

    FCML_A32( "pushl (%eax)", 0xFF, 0x30 );

    FCML_I64( "push qword ptr [rax]", 0xFF, 0x30 );
    FCML_I64_M( "push rcx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_I64( "push word ptr [rax]", 0x66, 0xFF, 0x30 );
    FCML_I64_M( "push cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_I64( "push qword ptr [eax]", 0x67, 0xFF, 0x30 );
    FCML_I64_D( "push rcx", 0x67, 0xFF, 0xF1 );
    FCML_I64( "push word ptr [eax]", 0x66, 0x67, 0xFF, 0x30 );
    FCML_I64_D( "push cx", 0x66, 0x67, 0xFF, 0xF1 );
    FCML_I64_D( "push qword ptr [rax]", 0x48, 0xFF, 0x30 );
    FCML_I64_D( "push rcx", 0x48, 0xFF, 0xF1 );

    FCML_A64( "pushq (%rax)", 0xFF, 0x30 );
    FCML_A64_M( "push %rcx", 2, FCML_MI( 0x51 ), FCML_MI( 0xff, 0xf1 ) );
    FCML_A64( "pushw (%rax)", 0x66, 0xFF, 0x30 );
    FCML_A64_M( "push %cx", 2, FCML_MI( 0x66, 0x51 ), FCML_MI( 0x66, 0xff, 0xf1 ) );
    FCML_A64( "pushq (%eax)", 0x67, 0xFF, 0x30 );
    FCML_A64_D( "push %rcx", 0x67, 0xFF, 0xF1 );
    FCML_A64( "pushw (%eax)", 0x66, 0x67, 0xFF, 0x30 );
    FCML_A64_D( "push %cx", 0x66, 0x67, 0xFF, 0xF1 );
    FCML_A64_D( "pushq (%rax)", 0x48, 0xFF, 0x30 );
    FCML_A64_D( "push %rcx", 0x48, 0xFF, 0xF1 );

    FCML_I32_M( "push eax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
    FCML_I32_M( "push ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
    FCML_I32_D( "push eax", 0x67, 0x50 );
    FCML_I64_M( "push rax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
    FCML_I64_M( "push ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
    FCML_I64_D( "push rax", 0x67, 0x50 );
    FCML_I64_D( "push rax", 0x48, 0x50 );

    FCML_A64_M( "push %rax", 2, FCML_MI( 0x50 ), FCML_MI( 0xff, 0xf0 ) );
	FCML_A64_M( "push %ax", 2, FCML_MI( 0x66, 0x50 ), FCML_MI( 0x66, 0xff, 0xf0 ) );
	FCML_A64_D( "push %rax", 0x67, 0x50 );
	FCML_A64_D( "push %rax", 0x48, 0x50 );

    FCML_I32_M( "push 0ffffffffh", 2, FCML_MI( 0x68, 0xff, 0xff, 0xff, 0xff ), FCML_MI( 0x6a, 0xff ) );
    FCML_I32_M( "push 00000020h", 2, FCML_MI( 0x68, 0x20, 0x00, 0x00, 0x00 ), FCML_MI( 0x6a, 0x20 ) );
    FCML_I32_M( "push 0ffffh", 2, FCML_MI( 0x66, 0x68, 0xff, 0xff ), FCML_MI( 0x66, 0x6a, 0xff ) );
    FCML_I32( "push 50402020h", 0x68, 0x20, 0x20, 0x40, 0x50 );
    FCML_I32( "push 11ff20ffh", 0x68, 0xFF, 0x20, 0xFF, 0x11 );
    FCML_I64( "push 11ffh", 0x66, 0x68, 0xff, 0x11 );
	FCML_I64_A( "push 11ffh", 0x68, 0xff, 0x11, 0x00, 0x00 );
    FCML_I32( "push 11ffh", 0x66, 0x68, 0xff, 0x11 );
	FCML_I32_A( "push 11ffh", 0x68, 0xff, 0x11, 0x00, 0x00 );
	FCML_I64( "push 00000000221111ffh", 0x68, 0xFF, 0x11, 0x11, 0x22 );
    FCML_I64_D( "push 00000000221111ffh", 0x48, 0x68, 0xFF, 0x11, 0x11, 0x22 );
    FCML_I64( "push 00000000221111ffh", 0x68, 0xff, 0x11, 0x11, 0x22 );
    FCML_I64( "push 0ffffffffff1111ffh", 0x68, 0xFF, 0x11, 0x11, 0xFF );
    FCML_I64_D( "push 0ffffffffff1111ffh", 0x48, 0x68, 0xFF, 0x11, 0x11, 0xFF );
    FCML_I16( "push 11ffh", 0x68, 0xff, 0x11 );

    FCML_A64( "pushq $0xffffffffffffffff", 0x68, 0xff, 0xff, 0xff, 0xff );
    FCML_A64( "pushq $0x00000000221111ff", 0x68, 0xff, 0x11, 0x11, 0x22 );
    FCML_A32( "pushw $0x11ff", 0x66, 0x68, 0xff, 0x11 );
    FCML_A32( "pushl $0x000011ff", 0x68, 0xff, 0x11, 0x00, 0x00 );

    FCML_I32( "push cs", 0x0e );
    FCML_I32( "push ss", 0x16 );
    FCML_I32( "push ds", 0x1e );
    FCML_I32( "push es", 0x06 );
    FCML_I64_FAILED( "push cs", 0x0e );
    FCML_I64_FAILED( "push ss", 0x16 );
    FCML_I64_FAILED( "push ds", 0x1e );
    FCML_I64_FAILED( "push es", 0x06 );

    FCML_A32( "push %cs", 0x0e );
	FCML_A32( "push %ss", 0x16 );
	FCML_A32( "push %ds", 0x1e );
	FCML_A32( "push %es", 0x06 );

    FCML_I32( "push fs", 0x0f, 0xa0 );
    FCML_I32( "push gs", 0x0f, 0xa8 );
    FCML_I64( "push fs", 0x0f, 0xa0 );
    FCML_I64( "push gs", 0x0f, 0xa8 );

	FCML_A32( "pushw %fs", 0x66, 0x0f, 0xa0 );
	FCML_A32( "pushl %fs", 0x0f, 0xa0 );
	FCML_A32_A( "push %fs", 0x0f, 0xa0 );
	FCML_A64( "pushw %fs", 0x66, 0x0f, 0xa0 );
	FCML_A64( "pushq %fs", 0x0f, 0xa0 );
	FCML_A64_A( "push %fs", 0x0f, 0xa0 );
	FCML_A32( "pushw %gs", 0x66, 0x0f, 0xa8 );
	FCML_A32( "pushl %gs", 0x0f, 0xa8 );
	FCML_A32_A( "push %gs", 0x0f, 0xa8 );
	FCML_A64( "pushw %gs", 0x66, 0x0f, 0xa8 );
	FCML_A64( "pushq %gs", 0x0f, 0xa8 );
	FCML_A64_A( "push %gs", 0x0f, 0xa8 );
}

void fcml_tf_instruction_PUSHA(void) {

    FCML_I32( "pushad", 0x60 );
    FCML_I64_FAILED( "pushad", 0x60 );
    FCML_I32( "pusha", 0x66, 0x60 );

    FCML_A32( "pusha", 0x60 );
	FCML_A32( "pushaw", 0x66, 0x60 );
}

void fcml_tf_instruction_PUSHF(void) {

    FCML_I32( "pushf", 0x66, 0x9C );
    FCML_I64( "pushf", 0x66, 0x9C );

    FCML_I32( "pushfd", 0x9C );
    FCML_I64_FAILED( "pushfd", 0x9C );

    FCML_I64( "pushfq", 0x9C );

    FCML_A32( "pushfw", 0x66, 0x9c );
    FCML_A32( "pushf", 0x9c );
    FCML_A64( "pushfw", 0x66, 0x9c );
    FCML_A64( "pushfq", 0x9c );
}

void fcml_tf_instruction_PXOR(void) {

    FCML_I64( "pxor mm0,mmword ptr [rax]", 0x0F, 0xEF, 0x00 );
    FCML_I32( "pxor mm0,mm1", 0x0F, 0xEF, 0xC1 );

    FCML_I64( "pxor xmm0,xmmword ptr [rax]", 0x66, 0x0F, 0xEF, 0x00 );
    FCML_I32( "pxor xmm0,xmm1", 0x66, 0x0F, 0xEF, 0xC1 );

    FCML_I64( "vpxor xmm0,xmm0,xmmword ptr [rax]", 0xc5, 0xf9, 0xef, 0x00 );
    FCML_I32( "vpxor xmm0,xmm0,xmm1", 0xc5, 0xf9, 0xef, 0xc1 );

    FCML_I64( "vpxor ymm0,ymm0,ymmword ptr [rax]", 0xc5, 0xfd, 0xef, 0x00 );
    FCML_I32( "vpxor ymm0,ymm0,ymm1", 0xc5, 0xfd, 0xef, 0xc1 );

    FCML_A64( "pxor (%rax),%mm0", 0x0f, 0xef, 0x00 );
    FCML_A64( "pxor %mm1,%mm0", 0x0f, 0xef, 0xc1 );
    FCML_A64( "pxor (%rax),%xmm0", 0x66, 0x0f, 0xef, 0x00 );
    FCML_A64( "pxor %xmm1,%xmm0", 0x66, 0x0f, 0xef, 0xc1 );
    FCML_A64( "vpxor (%rax),%xmm0,%xmm0", 0xc5, 0xf9, 0xef, 0x00 );
    FCML_A64( "vpxor %xmm1,%xmm0,%xmm0", 0xc5, 0xf9, 0xef, 0xc1 );
    FCML_A64( "vpxor (%rax),%ymm0,%ymm0", 0xc5, 0xfd, 0xef, 0x00 );
    FCML_A64( "vpxor %ymm1,%ymm0,%ymm0", 0xc5, 0xfd, 0xef, 0xc1 );
}

void fcml_tf_instruction_PAVGUSB(void) {

	FCML_I32( "pavgusb mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xBF );
    FCML_I64( "pavgusb mm0,mm1", 0x0F, 0x0F, 0xC1, 0xBF );

    FCML_A64( "pavgusb (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xbf );
    FCML_A64( "pavgusb %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xbf );
}

void fcml_tf_instruction_PF2ID(void) {

    FCML_I32( "pf2id mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x1D );
    FCML_I64( "pf2id mm0,mm1", 0x0F, 0x0F, 0xC1, 0x1D );

    FCML_A64( "pf2id (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x1d );
    FCML_A64( "pf2id %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x1d );
}

void fcml_tf_instruction_PFACC(void) {

    FCML_I32( "pfacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xAE );
    FCML_I64( "pfacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0xAE );

    FCML_A64( "pfacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xae );
    FCML_A64( "pfacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xae );
}

void fcml_tf_instruction_PFADD(void) {

    FCML_I32( "pfadd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x9E );
    FCML_I64( "pfadd mm0,mm1", 0x0F, 0x0F, 0xC1, 0x9E );

    FCML_A64( "pfadd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x9e );
    FCML_A64( "pfadd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x9e );
}

void fcml_tf_instruction_PFCMPEQ(void) {

    FCML_I32( "pfcmpeq mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB0 );
    FCML_I64( "pfcmpeq mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB0 );

    FCML_A64( "pfcmpeq (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb0 );
    FCML_A64( "pfcmpeq %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb0 );
}

void fcml_tf_instruction_PFCMPGE(void) {

    FCML_I32( "pfcmpge mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x90 );
    FCML_I64( "pfcmpge mm0,mm1", 0x0F, 0x0F, 0xC1, 0x90 );

    FCML_A64( "pfcmpeq (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb0 );
    FCML_A64( "pfcmpeq %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb0 );
}

void fcml_tf_instruction_PFCMPGT(void) {

    FCML_I32( "pfcmpgt mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA0 );
    FCML_I64( "pfcmpgt mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA0 );

    FCML_A64( "pfcmpgt (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa0 );
    FCML_A64( "pfcmpgt %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa0 );
}

void fcml_tf_instruction_PFMAX(void) {

    FCML_I32( "pfmax mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA4 );
    FCML_I64( "pfmax mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA4 );

    FCML_A64( "pfmax (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa4 );
    FCML_A64( "pfmax %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa4 );
}

void fcml_tf_instruction_PFMIN(void) {

    FCML_I32( "pfmin mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x94 );
    FCML_I64( "pfmin mm0,mm1", 0x0F, 0x0F, 0xC1, 0x94 );

    FCML_A64( "pfmin (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x94 );
    FCML_A64( "pfmin %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x94 );
}

void fcml_tf_instruction_PFMUL(void) {

    FCML_I32( "pfmul mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB4 );
    FCML_I64( "pfmul mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB4 );

    FCML_A64( "pfmul (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb4 );
    FCML_A64( "pfmul %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb4 );
}

void fcml_tf_instruction_PFRCP(void) {

    FCML_I32( "pfrcp mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x96 );
    FCML_I64( "pfrcp mm0,mm1", 0x0F, 0x0F, 0xC1, 0x96 );

    FCML_A64( "pfrcp (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x96 );
    FCML_A64( "pfrcp %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x96 );
}

void fcml_tf_instruction_PFRCPIT1(void) {

    FCML_I32( "pfrcpit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA6 );
    FCML_I64( "pfrcpit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA6 );

    FCML_I32( "pfrcpit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA6 );
	FCML_I64( "pfrcpit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA6 );
}

void fcml_tf_instruction_PFRCPIT2(void) {

    FCML_I32( "pfrcpit2 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB6 );
    FCML_I64( "pfrcpit2 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB6 );

    FCML_A64( "pfrcpit2 (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb6 );
    FCML_A64( "pfrcpit2 %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb6 );
}

void fcml_tf_instruction_PFRSQIT1(void) {

    FCML_I32( "pfrsqit1 mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xA7 );
    FCML_I64( "pfrsqit1 mm0,mm1", 0x0F, 0x0F, 0xC1, 0xA7 );

    FCML_A64( "pfrsqit1 (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xa7 );
    FCML_A64( "pfrsqit1 %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xa7 );
}

void fcml_tf_instruction_PFRSQRT(void) {

    FCML_I32( "pfrsqrt mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x97 );
    FCML_I64( "pfrsqrt mm0,mm1", 0x0F, 0x0F, 0xC1, 0x97 );
}

void fcml_tf_instruction_PFSUB(void) {

    FCML_I32( "pfsub mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x9A );
    FCML_I64( "pfsub mm0,mm1", 0x0F, 0x0F, 0xC1, 0x9A );

    FCML_A64( "pfsub (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x9a );
    FCML_A64( "pfsub %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x9a );
}

void fcml_tf_instruction_PFSUBR(void) {

    FCML_I32( "pfsubr mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xAA );
    FCML_I64( "pfsubr mm0,mm1", 0x0F, 0x0F, 0xC1, 0xAA );

    FCML_A64( "pfsubr (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xaa );
    FCML_A64( "pfsubr %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xaa );
}

void fcml_tf_instruction_PI2FD(void) {

    FCML_I32( "pi2fd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x0D );
    FCML_I64( "pi2fd mm0,mm1", 0x0F, 0x0F, 0xC1, 0x0D );

    FCML_A64( "pi2fd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x0d );
    FCML_A64( "pi2fd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x0d );
}

void fcml_tf_instruction_PMULHRW(void) {

    FCML_I32( "pmulhrw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xB7 );
    FCML_I64( "pmulhrw mm0,mm1", 0x0F, 0x0F, 0xC1, 0xB7 );

    FCML_A64( "pmulhrw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xb7 );
    FCML_A64( "pmulhrw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xb7 );
}

void fcml_tf_instruction_PREFETCH(void) {

    FCML_I32( "prefetch byte ptr [eax]", 0x0F, 0x0D, 0x00 );
    FCML_I64( "prefetchw byte ptr [rax]", 0x0F, 0x0D, 0x08 );

    FCML_A64( "prefetch (%rax)", 0x0f, 0x0d, 0x00 );
    FCML_A64( "prefetchw (%rax)", 0x0f, 0x0d, 0x08 );
}

void fcml_tf_instruction_PF2IW(void) {

    FCML_I32( "pf2iw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x1C );
    FCML_I64( "pf2iw mm0,mm1", 0x0F, 0x0F, 0xC1, 0x1C );

    FCML_A64( "pf2iw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x1c );
    FCML_A64( "pf2iw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x1c );
}

void fcml_tf_instruction_PFNACC(void) {

    FCML_I32( "pfnacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x8A );
    FCML_I64( "pfnacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0x8A );

    FCML_A64( "pfnacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x8a );
    FCML_A64( "pfnacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x8a );
}

void fcml_tf_instruction_PFPNACC(void) {

    FCML_I32( "pfpnacc mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x8E );
    FCML_I64( "pfpnacc mm0,mm1", 0x0F, 0x0F, 0xC1, 0x8E );

    FCML_A64( "pfpnacc (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x8e );
    FCML_A64( "pfpnacc %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x8e );
}

void fcml_tf_instruction_PI2FW(void) {

    FCML_I32( "pi2fw mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0x0C );
    FCML_I64( "pi2fw mm0,mm1", 0x0F, 0x0F, 0xC1, 0x0C );

    FCML_A64( "pi2fw (%rax),%mm0", 0x0f, 0x0f, 0x00, 0x0c );
    FCML_A64( "pi2fw %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0x0c );
}

void fcml_tf_instruction_PSWAPD(void) {

    FCML_I32( "pswapd mm0,mmword ptr [eax]", 0x0F, 0x0F, 0x00, 0xBB );
    FCML_I64( "pswapd mm0,mm1", 0x0F, 0x0F, 0xC1, 0xBB );

    FCML_A64( "pswapd (%rax),%mm0", 0x0f, 0x0f, 0x00, 0xbb );
    FCML_A64( "pswapd %mm1,%mm0", 0x0f, 0x0f, 0xc1, 0xbb );
}

void fcml_tf_instruction_PDEP(void) {

    FCML_I32( "pdep eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x43, 0xF5, 0x00 );
    FCML_I32( "pdep eax,edi,eax", 0xC4, 0xE2, 0x43, 0xF5, 0xC0 );

    FCML_I64( "pdep rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC3, 0xF5, 0x00 );
    FCML_I64( "pdep rax,rdi,rax", 0xC4, 0xE2, 0xC3, 0xF5, 0xC0 );

    FCML_A64( "pdep (%rax),%edi,%eax", 0xc4, 0xe2, 0x43, 0xf5, 0x00 );
    FCML_A64( "pdep %eax,%edi,%eax", 0xc4, 0xe2, 0x43, 0xf5, 0xc0 );
    FCML_A64( "pdep (%rax),%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf5, 0x00 );
    FCML_A64( "pdep %rax,%rdi,%rax", 0xc4, 0xe2, 0xc3, 0xf5, 0xc0 );
}

void fcml_tf_instruction_PEXT(void) {

    FCML_I32( "pext eax,edi,dword ptr [eax]", 0xC4, 0xE2, 0x42, 0xF5, 0x00 );
    FCML_I32( "pext eax,edi,eax", 0xC4, 0xE2, 0x42, 0xF5, 0xC0 );

    FCML_I64( "pext rax,rdi,qword ptr [rax]", 0xC4, 0xE2, 0xC2, 0xF5, 0x00 );
    FCML_I64( "pext rax,rdi,rax", 0xC4, 0xE2, 0xC2, 0xF5, 0xC0 );

    FCML_A64( "pext (%rax),%edi,%eax", 0xc4, 0xe2, 0x42, 0xf5, 0x00 );
    FCML_A64( "pext %eax,%edi,%eax", 0xc4, 0xe2, 0x42, 0xf5, 0xc0 );
    FCML_A64( "pext (%rax),%rdi,%rax", 0xc4, 0xe2, 0xc2, 0xf5, 0x00 );
    FCML_A64( "pext %rax,%rdi,%rax", 0xc4, 0xe2, 0xc2, 0xf5, 0xc0 );
}

fcml_stf_test_case fctl_ti_instructions_p[] = {
	{ "fcml_tf_instruction_PABS", fcml_tf_instruction_PABS },
	{ "fcml_tf_instruction_PACKSS", fcml_tf_instruction_PACKSS },
	{ "fcml_tf_instruction_PACKUSD", fcml_tf_instruction_PACKUSD },
	{ "fcml_tf_instruction_PACKUSW", fcml_tf_instruction_PACKUSW },
	{ "fcml_tf_instruction_PADD", fcml_tf_instruction_PADD },
	{ "fcml_tf_instruction_PADDS", fcml_tf_instruction_PADDS },
	{ "fcml_tf_instruction_PADDUS", fcml_tf_instruction_PADDUS },
	{ "fcml_tf_instruction_PADDQ", fcml_tf_instruction_PADDQ },
	{ "fcml_tf_instruction_PALIGNR", fcml_tf_instruction_PALIGNR },
	{ "fcml_tf_instruction_PAND", fcml_tf_instruction_PAND },
	{ "fcml_tf_instruction_PANDN", fcml_tf_instruction_PANDN },
	{ "fcml_tf_instruction_PAUSE", fcml_tf_instruction_PAUSE },
	{ "fcml_tf_instruction_PAVGB", fcml_tf_instruction_PAVGB },
	{ "fcml_tf_instruction_PBLENDVB", fcml_tf_instruction_PBLENDVB },
	{ "fcml_tf_instruction_PBLENDW", fcml_tf_instruction_PBLENDW },
	{ "fcml_tf_instruction_PCLMULQDQ", fcml_tf_instruction_PCLMULQDQ },
	{ "fcml_tf_instruction_PCMPEQ", fcml_tf_instruction_PCMPEQ },
	{ "fcml_tf_instruction_PCMPEQQ", fcml_tf_instruction_PCMPEQQ },
	{ "fcml_tf_instruction_PCMPESTRI", fcml_tf_instruction_PCMPESTRI },
	{ "fcml_tf_instruction_PCMPESTRM", fcml_tf_instruction_PCMPESTRM },
	{ "fcml_tf_instruction_PCMPGT", fcml_tf_instruction_PCMPGT },
	{ "fcml_tf_instruction_PCMPGTQ", fcml_tf_instruction_PCMPGTQ },
	{ "fcml_tf_instruction_PCMPISTRI", fcml_tf_instruction_PCMPISTRI },
	{ "fcml_tf_instruction_PCMPISTRM", fcml_tf_instruction_PCMPISTRM },
	{ "fcml_tf_instruction_PEXTRB", fcml_tf_instruction_PEXTRB },
	{ "fcml_tf_instruction_PEXTRW", fcml_tf_instruction_PEXTRW },
	{ "fcml_tf_instruction_PHADDW", fcml_tf_instruction_PHADDW },
	{ "fcml_tf_instruction_PHADDSW", fcml_tf_instruction_PHADDSW },
	{ "fcml_tf_instruction_PHMINPOSUW", fcml_tf_instruction_PHMINPOSUW },
	{ "fcml_tf_instruction_PHSUBW", fcml_tf_instruction_PHSUBW },
	{ "fcml_tf_instruction_PHSUBSW", fcml_tf_instruction_PHSUBSW },
	{ "fcml_tf_instruction_PINSR", fcml_tf_instruction_PINSR },
	{ "fcml_tf_instruction_PINSRW", fcml_tf_instruction_PINSRW },
	{ "fcml_tf_instruction_PMADDUBSW", fcml_tf_instruction_PMADDUBSW },
	{ "fcml_tf_instruction_PMADDWD", fcml_tf_instruction_PMADDWD },
	{ "fcml_tf_instruction_PMAXSB", fcml_tf_instruction_PMAXSB },
	{ "fcml_tf_instruction_PMAXSW", fcml_tf_instruction_PMAXSW },
	{ "fcml_tf_instruction_PMAXSD", fcml_tf_instruction_PMAXSD },
	{ "fcml_tf_instruction_PMAXUB", fcml_tf_instruction_PMAXUB },
	{ "fcml_tf_instruction_PMAXUW", fcml_tf_instruction_PMAXUW },
	{ "fcml_tf_instruction_PMAXUD", fcml_tf_instruction_PMAXUD },
	{ "fcml_tf_instruction_PMINSB", fcml_tf_instruction_PMINSB },
	{ "fcml_tf_instruction_PMINSW", fcml_tf_instruction_PMINSW },
	{ "fcml_tf_instruction_PMINSD", fcml_tf_instruction_PMINSD },
	{ "fcml_tf_instruction_PMINUB", fcml_tf_instruction_PMINUB },
	{ "fcml_tf_instruction_PMINUW", fcml_tf_instruction_PMINUW },
	{ "fcml_tf_instruction_PMINUD", fcml_tf_instruction_PMINUD },
	{ "fcml_tf_instruction_PMOVMSKB", fcml_tf_instruction_PMOVMSKB },
	{ "fcml_tf_instruction_PMOVSX", fcml_tf_instruction_PMOVSX },
	{ "fcml_tf_instruction_PMOVZX", fcml_tf_instruction_PMOVZX },
	{ "fcml_tf_instruction_PMULDQ", fcml_tf_instruction_PMULDQ },
	{ "fcml_tf_instruction_PMULHRSW", fcml_tf_instruction_PMULHRSW },
	{ "fcml_tf_instruction_PMULHUW", fcml_tf_instruction_PMULHUW },
	{ "fcml_tf_instruction_PMULHW", fcml_tf_instruction_PMULHW },
	{ "fcml_tf_instruction_PMULUDQ", fcml_tf_instruction_PMULUDQ },
	{ "fcml_tf_instruction_PMULLW", fcml_tf_instruction_PMULLW },
	{ "fcml_tf_instruction_PMULLD", fcml_tf_instruction_PMULLD },
	{ "fcml_tf_instruction_POP", fcml_tf_instruction_POP },
	{ "fcml_tf_instruction_POPA", fcml_tf_instruction_POPA },
	{ "fcml_tf_instruction_POPCNT", fcml_tf_instruction_POPCNT },
	{ "fcml_tf_instruction_POPF", fcml_tf_instruction_POPF },
	{ "fcml_tf_instruction_POR", fcml_tf_instruction_POR },
	{ "fcml_tf_instruction_PREFETCHT", fcml_tf_instruction_PREFETCHT },
	{ "fcml_tf_instruction_PSADBW", fcml_tf_instruction_PSADBW },
	{ "fcml_tf_instruction_PSHUFB", fcml_tf_instruction_PSHUFB },
	{ "fcml_tf_instruction_PSHUFD", fcml_tf_instruction_PSHUFD },
	{ "fcml_tf_instruction_PSHUFHW", fcml_tf_instruction_PSHUFHW },
	{ "fcml_tf_instruction_PSHUFLW", fcml_tf_instruction_PSHUFLW },
	{ "fcml_tf_instruction_PSHUFW", fcml_tf_instruction_PSHUFW },
	{ "fcml_tf_instruction_PSIGN", fcml_tf_instruction_PSIGN },
	{ "fcml_tf_instruction_PSLLDQ", fcml_tf_instruction_PSLLDQ },
	{ "fcml_tf_instruction_PSLL", fcml_tf_instruction_PSLL },
	{ "fcml_tf_instruction_PSRA", fcml_tf_instruction_PSRA },
	{ "fcml_tf_instruction_PSRLDQ", fcml_tf_instruction_PSRLDQ },
	{ "fcml_tf_instruction_PSRL", fcml_tf_instruction_PSRL },
	{ "fcml_tf_instruction_PSUB", fcml_tf_instruction_PSUB },
	{ "fcml_tf_instruction_PSUBQ", fcml_tf_instruction_PSUBQ },
	{ "fcml_tf_instruction_PSUBS", fcml_tf_instruction_PSUBS },
	{ "fcml_tf_instruction_PSUBUS", fcml_tf_instruction_PSUBUS },
	{ "fcml_tf_instruction_PTEST", fcml_tf_instruction_PTEST },
	{ "fcml_tf_instruction_PUNPCKLB", fcml_tf_instruction_PUNPCKLB },
	{ "fcml_tf_instruction_PUNPCKHB", fcml_tf_instruction_PUNPCKHB },
	{ "fcml_tf_instruction_PUSH", fcml_tf_instruction_PUSH },
	{ "fcml_tf_instruction_PUSHA", fcml_tf_instruction_PUSHA },
	{ "fcml_tf_instruction_PUSHF", fcml_tf_instruction_PUSHF },
	{ "fcml_tf_instruction_PXOR", fcml_tf_instruction_PXOR },
	{ "fcml_tf_instruction_PAVGUSB", fcml_tf_instruction_PAVGUSB },
	{ "fcml_tf_instruction_PF2ID", fcml_tf_instruction_PF2ID },
	{ "fcml_tf_instruction_PFACC", fcml_tf_instruction_PFACC },
	{ "fcml_tf_instruction_PFADD", fcml_tf_instruction_PFADD },
	{ "fcml_tf_instruction_PFCMPEQ", fcml_tf_instruction_PFCMPEQ },
	{ "fcml_tf_instruction_PFCMPGE", fcml_tf_instruction_PFCMPGE },
	{ "fcml_tf_instruction_PFCMPGT", fcml_tf_instruction_PFCMPGT },
	{ "fcml_tf_instruction_PFMAX", fcml_tf_instruction_PFMAX },
	{ "fcml_tf_instruction_PFMIN", fcml_tf_instruction_PFMIN },
	{ "fcml_tf_instruction_PFMUL", fcml_tf_instruction_PFMUL },
	{ "fcml_tf_instruction_PFRCP", fcml_tf_instruction_PFRCP },
	{ "fcml_tf_instruction_PFRCPIT1", fcml_tf_instruction_PFRCPIT1 },
	{ "fcml_tf_instruction_PFRCPIT2", fcml_tf_instruction_PFRCPIT2 },
	{ "fcml_tf_instruction_PFRSQIT1", fcml_tf_instruction_PFRSQIT1 },
	{ "fcml_tf_instruction_PFRSQRT", fcml_tf_instruction_PFRSQRT },
	{ "fcml_tf_instruction_PFSUB", fcml_tf_instruction_PFSUB },
	{ "fcml_tf_instruction_PFSUBR", fcml_tf_instruction_PFSUBR },
	{ "fcml_tf_instruction_PI2FD", fcml_tf_instruction_PI2FD },
	{ "fcml_tf_instruction_PMULHRW", fcml_tf_instruction_PMULHRW },
	{ "fcml_tf_instruction_PREFETCH", fcml_tf_instruction_PREFETCH },
	{ "fcml_tf_instruction_PF2IW", fcml_tf_instruction_PF2IW },
	{ "fcml_tf_instruction_PFNACC", fcml_tf_instruction_PFNACC },
	{ "fcml_tf_instruction_PFPNACC", fcml_tf_instruction_PFPNACC },
	{ "fcml_tf_instruction_PI2FW", fcml_tf_instruction_PI2FW },
	{ "fcml_tf_instruction_PSWAPD", fcml_tf_instruction_PSWAPD },
	{ "fcml_tf_instruction_PDEP", fcml_tf_instruction_PDEP },
	{ "fcml_tf_instruction_PEXT", fcml_tf_instruction_PEXT },
	FCML_STF_NULL_TEST
};

fcml_stf_test_suite fctl_si_instructions_p = {
	"suite-fctl_ti_instructions_p", fcml_tf_instructions_p_suite_init, fcml_tf_instructions_p_suite_cleanup, fctl_ti_instructions_p
};




