/* $Id: segment.h,v 1.14 2009-01-28 16:47:15 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SEGMENT_H_INCLUDED
#define __SEGMENT_H_INCLUDED

#include "compiler.h"

static inline __attribute__((__always_inline__)) uint16_t
get_cs(void)
{
	uint16_t cs;

	__asm__(
		"movw %%cs,%0\n"
		: "=a" (cs)
	);

	return cs;
}

static inline __attribute__((__always_inline__)) void
__put_byte(uint16_t seg, uint16_t offset, uint8_t val)
{
	asm volatile (
		"movw %0, %%es\n"
		"movb %2, %%es:(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "a" (val)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
__put_word(uint16_t seg, uint16_t offset, uint16_t val)
{
	asm volatile (
		"movw %0, %%es\n"
		"movw %2, %%es:(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "a" (val)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) void
__put_long(uint16_t seg, uint16_t offset, uint32_t val)
{
	asm volatile (
		"movw %0, %%es\n"
		"movl %2, %%es:(%1)\n"
		: /* no output */
		: "r" (seg), "b" (offset), "r" (val)
		: "memory"
	);
}

static inline __attribute__((__always_inline__)) uint8_t
__get_byte(uint16_t seg, uint16_t offset)
{
	uint8_t val;

	asm volatile (
		"movw %1, %%es\n"
		"movb %%es:(%2), %0\n"
		: "=a" (val)
		: "r" (seg), "b" (offset)
	);

	return val;
}

static inline __attribute__((__always_inline__)) uint16_t
__get_word(uint16_t seg, uint16_t offset)
{
	uint16_t val;

	asm volatile (
		"movw %1, %%es\n"
		"movw %%es:(%2), %0\n"
		: "=a" (val)
		: "r" (seg), "b" (offset)
	);

	return val;
}

static inline __attribute__((__always_inline__)) uint32_t
__get_long(uint16_t seg, uint16_t offset)
{
	uint32_t val;

	asm volatile (
		"movw %1, %%es\n"
		"movl %%es:(%2), %0\n"
		: "=r" (val)
		: "r" (seg), "b" (offset)
	);

	return val;
}

#define put_byte(seg, off, val) \
	__put_byte((seg), (uint16_t) (unsigned long) (off), (val))
#define put_word(seg, off, val) \
	__put_word((seg), (uint16_t) (unsigned long) (off), (val))
#define put_long(seg, off, val) \
	__put_long((seg), (uint16_t) (unsigned long) (off), (val))

#define get_byte(seg, off) \
	__get_byte((seg), (uint16_t) (unsigned long) (off))
#define get_word(seg, off) \
	__get_word((seg), (uint16_t) (unsigned long) (off))
#define get_long(seg, off) \
	__get_long((seg), (uint16_t) (unsigned long) (off))

#endif /* __SEGMENT_H_INCLUDED */
