/* $Id: main.S,v 1.9 2009-06-18 16:24:57 potyra Exp $
 *
 * vim: filetype=ia64:
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

.text
.globl main
main:
	cli
	call libs_clrscr
	call setup_idt
	call setup_pic0_single_autoeoi
	call setup_controller
	call setup_pit
	call setup_dio48
	sti

main_loop_entry:
	movl $str_menu, %edx
	call libs_puts

main_loop:
	cli
	cmpb $1, kbd_key_recv
	je main_key_pressed
	sti
	call check_dio48_inputs

	jmp main_loop

main_key_pressed:
	movb kbd_key_read, %al
	movb $0, kbd_key_read
	movb $0, kbd_key_recv
	sti

	/* no byte read? */
	cmpb $0, %al
	je main_loop

	cmpb $'0', %al
	je press_0
	cmpb $'1', %al
	je press_1
	cmpb $'2', %al
	je press_2
	cmpb $'3', %al
	je press_3
	cmpb $'4', %al
	je press_4

	cmpb $'a', %al
	je press_a
	cmpb $'s', %al
	je press_s
	cmpb $'d', %al
	je press_d
	cmpb $'f', %al
	je press_f
	cmpb $'t', %al
	je press_t

	cmpb $'q', %al
	je press_q
	cmpb $'p', %al
	je press_p

	jmp main_loop

dump_state:
	cli
	pusha
	/* stack contains now:
	 * return eip	+32
	 * eax		+28
	 * ecx		+24
	 * edx		+20
	 * ebx		+16
	 * old esp	+12
	 * ebp		+8
	 * esi		+4
	 * edi <--- esp 
	 */
	movl $str_reg_eip, %edx
	call libs_puts
	movl 32(%esp), %eax /* return eip */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_eax, %edx
	call libs_puts
	movl 28(%esp), %eax /* eax */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_ecx, %edx
	call libs_puts
	movl 24(%esp), %eax /* ecx */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_edx, %edx
	call libs_puts
	movl 20(%esp), %eax /* edx */
	call libs_printl
	movl $str_nl, %edx
	call libs_puts


	movl $str_reg_ebx, %edx
	call libs_puts
	movl 16(%esp), %eax /* ebx */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_esp, %edx
	call libs_puts
	movl 12(%esp), %eax /* old esp */
	addl $8, %eax /* interrupt handler: esp is off by a far call */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_ebp, %edx
	call libs_puts
	movl 8(%esp), %eax /* ebp */
	call libs_printl
	movl $str_comma_spc, %edx
	call libs_puts

	movl $str_reg_esi, %edx
	call libs_puts
	movl 4(%esp), %eax /* esi */
	call libs_printl
	movl $str_nl, %edx
	call libs_puts

	movl $str_reg_edi, %edx
	call libs_puts
	movl (%esp), %eax /* edi */
	call libs_printl
	movl $str_nl, %edx
	call libs_puts

	popa
	iret

press_0:
	movl $0xc100, %edx
	xorb %al, %al
	outb %al, %dx
	incl %edx
	outb %al, %dx
	movb $0, reg_0C
	jmp dio48_update_0c

press_1:
	/* ground floor door */
	movb reg_0C, %al
	xorb $0b00000100, %al
	jmp dio48_update_0c

press_2:
	/* 1st floor door */
	movb reg_0C, %al
	xorb $0b00001000, %al
	jmp dio48_update_0c

press_3:
	/* 2nd floor door */
	movb reg_0C, %al
	xorb $0b00010000, %al
	jmp dio48_update_0c

press_4:
	/* direction */
	movb reg_0C, %al
	xorb $0b00000010, %al
	jmp dio48_update_0c

/* asdf: update floor variable */
press_a:
	movb $0, elevator_floor
	call elevator_update_floor_led
	jmp main_loop

press_s:
	movb $1, elevator_floor
	call elevator_update_floor_led
	jmp main_loop

press_d:
	movb $2, elevator_floor
	call elevator_update_floor_led
	jmp main_loop

press_f:
	movb $3, elevator_floor
	call elevator_update_floor_led
	jmp main_loop

press_t:
	/* motor on/off */
	movb reg_0C, %al
	xorb $0b00000001, %al
	jmp dio48_update_0c

press_q:
	/* show destination bitmask */
	xorb %al, %al
	call elevator_destination_bitmask
	call libs_printb_hex
	movl $str_nl, %edx
	call libs_puts
	jmp main_loop

press_p:
	pusha
	movl $0xc100, %edx
	inb %dx, %al
	movl %eax, %edi
	movl $5, %ecx
_L100:
	movl $1, %eax
	movl $6, %ebp
_L101:
	outb %al, %dx
	movb %al, %bl
	movl $10, %eax
	call delay
	movb %bl, %al
	shlb $1, %al
	decl %ebp
	jnz _L101
	decl %ecx
	jnz _L100

	movl %edx, %eax
	outb %al, %dx
	call rand6
	cmpb $1, %al
	jne _L102
	movb $0x6, %al
	jmp _L120
_L102:
	cmpb $2, %al
	jne _L103
	movb $0x5b, %al
	jmp _L120
_L103:
	cmpb $3, %al
	jne _L104
	movb $0x4f, %al
	jmp _L120
_L104:
	cmpb $4, %al
	jne _L105
	movb $0x66, %al
	jmp _L120
_L105:
	cmpb $5, %al
	jne _L106
	movb $0x6d, %al
	jmp _L120
_L106:	
	movb $0x7d, %al
	outb %al, %dx
	movl $0xc102, %edx
	inb %dx, %al
	movl %eax, %esi
	orb $4, %al
	outb %al, %dx
	movl $30, %eax
	call delay
	movl %esi, %eax
	orb $12, %al
	outb %al, %dx
	movl $30, %eax
	call delay
	movl %esi, %eax
	orb $28, %al
	outb %al, %dx
	movl $80, %eax
	call delay
	movl %esi, %eax
	andb $0xe3, %al
	orb $0x18, %al
	outb %al, %dx
	movl $30, %eax
	call delay
	movl %esi, %eax
	andb $0xe3, %al
	orb $0x10, %al
	outb %al, %dx
	movl $30, %eax
	call delay
	andb $0xe3, %al
	outb %al, %dx
	movl $100, %eax
	call delay
	movl %esi, %eax
	outb %al, %dx
	movl $0xc100, %edx
	jmp _L121

_L120:
	outb %al, %dx
	movl $150, %eax
	call delay
_L121:
	movl %edi, %eax
	outb %al, %dx
	popa
	jmp main_loop
	

/* update port 0C of dio48 with value in %al, also updating the
 * variable.
 */
dio48_update_0c:
	movb %al, reg_0C
	movl $0xc102, %edx
	outb %al, %dx
	jmp main_loop


setup_dio48:
	/* control word #0, mode 0, all outputs */
	/* base addr2 set by bios: 0xc100 */
	/* 1st dio24: 0xc100-0xc103,
	 * 2nd dio24: 0xc104-0xc107 */
	movb $0b10000000, %al
	/* base 1 + 3 */
	movl $0xc103, %edx
	outb %al, %dx

	/* control word #1, mode 0, all inputs */
	movb $0b10011011, %al
	movl $0xc107, %edx
	outb %al, %dx

	/* initialize status */
	movl $0xc104, %edx
	inb %dx, %al
	movb %al, reg_1A
	movl $0xc105, %edx
	inb %dx, %al
	movb %al, reg_1B

	ret
check_dio48_inputs:
	/* cl: 0 -> no changes */
	xorb %cl, %cl

	/* check port 1A */
	movl $0xc104, %edx
	inb %dx, %al
	cmpb reg_1A, %al
	je check_dio48_b

	/* 1A unequal */
	movb %al, reg_1A
	incb %cl
check_dio48_b:
	/* check port 1B */
	movl $0xc105, %edx
	inb %dx, %al
	cmpb reg_1B, %al
	je check_dio48_done

	/* 1B unequal */
	movb %al, reg_1B
	incb %cl
check_dio48_done:
	cmpb $0, %cl
	je check_dio48_out

	/* ports changed */
	call elevator_control_main
	call dio48_print_ports
check_dio48_out:
	ret


dio48_print_ports:
	movl $str_port1a, %edx
	call libs_puts
	movb reg_1A, %al
	call libs_printb_hex

	movl $str_port1b, %edx
	call libs_puts
	movb reg_1B, %al
	call libs_printb_hex

	movl $str_nl, %edx
	call libs_puts
	ret
	

/* program pic0 to 8086 mode, autoeoi, single */
setup_pic0_single_autoeoi:
	/* icw1: level triggered, single, ic4 present */
	movb $0x1b, %al
	outb %al, $0x0020

	/* icw2: base address 32 */
	movb $0x20, %al
	outb %al, $0x0021

	/* no icw3 (single) (FIXME) */
	xorb %al, %al
	outb %al, $0x0021

	/* icw4: autoeoi, 8086 mode */
	movb $0x03, %al
	outb %al, $0x0021

	/* program interrupt mask, disable all ints apart from 1,0 */
	movb $0b11111100, %al
	outb %al, $0x0021
	ret

setup_idt:
	lidt idt_descr
	movl $str_idt_setup, %edx
	call libs_puts
	ret

/* ******************* interrupt/exception handlers  ******************
 * Attention: due to offsets begin split in IDT, the IDT (in the .data
 * section) must be close enough to the exception handlers in the .text
 * segment, since these are only using offset 15..0 for relocation.
 * However the linker seems to do the right thing generating
 * R_386_16 relocation entries, so it might not link if the sections
 * would be too far away from each other.
 * ******************************************************************** */

/** return to the main loop. Stack must contain plain interrupt
 *  data and no additional entries. Data segments should have been 
 *  restored already.
 *
 *  This should get jumped to from interrupt handlers.
 */
iret_to_main_loop_entry:
	/* exit task by mangling stack */
	movl $main_loop_entry, (%esp)
	movl $0x08, 4(%esp)
	iret

/* exception handler for all unhandled exceptions */
unhandled_exception:
	movl $str_unhandled, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

double_fault:
	movl $str_double_fault, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

segment_not_present_fault:
	movl $str_seg_not_present, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

stack_segment_fault:
	/* this won't get reached (double fault!) */
	movl $str_stack_segment_fault, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

general_protection_fault:
	/* restore data segment */
	movl $0x10, %eax
	mov %ax, %ds
	mov %ax, %es
	mov %ax, %fs
	mov %ax, %gs

	movl $str_gp, %edx
	call libs_puts
	movl $str_task_abort, %edx
	call libs_puts

	/* error code */
	/* FIXME display error code, needs "and, shrb" hence disabled 
	 *       for now. 
	popl %eax
	pushl %eax
	shrb $4, %al
	call libs_printb
	popl %eax
	andb $0xf, %al
	call libs_printb
	*/

	/* terminate process */
	jmp iret_to_main_loop_entry

page_fault:
	movl $str_page_fault, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit

	iret

	
/* exception handler for division by 0 */
handle_div0:
	movl $str_div0, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq0_handler:
	call handle_pit_irq
	iret

irq1_handler:
	/* restore os data segments */
	pushl %ds
	pushl %es
	pushl %fs
	pushl %gs

	pushl %eax
	movl $0x10, %eax
	mov %ax, %ds
	mov %ax, %es
	mov %ax, %fs
	mov %ax, %gs

	call release_comp_irq

	popl %eax
	pop %gs
	pop %fs
	pop %es
	pop %ds

	cmpb $10, kbd_key_read /* enter */
	je dump_state /* alternate exit point */

	iret

irq2_handler:
	movl $str_irq2, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq3_handler:
	movl $str_irq3, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq4_handler:
	movl $str_irq4, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq5_handler:
	movl $str_irq5, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq6_handler:
	movl $str_irq6, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret

irq7_handler:
	movl $str_irq7, %edx
	call libs_puts

	/* "abort" task (just stall the machine) */
	jmp libs_exit
	iret


.section .rodata
idt:
	/* 0: divide error (Fault) */
	.word handle_div0
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 1: Debug (Fault/Trap) */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 2: NMI (Interrupt) */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 3: Breakpoint (Trap) */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 4: Overflow (Trap) */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 5 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 6 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 7 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 8 double fault */
	.word double_fault
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 9 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 10 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 11 */
	.word segment_not_present_fault
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 12 */
	.word stack_segment_fault
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 13 */
	.word general_protection_fault
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 14 */
	.word page_fault
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 15 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 16 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 17 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 18 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 19 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 20 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 21 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 22 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 23 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 24 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 25 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 26 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 27 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 28 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 29 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 30 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* 31 */
	.word unhandled_exception
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xef /* 1110 1111 */
	.word 0

	/* ********** user defined ********* */

	/* 32: pic0, irq 0 */
	.word irq0_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 33: pic0, irq 1 */
	.word irq1_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 34: pic0, irq 2 */
	.word irq2_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 35: pic0, irq 3 */
	.word irq3_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 36: pic0, irq 4 */
	.word irq4_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 37: pic0, irq 5 */
	.word irq5_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 38: pic0, irq 6 */
	.word irq6_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* 39: pic0, irq 7 */
	.word irq7_handler
	.word 0x0008 /* segment 8 */
	.byte 0 /* constant 0/reserved */
	.byte 0xee /* 1110 1110 */
	.word 0

	/* sentinel */
	.long 0, 0
idt_end:

idt_descr:
	.word (idt_end - idt) - 1
	.long idt
	.word 0x0000

str_div0:
	.asciz "Division by Zero\n"

str_idt_setup:
	.asciz "IDT setup.\n"

str_unhandled:
	.asciz "Unhandled Exception/Interrupt\n"

str_double_fault:
	.asciz "Double Fault\n"

str_seg_not_present:
	.asciz "Segment not Present\n"

str_page_fault:
	.asciz "Page Fault\n"

str_stack_segment_fault:
	.asciz "Stack Segment Fault\n"

str_gp:
	.asciz "General Protection Fault\n"

str_irq0:
	.asciz "Interrupt 0\n"

str_irq1:
	.asciz "Interrupt 1\n"

str_irq2:
	.asciz "Interrupt 2\n"

str_irq3:
	.asciz "Interrupt 3\n"

str_irq4:
	.asciz "Interrupt 4\n"

str_irq5:
	.asciz "Interrupt 5\n"

str_irq6:
	.asciz "Interrupt 6\n"

str_irq7:
	.asciz "Interrupt 7\n"

str_task_abort:
	.asciz "Aborting current task\n"

str_menu:
	.ascii "Main Menu - Toggle bits in output ports\n"
	.ascii "Enter: Dump cpu state.\n"
	.ascii "0: reset all outputs to 0\n"
	.ascii "1: Open/close ground floor door\n"
	.ascii "2: Open/close 1st floor door\n"
	.ascii "3: Open/close 2nd floor door\n"
	.ascii "4: Invert elevator direction\n"
	.ascii "t: Turn on/off motor\n"
	.ascii "a: set floor variable to 0\n"
	.ascii "s: set floor variable to 1\n"
	.ascii "d: set floor variable to 2\n"
	.ascii "f: set floor variable to 3 (invalid)\n"
	.ascii "q: call elevator_destination_bitmask and show %al\n"
	.asciz "t: Turn on/off motor\n"

str_port1a:
	.asciz "Input ports changed: Port 1A: 0x"
str_port1b:
	.asciz ", Port 1B: 0x"
str_nl:
	.asciz "\n"

str_comma_spc:
	.asciz ", "

str_reg_eip:
	.asciz "EIP=0x"

str_reg_eax:
	.asciz "EAX=0x"

str_reg_ebx:
	.asciz "EBX=0x"

str_reg_ecx:
	.asciz "ECX=0x"

str_reg_edx:
	.asciz "EDX=0x"

str_reg_edi:
	.asciz "EDI=0x"

str_reg_ebp:
	.asciz "EBP=0x"

str_reg_esp:
	.asciz "ESP=0x"

str_reg_esi:
	.asciz "ESI=0x"


.data
reg_0C:
	.byte 0
reg_1A:
	.byte 0
reg_1B:
	.byte 0
