/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.BinarySequence;
import jalview.math.Matrix;
import java.io.PrintStream;

public class PCA
implements Runnable {
    Matrix m;
    Matrix symm;
    Matrix m2;
    double[] eigenvalue;
    Matrix eigenvector;
    StringBuffer details = new StringBuffer();

    public PCA(String[] s) {
        int count;
        int ii;
        BinarySequence[] bs = new BinarySequence[s.length];
        for (ii = 0; ii < s.length && s[ii] != null; ++ii) {
            bs[ii] = new BinarySequence(s[ii]);
            bs[ii].encode();
        }
        BinarySequence[] bs2 = new BinarySequence[s.length];
        for (ii = 0; ii < s.length && s[ii] != null; ++ii) {
            bs2[ii] = new BinarySequence(s[ii]);
            bs2[ii].blosumEncode();
        }
        for (count = 0; count < bs.length && bs[count] != null; ++count) {
        }
        double[][] seqmat = new double[count][bs[0].getDBinary().length];
        double[][] seqmat2 = new double[count][bs2[0].getDBinary().length];
        for (int i = 0; i < count; ++i) {
            seqmat[i] = bs[i].getDBinary();
            seqmat2[i] = bs2[i].getDBinary();
        }
        this.m = new Matrix(seqmat, count, bs[0].getDBinary().length);
        this.m2 = new Matrix(seqmat2, count, bs2[0].getDBinary().length);
    }

    public Matrix getM() {
        return this.m;
    }

    public double getEigenvalue(int i) {
        return this.eigenvector.d[i];
    }

    public float[][] getComponents(int l, int n, int mm, float factor) {
        float[][] out = new float[this.m.rows][3];
        for (int i = 0; i < this.m.rows; ++i) {
            out[i][0] = (float)this.component(i, l) * factor;
            out[i][1] = (float)this.component(i, n) * factor;
            out[i][2] = (float)this.component(i, mm) * factor;
        }
        return out;
    }

    public double[] component(int n) {
        double[] out = new double[this.m.rows];
        for (int i = 0; i < this.m.rows; ++i) {
            out[i] = this.component(i, n);
        }
        return out;
    }

    double component(int row, int n) {
        double out = 0.0;
        for (int i = 0; i < this.symm.cols; ++i) {
            out += this.symm.value[row][i] * this.eigenvector.value[i][n];
        }
        return out / this.eigenvector.d[n];
    }

    public String getDetails() {
        return this.details.toString();
    }

    public void run() {
        Matrix mt = this.m.transpose();
        this.details.append(" --- OrigT * Orig ---- \n");
        this.eigenvector = mt.preMultiply(this.m2);
        PrintStream ps = new PrintStream(System.out){

            public void print(String x) {
                PCA.this.details.append(x);
            }

            public void println() {
                PCA.this.details.append("\n");
            }
        };
        this.eigenvector.print(ps);
        this.symm = this.eigenvector.copy();
        this.eigenvector.tred();
        this.details.append(" ---Tridiag transform matrix ---\n");
        this.details.append(" --- D vector ---\n");
        this.eigenvector.printD(ps);
        ps.println();
        this.details.append("--- E vector ---\n");
        this.eigenvector.printE(ps);
        ps.println();
        this.eigenvector.tqli();
        this.details.append(" --- New diagonalization matrix ---\n");
        this.details.append(" --- Eigenvalues ---\n");
        this.eigenvector.printD(ps);
        ps.println();
    }
}

