/*
Copyright (C) 2006 - 2015 Evan Teran
                          evan.teran@gmail.com

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DIALOGSTRINGS_20061101_H_
#define DIALOGSTRINGS_20061101_H_

#include <QDialog>
#include "Types.h"

class QSortFilterProxyModel;
class QListWidgetItem;

namespace ProcessProperties {

namespace Ui { class DialogStrings; }

class DialogStrings : public QDialog {
	Q_OBJECT

public:
	DialogStrings(QWidget *parent = 0);
	virtual ~DialogStrings();

public Q_SLOTS:
	void on_btnFind_clicked();
	void on_listWidget_itemDoubleClicked(QListWidgetItem *);

private:
	virtual void showEvent(QShowEvent *event);

private:
	void do_find();

private:
	 Ui::DialogStrings *const ui;
	 QSortFilterProxyModel *  filter_model_;
};

}

#endif
