// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Runtime.CompilerServices;
using System.Runtime.InteropServices;
using System.Threading;
using Xunit;

public unsafe class Program
{
    // We test for mismatched callling convention by checking for a failure to
    // find the native entry point when the exported function is stdcall, but
    // the defined p/invoke is cdecl. This is only relevant on Windows x86.
    private static bool ValidateMismatch = OperatingSystem.IsWindows() && TestLibrary.Utilities.IsX86;

    private static void DefaultDllImport_Blittable()
    {
        Console.WriteLine($"Running {nameof(DefaultDllImport_Blittable)}...");

        const int a = 11;
        const int expected = a * 2;
        {
            Console.WriteLine($" -- default: UnmanagedCallConv()");
            int b;
            PInvokesCS.DefaultDllImport.Default.Blittable_Double_DefaultUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- cdecl: UnmanagedCallConv(cdecl)");
            int b;
            PInvokesCS.DefaultDllImport.Cdecl.Blittable_Double_CdeclUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- stdcall: UnmanagedCallConv(stdcall)");
            int b;
            PInvokesCS.DefaultDllImport.Stdcall.Blittable_Double_StdcallUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }

        if (ValidateMismatch)
        {
            Console.WriteLine($" -- stdcall: UnmanagedCallConv(cdecl)");
            Assert.Throws<EntryPointNotFoundException>(() => PInvokesCS.DefaultDllImport.Stdcall.Blittable_Double_CdeclUnmanagedCallConv(a, null));
        }
    }

    private static void DefaultDllImport_NotBlittable()
    {
        Console.WriteLine($"Running {nameof(DefaultDllImport_NotBlittable)}...");

        const int a = 11;
        const int expected = a * 2;
        {
            Console.WriteLine($" -- default: UnmanagedCallConv()");
            int b;
            PInvokesCS.DefaultDllImport.Default.NotBlittable_Double_DefaultUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- cdecl: UnmanagedCallConv(cdecl)");
            int b;
            PInvokesCS.DefaultDllImport.Cdecl.NotBlittable_Double_CdeclUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- stdcall: UnmanagedCallConv(stdcall)");
            int b;
            PInvokesCS.DefaultDllImport.Stdcall.NotBlittable_Double_StdcallUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }

        if (ValidateMismatch)
        {
            Console.WriteLine($" -- stdcall: UnmanagedCallConv(cdecl)");
            Assert.Throws<EntryPointNotFoundException>(() => PInvokesCS.DefaultDllImport.Stdcall.NotBlittable_Double_CdeclUnmanagedCallConv(a, null));
        }
    }

    private static void WinapiDllImport_Blittable()
    {
        Console.WriteLine($"Running {nameof(WinapiDllImport_Blittable)}...");

        const int a = 11;
        const int expected = a * 2;
        {
            Console.WriteLine($" -- default: UnmanagedCallConv()");
            int b;
            PInvokesCS.WinapiDllImport.Default.Blittable_Double_DefaultUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- cdecl: UnmanagedCallConv(cdecl)");
            int b;
            PInvokesCS.WinapiDllImport.Cdecl.Blittable_Double_CdeclUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }
        {
            Console.WriteLine($" -- stdcall: UnmanagedCallConv(stdcall)");
            int b;
            PInvokesCS.WinapiDllImport.Stdcall.Blittable_Double_StdcallUnmanagedCallConv(a, &b);
            Assert.Equal(expected, b);
        }

        if (ValidateMismatch)
        {
            Console.WriteLine($" 