# -*- encoding: utf-8 -*-
from django.utils.translation import ugettext_lazy as _

#: http://ru.wikipedia.org/wiki/Коды_субъектов_Российской_Федерации
RU_COUNTY_CHOICES = (
    ("Central Federal County", _("Central Federal County")),
    ("South Federal County", _("South Federal County")),
    ("North-West Federal County", _("North-West Federal County")),
    ("Far-East Federal County", _("Far-East Federal County")),
    ("Siberian Federal County", _("Siberian Federal County")),
    ("Ural Federal County", _("Ural Federal County")),
    ("Privolzhsky Federal County", _("Privolzhsky Federal County")),
    ("North-Caucasian Federal County", _("North-Caucasian Federal County"))
)

#: http://ru.wikipedia.org/wiki/Федеральные_округа_Российской_Федерации
RU_REGIONS_CHOICES = (
    ("77", _("Moskva")),
    ("78", _("Saint-Peterburg")),
    ("50", _("Moskovskaya oblast'")),
    ("01", _("Adygeya, Respublika")),
    ("02", _("Bashkortostan, Respublika")),
    ("03", _("Buryatia, Respublika")),
    ("04", _("Altay, Respublika")),
    ("05", _("Dagestan, Respublika")),
    ("06", _("Ingushskaya Respublika")),
    ("07", _("Kabardino-Balkarskaya Respublika")),
    ("08", _("Kalmykia, Respublika")),
    ("09", _("Karachaevo-Cherkesskaya Respublika")),
    ("10", _("Karelia, Respublika")),
    ("11", _("Komi, Respublika")),
    ("12", _("Mariy Ehl, Respublika")),
    ("13", _("Mordovia, Respublika")),
    ("14", _("Sakha, Respublika (Yakutiya)")),
    ("15", _("Severnaya Osetia, Respublika (Alania)")),
    ("16", _("Tatarstan, Respublika")),
    ("17", _("Tyva, Respublika (Tuva)")),
    ("18", _("Udmurtskaya Respublika")),
    ("19", _("Khakassiya, Respublika")),
    ("95", _("Chechenskaya Respublika")),
    ("21", _("Chuvashskaya Respublika")),
    ("22", _("Altayskiy Kray")),
    ("80", _("Zabaykalskiy Kray")),
    ("82", _("Kamchatskiy Kray")),
    ("23", _("Krasnodarskiy Kray")),
    ("24", _("Krasnoyarskiy Kray")),
    ("81", _("Permskiy Kray")),
    ("25", _("Primorskiy Kray")),
    ("26", _("Stavropol'siyy Kray")),
    ("27", _("Khabarovskiy Kray")),
    ("28", _("Amurskaya oblast'")),
    ("29", _("Arkhangel'skaya oblast'")),
    ("30", _("Astrakhanskaya oblast'")),
    ("31", _("Belgorodskaya oblast'")),
    ("32", _("Bryanskaya oblast'")),
    ("33", _("Vladimirskaya oblast'")),
    ("34", _("Volgogradskaya oblast'")),
    ("35", _("Vologodskaya oblast'")),
    ("36", _("Voronezhskaya oblast'")),
    ("37", _("Ivanovskaya oblast'")),
    ("38", _("Irkutskaya oblast'")),
    ("39", _("Kaliningradskaya oblast'")),
    ("40", _("Kaluzhskaya oblast'")),
    ("42", _("Kemerovskaya oblast'")),
    ("43", _("Kirovskaya oblast'")),
    ("44", _("Kostromskaya oblast'")),
    ("45", _("Kurganskaya oblast'")),
    ("46", _("Kurskaya oblast'")),
    ("47", _("Leningradskaya oblast'")),
    ("48", _("Lipeckaya oblast'")),
    ("49", _("Magadanskaya oblast'")),
    ("51", _("Murmanskaya oblast'")),
    ("52", _("Nizhegorodskaja oblast'")),
    ("53", _("Novgorodskaya oblast'")),
    ("54", _("Novosibirskaya oblast'")),
    ("55", _("Omskaya oblast'")),
    ("56", _("Orenburgskaya oblast'")),
    ("57", _("Orlovskaya oblast'")),
    ("58", _("Penzenskaya oblast'")),
    ("60", _("Pskovskaya oblast'")),
    ("61", _("Rostovskaya oblast'")),
    ("62", _("Rjazanskaya oblast'")),
    ("63", _("Samarskaya oblast'")),
    ("64", _("Saratovskaya oblast'")),
    ("65", _("Sakhalinskaya oblast'")),
    ("66", _("Sverdlovskaya oblast'")),
    ("67", _("Smolenskaya oblast'")),
    ("68", _("Tambovskaya oblast'")),
    ("69", _("Tverskaya oblast'")),
    ("70", _("Tomskaya oblast'")),
    ("71", _("Tul'skaya oblast'")),
    ("72", _("Tyumenskaya oblast'")),
    ("73", _("Ul'ianovskaya oblast'")),
    ("74", _("Chelyabinskaya oblast'")),
    ("76", _("Yaroslavskaya oblast'")),
    ("79", _("Evreyskaya avtonomnaja oblast'")),
    ("83", _("Neneckiy autonomnyy okrug")),
    ("86", _("Khanty-Mansiyskiy avtonomnyy okrug - Yugra")),
    ("87", _("Chukotskiy avtonomnyy okrug")),
    ("89", _("Yamalo-Neneckiy avtonomnyy okrug"))
)
