/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __field
#define __field

#include "widget.h"
#include <string>
#include <list>
#include <sstream>

class field : public widget { // a text field

  int width; // in chars

  enum {pushback = 1, insert = 2};
  int mode; // push back or insert

  std::string text; // text of the field
  int len; // length of text
  int last; // last char

  // the view
  int left, right; // left & right chars
  std::string view_text;
  void calc_view_text ();

  int cursor; // cursor pos ie char position
  int offset; // offset from left

  // focus
  //
  int focus; // 1 - field has focus, 0 - lost focus
  int clicked_lmb;

  // listener
  change_listener<field>* lsnr;

  char sbuf [1024]; // buffer for writing ints and floats

  public:

    field (int w);
    field (int x, int y, const std::string& str = "", int w = 0);

    void set_text (const std::string& txt);
    void set_text (int i);
    void set_text (float f);

    const std::string& get_text () {return text;}

    int handle_input ();

    void calc_view ();
    void calc_cursor ();

    void update ();

    void draw ();
    void draw_cursor (int x, int y);

    int hittest (int x, int y);

    int has_focus () {return focus;}

    operator int() const;
    operator float() const;

    void set_listener (change_listener<field>* fl);
};

#endif
