/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.digikam.org
 *
 * Date        : 2004-01-01
 * Description : Wall Paper kipi-plugin
 *
 * Copyright (C) 2004      by Gregory Kokanosky <gregory dot kokanosky at free.fr>
 * Copyright (C) 2004-2015 by Gilles Caulier <caulier dot gilles at gmail dot com>
 * Copyright (C) 2012      by Varun Herale <varun dot herale at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef PLUGIN_WALLPAPER_H
#define PLUGIN_WALLPAPER_H

// Qt includes

#include <QVariant>

// Libkipi includes

#include <KIPI/Plugin>

class QAction;

using namespace KIPI;

namespace KIPIWallPaperPlugin
{

class Plugin_WallPaper : public Plugin
{
    Q_OBJECT

public:

    Plugin_WallPaper(QObject* const parent, const QVariantList& args);
    ~Plugin_WallPaper();

    void setup(QWidget* const);

protected Q_SLOTS:

    void slotSetWallpaper();

private:

    void setupActions();

private:

    class Private;
    Private* const d;
};

} // namespace KIPIWallPaperPlugin

#endif // PLUGIN_WALLPAPER_H
