//
// C++ Interface: Exceptions
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef EXCEPTIONS_H__
#define EXCEPTIONS_H__

class Exception
{
public:
	Exception() : message("") {}
	Exception(const char* msg) : message(msg) {}
	const char* getMessage() const {return message;}
protected:
	const char* message;
};

class IndexOutOfBoundsException : public Exception
{
	public:
		IndexOutOfBoundsException() : Exception() {}
};

class RpcHandlerException : public Exception
{
	public:
		RpcHandlerException(const char* aMethodName,const char* aMessage) : Exception(aMessage),methodName(aMethodName) {}
		const char* getMethodName() const {return methodName;}
	private:
		const char* methodName;
	
};

#endif

