#include "query.h"
#include "var.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace core {

void Query::setf(const char* key, unsigned len, const char* val)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            level.l1 = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            level.l2 = strtol(val, nullptr, 10);
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            trange.p1 = strtol(val, nullptr, 10);
                            break;
                        case '2':
                            trange.p2 = strtol(val, nullptr, 10);
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                { double dval = strtod(val, nullptr); latrange.set(dval, dval); }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                { double dval = strtod(val, nullptr); lonrange.set(dval, dval); }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        dtrange.min.day    = dtrange.max.day = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        dtrange.min.minute = dtrange.max.minute = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        dtrange.min.second = dtrange.max.second = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        varcodes.clear(); varcodes.insert(resolve_varcode(val));
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        dtrange.min.year   = dtrange.max.year = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        dtrange.min.hour   = dtrange.max.hour = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        ident = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        dtrange.min.month  = dtrange.max.month = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        query = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        limit = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        block = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        report = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        ana_id = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        mobile = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            latrange.imax = Coords::lat_to_int(strtod(val, nullptr));
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            latrange.imin = Coords::lat_to_int(strtod(val, nullptr));
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            lonrange.imax = Coords::lon_to_int(strtod(val, nullptr));
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            lonrange.imin = Coords::lon_to_int(strtod(val, nullptr));
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    dtrange.max.day = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    dtrange.min.day = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    dtrange.max.second = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    dtrange.min.second = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    priomax = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    priomin = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.year = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.year = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.hour = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.hour = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.minute = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.minute = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        varcodes.clear(); resolve_varlist(val, varcodes);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        station = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        priomin = priomax = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        report = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    dtrange.max.month = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    dtrange.min.month = strtol(val, nullptr, 10);
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                level.ltype1 = strtol(val, nullptr, 10);
                                break;
                            case '2':
                                level.ltype2 = strtol(val, nullptr, 10);
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        trange.pind = strtol(val, nullptr, 10);
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        ana_filter = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        data_filter = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        attr_filter = val;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
    }
}

void Query::unset(const char* key, unsigned len)
{
    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            level.l1 = MISSING_INT;
                            break;
                        case '2':
                            level.l2 = MISSING_INT;
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            trange.p1 = MISSING_INT;
                            break;
                        case '2':
                            trange.p2 = MISSING_INT;
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                latrange = LatRange();
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                lonrange = LonRange();
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        dtrange.min.day    = dtrange.max.day = 0xff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        dtrange.min.minute = dtrange.max.minute = 0xff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        dtrange.min.second = dtrange.max.second = 0xff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "ar", 2) == 0) {
                        varcodes.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        dtrange.min.year   = dtrange.max.year = 0xffff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        dtrange.min.hour   = dtrange.max.hour = 0xff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        ident.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        dtrange.min.month  = dtrange.max.month = 0xff;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "uery", 4) == 0) {
                        query.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "imit", 4) == 0) {
                        limit = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        block = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        report.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        ana_id = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        mobile = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "tm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            latrange.imax = LatRange::IMAX;
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            latrange.imin = LatRange::IMIN;
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nm", 2) == 0) {
                                switch (key[4]) {
                                    case 'a':
                                        if (key[5] == 'x') {
                                            lonrange.imax = MISSING_INT;
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    case 'i':
                                        if (key[5] == 'n') {
                                            lonrange.imin = MISSING_INT;
                                        } else {
                                            wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                            } else {
                                wreport::error_notfound::throwf("key %s is not valid for a query", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "aym", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    dtrange.max.day = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    dtrange.min.day = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ecm", 3) == 0) {
                        switch (key[4]) {
                            case 'a':
                                if (key[5] == 'x') {
                                    dtrange.max.second = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[5] == 'n') {
                                    dtrange.min.second = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 7:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riom", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    priomax = MISSING_INT;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    priomin = MISSING_INT;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'y':
                    if (memcmp(key + 1, "earm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.year = 0xffff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.year = 0xffff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "ourm", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.hour = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.hour = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inum", 4) == 0) {
                        switch (key[5]) {
                            case 'a':
                                if (key[6] == 'x') {
                                    dtrange.max.minute = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[6] == 'n') {
                                    dtrange.min.minute = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "arlist", 6) == 0) {
                        varcodes.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "tation", 6) == 0) {
                        station = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "riority", 7) == 0) {
                        priomin = priomax = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        report.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onthm", 5) == 0) {
                        switch (key[6]) {
                            case 'a':
                                if (key[7] == 'x') {
                                    dtrange.max.month = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            case 'i':
                                if (key[7] == 'n') {
                                    dtrange.min.month = 0xff;
                                } else {
                                    wreport::error_notfound::throwf("key %s is not valid for a query", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                level.ltype1 = MISSING_INT;
                                break;
                            case '2':
                                level.ltype2 = MISSING_INT;
                                break;
                            default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        trange.pind = MISSING_INT;
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_filter", 9) == 0) {
                        ana_filter.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        case 11:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ata_filter", 10) == 0) {
                        data_filter.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "ttr_filter", 10) == 0) {
                        attr_filter.clear();
                    } else {
                        wreport::error_notfound::throwf("key %s is not valid for a query", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
            }
            break;
        default: wreport::error_notfound::throwf("key %s is not valid for a query", key);
    }
}

}
}
