/*
 * crc32c.c - compute CRC32 using the Castagnoli polymonial
 *
 * Hardware version using Intel CRC32 instruction
 * Copyright (C) 2013 Mark Adler
 * Version 1.1  1 Aug 2013  Mark Adler
 * http://stackoverflow.com/a/17646775/12421
 *
 * Software version based on Stephan Brumme's slicing method
 * http://create.stephan-brumme.com/crc32/
 * Copyright (c) 2011-2015 Stephan Brumme. All rights reserved.
 * Slicing-by-16 contributed by Bulat Ziganshin
 *
 * Adapted for Cyrus by Robert Norris <robn@fastmail.com>
 *
 * Individual copyright notices follow.
 */

/*
 * crc32c.c -- compute CRC-32C using the Intel crc32 instruction
 * Copyright (C) 2013 Mark Adler
 * Version 1.1  1 Aug 2013  Mark Adler
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Mark Adler
 * madler@alumni.caltech.edu
 */

/*
 * Copyright (c) 2011-2015 Stephan Brumme. All rights reserved.
 * Slicing-by-16 contributed by Bulat Ziganshin
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the author be held liable for any damages arising from the
 * of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. If you use this software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 * 3. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 */

#include "config.h"
#include "crc32c.h"
#include <string.h>

#ifdef HAVE_SSE42

/* Block sizes for three-way parallel crc computation.  LONG and SHORT must
   both be powers of two.  The associated string constants must be set
   accordingly, for use in constructing the assembler instructions. */
#define LONG 8192
#define LONGx1 "8192"
#define LONGx2 "16384"
#define SHORT 256
#define SHORTx1 "256"
#define SHORTx2 "512"

/* Tables for hardware crc that shift a crc by LONG and SHORT zeros. */
static const uint32_t crc32c_long[4][256] = {
    {
        0x00000000, 0xe040e0ac, 0xc56db7a9, 0x252d5705, 0x8f3719a3, 0x6f77f90f, 0x4a5aae0a, 0xaa1a4ea6,
        0x1b8245b7, 0xfbc2a51b, 0xdeeff21e, 0x3eaf12b2, 0x94b55c14, 0x74f5bcb8, 0x51d8ebbd, 0xb1980b11,
        0x37048b6e, 0xd7446bc2, 0xf2693cc7, 0x1229dc6b, 0xb83392cd, 0x58737261, 0x7d5e2564, 0x9d1ec5c8,
        0x2c86ced9, 0xccc62e75, 0xe9eb7970, 0x09ab99dc, 0xa3b1d77a, 0x43f137d6, 0x66dc60d3, 0x869c807f,
        0x6e0916dc, 0x8e49f670, 0xab64a175, 0x4b2441d9, 0xe13e0f7f, 0x017eefd3, 0x2453b8d6, 0xc413587a,
        0x758b536b, 0x95cbb3c7, 0xb0e6e4c2, 0x50a6046e, 0xfabc4ac8, 0x1afcaa64, 0x3fd1fd61, 0xdf911dcd,
        0x590d9db2, 0xb94d7d1e, 0x9c602a1b, 0x7c20cab7, 0xd63a8411, 0x367a64bd, 0x135733b8, 0xf317d314,
        0x428fd805, 0xa2cf38a9, 0x87e26fac, 0x67a28f00, 0xcdb8c1a6, 0x2df8210a, 0x08d5760f, 0xe89596a3,
        0xdc122db8, 0x3c52cd14, 0x197f9a11, 0xf93f7abd, 0x5325341b, 0xb365d4b7, 0x964883b2, 0x7608631e,
        0xc790680f, 0x27d088a3, 0x02fddfa6, 0xe2bd3f0a, 0x48a771ac, 0xa8e79100, 0x8dcac605, 0x6d8a26a9,
        0xeb16a6d6, 0x0b56467a, 0x2e7b117f, 0xce3bf1d3, 0x6421bf75, 0x84615fd9, 0xa14c08dc, 0x410ce870,
        0xf094e361, 0x10d403cd, 0x35f954c8, 0xd5b9b464, 0x7fa3fac2, 0x9fe31a6e, 0xbace4d6b, 0x5a8eadc7,
        0xb21b3b64, 0x525bdbc8, 0x77768ccd, 0x97366c61, 0x3d2c22c7, 0xdd6cc26b, 0xf841956e, 0x180175c2,
        0xa9997ed3, 0x49d99e7f, 0x6cf4c97a, 0x8cb429d6, 0x26ae6770, 0xc6ee87dc, 0xe3c3d0d9, 0x03833075,
        0x851fb00a, 0x655f50a6, 0x407207a3, 0xa032e70f, 0x0a28a9a9, 0xea684905, 0xcf451e00, 0x2f05feac,
        0x9e9df5bd, 0x7edd1511, 0x5bf04214, 0xbbb0a2b8, 0x11aaec1e, 0xf1ea0cb2, 0xd4c75bb7, 0x3487bb1b,
        0xbdc82d81, 0x5d88cd2d, 0x78a59a28, 0x98e57a84, 0x32ff3422, 0xd2bfd48e, 0xf792838b, 0x17d26327,
        0xa64a6836, 0x460a889a, 0x6327df9f, 0x83673f33, 0x297d7195, 0xc93d9139, 0xec10c63c, 0x0c502690,
        0x8acca6ef, 0x6a8c4643, 0x4fa11146, 0xafe1f1ea, 0x05fbbf4c, 0xe5bb5fe0, 0xc09608e5, 0x20d6e849,
        0x914ee358, 0x710e03f4, 0x542354f1, 0xb463b45d, 0x1e79fafb, 0xfe391a57, 0xdb144d52, 0x3b54adfe,
        0xd3c13b5d, 0x3381dbf1, 0x16ac8cf4, 0xf6ec6c58, 0x5cf622fe, 0xbcb6c252, 0x999b9557, 0x79db75fb,
        0xc8437eea, 0x28039e46, 0x0d2ec943, 0xed6e29ef, 0x47746749, 0xa73487e5, 0x8219d0e0, 0x6259304c,
        0xe4c5b033, 0x0485509f, 0x21a8079a, 0xc1e8e736, 0x6bf2a990, 0x8bb2493c, 0xae9f1e39, 0x4edffe95,
        0xff47f584, 0x1f071528, 0x3a2a422d, 0xda6aa281, 0x7070ec27, 0x90300c8b, 0xb51d5b8e, 0x555dbb22,
        0x61da0039, 0x819ae095, 0xa4b7b790, 0x44f7573c, 0xeeed199a, 0x0eadf936, 0x2b80ae33, 0xcbc04e9f,
        0x7a58458e, 0x9a18a522, 0xbf35f227, 0x5f75128b, 0xf56f5c2d, 0x152fbc81, 0x3002eb84, 0xd0420b28,
        0x56de8b57, 0xb69e6bfb, 0x93b33cfe, 0x73f3dc52, 0xd9e992f4, 0x39a97258, 0x1c84255d, 0xfcc4c5f1,
        0x4d5ccee0, 0xad1c2e4c, 0x88317949, 0x687199e5, 0xc26bd743, 0x222b37ef, 0x070660ea, 0xe7468046,
        0x0fd316e5, 0xef93f649, 0xcabea14c, 0x2afe41e0, 0x80e40f46, 0x60a4efea, 0x4589b8ef, 0xa5c95843,
        0x14515352, 0xf411b3fe, 0xd13ce4fb, 0x317c0457, 0x9b664af1, 0x7b26aa5d, 0x5e0bfd58, 0xbe4b1df4,
        0x38d79d8b, 0xd8977d27, 0xfdba2a22, 0x1dfaca8e, 0xb7e08428, 0x57a06484, 0x728d3381, 0x92cdd32d,
        0x2355d83c, 0xc3153890, 0xe6386f95, 0x06788f39, 0xac62c19f, 0x4c222133, 0x690f7636, 0x894f969a
    },
    {
        0x00000000, 0x7e7c2df3, 0xfcf85be6, 0x82847615, 0xfc1cc13d, 0x8260ecce, 0x00e49adb, 0x7e98b728,
        0xfdd5f48b, 0x83a9d978, 0x012daf6d, 0x7f51829e, 0x01c935b6, 0x7fb51845, 0xfd316e50, 0x834d43a3,
        0xfe479fe7, 0x803bb214, 0x02bfc401, 0x7cc3e9f2, 0x025b5eda, 0x7c277329, 0xfea3053c, 0x80df28cf,
        0x03926b6c, 0x7dee469f, 0xff6a308a, 0x81161d79, 0xff8eaa51, 0x81f287a2, 0x0376f1b7, 0x7d0adc44,
        0xf963493f, 0x871f64cc, 0x059b12d9, 0x7be73f2a, 0x057f8802, 0x7b03a5f1, 0xf987d3e4, 0x87fbfe17,
        0x04b6bdb4, 0x7aca9047, 0xf84ee652, 0x8632cba1, 0xf8aa7c89, 0x86d6517a, 0x0452276f, 0x7a2e0a9c,
        0x0724d6d8, 0x7958fb2b, 0xfbdc8d3e, 0x85a0a0cd, 0xfb3817e5, 0x85443a16, 0x07c04c03, 0x79bc61f0,
        0xfaf12253, 0x848d0fa0, 0x060979b5, 0x78755446, 0x06ede36e, 0x7891ce9d, 0xfa15b888, 0x8469957b,
        0xf72ae48f, 0x8956c97c, 0x0bd2bf69, 0x75ae929a, 0x0b3625b2, 0x754a0841, 0xf7ce7e54, 0x89b253a7,
        0x0aff1004, 0x74833df7, 0xf6074be2, 0x887b6611, 0xf6e3d139, 0x889ffcca, 0x0a1b8adf, 0x7467a72c,
        0x096d7b68, 0x7711569b, 0xf595208e, 0x8be90d7d, 0xf571ba55, 0x8b0d97a6, 0x0989e1b3, 0x77f5cc40,
        0xf4b88fe3, 0x8ac4a210, 0x0840d405, 0x763cf9f6, 0x08a44ede, 0x76d8632d, 0xf45c1538, 0x8a2038cb,
        0x0e49adb0, 0x70358043, 0xf2b1f656, 0x8ccddba5, 0xf2556c8d, 0x8c29417e, 0x0ead376b, 0x70d11a98,
        0xf39c593b, 0x8de074c8, 0x0f6402dd, 0x71182f2e, 0x0f809806, 0x71fcb5f5, 0xf378c3e0, 0x8d04ee13,
        0xf00e3257, 0x8e721fa4, 0x0cf669b1, 0x728a4442, 0x0c12f36a, 0x726ede99, 0xf0eaa88c, 0x8e96857f,
        0x0ddbc6dc, 0x73a7eb2f, 0xf1239d3a, 0x8f5fb0c9, 0xf1c707e1, 0x8fbb2a12, 0x0d3f5c07, 0x734371f4,
        0xebb9bfef, 0x95c5921c, 0x1741e409, 0x693dc9fa, 0x17a57ed2, 0x69d95321, 0xeb5d2534, 0x952108c7,
        0x166c4b64, 0x68106697, 0xea941082, 0x94e83d71, 0xea708a59, 0x940ca7aa, 0x1688d1bf, 0x68f4fc4c,
        0x15fe2008, 0x6b820dfb, 0xe9067bee, 0x977a561d, 0xe9e2e135, 0x979eccc6, 0x151abad3, 0x6b669720,
        0xe82bd483, 0x9657f970, 0x14d38f65, 0x6aafa296, 0x143715be, 0x6a4b384d, 0xe8cf4e58, 0x96b363ab,
        0x12daf6d0, 0x6ca6db23, 0xee22ad36, 0x905e80c5, 0xeec637ed, 0x90ba1a1e, 0x123e6c0b, 0x6c4241f8,
        0xef0f025b, 0x91732fa8, 0x13f759bd, 0x6d8b744e, 0x1313c366, 0x6d6fee95, 0xefeb9880, 0x9197b573,
        0xec9d6937, 0x92e144c4, 0x106532d1, 0x6e191f22, 0x1081a80a, 0x6efd85f9, 0xec79f3ec, 0x9205de1f,
        0x11489dbc, 0x6f34b04f, 0xedb0c65a, 0x93cceba9, 0xed545c81, 0x93287172, 0x11ac0767, 0x6fd02a94,
        0x1c935b60, 0x62ef7693, 0xe06b0086, 0x9e172d75, 0xe08f9a5d, 0x9ef3b7ae, 0x1c77c1bb, 0x620bec48,
        0xe146afeb, 0x9f3a8218, 0x1dbef40d, 0x63c2d9fe, 0x1d5a6ed6, 0x63264325, 0xe1a23530, 0x9fde18c3,
        0xe2d4c487, 0x9ca8e974, 0x1e2c9f61, 0x6050b292, 0x1ec805ba, 0x60b42849, 0xe2305e5c, 0x9c4c73af,
        0x1f01300c, 0x617d1dff, 0xe3f96bea, 0x9d854619, 0xe31df131, 0x9d61dcc2, 0x1fe5aad7, 0x61998724,
        0xe5f0125f, 0x9b8c3fac, 0x190849b9, 0x6774644a, 0x19ecd362, 0x6790fe91, 0xe5148884, 0x9b68a577,
        0x1825e6d4, 0x6659cb27, 0xe4ddbd32, 0x9aa190c1, 0xe43927e9, 0x9a450a1a, 0x18c17c0f, 0x66bd51fc,
        0x1bb78db8, 0x65cba04b, 0xe74fd65e, 0x9933fbad, 0xe7ab4c85, 0x99d76176, 0x1b531763, 0x652f3a90,
        0xe6627933, 0x981e54c0, 0x1a9a22d5, 0x64e60f26, 0x1a7eb80e, 0x640295fd, 0xe686e3e8, 0x98face1b
    },
    {
        0x00000000, 0xd29f092f, 0xa0d264af, 0x724d6d80, 0x4448bfaf, 0x96d7b680, 0xe49adb00, 0x3605d22f,
        0x88917f5e, 0x5a0e7671, 0x28431bf1, 0xfadc12de, 0xccd9c0f1, 0x1e46c9de, 0x6c0ba45e, 0xbe94ad71,
        0x14ce884d, 0xc6518162, 0xb41cece2, 0x6683e5cd, 0x508637e2, 0x82193ecd, 0xf054534d, 0x22cb5a62,
        0x9c5ff713, 0x4ec0fe3c, 0x3c8d93bc, 0xee129a93, 0xd81748bc, 0x0a884193, 0x78c52c13, 0xaa5a253c,
        0x299d109a, 0xfb0219b5, 0x894f7435, 0x5bd07d1a, 0x6dd5af35, 0xbf4aa61a, 0xcd07cb9a, 0x1f98c2b5,
        0xa10c6fc4, 0x739366eb, 0x01de0b6b, 0xd3410244, 0xe544d06b, 0x37dbd944, 0x4596b4c4, 0x9709bdeb,
        0x3d5398d7, 0xefcc91f8, 0x9d81fc78, 0x4f1ef557, 0x791b2778, 0xab842e57, 0xd9c943d7, 0x0b564af8,
        0xb5c2e789, 0x675deea6, 0x15108326, 0xc78f8a09, 0xf18a5826, 0x23155109, 0x51583c89, 0x83c735a6,
        0x533a2134, 0x81a5281b, 0xf3e8459b, 0x21774cb4, 0x17729e9b, 0xc5ed97b4, 0xb7a0fa34, 0x653ff31b,
        0xdbab5e6a, 0x09345745, 0x7b793ac5, 0xa9e633ea, 0x9fe3e1c5, 0x4d7ce8ea, 0x3f31856a, 0xedae8c45,
        0x47f4a979, 0x956ba056, 0xe726cdd6, 0x35b9c4f9, 0x03bc16d6, 0xd1231ff9, 0xa36e7279, 0x71f17b56,
        0xcf65d627, 0x1dfadf08, 0x6fb7b288, 0xbd28bba7, 0x8b2d6988, 0x59b260a7, 0x2bff0d27, 0xf9600408,
        0x7aa731ae, 0xa8383881, 0xda755501, 0x08ea5c2e, 0x3eef8e01, 0xec70872e, 0x9e3deaae, 0x4ca2e381,
        0xf2364ef0, 0x20a947df, 0x52e42a5f, 0x807b2370, 0xb67ef15f, 0x64e1f870, 0x16ac95f0, 0xc4339cdf,
        0x6e69b9e3, 0xbcf6b0cc, 0xcebbdd4c, 0x1c24d463, 0x2a21064c, 0xf8be0f63, 0x8af362e3, 0x586c6bcc,
        0xe6f8c6bd, 0x3467cf92, 0x462aa212, 0x94b5ab3d, 0xa2b07912, 0x702f703d, 0x02621dbd, 0xd0fd1492,
        0xa6744268, 0x74eb4b47, 0x06a626c7, 0xd4392fe8, 0xe23cfdc7, 0x30a3f4e8, 0x42ee9968, 0x90719047,
        0x2ee53d36, 0xfc7a3419, 0x8e375999, 0x5ca850b6, 0x6aad8299, 0xb8328bb6, 0xca7fe636, 0x18e0ef19,
        0xb2baca25, 0x6025c30a, 0x1268ae8a, 0xc0f7a7a5, 0xf6f2758a, 0x246d7ca5, 0x56201125, 0x84bf180a,
        0x3a2bb57b, 0xe8b4bc54, 0x9af9d1d4, 0x4866d8fb, 0x7e630ad4, 0xacfc03fb, 0xdeb16e7b, 0x0c2e6754,
        0x8fe952f2, 0x5d765bdd, 0x2f3b365d, 0xfda43f72, 0xcba1ed5d, 0x193ee472, 0x6b7389f2, 0xb9ec80dd,
        0x07782dac, 0xd5e72483, 0xa7aa4903, 0x7535402c, 0x43309203, 0x91af9b2c, 0xe3e2f6ac, 0x317dff83,
        0x9b27dabf, 0x49b8d390, 0x3bf5be10, 0xe96ab73f, 0xdf6f6510, 0x0df06c3f, 0x7fbd01bf, 0xad220890,
        0x13b6a5e1, 0xc129acce, 0xb364c14e, 0x61fbc861, 0x57fe1a4e, 0x85611361, 0xf72c7ee1, 0x25b377ce,
        0xf54e635c, 0x27d16a73, 0x559c07f3, 0x87030edc, 0xb106dcf3, 0x6399d5dc, 0x11d4b85c, 0xc34bb173,
        0x7ddf1c02, 0xaf40152d, 0xdd0d78ad, 0x0f927182, 0x3997a3ad, 0xeb08aa82, 0x9945c702, 0x4bdace2d,
        0xe180eb11, 0x331fe23e, 0x41528fbe, 0x93cd8691, 0xa5c854be, 0x77575d91, 0x051a3011, 0xd785393e,
        0x6911944f, 0xbb8e9d60, 0xc9c3f0e0, 0x1b5cf9cf, 0x2d592be0, 0xffc622cf, 0x8d8b4f4f, 0x5f144660,
        0xdcd373c6, 0x0e4c7ae9, 0x7c011769, 0xae9e1e46, 0x989bcc69, 0x4a04c546, 0x3849a8c6, 0xead6a1e9,
        0x54420c98, 0x86dd05b7, 0xf4906837, 0x260f6118, 0x100ab337, 0xc295ba18, 0xb0d8d798, 0x6247deb7,
        0xc81dfb8b, 0x1a82f2a4, 0x68cf9f24, 0xba50960b, 0x8c554424, 0x5eca4d0b, 0x2c87208b, 0xfe1829a4,
        0x408c84d5, 0x92138dfa, 0xe05ee07a, 0x32c1e955, 0x04c43b7a, 0xd65b3255, 0xa4165fd5, 0x768956fa
    },
    {
        0x00000000, 0x4904f221, 0x9209e442, 0xdb0d1663, 0x21ffbe75, 0x68fb4c54, 0xb3f65a37, 0xfaf2a816,
        0x43ff7cea, 0x0afb8ecb, 0xd1f698a8, 0x98f26a89, 0x6200c29f, 0x2b0430be, 0xf00926dd, 0xb90dd4fc,
        0x87fef9d4, 0xcefa0bf5, 0x15f71d96, 0x5cf3efb7, 0xa60147a1, 0xef05b580, 0x3408a3e3, 0x7d0c51c2,
        0xc401853e, 0x8d05771f, 0x5608617c, 0x1f0c935d, 0xe5fe3b4b, 0xacfac96a, 0x77f7df09, 0x3ef32d28,
        0x0a118559, 0x43157778, 0x9818611b, 0xd11c933a, 0x2bee3b2c, 0x62eac90d, 0xb9e7df6e, 0xf0e32d4f,
        0x49eef9b3, 0x00ea0b92, 0xdbe71df1, 0x92e3efd0, 0x681147c6, 0x2115b5e7, 0xfa18a384, 0xb31c51a5,
        0x8def7c8d, 0xc4eb8eac, 0x1fe698cf, 0x56e26aee, 0xac10c2f8, 0xe51430d9, 0x3e1926ba, 0x771dd49b,
        0xce100067, 0x8714f246, 0x5c19e425, 0x151d1604, 0xefefbe12, 0xa6eb4c33, 0x7de65a50, 0x34e2a871,
        0x14230ab2, 0x5d27f893, 0x862aeef0, 0xcf2e1cd1, 0x35dcb4c7, 0x7cd846e6, 0xa7d55085, 0xeed1a2a4,
        0x57dc7658, 0x1ed88479, 0xc5d5921a, 0x8cd1603b, 0x7623c82d, 0x3f273a0c, 0xe42a2c6f, 0xad2ede4e,
        0x93ddf366, 0xdad90147, 0x01d41724, 0x48d0e505, 0xb2224d13, 0xfb26bf32, 0x202ba951, 0x692f5b70,
        0xd0228f8c, 0x99267dad, 0x422b6bce, 0x0b2f99ef, 0xf1dd31f9, 0xb8d9c3d8, 0x63d4d5bb, 0x2ad0279a,
        0x1e328feb, 0x57367dca, 0x8c3b6ba9, 0xc53f9988, 0x3fcd319e, 0x76c9c3bf, 0xadc4d5dc, 0xe4c027fd,
        0x5dcdf301, 0x14c90120, 0xcfc41743, 0x86c0e562, 0x7c324d74, 0x3536bf55, 0xee3ba936, 0xa73f5b17,
        0x99cc763f, 0xd0c8841e, 0x0bc5927d, 0x42c1605c, 0xb833c84a, 0xf1373a6b, 0x2a3a2c08, 0x633ede29,
        0xda330ad5, 0x9337f8f4, 0x483aee97, 0x013e1cb6, 0xfbccb4a0, 0xb2c84681, 0x69c550e2, 0x20c1a2c3,
        0x28461564, 0x6142e745, 0xba4ff126, 0xf34b0307, 0x09b9ab11, 0x40bd5930, 0x9bb04f53, 0xd2b4bd72,
        0x6bb9698e, 0x22bd9baf, 0xf9b08dcc, 0xb0b47fed, 0x4a46d7fb, 0x034225da, 0xd84f33b9, 0x914bc198,
        0xafb8ecb0, 0xe6bc1e91, 0x3db108f2, 0x74b5fad3, 0x8e4752c5, 0xc743a0e4, 0x1c4eb687, 0x554a44a6,
        0xec47905a, 0xa543627b, 0x7e4e7418, 0x374a8639, 0xcdb82e2f, 0x84bcdc0e, 0x5fb1ca6d, 0x16b5384c,
        0x2257903d, 0x6b53621c, 0xb05e747f, 0xf95a865e, 0x03a82e48, 0x4aacdc69, 0x91a1ca0a, 0xd8a5382b,
        0x61a8ecd7, 0x28ac1ef6, 0xf3a10895, 0xbaa5fab4, 0x405752a2, 0x0953a083, 0xd25eb6e0, 0x9b5a44c1,
        0xa5a969e9, 0xecad9bc8, 0x37a08dab, 0x7ea47f8a, 0x8456d79c, 0xcd5225bd, 0x165f33de, 0x5f5bc1ff,
        0xe6561503, 0xaf52e722, 0x745ff141, 0x3d5b0360, 0xc7a9ab76, 0x8ead5957, 0x55a04f34, 0x1ca4bd15,
        0x3c651fd6, 0x7561edf7, 0xae6cfb94, 0xe76809b5, 0x1d9aa1a3, 0x549e5382, 0x8f9345e1, 0xc697b7c0,
        0x7f9a633c, 0x369e911d, 0xed93877e, 0xa497755f, 0x5e65dd49, 0x17612f68, 0xcc6c390b, 0x8568cb2a,
        0xbb9be602, 0xf29f1423, 0x29920240, 0x6096f061, 0x9a645877, 0xd360aa56, 0x086dbc35, 0x41694e14,
        0xf8649ae8, 0xb16068c9, 0x6a6d7eaa, 0x23698c8b, 0xd99b249d, 0x909fd6bc, 0x4b92c0df, 0x029632fe,
        0x36749a8f, 0x7f7068ae, 0xa47d7ecd, 0xed798cec, 0x178b24fa, 0x5e8fd6db, 0x8582c0b8, 0xcc863299,
        0x758be665, 0x3c8f1444, 0xe7820227, 0xae86f006, 0x54745810, 0x1d70aa31, 0xc67dbc52, 0x8f794e73,
        0xb18a635b, 0xf88e917a, 0x23838719, 0x6a877538, 0x9075dd2e, 0xd9712f0f, 0x027c396c, 0x4b78cb4d,
        0xf2751fb1, 0xbb71ed90, 0x607cfbf3, 0x297809d2, 0xd38aa1c4, 0x9a8e53e5, 0x41834586, 0x0887b7a7
    }
};
static const uint32_t crc32c_short[4][256] = {
    {
        0x00000000, 0xdcb17aa4, 0xbc8e83b9, 0x603ff91d, 0x7cf17183, 0xa0400b27, 0xc07ff23a, 0x1cce889e,
        0xf9e2e306, 0x255399a2, 0x456c60bf, 0x99dd1a1b, 0x85139285, 0x59a2e821, 0x399d113c, 0xe52c6b98,
        0xf629b0fd, 0x2a98ca59, 0x4aa73344, 0x961649e0, 0x8ad8c17e, 0x5669bbda, 0x365642c7, 0xeae73863,
        0x0fcb53fb, 0xd37a295f, 0xb345d042, 0x6ff4aae6, 0x733a2278, 0xaf8b58dc, 0xcfb4a1c1, 0x1305db65,
        0xe9bf170b, 0x350e6daf, 0x553194b2, 0x8980ee16, 0x954e6688, 0x49ff1c2c, 0x29c0e531, 0xf5719f95,
        0x105df40d, 0xccec8ea9, 0xacd377b4, 0x70620d10, 0x6cac858e, 0xb01dff2a, 0xd0220637, 0x0c937c93,
        0x1f96a7f6, 0xc327dd52, 0xa318244f, 0x7fa95eeb, 0x6367d675, 0xbfd6acd1, 0xdfe955cc, 0x03582f68,
        0xe67444f0, 0x3ac53e54, 0x5afac749, 0x864bbded, 0x9a853573, 0x46344fd7, 0x260bb6ca, 0xfabacc6e,
        0xd69258e7, 0x0a232243, 0x6a1cdb5e, 0xb6ada1fa, 0xaa632964, 0x76d253c0, 0x16edaadd, 0xca5cd079,
        0x2f70bbe1, 0xf3c1c145, 0x93fe3858, 0x4f4f42fc, 0x5381ca62, 0x8f30b0c6, 0xef0f49db, 0x33be337f,
        0x20bbe81a, 0xfc0a92be, 0x9c356ba3, 0x40841107, 0x5c4a9999, 0x80fbe33d, 0xe0c41a20, 0x3c756084,
        0xd9590b1c, 0x05e871b8, 0x65d788a5, 0xb966f201, 0xa5a87a9f, 0x7919003b, 0x1926f926, 0xc5978382,
        0x3f2d4fec, 0xe39c3548, 0x83a3cc55, 0x5f12b6f1, 0x43dc3e6f, 0x9f6d44cb, 0xff52bdd6, 0x23e3c772,
        0xc6cfacea, 0x1a7ed64e, 0x7a412f53, 0xa6f055f7, 0xba3edd69, 0x668fa7cd, 0x06b05ed0, 0xda012474,
        0xc904ff11, 0x15b585b5, 0x758a7ca8, 0xa93b060c, 0xb5f58e92, 0x6944f436, 0x097b0d2b, 0xd5ca778f,
        0x30e61c17, 0xec5766b3, 0x8c689fae, 0x50d9e50a, 0x4c176d94, 0x90a61730, 0xf099ee2d, 0x2c289489,
        0xa8c8c73f, 0x7479bd9b, 0x14464486, 0xc8f73e22, 0xd439b6bc, 0x0888cc18, 0x68b73505, 0xb4064fa1,
        0x512a2439, 0x8d9b5e9d, 0xeda4a780, 0x3115dd24, 0x2ddb55ba, 0xf16a2f1e, 0x9155d603, 0x4de4aca7,
        0x5ee177c2, 0x82500d66, 0xe26ff47b, 0x3ede8edf, 0x22100641, 0xfea17ce5, 0x9e9e85f8, 0x422fff5c,
        0xa70394c4, 0x7bb2ee60, 0x1b8d177d, 0xc73c6dd9, 0xdbf2e547, 0x07439fe3, 0x677c66fe, 0xbbcd1c5a,
        0x4177d034, 0x9dc6aa90, 0xfdf9538d, 0x21482929, 0x3d86a1b7, 0xe137db13, 0x8108220e, 0x5db958aa,
        0xb8953332, 0x64244996, 0x041bb08b, 0xd8aaca2f, 0xc46442b1, 0x18d53815, 0x78eac108, 0xa45bbbac,
        0xb75e60c9, 0x6bef1a6d, 0x0bd0e370, 0xd76199d4, 0xcbaf114a, 0x171e6bee, 0x772192f3, 0xab90e857,
        0x4ebc83cf, 0x920df96b, 0xf2320076, 0x2e837ad2, 0x324df24c, 0xeefc88e8, 0x8ec371f5, 0x52720b51,
        0x7e5a9fd8, 0xa2ebe57c, 0xc2d41c61, 0x1e6566c5, 0x02abee5b, 0xde1a94ff, 0xbe256de2, 0x62941746,
        0x87b87cde, 0x5b09067a, 0x3b36ff67, 0xe78785c3, 0xfb490d5d, 0x27f877f9, 0x47c78ee4, 0x9b76f440,
        0x88732f25, 0x54c25581, 0x34fdac9c, 0xe84cd638, 0xf4825ea6, 0x28332402, 0x480cdd1f, 0x94bda7bb,
        0x7191cc23, 0xad20b687, 0xcd1f4f9a, 0x11ae353e, 0x0d60bda0, 0xd1d1c704, 0xb1ee3e19, 0x6d5f44bd,
        0x97e588d3, 0x4b54f277, 0x2b6b0b6a, 0xf7da71ce, 0xeb14f950, 0x37a583f4, 0x579a7ae9, 0x8b2b004d,
        0x6e076bd5, 0xb2b61171, 0xd289e86c, 0x0e3892c8, 0x12f61a56, 0xce4760f2, 0xae7899ef, 0x72c9e34b,
        0x61cc382e, 0xbd7d428a, 0xdd42bb97, 0x01f3c133, 0x1d3d49ad, 0xc18c3309, 0xa1b3ca14, 0x7d02b0b0,
        0x982edb28, 0x449fa18c, 0x24a05891, 0xf8112235, 0xe4dfaaab, 0x386ed00f, 0x58512912, 0x84e053b6
    },
    {
        0x00000000, 0x547df88f, 0xa8fbf11e, 0xfc860991, 0x541b94cd, 0x00666c42, 0xfce065d3, 0xa89d9d5c,
        0xa837299a, 0xfc4ad115, 0x00ccd884, 0x54b1200b, 0xfc2cbd57, 0xa85145d8, 0x54d74c49, 0x00aab4c6,
        0x558225c5, 0x01ffdd4a, 0xfd79d4db, 0xa9042c54, 0x0199b108, 0x55e44987, 0xa9624016, 0xfd1fb899,
        0xfdb50c5f, 0xa9c8f4d0, 0x554efd41, 0x013305ce, 0xa9ae9892, 0xfdd3601d, 0x0155698c, 0x55289103,
        0xab044b8a, 0xff79b305, 0x03ffba94, 0x5782421b, 0xff1fdf47, 0xab6227c8, 0x57e42e59, 0x0399d6d6,
        0x03336210, 0x574e9a9f, 0xabc8930e, 0xffb56b81, 0x5728f6dd, 0x03550e52, 0xffd307c3, 0xabaeff4c,
        0xfe866e4f, 0xaafb96c0, 0x567d9f51, 0x020067de, 0xaa9dfa82, 0xfee0020d, 0x02660b9c, 0x561bf313,
        0x56b147d5, 0x02ccbf5a, 0xfe4ab6cb, 0xaa374e44, 0x02aad318, 0x56d72b97, 0xaa512206, 0xfe2cda89,
        0x53e4e1e5, 0x0799196a, 0xfb1f10fb, 0xaf62e874, 0x07ff7528, 0x53828da7, 0xaf048436, 0xfb797cb9,
        0xfbd3c87f, 0xafae30f0, 0x53283961, 0x0755c1ee, 0xafc85cb2, 0xfbb5a43d, 0x0733adac, 0x534e5523,
        0x0666c420, 0x521b3caf, 0xae9d353e, 0xfae0cdb1, 0x527d50ed, 0x0600a862, 0xfa86a1f3, 0xaefb597c,
        0xae51edba, 0xfa2c1535, 0x06aa1ca4, 0x52d7e42b, 0xfa4a7977, 0xae3781f8, 0x52b18869, 0x06cc70e6,
        0xf8e0aa6f, 0xac9d52e0, 0x501b5b71, 0x0466a3fe, 0xacfb3ea2, 0xf886c62d, 0x0400cfbc, 0x507d3733,
        0x50d783f5, 0x04aa7b7a, 0xf82c72eb, 0xac518a64, 0x04cc1738, 0x50b1efb7, 0xac37e626, 0xf84a1ea9,
        0xad628faa, 0xf91f7725, 0x05997eb4, 0x51e4863b, 0xf9791b67, 0xad04e3e8, 0x5182ea79, 0x05ff12f6,
        0x0555a630, 0x51285ebf, 0xadae572e, 0xf9d3afa1, 0x514e32fd, 0x0533ca72, 0xf9b5c3e3, 0xadc83b6c,
        0xa7c9c3ca, 0xf3b43b45, 0x0f3232d4, 0x5b4fca5b, 0xf3d25707, 0xa7afaf88, 0x5b29a619, 0x0f545e96,
        0x0ffeea50, 0x5b8312df, 0xa7051b4e, 0xf378e3c1, 0x5be57e9d, 0x0f988612, 0xf31e8f83, 0xa763770c,
        0xf24be60f, 0xa6361e80, 0x5ab01711, 0x0ecdef9e, 0xa65072c2, 0xf22d8a4d, 0x0eab83dc, 0x5ad67b53,
        0x5a7ccf95, 0x0e01371a, 0xf2873e8b, 0xa6fac604, 0x0e675b58, 0x5a1aa3d7, 0xa69caa46, 0xf2e152c9,
        0x0ccd8840, 0x58b070cf, 0xa436795e, 0xf04b81d1, 0x58d61c8d, 0x0cabe402, 0xf02ded93, 0xa450151c,
        0xa4faa1da, 0xf0875955, 0x0c0150c4, 0x587ca84b, 0xf0e13517, 0xa49ccd98, 0x581ac409, 0x0c673c86,
        0x594fad85, 0x0d32550a, 0xf1b45c9b, 0xa5c9a414, 0x0d543948, 0x5929c1c7, 0xa5afc856, 0xf1d230d9,
        0xf178841f, 0xa5057c90, 0x59837501, 0x0dfe8d8e, 0xa56310d2, 0xf11ee85d, 0x0d98e1cc, 0x59e51943,
        0xf42d222f, 0xa050daa0, 0x5cd6d331, 0x08ab2bbe, 0xa036b6e2, 0xf44b4e6d, 0x08cd47fc, 0x5cb0bf73,
        0x5c1a0bb5, 0x0867f33a, 0xf4e1faab, 0xa09c0224, 0x08019f78, 0x5c7c67f7, 0xa0fa6e66, 0xf48796e9,
        0xa1af07ea, 0xf5d2ff65, 0x0954f6f4, 0x5d290e7b, 0xf5b49327, 0xa1c96ba8, 0x5d4f6239, 0x09329ab6,
        0x09982e70, 0x5de5d6ff, 0xa163df6e, 0xf51e27e1, 0x5d83babd, 0x09fe4232, 0xf5784ba3, 0xa105b32c,
        0x5f2969a5, 0x0b54912a, 0xf7d298bb, 0xa3af6034, 0x0b32fd68, 0x5f4f05e7, 0xa3c90c76, 0xf7b4f4f9,
        0xf71e403f, 0xa363b8b0, 0x5fe5b121, 0x0b9849ae, 0xa305d4f2, 0xf7782c7d, 0x0bfe25ec, 0x5f83dd63,
        0x0aab4c60, 0x5ed6b4ef, 0xa250bd7e, 0xf62d45f1, 0x5eb0d8ad, 0x0acd2022, 0xf64b29b3, 0xa236d13c,
        0xa29c65fa, 0xf6e19d75, 0x0a6794e4, 0x5e1a6c6b, 0xf687f137, 0xa2fa09b8, 0x5e7c0029, 0x0a01f8a6
    },
    {
        0x00000000, 0x4a7ff165, 0x94ffe2ca, 0xde8013af, 0x2c13b365, 0x666c4200, 0xb8ec51af, 0xf293a0ca,
        0x582766ca, 0x125897af, 0xccd88400, 0x86a77565, 0x7434d5af, 0x3e4b24ca, 0xe0cb3765, 0xaab4c600,
        0xb04ecd94, 0xfa313cf1, 0x24b12f5e, 0x6ecede3b, 0x9c5d7ef1, 0xd6228f94, 0x08a29c3b, 0x42dd6d5e,
        0xe869ab5e, 0xa2165a3b, 0x7c964994, 0x36e9b8f1, 0xc47a183b, 0x8e05e95e, 0x5085faf1, 0x1afa0b94,
        0x6571edd9, 0x2f0e1cbc, 0xf18e0f13, 0xbbf1fe76, 0x49625ebc, 0x031dafd9, 0xdd9dbc76, 0x97e24d13,
        0x3d568b13, 0x77297a76, 0xa9a969d9, 0xe3d698bc, 0x11453876, 0x5b3ac913, 0x85badabc, 0xcfc52bd9,
        0xd53f204d, 0x9f40d128, 0x41c0c287, 0x0bbf33e2, 0xf92c9328, 0xb353624d, 0x6dd371e2, 0x27ac8087,
        0x8d184687, 0xc767b7e2, 0x19e7a44d, 0x53985528, 0xa10bf5e2, 0xeb740487, 0x35f41728, 0x7f8be64d,
        0xcae3dbb2, 0x809c2ad7, 0x5e1c3978, 0x1463c81d, 0xe6f068d7, 0xac8f99b2, 0x720f8a1d, 0x38707b78,
        0x92c4bd78, 0xd8bb4c1d, 0x063b5fb2, 0x4c44aed7, 0xbed70e1d, 0xf4a8ff78, 0x2a28ecd7, 0x60571db2,
        0x7aad1626, 0x30d2e743, 0xee52f4ec, 0xa42d0589, 0x56bea543, 0x1cc15426, 0xc2414789, 0x883eb6ec,
        0x228a70ec, 0x68f58189, 0xb6759226, 0xfc0a6343, 0x0e99c389, 0x44e632ec, 0x9a662143, 0xd019d026,
        0xaf92366b, 0xe5edc70e, 0x3b6dd4a1, 0x711225c4, 0x8381850e, 0xc9fe746b, 0x177e67c4, 0x5d0196a1,
        0xf7b550a1, 0xbdcaa1c4, 0x634ab26b, 0x2935430e, 0xdba6e3c4, 0x91d912a1, 0x4f59010e, 0x0526f06b,
        0x1fdcfbff, 0x55a30a9a, 0x8b231935, 0xc15ce850, 0x33cf489a, 0x79b0b9ff, 0xa730aa50, 0xed4f5b35,
        0x47fb9d35, 0x0d846c50, 0xd3047fff, 0x997b8e9a, 0x6be82e50, 0x2197df35, 0xff17cc9a, 0xb5683dff,
        0x902bc195, 0xda5430f0, 0x04d4235f, 0x4eabd23a, 0xbc3872f0, 0xf6478395, 0x28c7903a, 0x62b8615f,
        0xc80ca75f, 0x8273563a, 0x5cf34595, 0x168cb4f0, 0xe41f143a, 0xae60e55f, 0x70e0f6f0, 0x3a9f0795,
        0x20650c01, 0x6a1afd64, 0xb49aeecb, 0xfee51fae, 0x0c76bf64, 0x46094e01, 0x98895dae, 0xd2f6accb,
        0x78426acb, 0x323d9bae, 0xecbd8801, 0xa6c27964, 0x5451d9ae, 0x1e2e28cb, 0xc0ae3b64, 0x8ad1ca01,
        0xf55a2c4c, 0xbf25dd29, 0x61a5ce86, 0x2bda3fe3, 0xd9499f29, 0x93366e4c, 0x4db67de3, 0x07c98c86,
        0xad7d4a86, 0xe702bbe3, 0x3982a84c, 0x73fd5929, 0x816ef9e3, 0xcb110886, 0x15911b29, 0x5feeea4c,
        0x4514e1d8, 0x0f6b10bd, 0xd1eb0312, 0x9b94f277, 0x690752bd, 0x2378a3d8, 0xfdf8b077, 0xb7874112,
        0x1d338712, 0x574c7677, 0x89cc65d8, 0xc3b394bd, 0x31203477, 0x7b5fc512, 0xa5dfd6bd, 0xefa027d8,
        0x5ac81a27, 0x10b7eb42, 0xce37f8ed, 0x84480988, 0x76dba942, 0x3ca45827, 0xe2244b88, 0xa85bbaed,
        0x02ef7ced, 0x48908d88, 0x96109e27, 0xdc6f6f42, 0x2efccf88, 0x64833eed, 0xba032d42, 0xf07cdc27,
        0xea86d7b3, 0xa0f926d6, 0x7e793579, 0x3406c41c, 0xc69564d6, 0x8cea95b3, 0x526a861c, 0x18157779,
        0xb2a1b179, 0xf8de401c, 0x265e53b3, 0x6c21a2d6, 0x9eb2021c, 0xd4cdf379, 0x0a4de0d6, 0x403211b3,
        0x3fb9f7fe, 0x75c6069b, 0xab461534, 0xe139e451, 0x13aa449b, 0x59d5b5fe, 0x8755a651, 0xcd2a5734,
        0x679e9134, 0x2de16051, 0xf36173fe, 0xb91e829b, 0x4b8d2251, 0x01f2d334, 0xdf72c09b, 0x950d31fe,
        0x8ff73a6a, 0xc588cb0f, 0x1b08d8a0, 0x517729c5, 0xa3e4890f, 0xe99b786a, 0x371b6bc5, 0x7d649aa0,
        0xd7d05ca0, 0x9dafadc5, 0x432fbe6a, 0x09504f0f, 0xfbc3efc5, 0xb1bc1ea0, 0x6f3c0d0f, 0x2543fc6a
    },
    {
        0x00000000, 0x25bbf5db, 0x4b77ebb6, 0x6ecc1e6d, 0x96efd76c, 0xb35422b7, 0xdd983cda, 0xf823c901,
        0x2833d829, 0x0d882df2, 0x6344339f, 0x46ffc644, 0xbedc0f45, 0x9b67fa9e, 0xf5abe4f3, 0xd0101128,
        0x5067b052, 0x75dc4589, 0x1b105be4, 0x3eabae3f, 0xc688673e, 0xe33392e5, 0x8dff8c88, 0xa8447953,
        0x7854687b, 0x5def9da0, 0x332383cd, 0x16987616, 0xeebbbf17, 0xcb004acc, 0xa5cc54a1, 0x8077a17a,
        0xa0cf60a4, 0x8574957f, 0xebb88b12, 0xce037ec9, 0x3620b7c8, 0x139b4213, 0x7d575c7e, 0x58eca9a5,
        0x88fcb88d, 0xad474d56, 0xc38b533b, 0xe630a6e0, 0x1e136fe1, 0x3ba89a3a, 0x55648457, 0x70df718c,
        0xf0a8d0f6, 0xd513252d, 0xbbdf3b40, 0x9e64ce9b, 0x6647079a, 0x43fcf241, 0x2d30ec2c, 0x088b19f7,
        0xd89b08df, 0xfd20fd04, 0x93ece369, 0xb65716b2, 0x4e74dfb3, 0x6bcf2a68, 0x05033405, 0x20b8c1de,
        0x4472b7b9, 0x61c94262, 0x0f055c0f, 0x2abea9d4, 0xd29d60d5, 0xf726950e, 0x99ea8b63, 0xbc517eb8,
        0x6c416f90, 0x49fa9a4b, 0x27368426, 0x028d71fd, 0xfaaeb8fc, 0xdf154d27, 0xb1d9534a, 0x9462a691,
        0x141507eb, 0x31aef230, 0x5f62ec5d, 0x7ad91986, 0x82fad087, 0xa741255c, 0xc98d3b31, 0xec36ceea,
        0x3c26dfc2, 0x199d2a19, 0x77513474, 0x52eac1af, 0xaac908ae, 0x8f72fd75, 0xe1bee318, 0xc40516c3,
        0xe4bdd71d, 0xc10622c6, 0xafca3cab, 0x8a71c970, 0x72520071, 0x57e9f5aa, 0x3925ebc7, 0x1c9e1e1c,
        0xcc8e0f34, 0xe935faef, 0x87f9e482, 0xa2421159, 0x5a61d858, 0x7fda2d83, 0x111633ee, 0x34adc635,
        0xb4da674f, 0x91619294, 0xffad8cf9, 0xda167922, 0x2235b023, 0x078e45f8, 0x69425b95, 0x4cf9ae4e,
        0x9ce9bf66, 0xb9524abd, 0xd79e54d0, 0xf225a10b, 0x0a06680a, 0x2fbd9dd1, 0x417183bc, 0x64ca7667,
        0x88e56f72, 0xad5e9aa9, 0xc39284c4, 0xe629711f, 0x1e0ab81e, 0x3bb14dc5, 0x557d53a8, 0x70c6a673,
        0xa0d6b75b, 0x856d4280, 0xeba15ced, 0xce1aa936, 0x36396037, 0x138295ec, 0x7d4e8b81, 0x58f57e5a,
        0xd882df20, 0xfd392afb, 0x93f53496, 0xb64ec14d, 0x4e6d084c, 0x6bd6fd97, 0x051ae3fa, 0x20a11621,
        0xf0b10709, 0xd50af2d2, 0xbbc6ecbf, 0x9e7d1964, 0x665ed065, 0x43e525be, 0x2d293bd3, 0x0892ce08,
        0x282a0fd6, 0x0d91fa0d, 0x635de460, 0x46e611bb, 0xbec5d8ba, 0x9b7e2d61, 0xf5b2330c, 0xd009c6d7,
        0x0019d7ff, 0x25a22224, 0x4b6e3c49, 0x6ed5c992, 0x96f60093, 0xb34df548, 0xdd81eb25, 0xf83a1efe,
        0x784dbf84, 0x5df64a5f, 0x333a5432, 0x1681a1e9, 0xeea268e8, 0xcb199d33, 0xa5d5835e, 0x806e7685,
        0x507e67ad, 0x75c59276, 0x1b098c1b, 0x3eb279c0, 0xc691b0c1, 0xe32a451a, 0x8de65b77, 0xa85daeac,
        0xcc97d8cb, 0xe92c2d10, 0x87e0337d, 0xa25bc6a6, 0x5a780fa7, 0x7fc3fa7c, 0x110fe411, 0x34b411ca,
        0xe4a400e2, 0xc11ff539, 0xafd3eb54, 0x8a681e8f, 0x724bd78e, 0x57f02255, 0x393c3c38, 0x1c87c9e3,
        0x9cf06899, 0xb94b9d42, 0xd787832f, 0xf23c76f4, 0x0a1fbff5, 0x2fa44a2e, 0x41685443, 0x64d3a198,
        0xb4c3b0b0, 0x9178456b, 0xffb45b06, 0xda0faedd, 0x222c67dc, 0x07979207, 0x695b8c6a, 0x4ce079b1,
        0x6c58b86f, 0x49e34db4, 0x272f53d9, 0x0294a602, 0xfab76f03, 0xdf0c9ad8, 0xb1c084b5, 0x947b716e,
        0x446b6046, 0x61d0959d, 0x0f1c8bf0, 0x2aa77e2b, 0xd284b72a, 0xf73f42f1, 0x99f35c9c, 0xbc48a947,
        0x3c3f083d, 0x1984fde6, 0x7748e38b, 0x52f31650, 0xaad0df51, 0x8f6b2a8a, 0xe1a734e7, 0xc41cc13c,
        0x140cd014, 0x31b725cf, 0x5f7b3ba2, 0x7ac0ce79, 0x82e30778, 0xa758f2a3, 0xc994ecce, 0xec2f1915
    }
};

/* Apply the zeros operator table to crc. */
static inline uint32_t crc32c_shift(const uint32_t zeros[][256], uint32_t crc)
{
    return zeros[0][crc & 0xff] ^ zeros[1][(crc >> 8) & 0xff] ^
           zeros[2][(crc >> 16) & 0xff] ^ zeros[3][crc >> 24];
}

/* Compute CRC-32C using the Intel hardware instruction. */
static uint32_t crc32c_hw(uint32_t crc, const void *buf, size_t len)
{
    const unsigned char *next = buf;
    const unsigned char *end;
    uint64_t crc0, crc1, crc2;      /* need to be 64 bits for crc32q */

    /* pre-process the crc */
    crc0 = crc ^ 0xffffffff;

    /* compute the crc for up to seven leading bytes to bring the data pointer
       to an eight-byte boundary */
    while (len && ((uintptr_t)next & 7) != 0) {
        __asm__("crc32b\t" "(%1), %0"
                : "=r"(crc0)
                : "r"(next), "0"(crc0));
        next++;
        len--;
    }

    /* compute the crc on sets of LONG*3 bytes, executing three independent crc
       instructions, each on LONG bytes -- this is optimized for the Nehalem,
       Westmere, Sandy Bridge, and Ivy Bridge architectures, which have a
       throughput of one crc per cycle, but a latency of three cycles */
    while (len >= LONG*3) {
        crc1 = 0;
        crc2 = 0;
        end = next + LONG;
        do {
            __asm__("crc32q\t" "(%3), %0\n\t"
                    "crc32q\t" LONGx1 "(%3), %1\n\t"
                    "crc32q\t" LONGx2 "(%3), %2"
                    : "=r"(crc0), "=r"(crc1), "=r"(crc2)
                    : "r"(next), "0"(crc0), "1"(crc1), "2"(crc2));
            next += 8;
        } while (next < end);
        crc0 = crc32c_shift(crc32c_long, crc0) ^ crc1;
        crc0 = crc32c_shift(crc32c_long, crc0) ^ crc2;
        next += LONG*2;
        len -= LONG*3;
    }

    /* do the same thing, but now on SHORT*3 blocks for the remaining data less
       than a LONG*3 block */
    while (len >= SHORT*3) {
        crc1 = 0;
        crc2 = 0;
        end = next + SHORT;
        do {
            __asm__("crc32q\t" "(%3), %0\n\t"
                    "crc32q\t" SHORTx1 "(%3), %1\n\t"
                    "crc32q\t" SHORTx2 "(%3), %2"
                    : "=r"(crc0), "=r"(crc1), "=r"(crc2)
                    : "r"(next), "0"(crc0), "1"(crc1), "2"(crc2));
            next += 8;
        } while (next < end);
        crc0 = crc32c_shift(crc32c_short, crc0) ^ crc1;
        crc0 = crc32c_shift(crc32c_short, crc0) ^ crc2;
        next += SHORT*2;
        len -= SHORT*3;
    }

    /* compute the crc on the remaining eight-byte units less than a SHORT*3
       block */
    end = next + (len - (len & 7));
    while (next < end) {
        __asm__("crc32q\t" "(%1), %0"
                : "=r"(crc0)
                : "r"(next), "0"(crc0));
        next += 8;
    }
    len &= 7;

    /* compute the crc for up to seven trailing bytes */
    while (len) {
        __asm__("crc32b\t" "(%1), %0"
                : "=r"(crc0)
                : "r"(next), "0"(crc0));
        next++;
        len--;
    }

    /* return a post-processed crc */
    return (uint32_t)crc0 ^ 0xffffffff;
}

#endif /* HAVE_SSE42 */


/* Tables for slice-by-4 software fallback */
static const uint32_t crc32c_lookup[4][256] = {
    {
        0x00000000, 0xf26b8303, 0xe13b70f7, 0x1350f3f4, 0xc79a971f, 0x35f1141c, 0x26a1e7e8, 0xd4ca64eb,
        0x8ad958cf, 0x78b2dbcc, 0x6be22838, 0x9989ab3b, 0x4d43cfd0, 0xbf284cd3, 0xac78bf27, 0x5e133c24,
        0x105ec76f, 0xe235446c, 0xf165b798, 0x030e349b, 0xd7c45070, 0x25afd373, 0x36ff2087, 0xc494a384,
        0x9a879fa0, 0x68ec1ca3, 0x7bbcef57, 0x89d76c54, 0x5d1d08bf, 0xaf768bbc, 0xbc267848, 0x4e4dfb4b,
        0x20bd8ede, 0xd2d60ddd, 0xc186fe29, 0x33ed7d2a, 0xe72719c1, 0x154c9ac2, 0x061c6936, 0xf477ea35,
        0xaa64d611, 0x580f5512, 0x4b5fa6e6, 0xb93425e5, 0x6dfe410e, 0x9f95c20d, 0x8cc531f9, 0x7eaeb2fa,
        0x30e349b1, 0xc288cab2, 0xd1d83946, 0x23b3ba45, 0xf779deae, 0x05125dad, 0x1642ae59, 0xe4292d5a,
        0xba3a117e, 0x4851927d, 0x5b016189, 0xa96ae28a, 0x7da08661, 0x8fcb0562, 0x9c9bf696, 0x6ef07595,
        0x417b1dbc, 0xb3109ebf, 0xa0406d4b, 0x522bee48, 0x86e18aa3, 0x748a09a0, 0x67dafa54, 0x95b17957,
        0xcba24573, 0x39c9c670, 0x2a993584, 0xd8f2b687, 0x0c38d26c, 0xfe53516f, 0xed03a29b, 0x1f682198,
        0x5125dad3, 0xa34e59d0, 0xb01eaa24, 0x42752927, 0x96bf4dcc, 0x64d4cecf, 0x77843d3b, 0x85efbe38,
        0xdbfc821c, 0x2997011f, 0x3ac7f2eb, 0xc8ac71e8, 0x1c661503, 0xee0d9600, 0xfd5d65f4, 0x0f36e6f7,
        0x61c69362, 0x93ad1061, 0x80fde395, 0x72966096, 0xa65c047d, 0x5437877e, 0x4767748a, 0xb50cf789,
        0xeb1fcbad, 0x197448ae, 0x0a24bb5a, 0xf84f3859, 0x2c855cb2, 0xdeeedfb1, 0xcdbe2c45, 0x3fd5af46,
        0x7198540d, 0x83f3d70e, 0x90a324fa, 0x62c8a7f9, 0xb602c312, 0x44694011, 0x5739b3e5, 0xa55230e6,
        0xfb410cc2, 0x092a8fc1, 0x1a7a7c35, 0xe811ff36, 0x3cdb9bdd, 0xceb018de, 0xdde0eb2a, 0x2f8b6829,
        0x82f63b78, 0x709db87b, 0x63cd4b8f, 0x91a6c88c, 0x456cac67, 0xb7072f64, 0xa457dc90, 0x563c5f93,
        0x082f63b7, 0xfa44e0b4, 0xe9141340, 0x1b7f9043, 0xcfb5f4a8, 0x3dde77ab, 0x2e8e845f, 0xdce5075c,
        0x92a8fc17, 0x60c37f14, 0x73938ce0, 0x81f80fe3, 0x55326b08, 0xa759e80b, 0xb4091bff, 0x466298fc,
        0x1871a4d8, 0xea1a27db, 0xf94ad42f, 0x0b21572c, 0xdfeb33c7, 0x2d80b0c4, 0x3ed04330, 0xccbbc033,
        0xa24bb5a6, 0x502036a5, 0x4370c551, 0xb11b4652, 0x65d122b9, 0x97baa1ba, 0x84ea524e, 0x7681d14d,
        0x2892ed69, 0xdaf96e6a, 0xc9a99d9e, 0x3bc21e9d, 0xef087a76, 0x1d63f975, 0x0e330a81, 0xfc588982,
        0xb21572c9, 0x407ef1ca, 0x532e023e, 0xa145813d, 0x758fe5d6, 0x87e466d5, 0x94b49521, 0x66df1622,
        0x38cc2a06, 0xcaa7a905, 0xd9f75af1, 0x2b9cd9f2, 0xff56bd19, 0x0d3d3e1a, 0x1e6dcdee, 0xec064eed,
        0xc38d26c4, 0x31e6a5c7, 0x22b65633, 0xd0ddd530, 0x0417b1db, 0xf67c32d8, 0xe52cc12c, 0x1747422f,
        0x49547e0b, 0xbb3ffd08, 0xa86f0efc, 0x5a048dff, 0x8ecee914, 0x7ca56a17, 0x6ff599e3, 0x9d9e1ae0,
        0xd3d3e1ab, 0x21b862a8, 0x32e8915c, 0xc083125f, 0x144976b4, 0xe622f5b7, 0xf5720643, 0x07198540,
        0x590ab964, 0xab613a67, 0xb831c993, 0x4a5a4a90, 0x9e902e7b, 0x6cfbad78, 0x7fab5e8c, 0x8dc0dd8f,
        0xe330a81a, 0x115b2b19, 0x020bd8ed, 0xf0605bee, 0x24aa3f05, 0xd6c1bc06, 0xc5914ff2, 0x37faccf1,
        0x69e9f0d5, 0x9b8273d6, 0x88d28022, 0x7ab90321, 0xae7367ca, 0x5c18e4c9, 0x4f48173d, 0xbd23943e,
        0xf36e6f75, 0x0105ec76, 0x12551f82, 0xe03e9c81, 0x34f4f86a, 0xc69f7b69, 0xd5cf889d, 0x27a40b9e,
        0x79b737ba, 0x8bdcb4b9, 0x988c474d, 0x6ae7c44e, 0xbe2da0a5, 0x4c4623a6, 0x5f16d052, 0xad7d5351
    },
    {
        0x00000000, 0x13a29877, 0x274530ee, 0x34e7a899, 0x4e8a61dc, 0x5d28f9ab, 0x69cf5132, 0x7a6dc945,
        0x9d14c3b8, 0x8eb65bcf, 0xba51f356, 0xa9f36b21, 0xd39ea264, 0xc03c3a13, 0xf4db928a, 0xe7790afd,
        0x3fc5f181, 0x2c6769f6, 0x1880c16f, 0x0b225918, 0x714f905d, 0x62ed082a, 0x560aa0b3, 0x45a838c4,
        0xa2d13239, 0xb173aa4e, 0x859402d7, 0x96369aa0, 0xec5b53e5, 0xfff9cb92, 0xcb1e630b, 0xd8bcfb7c,
        0x7f8be302, 0x6c297b75, 0x58ced3ec, 0x4b6c4b9b, 0x310182de, 0x22a31aa9, 0x1644b230, 0x05e62a47,
        0xe29f20ba, 0xf13db8cd, 0xc5da1054, 0xd6788823, 0xac154166, 0xbfb7d911, 0x8b507188, 0x98f2e9ff,
        0x404e1283, 0x53ec8af4, 0x670b226d, 0x74a9ba1a, 0x0ec4735f, 0x1d66eb28, 0x298143b1, 0x3a23dbc6,
        0xdd5ad13b, 0xcef8494c, 0xfa1fe1d5, 0xe9bd79a2, 0x93d0b0e7, 0x80722890, 0xb4958009, 0xa737187e,
        0xff17c604, 0xecb55e73, 0xd852f6ea, 0xcbf06e9d, 0xb19da7d8, 0xa23f3faf, 0x96d89736, 0x857a0f41,
        0x620305bc, 0x71a19dcb, 0x45463552, 0x56e4ad25, 0x2c896460, 0x3f2bfc17, 0x0bcc548e, 0x186eccf9,
        0xc0d23785, 0xd370aff2, 0xe797076b, 0xf4359f1c, 0x8e585659, 0x9dface2e, 0xa91d66b7, 0xbabffec0,
        0x5dc6f43d, 0x4e646c4a, 0x7a83c4d3, 0x69215ca4, 0x134c95e1, 0x00ee0d96, 0x3409a50f, 0x27ab3d78,
        0x809c2506, 0x933ebd71, 0xa7d915e8, 0xb47b8d9f, 0xce1644da, 0xddb4dcad, 0xe9537434, 0xfaf1ec43,
        0x1d88e6be, 0x0e2a7ec9, 0x3acdd650, 0x296f4e27, 0x53028762, 0x40a01f15, 0x7447b78c, 0x67e52ffb,
        0xbf59d487, 0xacfb4cf0, 0x981ce469, 0x8bbe7c1e, 0xf1d3b55b, 0xe2712d2c, 0xd69685b5, 0xc5341dc2,
        0x224d173f, 0x31ef8f48, 0x050827d1, 0x16aabfa6, 0x6cc776e3, 0x7f65ee94, 0x4b82460d, 0x5820de7a,
        0xfbc3faf9, 0xe861628e, 0xdc86ca17, 0xcf245260, 0xb5499b25, 0xa6eb0352, 0x920cabcb, 0x81ae33bc,
        0x66d73941, 0x7575a136, 0x419209af, 0x523091d8, 0x285d589d, 0x3bffc0ea, 0x0f186873, 0x1cbaf004,
        0xc4060b78, 0xd7a4930f, 0xe3433b96, 0xf0e1a3e1, 0x8a8c6aa4, 0x992ef2d3, 0xadc95a4a, 0xbe6bc23d,
        0x5912c8c0, 0x4ab050b7, 0x7e57f82e, 0x6df56059, 0x1798a91c, 0x043a316b, 0x30dd99f2, 0x237f0185,
        0x844819fb, 0x97ea818c, 0xa30d2915, 0xb0afb162, 0xcac27827, 0xd960e050, 0xed8748c9, 0xfe25d0be,
        0x195cda43, 0x0afe4234, 0x3e19eaad, 0x2dbb72da, 0x57d6bb9f, 0x447423e8, 0x70938b71, 0x63311306,
        0xbb8de87a, 0xa82f700d, 0x9cc8d894, 0x8f6a40e3, 0xf50789a6, 0xe6a511d1, 0xd242b948, 0xc1e0213f,
        0x26992bc2, 0x353bb3b5, 0x01dc1b2c, 0x127e835b, 0x68134a1e, 0x7bb1d269, 0x4f567af0, 0x5cf4e287,
        0x04d43cfd, 0x1776a48a, 0x23910c13, 0x30339464, 0x4a5e5d21, 0x59fcc556, 0x6d1b6dcf, 0x7eb9f5b8,
        0x99c0ff45, 0x8a626732, 0xbe85cfab, 0xad2757dc, 0xd74a9e99, 0xc4e806ee, 0xf00fae77, 0xe3ad3600,
        0x3b11cd7c, 0x28b3550b, 0x1c54fd92, 0x0ff665e5, 0x759baca0, 0x663934d7, 0x52de9c4e, 0x417c0439,
        0xa6050ec4, 0xb5a796b3, 0x81403e2a, 0x92e2a65d, 0xe88f6f18, 0xfb2df76f, 0xcfca5ff6, 0xdc68c781,
        0x7b5fdfff, 0x68fd4788, 0x5c1aef11, 0x4fb87766, 0x35d5be23, 0x26772654, 0x12908ecd, 0x013216ba,
        0xe64b1c47, 0xf5e98430, 0xc10e2ca9, 0xd2acb4de, 0xa8c17d9b, 0xbb63e5ec, 0x8f844d75, 0x9c26d502,
        0x449a2e7e, 0x5738b609, 0x63df1e90, 0x707d86e7, 0x0a104fa2, 0x19b2d7d5, 0x2d557f4c, 0x3ef7e73b,
        0xd98eedc6, 0xca2c75b1, 0xfecbdd28, 0xed69455f, 0x97048c1a, 0x84a6146d, 0xb041bcf4, 0xa3e32483
    },
    {
        0x00000000, 0xa541927e, 0x4f6f520d, 0xea2ec073, 0x9edea41a, 0x3b9f3664, 0xd1b1f617, 0x74f06469,
        0x38513ec5, 0x9d10acbb, 0x773e6cc8, 0xd27ffeb6, 0xa68f9adf, 0x03ce08a1, 0xe9e0c8d2, 0x4ca15aac,
        0x70a27d8a, 0xd5e3eff4, 0x3fcd2f87, 0x9a8cbdf9, 0xee7cd990, 0x4b3d4bee, 0xa1138b9d, 0x045219e3,
        0x48f3434f, 0xedb2d131, 0x079c1142, 0xa2dd833c, 0xd62de755, 0x736c752b, 0x9942b558, 0x3c032726,
        0xe144fb14, 0x4405696a, 0xae2ba919, 0x0b6a3b67, 0x7f9a5f0e, 0xdadbcd70, 0x30f50d03, 0x95b49f7d,
        0xd915c5d1, 0x7c5457af, 0x967a97dc, 0x333b05a2, 0x47cb61cb, 0xe28af3b5, 0x08a433c6, 0xade5a1b8,
        0x91e6869e, 0x34a714e0, 0xde89d493, 0x7bc846ed, 0x0f382284, 0xaa79b0fa, 0x40577089, 0xe516e2f7,
        0xa9b7b85b, 0x0cf62a25, 0xe6d8ea56, 0x43997828, 0x37691c41, 0x92288e3f, 0x78064e4c, 0xdd47dc32,
        0xc76580d9, 0x622412a7, 0x880ad2d4, 0x2d4b40aa, 0x59bb24c3, 0xfcfab6bd, 0x16d476ce, 0xb395e4b0,
        0xff34be1c, 0x5a752c62, 0xb05bec11, 0x151a7e6f, 0x61ea1a06, 0xc4ab8878, 0x2e85480b, 0x8bc4da75,
        0xb7c7fd53, 0x12866f2d, 0xf8a8af5e, 0x5de93d20, 0x29195949, 0x8c58cb37, 0x66760b44, 0xc337993a,
        0x8f96c396, 0x2ad751e8, 0xc0f9919b, 0x65b803e5, 0x1148678c, 0xb409f5f2, 0x5e273581, 0xfb66a7ff,
        0x26217bcd, 0x8360e9b3, 0x694e29c0, 0xcc0fbbbe, 0xb8ffdfd7, 0x1dbe4da9, 0xf7908dda, 0x52d11fa4,
        0x1e704508, 0xbb31d776, 0x511f1705, 0xf45e857b, 0x80aee112, 0x25ef736c, 0xcfc1b31f, 0x6a802161,
        0x56830647, 0xf3c29439, 0x19ec544a, 0xbcadc634, 0xc85da25d, 0x6d1c3023, 0x8732f050, 0x2273622e,
        0x6ed23882, 0xcb93aafc, 0x21bd6a8f, 0x84fcf8f1, 0xf00c9c98, 0x554d0ee6, 0xbf63ce95, 0x1a225ceb,
        0x8b277743, 0x2e66e53d, 0xc448254e, 0x6109b730, 0x15f9d359, 0xb0b84127, 0x5a968154, 0xffd7132a,
        0xb3764986, 0x1637dbf8, 0xfc191b8b, 0x595889f5, 0x2da8ed9c, 0x88e97fe2, 0x62c7bf91, 0xc7862def,
        0xfb850ac9, 0x5ec498b7, 0xb4ea58c4, 0x11abcaba, 0x655baed3, 0xc01a3cad, 0x2a34fcde, 0x8f756ea0,
        0xc3d4340c, 0x6695a672, 0x8cbb6601, 0x29faf47f, 0x5d0a9016, 0xf84b0268, 0x1265c21b, 0xb7245065,
        0x6a638c57, 0xcf221e29, 0x250cde5a, 0x804d4c24, 0xf4bd284d, 0x51fcba33, 0xbbd27a40, 0x1e93e83e,
        0x5232b292, 0xf77320ec, 0x1d5de09f, 0xb81c72e1, 0xccec1688, 0x69ad84f6, 0x83834485, 0x26c2d6fb,
        0x1ac1f1dd, 0xbf8063a3, 0x55aea3d0, 0xf0ef31ae, 0x841f55c7, 0x215ec7b9, 0xcb7007ca, 0x6e3195b4,
        0x2290cf18, 0x87d15d66, 0x6dff9d15, 0xc8be0f6b, 0xbc4e6b02, 0x190ff97c, 0xf321390f, 0x5660ab71,
        0x4c42f79a, 0xe90365e4, 0x032da597, 0xa66c37e9, 0xd29c5380, 0x77ddc1fe, 0x9df3018d, 0x38b293f3,
        0x7413c95f, 0xd1525b21, 0x3b7c9b52, 0x9e3d092c, 0xeacd6d45, 0x4f8cff3b, 0xa5a23f48, 0x00e3ad36,
        0x3ce08a10, 0x99a1186e, 0x738fd81d, 0xd6ce4a63, 0xa23e2e0a, 0x077fbc74, 0xed517c07, 0x4810ee79,
        0x04b1b4d5, 0xa1f026ab, 0x4bdee6d8, 0xee9f74a6, 0x9a6f10cf, 0x3f2e82b1, 0xd50042c2, 0x7041d0bc,
        0xad060c8e, 0x08479ef0, 0xe2695e83, 0x4728ccfd, 0x33d8a894, 0x96993aea, 0x7cb7fa99, 0xd9f668e7,
        0x9557324b, 0x3016a035, 0xda386046, 0x7f79f238, 0x0b899651, 0xaec8042f, 0x44e6c45c, 0xe1a75622,
        0xdda47104, 0x78e5e37a, 0x92cb2309, 0x378ab177, 0x437ad51e, 0xe63b4760, 0x0c158713, 0xa954156d,
        0xe5f54fc1, 0x40b4ddbf, 0xaa9a1dcc, 0x0fdb8fb2, 0x7b2bebdb, 0xde6a79a5, 0x3444b9d6, 0x91052ba8
    },
    {
        0x00000000, 0xdd45aab8, 0xbf672381, 0x62228939, 0x7b2231f3, 0xa6679b4b, 0xc4451272, 0x1900b8ca,
        0xf64463e6, 0x2b01c95e, 0x49234067, 0x9466eadf, 0x8d665215, 0x5023f8ad, 0x32017194, 0xef44db2c,
        0xe964b13d, 0x34211b85, 0x560392bc, 0x8b463804, 0x924680ce, 0x4f032a76, 0x2d21a34f, 0xf06409f7,
        0x1f20d2db, 0xc2657863, 0xa047f15a, 0x7d025be2, 0x6402e328, 0xb9474990, 0xdb65c0a9, 0x06206a11,
        0xd725148b, 0x0a60be33, 0x6842370a, 0xb5079db2, 0xac072578, 0x71428fc0, 0x136006f9, 0xce25ac41,
        0x2161776d, 0xfc24ddd5, 0x9e0654ec, 0x4343fe54, 0x5a43469e, 0x8706ec26, 0xe524651f, 0x3861cfa7,
        0x3e41a5b6, 0xe3040f0e, 0x81268637, 0x5c632c8f, 0x45639445, 0x98263efd, 0xfa04b7c4, 0x27411d7c,
        0xc805c650, 0x15406ce8, 0x7762e5d1, 0xaa274f69, 0xb327f7a3, 0x6e625d1b, 0x0c40d422, 0xd1057e9a,
        0xaba65fe7, 0x76e3f55f, 0x14c17c66, 0xc984d6de, 0xd0846e14, 0x0dc1c4ac, 0x6fe34d95, 0xb2a6e72d,
        0x5de23c01, 0x80a796b9, 0xe2851f80, 0x3fc0b538, 0x26c00df2, 0xfb85a74a, 0x99a72e73, 0x44e284cb,
        0x42c2eeda, 0x9f874462, 0xfda5cd5b, 0x20e067e3, 0x39e0df29, 0xe4a57591, 0x8687fca8, 0x5bc25610,
        0xb4868d3c, 0x69c32784, 0x0be1aebd, 0xd6a40405, 0xcfa4bccf, 0x12e11677, 0x70c39f4e, 0xad8635f6,
        0x7c834b6c, 0xa1c6e1d4, 0xc3e468ed, 0x1ea1c255, 0x07a17a9f, 0xdae4d027, 0xb8c6591e, 0x6583f3a6,
        0x8ac7288a, 0x57828232, 0x35a00b0b, 0xe8e5a1b3, 0xf1e51979, 0x2ca0b3c1, 0x4e823af8, 0x93c79040,
        0x95e7fa51, 0x48a250e9, 0x2a80d9d0, 0xf7c57368, 0xeec5cba2, 0x3380611a, 0x51a2e823, 0x8ce7429b,
        0x63a399b7, 0xbee6330f, 0xdcc4ba36, 0x0181108e, 0x1881a844, 0xc5c402fc, 0xa7e68bc5, 0x7aa3217d,
        0x52a0c93f, 0x8fe56387, 0xedc7eabe, 0x30824006, 0x2982f8cc, 0xf4c75274, 0x96e5db4d, 0x4ba071f5,
        0xa4e4aad9, 0x79a10061, 0x1b838958, 0xc6c623e0, 0xdfc69b2a, 0x02833192, 0x60a1b8ab, 0xbde41213,
        0xbbc47802, 0x6681d2ba, 0x04a35b83, 0xd9e6f13b, 0xc0e649f1, 0x1da3e349, 0x7f816a70, 0xa2c4c0c8,
        0x4d801be4, 0x90c5b15c, 0xf2e73865, 0x2fa292dd, 0x36a22a17, 0xebe780af, 0x89c50996, 0x5480a32e,
        0x8585ddb4, 0x58c0770c, 0x3ae2fe35, 0xe7a7548d, 0xfea7ec47, 0x23e246ff, 0x41c0cfc6, 0x9c85657e,
        0x73c1be52, 0xae8414ea, 0xcca69dd3, 0x11e3376b, 0x08e38fa1, 0xd5a62519, 0xb784ac20, 0x6ac10698,
        0x6ce16c89, 0xb1a4c631, 0xd3864f08, 0x0ec3e5b0, 0x17c35d7a, 0xca86f7c2, 0xa8a47efb, 0x75e1d443,
        0x9aa50f6f, 0x47e0a5d7, 0x25c22cee, 0xf8878656, 0xe1873e9c, 0x3cc29424, 0x5ee01d1d, 0x83a5b7a5,
        0xf90696d8, 0x24433c60, 0x4661b559, 0x9b241fe1, 0x8224a72b, 0x5f610d93, 0x3d4384aa, 0xe0062e12,
        0x0f42f53e, 0xd2075f86, 0xb025d6bf, 0x6d607c07, 0x7460c4cd, 0xa9256e75, 0xcb07e74c, 0x16424df4,
        0x106227e5, 0xcd278d5d, 0xaf050464, 0x7240aedc, 0x6b401616, 0xb605bcae, 0xd4273597, 0x09629f2f,
        0xe6264403, 0x3b63eebb, 0x59416782, 0x8404cd3a, 0x9d0475f0, 0x4041df48, 0x22635671, 0xff26fcc9,
        0x2e238253, 0xf36628eb, 0x9144a1d2, 0x4c010b6a, 0x5501b3a0, 0x88441918, 0xea669021, 0x37233a99,
        0xd867e1b5, 0x05224b0d, 0x6700c234, 0xba45688c, 0xa345d046, 0x7e007afe, 0x1c22f3c7, 0xc167597f,
        0xc747336e, 0x1a0299d6, 0x782010ef, 0xa565ba57, 0xbc65029d, 0x6120a825, 0x0302211c, 0xde478ba4,
        0x31035088, 0xec46fa30, 0x8e647309, 0x5321d9b1, 0x4a21617b, 0x9764cbc3, 0xf54642fa, 0x2803e842
    },
};

#if BYTE_ORDER != LITTLE_ENDIAN
/* swap endianness */
static uint32_t swap(uint32_t x)
{
#if defined(__GNUC__) || defined(__clang__)
    return __builtin_bswap32(x);
#else
    return (x >> 24) |
            ((x >>  8) & 0x0000FF00) |
            ((x <<  8) & 0x00FF0000) |
            (x << 24);
#endif
}
#endif

static uint32_t crc32c_sw(uint32_t crc, const void *buf, size_t len) {
    const uint32_t *cur = (const uint32_t *) buf;
    const uint8_t *curc;
    uint32_t crc0, crc1;

    crc0 = crc ^ 0xffffffff;

    /* process four bytes at once (slicing-by-4) */
    while (len >= 4) {
#if BYTE_ORDER == LITTLE_ENDIAN
        crc1 = *cur++ ^ crc0;
        crc0 = crc32c_lookup[0][(crc1>>24) & 0xff] ^
               crc32c_lookup[1][(crc1>>16) & 0xff] ^
               crc32c_lookup[2][(crc1>> 8) & 0xff] ^
               crc32c_lookup[3][ crc1      & 0xff];
#else
        crc1 = *cur++ ^ swap(crc0);
        crc0 = crc32c_lookup[0][ crc1     & 0xff] ^
               crc32c_lookup[1][(crc1>> 8) & 0xff] ^
               crc32c_lookup[2][(crc1>>16) & 0xff] ^
               crc32c_lookup[3][(crc1>>24) & 0xff];
#endif

        len -= 4;
    }

    curc = (const uint8_t *) cur;
    /* remaining 1 to 3 bytes (standard algorithm) */
    while (len-- != 0)
        crc0 = (crc0 >> 8) ^ crc32c_lookup[0][(crc0 & 0xFF) ^ *curc++];

    return crc0 ^ 0xffffffff;
}


/* Check for SSE 4.2.  SSE 4.2 was first supported in Nehalem processors
   introduced in November, 2008.  This does not check for the existence of the
   cpuid instruction itself, which was introduced on the 486SL in 1992, so this
   will fail on earlier x86 processors.  cpuid works on all Pentium and later
   processors. */
#define SSE42(have) \
    do { \
        uint32_t eax, ecx; \
        eax = 1; \
        __asm__("cpuid" \
                : "=c"(ecx) \
                : "a"(eax) \
                : "%ebx", "%edx"); \
        (have) = (ecx >> 20) & 1; \
    } while (0)

#ifdef HAVE_SSE42
static int have_sse42 = 0;
#endif

EXPORTED void crc32c_init()
{
#ifdef HAVE_SSE42
    SSE42(have_sse42);
#endif
}

static uint32_t crc32c(uint32_t crc, const void *buf, size_t len) {
#ifdef HAVE_SSE42
    return have_sse42
        ? crc32c_hw(crc, buf, len)
        : crc32c_sw(crc, buf, len);
#else
    return crc32c_sw(crc, buf, len);
#endif
}

EXPORTED uint32_t crc32c_map(const char *base, unsigned len)
{
    return crc32c(0, (const void *) base, (size_t) len);
}

EXPORTED uint32_t crc32c_iovec(struct iovec *iov, int iovcnt)
{
    int n;
    uint32_t crc = crc32c(0, 0, 0);
    for (n = 0; n < iovcnt; n++) {
        if (iov[n].iov_len)
            crc = crc32c(crc, (const char *) iov[n].iov_base, iov[n].iov_len);
    }
    return crc;
}

EXPORTED uint32_t crc32c_buf(const struct buf *buf)
{
    return crc32c_map(buf->s, buf->len);
}

EXPORTED uint32_t crc32c_cstring(const char *buf)
{
    return crc32c_map(buf, strlen(buf));
}
