/*
 * This file is part of the UVES Pipeline
 * Copyright (C) 2002, 2003, 2004, 2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2011-12-08 13:55:51 $
 * $Revision: 1.148 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.147  2010/11/26 07:41:34  amodigli
 * added uves_scired_wmap_filename()
 *
 * Revision 1.146  2010/09/24 09:32:03  amodigli
 * put back QFITS dependency to fix problem spot by NRI on FIBER mode (with MIDAS calibs) data
 *
 * Revision 1.144  2010/06/07 17:41:49  amodigli
 * added uves_scired_fluxcal_science_noappend_filename(),uves_scired_fluxcal_error_noappend_filename()
 *
 * Revision 1.143  2010/06/07 13:24:20  amodigli
 * Fixed typo in PRO.CATG and PIPEFILE of products in case of merging option is noappend: NOAPPEND-->NONMERGED
 *
 * Revision 1.142  2010/06/07 11:12:02  amodigli
 * added uves_scired_red_noappend_error_filename()
 *
 * Revision 1.141  2010/06/04 09:50:10  amodigli
 * added UVES_RED_NOAPPEND_STD, uves_response_red_noappend_standard_filename() uves_scired_red_noappend_science_filename()
 *
 * Revision 1.140  2010/05/19 13:28:51  amodigli
 * rename uves_extraction_quality_standard_filename->uves_order_extract_qc_standard_filename, UVES_EXTRACTION_QUALITY->UVES_ORDER_EXTRACT_QC
 *
 * Revision 1.139  2010/05/18 17:09:24  amodigli
 * added UVES_EXTRACTION_QUALITY and uves_extraction_quality_standard_filename
 *
 * Revision 1.138  2009/02/20 18:21:12  amodigli
 * added RAW_IMA
 *
 * Revision 1.137  2009/01/02 08:30:03  amodigli
 * added uves_contains_frames_kind
 *
 * Revision 1.136  2008/08/29 09:52:26  amodigli
 * fixed compiler warning
 *
 * Revision 1.135  2008/06/26 08:25:55  amodigli
 * added uves_local_filename
 *
 * Revision 1.134  2007/11/26 15:26:59  amodigli
 * added FLAMES_INFO_TABLE
 *
 * Revision 1.133  2007/11/19 08:07:06  amodigli
 * cleaned
 *
 * Revision 1.132  2007/11/13 16:20:59  amodigli
 * added UVES_ORD_TAB to remove name clashes between order tables from FIBER and ECHELLE mode
 *
 * Revision 1.131  2007/10/30 17:45:03  jmlarsen
 * Added WEIGHTS_<chip> images to support object weighted arclamp extraction
 *
 * Revision 1.130  2007/10/17 14:58:48  amodigli
 * added uves_check_if_format_is_midas
 *
 * Revision 1.129  2007/09/19 11:09:49  amodigli
 * Now FLAMES_FIB_FF_DT is a macro
 *
 * Revision 1.128  2007/09/11 17:08:07  amodigli
 * added uves_polynomial_convert_from_plist_midas from uves_utils_polynomial.h
 *
 * Revision 1.127  2007/09/06 14:14:38  amodigli
 * added uves_scired_ff_variance_2d_filename
 *
 * Revision 1.126  2007/08/16 13:21:15  amodigli
 * added uves_scired_red_2d_error_filename
 *
 * Revision 1.125  2007/08/16 06:49:47  amodigli
 * added uves_vector_to_image
 *
 * Revision 1.124  2007/08/10 12:10:35  amodigli
 * changed 2d extraction product file names as by DFS04196
 *
 * Revision 1.123  2007/08/02 15:18:10  amodigli
 * added possibility of FLAMES_SLIT_FF_BN4
 *
 * Revision 1.122  2007/07/23 06:30:50  amodigli
 * added FLAMES_FIB_FF_DT
 *
 * Revision 1.121  2007/07/03 12:39:13  amodigli
 * added FLAMES_CORVEL_MASK FLAMES_SCI_SIM_RED
 *
 * Revision 1.120  2007/06/26 13:34:43  jmlarsen
 * Exported function for FLAMES
 *
 * Revision 1.119  2007/06/25 07:16:55  jmlarsen
 * Fixed definition of FLAMES_FIB_FF_BP
 *
 * Revision 1.118  2007/06/25 05:54:45  amodigli
 * added FIB_LINE_TABLE_MIDAS
 *
 * Revision 1.117  2007/06/22 16:04:01  jmlarsen
 * Fixed one FLAMES tag
 *
 * Revision 1.116  2007/06/22 15:49:27  jmlarsen
 * Fixed FLAMES product tags
 *
 * Revision 1.115  2007/06/22 14:50:45  jmlarsen
 * Optionally save height=1 images as NAXIS=1
 *
 * Revision 1.114  2007/06/22 09:30:10  jmlarsen
 * Allow saving CPL_TYPE_INT images as 16 or 32 bit FITS
 *
 * Revision 1.113  2007/06/21 15:12:57  amodigli
 * added FLAMES sci product types
 *
 * Revision 1.112  2007/06/06 08:17:33  amodigli
 * replace tab with 4 spaces
 *
 * Revision 1.111  2007/05/16 11:47:18  amodigli
 * added FLAMES_SCI_COM_RED
 *
 * Revision 1.110  2007/05/03 15:19:12  jmlarsen
 * Added const version of uves_load_linetable()
 *
 * Revision 1.109  2007/04/26 13:19:13  jmlarsen
 * Exported function copy_if_possible
 *
 * Revision 1.108  2007/04/24 16:44:26  amodigli
 * changed interface uves_load_ordertable to return also extention table
 *
 * Revision 1.107  2007/04/24 12:50:29  jmlarsen
 * Replaced cpl_propertylist -> uves_propertylist which is much faster
 *
 * Revision 1.106  2007/04/23 06:59:29  amodigli
 * added uves_save_imagelist
 *
 * Revision 1.105  2007/04/03 06:28:26  amodigli
 * uves_load_ordertable provides now fibre_mask and fibre_pos if appropriate
 *
 * Revision 1.104  2007/03/20 15:39:54  amodigli
 * added FLAMES tags
 *
 * Revision 1.103  2007/03/15 15:04:37  jmlarsen
 * Allow spaces in HISTORY keyword string values
 *
 * Revision 1.102  2007/02/09 13:36:06  jmlarsen
 * Added function to load ref_flat
 *
 * Revision 1.101  2007/02/08 07:33:17  jmlarsen
 * Added uves_load_cd_align()
 *
 * Revision 1.100  2007/01/17 13:25:41  jmlarsen
 * Added uves_load_image()
 *
 * Revision 1.99  2007/01/10 12:37:18  jmlarsen
 * Exported function to warn about mismatching calibration frames
 *
 * Revision 1.98  2007/01/09 17:45:42  amodigli
 * added uves_check_rec_status
 *
 * Revision 1.97  2006/12/12 12:09:12  jmlarsen
 * Added function to load corvel table
 *
 * Revision 1.96  2006/12/07 08:23:02  jmlarsen
 * uves_load_raw_imagelist: support FLAMES
 *
 * Revision 1.95  2006/12/01 08:26:58  jmlarsen
 * Load FLAMES order table oshift/yshift
 *
 * Revision 1.94  2006/11/24 16:21:32  jmlarsen
 * Added FIB_LINE_TABLE_x
 *
 * Revision 1.93  2006/11/22 08:41:12  jmlarsen
 * Exported and fixed bug in uves_read_midas_array
 *
 * Revision 1.91  2006/11/22 08:22:29  jmlarsen
 * Set message level according to preprocessor symbol
 *
 * Revision 1.90  2006/11/16 14:09:27  jmlarsen
 * Fixed definition of FLAMES order table tag
 *
 * Revision 1.89  2006/11/15 15:02:14  jmlarsen
 * Implemented const safe workarounds for CPL functions
 *
 * Revision 1.87  2006/11/15 14:04:08  jmlarsen
 * Removed non-const version of parameterlist_get_first/last/next which is already
 * in CPL, added const-safe wrapper, unwrapper and deallocator functions
 *
 * Revision 1.86  2006/11/13 12:44:31  jmlarsen
 * Support FLAMES FIB_ARC_LAMP_RED frames
 *
 * Revision 1.85  2006/11/07 14:01:12  jmlarsen
 * Moved flames_load_ functions to separate source file
 *
 * Revision 1.84  2006/11/03 15:01:21  jmlarsen
 * Killed UVES 3d table module and use CPL 3d tables
 *
 * Revision 1.83  2006/10/24 14:05:25  jmlarsen
 * Generalized load functions to support FLAMES
 *
 * Revision 1.82  2006/10/19 13:53:25  jmlarsen
 * Changed guess line table tag to LINE_GUESS_TAB
 *
 * Revision 1.81  2006/10/12 11:37:28  jmlarsen
 * Temporarily disabled FLAMES code generation
 *
 * Revision 1.80  2006/10/02 08:34:06  jmlarsen
 * Added REF_TFLAT
 *
 * Revision 1.79  2006/09/27 13:13:24  jmlarsen
 * Use dynamic memory allocation to store bad pixels
 *
 * Revision 1.78  2006/09/20 15:42:18  jmlarsen
 * Implemented MASTER_RESPONSE support
 *
 * Revision 1.77  2006/09/20 10:57:19  jmlarsen
 * Fixed typo
 *
 * Revision 1.76  2006/09/20 07:26:54  jmlarsen
 * Shortened max line length
 *
 * Revision 1.75  2006/09/19 14:25:32  jmlarsen
 * Propagate FITS keywords from master flat, not science, to WCALIB_FLAT_OBJ
 *
 * Revision 1.74  2006/09/19 07:12:58  jmlarsen
 * Exported function uves_write_statistics
 *
 * Revision 1.73  2006/09/14 08:46:51  jmlarsen
 * Added support for TFLAT, SCREEN_FLAT frames
 *
 * Revision 1.72  2006/09/11 08:19:10  jmlarsen
 * Renamed identifier reserved by POSIX
 *
 * Revision 1.71  2006/08/24 11:36:58  jmlarsen
 * Write recipe start/stop time to header
 *
 * Revision 1.70  2006/08/17 13:56:52  jmlarsen
 * Reduced max line length
 *
 * Revision 1.69  2006/08/11 08:59:41  jmlarsen
 * Take into account the different meanings of line table 'Y' column
 *
 * Revision 1.68  2006/08/07 14:42:02  jmlarsen
 * Implemented on-the-fly correction of a line table when its order
 * numbering is inconsistent with the order table (DFS02694)
 *
 * Revision 1.67  2006/08/07 12:14:19  jmlarsen
 * Removed unused function
 *
 * Revision 1.66  2006/08/01 14:43:36  amodigli
 * fixed bug loading fitsheader in uves_load_masterformatcheck
 *
 * Revision 1.65  2006/07/31 06:29:05  amodigli
 * added flames_load_frame_index
 *
 * Revision 1.64  2006/07/14 12:20:10  jmlarsen
 * Added LINE_INTMON_TABLE
 *
 * Revision 1.63  2006/06/26 07:54:15  amodigli
 * flames_load_image flames_load_table
 *
 * Revision 1.62  2006/06/23 15:31:32  amodigli
 * added useful stuff for flames
 *
 * Revision 1.61  2006/06/22 15:25:35  amodigli
 * changes for flames_cal_prep_sff_ofpos
 *
 * Revision 1.60  2006/06/19 06:51:14  amodigli
 * added support flames-old format
 *
 * Revision 1.59  2006/06/16 08:22:01  jmlarsen
 * Manually propagate ESO.DET. keywords from 1st/2nd input header
 *
 * Revision 1.58  2006/06/13 11:55:06  jmlarsen
 * Shortened max line length
 *
 * Revision 1.57  2006/06/06 09:04:14  jmlarsen
 * Bugfix: UVES_CHIP_REDU -> UVES_CHIP_REDL
 *
 * Revision 1.56  2006/06/06 08:40:10  jmlarsen
 * Shortened max line length
 *
 * Revision 1.55  2006/05/22 06:47:15  amodigli
 * fixed some bugs on msflat
 *
 * Revision 1.54  2006/05/19 13:07:52  amodigli
 * modified to support SFLATs
 *
 * Revision 1.53  2006/05/17 09:54:55  amodigli
 * added supposr SFLATs
 *
 * Revision 1.52  2006/05/15 06:09:52  amodigli
 * added support for some FLAMES input frames
 *
 * Revision 1.51  2006/04/25 14:58:48  amodigli
 * added paf creation functionalities
 *
 * Revision 1.50  2006/04/24 09:19:01  jmlarsen
 * Simplified code
 *
 * Revision 1.49  2006/04/06 13:13:04  jmlarsen
 * Added const modifier
 *
 * Revision 1.48  2006/04/06 12:56:50  jmlarsen
 * Added support for PDARK, IFLAT, DLFAT frames
 *
 * Revision 1.47  2006/04/06 11:48:17  jmlarsen
 * Support for SCI_POINT_-, SCI_EXTND_- and SCI_SLICER-frames
 *
 * Revision 1.46  2006/04/06 09:48:15  amodigli
 * changed uves_frameset_insert interface to have QC log
 *
 * Revision 1.45  2006/04/06 08:31:15  jmlarsen
 * Added support for reading MASTER_DFLAT, MASTER_IFLAT, MASTER_PDARK
 *
 * Revision 1.44  2006/03/24 14:19:19  jmlarsen
 * Recognize background tables
 *
 * Revision 1.43  2006/03/06 09:22:43  jmlarsen
 * Added support for reading MIDAS line tables with MIDAS tags
 *
 * Revision 1.42  2006/02/15 13:19:15  jmlarsen
 * Reduced source code max. line length
 *
 * Revision 1.41  2006/01/09 15:22:55  jmlarsen
 * Removed some warnings
 *
 * Revision 1.40  2006/01/03 16:56:53  amodigli
 * Added MASTER_ARC_FORM
 *
 * Revision 1.39  2005/12/19 16:17:56  jmlarsen
 * Replaced bool -> int
 *
 */

#ifndef UVES_DFS_H
#define UVES_DFS_H

/*-----------------------------------------------------------------------------
                                Includes
  -----------------------------------------------------------------------------*/
#include <uves_cpl_size.h>
#include <uves_propertylist.h>
#include <uves_utils_polynomial.h>
#include <uves_chip.h>
#include <uves_utils.h>
#include <cpl.h>

#include <stdbool.h>
#include <math.h>
/*-----------------------------------------------------------------------------
                Defines
 -----------------------------------------------------------------------------*/
/* FLAMES */
/*
 * reduce
 */
#define RAW_IMA       "RAW_IMA"
#define FLAMES_SCI_RED       "FIB_SCI_RED"
#define FLAMES_SCI_SIM_RED   "FIB_SCI_SIM_RED"
#define FLAMES_SCI_COM_RED   "FIB_SCI_COM_RED"
#define FLAMES_CORVEL_MASK   "CORVEL_MASK"

#define FLAMES_INFO_TABLE(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_SCI_INFO_TAB_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_SCI_INFO_TAB_REDU" : "???")

#define FLAMES_LINE_TABLE(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_LINE_TABLE_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_LINE_TABLE_REDU" : "???")

#define FLAMES_LINE_TABLE_MIDAS(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_LINE_TABLE_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_LINE_TABLE_REDU" : "???")

#define FLAMES_SLIT_FF_DT1(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_DT1_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_DT1_REDU" : "???")

#define FLAMES_SLIT_FF_DT2(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_DT2_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_DT2_REDU" : "???")

#define FLAMES_SLIT_FF_DT3(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_DT3_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_DT3_REDU" : "???")

#define FLAMES_SLIT_FF_DTC(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_DTC_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_DTC_REDU" : "???")

#define FLAMES_SLIT_FF_DT(it, chip) ((it) == 1 ? FLAMES_SLIT_FF_DT1(chip) : \
                                     (it) == 2 ? FLAMES_SLIT_FF_DT2(chip) : \
                                     (it) == 3 ? FLAMES_SLIT_FF_DT3(chip) : "???")

#define FLAMES_SLIT_FF_BP1(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BP1_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BP1_REDU" : "???")

#define FLAMES_SLIT_FF_BP2(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BP2_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BP2_REDU" : "???")

#define FLAMES_SLIT_FF_BP3(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BP3_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BP3_REDU" : "???")

#define FLAMES_SLIT_FF_BPC(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BPC_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BPC_REDU" : "???")

#define FLAMES_SLIT_FF_BP(it, chip) ((it) == 1 ? FLAMES_SLIT_FF_BP1(chip) : \
                                     (it) == 2 ? FLAMES_SLIT_FF_BP2(chip) : \
                                     (it) == 3 ? FLAMES_SLIT_FF_BP3(chip) : "???")


#define FLAMES_SLIT_FF_BN1(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BN1_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BN1_REDU" : "???")

#define FLAMES_SLIT_FF_BN2(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BN2_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BN2_REDU" : "???")

#define FLAMES_SLIT_FF_BN3(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BN3_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BN3_REDU" : "???")

#define FLAMES_SLIT_FF_BN4(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BN4_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BN4_REDU" : "???")

#define FLAMES_SLIT_FF_BNC(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_BNC_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_BNC_REDU" : "???")

#define FLAMES_SLIT_FF_BN(it, chip) ((it) == 1 ? FLAMES_SLIT_FF_BN1(chip) : \
                                     (it) == 2 ? FLAMES_SLIT_FF_BN2(chip) : \
                                     (it) == 3 ? FLAMES_SLIT_FF_BN3(chip) : \
                                     (it) == 4 ? FLAMES_SLIT_FF_BN4(chip) : "???")


#define FLAMES_SLIT_FF_SG1(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_SG1_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_SG1_REDU" : "???")

#define FLAMES_SLIT_FF_SG2(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_SG2_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_SG2_REDU" : "???")

#define FLAMES_SLIT_FF_SG3(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_SG3_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_SG3_REDU" : "???")

#define FLAMES_SLIT_FF_SGC(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_SGC_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_SGC_REDU" : "???")


#define FLAMES_SLIT_FF_SG(it, chip) ((it) == 1 ? FLAMES_SLIT_FF_SG1(chip) : \
                                     (it) == 2 ? FLAMES_SLIT_FF_SG2(chip) : \
                                     (it) == 3 ? FLAMES_SLIT_FF_SG3(chip) : "???")

#define FLAMES_SLIT_FF_COM(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_COM_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_COM_REDU" : "???")

#define FLAMES_SLIT_FF_NOR(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_NOR_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_NOR_REDU" : "???")

#define FLAMES_SLIT_FF_NSG(chip)  ((chip) == UVES_CHIP_REDL ? "SLIT_FF_NSG_REDL" : \
                       (chip) == UVES_CHIP_REDU ? "SLIT_FF_NSG_REDU" : "???")



#define FLAMES_FIB_FF_DT1(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_DT1_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_DT1_REDU" : "???")

#define FLAMES_FIB_FF_DT2(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_DT2_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_DT2_REDU" : "???")

#define FLAMES_FIB_FF_DT3(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_DT3_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_DT3_REDU" : "???")

#define FLAMES_FIB_FF_DTC(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_DTC_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_DTC_REDU" : "???")


#define FLAMES_FIB_FF_DT(it, chip) ((it) == 1 ? FLAMES_FIB_FF_DT1(chip) : \
                                     (it) == 2 ? FLAMES_FIB_FF_DT2(chip) : \
                                     (it) == 3 ? FLAMES_FIB_FF_DT3(chip) : "???")



#define FLAMES_FIB_FF_BP1(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BP1_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BP1_REDU" : "???")

#define FLAMES_FIB_FF_BP2(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BP2_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BP2_REDU" : "???")

#define FLAMES_FIB_FF_BP3(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BP3_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BP3_REDU" : "???")

#define FLAMES_FIB_FF_BPC(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BPC_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BPC_REDU" : "???")

#define FLAMES_FIB_FF_BP(it, chip) ((it) == 1 ? FLAMES_FIB_FF_BP1(chip) : \
                                     (it) == 2 ? FLAMES_FIB_FF_BP2(chip) : \
                                     (it) == 3 ? FLAMES_FIB_FF_BP3(chip) : "???")



#define FLAMES_FIB_FF_BN1(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BN1_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BN1_REDU" : "???")

#define FLAMES_FIB_FF_BN2(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BN2_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BN2_REDU" : "???")

#define FLAMES_FIB_FF_BN3(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BN3_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BN3_REDU" : "???")
#define FLAMES_FIB_FF_BNC(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_BNC_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_BNC_REDU" : "???")


#define FLAMES_FIB_FF_SG1(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_SG1_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_SG1_REDU" : "???")

#define FLAMES_FIB_FF_SG2(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_SG2_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_SG2_REDU" : "???")

#define FLAMES_FIB_FF_SG3(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_SG3_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_SG3_REDU" : "???")

#define FLAMES_FIB_FF_SGC(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_SGC_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_SGC_REDU" : "???")

#define FLAMES_FIB_FF_SG(it, chip) ((it) == 1 ? FLAMES_FIB_FF_SG1(chip) : \
                                     (it) == 2 ? FLAMES_FIB_FF_SG2(chip) : \
                                     (it) == 3 ? FLAMES_FIB_FF_SG3(chip) : "???")


#define FLAMES_FIB_FF_COM(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_COM_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_COM_REDU" : "???")

#define FLAMES_FIB_FF_NOR(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_NOR_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_NOR_REDU" : "???")

#define FLAMES_FIB_FF_NSG(chip)  ((chip) == UVES_CHIP_REDL ? "FIB_FF_NSG_REDL" : \
                      (chip) == UVES_CHIP_REDU ? "FIB_FF_NSG_REDU" : "???")


#define FIB_FF_ODD_INFO_TAB "FIB_FF_ODD_INFO_TAB"
#define FIB_FF_EVEN_INFO_TAB "FIB_FF_EVEN_INFO_TAB"
#define FIB_FF_ALL_INFO_TAB "FIB_FF_ALL_INFO_TAB"


/*
 * prep_sff_ofpos
 */
#define FLAMES_FIB_FF_ALL   "FIB_FF_ALL_RED"
#define FLAMES_FIB_FF_ODD   "FIB_FF_ODD_RED"
#define FLAMES_FIB_FF_EVEN  "FIB_FF_EVEN_RED"

#define FLAMES_CORVEL(chip)  ((chip) == UVES_CHIP_REDL ? "CORVEL_TAB_REDL" : \
                  (chip) == UVES_CHIP_REDU ? "CORVEL_TAB_REDU" : "???")

/*
 * wavecal
 */
#define FLAMES_FIB_SCI_SIM "FIB_SCI_SIM_RED"


#define FLAMES_ORDEF(flames, chip)  ((flames) ?                                       \
                     (((chip) == UVES_CHIP_REDU) ? "FIB_ORDEF_REDU" : \
                      ((chip) == UVES_CHIP_REDL) ? "FIB_ORDEF_REDL" : \
                      "???") : "??UVES??")
#define FLAMES_ORDEF_EXTENSION(flames, chip)  0


/* UVES + FLAMES */

/* Narrow arc lamp frames */
#define UVES_FORMATCHECK(flames,blue) ((flames) ? "FIB_ARC_LAMP_FORM_RED" : \
                                      ((blue) ? "ARC_LAMP_FORM_BLUE" : "ARC_LAMP_FORM_RED"))

/* Narrow flat field frames */
#define UVES_ORDER_FLAT(flames, blue) ((flames) ? "FIB_ORDEF_RED" : \
                       ((blue) ? "ORDER_FLAT_BLUE" : "ORDER_FLAT_RED"))

/* Bias raw frames */
#define UVES_BIAS(blue)           ((blue) ? "BIAS_BLUE"      : "BIAS_RED")

/* Dark raw frames */
#define UVES_DARK(blue)           ((blue) ? "DARK_BLUE"      : "DARK_RED")
#define UVES_PDARK(blue)          ((blue) ? "PDARK_BLUE"     : "PDARK_RED")

/* Flatfield raw frames */
#define UVES_FLAT(blue)           ((blue) ? "FLAT_BLUE"      : "FLAT_RED")
#define UVES_IFLAT(blue)          ((blue) ? "IFLAT_BLUE"     : "IFLAT_RED")
#define UVES_DFLAT(blue)          ((blue) ? "DFLAT_BLUE"     : "DFLAT_RED")
#define UVES_SFLAT(blue)          ((blue) ? "SFLAT_BLUE"     : "SFLAT_RED")
#define UVES_TFLAT(blue)          ((blue) ? "TFLAT_BLUE"     : "TFLAT_RED")
#define UVES_SCREEN_FLAT(blue)          ((blue) ? "SCREEN_FLAT_BLUE"     : "SCREEN_FLAT_RED")

/* Arc lamp */
#define UVES_ARC_LAMP(flames,blue)     ((flames) ? "FIB_ARC_LAMP_RED" : \
                                       ((blue) ? "ARC_LAMP_BLUE" : "ARC_LAMP_RED"))

#define UVES_ECH_ARC_LAMP(blue)       ((blue) ? "ECH_ARC_LAMP_BLUE" : "ECH_ARC_LAMP_RED")

/* CD align */
#define UVES_CD_ALIGN(blue)       ((blue) ? "CD_ALIGN_BLUE" : "CD_ALIGN_RED")

/* STD Star */
#define UVES_STD_STAR(blue)           ((blue) ? "STANDARD_BLUE" : "STANDARD_RED")

/* Science */
#define UVES_SCIENCE(blue)         ((blue) ? "SCIENCE_BLUE"    : "SCIENCE_RED")
#define UVES_SCI_EXTND(blue)       ((blue) ? "SCI_EXTND_BLUE"  : "SCI_EXTND_RED")
#define UVES_SCI_POINT(blue)       ((blue) ? "SCI_POINT_BLUE"  : "SCI_POINT_RED")
#define UVES_SCI_SLICER(blue)      ((blue) ? "SCI_SLICER_BLUE" : "SCI_SLICER_RED")

/* DRS setup table (for backwards compatibility) */
#define UVES_DRS_SETUP(flames, chip) ((flames) ?                                            \
                      (((chip) == UVES_CHIP_REDU) ? "FIB_DRS_REDU" :        \
                       ((chip) == UVES_CHIP_REDL) ? "FIB_DRS_REDL" : "???") \
                      :                                                     \
                      (((chip) == UVES_CHIP_BLUE) ? "DRS_SETUP_BLUE" :      \
                       ((chip) == UVES_CHIP_REDU) ? "DRS_SETUP_REDU" :      \
                       ((chip) == UVES_CHIP_REDL) ? "DRS_SETUP_REDL" : "???"))
    
#define UVES_DRS_SETUP_EXTENSION(chip)  1

/* Order table (written by physmod + flames_cal_orderpos) */
#define UVES_GUESS_ORDER_TABLE(flames,chip) ((flames) ?                                  \
                                (((chip) == UVES_CHIP_REDU) ? "FIB_ORD_GUE_REDU" :       \
                                 ((chip) == UVES_CHIP_REDL) ? "FIB_ORD_GUE_REDL" : "???")\
                                 :                                                       \
                                 (((chip) == UVES_CHIP_BLUE) ? "ORDER_GUESS_TAB_BLUE" :  \
                                 ((chip) == UVES_CHIP_REDU) ? "ORDER_GUESS_TAB_REDU" :   \
                 ((chip) == UVES_CHIP_REDL) ? "ORDER_GUESS_TAB_REDL" :   \
                 "???"))


/* Order table (written by physmod + flames_cal_orderpos) */
#define UVES_ORD_TAB(flames,chip) ((flames) ?                                  \
                                (((chip) == UVES_CHIP_REDU) ? "FIB_ORD_TAB_REDU" :       \
                                 ((chip) == UVES_CHIP_REDL) ? "FIB_ORD_TAB_REDL" : "???")\
                                 :                                                       \
                                 (((chip) == UVES_CHIP_BLUE) ? "ORDER_TABLE_BLUE" :  \
                                 ((chip) == UVES_CHIP_REDU) ? "ORDER_TABLE_REDU" :   \
                 ((chip) == UVES_CHIP_REDL) ? "ORDER_TABLE_REDL" :   \
                 "???"))

#define UVES_GUESS_ORDER_TABLE_EXTENSION(flames,chip)  1


/* Order table (written by uves_orderpos / flames_cal_prep_sff_ofpos) */
#define UVES_ORDER_TABLE(flames,chip)  ((flames) ?                                             \
                                        (((chip) == UVES_CHIP_REDU) ? "FIB_ORDEF_TABLE_REDU" : \
                         ((chip) == UVES_CHIP_REDL) ? "FIB_ORDEF_TABLE_REDL" : \
                                         "???")                                                \
                    :                                                      \
                    (((chip) == UVES_CHIP_BLUE) ? "ORDER_TABLE_BLUE" :     \
                     ((chip) == UVES_CHIP_REDU) ? "ORDER_TABLE_REDU" :     \
                     ((chip) == UVES_CHIP_REDL) ? "ORDER_TABLE_REDL" :     \
                     "???"))
#define UVES_ORDER_TABLE_EXTENSION       1
#define UVES_ORDER_TABLE_EXTENSION_POLY  2
#define UVES_ORDER_TABLE_EXTENSION_FIBRE 3


/* Flame science products
FIB_SCI_INFO_TAB
MWXB_SCI_REDL
ERR_MWXB_SCI_REDL
XB_SCI_REDL

MWXB_SCI_RAW_REDL
ERR_MWXB_SCI_RAW_REDL
XB_SCI_RAW_REDL

MWXB_SCI_REDU
ERR_MWXB_SCI_REDU
XB_SCI_REDU
MWXB_SCI_RAW_REDU
ERR_MWXB_SCI_RAW_REDU
XB_SCI_RAW_REDU
*/
#define FLAMES_SCI_INFO_TAB "FIB_SCI_INFO_TAB"

#define FLAMES_MWXB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "MWXB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "MWXB_SCI_REDL" : \
                              "???")

#define FLAMES_ERR_MWXB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "ERR_MWXB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "ERR_MWXB_SCI_REDL" : \
                              "???")


#define FLAMES_XB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "XB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "XB_SCI_REDL" : \
                              "???")

#define FLAMES_ERR_XB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "ERR_XB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "ERR_XB_SCI_REDL" : \
                              "???")

#define FLAMES_WXB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "WXB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "WXB_SCI_REDL" : \
                              "???")

#define FLAMES_ERR_WXB_SCI(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "ERR_WXB_SCI_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "ERR_WXB_SCI_REDL" : \
                              "???")


#define FLAMES_MWXB_SCI_RAW(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "MWXB_SCI_RAW_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "MWXB_SCI_RAW_REDL" : \
                              "???")

#define FLAMES_ERR_MWXB_SCI_RAW(chip) ( \
             ((chip) == UVES_CHIP_REDU) ? "ERR_MWXB_SCI_RAW_REDU" : \
             ((chip) == UVES_CHIP_REDL) ? "ERR_MWXB_SCI_RAW_REDL" : \
                              "???")


#define FLAMES_WXB_SCI_RAW(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "WXB_SCI_RAW_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "WXB_SCI_RAW_REDL" : \
                              "???")

#define FLAMES_ERR_WXB_SCI_RAW(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "ERR_WXB_SCI_RAW_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "ERR_WXB_SCI_RAW_REDL" : \
                              "???")


#define FLAMES_XB_SCI_RAW(chip) ( \
                          ((chip) == UVES_CHIP_REDU) ? "XB_SCI_RAW_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "XB_SCI_RAW_REDL" : \
                              "???")

#define FLAMES_ERR_XB_SCI_RAW(chip) ( \
              ((chip) == UVES_CHIP_REDU) ? "ERR_XB_SCI_RAW_REDU" : \
              ((chip) == UVES_CHIP_REDL) ? "ERR_XB_SCI_RAW_REDL" : \
                              "???")



/* Background tables are used only to tell
   the user that they are actually *not* used for processing */
#define UVES_BACKGR_TABLE(chip) (((chip) == UVES_CHIP_BLUE) ? "BACKGR_TABLE_BLUE" :    \
                 ((chip) == UVES_CHIP_REDU) ? "BACKGR_TABLE_REDU" :    \
                 ((chip) == UVES_CHIP_REDL) ? "BACKGR_TABLE_REDL" : "???")

/* Master bias */
#define UVES_MASTER_BIAS(chip)           (((chip) == UVES_CHIP_BLUE) ? "MASTER_BIAS_BLUE" :  \
                      ((chip) == UVES_CHIP_REDU) ? "MASTER_BIAS_REDU" :  \
                      ((chip) == UVES_CHIP_REDL) ? "MASTER_BIAS_REDL" : "???")
#define UVES_MASTER_BIAS_EXTENSION(chip) 0

/* Master Formatcheck */
#define UVES_MASTER_ARC_FORM(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_FORM_BLUE" : \
                                    ((chip) == UVES_CHIP_REDU) ? "MASTER_FORM_REDU" : \
                                    ((chip) == UVES_CHIP_REDL) ? "MASTER_FORM_REDL" : "???")

#define UVES_MASTER_ARC_FORM_EXTENSION(chip) 0

/* Master dark */
#define UVES_MASTER_DARK(chip)   (((chip) == UVES_CHIP_BLUE) ? "MASTER_DARK_BLUE" : \
                                  ((chip) == UVES_CHIP_REDU) ? "MASTER_DARK_REDU" : \
                                  ((chip) == UVES_CHIP_REDL) ? "MASTER_DARK_REDL" : "???")

#define UVES_MASTER_PDARK(chip)  (((chip) == UVES_CHIP_BLUE) ? "MASTER_PDARK_BLUE": \
                  ((chip) == UVES_CHIP_REDU) ? "MASTER_PDARK_REDU": \
                  ((chip) == UVES_CHIP_REDL) ? "MASTER_PDARK_REDL": "???")

#define UVES_MASTER_DARK_EXTENSION(chip) 0

/* Master flat */
#define UVES_MASTER_FLAT(chip)  (((chip) == UVES_CHIP_BLUE) ? "MASTER_FLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "MASTER_FLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "MASTER_FLAT_REDL" : "???")
#define UVES_MASTER_DFLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_DFLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "MASTER_DFLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "MASTER_DFLAT_REDL" : "???")
#define UVES_MASTER_SFLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_SFLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "MASTER_SFLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "MASTER_SFLAT_REDL" : "???")
#define UVES_MASTER_IFLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_IFLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "MASTER_IFLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "MASTER_IFLAT_REDL" : "???")
#define UVES_MASTER_TFLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_TFLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "MASTER_TFLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "MASTER_TFLAT_REDL" : "???")
#define UVES_REF_TFLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "REF_TFLAT_BLUE" : \
                                 ((chip) == UVES_CHIP_REDU) ? "REF_TFLAT_REDU" : \
                                 ((chip) == UVES_CHIP_REDL) ? "REF_TFLAT_REDL" : "???")
#define UVES_MASTER_SCREEN_FLAT(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_SCREEN_FLAT_BLUE" : \
                                       ((chip) == UVES_CHIP_REDU) ? "MASTER_SCREEN_FLAT_REDU" : \
                                       ((chip) == UVES_CHIP_REDL) ? "MASTER_SCREEN_FLAT_REDL" : \
                       "???")
#define UVES_MASTER_FLAT_EXTENSION(chip) 0
#define UVES_BKG_FLAT(chip)              (((chip) == UVES_CHIP_BLUE) ? "BKG_FLAT_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "BKG_FLAT_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "BKG_FLAT_REDL" : "???" )
#define UVES_RATIO_TFLAT(chip)              (((chip) == UVES_CHIP_BLUE) ? "RATIO_TFLAT_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "RATIO_TFLAT_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "RATIO_TFLAT_REDL" : "???" )

#define UVES_WEIGHTS(chip)          ((chip) == UVES_CHIP_REDU ? "WEIGHTS_REDU" : \
                                     (chip) == UVES_CHIP_REDL ? "WEIGHTS_REDL" : \
                                     (chip) == UVES_CHIP_BLUE ? "WEIGHTS_BLUE" : \
                                     "???")
/* Line table */
#define UVES_LINE_TABLE(flames,chip)   ((flames) ?                                           \
                                 (((chip) == UVES_CHIP_REDU) ? "FIB_LINE_TABLE_REDU" :       \
                                  ((chip) == UVES_CHIP_REDL) ? "FIB_LINE_TABLE_REDL" : "???")\
                                  :                                                          \
                                  (((chip) == UVES_CHIP_BLUE) ? "LINE_TABLE_BLUE" :          \
                                   ((chip) == UVES_CHIP_REDU) ? "LINE_TABLE_REDU" :          \
                                   ((chip) == UVES_CHIP_REDL) ? "LINE_TABLE_REDL" : "???"))

/* Guess line table */
#define UVES_GUESS_LINE_TABLE(flames,chip) ((flames) ?                                    \
                                 (((chip) == UVES_CHIP_REDU) ? "FIB_LIN_GUE_REDU" :       \
                                  ((chip) == UVES_CHIP_REDL) ? "FIB_LIN_GUE_REDL" : "???")\
                                  :                                                       \
                                  (((chip) == UVES_CHIP_BLUE) ? "LINE_GUESS_TAB_BLUE" :   \
                                  ((chip) == UVES_CHIP_REDU) ? "LINE_GUESS_TAB_REDU" :    \
                   ((chip) == UVES_CHIP_REDL) ? "LINE_GUESS_TAB_REDL" : "???"))

#define UVES_LINE_TABLE_EXTENSION            1
#define UVES_LINE_TABLE_EXTENSION_DISPERSION 2
#define UVES_LINE_TABLE_EXTENSION_ABSORDER   3

/* For backwards compatibility */
#define UVES_LINE_TABLE_MIDAS_BLUE(window) (((window)==1) ? "LINE_TABLE_BLUE1" : \
                                            ((window)==2) ? "LINE_TABLE_BLUE2" : \
                                            ((window)==3) ? "LINE_TABLE_BLUE3" : \
                        "LINE_TABLE_BLUEx")
#define UVES_LINE_TABLE_MIDAS_REDL(window) (((window)==1) ? "LINE_TABLE_REDL1" : \
                                            ((window)==2) ? "LINE_TABLE_REDL2" : \
                                            ((window)==3) ? "LINE_TABLE_REDL3" : \
                                            "LINE_TABLE_REDLx")
#define UVES_LINE_TABLE_MIDAS_REDU(window) (((window)==1) ? "LINE_TABLE_REDU1" : \
                                            ((window)==2) ? "LINE_TABLE_REDU2" : \
                                            ((window)==3) ? "LINE_TABLE_REDU3" : \
                        "LINE_TABLE_REDUx")
#define UVES_LINE_TABLE_MIDAS(chip,window) ( ((chip) == UVES_CHIP_BLUE) ?        \
                        UVES_LINE_TABLE_MIDAS_BLUE(window) : \
                                             ((chip) == UVES_CHIP_REDU) ?        \
                        UVES_LINE_TABLE_MIDAS_REDU(window) : \
                                             ((chip) == UVES_CHIP_REDL) ?        \
                        UVES_LINE_TABLE_MIDAS_REDL(window) : "???")

/* Response curves et al. */
#define UVES_INSTR_RESPONSE(chip) (((chip) == UVES_CHIP_BLUE) ? "INSTR_RESPONSE_BLUE" : \
                                   ((chip) == UVES_CHIP_REDU) ? "INSTR_RESPONSE_REDU" : \
                                   ((chip) == UVES_CHIP_REDL) ? "INSTR_RESPONSE_REDL" : "???")
#define UVES_INSTR_RESPONSE_EXTENSION(chip) 0

#define UVES_MASTER_RESPONSE(chip) (((chip) == UVES_CHIP_BLUE) ? "MASTER_RESPONSE_BLUE" : \
                                    ((chip) == UVES_CHIP_REDU) ? "MASTER_RESPONSE_REDU" : \
                                    ((chip) == UVES_CHIP_REDL) ? "MASTER_RESPONSE_REDL" : "???")
#define UVES_MASTER_RESPONSE_EXTENSION(chip) 0

#define UVES_WCALIB_FF_RESPONSE(chip) (((chip) == UVES_CHIP_BLUE) ? "WCALIB_FF_RESPONSE_BLUE" : \
                                       ((chip) == UVES_CHIP_REDU) ? "WCALIB_FF_RESPONSE_REDU" : \
                                       ((chip) == UVES_CHIP_REDL) ? "WCALIB_FF_RESPONSE_REDL" : \
                       "???")
#define UVES_RED_STD(chip)               (((chip) == UVES_CHIP_BLUE) ? "RED_STD_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "RED_STD_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "RED_STD_REDL" : "???")

#define UVES_RED_NOAPPEND_STD(chip)       (((chip) == UVES_CHIP_BLUE) ? "RED_NONMERGED_STD_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "RED_NONMERGED_STD_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "RED_NONMERGED_STD_REDL" : "???")

#define UVES_BKG_STD(chip)               (((chip) == UVES_CHIP_BLUE) ? "BKG_STD_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "BKG_STD_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "BKG_STD_REDL" : "???")

#define UVES_ORDER_EXTRACT_QC(chip)               (((chip) == UVES_CHIP_BLUE) ? "ORDER_EXTRACT_QC_BLUE" : \
                                          ((chip) == UVES_CHIP_REDU) ? "ORDER_EXTRACT_QC_REDU" : \
                                          ((chip) == UVES_CHIP_REDL) ? "ORDER_EXTRACT_QC_REDL" : "???")

#define UVES_EFFICIENCY_TABLE(chip) (((chip) == UVES_CHIP_BLUE) ? "EFFICIENCY_TABLE_BLUE" : \
                                     ((chip) == UVES_CHIP_REDU) ? "EFFICIENCY_TABLE_REDU" : \
                                     ((chip) == UVES_CHIP_REDL) ? "EFFICIENCY_TABLE_REDL" : "???")

/* CD align table */
#define UVES_CD_ALIGN_TABLE(blue)       ((blue) ? "CD_ALIGN_TABLE_BLUE" : "CD_ALIGN_TABLE_RED")

/* 
 * Reference CALIB tags
 */

/* Line catalogue */
#define UVES_LINE_REFER_TABLE           "LINE_REFER_TABLE"
#define UVES_LINE_REFER_TABLE_EXTENSION 1

#define UVES_LINE_INTMON_TABLE           "LINE_INTMON_TABLE"
#define UVES_LINE_INTMON_TABLE_EXTENSION 1

/* Standard star flux */
#define UVES_FLUX_STD_TABLE           "FLUX_STD_TABLE"
#define UVES_FLUX_STD_TABLE_EXTENSION 1

/* Extinction coefficients */
#define UVES_EXTCOEFF_TABLE           "EXTCOEFF_TABLE"
#define UVES_EXTCOEFF_TABLE_EXTENSION 1

/*
 *  Image statistics
 */

#define UVES_ALL_STATS (CPL_STATS_MEAN | CPL_STATS_STDEV | CPL_STATS_MEDIAN | \
            CPL_STATS_MIN  | CPL_STATS_MAX)
#define DICTIONARY "PRO-1.15"

/*-----------------------------------------------------------------------------
                                Functions prototypes
 -----------------------------------------------------------------------------*/
int uves_contains_frames_kind(cpl_frameset * sof, 
                                 cpl_frameset* raw,
                                 const char*         type);

char *
uves_local_filename(const char *prefix, enum uves_chip chip, int trace, int window);

void
uves_copy_if_possible(uves_propertylist *to, const uves_propertylist *from,
                      const char *name);

void
uves_warn_if_chip_names_dont_match(const uves_propertylist *calib_header, 
                   const char *raw_chip_name, enum uves_chip chip);

cpl_error_code
uves_extract_frames_group_type(const cpl_frameset * set, cpl_frameset** ext, 
                   cpl_frame_group type);
cpl_error_code
uves_frameset_merge(cpl_frameset * set1, const cpl_frameset* set2);
cpl_error_code
uves_sflats_get_encoder_steps(const cpl_frameset * set, cpl_table** encoder_tbl, int* nset);

cpl_error_code uves_dfs_set_groups(cpl_frameset *);

cpl_image *
uves_crop_and_rotate(const cpl_image *image, const uves_propertylist *header,
             enum uves_chip chip,
             const uves_propertylist *redl_header, 
             bool new_format, uves_propertylist **out_header);

void *uves_read_midas_array(const uves_propertylist *plist, const char *name, int *length,
                cpl_type *type, int *nkeys);
polynomial *
uves_polynomial_convert_from_plist_midas(const uves_propertylist *plist, 
					 const char *regression_name,
                                         const int index);

/* Save */
void
uves_dfs_write_statistics(const cpl_image *image, uves_propertylist *header,
			  unsigned stats_mask);

cpl_error_code
uves_frameset_insert(cpl_frameset *frames, 
                     void *object, 
             cpl_frame_group group, 
                     cpl_frame_type type, 
                     cpl_frame_level level,
             const char *filename, 
                     const char *tag, 
             const uves_propertylist *raw_header,
                     const uves_propertylist *primary_header, 
             const uves_propertylist *table_header, 
                     const cpl_parameterlist *parameters, 
             const char *recipe, 
                     const char *pipeline,
                     cpl_table **qc,
             const char *start_time,
             bool dump_paf,
             unsigned stats_mask);

int uves_check_rec_status(const int val) ;

cpl_error_code
uves_save_image_local(const char *description, const char *filename_prefix, 
                      const cpl_image *image, 
                      enum uves_chip chip, int trace, int window,
                      const uves_propertylist *plist,
                      bool use_bitpix16_for_int);

cpl_error_code uves_save_table_local(const char *description, const char *filename_prefix,
                     const cpl_table *table,
                     enum uves_chip chip, int trace, int window,
                     const uves_propertylist *pheader, 
                     const uves_propertylist *eheader);
cpl_error_code uves_save_polynomial(polynomial *p, const char *filename,
                    const uves_propertylist *header);

void uves_save_image(const cpl_image *image, const char *filename, const uves_propertylist *plist,
		     bool use_bitpix16_for_int, bool save1d);

void uves_save_imagelist(const cpl_imagelist *iml, const char *filename, const uves_propertylist *plist);

cpl_image *uves_load_image(const cpl_frame *f,
    int plane,
    int extension,
    uves_propertylist **header);

cpl_image *uves_load_image_file(const char *filename,
    int plane,
    int extension,
    uves_propertylist **header);
    

/* Load raw */
cpl_error_code
uves_load_master_formatcheck(const cpl_frameset *frames, const char *chip_name,
        const char **mform_filename, 
        cpl_image **mform, uves_propertylist **mform_header, enum uves_chip chip);

cpl_error_code uves_load_formatcheck(const cpl_frameset *frames,
                     bool flames,
                     const char **raw_filename,
                     cpl_image *raw_image[2],
                     uves_propertylist *raw_header[2], 
                     uves_propertylist *rotated_header[2], bool *blue);

cpl_error_code uves_load_orderpos(const cpl_frameset *frames,
                  bool flames,
                  const char **raw_filename,
                  cpl_image *raw_image[2],
                  uves_propertylist *raw_header[2], 
                  uves_propertylist *rotated_header[2], 
                                  bool *blue);

void uves_load_arclamp(const cpl_frameset *frames,
               bool flames,
               const char **raw_filename, 
               cpl_image *raw_image[2], uves_propertylist *raw_header[2],
               uves_propertylist *rotated_header[2], 
               bool *blue, bool *sim_cal);

cpl_error_code uves_load_science(const cpl_frameset *frames, const char **raw_filename, 
                 cpl_image *raw_image[2], 
                 uves_propertylist *raw_header[2], 
                 uves_propertylist *rotated_header[2], 
                 bool *blue,
                 const char **sci_type);
cpl_error_code uves_load_standard(const cpl_frameset *frames, const char **raw_filename,
                  cpl_image *raw_image[2], uves_propertylist *raw_header[2], 
                  uves_propertylist *rotated_header[2], bool *blue);
cpl_error_code uves_load_raw_imagelist(const cpl_frameset *frames, 
                       bool flames,
                       const char *blue_tag, 
                       const char *red_tag, cpl_type type, 
                       cpl_imagelist *images[2], uves_propertylist **raw_headers[2],
                       uves_propertylist *rotated_header[2],
                       bool *blue);

/* Load calibration */
cpl_error_code uves_load_drs(const cpl_frameset *frames, 
                 bool flames,
                 const char *chip_name,
                 const char **drs_filename, 
                 uves_propertylist **drs_header,
                 enum uves_chip chip);
cpl_error_code uves_load_mbias(const cpl_frameset *frames, const char *chip_id,
                   const char **mbias_filename,
                   cpl_image **mbias, uves_propertylist **mbias_header, 
                   enum uves_chip chip);
cpl_error_code uves_load_mdark(const cpl_frameset *frames, const char *chip_id,
                   const char **mdark_filename,
                   cpl_image **mdark, uves_propertylist **mdark_header,
                   enum uves_chip chip);
cpl_error_code uves_load_mflat_const(const cpl_frameset *frames, const char *chip_name,
                     const char **mflat_filename, 
                     cpl_image **mflat, uves_propertylist **mflat_header, 
                     enum uves_chip chip,
                     const cpl_frame **mflat_frame);
cpl_error_code uves_load_mflat(cpl_frameset *frames, const char *chip_name,
                   const char **mflat_filename, 
                   cpl_image **mflat, uves_propertylist **mflat_header, 
                   enum uves_chip chip,
                   cpl_frame **mflat_frame);
cpl_image *
uves_load_weights(const cpl_frameset *frames, const char **weights_filename,
                  enum uves_chip chip);

void uves_load_ref_flat(const cpl_frameset *frames, const char *chip_name,
            const char **filename, cpl_image **rflat,
            uves_propertylist **rflat_header, enum uves_chip chip);

cpl_error_code uves_load_ordertable(const cpl_frameset *frames, 
                    bool flames,
                    const char *chip_id,
                    const char **ordertable_filename,
                    cpl_table **ordertable, 
                    uves_propertylist **ordertable_header, 
                    uves_propertylist **ordertable_xheader, 
                    polynomial **order_locations, 
                                    cpl_table **traces,
                    int *tab_in_out_oshift,
                    double *tab_in_out_yshift,
                                    int ** fibre_mask,
                                    double ** fibre_pos,
                    enum uves_chip chip,
                    bool guess_table);

void uves_load_linetable_const(const cpl_frameset *frames, 
                   bool flames,
                   const char *chip_name,
                   const polynomial *order_locations, 
                   int minorder, int maxorder,
                   const char **linetable_filename,
                   const cpl_table **linetable,
                   const uves_propertylist **linetable_header,
                   const polynomial **dispersion_relation,
                   polynomial **absolute_order,
                   enum uves_chip chip, int trace_id, int window);

void uves_load_linetable(const cpl_frameset *frames, 
             bool flames,
             const char *chip_name,
             const polynomial *order_locations, 
             int minorder, int maxorder,
             const char **linetable_filename,
             cpl_table **linetable,
             uves_propertylist **linetable_header,
             polynomial **dispersion_relation,
             polynomial **absolute_order,
             enum uves_chip chip, int trace_id, int window);

cpl_error_code uves_load_response_curve(const cpl_frameset *frames, const char *chip_name,
                    const char **response_filename, 
                    cpl_image **response_curve,
                    cpl_table **master_response,
                    uves_propertylist **response_header, enum uves_chip chip);

void uves_load_corvel(const cpl_frameset *frames,
              cpl_table **corvel,
              uves_propertylist **corvel_header,
              const char **corvel_filename);
            
void uves_load_cd_align(const cpl_frameset *frames,
            const char **raw_filename1,
            const char **raw_filename2,
            cpl_image *raw_image1[2],
            cpl_image *raw_image2[2],
            uves_propertylist *raw_header1[2], 
            uves_propertylist *raw_header2[2], 
            uves_propertylist *rotated_header1[2], 
            uves_propertylist *rotated_header2[2], 
            bool *blue);

/* Static calibration */
cpl_error_code uves_load_linerefertable(const cpl_frameset *frames, 
                    const char **line_refer_filename, 
                    cpl_table **line_refer, 
                    uves_propertylist **line_refer_header);

cpl_error_code uves_load_lineintmon(const cpl_frameset *frames, 
                    const char **line_intmonr_filename, 
                    cpl_table **line_intmon);

cpl_error_code uves_load_flux_table(const cpl_frameset *frames, const char **flux_table_filename, 
                    cpl_table **flux_table);
    
cpl_error_code uves_load_atmo_ext(const cpl_frameset *frames, 
                  const char **atmext_table_filename, 
                  cpl_table **atmext_table);

/* Product filenames */

/* Mbias */
char *uves_masterbias_filename(enum uves_chip chip);

/* Mdark */
char *uves_masterdark_filename(enum uves_chip chip);

/* Mflat */
char *uves_masterflat_filename(enum uves_chip chip);
char *uves_masterflat_bkg_filename(enum uves_chip chip);

/* Orderpos */
char *uves_ordef_filename(enum uves_chip chip);
char *uves_order_table_filename(enum uves_chip chip);
char *uves_guess_order_table_filename(enum uves_chip chip);
char *uves_guess_line_table_filename(enum uves_chip chip);

/* Wavecal */
char *uves_line_table_filename(enum uves_chip chip);
char *uves_line_table_filename_paf(enum uves_chip chip);

/* Response */
char *uves_response_curve_filename(enum uves_chip chip);
char *uves_response_curve_2d_filename(enum uves_chip chip);
char *uves_response_red_standard_filename(enum uves_chip chip);
char *uves_response_red_noappend_standard_filename(enum uves_chip chip);
char *uves_response_efficiency_filename(enum uves_chip chip);
char *uves_response_bkg_standard_filename(enum uves_chip chip);

char *uves_order_extract_qc_standard_filename(enum uves_chip chip);

/* Tflat */
char *uves_flat_ratio_filename(enum uves_chip chip);

/* CDAlign */
char *uves_cd_align_filename(enum uves_chip chip);

/* Scired */
char *uves_scired_red_science_filename(enum uves_chip chip);
char *uves_scired_red_noappend_science_filename(enum uves_chip chip);
char *uves_scired_red_2d_science_filename(enum uves_chip chip);
char *uves_scired_red_error_filename(enum uves_chip chip);
char *uves_scired_red_noappend_error_filename(enum uves_chip chip);
char *uves_scired_red_2d_error_filename(enum uves_chip chip);
char *uves_scired_fluxcal_science_filename(enum uves_chip chip);
char *uves_scired_fluxcal_science_noappend_filename(enum uves_chip chip);
char *uves_scired_fluxcal_science_2d_filename(enum uves_chip chip);
char *uves_scired_fluxcal_error_filename(enum uves_chip chip);
char *uves_scired_fluxcal_error_noappend_filename(enum uves_chip chip);
char *uves_scired_fluxcal_error_2d_filename(enum uves_chip chip);
char *uves_scired_ff_variance_filename(enum uves_chip chip);
char *uves_scired_ff_variance_2d_filename(enum uves_chip chip);
char *uves_scired_background_filename(enum uves_chip chip);
char *uves_scired_merged_sky_filename(enum uves_chip chip);
char *uves_scired_merged_science_filename(enum uves_chip chip);
char *uves_scired_merged_2d_science_filename(enum uves_chip chip);
char *uves_scired_resampled_filename(enum uves_chip chip);
char *uves_scired_resampled_2d_filename(enum uves_chip chip);
char *uves_scired_resampledmf_filename(enum uves_chip chip);
char *uves_scired_rebinned_filename(enum uves_chip chip);
char *uves_scired_rebinned_2d_filename(enum uves_chip chip);
char *uves_scired_ordertrace_filename(enum uves_chip chip);
char *uves_scired_wmap_filename(enum uves_chip chip);
char *uves_scired_crmask_filename(enum uves_chip chip);
char *uves_scired_ext2d_filename(enum uves_chip chip);
char *uves_scired_ff2d_filename(enum uves_chip chip);
cpl_image*
uves_vector_to_image(const cpl_vector* vector,cpl_type type);


cpl_error_code
uves_check_if_format_is_midas(uves_propertylist* header, bool* format_is_midas);


#endif
