/* $Id: kmo_dev_setup-test.c,v 1.5 2013-10-08 11:18:56 aagudo Exp $
 *
 * This file is part of the KMOS Library
 * Copyright (C) 2002-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-10-08 11:18:56 $
 * $Revision: 1.5 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <sys/stat.h>

#include <cpl.h>

#include "kmclipm_functions.h"
#include "kmclipm_constants.h"

#include "kmo_dfs.h"

const char  *test_global_path_test_data;
float   test_global_seed_data, test_global_seed_noise;
int     test_global_size_x, test_global_size_y, test_global_size_z, test_global_nr_frames;
void kmo_get_pipe_command(char*, const char*, const char*, int);
int kmo_test_file_exists(const char*);
void kmo_test_verbose_off();
void kmo_test_verbose_on();
double kmo_test_esorex_data(const char*, int);
const char* kmo_test_cat_strings(char*, const char*, const char*);
int  kmo_test_create_RAW_data(int, int, const char*, char**, char**, int*, int, char**, char**, int*, int, float, float);
int  kmo_test_create_RAW_data_zero(int, int, const char*);
int  kmo_test_create_F2D_data(int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2D_data_noise(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2I_data(int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F2I_data_noise(int, int, int, const char*, char *, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data(int, int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data_infinite(int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data2(int, int, int, int, int*, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F3I_data_noise(int, int, int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F1I_data(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_F1I_data_noise(int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
int  kmo_test_create_B2D_data(int, int, int, const char*, char*, char*, int*, int, char**, char**, int*, int);
void kmo_test_create_pipeline_data_core(const char*, const char*);

const char      *path_recipe       = "kmo_dev_setup/";

/**
    @defgroup kmo_dev_setup_test  kmo_dev_setup_test unit tests

    @{
*/

/**
  @brief    Test of kmo_dev_setup recipe.
  @param    argc   the number of parameters
  @param    argv   the parameter list

  Call @c kmo_dev_setup-test @c --generate when only the test data for this
  recipe should be generated.
  Call @c kmo_dev_setup-test @c --no-gen when only the tests should be
  executed and no data should be generated.

 */
int main(int argc, char *argv[])
{
    float   tol = 0.01;

    char    test_path[256],
            file_path[256];

    cpl_propertylist *h = NULL;

    cpl_test_init("<kmos-spark@mpe.mpg.de>", CPL_MSG_WARNING);

    strcpy(test_path, test_global_path_test_data);
    strcat(test_path, path_recipe);

    if (kmo_test_file_exists(test_path) == FALSE) {
        mkdir(test_path, 0777);
    }

    // get rid of warning...
    if ((argc == 5) && (strcmp(argv[1], "xxx") != 0)) {
    }

    // run kmo_dev_setup repeatedly
    kmo_test_create_pipeline_data_core(path_recipe, "log_kmo_dev_setup.txt");

    sprintf(test_path, "%s%s", test_global_path_test_data, path_recipe);

    // check arc_on_123.fits
    sprintf(file_path, "%s%s", test_path, "arc_on_123");
    cpl_test_abs(kmo_test_esorex_data(file_path, 1), 252.872, tol*1.5);
    strcat(file_path, ".fits");

    h = kmclipm_propertylist_load(file_path, 0);
    cpl_test_eq(cpl_propertylist_get_bool(h, INS_LAMP1_ST), 1);
    cpl_test_eq(cpl_propertylist_get_int(h, OBS_ID), -2147);
    cpl_test_eq(cpl_propertylist_get_double(h, ROTANGLE), 0.0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS FILT1 ID"), "K"), 0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS FILT2 ID"), "K"), 0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS FILT3 ID"), "K"), 0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS GRAT1 ID"), "K"), 0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS GRAT2 ID"), "K"), 0);
    cpl_test_eq(strcmp(cpl_propertylist_get_string(h, "ESO INS GRAT3 ID"), "K"), 0);
    cpl_test_eq(cpl_propertylist_get_double(h, EXPTIME), 600);
    cpl_propertylist_delete(h); h = NULL;

    h = kmclipm_propertylist_load(file_path, 1);
    cpl_test_eq(cpl_propertylist_get_double(h, GAIN), 1.1);
    cpl_test_eq(cpl_propertylist_get_double(h, RON), 0.1);
    cpl_test_eq(cpl_propertylist_get_double(h, EXPTIME), 600);
    cpl_propertylist_delete(h); h = NULL;

    return cpl_test_end(0);
}

/** @} */
