/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.DocumentEventIgnorer;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.TreeWalker;
import net.sf.saxon.pull.UnconstructedElement;
import net.sf.saxon.pull.UnconstructedParent;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class VirtualTreeWalker
implements PullProvider,
NamespaceDeclarations {
    private PipelineConfiguration pipe;
    private int currentEvent = 0;
    private int nameCode;
    private int nextNameCode;
    private ParentNodeConstructor instruction;
    private XPathContext context;
    private Stack constructorStack = new Stack();
    private Stack iteratorStack = new Stack();
    private PullProvider subordinateTreeWalker = null;
    private boolean alreadyRead = false;
    private boolean allowAttributes = false;
    private int stripDepth = -1;
    private AttributeCollectionImpl attributes;
    private boolean foundAttributes;
    private int[] activeNamespaces;
    private ArrayList additionalNamespaces = new ArrayList(10);
    private FastStringBuffer textNodeBuffer = new FastStringBuffer(100);
    private CharSequence currentTextValue = null;
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    public VirtualTreeWalker(ParentNodeConstructor parentNodeConstructor, XPathContext xPathContext) {
        this.instruction = parentNodeConstructor;
        this.context = xPathContext;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int next() throws XPathException {
        try {
            SequenceIterator sequenceIterator;
            if (this.subordinateTreeWalker != null) {
                this.currentEvent = this.subordinateTreeWalker.next();
                if (this.currentEvent == -1) {
                    this.subordinateTreeWalker = null;
                    return this.next();
                }
                return this.currentEvent;
            }
            if (this.currentEvent == 0) {
                this.constructorStack.push(this.instruction);
                if (this.stripDepth < 0 && this.instruction.getValidationAction() == 4) {
                    this.stripDepth = this.constructorStack.size();
                }
                SequenceIterator sequenceIterator2 = this.instruction.getContentExpression().iterate(this.context);
                this.iteratorStack.push(sequenceIterator2);
                if (this.instruction instanceof DocumentInstr) {
                    this.currentEvent = 2;
                    this.nameCode = -1;
                } else {
                    this.currentEvent = 4;
                    this.nameCode = ((ElementCreator)this.instruction).getNameCode(this.context);
                    this.allowAttributes = true;
                    this.processAttributesAndNamespaces((ElementCreator)this.instruction, sequenceIterator2);
                    this.allowAttributes = false;
                    this.alreadyRead = true;
                }
                return this.currentEvent;
            }
            if (this.iteratorStack.isEmpty()) {
                if (this.currentEvent == 2 || this.currentEvent == 4) {
                    sequenceIterator = this.instruction.getContentExpression().iterate(this.context);
                    this.constructorStack.push(this.instruction);
                    if (this.stripDepth < 0 && this.instruction.getValidationAction() == 4) {
                        this.stripDepth = this.constructorStack.size();
                    }
                    this.iteratorStack.push(sequenceIterator);
                } else {
                    if (this.currentEvent == 3 || this.currentEvent == 5) {
                        this.currentEvent = -1;
                        return this.currentEvent;
                    }
                    this.currentEvent = this.instruction instanceof DocumentInstr ? 3 : 5;
                    return this.currentEvent;
                }
            }
            sequenceIterator = (SequenceIterator)this.iteratorStack.peek();
            if (this.alreadyRead) {
                Item item = sequenceIterator.current();
                this.alreadyRead = false;
                this.nameCode = this.nextNameCode;
                return this.processItem(sequenceIterator, item);
            }
            return this.processItem(sequenceIterator, sequenceIterator.next());
        }
        catch (XPathException xPathException) {
            this.context.getController().reportFatalError(xPathException);
            throw xPathException;
        }
    }

    private int processItem(SequenceIterator sequenceIterator, Item item) throws XPathException {
        if (item == null) {
            ParentNodeConstructor parentNodeConstructor;
            if (this.stripDepth == this.constructorStack.size()) {
                this.stripDepth = -1;
            }
            if ((parentNodeConstructor = (ParentNodeConstructor)this.constructorStack.pop()) instanceof DocumentInstr) {
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentEvent = 3;
                    this.nameCode = -1;
                    return this.currentEvent;
                }
                return this.next();
            }
            this.currentEvent = 5;
            this.nameCode = -1;
            this.iteratorStack.pop();
            return this.currentEvent;
        }
        if (item instanceof UnconstructedParent) {
            UnconstructedParent unconstructedParent = (UnconstructedParent)item;
            ParentNodeConstructor parentNodeConstructor = unconstructedParent.getInstruction();
            this.constructorStack.push(parentNodeConstructor);
            if (this.stripDepth < 0 && parentNodeConstructor.getValidationAction() == 4) {
                this.stripDepth = this.constructorStack.size();
            }
            SequenceIterator sequenceIterator2 = parentNodeConstructor.getContentExpression().iterate(unconstructedParent.getXPathContext());
            if (parentNodeConstructor instanceof DocumentInstr) {
                this.iteratorStack.push(sequenceIterator2);
                return this.next();
            }
            this.currentEvent = 4;
            this.nameCode = ((UnconstructedElement)item).getNameCode();
            this.processAttributesAndNamespaces((ElementCreator)parentNodeConstructor, sequenceIterator2);
            this.alreadyRead = true;
            this.iteratorStack.push(sequenceIterator2);
            return this.currentEvent;
        }
        if (item instanceof AtomicValue) {
            Item item2;
            this.currentTextValue = this.textNodeBuffer;
            this.textNodeBuffer.setLength(0);
            this.textNodeBuffer.append(item.getStringValueCS());
            while ((item2 = sequenceIterator.next()) instanceof AtomicValue) {
                this.textNodeBuffer.append(' ');
                this.textNodeBuffer.append(item2.getStringValueCS());
            }
            this.currentEvent = 8;
            this.nameCode = -1;
            this.alreadyRead = true;
            return this.currentEvent;
        }
        this.nameCode = ((NodeInfo)item).getNameCode();
        switch (((NodeInfo)item).getNodeKind()) {
            case 3: {
                this.currentEvent = 8;
                this.currentTextValue = item.getStringValueCS();
                return this.currentEvent;
            }
            case 8: {
                this.currentEvent = 9;
                return this.currentEvent;
            }
            case 7: {
                this.currentEvent = 10;
                return this.currentEvent;
            }
            case 2: {
                if (!this.allowAttributes) {
                    DynamicError dynamicError;
                    if (this.constructorStack.peek() instanceof DocumentInstr) {
                        dynamicError = new DynamicError("Attributes cannot be attached to a document node");
                        if (this.context.getController().getExecutable().getHostLanguage() == 51) {
                            dynamicError.setErrorCode("XQTY0004");
                        } else {
                            dynamicError.setErrorCode("XTDE0420");
                        }
                    } else {
                        dynamicError = new DynamicError("Attributes in the content of an element must come before the child nodes");
                        if (this.context.getController().getExecutable().getHostLanguage() == 51) {
                            dynamicError.setErrorCode("XQDY0024");
                        } else {
                            dynamicError.setErrorCode("XTDE0410");
                        }
                    }
                    dynamicError.setXPathContext(this.context);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
                this.currentEvent = 6;
                return this.currentEvent;
            }
            case 13: {
                if (!this.allowAttributes) {
                    DynamicError dynamicError = new DynamicError("Namespace nodes in the content of an element must come before the child nodes");
                    dynamicError.setErrorCode("XTDE0410");
                    dynamicError.setXPathContext(this.context);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
                this.currentEvent = 7;
                return this.currentEvent;
            }
            case 1: {
                this.subordinateTreeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.currentEvent = this.subordinateTreeWalker.next();
                this.nameCode = this.subordinateTreeWalker.getNameCode();
                return this.currentEvent;
            }
            case 9: {
                this.subordinateTreeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.subordinateTreeWalker = new DocumentEventIgnorer(this.subordinateTreeWalker);
                this.subordinateTreeWalker.setPipelineConfiguration(this.pipe);
                this.currentEvent = this.subordinateTreeWalker.next();
                this.nameCode = -1;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException();
    }

    private void processAttributesAndNamespaces(ElementCreator elementCreator, SequenceIterator sequenceIterator) throws XPathException {
        Item item;
        boolean bl;
        this.foundAttributes = false;
        this.additionalNamespaces.clear();
        this.activeNamespaces = elementCreator.getActiveNamespaces();
        if (this.activeNamespaces == null) {
            this.activeNamespaces = EMPTY_INT_ARRAY;
        }
        boolean bl2 = bl = this.stripDepth < 0;
        while ((item = sequenceIterator.next()) != null && item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            int n = nodeInfo.getNodeKind();
            if (n == 2) {
                int n2;
                if (!this.foundAttributes) {
                    if (this.attributes == null) {
                        this.attributes = new AttributeCollectionImpl(this.context.getNamePool());
                    }
                    this.attributes.clear();
                    this.foundAttributes = true;
                }
                if ((n2 = this.attributes.getIndexByFingerprint(nodeInfo.getFingerprint())) >= 0) {
                    if (this.context.getController().getExecutable().getHostLanguage() == 50) {
                        this.attributes.setAttribute(n2, nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : 642, nodeInfo.getStringValue(), 0, 0);
                        continue;
                    }
                    DynamicError dynamicError = new DynamicError("The attributes of an element must have distinct names");
                    dynamicError.setErrorCode("XQDY0025");
                    dynamicError.setXPathContext(this.context);
                    dynamicError.setLocator(this.getSourceLocator());
                    throw dynamicError;
                }
                this.attributes.addAttribute(nodeInfo.getNameCode(), bl ? nodeInfo.getTypeAnnotation() : 642, nodeInfo.getStringValue(), 0, 0);
                continue;
            }
            if (n == 13) {
                this.additionalNamespaces.add(nodeInfo);
                continue;
            }
            if (n == 3 && nodeInfo.getStringValue().equals("")) continue;
            this.nextNameCode = ((NodeInfo)item).getNameCode();
            break;
        }
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getAttributes();
        }
        if (this.foundAttributes) {
            return this.attributes;
        }
        return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getNamespaceDeclarations();
        }
        return this;
    }

    public int skipToMatchingEnd() throws XPathException {
        Item item;
        if (this.currentEvent != 2 && this.currentEvent != 4) {
            throw new IllegalStateException();
        }
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.skipToMatchingEnd();
        }
        SequenceIterator sequenceIterator = (SequenceIterator)this.iteratorStack.peek();
        if (this.alreadyRead) {
            this.alreadyRead = false;
        }
        while ((item = sequenceIterator.next()) != null) {
        }
        return this.currentEvent == 2 ? 3 : 5;
    }

    public void close() {
        if (this.subordinateTreeWalker != null) {
            this.subordinateTreeWalker.close();
        }
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public int getNameCode() {
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getNameCode();
        }
        return this.nameCode;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public CharSequence getStringValue() throws XPathException {
        Item item;
        if (this.subordinateTreeWalker != null) {
            return this.subordinateTreeWalker.getStringValue();
        }
        if (this.currentEvent == 8) {
            return this.currentTextValue;
        }
        if (this.currentEvent != 4 && this.currentEvent != 2) {
            SequenceIterator sequenceIterator = (SequenceIterator)this.iteratorStack.peek();
            if (sequenceIterator.current() == null) {
                return "";
            }
            return sequenceIterator.current().getStringValue();
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        SequenceIterator sequenceIterator = (SequenceIterator)this.iteratorStack.peek();
        if (this.alreadyRead) {
            if (sequenceIterator.current() == null) {
                return "";
            }
            this.processText(sequenceIterator.current(), fastStringBuffer);
            this.alreadyRead = false;
        }
        while ((item = sequenceIterator.next()) != null) {
            this.processText(item, fastStringBuffer);
        }
        return fastStringBuffer;
    }

    private void processText(Item item, FastStringBuffer fastStringBuffer) {
        if (item instanceof UnconstructedParent) {
            fastStringBuffer.append(item.getStringValueCS());
        } else if (item instanceof AtomicValue) {
            fastStringBuffer.append(item.getStringValueCS());
        } else {
            NodeInfo nodeInfo = (NodeInfo)item;
            switch (nodeInfo.getNodeKind()) {
                case 1: 
                case 3: 
                case 9: {
                    fastStringBuffer.append(nodeInfo.getStringValueCS());
                }
            }
        }
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public int getTypeAnnotation() {
        if (this.subordinateTreeWalker != null && this.stripDepth < 0) {
            return this.subordinateTreeWalker.getTypeAnnotation();
        }
        return -1;
    }

    public SourceLocator getSourceLocator() {
        return this.instruction;
    }

    public int getNumberOfNamespaces() {
        return this.activeNamespaces.length + this.additionalNamespaces.size();
    }

    public String getPrefix(int n) {
        if (n < this.activeNamespaces.length) {
            return this.getNamePool().getPrefixFromNamespaceCode(this.activeNamespaces[n]);
        }
        return ((NodeInfo)this.additionalNamespaces.get(n - this.activeNamespaces.length)).getLocalPart();
    }

    public String getURI(int n) {
        if (n < this.activeNamespaces.length) {
            return this.getNamePool().getURIFromNamespaceCode(this.activeNamespaces[n]);
        }
        return ((NodeInfo)this.additionalNamespaces.get(n - this.activeNamespaces.length)).getStringValue();
    }

    public int getNamespaceCode(int n) {
        if (n < this.activeNamespaces.length) {
            return this.activeNamespaces[n];
        }
        return this.getNamePool().allocateNamespaceCode(this.getPrefix(n), this.getURI(n));
    }

    public int[] getNamespaceCodes(int[] nArray) {
        if (nArray.length < this.getNumberOfNamespaces()) {
            nArray = new int[this.getNumberOfNamespaces()];
        } else {
            nArray[this.getNumberOfNamespaces()] = -1;
        }
        for (int i = 0; i < this.getNumberOfNamespaces(); ++i) {
            nArray[i] = this.getNamespaceCode(i);
        }
        return nArray;
    }

    public List getUnparsedEntities() {
        return null;
    }
}

