
var _mediaPlayerLastId = 1;

function Media(src, mediaSuccess, mediaError, mediaStatus) {
    if (typeof(mediaError) !== "function") {
        mediaError = new Function();
    }
    if (typeof(mediaStatus) !== "function") {
        mediaStatus = new Function();
    }

    this.src = src;
    this.id = _mediaPlayerLastId++;
    this._duration = -1;
    this._position = -1;
    this._timeoutId = 0;

    Cordova.exec(null, mediaError, "com.cordova.Media", "newPlayer", [src, this.id]);
    Cordova.exec(mediaSuccess, mediaStatus, "com.cordova.Media", "playerSetCallbacks", [ { id: this.id } ]);
}

Media.prototype = {
    seekTo: function (position) {
        if (typeof(position) !== "number") return;
        Cordova.exec(null, null, "com.cordova.Media", "seekTo", [ { id: this.id, position: position } ]);
    },

    setVolume: function (level) {
        if (typeof mediaSuccess !== "number") return;

        Cordova.exec(null, null, "com.cordova.Media", "setVolume", [ { id: this.id, volume: level } ]);
    },

    getCurrentPosition: function (mediaSuccess, mediaError) {
        if (typeof mediaSuccess !== "function") return;
        var self = this;
        Cordova.exec(function (position) {
            self._position = position;
            mediaSuccess(position);
        }, null, "com.cordova.Media", "getCurrentPosition", [ { id: this.id } ]);
    },

    getDuration: function () {
        var self = this;

        Cordova.exec(function (duration) {
            if (duration <= 0 && !self._timeoutId)
                self._timeoutId = setTimeout(self.getDuration.bind(self), 500);
            self._duration = duration;
        }, null, "com.cordova.Media", "getDuration", [ { id: this.id } ]);
        return this._duration;
    },

    play: function () {
        this.getDuration();
        Cordova.exec(null, null, "com.cordova.Media", "play", [ { id: this.id } ]);
    },

    pause: function () {
        this.getDuration();
        Cordova.exec(null, null, "com.cordova.Media", "pause", [ { id: this.id } ]);
    },

    stop: function () {
        this.getDuration();
        Cordova.exec(null, null, "com.cordova.Media", "stop", [ { id: this.id } ]);
    },


    release: function () {
        if (this._timeoutId) {
            this._timeoutId = 0;
            clearTimeout(this._timeoutId);
        }
        Cordova.exec(null, null, "com.cordova.Media", "releasePlayer", [ { id: this.id } ]);
    },

    startRecord: function () {
        Cordova.exec(null, null, "com.cordova.Media", "startRecording", [ { id: this.id } ]);
    },

    stopRecord: function () {
        Cordova.exec(null, null, "com.cordova.Media", "stopRecording", [ { id: this.id } ]);
    }
};

Media.MEDIA_NONE = 0;
Media.MEDIA_STARTING = 1;
Media.MEDIA_RUNNING = 2;
Media.MEDIA_PAUSED = 3;
Media.MEDIA_STOPPED = 4;

function MediaError(code, message) {
    this.code = code;
    this.message = message;
}

MediaError.MEDIA_ERR_NONE_ACTIVE = 0;
MediaError.MEDIA_ERR_ABORTED = 1;
MediaError.MEDIA_ERR_NETWORK = 2;
MediaError.MEDIA_ERR_DECODE = 3;
MediaError.MEDIA_ERR_NONE_SUPPORTED = 4;

Cordova.addConstructor("com.cordova.Media", function() {
    window.Media = Media;
    window.MediaError = MediaError;
});
