var systemWindowOpen = null;

function openBrowser(url, target, options) {
    if (!url || typeof(url) != "string")
        return;
    if (!target || typeof(target) != "string")
        target = "_self";
    if (!options || typeof(options) != "string")
        options = "location=yes";

    if (target === "_self") {
        systemWindowOpen(url, "_self");
        return;
    }
    if (target === "_system") {
        // TODO: don't allow relative url
        Cordova.exec(null, null, "com.cordova.App", "loadUrl", [ url ]);
        return;
    }

    var ref = {
        events: {
            loadstart: new Cordova.EventHandler("loadstart"),
            loadend: new Cordova.EventHandler("loadend"),
            close: new Cordova.EventHandler("close")
        },

        addEventListener: function(eventname, callback) {
            ref.events[eventname].addEventListener(callback);
        },

        removeEventListener: function(eventname, callback) {
            ref.events[eventname].removeEventListener(callback);
        },

        close: function() {
            Cordova.exec(null, null, "com.cordova.InAppBrowser", "close", [ url ]);
        }
    };
    Cordova.exec(function() {
        ref.events.loadend.dispatchEvent()
    }, function() {
        ref.events.close.dispatchEvent()
    }, "com.cordova.InAppBrowser", "loadUrl", [ url ]);
    return ref;
}

Cordova.addConstructor("com.cordova.InAppBrowser", function () {
    if (systemWindowOpen)
        return;
    systemWindowOpen = window.open;
    window.open = openBrowser;
});
