if not modules then modules = { } end modules ['lang-txt'] = {
    version   = 1.001,
    comment   = "companion to lang-lab.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "PRAGMA ADE / ConTeXt Development Team",
    license   = "see context related readme files",
    dataonly  = true,
}

-- The content of this file is derived from the mkii lang-* files and
-- early 2011 the mkii labels are generated from this file. The
-- translations have been collected over years by users, using named
-- glyphs. This file uses utf exclusively.
--
-- Many of the initial translations were done by Tobias Burnus but
-- completed by numerous users. The following list is incomplete so feel
-- free to send me corrections.
--
-- In 2020+ Tomas Hala and his students added some more languages and did
-- some extensive checking of the entries in this file.
--
-- af    Afrikaans      ...
-- ar    Arabic         Idris Samawi Hamid, Khaled Hosny
-- be    Belarussian    Darya Hryshkavets (2019)
-- bg    Bulgarian      Vladislav Hinkin, Aleš Ďurčanský (2019)
-- ca    Catalan        ...; additions Javier Gambin Monzo + Samuel Conca Coles (2022)
-- cn    Chinese        Wang Lei, ...
-- cs    Czech          Tom Hudec, Petr Sojka, Richard Gabriel; additions Tomáš Hála (2022)
-- da    Danish         Arne Jorgensen
-- de    German         Tobias Burnus, ...
-- en    English        Hans Hagen, ...
-- eo    Esperanto      Alain Delmotte (2021)
-- es    Spanish        Andrés Montoya, ...; additions Javier Gambin Monzo + Samuel Conca Coles (2022)
-- et    Estonian       Clyde Johnston (2018)
-- fa    Persian        Mohammad Hossein Bateni (2016)
-- fi    Finnish        ...; additions Ossi Salo (2022)
-- fr    French         Daniel Flipo, Arthur Reutenauer; additions Arnaud Pierre Henri De Barbentane + Adrien Patton (2022)
-- gr    Greek          Apostolos Syropoulos, Thomas Schmitz
-- hr    Croatian       Željko Vrba, Richard Gabriel, Vedran Miletić
-- hu    Hungarian      Adam Reviczky
-- hy    Armenian       Kristina Nazarjanová (2022)
-- it    Italian        Giuseppe Bilotta, Luigi Scarso
-- ja    Japanese       Richard Gabriel
-- kr    Korean         Jeong Dalyoung
-- la    Latin          ...
-- lt    Lithuanian     Marius Aleknevičius
-- mk    Macedonian     Jakub Loula, Tomáš Hála (2019), Stojan Trajanovski (2019)
-- nb    Norwegian      Hans Fredrik Nordhaug, ...
-- nn    Norwegian      Hans Fredrik Nordhaug, ...
-- nl    Dutch          Hans Hagen
-- pl    Polish         Grzegorz Sapijaszko (2011)
-- pt    Portuguese     Pedro F. M. Mendonça; additions Joana Sophia Bogas Carneiro (2023)
-- ro    Romanian       Dan Seracu, ...
-- ru    Russian        Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- sk    Slovak         Tomáš Hála (2012, 2022)
-- sl    Slovenian      Mojca Miklavec
-- sr    Serbian        Ivan Pešić (2020)
-- sr-latn Serbian      Ivan Pešić (2020)
-- sv    Swedish        ...; additions Edith and Mikael Sundqvist (2023)
-- tk    Turkish        Tobias Burnus
-- tr    Turkmen        Nazar Annagurban
-- ua    Ukrainian      Olga Briginets, Alexander Bokovoy, Victor Figurnov, ...
-- vi    Vietnamese     Han The Thanh


-- For the moment we keep this table in memory. In the future we can then
-- enable labels.

-- thinspace == sixperemspace = 0x2006
-- print("!"..utf.char(0x2006).."!")

-- Will be done when needed:
-- (TH) editor|editors:mnem missing
-- (HH) save memory at functions
-- (MS) btx settings for sv

languages       = languages or { }
local languages = languages

languages.data  = languages.data or utilities.storage.allocate { }
local data      = languages.data

local hairspace = utf.char(0x200A)

data.labels={
 ["btx"]={
  ["In"]={
   ["labels"]={
    ["be"]="У",
    ["bg"]="в",
    ["ca"]="En",
    ["cs"]="In",
    ["de"]="In",
    ["en"]="In",
    ["eo"]="En",
    ["es"]="En",
    ["fa"]="در",
    ["fr"]="Dans",
    ["hy"]="Մեջ",
    ["mk"]="во",
    ["sk"]="In",
    ["sr"]="У",
    ["sr-latn"]="U",
   },
  },
  ["Number"]={
   ["labels"]={
    ["be"]="Нумар",
    ["bg"]="номер",
    ["ca"]="Nombre",
    ["cs"]="Číslo",
    ["de"]="Nummer",
    ["en"]="Number",
    ["eo"]="Nombro",
    ["es"]="Numero",
    ["fa"]="شماره",
    ["fr"]="Numéro",
    ["hy"]="Համար",
    ["mk"]="Број",
    ["nl"]="Nummer",
    ["pt"]="Numero",
    ["sk"]="Číslo",
    ["sr"]="Број",
    ["sr-latn"]="Broj",
   },
  },
  ["Volume"]={
   ["labels"]={
    ["be"]="Гук",
    ["bg"]="обем",
    ["ca"]="Volum",
    ["cs"]="Svazek",
    ["de"]="Band",
    ["en"]="Volume",
    ["eo"]="Volumo",
    ["es"]="Volumen",
    ["et"]="Köide",
    ["fa"]="جلد",
    ["fr"]="Volume",
    ["hy"]="Ծավալ",
    ["mk"]="Том",
    ["nl"]="Deel",
    ["pt"]="Volume",
    ["sk"]="Zväzok",
    ["sr"]="Том",
    ["sr-latn"]="Tom",
   },
  },
  ["and"]={
   ["labels"]={
    ["be"]="i",
    ["bg"]="a",
    ["ca"]="i",
    ["cs"]="a",
    ["de"]="und",
    ["en"]="and",
    ["eo"]="kaj",
    ["es"]="y",
    ["et"]="ja",
    ["fa"]="و",
    ["fr"]="et",
    ["hy"]="և",
    ["it"]="e",
    ["mk"]="и",
    ["nl"]="en",
    ["pt"]="e",
    ["sk"]="a",
    ["sr"]="и",
    ["sr-latn"]="i",
   },
  },
  ["edition"]={
   ["labels"]={
    ["be"]="Выданне",
    ["bg"]="издание",
    ["ca"]="Edició",
    ["cs"]="vydání",
    ["de"]="Auflage",
    ["en"]="edition",
    ["eo"]="eldono",
    ["es"]="edición",
    ["et"]="väljaanne",
    ["fa"]="ویرایش",
    ["fi"]="versio",
    ["fr"]="édition",
    ["hy"]="հրատարակություն",
    ["it"]="edizione",
    ["mk"]="издание",
    ["nl"]="editie",
    ["pt"]="edicao",
    ["sk"]="vydanie",
    ["sr"]="издање",
    ["sr-latn"]="izdanje",
   },
  },
  ["editor"]={
   ["labels"]={
    ["be"]="реэдактар",
    ["bg"]="редактор",
    ["ca"]="editor",
    ["cs"]="editor",
    ["de"]="Herausgeber",
    ["en"]="editor",
    ["eo"]="eldonisto",
    ["es"]="editor",
    ["et"]="toimetaja",
    ["fa"]="ویراستار",
    ["fr"]="éditeur",
    ["hy"]="խմբագիր",
    ["it"]="a cura di",
    ["mk"]="уредник",
    ["pt"]="editor",
    ["sk"]="editor",
    ["sr"]="уредник",
    ["sr-latn"]="urednik",
   },
  },
  ["editor:f"]={
   ["labels"]={
    ["cs"]="editorka",
    ["sk"]="editorka",
   },
  },
  ["editors"]={
   ["labels"]={
    ["be"]="рэдактары",
    ["bg"]="редактори",
    ["ca"]="editors",
    ["cs"]="editoři",
    ["de"]="Herausgeber",
    ["en"]="editors",
    ["eo"]="eldonistoj",
    ["es"]="editores",
    ["et"]="toimetajad",
    ["fr"]="éditeurs",
    ["hy"]="խմբագիրներ",
    ["it"]="a cura di",
    ["mk"]="уредници",
    ["pt"]="editores",
    ["sk"]="editori",
    ["sr"]="уредници",
    ["sr-latn"]="urednici",
   },
  },
  ["editors:f"]={
   ["labels"]={
    ["cs"]="editorky",
    ["sk"]="editorky",
   },
  },
  ["in"]={
   ["labels"]={
    ["be"]="у",
    ["bg"]="в",
    ["ca"]="en",
    ["cs"]="v",
    ["de"]="in",
    ["en"]="in",
    ["eo"]="en",
    ["es"]="en",
    ["fa"]="در",
    ["fr"]="dans",
    ["hy"]="մեջ",
    ["mk"]="во",
    ["pt"]="em",
    ["sk"]="v",
    ["sr"]="у",
    ["sr-latn"]="u",
   },
  },
  ["mastersthesis"]={
   ["labels"]={
    ["be"]="Дыпломная работа",
    ["bg"]="дипломна работа",
    ["ca"]="Tesi de maestria",
    ["cs"]="Diplomová práce",
    ["de"]="Masterarbeit",
    ["en"]="Master's thesis",
    ["eo"]="Magistreca disertaĵo",
    ["es"]="Tesis de maestría",
    ["et"]="magistritöö",
    ["fa"]="پایان‌نامه کارشناسی ارشد",
    ["fi"]="Pro gradu tutkielma",
    ["fr"]="Thèse de master (DEA, DESS, master)",
    ["hy"]="Մագիստրոսական թեզ",
    ["it"]="Tesi di laurea",
    ["mk"]="Магистерска дисертација",
    ["nl"]="Masterproef",
    ["pt"]="Tese de mestrado",
    ["sk"]="Diplomová práca",
    ["sr"]="Мастер дисертација",
    ["sr-latn"]="Master disertacija",
   },
  },
  ["number"]={
   ["labels"]={
    ["be"]="нумар",
    ["bg"]="номер",
    ["ca"]="nombre",
    ["cs"]="číslo",
    ["de"]="Nummer",
    ["en"]="number",
    ["eo"]="numero",
    ["es"]="numero",
    ["fa"]="شماره",
    ["fi"]="numero",
    ["fr"]="numéro",
    ["hy"]="համար",
    ["mk"]="број",
    ["nl"]="nummer",
    ["pt"]="numero",
    ["sk"]="číslo",
    ["sr"]="број",
    ["sr-latn"]="broj",
   },
  },
  ["of"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="на",
    ["ca"]="de",
    ["cs"]="z",
    ["de"]="von",
    ["en"]="of",
    ["eo"]="de",
    ["es"]="de",
    ["fr"]="de",
    ["hy"]="-ից",
    ["mk"]="од",
    ["nl"]="van",
    ["pt"]="de",
    ["sk"]="z",
    ["sr"]="од",
    ["sr-latn"]="od",
   },
  },
  ["others"]={
   ["labels"]={
    ["ca"]="et al.",
    ["cs"]="a~kol.",
    ["de"]="et al.",
    ["en"]="et al.",
    ["eo"]="aliaj",
    ["es"]="otros",
    ["et"]="jt",
    ["fr"]="et al.",
    ["hy"]="եւ այլն",
    ["mk"]="и др.",
    ["pt"]="etc",
    ["sk"]="a~kol.",
    ["sr"]="и др.",
    ["sr-latn"]="i dr.",
   },
  },
  ["p"]={
   ["labels"]={
    ["be"]="стар.",
    ["ca"]="p.",
    ["cs"]="s.",
    ["de"]="S.",
    ["en"]="p.",
    ["eo"]="p.",
    ["es"]="p",
    ["et"]="lk",
    ["fa"]="ص",
    ["fr"]="p.",
    ["hy"]="էջ",
    ["mk"]="стр.",
    ["pt"]="p",
    ["sk"]="s.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
   },
  },
  ["pages"]={
   ["labels"]={
    ["be"]="старонка",
    ["bg"]="страни",
    ["ca"]="pagines",
    ["cs"]="strany",
    ["de"]="Seiten",
    ["en"]="pages",
    ["eo"]="paĝoj",
    ["es"]="paginas",
    ["et"]="leheküljed",
    ["fa"]="صفحات",
    ["fi"]="sivut",
    ["fr"]="pages",
    ["hy"]="էջեր",
    ["mk"]="страници",
    ["nl"]="paginas",
    ["pt"]="paginas",
    ["sk"]="strany",
    ["sr"]="страницa",
    ["sr-latn"]="stranica",
   },
  },
  ["patent"]={
   ["labels"]={
    ["be"]="патэнт",
    ["bg"]="патент",
    ["ca"]="Patent",
    ["cs"]="Patent",
    ["de"]="Patent",
    ["en"]="Patent",
    ["eo"]="Patento",
    ["es"]="Patente",
    ["et"]="Patent",
    ["fi"]="patentti",
    ["fr"]="Brevet",
    ["hy"]="Արտոնագիր",
    ["it"]="Brevetto",
    ["mk"]="Патент",
    ["nl"]="Octrooi",
    ["pt"]="Patente",
    ["sk"]="Patent",
    ["sr"]="Патент",
    ["sr-latn"]="Patent",
   },
  },
  ["phdthesis"]={
   ["labels"]={
    ["be"]="Доктарская дысертацыя",
    ["bg"]="дисертачна работа",
    ["ca"]="Tesi doctoral",
    ["cs"]="Disertační práce",
    ["de"]="Dissertation",
    ["en"]="PhD thesis",
    ["eo"]="Doktoriĝa disertaĵo",
    ["es"]="Tesis doctoral",
    ["et"]="doktoritöö",
    ["fa"]="رساله دکتری",
    ["fr"]="Thèse de doctorat",
    ["hy"]="Դոկտորական թեզ",
    ["it"]="Tesi di dottorato",
    ["mk"]="Докторска дисертација",
    ["nl"]="Proefschrift",
    ["pt"]="Tese de douturamento",
    ["sk"]="Dizertačná práca",
    ["sr"]="Докторска дисертација",
    ["sr-latn"]="Doktorska disertacija",
   },
  },
  ["pp"]={
   ["labels"]={
    ["ca"]="pp",
    ["cs"]="s.",
    ["de"]="S.",
    ["en"]="pp.",
    ["eo"]="pp.",
    ["es"]="pp",
    ["et"]="lk-d",
    ["fa"]="صص",
    ["hy"]="էջ",
    ["mk"]="стр.",
    ["pt"]="pp",
    ["sk"]="s.",
    ["sr"]="стр.",
    ["sr-latn"]="str.",
   },
  },
  ["technicalreport"]={
   ["labels"]={
    ["be"]="Тэхнічны даклад",
    ["bg"]="технически доклад",
    ["ca"]="Report tecnic",
    ["cs"]="Technická zpráva",
    ["de"]="Technischer Bericht",
    ["en"]="Technical report",
    ["eo"]="Teknika raporto",
    ["es"]="Informe técnico",
    ["et"]="tehniline raport",
    ["fa"]="گزارش فنی",
    ["fi"]="Tekninen raportti",
    ["fr"]="Rapport technique",
    ["hy"]="Տեխնիկական հաշվետվություն",
    ["it"]="Relazione tecnica",
    ["mk"]="Технички извештај",
    ["nl"]="Technisch rapport",
    ["pt"]="Reporte tecnico",
    ["sk"]="Technická zpráva",
    ["sr"]="Технички извештај",
    ["sr-latn"]="Tehnički izveštaj",
   },
  },
  ["volume"]={
   ["labels"]={
    ["be"]="гучнасць",
    ["bg"]="обем",
    ["ca"]="volum",
    ["cs"]="svazek",
    ["de"]="Band",
    ["en"]="volume",
    ["eo"]="volumo",
    ["es"]="volumen",
    ["et"]="köide",
    ["fa"]="جلد",
    ["fr"]="volume",
    ["hy"]="ծավալ",
    ["mk"]="том",
    ["nl"]="deel",
    ["pt"]="volume",
    ["sk"]="zväzok",
    ["sr"]="том",
    ["sr-latn"]="tom",
   },
  },
  ["with"]={
   ["labels"]={
    ["be"]="з",
    ["bg"]="със",
    ["ca"]="en",
    ["cs"]="s",
    ["de"]="mit",
    ["en"]="with",
    ["eo"]="kun",
    ["es"]="con",
    ["et"]="koos",
    ["fi"]="kanssa",
    ["fr"]="avec",
    ["hy"]="ի հետ",
    ["it"]="con",
    ["mk"]="со",
    ["nl"]="met",
    ["pt"]="com",
    ["sk"]="s",
    ["sr"]="са",
    ["sr-latn"]="sa",
   },
  },
 },
 ["functions"]={
  ["Pr"]={
   ["labels"]={
    ["ca"]="Pr",
    ["cs"]="P",
    ["en"]="Pr",
    ["eo"]="P",
    ["es"]="Pr",
    ["hy"]="P",
    ["mk"]="P",
    ["pt"]="Pr",
    ["sk"]="P",
    ["sr"]="P",
    ["sr-latn"]="P",
    ["sv"]="Pr",
   },
  },
  ["arccos"]={
   ["labels"]={
    ["ca"]="arc cos",
    ["cs"]="arccos",
    ["en"]="arccos",
    ["eo"]="arccos",
    ["es"]="arc\\sixperemspace cos",
    ["hr"]="arc\\sixperemspace cos",
    ["hy"]="arccos",
    ["mk"]="arccos",
    ["pl"]="arc\\sixperemspace cos",
    ["pt"]="arccos",
    ["sk"]="arccos",
    ["sr"]="arccos",
    ["sr-latn"]="arccos",
    ["sv"]="arccos",
   },
  },
  ["arccosh"]={
   ["labels"]={
    ["ca"]="arccosh",
    ["cs"]="arccosh",
    ["en"]="arccosh",
    ["eo"]="arccosh",
    ["es"]="arc\\sixperemspace cosh",
    ["hr"]="arc\\sixperemspace cosh",
    ["hy"]="arccosh",
    ["mk"]="arccosh",
    ["pl"]="arc\\sixperemspace cosh",
    ["pt"]="arccosh",
    ["sk"]="arccosh",
    ["sr"]="arccosh",
    ["sr-latn"]="arccosh",
    ["sv"]="arcosh",
   },
  },
  ["arccot"]={
   ["labels"]={
    ["ca"]="arc cot",
    ["cs"]="arccotg",
    ["en"]="arccot",
    ["eo"]="arcctan",
    ["es"]="arc\\sixperemspace cot",
    ["hr"]="arc\\sixperemspace ctg",
    ["hy"]="arcctg",
    ["mk"]="arccotg",
    ["pl"]="arc\\sixperemspace ctg",
    ["pt"]="arccot",
    ["sk"]="arccotg",
    ["sr"]="arcctg",
    ["sr-latn"]="arcctg",
    ["sv"]="arccot",
   },
  },
  ["arcsin"]={
   ["labels"]={
    ["ca"]="arc sen",
    ["cs"]="arcsin",
    ["en"]="arcsin",
    ["eo"]="arcsin",
    ["es"]="arc\\sixperemspace sen",
    ["hr"]="arc\\sixperemspace sin",
    ["hy"]="arcsin",
    ["mk"]="arcsin",
    ["pl"]="arc\\sixperemspace sin",
    ["pt"]="arcsin",
    ["sk"]="arcsin",
    ["sr"]="arcsin",
    ["sr-latn"]="arcsin",
    ["sv"]="arcsin",
   },
  },
  ["arcsinh"]={
   ["labels"]={
    ["ca"]="arc senh",
    ["cs"]="arcsinh",
    ["en"]="arcsinh",
    ["eo"]="arcsinh",
    ["es"]="arc\\sixperemspace senh",
    ["hr"]="arc\\sixperemspace sinh",
    ["hy"]="arcsinh",
    ["mk"]="arcsinh",
    ["pl"]="arc\\sixperemspace sinh",
    ["pt"]="arcsinh",
    ["sk"]="arcsinh",
    ["sr"]="arcsinh",
    ["sr-latn"]="arcsinh",
    ["sv"]="arsinh",
   },
  },
  ["arctan"]={
   ["labels"]={
    ["ca"]="arc tan",
    ["cs"]="arctg",
    ["en"]="arctan",
    ["eo"]="arctang",
    ["es"]="arc\\sixperemspace tan",
    ["hr"]="arc\\sixperemspace tg",
    ["hy"]="arctan",
    ["mk"]="arctg",
    ["pl"]="arc\\sixperemspace tg",
    ["pt"]="arctan",
    ["sk"]="arctg",
    ["sr"]="arctg",
    ["sr-latn"]="arctg",
    ["sv"]="arctan",
   },
  },
  ["arctanh"]={
   ["labels"]={
    ["ca"]="arc tanh",
    ["cs"]="arctgh",
    ["en"]="arctanh",
    ["eo"]="arctanh",
    ["es"]="arc\\sixperemspace tanh",
    ["hr"]="arc\\sixperemspace tgh",
    ["hy"]="arctanh",
    ["mk"]="arctgh",
    ["pl"]="arc\\sixperemspace tgh",
    ["pt"]="arctanh",
    ["sk"]="arctgh",
    ["sr"]="arctgh",
    ["sr-latn"]="arctgh",
    ["sv"]="artanh",
   },
  },
  ["arg"]={
   ["labels"]={
    ["ca"]="arg",
    ["cs"]="arg",
    ["en"]="arg",
    ["eo"]="arg",
    ["es"]="arg",
    ["hy"]="arg",
    ["mk"]="arg",
    ["pt"]="arg",
    ["sk"]="arg",
    ["sr"]="arg",
    ["sr-latn"]="arg",
    ["sv"]="arg",
   },
  },
  ["cos"]={
   ["labels"]={
    ["ca"]="cos",
    ["cs"]="cos",
    ["en"]="cos",
    ["eo"]="cos",
    ["es"]="cos",
    ["hy"]="cos",
    ["mk"]="cos",
    ["pt"]="cos",
    ["sk"]="cos",
    ["sr"]="cos",
    ["sr-latn"]="cos",
    ["sv"]="cos",
   },
  },
  ["cosh"]={
   ["labels"]={
    ["ca"]="cosh",
    ["cs"]="cosh",
    ["en"]="cosh",
    ["eo"]="cosh",
    ["es"]="cosh",
    ["hy"]="cosh",
    ["mk"]="cosh",
    ["pt"]="cosh",
    ["sk"]="cosh",
    ["sr"]="cosh",
    ["sr-latn"]="cosh",
    ["sv"]="cosh",
   },
  },
  ["cot"]={
   ["labels"]={
    ["ca"]="cot",
    ["cs"]="cotg",
    ["en"]="cot",
    ["eo"]="cotan",
    ["es"]="cot",
    ["hr"]="ctg",
    ["hy"]="cot",
    ["mk"]="ctg",
    ["pl"]="ctg",
    ["pt"]="cot",
    ["sk"]="cotg",
    ["sr"]="ctg",
    ["sr-latn"]="ctg",
    ["sv"]="cot",
   },
  },
  ["coth"]={
   ["labels"]={
    ["ca"]="coth",
    ["cs"]="cotgh",
    ["en"]="coth",
    ["eo"]="cotanh",
    ["es"]="coth",
    ["hy"]="coth",
    ["mk"]="ctgh",
    ["pt"]="coth",
    ["sk"]="cotgh",
    ["sr"]="ctgh",
    ["sr-latn"]="ctgh",
    ["sv"]="coth",
   },
  },
  ["csc"]={
   ["labels"]={
    ["ca"]="csc",
    ["cs"]="cosec",
    ["en"]="csc",
    ["eo"]="cosec",
    ["es"]="csc",
    ["hy"]="csc",
    ["mk"]="cosec",
    ["pt"]="csc",
    ["sk"]="cosec",
    ["sr"]="cosec",
    ["sr-latn"]="cosec",
    ["sv"]="csc",
   },
  },
  ["deg"]={
   ["labels"]={
    ["ca"]="gr",
    ["cs"]="deg",
    ["en"]="deg",
    ["eo"]="gr",
    ["es"]="gr",
    ["hy"]="deg",
    ["mk"]="deg",
    ["pt"]="deg",
    ["sk"]="deg",
    ["sr"]="deg",
    ["sr-latn"]="deg",
    ["sv"]="deg",
   },
  },
  ["det"]={
   ["labels"]={
    ["ca"]="det",
    ["cs"]="det",
    ["en"]="det",
    ["eo"]="det",
    ["es"]="det",
    ["hy"]="det",
    ["pt"]="det",
    ["sk"]="det",
    ["sr"]="det",
    ["sr-latn"]="det",
    ["sv"]="det",
   },
  },
  ["diff"]={
   ["labels"]={
    ["ca"]="d",
    ["cs"]="d",
    ["en"]="d",
    ["eo"]="dif",
    ["hy"]="d",
    ["pt"]="d",
    ["sk"]="d",
    ["sv"]="d",
   },
  },
  ["dim"]={
   ["labels"]={
    ["ca"]="dim",
    ["cs"]="dim",
    ["en"]="dim",
    ["eo"]="dim",
    ["es"]="dim",
    ["hy"]="dim",
    ["mk"]="dim",
    ["pt"]="dim",
    ["sk"]="dim",
    ["sr"]="dim",
    ["sr-latn"]="dim",
    ["sv"]="dim",
   },
  },
  ["exp"]={
   ["labels"]={
    ["ca"]="exp",
    ["cs"]="exp",
    ["en"]="exp",
    ["eo"]="eksp",
    ["es"]="exp",
    ["hy"]="exp",
    ["pt"]="exp",
    ["sk"]="exp",
    ["sr"]="exp",
    ["sr-latn"]="exp",
    ["sv"]="exp",
   },
  },
  ["gcd"]={
   ["labels"]={
    ["ca"]="med",
    ["cs"]="NSD",
    ["de"]="ggT",
    ["en"]="gcd",
    ["eo"]="",
    ["es"]="mcd",
    ["hr"]="nzd",
    ["hy"]="ԱԸԲ",
    ["mk"]="НЗД",
    ["nl"]="ggd",
    ["pt"]="gcd",
    ["sk"]="NSD",
    ["sr"]="НЗД",
    ["sr-latn"]="NZD",
    ["sv"]="sgd",
   },
  },
  ["hom"]={
   ["labels"]={
    ["ca"]="hom",
    ["cs"]="Hom",
    ["en"]="hom",
    ["eo"]="hom",
    ["es"]="hom",
    ["hy"]="հոմ",
    ["pt"]="hom",
    ["sk"]="Hom",
    ["sv"]="hom",
   },
  },
  ["inf"]={
   ["labels"]={
    ["ca"]="inf",
    ["cs"]="inf",
    ["en"]="inf",
    ["eo"]="inf",
    ["es"]="inf",
    ["hy"]="inf",
    ["mk"]="inf",
    ["pt"]="inf",
    ["sk"]="inf",
    ["sr"]="inf",
    ["sr-latn"]="inf",
    ["sv"]="inf",
   },
  },
  ["injlim"]={
   ["labels"]={
    ["ca"]="inj",
    ["cs"]="inj\\sixperemspace lim",
    ["en"]="inj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace iny",
    ["hy"]="inj\\sixperemspace lim",
    ["pt"]="inj\\sixperemspace lim",
    ["sk"]="inj\\sixperemspace lim",
    ["sr"]="inj\\sixperemspace lim",
    ["sr-latn"]="inj\\sixperemspace lim",
    ["sv"]="inj\\sixperemspace lim",
   },
  },
  ["inv"]={
   ["labels"]={
    ["ca"]="inv",
    ["cs"]="inv",
    ["en"]="inv",
    ["eo"]="inv",
    ["es"]="inv",
    ["hy"]="inv",
    ["mk"]="inv",
    ["pt"]="inv",
    ["sk"]="inv",
    ["sr"]="inv",
    ["sr-latn"]="inv",
    ["sv"]="inv",
   },
  },
  ["ker"]={
   ["labels"]={
    ["ca"]="Ker",
    ["cs"]="ker",
    ["en"]="ker",
    ["eo"]="",
    ["es"]="Ker",
    ["hy"]="ker",
    ["pt"]="ker",
    ["sk"]="ker",
    ["sr"]="ker",
    ["sr-latn"]="ker",
    ["sv"]="ker",
   },
  },
  ["lcm"]={
   ["labels"]={
    ["ca"]="MCM",
    ["cs"]="NSN",
    ["de"]="kgV",
    ["en"]="lcm",
    ["eo"]="",
    ["es"]="MCM",
    ["hr"]="nzv",
    ["hy"]="աըբ",
    ["mk"]="НЗС",
    ["nl"]="kgv",
    ["pt"]="lcm",
    ["sk"]="NSN",
    ["sr"]="НЗС",
    ["sr-latn"]="NZS",
    ["sv"]="lcm",
   },
  },
  ["lg"]={
   ["labels"]={
    ["ca"]="log",
    ["cs"]="log",
    ["de"]="log",
    ["en"]="lg",
    ["eo"]="log",
    ["es"]="log",
    ["fr"]="log",
    ["hy"]="lg",
    ["mk"]="lg",
    ["pt"]="lg",
    ["sk"]="log",
    ["sr"]="lg",
    ["sr-latn"]="lg",
    ["sv"]="lg",
   },
  },
  ["lim"]={
   ["labels"]={
    ["ca"]="lim",
    ["cs"]="lim",
    ["en"]="lim",
    ["eo"]="lim",
    ["es"]="lím",
    ["hy"]="lim",
    ["mk"]="lim",
    ["pt"]="lim",
    ["sk"]="lim",
    ["sr"]="lim",
    ["sr-latn"]="lim",
    ["sv"]="lim",
   },
  },
  ["liminf"]={
   ["labels"]={
    ["ca"]="lim inf",
    ["cs"]="lim\\sixperemspace inf",
    ["en"]="lim\\sixperemspace inf",
    ["eo"]="subinf",
    ["es"]="lím\\sixperemspace inf",
    ["hy"]="lim\\sixperemspace infs",
    ["mk"]="lim\\sixperemspace inf",
    ["pt"]="lim\\sixperemspace inf",
    ["sk"]="lim\\sixperemspace inf",
    ["sr"]="lim\\sixperemspace inf",
    ["sr-latn"]="lim\\sixperemspace inf",
    ["sv"]="lim\\sixperemspace inf",
   },
  },
  ["limsup"]={
   ["labels"]={
    ["ca"]="lim sup",
    ["cs"]="lim\\sixperemspace sup",
    ["en"]="lim\\sixperemspace sup",
    ["eo"]="suplim",
    ["es"]="lím\\sixperemspace sup",
    ["hy"]="lim\\sixperemspace sup",
    ["mk"]="lim\\sixperemspace sup",
    ["pt"]="lim\\sixperemspace sup",
    ["sk"]="lim\\sixperemspace sup",
    ["sr"]="lim\\sixperemspace sup",
    ["sr-latn"]="lim\\sixperemspace sup",
    ["sv"]="lim\\sixperemspace sup",
   },
  },
  ["ln"]={
   ["labels"]={
    ["ca"]="ln",
    ["cs"]="ln",
    ["en"]="ln",
    ["eo"]="ln",
    ["es"]="ln",
    ["hy"]="ln",
    ["mk"]="ln",
    ["pt"]="ln",
    ["sk"]="ln",
    ["sr"]="ln",
    ["sr-latn"]="ln",
    ["sv"]="ln",
   },
  },
  ["log"]={
   ["labels"]={
    ["ca"]="log",
    ["cs"]="log",
    ["en"]="log",
    ["eo"]="log",
    ["es"]="log",
    ["hy"]="log",
    ["mk"]="log",
    ["pt"]="log",
    ["sk"]="log",
    ["sr"]="log",
    ["sr-latn"]="log",
    ["sv"]="log",
   },
  },
  ["max"]={
   ["labels"]={
    ["ca"]="max",
    ["cs"]="max",
    ["en"]="max",
    ["eo"]="maks",
    ["es"]="máx",
    ["fi"]="max",
    ["hy"]="max",
    ["mk"]="max",
    ["pt"]="max",
    ["sk"]="max",
    ["sr"]="max",
    ["sr-latn"]="max",
    ["sv"]="max",
   },
  },
  ["median"]={
   ["labels"]={
    ["comment"]=[[ cs+sk: \tilde won't work]],
    ["ca"]="mitjana",
    ["cs"]="Me",
    ["en"]="median",
    ["eo"]="mediano",
    ["es"]="Mediana",
    ["fi"]="mediaani",
    ["fr"]="médiane",
    ["hy"]="միջին",
    ["pt"]="median",
    ["sk"]="Med",
    ["sr"]="median",
    ["sr-latn"]="median",
    ["sv"]="median",
   },
  },
  ["min"]={
   ["labels"]={
    ["ca"]="min",
    ["cs"]="min",
    ["en"]="min",
    ["eo"]="min",
    ["es"]="mín",
    ["fi"]="min",
    ["hy"]="min",
    ["mk"]="min",
    ["pt"]="min",
    ["sk"]="min",
    ["sr"]="min",
    ["sr-latn"]="min",
    ["sv"]="min",
   },
  },
  ["mod"]={
   ["labels"]={
    ["ca"]="mod",
    ["cs"]="mod",
    ["en"]="mod",
    ["eo"]="mod",
    ["es"]="mod",
    ["fi"]="mod",
    ["hy"]="mod",
    ["mk"]="mod",
    ["pt"]="mod",
    ["sk"]="mod",
    ["sr"]="mod",
    ["sr-latn"]="mod",
    ["sv"]="mod",
   },
  },
  ["projlim"]={
   ["labels"]={
    ["ca"]="lim proy",
    ["cs"]="proj\\sixperemspace lim",
    ["en"]="proj\\sixperemspace lim",
    ["eo"]="",
    ["es"]="lím\\sixperemspace proy",
    ["hy"]="proj\\sixperemspace lim",
    ["pt"]="proj\\sixperemspace lim",
    ["sk"]="proj\\sixperemspace lim",
    ["sr"]="proj\\sixperemspace lim",
    ["sr-latn"]="proj\\sixperemspace lim",
    ["sv"]="proj\\sixperemspace lim",
   },
  },
  ["sec"]={
   ["labels"]={
    ["ca"]="sec",
    ["cs"]="sec",
    ["en"]="sec",
    ["eo"]="sek",
    ["es"]="sec",
    ["fi"]="sek",
    ["hy"]="sec",
    ["mk"]="sec",
    ["pt"]="sec",
    ["sk"]="sec",
    ["sr"]="sec",
    ["sr-latn"]="sec",
    ["sv"]="sec",
   },
  },
  ["sin"]={
   ["labels"]={
    ["ca"]="sen",
    ["cs"]="sin",
    ["en"]="sin",
    ["eo"]="sin",
    ["es"]="sen",
    ["fi"]="sin",
    ["hy"]="sin",
    ["mk"]="sin",
    ["pt"]="sen",
    ["sk"]="sin",
    ["sr"]="sin",
    ["sr-latn"]="sin",
    ["sv"]="sin",
   },
  },
  ["sinh"]={
   ["labels"]={
    ["ca"]="senh",
    ["cs"]="sinh",
    ["en"]="sinh",
    ["eo"]="sinh",
    ["es"]="senh",
    ["hy"]="sinh",
    ["mk"]="sinh",
    ["pt"]="sinh",
    ["sk"]="sinh",
    ["sr"]="sinh",
    ["sr-latn"]="sinh",
    ["sv"]="sinh",
   },
  },
  ["sup"]={
   ["labels"]={
    ["cs"]="sup",
    ["en"]="sup",
    ["eo"]="sup",
    ["es"]="sup",
    ["hy"]="sup",
    ["mk"]="sup",
    ["pt"]="sup",
    ["sk"]="sup",
    ["sr"]="sup",
    ["sr-latn"]="sup",
    ["sv"]="sup",
   },
  },
  ["tan"]={
   ["labels"]={
    ["cs"]="tg",
    ["en"]="tan",
    ["eo"]="tan",
    ["es"]="tan",
    ["hr"]="tg",
    ["hy"]="tan",
    ["mk"]="tg",
    ["pl"]="tg",
    ["pt"]="tan",
    ["sk"]="tg",
    ["sr"]="tg",
    ["sr-latn"]="tg",
    ["sv"]="tan",
   },
  },
  ["tanh"]={
   ["labels"]={
    ["cs"]="tgh",
    ["en"]="tanh",
    ["eo"]="tanh",
    ["es"]="tanh",
    ["hy"]="tanh",
    ["mk"]="tgh",
    ["pt"]="tanh",
    ["sk"]="tgh",
    ["sr"]="tgh",
    ["sr-latn"]="tgh",
    ["sv"]="tanh",
   },
  },
 },
 ["texts"]={
  ["and"]={
   ["labels"]={
    ["af"]="",
    ["ca"]=" i ",
    ["cs"]=" a ",
    ["da"]="",
    ["de"]=" und ",
    ["en"]=" and ",
    ["eo"]=" kaj ",
    ["es"]=" y ",
    ["et"]=" ja ",
    ["fa"]=" و ",
    ["fi"]="",
    ["fr"]=" et ",
    ["gr"]="",
    ["hr"]=" i ",
    ["hu"]=" és ",
    ["hy"]=" և ",
    ["it"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]=" и ",
    ["nb"]="",
    ["nl"]=" en ",
    ["nn"]="",
    ["pl"]=" i ",
    ["pt"]=" e ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]=" a ",
    ["sl"]="",
    ["sr"]=" и ",
    ["sv"]=" och ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["appendix"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Bylae ",
    ["ar"]="ملحق ",
    ["be"]="Апендыцыт ",
    ["ca"]="Apèndix ",
    ["cn"]="附录 ",
    ["cs"]="Příloha ",
    ["da"]="Bilag ",
    ["de"]="Anhang ",
    ["en"]="Appendix ",
    ["eo"]="Anekso ",
    ["es"]="Apéndice ",
    ["et"]="Lisa ",
    ["fa"]="پیوست ",
    ["fi"]="Liite ",
    ["fr"]="Annexe ",
    ["gr"]="Παράρτημα ",
    ["hr"]="Dodatak ",
    ["hu"]="Melléklet ",
    ["hy"]="Հավելված ",
    ["it"]="",
    ["ja"]="付録",
    ["kr"]="부록",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Додаток ",
    ["nb"]="Tillegg ",
    ["nl"]="",
    ["nn"]="Tillegg ",
    ["pl"]="Dodatek ",
    ["pt"]="Apendice ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Príloha ",
    ["sl"]="Dodatek ",
    ["sr"]="Додатак ",
    ["sr-latn"]="Dodatak ",
    ["sv"]="Bilaga ",
    ["tk"]="Goşmaça ",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["april"]={
   ["labels"]={
    ["af"]="april",
    ["ar"]="أبريل",
    ["ar-dz"]="أفريل",
    ["ar-sy"]="نيسان",
    ["be"]="красавіка",
    ["bg"]="април",
    ["ca"]="abril",
    ["cn"]="四月",
    ["cs"]="dubna",
    ["da"]="april",
    ["de"]="April",
    ["en"]="April",
    ["eo"]="Aprilo",
    ["es"]="abril",
    ["et"]="aprill",
    ["fa"]="آوریل",
    ["fi"]="huhtikuu",
    ["fr"]="avril",
    ["gr"]="Απρίλιος",
    ["hr"]="travnja",
    ["hu"]="április",
    ["hy"]="Ապրիլ",
    ["it"]="aprile",
    ["ja"]="4",
    ["kr"]="4",
    ["la"]="Aprilis",
    ["lt"]="balandžio",
    ["mk"]="април",
    ["nb"]="april",
    ["nl"]="april",
    ["nn"]="april",
    ["pl"]="kwietnia",
    ["pt"]="abril",
    ["ro"]="aprilie",
    ["ru"]="апреля",
    ["sk"]="apríla",
    ["sl"]="april",
    ["sr"]="aприл",
    ["sr-latn"]="april",
    ["sv"]="april",
    ["tk"]="aprel",
    ["tr"]="nisan",
    ["ua"]="квітня",
    ["vi"]="tháng tư",
   },
  },
  ["april:jalali"]={
   ["labels"]={
    ["ca"]="Tir",
    ["en"]="Tir",
    ["fa"]="تیر",
    ["hy"]="Տիր",
   },
  },
  ["april:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="апр.",
    ["ca"]="abr",
    ["cs"]="dub.",
    ["da"]="",
    ["de"]="Apr.",
    ["en"]="apr",
    ["eo"]="Apr.",
    ["es"]="abr.",
    ["et"]="apr",
    ["fi"]="",
    ["fr"]="avr.",
    ["gr"]="",
    ["hr"]="tra",
    ["hu"]="ápr.",
    ["hy"]="Ապր",
    ["it"]="",
    ["la"]="",
    ["lt"]="apr",
    ["mk"]="апр.",
    ["nb"]="april",
    ["nl"]="",
    ["nn"]="april",
    ["pl"]="kwi.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="apr.",
    ["sl"]="",
    ["sr"]="апр",
    ["sr-latn"]="apr",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["atpage"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="في صفحة ",
    ["ca"]="a la pagina ",
    ["cs"]="na straně ",
    ["da"]="på side ",
    ["de"]="auf Seite ",
    ["en"]="at page ",
    ["eo"]="je paĝo ",
    ["es"]="en la página ",
    ["et"]="leheküljel ",
    ["fa"]="در صفحه ",
    ["fi"]="sivulla ",
    ["fr"]="à la page ",
    ["gr"]="",
    ["hr"]="na stranici ",
    ["hu"]="oldal ",
    ["hy"]="էջում ",
    ["it"]="a pagina ",
    ["la"]="",
    ["lt"]="puslapyje ",
    ["mk"]="на страница ",
    ["nb"]="på side ",
    ["nl"]="op pagina ",
    ["nn"]="på side ",
    ["pl"]="na stronie ",
    ["pt"]="na pagina",
    ["ro"]="",
    ["ru"]="на странице ",
    ["sk"]="na strane ",
    ["sl"]="na strani ",
    ["sr"]="на страници ",
    ["sr-latn"]="na stranici ",
    ["sv"]="på sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="на сторінці ",
    ["vi"]="",
   },
  },
  ["august"]={
   ["labels"]={
    ["af"]="augustus",
    ["ar"]="أغسطس",
    ["ar-dz"]="أوت",
    ["ar-ma"]="غشت",
    ["ar-sy"]="آب",
    ["be"]="жнівня",
    ["bg"]="август",
    ["ca"]="agost",
    ["cn"]="八月",
    ["cs"]="srpna",
    ["da"]="august",
    ["de"]="August",
    ["en"]="August",
    ["eo"]="Aŭgusto",
    ["es"]="agosto",
    ["et"]="august",
    ["fa"]="اوت",
    ["fi"]="elokuu",
    ["fr"]="août",
    ["gr"]="Αύγουστος",
    ["hr"]="kolovoza",
    ["hu"]="augusztus",
    ["hy"]="Օգոստոս",
    ["it"]="agosto",
    ["ja"]="8",
    ["kr"]="8",
    ["la"]="Augustus",
    ["lt"]="rugpjūčio",
    ["mk"]="август",
    ["nb"]="august",
    ["nl"]="augustus",
    ["nn"]="august",
    ["pl"]="sierpnia",
    ["pt"]="agosto",
    ["ro"]="august",
    ["ru"]="августа",
    ["sk"]="augusta",
    ["sl"]="avgust",
    ["sr"]="август",
    ["sr-latn"]="avgust",
    ["sv"]="augusti",
    ["tk"]="awgust",
    ["tr"]="ağustos",
    ["ua"]="серпня",
    ["vi"]="tháng tám",
   },
  },
  ["august:jalali"]={
   ["labels"]={
    ["ca"]="Aban",
    ["en"]="Aban",
    ["fa"]="آبان",
    ["hy"]="Աբան",
   },
  },
  ["august:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="авг.",
    ["ca"]="ag",
    ["cs"]="srp.",
    ["da"]="",
    ["de"]="Aug.",
    ["en"]="aug",
    ["eo"]="Aŭg.",
    ["es"]="ago.",
    ["et"]="aug",
    ["fi"]="",
    ["fr"]="",
    ["gr"]="",
    ["hr"]="kol",
    ["hu"]="aug.",
    ["hy"]="Օգ",
    ["it"]="",
    ["la"]="",
    ["lt"]="aug",
    ["mk"]="авг.",
    ["nb"]="aug.",
    ["nl"]="",
    ["nn"]="aug.",
    ["pl"]="sier.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="aug.",
    ["sl"]="",
    ["sr"]="авг",
    ["sr-latn"]="avg",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["chapter"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Hoofstuk ",
    ["ar"]="باب ",
    ["be"]="Глава ",
    ["bg"]="Eпизод ",
    ["ca"]="Capítol ",
    ["cn"]={ "第 ", " 章" },
    ["cs"]="Kapitola ",
    ["da"]="",
    ["de"]="Kapitel ",
    ["en"]="Chapter ",
    ["eo"]="Ĉapitro ",
    ["es"]="Capítulo ",
    ["et"]="Peatükk ",
    ["fa"]="فصل ",
    ["fi"]="luku",
    ["fr"]="Chapitre ",
    ["gr"]="Κεφάλαιο ",
    ["hr"]="Poglavlje ",
    ["hu"]={ "", " fejezet" },
    ["hy"]="Գլուխ ",
    ["it"]="",
    ["ja"]={ "第", "章" },
    ["kr"]={ "제", "장" },
    ["la"]="",
    ["lt"]="",
    ["mk"]="Глава ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Rozdział ",
    ["pt"]="Capitulo ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Kapitola ",
    ["sl"]="Poglavje ",
    ["sr"]="Глава ",
    ["sr-latn"]="Glava ",
    ["sv"]="Kapitel ",
    ["tk"]="Bap ",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="Chương ",
   },
  },
  ["continued"]={
   ["labels"]={
    ["af"]="",
    ["be"]=" (працяг)",
    ["bg"]=" (продължение)",
    ["ca"]="continua",
    ["cs"]=" (pokračování)",
    ["da"]="",
    ["de"]=" (Fortsetzung)",
    ["en"]=" (continued)",
    ["eo"]=" (daŭrigota)",
    ["es"]=" (continúa)",
    ["et"]=" (jätkub)",
    ["fa"]="(ادامه دارد)",
    ["fi"]="(jatkuu)",
    ["fr"]="",
    ["gr"]="",
    ["hr"]=" (nastavak)",
    ["hu"]=" (folytatás)",
    ["hy"]=" (շարունակություն)",
    ["it"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]=" (продолжение)",
    ["nb"]="",
    ["nl"]=" (vervolgd)",
    ["nn"]="",
    ["pl"]="",
    ["pt"]=" (continua)",
    ["ro"]="",
    ["ru"]="",
    ["sk"]=" (pokračovanie)",
    ["sl"]="",
    ["sr"]=" (наставак)",
    ["sr-latn"]=" (nastavak)",
    ["sv"]=" (forts.)",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["day:genetiv"]={
   ["labels"]={
    ["cs"]="dne",
    ["sk"]="dňa",
   },
  },
  ["day"]={
   ["labels"]={
    ["bg"]="ден",
    ["ca"]="dia",
    ["cs"]="den",
    ["de"]="Tag",
    ["en"]="day",
    ["eo"]="tago",
    ["et"]="päev",
    ["fa"]="روز",
    ["fi"]="päivä",
    ["fr"]="jour",
    ["hy"]="օր",
    ["kr"]="일",
    ["mk"]="ден",
    ["nl"]="dag",
    ["pt"]="dia",
    ["sk"]="deň",
    ["sr"]="дан",
    ["sr-latn"]="dan",
    ["sv"]="dag",
   },
  },
  ["december"]={
   ["labels"]={
    ["af"]="desember",
    ["ar"]="ديسمبر",
    ["ar-ma"]="دجنبر",
    ["ar-sy"]="كانون الأول",
    ["be"]="снежня",
    ["bg"]="декември",
    ["ca"]="desembre",
    ["cn"]="十二月",
    ["cs"]="prosince",
    ["da"]="december",
    ["de"]="Dezember",
    ["en"]="December",
    ["eo"]="Decembro",
    ["es"]="diciembre",
    ["et"]="detsember",
    ["fa"]="دسامبر",
    ["fi"]="joulukuu",
    ["fr"]="décembre",
    ["gr"]="Δεκέμβριος",
    ["hr"]="prosinca",
    ["hu"]="december",
    ["hy"]="Դեկտեմբեր",
    ["it"]="dicembre",
    ["ja"]="12",
    ["kr"]="12",
    ["la"]="December",
    ["lt"]="gruodžio",
    ["mk"]="декември",
    ["nb"]="desember",
    ["nl"]="december",
    ["nn"]="desember",
    ["pl"]="grudnia",
    ["pt"]="dezembro",
    ["ro"]="decembrie",
    ["ru"]="декабря",
    ["sk"]="decembra",
    ["sl"]="december",
    ["sr"]="децембар",
    ["sr-latn"]="decembar",
    ["sv"]="december",
    ["tk"]="dekabr",
    ["tr"]="aralık",
    ["ua"]="грудня",
    ["vi"]="tháng mười hai",
   },
  },
  ["december:jalali"]={
   ["labels"]={
    ["ca"]="Esfand",
    ["en"]="Esfand",
    ["fa"]="اسفند",
    ["hy"]="Էսֆանդ",
   },
  },
  ["december:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="дек.",
    ["ca"]="des",
    ["cs"]="pros.",
    ["da"]="",
    ["de"]="Dez.",
    ["en"]="dec",
    ["eo"]="Dec.",
    ["es"]="dic.",
    ["et"]="dets",
    ["fi"]="",
    ["fr"]="déc.",
    ["gr"]="",
    ["hr"]="pro",
    ["hu"]="dec.",
    ["hy"]="Դեկ",
    ["it"]="",
    ["la"]="",
    ["lt"]="dec",
    ["mk"]="дек.",
    ["nb"]="des.",
    ["nl"]="",
    ["nn"]="des.",
    ["pl"]="gru.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="dec.",
    ["sl"]="",
    ["sr"]="дец",
    ["sr-latn"]="dec",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["february"]={
   ["labels"]={
    ["af"]="februarie",
    ["ar"]="فبراير",
    ["ar-dz"]="فيفري",
    ["ar-sy"]="شباط",
    ["be"]="лютага",
    ["bg"]="февруари",
    ["ca"]="febrer",
    ["cn"]="二月",
    ["cs"]="února",
    ["da"]="februar",
    ["de"]="Februar",
    ["en"]="February",
    ["eo"]="Februaro",
    ["es"]="febrero",
    ["et"]="veebruar",
    ["fa"]="فوریه",
    ["fi"]="helmikuu",
    ["fr"]="février",
    ["gr"]="Φεβρουάριος",
    ["hr"]="veljače",
    ["hu"]="február",
    ["hy"]="Պետրվար",
    ["it"]="febbraio",
    ["ja"]="2",
    ["kr"]="2",
    ["la"]="Februarius",
    ["lt"]="vasario",
    ["mk"]="февруари",
    ["nb"]="februar",
    ["nl"]="februari",
    ["nn"]="februar",
    ["pl"]="lutego",
    ["pt"]="fevereiro",
    ["ro"]="februarie",
    ["ru"]="февраля",
    ["sk"]="februára",
    ["sl"]="februar",
    ["sr"]="фебруар",
    ["sr-latn"]="februar",
    ["sv"]="februari",
    ["tk"]="fewral",
    ["tr"]="Şubat",
    ["ua"]="лютого",
    ["vi"]="tháng hai",
   },
  },
  ["february:jalali"]={
   ["labels"]={
    ["ca"]="Ordibehesht",
    ["en"]="Ordibehesht",
    ["fa"]="اردیبهشت",
    ["hy"]="Օրդիբեհեշթ",
   },
  },
  ["february:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="февр.",
    ["ca"]="febr",
    ["cs"]="ún.",
    ["da"]="",
    ["de"]="Feb.",
    ["en"]="feb",
    ["eo"]="Feb.",
    ["es"]="feb.",
    ["et"]="veebr",
    ["fi"]="",
    ["fr"]="fév.",
    ["gr"]="",
    ["hr"]="velj",
    ["hu"]="feb.",
    ["hy"]="Փետ",
    ["it"]="",
    ["la"]="",
    ["lt"]="feb",
    ["mk"]="фев.",
    ["nb"]="feb.",
    ["nl"]="",
    ["nn"]="feb.",
    ["pl"]="lut.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="feb.",
    ["sl"]="",
    ["sr"]="феб",
    ["sr-latn"]="feb",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["figure"]={
   ["labels"]={
    ["af"]="Figuur ",
    ["ar"]="شكل ",
    ["be"]="Малюнак ",
    ["bg"]="Фигура ",
    ["ca"]="Figura ",
    ["cn"]="图 ",
    ["cs"]="Obrázek ",
    ["da"]="Figur ",
    ["de"]="Abbildung ",
    ["en"]="Figure ",
    ["eo"]="Figuro ",
    ["es"]="Figura ",
    ["et"]="Joonis ",
    ["fa"]="شکل ",
    ["fi"]="Kuva ",
    ["fr"]="Figure ",
    ["gr"]="Σχήμα ",
    ["hr"]="Slika ",
    ["hu"]={ "", " ábra" },
    ["hy"]="Նկար ",
    ["it"]="Fig. ",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imago ",
    ["lt"]={ "", " pav." },
    ["mk"]="Слика ",
    ["nb"]="Figur ",
    ["nl"]="Figuur ",
    ["nn"]="Figur ",
    ["pl"]="Ilustracja ",
    ["pt"]="Figura ",
    ["ro"]="Figura ",
    ["ru"]="Рисунок ",
    ["sk"]="Obrázok ",
    ["sl"]="Slika ",
    ["sr"]="Слика ",
    ["sr-latn"]="Slika ",
    ["sv"]="Figur ",
    ["tk"]="Surat ",
    ["tr"]="Şekil ",
    ["ua"]="Малюнок ",
    ["vi"]="Hình ",
   },
  },
  ["following:plural"]={
   ["labels"]={
    ["cs"]="násl.",
    ["de"]="ff.",
    ["en"]="ff.",
    ["eo"]="sekvv",
    ["fr"]=hairspace .. "sqq",
    ["hy"]="ff.",
    ["pt"]="seg",
    ["sk"]="násl.",
    ["sv"]="ff.",
   },
  },
  ["following:singular"]={
   ["labels"]={
    ["cs"]="násl.",
    ["de"]="f.",
    ["en"]="f.",
    ["eo"]="sekv",
    ["fr"]=hairspace .. "sq",
    ["hy"]="f.",
    ["pt"]="seg",
    ["sk"]="násl.",
    ["sv"]="f.",
   },
  },
  ["followingpage"]={
   ["labels"]={
    ["ca"]="en la seguent pagina",
    ["cs"]="na následující straně",
    ["de"]="auf einer Folgeseite",
    ["en"]="on a following page",
    ["eo"]="je sekvanta paĝo",
    ["es"]="en la siguiente pagina",
    ["et"]="järgmisel leheküljel",
    ["fa"]="در صفحات آینده",
    ["fi"]="seuraavalla sivulla",
    ["fr"]="sur la page suivante",
    ["hy"]="Հաջորդ էջում",
    ["mk"]="на следната страница",
    ["nl"]="op een volgende bladzijde",
    ["pt"]="pagina seguinte",
    ["sk"]="na nasledujúcej strane",
    ["sr"]="на следећој страници",
    ["sr-latn"]="na sledećoj stranici",
    ["sv"]="på nästa sida",
   },
  },
  ["friday"]={
   ["labels"]={
    ["af"]="vrydag",
    ["ar"]="الجمعة",
    ["be"]="пятніца",
    ["bg"]="петък",
    ["ca"]="divendres",
    ["cn"]="星期五",
    ["cs"]="pátek",
    ["da"]="fredag",
    ["de"]="Freitag",
    ["en"]="Friday",
    ["eo"]="vendredo",
    ["es"]="viernes",
    ["et"]="reede",
    ["fa"]="جمعه",
    ["fi"]="perjantai",
    ["fr"]="vendredi",
    ["gr"]="Παρασκευή",
    ["hr"]="petak",
    ["hu"]="péntek",
    ["hy"]="ուրբաթ",
    ["it"]="venerdì",
    ["ja"]="金曜日",
    ["kr"]="금요일",
    ["la"]="Dies Veneris",
    ["lt"]="penktadienis",
    ["mk"]="петок",
    ["nb"]="fredag",
    ["nl"]="vrijdag",
    ["nn"]="fredag",
    ["pl"]="piątek",
    ["pt"]="sexta-feira",
    ["ro"]="vineri",
    ["ru"]="пятница",
    ["sk"]="piatok",
    ["sl"]="petek",
    ["sr"]="петак",
    ["sr-latn"]="petak",
    ["sv"]="fredag",
    ["tk"]="bäşinji gün",
    ["tr"]="cuma",
    ["ua"]="п'ятниця",
    ["vi"]="thứ sáu",
   },
  },
  ["friday:mnem"]={
   ["labels"]={
    ["bg"]="пт",
    ["ca"]="dv",
    ["cs"]="pá",
    ["de"]="Fr.",
    ["en"]="fri",
    ["eo"]="ven.",
    ["es"]="vi",
    ["fi"]="pe",
    ["fr"]="ven.",
    ["hy"]="Ուրբ",
    ["sk"]="pi",
    ["sr"]="пет",
    ["sr-latn"]="pet",
   },
  },
  ["graphic"]={
   ["labels"]={
    ["af"]="Grafiek ",
    ["ar"]="رسم ",
    ["be"]="Графіка ",
    ["bg"]="Графичен ",
    ["ca"]="Gràfica ",
    ["cn"]="插图 ",
    ["cs"]="Graf ",
    ["da"]="Grafik ",
    ["de"]="Grafik ",
    ["en"]="Graphic ",
    ["eo"]="Grafiko ",
    ["es"]="Gráfico ",
    ["et"]="Pilt ",
    ["fa"]="طرح ",
    ["fi"]="Grafiikka ",
    ["fr"]="Illustration ",
    ["gr"]="Γραφικό ",
    ["hr"]="Slika ",
    ["hu"]={ "", " kép" },
    ["hy"]="Գրաֆ ",
    ["it"]="Grafico ",
    ["ja"]="イラスト",
    ["la"]="Typus ",
    ["lt"]="Graphic ",
    ["mk"]="График ",
    ["nb"]="Bilde ",
    ["nl"]="Grafiek ",
    ["nn"]="Bilete ",
    ["pl"]="Grafika ",
    ["pt"]="Gráfico ",
    ["ro"]="Graficul ",
    ["ru"]="График ",
    ["sk"]="Graf ",
    ["sl"]="Slika ",
    ["sr"]="График ",
    ["sr-latn"]="Grafik ",
    ["sv"]="Grafik ",
    ["tk"]="Grafik ",
    ["tr"]="Grafik ",
    ["ua"]="График ",
    ["vi"]="Đồ thị ",
   },
  },
  ["hencefore"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما وضحنا سابقا",
    ["be"]="гл. вышэй",
    ["bg"]="виж по-горе",
    ["ca"]="com es mostra dalt",
    ["cs"]="viz výše",
    ["da"]="se foroven",
    ["de"]="siehe oben",
    ["en"]="as we show above",
    ["eo"]="laŭsupre",
    ["es"]="como se muestra arriba",
    ["et"]="nii nagu üleval näidatud",
    ["fa"]="چنان‌که شرح دادیم",
    ["fi"]="kuten yllä näytämme",
    ["fr"]="ci-dessus",
    ["gr"]="",
    ["hr"]="vidi gore",
    ["hu"]="lásd feljebb",
    ["hy"]="ստորև նշված",
    ["it"]="come mostrato sopra",
    ["kr"]="그러므로",
    ["la"]="",
    ["lt"]="kaip parodyta aukščiau",
    ["mk"]="како што е прикажано погоре",
    ["nb"]="som vist over",
    ["nl"]="hierboven",
    ["nn"]="som vist over",
    ["pl"]="jak pokazano wyżej",
    ["pt"]="como mostrado em cima",
    ["ro"]="",
    ["ru"]="см. выше",
    ["sk"]="pozri hore",
    ["sl"]="glej zgoraj",
    ["sr"]="као што је показано изнад",
    ["sr-latn"]="kao što je pokazano iznad",
    ["sv"]="se ovan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано вище",
    ["vi"]="",
   },
  },
  ["hereafter"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="كما نوضح لاحقا",
    ["be"]="гл. ніжэй",
    ["bg"]="ў далейшым",
    ["ca"]="com es mostra baix",
    ["cs"]="viz níže",
    ["da"]="se forneden",
    ["de"]="siehe unten",
    ["en"]="as we show below",
    ["eo"]="laŭsube",
    ["es"]="como se muestra abajo",
    ["et"]="nii nagu all näidatud",
    ["fa"]="چنان‌که شرح خواهیم داد",
    ["fi"]="kuten alla näytämme",
    ["fr"]="ci-dessous",
    ["gr"]="",
    ["hr"]="vidi ispod",
    ["hu"]="lásd lejjebb",
    ["hy"]="ինչպես ցույց է տրված ստորև",
    ["it"]="come mostrato sotto",
    ["kr"]="이후로",
    ["la"]="",
    ["lt"]="kaip parodyta žemiau",
    ["mk"]="како што е прикажано подолу",
    ["nb"]="som vist under",
    ["nl"]="hieronder",
    ["nn"]="som vist under",
    ["pl"]="jak pokazano niżej",
    ["pt"]="como mostrado em baixo",
    ["ro"]="",
    ["ru"]="см. ниже",
    ["sk"]="pozri ďalej",
    ["sl"]="glej spodaj",
    ["sr"]="као што је показано ниже",
    ["sr-latn"]="kao što je pokazano niže",
    ["sv"]="se nedan",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="як показано нижче",
    ["vi"]="",
   },
  },
  ["intermezzo"]={
   ["labels"]={
    ["af"]="Intermezzo ",
    ["ar"]="فسحة ",
    ["be"]="Інтэрмецца ",
    ["bg"]="Интермецо ",
    ["ca"]="Intermedi ",
    ["cn"]="퉣 ",
    ["cs"]="Intermezzo ",
    ["da"]="Intermezzo ",
    ["de"]="Intermezzo ",
    ["en"]="Intermezzo ",
    ["eo"]="Intermezo ",
    ["es"]="Intermedio ",
    ["et"]="Vahemäng ",
    ["fi"]="Intermezzo ",
    ["fr"]="Intermède ",
    ["gr"]="Παύση ",
    ["hr"]="Intermeco ",
    ["hu"]={ "", " intermezzo" },
    ["hy"]="Ինտերմեցո ",
    ["it"]="Intermezzo ",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissum ",
    ["lt"]="Intermezzo ",
    ["mk"]="Дигресија ",
    ["nb"]="Intermesso ",
    ["nl"]="Intermezzo ",
    ["nn"]="Intermesso ",
    ["pl"]="Intermezzo ",
    ["pt"]="Intermédio ",
    ["ro"]="Intermezzo ",
    ["ru"]="Вставка ",
    ["sk"]="Intermezzo ",
    ["sl"]="Intermezzo ",
    ["sr"]="Дигресија ",
    ["sr-latn"]="Digresija ",
    ["sv"]="Intermezzo ",
    ["tk"]="Arakesme ",
    ["tr"]="",
    ["ua"]="Вставка ",
    ["vi"]="Intermezzo ",
   },
  },
  ["january"]={
   ["labels"]={
    ["af"]="januarie",
    ["ar"]="يناير",
    ["ar-dz"]="جانفي",
    ["ar-sy"]="كانون الثاني",
    ["be"]="студзеня",
    ["bg"]="януари",
    ["ca"]="gener",
    ["cn"]="一月",
    ["cs"]="ledna",
    ["da"]="januar",
    ["de"]="Januar",
    ["en"]="January",
    ["eo"]="Januaro",
    ["es"]="enero",
    ["et"]="jaanuar",
    ["fa"]="ژانویه",
    ["fi"]="tammikuu",
    ["fr"]="janvier",
    ["gr"]="Ιανουάριος",
    ["hr"]="siječnja",
    ["hu"]="január",
    ["hy"]="Հունվար",
    ["it"]="gennaio",
    ["ja"]="1",
    ["kr"]="1",
    ["la"]="Ianuarius",
    ["lt"]="sausio",
    ["mk"]="јануари",
    ["nb"]="januar",
    ["nl"]="januari",
    ["nn"]="januar",
    ["pl"]="stycznia",
    ["pt"]="janeiro",
    ["ro"]="ianuarie",
    ["ru"]="января",
    ["sk"]="januára",
    ["sl"]="januar",
    ["sr"]="јануар",
    ["sr-latn"]="januar",
    ["sv"]="januari",
    ["tk"]="ýanwar",
    ["tr"]="ocak",
    ["ua"]="січня",
    ["vi"]="tháng giêng",
   },
  },
  ["january:jalali"]={
   ["labels"]={
    ["ca"]="Farvardin",
    ["en"]="Farvardin",
    ["es"]="Farvardin",
    ["fa"]="فروردین",
    ["hy"]="Ֆարվարդին",
   },
  },
  ["january:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ян.",
    ["ca"]="gen",
    ["cs"]="led.",
    ["da"]="",
    ["de"]="Jan.",
    ["en"]="jan",
    ["eo"]="Jan.",
    ["es"]="ene.",
    ["et"]="jaan",
    ["fi"]="",
    ["fr"]="jan.",
    ["gr"]="",
    ["hr"]="sij",
    ["hu"]="jan.",
    ["hy"]="Հունվ",
    ["it"]="",
    ["la"]="",
    ["lt"]="jan",
    ["mk"]="jан.",
    ["nb"]="jan.",
    ["nl"]="",
    ["nn"]="jan.",
    ["pl"]="sty.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="jan.",
    ["sl"]="",
    ["sr"]="јан",
    ["sr-latn"]="jan",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["july"]={
   ["labels"]={
    ["af"]="julie",
    ["ar"]="يوليو",
    ["ar-dz"]="جويلة",
    ["ar-ma"]="يوليوز",
    ["ar-sy"]="تموز",
    ["be"]="ліпня",
    ["bg"]="юли",
    ["ca"]="juliol",
    ["cn"]="七月",
    ["cs"]="července",
    ["da"]="juli",
    ["de"]="Juli",
    ["en"]="July",
    ["eo"]="Julio",
    ["es"]="julio",
    ["et"]="juuli",
    ["fa"]="ژوئیه",
    ["fi"]="heinäkuu",
    ["fr"]="juillet",
    ["gr"]="Ιούλιος",
    ["hr"]="srpnja",
    ["hu"]="július",
    ["hy"]="Հուլիս",
    ["it"]="luglio",
    ["ja"]="7",
    ["kr"]="7",
    ["la"]="Iulius",
    ["lt"]="liepos",
    ["mk"]="јули",
    ["nb"]="juli",
    ["nl"]="juli",
    ["nn"]="juli",
    ["pl"]="lipca",
    ["pt"]="julho",
    ["ro"]="iulie",
    ["ru"]="июля",
    ["sk"]="júla",
    ["sl"]="julij",
    ["sr"]="jул",
    ["sr-latn"]="jul",
    ["sv"]="juli",
    ["tk"]="iýul",
    ["tr"]="temmuz",
    ["ua"]="липня",
    ["vi"]="tháng bảy",
   },
  },
  ["july:jalali"]={
   ["labels"]={
    ["ca"]="Mehr",
    ["en"]="Mehr",
    ["es"]="Mehr",
    ["fa"]="مهر",
    ["hy"]="Մեհր",
   },
  },
  ["july:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юли",
    ["ca"]="jul",
    ["cs"]="čce",
    ["da"]="",
    ["de"]="Jul.",
    ["en"]="jul",
    ["eo"]="Jul.",
    ["es"]="jul.",
    ["et"]="juuli",
    ["fi"]="",
    ["fr"]="juill.",
    ["gr"]="",
    ["hr"]="srp",
    ["hu"]="júl.",
    ["hy"]="Հուլ",
    ["it"]="",
    ["la"]="",
    ["lt"]="jul",
    ["mk"]="јул.",
    ["nb"]="juli",
    ["nl"]="",
    ["nn"]="juli",
    ["pl"]="lip.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="júla",
    ["sl"]="",
    ["sr"]="јул",
    ["sr-latn"]="jul",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["june"]={
   ["labels"]={
    ["af"]="junie",
    ["ar"]="يونيو",
    ["ar-dz"]="جوان",
    ["ar-sy"]="حزيران",
    ["be"]="чэрвня",
    ["bg"]="юни",
    ["ca"]="juny",
    ["cn"]="六月",
    ["cs"]="června",
    ["da"]="juni",
    ["de"]="Juni",
    ["en"]="June",
    ["eo"]="Junio",
    ["es"]="junio",
    ["et"]="juuni",
    ["fa"]="ژوئن",
    ["fi"]="kesäkuu",
    ["fr"]="juin",
    ["gr"]="Ιούνιος",
    ["hr"]="lipnja",
    ["hu"]="június",
    ["hy"]="Հունիսի",
    ["it"]="giugno",
    ["ja"]="6",
    ["kr"]="6",
    ["la"]="Iunius",
    ["lt"]="birželio",
    ["mk"]="јуни",
    ["nb"]="juni",
    ["nl"]="juni",
    ["nn"]="juni",
    ["pl"]="czerwca",
    ["pt"]="junho",
    ["ro"]="iunie",
    ["ru"]="июня",
    ["sk"]="júna",
    ["sl"]="junij",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="juni",
    ["tk"]="iýun",
    ["tr"]="haziran",
    ["ua"]="червня",
    ["vi"]="tháng sáu",
   },
  },
  ["june:jalali"]={
   ["labels"]={
    ["ca"]="Shahrivar",
    ["en"]="Shahrivar",
    ["es"]="Shahrivar",
    ["fa"]="شهریور",
    ["hy"]="Շահրիվար",
   },
  },
  ["june:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="юни",
    ["ca"]="juny",
    ["cs"]="čer.",
    ["da"]="",
    ["de"]="Jun.",
    ["en"]="jun",
    ["eo"]="Jun.",
    ["es"]="jun.",
    ["et"]="juuni",
    ["fi"]="",
    ["fr"]="juin",
    ["gr"]="",
    ["hr"]="lip",
    ["hu"]="jún.",
    ["hy"]="Հուն",
    ["it"]="",
    ["la"]="",
    ["lt"]="jun",
    ["mk"]="јун.",
    ["nb"]="juni",
    ["nl"]="",
    ["nn"]="juni",
    ["pl"]="czerw.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="júna",
    ["sl"]="",
    ["sr"]="јун",
    ["sr-latn"]="jun",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["line"]={
   ["labels"]={
    ["af"]="reël ",
    ["ar"]="سطر ",
    ["be"]="радок ",
    ["bg"]="ред ",
    ["ca"]="línia ",
    ["cn"]="行 ",
    ["cs"]="řádek ",
    ["da"]="linie ",
    ["de"]="Zeile ",
    ["en"]="line ",
    ["eo"]="linio ",
    ["es"]="línea ",
    ["et"]="joon ",
    ["fa"]="سطر ",
    ["fi"]="rivi ",
    ["fr"]="ligne ",
    ["gr"]="Γραμμή ",
    ["hr"]="redak ",
    ["hu"]={ "", " sor" },
    ["hy"]="Տող ",
    ["it"]="riga ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="line ",
    ["mk"]="линија ",
    ["nb"]="linje ",
    ["nl"]="regel ",
    ["nn"]="linje ",
    ["pl"]="wiersz ",
    ["pt"]="linha ",
    ["ro"]="linia ",
    ["ru"]="строка ",
    ["sk"]="riadok ",
    ["sl"]="vrstica ",
    ["sr"]="линија ",
    ["sr-latn"]="linija ",
    ["sv"]="rad ",
    ["tk"]="setir ",
    ["tr"]="satır ",
    ["ua"]="рядок ",
    ["vi"]="dòng ",
   },
  },
  ["lines"]={
   ["labels"]={
    ["af"]="reëls ",
    ["ar"]="السطور ",
    ["be"]="радкi ",
    ["bg"]="редове ",
    ["ca"]="línies ",
    ["cn"]="行 ",
    ["cs"]="řádky ",
    ["da"]="linier ",
    ["de"]="Zeilen ",
    ["en"]="lines ",
    ["eo"]="linioj ",
    ["es"]="líneas ",
    ["et"]="jooned ",
    ["fa"]="سطرهای ",
    ["fi"]="rivie ",
    ["fr"]="lignes ",
    ["gr"]="Γραμμές ",
    ["hr"]="retci ",
    ["hu"]="sorok ",
    ["hy"]="Տողեր ",
    ["it"]="righe ",
    ["ja"]="線",
    ["kr"]="행",
    ["la"]="versus ",
    ["lt"]="lines ",
    ["mk"]="линии ",
    ["nb"]="linjer ",
    ["nl"]="regels ",
    ["nn"]="linjer ",
    ["pl"]="wiersze ",
    ["pt"]="linhas ",
    ["ro"]="liniile ",
    ["ru"]="строки ",
    ["sk"]="riadky ",
    ["sl"]="vrstice ",
    ["sr"]="линије ",
    ["sr-latn"]="linije ",
    ["sv"]="rader ",
    ["tk"]="setirler ",
    ["tr"]="satırlar ",
    ["ua"]="рядки ",
    ["vi"]="dòng ",
   },
  },
  ["march"]={
   ["labels"]={
    ["af"]="maart",
    ["ar"]="مارس",
    ["ar-sy"]="آذار",
    ["be"]="сакавіка",
    ["bg"]="март",
    ["ca"]="març",
    ["cn"]="三月",
    ["cs"]="března",
    ["da"]="marts",
    ["de"]="März",
    ["en"]="March",
    ["eo"]="Marto",
    ["es"]="marzo",
    ["et"]="märts",
    ["fa"]="مارس",
    ["fi"]="maaliskuu",
    ["fr"]="mars",
    ["gr"]="Μάρτιος",
    ["hr"]="ožujka",
    ["hu"]="március",
    ["hy"]="Մարտ",
    ["it"]="marzo",
    ["ja"]="3",
    ["kr"]="3",
    ["la"]="Martius",
    ["lt"]="kovo",
    ["mk"]="март",
    ["nb"]="mars",
    ["nl"]="maart",
    ["nn"]="mars",
    ["pl"]="marca",
    ["pt"]="março",
    ["ro"]="martie",
    ["ru"]="марта",
    ["sk"]="marca",
    ["sl"]="marec",
    ["sr"]="март",
    ["sr-latn"]="mart",
    ["sv"]="mars",
    ["tk"]="mart",
    ["tr"]="mart",
    ["ua"]="березня",
    ["vi"]="tháng ba",
   },
  },
  ["march:jalali"]={
   ["labels"]={
    ["ca"]="Jordad",
    ["en"]="Khordad",
    ["es"]="Khordad",
    ["fa"]="خرداد",
    ["hy"]="Խորդադ",
   },
  },
  ["march:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="март",
    ["ca"]="març",
    ["cs"]="břez.",
    ["da"]="",
    ["de"]="Mrz.",
    ["en"]="mar",
    ["eo"]="Mar.",
    ["es"]="mar.",
    ["et"]="märts",
    ["fi"]="",
    ["fr"]="mars",
    ["gr"]="",
    ["hr"]="ožu",
    ["hu"]="már.",
    ["hy"]="Մարտ",
    ["it"]="",
    ["la"]="",
    ["lt"]="mar",
    ["mk"]="мар.",
    ["nb"]="mars",
    ["nl"]="",
    ["nn"]="mars",
    ["pl"]="mar.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="mar.",
    ["sl"]="",
    ["sr"]="мар",
    ["sr-latn"]="mar",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["may"]={
   ["labels"]={
    ["af"]="mei",
    ["ar"]="مايو",
    ["ar-dz"]="ماي",
    ["ar-ma"]="ماي",
    ["ar-sy"]="أيار",
    ["be"]="мая",
    ["bg"]="маӣ",
    ["ca"]="maig",
    ["cn"]="五月",
    ["cs"]="května",
    ["da"]="maj",
    ["de"]="Mai",
    ["en"]="May",
    ["eo"]="Majo",
    ["es"]="mayo",
    ["et"]="mai",
    ["fa"]="مه",
    ["fi"]="toukokuu",
    ["fr"]="mai",
    ["gr"]="Μάιος",
    ["hr"]="svibnja",
    ["hu"]="május",
    ["hy"]="Մայիս",
    ["it"]="maggio",
    ["ja"]="5",
    ["kr"]="5",
    ["la"]="Maius",
    ["lt"]="gegužės",
    ["mk"]="мај",
    ["nb"]="mai",
    ["nl"]="mei",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="maio",
    ["ro"]="mai",
    ["ru"]="мая",
    ["sk"]="mája",
    ["sl"]="maj",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="maj",
    ["tk"]="maý",
    ["tr"]="mayıs",
    ["ua"]="травня",
    ["vi"]="tháng năm",
   },
  },
  ["may:jalali"]={
   ["labels"]={
    ["ca"]="Mordad",
    ["en"]="Mordad",
    ["es"]="Mordad",
    ["fa"]="مرداد",
    ["hy"]="Մորդադ",
   },
  },
  ["may:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="май",
    ["ca"]="maig",
    ["cs"]="květ.",
    ["da"]="",
    ["de"]="Mai",
    ["en"]="may",
    ["eo"]="Maj.",
    ["es"]="may.",
    ["et"]="mai",
    ["fi"]="",
    ["fr"]="mai",
    ["gr"]="",
    ["hr"]="svi",
    ["hu"]="máj.",
    ["hy"]="Մայ",
    ["it"]="",
    ["la"]="",
    ["lt"]="may",
    ["mk"]="мај",
    ["nb"]="mai",
    ["nl"]="",
    ["nn"]="mai",
    ["pl"]="maja",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="mája",
    ["sl"]="",
    ["sr"]="мај",
    ["sr-latn"]="maj",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["monday"]={
   ["labels"]={
    ["af"]="maandag",
    ["ar"]="الاثنين",
    ["be"]="панядзелак",
    ["bg"]="понеделник",
    ["ca"]="dilluns",
    ["cn"]="星期一",
    ["cs"]="pondělí",
    ["da"]="mandag",
    ["de"]="Montag",
    ["en"]="Monday",
    ["eo"]="lundo",
    ["es"]="lunes",
    ["et"]="esmaspäev",
    ["fa"]="دوشنبه",
    ["fi"]="maanantai",
    ["fr"]="lundi",
    ["gr"]="Δευτέρα",
    ["hr"]="ponedjeljak",
    ["hu"]="hétfő",
    ["hy"]="երկուշաբթի",
    ["it"]="lunedì",
    ["ja"]="月曜日",
    ["kr"]="월요일",
    ["la"]="Dies Lunae",
    ["lt"]="pirmadienis",
    ["mk"]="понеделник",
    ["nb"]="mandag",
    ["nl"]="maandag",
    ["nn"]="måndag",
    ["pl"]="poniedziałek",
    ["pt"]="segunda-feira",
    ["ro"]="luni",
    ["ru"]="понедельник",
    ["sk"]="pondelok",
    ["sl"]="ponedeljek",
    ["sr"]="понедељак",
    ["sr-latn"]="ponedeljak",
    ["sv"]="måndag",
    ["tk"]="birinji gün",
    ["tr"]="pazartesi",
    ["ua"]="понеділок",
    ["vi"]="thứ hai",
   },
  },
  ["monday:mnem"]={
   ["labels"]={
    ["bg"]="пн",
    ["ca"]="dl",
    ["cs"]="po",
    ["de"]="Mo.",
    ["en"]="mon",
    ["eo"]="lun.",
    ["es"]="lu",
    ["fi"]="ma",
    ["fr"]="lun.",
    ["hy"]="Երկ",
    ["sk"]="po",
    ["sr"]="пон",
    ["sr-latn"]="pon",
   },
  },
  ["month"]={
   ["labels"]={
    ["be"]="месяц",
    ["bg"]="месец",
    ["ca"]="mes",
    ["cs"]="měsíc",
    ["de"]="Monat",
    ["en"]="month",
    ["eo"]="monato",
    ["es"]="mes",
    ["et"]="kuu",
    ["fa"]="ماه",
    ["fi"]="kuukausi",
    ["fr"]="mois",
    ["hy"]="ամիս",
    ["kr"]="월",
    ["mk"]="месец",
    ["nl"]="maand",
    ["pt"]="mes",
    ["sk"]="mesiac",
    ["sr"]="месец",
    ["sr-latn"]="mesec",
    ["sv"]="månad",
   },
  },
  ["november"]={
   ["labels"]={
    ["af"]="november",
    ["ar"]="نوفمبر",
    ["ar-ma"]="نونبر",
    ["ar-sy"]="تشرين الثاني",
    ["be"]="лістапада",
    ["bg"]="ноември",
    ["ca"]="novembre",
    ["cn"]="十一月",
    ["cs"]="listopadu",
    ["da"]="november",
    ["de"]="November",
    ["en"]="November",
    ["eo"]="Novembro",
    ["es"]="noviembre",
    ["et"]="november",
    ["fa"]="نوامبر",
    ["fi"]="marraskuu",
    ["fr"]="novembre",
    ["gr"]="Νοέμβριος",
    ["hr"]="studenog",
    ["hu"]="november",
    ["hy"]="Նոյեմբեր",
    ["it"]="novembre",
    ["ja"]="11",
    ["kr"]="11",
    ["la"]="November",
    ["lt"]="lapkričio",
    ["mk"]="ноември",
    ["nb"]="november",
    ["nl"]="november",
    ["nn"]="november",
    ["pl"]="listopada",
    ["pt"]="novembro",
    ["ro"]="noiembrie",
    ["ru"]="ноября",
    ["sk"]="novembra",
    ["sl"]="november",
    ["sr"]="новембар",
    ["sr-latn"]="novembar",
    ["sv"]="november",
    ["tk"]="noýabr",
    ["tr"]="kasım",
    ["ua"]="листопада",
    ["vi"]="tháng mười một",
   },
  },
  ["november:jalali"]={
   ["labels"]={
    ["ca"]="Bahman",
    ["en"]="Bahman",
    ["es"]="Bahman",
    ["fa"]="بهمن",
    ["hy"]="Բահման",
   },
  },
  ["november:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="ноем.",
    ["ca"]="nov",
    ["cs"]="list.",
    ["da"]="",
    ["de"]="Nov.",
    ["en"]="nov",
    ["eo"]="Nov.",
    ["es"]="nov.",
    ["et"]="nov",
    ["fi"]="",
    ["fr"]="nov.",
    ["gr"]="",
    ["hr"]="stu",
    ["hu"]="nov.",
    ["hy"]="Նոյ",
    ["it"]="",
    ["la"]="",
    ["lt"]="nov",
    ["mk"]="ноем.",
    ["nb"]="nov.",
    ["nl"]="",
    ["nn"]="nov.",
    ["pl"]="lis.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="nov.",
    ["sl"]="",
    ["sr"]="нов",
    ["sr-latn"]="nov",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["october"]={
   ["labels"]={
    ["af"]="oktober",
    ["ar"]="أكتوبر",
    ["ar-sy"]="تشرين الأول",
    ["be"]="кастрычніка",
    ["bg"]="октомври",
    ["ca"]="octubre",
    ["cn"]="十月",
    ["cs"]="října",
    ["da"]="oktober",
    ["de"]="Oktober",
    ["en"]="October",
    ["eo"]="Oktobro",
    ["es"]="octubre",
    ["et"]="oktoober",
    ["fa"]="اکتبر",
    ["fi"]="lokakuu",
    ["fr"]="octobre",
    ["gr"]="Οκτώβριος",
    ["hr"]="listopada",
    ["hu"]="október",
    ["hy"]="հոկտեմբեր",
    ["it"]="ottobre",
    ["ja"]="10",
    ["kr"]="10",
    ["la"]="October",
    ["lt"]="spalio",
    ["mk"]="октомври",
    ["nb"]="oktober",
    ["nl"]="oktober",
    ["nn"]="oktober",
    ["pl"]="października",
    ["pt"]="outubro",
    ["ro"]="octombrie",
    ["ru"]="октября",
    ["sk"]="októbra",
    ["sl"]="oktober",
    ["sr"]="октобар",
    ["sr-latn"]="oktobar",
    ["sv"]="oktober",
    ["tk"]="oktýabr",
    ["tr"]="ekim",
    ["ua"]="жовтня",
    ["vi"]="tháng mười",
   },
  },
  ["october:jalali"]={
   ["labels"]={
    ["ca"]="Dey",
    ["en"]="Dey",
    ["es"]="Dey",
    ["fa"]="دی",
    ["hy"]="Դեյ",
   },
  },
  ["october:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="окт.",
    ["ca"]="oct",
    ["cs"]="říj.",
    ["da"]="",
    ["de"]="Okt.",
    ["en"]="oct",
    ["eo"]="Okt.",
    ["es"]="oct.",
    ["et"]="okt",
    ["fi"]="",
    ["fr"]="oct.",
    ["gr"]="",
    ["hr"]="lis",
    ["hu"]="okt.",
    ["hy"]="Հոկ",
    ["it"]="",
    ["la"]="",
    ["lt"]="oct",
    ["mk"]="окт.",
    ["nb"]="okt.",
    ["nl"]="",
    ["nn"]="okt.",
    ["pl"]="paź.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="okt.",
    ["sl"]="",
    ["sr"]="окт",
    ["sr-latn"]="okt",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["page"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="صفحة ",
    ["be"]="старонка ",
    ["bg"]="страна ",
    ["ca"]="pagina ",
    ["cs"]="strana ",
    ["da"]="Side ",
    ["de"]="Seite ",
    ["en"]="page ",
    ["eo"]="paĝo ",
    ["es"]="página ",
    ["et"]="lehekülg ",
    ["fa"]="صفحه ",
    ["fi"]="Sivu ",
    ["fr"]="page ",
    ["gr"]="",
    ["hr"]="stranica ",
    ["hu"]="oldal ",
    ["hy"]="էջ ",
    ["it"]="pagina ",
    ["kr"]="쪽",
    ["la"]="",
    ["lt"]="puslapis ",
    ["mk"]="страница ",
    ["nb"]="side ",
    ["nl"]="pagina ",
    ["nn"]="side ",
    ["pl"]="strona ",
    ["pt"]="pagina ",
    ["ro"]="",
    ["ru"]="страница ",
    ["sk"]="strana ",
    ["sl"]="stran ",
    ["sr"]="страница ",
    ["sr-latn"]="stranica ",
    ["sv"]="Sida ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="сторінка ",
    ["vi"]="",
   },
  },
  ["part"]={
   ["labels"]={
    ["af"]="Deel ",
    ["ar"]="جزء ",
    ["be"]="Частка ",
    ["bg"]="Частка ",
    ["ca"]="Part ",
    ["cn"]={ "第 ", " 部分" },
    ["cs"]="Část ",
    ["da"]="Del ",
    ["de"]="Teil ",
    ["en"]="Part ",
    ["eo"]="Parto ",
    ["es"]="Parte ",
    ["et"]="Osa ",
    ["fa"]="قسمت ",
    ["fi"]="Osa ",
    ["fr"]="Partie ",
    ["gr"]="Μέρος ",
    ["hr"]="Dio ",
    ["hu"]={ "", " rész" },
    ["hy"]="Մաս ",
    ["it"]="Parte ",
    ["ja"]={ "第", "パート" },
    ["kr"]={ "제", "부" },
    ["la"]="Pars ",
    ["lt"]={ "", " dalis" },
    ["nb"]="Del ",
    ["nl"]="Deel ",
    ["nn"]="Del ",
    ["pl"]="Część ",
    ["pt"]="Parte ",
    ["ro"]="Partea ",
    ["ru"]="Часть ",
    ["sk"]="Časť ",
    ["sl"]="Del ",
    ["sr"]="Део ",
    ["sr-latn"]="Deo ",
    ["sv"]="Del ",
    ["tk"]="Bölüm ",
    ["tr"]="Cilt ",
    ["ua"]="Частина ",
    ["vi"]="Phần ",
   },
  },
  ["precedingpage"]={
   ["labels"]={
    ["comment"]=[[ "auf der vorigen Seite" ok, but not "auf einer vorigen Seite" ]],
    ["ca"]="en una pagina anterior",
    ["cs"]="na předchozí straně",
    ["de"]="oben",
    ["en"]="on a preceding page",
    ["eo"]="sur antaŭa paĝo",
    ["es"]="en la pagina anterior",
    ["et"]="eelmisel lehel",
    ["fa"]="در صفحات گذشته",
    ["fi"]="edellisellä sivulla",
    ["fr"]="sur la page précédente",
    ["hy"]="նախորդ էջ",
    ["mk"]="на претходната страница",
    ["nl"]="op een voorgaande bladzijde",
    ["pt"]="na seguinte pagina",
    ["sk"]="na predchádzajúcej strane",
    ["sr"]="на претходној страници",
    ["sr-latn"]="na prethodnoj stranici",
    ["sv"]="på föregående sida",
   },
  },
  ["saturday"]={
   ["labels"]={
    ["af"]="saterdag",
    ["ar"]="السبت",
    ["be"]="субота",
    ["bg"]="сряда",
    ["ca"]="dissabte",
    ["cn"]="星期六",
    ["cs"]="sobota",
    ["da"]="lørdag",
    ["de"]="Samstag",
    ["en"]="Saturday",
    ["eo"]="sabato",
    ["es"]="sábado",
    ["et"]="laupäev",
    ["fa"]="شنبه",
    ["fi"]="lauantai",
    ["fr"]="samedi",
    ["gr"]="Σάββατο",
    ["hr"]="subota",
    ["hu"]="szombat",
    ["hy"]="շաբաթ",
    ["it"]="sabato",
    ["ja"]="土曜日",
    ["kr"]="토요일",
    ["la"]="Dies Saturni",
    ["lt"]="šeštadienis",
    ["mk"]="сабота",
    ["nb"]="lørdag",
    ["nl"]="zaterdag",
    ["nn"]="laurdag",
    ["pl"]="sobota",
    ["pt"]="sábado",
    ["ro"]="sâmbătă",
    ["ru"]="суббота",
    ["sk"]="sobota",
    ["sl"]="sobota",
    ["sr"]="субота",
    ["sr-latn"]="subota",
    ["sv"]="lördag",
    ["tk"]="altynjy gün",
    ["tr"]="cumartesi",
    ["ua"]="субота",
    ["vi"]="thứ bảy",
   },
  },
  ["saturday:mnem"]={
   ["labels"]={
    ["bg"]="сб",
    ["cs"]="so",
    ["de"]="Sa.",
    ["en"]="sat",
    ["eo"]="sab.",
    ["es"]="sa",
    ["fi"]="La",
    ["fr"]="sam.",
    ["hy"]="Շաբ",
    ["sk"]="so",
    ["sr"]="суб",
    ["sr-latn"]="sub",
   },
  },
  ["section"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="Paragraaf ",
    ["ar"]="فصل ",
    ["bg"]="Cекция ",
    ["ca"]="Secció ",
    ["cn"]={ "第 ", " 节" },
    ["cs"]="Sekce ",
    ["da"]="",
    ["de"]="Abschnitt ",
    ["en"]="Section ",
    ["eo"]="Sekcio ",
    ["es"]="Sección ",
    ["et"]="jaos ",
    ["fa"]="بخش ",
    ["fi"]="Osio ",
    ["fr"]="Section ",
    ["gr"]="Ενότητα ",
    ["hr"]="Odjeljak ",
    ["hu"]="Fejezet ",
    ["hy"]="Բաժին ",
    ["it"]="",
    ["ja"]={ "第", "項" },
    ["kr"]={ "제", "절" },
    ["la"]="",
    ["lt"]="",
    ["mk"]="Поглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podrozdział ",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Sekcia ",
    ["sl"]="",
    ["sr"]="Одељак ",
    ["sr-latn"]="Odeljak ",
    ["sv"]="Avsnitt",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["see"]={
   ["labels"]={
    ["af"]="",
    ["ar"]="انظر ",
    ["be"]="гл. ",
    ["bg"]="погледни ",
    ["ca"]="vore ",
    ["cs"]="viz ",
    ["da"]="se ",
    ["de"]="siehe ",
    ["en"]="see ",
    ["eo"]="vidu ",
    ["es"]="ver: ",
    ["et"]="vaadake ",
    ["fa"]="نگاه کنید به ",
    ["fi"]="katso ",
    ["fr"]="cf. ",
    ["gr"]="",
    ["hr"]="vidi ",
    ["hu"]="lásd ",
    ["hy"]="Նայել ",
    ["it"]="cf. ",
    ["kr"]="",
    ["la"]="",
    ["lt"]="žiūrėti ",
    ["mk"]="види ",
    ["nb"]="se ",
    ["nl"]="zie ",
    ["nn"]="sjå ",
    ["pl"]="patrz ",
    ["pt"]="ver ",
    ["ro"]="",
    ["ru"]="см. ",
    ["sk"]="pozri ",
    ["sl"]="glej ",
    ["sr"]="види ",
    ["sr-latn"]="vidi ",
    ["sv"]="se ",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="див. ",
    ["vi"]="",
   },
  },
  ["september"]={
   ["labels"]={
    ["af"]="september",
    ["ar"]="سبتمبر",
    ["ar-ma"]="شتنبر",
    ["ar-sy"]="أيلول",
    ["be"]="верасня",
    ["bg"]="септември",
    ["ca"]="setembre",
    ["cn"]="九月",
    ["cs"]="září",
    ["da"]="september",
    ["de"]="September",
    ["en"]="September",
    ["eo"]="Septembro",
    ["es"]="septiembre",
    ["et"]="september",
    ["fa"]="سپتامبر",
    ["fi"]="syyskuu",
    ["fr"]="septembre",
    ["gr"]="Σεπτέμβριος",
    ["hr"]="rujna",
    ["hu"]="szeptember",
    ["hy"]="Սեպտեմբեր",
    ["it"]="settembre",
    ["ja"]="9",
    ["kr"]="9",
    ["la"]="September",
    ["lt"]="rugsėjo",
    ["mk"]="септември",
    ["nb"]="september",
    ["nl"]="september",
    ["nn"]="september",
    ["pl"]="września",
    ["pt"]="setembro",
    ["ro"]="septembrie",
    ["ru"]="сентября",
    ["sk"]="septembra",
    ["sl"]="september",
    ["sr"]="септембар",
    ["sr-latn"]="septembar",
    ["sv"]="september",
    ["tk"]="sentýabr",
    ["tr"]="eylül",
    ["ua"]="вересня",
    ["vi"]="tháng chín",
   },
  },
  ["september:jalali"]={
   ["labels"]={
    ["en"]="Azar",
    ["es"]="Azar",
    ["fa"]="آذر",
    ["hy"]="Ազար",
   },
  },
  ["september:mnem"]={
   ["labels"]={
    ["af"]="",
    ["bg"]="септ.",
    ["ca"]="set",
    ["cs"]="září",
    ["da"]="",
    ["de"]="Sep.",
    ["en"]="sep",
    ["eo"]="Sep.",
    ["es"]="sep.",
    ["et"]="sept",
    ["fi"]="",
    ["fr"]="sept.",
    ["gr"]="",
    ["hr"]="ruj",
    ["hu"]="szep.",
    ["hy"]="Սեպ",
    ["it"]="",
    ["la"]="",
    ["lt"]="sep",
    ["mk"]="септ.",
    ["nb"]="sep.",
    ["nl"]="",
    ["nn"]="sep.",
    ["pl"]="wrz.",
    ["pt"]="",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="sept.",
    ["sl"]="",
    ["sr"]="сеп.",
    ["sr-latn"]="sep.",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى ",
    ["bg"]="Подсекция ",
    ["ca"]="Subsecció ",
    ["cn"]="",
    ["cs"]="Podsekce ",
    ["da"]="",
    ["de"]="Unterabschnitt ",
    ["en"]="Subsection ",
    ["eo"]="Subsekcio ",
    ["es"]="Subsección ",
    ["et"]="alajaotis ",
    ["fa"]="زیربخش ",
    ["fi"]="Alajakso",
    ["fr"]="Soussection ",
    ["gr"]="Υπόενότητα ",
    ["hr"]="Pododjeljak ",
    ["hu"]="Alfejezet ",
    ["hy"]=" Ենթաբաժին ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="Podpodrozdział ",
    ["pt"]="Subsecçao ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podsekcia ",
    ["sl"]="",
    ["sr"]="Пододељак ",
    ["sr-latn"]="Pododeljak ",
    ["sv"]="Underavsnitt",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى ",
    ["bg"]="Подподсекция ",
    ["ca"]="Subsubsecció ",
    ["cn"]="",
    ["cs"]="Podpodsekce ",
    ["da"]="",
    ["de"]="Unterunterabschnitt ",
    ["en"]="Subsubsection ",
    ["eo"]="Subsubsekcio ",
    ["es"]="Subsubsección ",
    ["et"]="alamjaotis ",
    ["fa"]="زیرزیربخش ",
    ["fi"]="Alakohta ",
    ["fr"]="Soussoussection ",
    ["gr"]="",
    ["hr"]="Podpododjeljak ",
    ["hu"]="Al-alfejezet ",
    ["hy"]="Ենթաենթաբաժին ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="Subsubsecçao ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podpodsekcia ",
    ["sl"]="",
    ["sr"]="Подпододељак ",
    ["sr-latn"]="Podpododeljak ",
    ["sv"]="Underunderavsnitt",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["subsubsubsection"]={
   ["hidden"]=true,
   ["labels"]={
    ["af"]="",
    ["ar"]="فصل أدنى أدنى أدنى ",
    ["bg"]="Подподподсекция ",
    ["ca"]="Subsubsubsecció ",
    ["cn"]="",
    ["cs"]="Podpodpodsekce ",
    ["da"]="",
    ["de"]="Unterunterunterabschnitt ",
    ["en"]="Subsubsubsection ",
    ["eo"]="Subsubsubsekcio ",
    ["es"]="Subsubsubsección ",
    ["et"]="",
    ["fa"]="زیرزیرزیربخش ",
    ["fi"]="Ala-alakohta ",
    ["fr"]="Soussoussoussection ",
    ["gr"]="",
    ["hr"]="Podpodpododjeljak ",
    ["hu"]="Al-al-alfejezet ",
    ["hy"]="Ենթաենթաենթաբաժին ",
    ["it"]="",
    ["ja"]="",
    ["la"]="",
    ["lt"]="",
    ["mk"]="Подподподпоглавје ",
    ["nb"]="",
    ["nl"]="",
    ["nn"]="",
    ["pl"]="",
    ["pt"]="Subsubsubsecçao ",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Podpodpodsekcia ",
    ["sl"]="",
    ["sr"]="Подподпододељак ",
    ["sr-latn"]="Podpodpododeljak ",
    ["sv"]="",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["sunday"]={
   ["labels"]={
    ["af"]="sondag",
    ["ar"]="الأحد",
    ["be"]="нядзеля",
    ["bg"]="неделя",
    ["ca"]="diumenge",
    ["cn"]="星期日",
    ["cs"]="neděle",
    ["da"]="søndag",
    ["de"]="Sonntag",
    ["en"]="Sunday",
    ["eo"]="dimanĉo",
    ["es"]="domingo",
    ["et"]="pühapäev",
    ["fa"]="یکشنبه",
    ["fi"]="sunnuntai",
    ["fr"]="dimanche",
    ["gr"]="Κυριακή",
    ["hr"]="nedjelja",
    ["hu"]="vasárnap",
    ["hy"]="կիրակի",
    ["it"]="domenica",
    ["ja"]="日曜日",
    ["kr"]="일요일",
    ["la"]="Dies Solis",
    ["lt"]="sekmadienis",
    ["mk"]="недела",
    ["nb"]="søndag",
    ["nl"]="zondag",
    ["nn"]="sundag",
    ["pl"]="niedziela",
    ["pt"]="domingo",
    ["ro"]="duminică",
    ["ru"]="воскресенье",
    ["sk"]="nedeľa",
    ["sl"]="nedelja",
    ["sr"]="недеља",
    ["sr-latn"]="nedelja",
    ["sv"]="söndag",
    ["tk"]="dynç gün",
    ["tr"]="pazar",
    ["ua"]="неділя",
    ["vi"]="chủ nhật",
   },
  },
  ["sunday:mnem"]={
   ["labels"]={
    ["bg"]="нд",
    ["ca"]="dg",
    ["cs"]="ne",
    ["de"]="So.",
    ["en"]="sun",
    ["eo"]="dim.",
    ["es"]="do",
    ["fr"]="dim.",
    ["hy"]="Կիր",
    ["sk"]="ne",
    ["sr"]="нед",
    ["sr-latn"]="ned",
   },
  },
  ["table"]={
   ["labels"]={
    ["af"]="Tabel",
    ["ar"]="جدول ",
    ["be"]="Табліца ",
    ["bg"]="Таблица ",
    ["ca"]="Taula ",
    ["cn"]="表 ",
    ["cs"]="Tabulka ",
    ["da"]="Tabel ",
    ["de"]="Tabelle ",
    ["en"]="Table ",
    ["eo"]="Tabelo ",
    ["es"]="Tabla ",
    ["et"]="Tabel ",
    ["fa"]="جدول ",
    ["fi"]="Taulukko ",
    ["fr"]="Tableau ",
    ["gr"]="Πίνακας ",
    ["hr"]="Tablica ",
    ["hu"]={ "", " táblázat" },
    ["hy"]="Աղյուսակ ",
    ["it"]="Tabella ",
    ["ja"]="表",
    ["kr"]="표 ",
    ["la"]="Tabula ",
    ["lt"]={ "", " lentelė." },
    ["mk"]="Табела ",
    ["nb"]="Tabell ",
    ["nl"]="Tabel ",
    ["nn"]="Tabell ",
    ["pl"]="Tabela ",
    ["pt"]="Tabela ",
    ["ro"]="Tabelul ",
    ["ru"]="Таблица ",
    ["sk"]="Tabuľka ",
    ["sl"]="Tabela ",
    ["sr"]="Табела ",
    ["sr-latn"]="Tabela ",
    ["sv"]="Tabell ",
    ["tk"]="Tablisa ",
    ["tr"]="Tablo ",
    ["ua"]="Таблиця ",
    ["vi"]="Bảng ",
   },
  },
  ["thursday"]={
   ["labels"]={
    ["af"]="donderdag",
    ["ar"]="الخميس",
    ["be"]="чацвер",
    ["bg"]="четвъртък",
    ["ca"]="dijous",
    ["cn"]="星期四",
    ["cs"]="čtvrtek",
    ["da"]="torsdag",
    ["de"]="Donnerstag",
    ["en"]="Thursday",
    ["eo"]="ĵaŭdo",
    ["es"]="jueves",
    ["et"]="neljapäev",
    ["fa"]="پنج‌شنبه",
    ["fi"]="torstai",
    ["fr"]="jeudi",
    ["gr"]="Πέμπτη",
    ["hr"]="četvrtak",
    ["hu"]="csütörtök",
    ["hy"]="հինգշաբթի",
    ["it"]="giovedì",
    ["ja"]="木曜日",
    ["kr"]="목요일",
    ["la"]="Dies Iovis",
    ["lt"]="ketvirtadienis",
    ["mk"]="четврток",
    ["nb"]="torsdag",
    ["nl"]="donderdag",
    ["nn"]="torsdag",
    ["pl"]="czwartek",
    ["pt"]="quinta-feira",
    ["ro"]="joi",
    ["ru"]="четверг",
    ["sk"]="štvrtok",
    ["sl"]="četrtek",
    ["sr"]="четвртак",
    ["sr-latn"]="četvrtak",
    ["sv"]="torsdag",
    ["tk"]="dördünji gün",
    ["tr"]="perşembe",
    ["ua"]="четвер",
    ["vi"]="thứ năm",
   },
  },
  ["thursday:mnem"]={
   ["labels"]={
    ["bg"]="чт",
    ["ca"]="dj",
    ["cs"]="čt",
    ["de"]="Do.",
    ["en"]="thu",
    ["eo"]="ĵaŭ.",
    ["es"]="ju",
    ["fi"]="To",
    ["fr"]="jeu.",
    ["hy"]="Հնգ",
    ["sk"]="št",
    ["sr"]="чет",
    ["sr-latn"]="čet",
   },
  },
  ["tuesday"]={
   ["labels"]={
    ["af"]="dinsdag",
    ["ar"]="الثلاثاء",
    ["be"]="аўторак",
    ["bg"]="вторник",
    ["ca"]="dimarts",
    ["cn"]="星期二",
    ["cs"]="úterý",
    ["da"]="tirsdag",
    ["de"]="Dienstag",
    ["en"]="Tuesday",
    ["eo"]="mardo",
    ["es"]="martes",
    ["et"]="teisipäev",
    ["fa"]="سه‌شنبه",
    ["fi"]="tiistai",
    ["fr"]="mardi",
    ["gr"]="Τρίτη",
    ["hr"]="utorak",
    ["hu"]="kedd",
    ["hy"]="երեքշաբթի",
    ["it"]="martedì",
    ["ja"]="火曜日",
    ["kr"]="화요일",
    ["la"]="Dies Martis",
    ["lt"]="antradienis",
    ["mk"]="вторник",
    ["nb"]="tirsdag",
    ["nl"]="dinsdag",
    ["nn"]="tysdag",
    ["pl"]="wtorek",
    ["pt"]="terça-feira",
    ["ro"]="marți",
    ["ru"]="вторник",
    ["sk"]="utorok",
    ["sl"]="torek",
    ["sr"]="уторак",
    ["sr-latn"]="utorak",
    ["sv"]="tisdag",
    ["tk"]="ikinji gün",
    ["tr"]="salı",
    ["ua"]="вівторок",
    ["vi"]="thứ ba",
   },
  },
  ["tuesday:mnem"]={
   ["labels"]={
    ["bg"]="вт",
    ["ca"]="dm",
    ["cs"]="út",
    ["de"]="Di.",
    ["en"]="tue",
    ["eo"]="mar.",
    ["es"]="ma",
    ["fi"]="Ti",
    ["fr"]="mar.",
    ["hy"]="Երք",
    ["sk"]="út",
    ["sr"]="уто",
    ["sr-latn"]="uto",
   },
  },
  ["wednesday"]={
   ["labels"]={
    ["af"]="woensdag",
    ["ar"]="الأربعاء",
    ["be"]="серада",
    ["bg"]="сряда",
    ["ca"]="dimecres",
    ["cn"]="星期三",
    ["cs"]="středa",
    ["da"]="onsdag",
    ["de"]="Mittwoch",
    ["en"]="Wednesday",
    ["eo"]="merkredo",
    ["es"]="miércoles",
    ["et"]="kolmapäev",
    ["fa"]="چهارشنبه",
    ["fi"]="keskiviikko",
    ["fr"]="mercredi",
    ["gr"]="Τετάρτη",
    ["hr"]="srijeda",
    ["hu"]="szerda",
    ["hy"]="չորեքշաբթի",
    ["it"]="mercoledì",
    ["ja"]="水曜日",
    ["kr"]="수요일",
    ["la"]="Dies Mercuri",
    ["lt"]="trečiadienis",
    ["mk"]="среда",
    ["nb"]="onsdag",
    ["nl"]="woensdag",
    ["nn"]="onsdag",
    ["pl"]="środa",
    ["pt"]="quarta-feira",
    ["ro"]="miercuri",
    ["ru"]="среда",
    ["sk"]="streda",
    ["sl"]="sreda",
    ["sr"]="среда",
    ["sr-latn"]="sreda",
    ["sv"]="onsdag",
    ["tk"]="üçünji",
    ["tr"]="çarşamba",
    ["ua"]="середа",
    ["vi"]="thứ tư",
   },
  },
  ["wednesday:mnem"]={
   ["labels"]={
    ["bg"]="ср",
    ["ca"]="dim",
    ["cs"]="st",
    ["de"]="Mi.",
    ["en"]="wed",
    ["eo"]="mer.",
    ["es"]="mi",
    ["fi"]="Ke",
    ["fr"]="mer.",
    ["hy"]="չոր",
    ["sk"]="st",
    ["sr"]="сре",
    ["sr-latn"]="sre",
   },
  },
  ["year"]={
   ["labels"]={
    ["bg"]="година",
    ["ca"]="any",
    ["cs"]="rok",
    ["de"]="Jahr",
    ["en"]="year",
    ["eo"]="jaro",
    ["es"]="año",
    ["et"]="aasta",
    ["fa"]="سال",
    ["fi"]="Vuosi",
    ["fr"]="année",
    ["hy"]="Տարի",
    ["kr"]="년",
    ["mk"]="година",
    ["nl"]="jaar",
    ["pt"]="ano",
    ["sk"]="rok",
    ["sr"]="година",
    ["sr-latn"]="godina",
    ["sv"]="år",
   },
  },
 },
 ["titles"]={
  ["abbreviations"]={
   ["labels"]={
    ["af"]="Afkortings",
    ["ar"]="الاختصارات",
    ["be"]="Спіс скарачэнняў",
    ["bg"]="Съкращения",
    ["ca"]="Abreviacions",
    ["cn"]="缩略语",
    ["cs"]="Seznam zkratek",
    ["da"]="Forkortelser",
    ["de"]="Abkürzungen",
    ["en"]="Abbreviations",
    ["eo"]="Mallongigoj",
    ["es"]="Abreviaturas",
    ["et"]="Lühend",
    ["fa"]="نشانه‌های اختصاری",
    ["fi"]="Lyhennyksi",
    ["fr"]="Abréviations",
    ["gr"]="Συντομογραφίες",
    ["hr"]="Kratice",
    ["hu"]="Rövidítések",
    ["hy"]="Հապավումներ",
    ["it"]="Abbreviazioni",
    ["ja"]="略語",
    ["kr"]="약어",
    ["la"]="Notae",
    ["lt"]="Santrumpos",
    ["mk"]="Скратеници",
    ["nb"]="Forkortelser",
    ["nl"]="Afkortingen",
    ["nn"]="Forkortingar",
    ["pl"]="Wykaz skrótów",
    ["pt"]="Abreviaturas",
    ["ro"]="Abrevieri",
    ["ru"]="Список сокращений",
    ["sk"]="Zoznam skratiek",
    ["sl"]="Kratice",
    ["sr"]="Скраћенице",
    ["sr-latn"]="Skraćenice",
    ["sv"]="Förkortningar",
    ["tk"]="Gysgaltmalar",
    ["tr"]="Kısaltmalar",
    ["ua"]="Перелік скорочень",
    ["vi"]="Chữ viết tắt",
   },
  },
  ["content"]={
   ["labels"]={
    ["af"]="Inhoud",
    ["ar"]="المحتويات",
    ["be"]="Змест",
    ["bg"]="Съдържание",
    ["ca"]="Índex de continguts",
    ["cn"]="目录",
    ["cs"]="Obsah",
    ["da"]="Indhold",
    ["de"]="Inhalt",
    ["en"]="Contents",
    ["eo"]="Enhavo",
    ["es"]="Contenido",
    ["et"]="Sisu",
    ["fa"]="فهرست مطالب",
    ["fi"]="Sisällys",
    ["fr"]="Table des matières",
    ["gr"]="Περιεχόμενα",
    ["hr"]="Sadržaj",
    ["hu"]="Tartalom",
    ["hy"]="Բովանդակություն",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="목차",
    ["la"]="Quod in libro continetur",
    ["lt"]="Turinys",
    ["mk"]="Содржина",
    ["nb"]="Innhold",
    ["nl"]="Inhoud",
    ["nn"]="Innhald",
    ["pl"]="Spis treści",
    ["pt"]="Conteúdo",
    ["ro"]="Cuprins",
    ["ru"]="Содержание",
    ["sk"]="Obsah",
    ["sl"]="Kazalo",
    ["sr"]="Садржај",
    ["sr-latn"]="Sadržaj",
    ["sv"]="Innehåll",
    ["tk"]="Mazmuny",
    ["tr"]="Fihrist",
    ["ua"]="Зміст",
    ["vi"]="Mục lục",
   },
  },
  ["figures"]={
   ["labels"]={
    ["af"]="Figure",
    ["ar"]="الأشكال",
    ["be"]="Спіс ілюстрацый",
    ["ca"]="Figures",
    ["cn"]="图",
    ["cs"]="Seznam obrázků",
    ["da"]="Figurer",
    ["de"]="Abbildungen",
    ["en"]="Figures",
    ["eo"]="Figuroj",
    ["es"]="Figuras",
    ["et"]="Arvandmed",
    ["fa"]="فهرست اشکال",
    ["fi"]="Kuvi",
    ["fr"]="Figures",
    ["gr"]="Σχήματα",
    ["hr"]="Slike",
    ["hu"]="Ábrák",
    ["hy"]="Նկարազարդումներ",
    ["it"]="Figure",
    ["ja"]="図",
    ["kr"]="그림 ",
    ["la"]="Imagines",
    ["lt"]="Iliustracijos",
    ["mk"]="Листа на слики",
    ["nb"]="Figurer",
    ["nl"]="Figuren",
    ["nn"]="Figurar",
    ["pl"]="Ilustracje",
    ["pt"]="Figuras",
    ["ro"]="Figuri",
    ["ru"]="Список иллюстраций",
    ["sk"]="Zoznam obrázkov",
    ["sl"]="Slike",
    ["sr"]="Слике",
    ["sr-latn"]="Slike",
    ["sv"]="Figurer",
    ["tk"]="Suratlar",
    ["tr"]="Şekiller",
    ["ua"]="Перелік ілюстрацій",
    ["vi"]="Danh sách hình vẽ",
   },
  },
  ["graphics"]={
   ["labels"]={
    ["af"]="Grafieke",
    ["ar"]="الرسوم",
    ["be"]="Графiка",
    ["bg"]="Графики",
    ["ca"]="Gràfiques",
    ["cn"]="图",
    ["cs"]="Seznam grafů",
    ["da"]="Grafik",
    ["de"]="Grafiken",
    ["en"]="Graphics",
    ["eo"]="Grafikoj",
    ["es"]="Gráficos",
    ["et"]="Graafika",
    ["fa"]="فهرست طرح‌ها",
    ["fi"]="Grafiikkaoi",
    ["fr"]="Graphiques",
    ["gr"]="Γραφικά",
    ["hr"]="Slike",
    ["hu"]="Grafikák",
    ["hy"]="Գծապատկեր",
    ["it"]="Grafici",
    ["ja"]="グラフ",
    ["kr"]="그래픽 ",
    ["la"]="Typi",
    ["lt"]="Graphics",
    ["mk"]="Листа на графици",
    ["nb"]="Bilde",
    ["nl"]="Grafieken",
    ["nn"]="Bilete",
    ["pl"]="Grafiki",
    ["pt"]="Gráficos",
    ["ro"]="Grafice",
    ["ru"]="Список графиков",
    ["sk"]="Zoznam grafov",
    ["sl"]="Slike",
    ["sr"]="Графици",
    ["sr-latn"]="Grafici",
    ["sv"]="Grafik",
    ["tk"]="Grafikler",
    ["tr"]="Grafikler",
    ["ua"]="Перелік графіков",
    ["vi"]="Đồ thị",
   },
  },
  ["index"]={
   ["labels"]={
    ["af"]="Indeks",
    ["ar"]="الفهرس",
    ["be"]="Алфавітны паказальнік",
    ["bg"]="Индэкс",
    ["ca"]="Índex alfabètic",
    ["cn"]="索引",
    ["cs"]="Rejstřík",
    ["da"]="Indeks",
    ["de"]="Index",
    ["en"]="Index",
    ["eo"]="Indekso",
    ["es"]="Índice",
    ["et"]="Indeks",
    ["fa"]="نمایه",
    ["fi"]="Indeksiluku",
    ["fr"]="Index",
    ["gr"]="Ευρετήριο",
    ["hr"]="Indeks",
    ["hu"]="Index",
    ["hy"]="Այբբենական ցուցիչ",
    ["it"]="Indice",
    ["ja"]="目次",
    ["kr"]="찾아보기",
    ["la"]="Indices",
    ["lt"]="Rodyklė",
    ["mk"]="Индекс",
    ["nb"]="Register",
    ["nl"]="Index",
    ["nn"]="Register",
    ["pl"]="Indeks",
    ["pt"]="Índice",
    ["ro"]="Index",
    ["ru"]="Алфавитный указатель",
    ["sk"]="Register",
    ["sl"]="Stvarno kazalo",
    ["sr"]="Индекс појмова",
    ["sr-latn"]="Indeks pojmova",
    ["sv"]="Sakregister",
    ["tk"]="Indeks",
    ["tr"]="İndex",
    ["ua"]="Покажчик",
    ["vi"]="Chỉ số",
   },
  },
  ["intermezzi"]={
   ["labels"]={
    ["af"]="Intermezzos",
    ["ar"]="فسح",
    ["be"]="Спіс уставак",
    ["bg"]="Интермеца",
    ["ca"]="Intermedis",
    ["cn"]="퉣",
    ["cs"]="Intermezza",
    ["da"]="Intermezzoer",
    ["de"]="Intermezzi",
    ["en"]="Intermezzos",
    ["eo"]="Intermezoj",
    ["es"]="Intermedios",
    ["et"]="Vahemängud",
    ["fi"]="Intermezzos",
    ["fr"]="Intermèdes",
    ["gr"]="Παύσεις",
    ["hr"]="Intermeci",
    ["hu"]="Intermezzok",
    ["hy"]="Ինտերլյուդներ",
    ["it"]="Intermezzi",
    ["ja"]="間奏曲",
    ["kr"]="간주곡",
    ["la"]="Intermissa",
    ["lt"]="Intermezzos",
    ["mk"]="Листа на дигресии",
    ["nb"]="Intermesso",
    ["nl"]="Intermezzo's",
    ["nn"]="Intermesso",
    ["pl"]="Intermezza",
    ["pt"]="Intermédios",
    ["ro"]="Intermzzo",
    ["ru"]="Список вставок",
    ["sk"]="Intermezzá",
    ["sl"]="Intermezzi",
    ["sr"]="Списак дигресија",
    ["sr-latn"]="Spisak digresija",
    ["sv"]="Intermezzon",
    ["tk"]="Arakesmeler",
    ["tr"]="",
    ["ua"]="Перелік вставок",
    ["vi"]="Intermezzos",
   },
  },
  ["logos"]={
   ["labels"]={
    ["af"]="Logos",
    ["ar"]="الشعارات",
    ["be"]="Лагатыпы",
    ["bg"]="Логотипи",
    ["ca"]="Logotips",
    ["cn"]="徽标",
    ["cs"]="Loga",
    ["da"]="Logoer",
    ["de"]="Logos",
    ["en"]="Logos",
    ["eo"]="Markemblemoj",
    ["es"]="Logotipos",
    ["et"]="Logos",
    ["fa"]="فهرست لوگوها",
    ["fi"]="Vertauskuva",
    ["fr"]="Logos",
    ["gr"]="Λογότυπα",
    ["hr"]="Logotipi",
    ["hu"]="Fejlécek",
    ["hy"]="Լոգոներ",
    ["it"]="Logotipi",
    ["ja"]="理性",
    ["kr"]="이성",
    ["la"]="Typi negotiales",
    ["lt"]="Logos",
    ["mk"]="Логоа",
    ["nb"]="Logoer",
    ["nl"]="Logo's",
    ["nn"]="Logoar",
    ["pl"]="Znaki",
    ["pt"]="Logotipos",
    ["ro"]="Logo-uri",
    ["ru"]="Логотипы",
    ["sk"]="Logá",
    ["sl"]="Logotipi",
    ["sr"]="Логотипи",
    ["sr-latn"]="Logotipi",
    ["sv"]="Loggor",
    ["tk"]="Logolar",
    ["tr"]="Logolar",
    ["ua"]="Логотипи",
    ["vi"]="Biểu tượng",
   },
  },
  ["pubs"]={
   ["labels"]={
    ["af"]="",
    ["ca"]="Referències",
    ["cs"]="Literatura",
    ["da"]="",
    ["de"]="Literatur",
    ["en"]="References",
    ["eo"]="Referencoj",
    ["es"]="Bibliografía",
    ["et"]="Viited",
    ["fa"]="کتاب‌نامه",
    ["fi"]="Viittet",
    ["fr"]="Bibliographie",
    ["gr"]="",
    ["hr"]="Literatura",
    ["hu"]="Bibliográfia",
    ["hy"]="Գրականութիւն",
    ["it"]="Bibliografia",
    ["kr"]="참고문헌",
    ["la"]="",
    ["lt"]="Literatūra",
    ["mk"]="Литература",
    ["nb"]="",
    ["nl"]="Literatuur",
    ["nn"]="",
    ["pl"]="Bibliografia",
    ["pt"]="Referencias",
    ["ro"]="",
    ["ru"]="",
    ["sk"]="Literatúra",
    ["sl"]="Literatura",
    ["sr"]="Литература",
    ["sr-latn"]="Literatura",
    ["sv"]="Litteraturförteckning",
    ["tk"]="",
    ["tr"]="",
    ["ua"]="",
    ["vi"]="",
   },
  },
  ["tables"]={
   ["labels"]={
    ["af"]="Tabelle",
    ["ar"]="الجداول",
    ["be"]="Спіс табліц",
    ["ca"]="Taules",
    ["cn"]="表格",
    ["cs"]="Seznam tabulek",
    ["da"]="Tabeller",
    ["de"]="Tabellen",
    ["en"]="Tables",
    ["eo"]="Tabeloj",
    ["es"]="Tablas",
    ["et"]="Tabelid",
    ["fa"]="فهرست جداول",
    ["fi"]="Taulukkoj",
    ["fr"]="Tableaux",
    ["gr"]="Πίνακες",
    ["hr"]="Tablice",
    ["hu"]="Táblázatok",
    ["hy"]="Աղյուսակներ",
    ["it"]="Tabelle",
    ["ja"]="机",
    ["kr"]="표 ",
    ["la"]="Tabulae",
    ["lt"]="Lentelės",
    ["mk"]="Листа на табели",
    ["nb"]="Tabeller",
    ["nl"]="Tabellen",
    ["nn"]="Tabellar",
    ["pl"]="Tabele",
    ["pt"]="Tabelas",
    ["ro"]="Tabele",
    ["ru"]="Список таблиц",
    ["sk"]="Zoznam tabuliek",
    ["sl"]="Tabele",
    ["sr"]="Табеле",
    ["sr-latn"]="Tabele",
    ["sv"]="Tabeller",
    ["tk"]="Tablisalar",
    ["tr"]="Tablolar",
    ["ua"]="Перелік таблиць",
    ["vi"]="Danh sách bảng",
   },
  },
  ["units"]={
   ["labels"]={
    ["af"]="Eenhede",
    ["ar"]="الوحدات",
    ["be"]="Адзінкі вымярэння",
    ["bg"]="Адзінкі",
    ["ca"]="Unitats",
    ["cn"]="计量单位",
    ["cs"]="Jednotky",
    ["da"]="Enheder",
    ["de"]="Einheiten",
    ["en"]="Units",
    ["eo"]="Unuoj",
    ["es"]="Unidades",
    ["et"]="Ühikud",
    ["fa"]="واحدها",
    ["fi"]="Yksiköt",
    ["fr"]="Unités",
    ["gr"]="Μονάδες",
    ["hr"]="Jedinice",
    ["hu"]="Mértékegységek",
    ["hy"]="Չափման միավորներ",
    ["it"]="Unità",
    ["ja"]="ユニッツ",
    ["kr"]="측정단위",
    ["la"]="Modi",
    ["lt"]="Units",
    ["mk"]="Единици",
    ["nb"]="Enheter",
    ["nl"]="Eenheden",
    ["nn"]="Einingar",
    ["pl"]="Jednostki",
    ["pt"]="Unidades",
    ["ro"]="Unități",
    ["ru"]="Единицы измерения",
    ["sk"]="Jednotky",
    ["sl"]="Enote",
    ["sr"]="Јединице",
    ["sr-latn"]="Jedinice",
    ["sv"]="Enheter",
    ["tk"]="Birlikler",
    ["tr"]="Birimler",
    ["ua"]="Одиниці виміру",
    ["vi"]="Đơn vị",
   },
  },
 },
}

local functions = data.labels.functions

functions.asin   = functions.arcsin
functions.acos   = functions.arccos
functions.atan   = functions.arctan
functions.asinh  = functions.arcsinh
functions.acosh  = functions.arccosh
functions.atanh  = functions.arctanh

functions.tg     = functions.tan
functions.ctg    = functions.cot
functions.arctg  = functions.arctan
functions.arcctg = functions.arccot
functions.arctgh = functions.arctanh

