/*
 * Copyright 1999-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import org.apache.bcel.verifier.VerifierFactory;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.Repository;

/**
 * Reads a class file from stdin and runs BCEL Justice verifier.
 *
 * <p>
 * This is supposed to help us by giving us where the generate byte code is wrong,
 * but it turns out that this isn't as useful as I hoped for ...
 *
 * <h3>Usage</h3>
 * <pre>
 * $ cat Foo.class | java Justice
 * </pre>
 *
 * @author Kohsuke Kawaguchi
 */
public class Justice {
    public static void main(String[] args) throws Exception {
        ClassParser cp = new ClassParser(System.in,null);
        JavaClass clazz = cp.parse();
        Repository.addClass(clazz);
        Verifier v = VerifierFactory.getVerifier(clazz.getClassName());

        System.out.println("Pass 1");
        report(v.doPass1());
        System.out.println("Pass 2");
        report(v.doPass2());
        for( int i=0; i<clazz.getMethods().length; i++ ) {
            String name = clazz.getMethods()[i].getName();
            System.out.println("Pass 3a on "+name);
            report(v.doPass3a(i));
            System.out.println("Pass 3b on "+name);
            report(v.doPass3b(i));
        }
    }

    private static void report(VerificationResult r) {
        System.out.println(r);
    }
}
