/****************************************************************************
 *    lib/c/StaticRule.h - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef STATICRULE_H
#define STATICRULE_H
#include "Statement.h"
#include "Formula.h"
#include "Printer.h"

#include <string>
#include <set>

namespace C {

class StaticRule : virtual public Statement
{
public:
	StaticRule(int line, Formula* F, Formula* G, Types* types=NULL);
	
	virtual ~StaticRule ( );

	void print(Printer* p);
	virtual void printDirect(Printer* p);
	virtual void printNonDirect(Printer* p);

protected:
	Formula* F_;
	Formula* G_;

};
}; // end of package namespace

#endif // STATICRULE_H
