<?php
/*
+--------------------------------------------------------------------+
| CiviCRM version 4.7                                                |
+--------------------------------------------------------------------+
| Copyright CiviCRM LLC (c) 2004-2017                                |
+--------------------------------------------------------------------+
| This file is a part of CiviCRM.                                    |
|                                                                    |
| CiviCRM is free software; you can copy, modify, and distribute it  |
| under the terms of the GNU Affero General Public License           |
| Version 3, 19 November 2007 and the CiviCRM Licensing Exception.   |
|                                                                    |
| CiviCRM is distributed in the hope that it will be useful, but     |
| WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               |
| See the GNU Affero General Public License for more details.        |
|                                                                    |
| You should have received a copy of the GNU Affero General Public   |
| License and the CiviCRM Licensing Exception along                  |
| with this program; if not, contact CiviCRM LLC                     |
| at info[AT]civicrm[DOT]org. If you have questions about the        |
| GNU Affero General Public License or the licensing of CiviCRM,     |
| see the CiviCRM license FAQ at http://civicrm.org/licensing        |
+--------------------------------------------------------------------+
*/
/**
 * @package CRM
 * @copyright CiviCRM LLC (c) 2004-2017
 *
 * Generated from xml/schema/CRM/Price/PriceSet.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:7250a5af1e713fc047875f2cc22443ff)
 */
require_once 'CRM/Core/DAO.php';
require_once 'CRM/Utils/Type.php';
/**
 * CRM_Price_DAO_PriceSet constructor.
 */
class CRM_Price_DAO_PriceSet extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  static $_tableName = 'civicrm_price_set';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var boolean
   */
  static $_log = true;
  /**
   * Price Set
   *
   * @var int unsigned
   */
  public $id;
  /**
   * Which Domain is this price-set for
   *
   * @var int unsigned
   */
  public $domain_id;
  /**
   * Variable name/programmatic handle for this set of price fields.
   *
   * @var string
   */
  public $name;
  /**
   * Displayed title for the Price Set.
   *
   * @var string
   */
  public $title;
  /**
   * Is this price set active
   *
   * @var boolean
   */
  public $is_active;
  /**
   * Description and/or help text to display before fields in form.
   *
   * @var text
   */
  public $help_pre;
  /**
   * Description and/or help text to display after fields in form.
   *
   * @var text
   */
  public $help_post;
  /**
   * Optional Javascript script function(s) included on the form with this price_set. Can be used for conditional
   *
   * @var string
   */
  public $javascript;
  /**
   * What components are using this price set?
   *
   * @var string
   */
  public $extends;
  /**
   * FK to Financial Type(for membership price sets only).
   *
   * @var int unsigned
   */
  public $financial_type_id;
  /**
   * Is set if edited on Contribution or Event Page rather than through Manage Price Sets
   *
   * @var boolean
   */
  public $is_quick_config;
  /**
   * Is this a predefined system price set  (i.e. it can not be deleted, edited)?
   *
   * @var boolean
   */
  public $is_reserved;
  /**
   * Minimum Amount required for this set.
   *
   * @var int unsigned
   */
  public $min_amount;
  /**
   * Class constructor.
   */
  function __construct() {
    $this->__table = 'civicrm_price_set';
    parent::__construct();
  }
  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static ::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'domain_id', 'civicrm_domain', 'id');
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName() , 'financial_type_id', 'civicrm_financial_type', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }
  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = array(
        'id' => array(
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Set ID') ,
          'description' => 'Price Set',
          'required' => true,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
        ) ,
        'domain_id' => array(
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Set Domain') ,
          'description' => 'Which Domain is this price-set for',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'html' => array(
            'type' => 'Text',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'name' => array(
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name') ,
          'description' => 'Variable name/programmatic handle for this set of price fields.',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'title' => array(
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Price Set Title') ,
          'description' => 'Displayed title for the Price Set.',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 1,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'is_active' => array(
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Set Is Active?') ,
          'description' => 'Is this price set active',
          'default' => '1',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'help_pre' => array(
          'name' => 'help_pre',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Set Pre Help') ,
          'description' => 'Description and/or help text to display before fields in form.',
          'rows' => 4,
          'cols' => 80,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 1,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'help_post' => array(
          'name' => 'help_post',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Set Post Help') ,
          'description' => 'Description and/or help text to display after fields in form.',
          'rows' => 4,
          'cols' => 80,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 1,
          'html' => array(
            'type' => 'TextArea',
          ) ,
        ) ,
        'javascript' => array(
          'name' => 'javascript',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Price Set Javascript') ,
          'description' => 'Optional Javascript script function(s) included on the form with this price_set. Can be used for conditional',
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
        'extends' => array(
          'name' => 'extends',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Price Set Extends') ,
          'description' => 'What components are using this price set?',
          'required' => true,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_component',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'financial_type_id' => array(
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type') ,
          'description' => 'FK to Financial Type(for membership price sets only).',
          'default' => 'NULL',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'html' => array(
            'type' => 'Select',
          ) ,
          'pseudoconstant' => array(
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          )
        ) ,
        'is_quick_config' => array(
          'name' => 'is_quick_config',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Price Set Quick Config?') ,
          'description' => 'Is set if edited on Contribution or Event Page rather than through Manage Price Sets',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'is_reserved' => array(
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Set Is Reserved') ,
          'description' => 'Is this a predefined system price set  (i.e. it can not be deleted, edited)?',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'CheckBox',
          ) ,
        ) ,
        'min_amount' => array(
          'name' => 'min_amount',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Minimum Amount') ,
          'description' => 'Minimum Amount required for this set.',
          'table_name' => 'civicrm_price_set',
          'entity' => 'PriceSet',
          'bao' => 'CRM_Price_BAO_PriceSet',
          'localizable' => 0,
          'html' => array(
            'type' => 'Text',
          ) ,
        ) ,
      );
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }
  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }
  /**
   * Returns the names of this table
   *
   * @return string
   */
  static function getTableName() {
    return CRM_Core_DAO::getLocaleTableName(self::$_tableName);
  }
  /**
   * Returns if this table needs to be logged
   *
   * @return boolean
   */
  function getLog() {
    return self::$_log;
  }
  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &import($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'price_set', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  static function &export($prefix = false) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'price_set', $prefix, array());
    return $r;
  }
  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = array(
      'UI_name' => array(
        'name' => 'UI_name',
        'field' => array(
          0 => 'name',
        ) ,
        'localizable' => false,
        'unique' => true,
        'sig' => 'civicrm_price_set::1::name',
      ) ,
    );
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }
}
