/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <pml/StructuralComponent.h>
#include <pml/Atom.h>
#include <pml/PhysicalModel.h>
#include <pml/Component.h>
#include <pml/StructuralComponent.h>
#include <pml/MultiComponent.h>

// camitk
#include <InteractiveViewer.h>
#include <Geometry.h>
using namespace camitk;

#include "AnyDecoration.h"
#include "StructuralComponentDC.h"
#include "PMManagerDC.h"

#include <vtkUnstructuredGrid.h>
#include <vtkActor.h>

// ------------- constructor --------------
AnyDecoration::AnyDecoration(StructuralComponentDC * scdc) : Decoration(scdc) {
  mySC = scdc->getSC();

  // build 3D representation

  myGeometry = new Geometry(scdc->getName(),
                            StructuralComponentDC::structuralComponentToVtk(mySC, &atomMap),
                            scdc->getPMManagerDC()->toDCRenderingMode(mySC->getMode()));

  // set the visible mode
  myGeometry->setRenderingModes(scdc->getPMManagerDC()->toDCRenderingMode(mySC->getMode()));
  // surface /points color = SC color
  myGeometry->setActorColor(InterfaceGeometry::Surface, mySC->getColor());
  myGeometry->setActorColor(InterfaceGeometry::Points, mySC->getColor());
  // wireframe color = black
  double rgb[4];
  for (unsigned int i = 0;i < 4;i++)
    rgb[i] = 1.0;
  myGeometry->setActorColor(InterfaceGeometry::Wireframe, rgb);
}

// ------------- destructor --------------
AnyDecoration::~AnyDecoration() {
  show(false);
  dc->removeProp("AnyDecoration Surface");
  dc->removeProp("AnyDecoration Points");
  dc->removeProp("AnyDecoration Wireframe");
  delete myGeometry;
  myGeometry = NULL;
}

// ------------- update --------------
void AnyDecoration::update() {
  StructuralComponent *atoms = mySC->getAtoms();
  for (unsigned int i = 0;i < atoms->getNumberOfStructures(); i++) {
    Atom *a = (Atom *) atoms->getStructure(i);
    // find a in the map
    std::AtomVtkPointsIndexMapIterator result;
    result = atomMap.find(a);
    // get the new atom position
    if (result != atomMap.end()) {
      double pos[3];
      a->getPosition(pos);
      // set the new position in my geometry
      myGeometry->setPointPosition(result->second, pos[0], pos[1], pos[2]);
    }
  }
}

// ------------- show --------------
void AnyDecoration::show(const bool d) {
  if (d) {
    // make sure that all asked rendering are shown
    if (myGeometry->getRenderingModes() & InterfaceGeometry::Surface) {
      dc->addProp("AnyDecoration Surface", myGeometry->getActor(InterfaceGeometry::Surface));
      dc->getProp("AnyDecoration Surface")->VisibilityOn();
    }
    if (myGeometry->getRenderingModes() & InterfaceGeometry::Points) {
      dc->addProp("AnyDecoration Points", myGeometry->getActor(InterfaceGeometry::Points));
      dc->getProp("AnyDecoration Points")->VisibilityOn();
    }
    if (myGeometry->getRenderingModes() & InterfaceGeometry::Wireframe) {
      dc->addProp("AnyDecoration Wireframe", myGeometry->getActor(InterfaceGeometry::Wireframe));
      dc->getProp("AnyDecoration Wireframe")->VisibilityOn();
    }
  }
  else {
    // remove all actors
    if (dc->getProp("AnyDecoration Surface"))
      dc->getProp("AnyDecoration Surface")->VisibilityOff();
    if (dc->getProp("AnyDecoration Points"))
      dc->getProp("AnyDecoration Points")->VisibilityOff();
    if (dc->getProp("AnyDecoration Wireframe"))
      dc->getProp("AnyDecoration Wireframe")->VisibilityOff();
  }
}


// ------------- setColor --------------
void AnyDecoration::setColor(const double r, const double g, const double b) {
  myGeometry->setColor(r, g, b);
}
