/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.prc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.prc.PalmResource;
import com.kreative.prc.PalmResourceAlreadyExistsException;
import com.kreative.prc.PalmResourceProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PalmResourceCollection
extends PalmResourceProvider
implements Map<Integer, Map<Short, PalmResource>> {
    private Map<Integer, Map<Short, PalmResource>> map = new HashMap<Integer, Map<Short, PalmResource>>();
    private byte[] header = new byte[78];

    public PalmResourceCollection() {
        KSFLUtilities.putShort(this.header, 32, (short)1);
        KSFLUtilities.putShort(this.header, 34, (short)1);
        KSFLUtilities.putInt(this.header, 60, 1634758764);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized byte[] getPRCHeader() {
        return KSFLUtilities.copy(this.header);
    }

    @Override
    public synchronized void setPRCHeader(byte[] header) {
        this.header = KSFLUtilities.copy(header);
    }

    @Override
    public synchronized boolean add(PalmResource r) throws PalmResourceAlreadyExistsException {
        if (this.map.containsKey(r.type) && this.map.get(r.type).containsKey(r.id)) {
            throw new PalmResourceAlreadyExistsException();
        }
        if (this.map.containsKey(r.type)) {
            this.map.get(r.type).put(r.id, r.deepCopy());
        } else {
            HashMap<Short, PalmResource> nmap = new HashMap<Short, PalmResource>();
            nmap.put(r.id, r.deepCopy());
            this.map.put(r.type, nmap);
        }
        return true;
    }

    @Override
    public synchronized boolean contains(int type, short id) {
        return this.map.containsKey(type) && this.map.get(type).containsKey(id);
    }

    private PalmResource find(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id);
        }
        return null;
    }

    @Override
    public synchronized PalmResource get(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return this.map.get(type).get(id).deepCopy();
        }
        return null;
    }

    @Override
    public synchronized PalmResource getAttributes(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            PalmResource r = this.map.get(type).get(id);
            return new PalmResource(r.type, r.id, new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            return KSFLUtilities.copy(this.map.get((Object)Integer.valueOf((int)type)).get((Object)Short.valueOf((short)id)).data);
        }
        return null;
    }

    @Override
    public synchronized boolean remove(int type, short id) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get(type).remove(id);
            if (this.map.get(type).isEmpty()) {
                this.map.remove(type);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean set(int type, short id, PalmResource r) throws PalmResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        PalmResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new PalmResourceAlreadyExistsException();
        }
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean setAttributes(int type, short id, PalmResource r) throws PalmResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        PalmResource o = this.find(type, id);
        if ((o.type != r.type || o.id != r.id) && this.contains(r.type, r.id)) {
            throw new PalmResourceAlreadyExistsException();
        }
        r = r.deepCopy();
        r.data = o.data;
        return this.remove(type, id) && this.add(r);
    }

    @Override
    public synchronized boolean setData(int type, short id, byte[] data) {
        if (this.map.containsKey(type) && this.map.get(type).containsKey(id)) {
            this.map.get((Object)Integer.valueOf((int)type)).get((Object)Short.valueOf((short)id)).data = KSFLUtilities.copy(data);
            return true;
        }
        return false;
    }

    @Override
    public synchronized int getTypeCount() {
        return this.map.size();
    }

    @Override
    public synchronized int getType(int index) {
        return this.map.keySet().toArray(new Integer[0])[index];
    }

    @Override
    public synchronized int[] getTypes() {
        Integer[] types = this.map.keySet().toArray(new Integer[0]);
        int[] types2 = new int[types.length];
        int i = 0;
        while (i < types.length) {
            types2[i] = types[i];
            ++i;
        }
        return types2;
    }

    @Override
    public synchronized int getResourceCount(int type) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).size();
        }
        return 0;
    }

    @Override
    public synchronized short getID(int type, int index) {
        if (this.map.containsKey(type)) {
            return this.map.get(type).keySet().toArray(new Short[0])[index];
        }
        return 0;
    }

    @Override
    public synchronized short[] getIDs(int type) {
        if (this.map.containsKey(type)) {
            Short[] ids = this.map.get(type).keySet().toArray(new Short[0]);
            short[] ids2 = new short[ids.length];
            int i = 0;
            while (i < ids.length) {
                ids2[i] = ids[i];
                ++i;
            }
            return ids2;
        }
        return new short[0];
    }

    @Override
    public synchronized short getNextAvailableID(int type, short start) {
        if (this.map.containsKey(type)) {
            while (this.map.get(type).containsKey(start)) {
                start = (short)(start + 1);
            }
        }
        return start;
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized Set<Map.Entry<Integer, Map<Short, PalmResource>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized Map<Short, PalmResource> get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized Set<Integer> keySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Map<Short, PalmResource> put(Integer key, Map<Short, PalmResource> value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends Map<Short, PalmResource>> t) {
        this.map.putAll(t);
    }

    @Override
    public synchronized Map<Short, PalmResource> remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized Collection<Map<Short, PalmResource>> values() {
        return this.map.values();
    }
}

