/*
 * File:          sidl_rmi_ObjectDoesNotExistException_Module.c
 * Symbol:        sidl.rmi.ObjectDoesNotExistException-v0.9.17
 * Symbol Type:   class
 * Babel Version: 1.4.0 (Revision: 6607 release-1-4-0-branch)
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   implement a C extension type for a sidl extendable
 * 
 * Copyright (c) 2000-2002, Lawrence Livermore National Security, LLC.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 */

/*
 * THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL
 * COMPILER. DO NOT EDIT THIS!
 * 
 * This file contains the implementation of a Python C
 * extension type (i.e. a Python type implemented in C).
 * This extension type provides Python interface to the
 * sidl type sidl.rmi.ObjectDoesNotExistException.
 */


/**
 * Symbol "sidl.rmi.ObjectDoesNotExistException" (version 0.9.17)
 * 
 * This exception is thrown by a server when a passed in object 
 * id does not match any known object. 
 */
#include <Python.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#ifndef included_sidl_BaseClass_h
#include "sidl_BaseClass.h"
#endif
#ifndef included_sidl_ClassInfo_h
#include "sidl_ClassInfo.h"
#endif
#ifndef included_sidl_rmi_ProtocolFactory_h
#include "sidl_rmi_ProtocolFactory.h"
#endif
#ifndef included_sidl_rmi_InstanceRegistry_h
#include "sidl_rmi_InstanceRegistry.h"
#endif
#ifndef included_sidl_rmi_InstanceHandle_h
#include "sidl_rmi_InstanceHandle.h"
#endif
#ifndef included_sidl_rmi_Invocation_h
#include "sidl_rmi_Invocation.h"
#endif
#ifndef included_sidl_rmi_Response_h
#include "sidl_rmi_Response.h"
#endif
#ifndef included_sidl_rmi_ServerRegistry_h
#include "sidl_rmi_ServerRegistry.h"
#endif
#ifndef included_sidl_rmi_ConnectRegistry_h
#include "sidl_rmi_ConnectRegistry.h"
#endif
#ifndef included_sidl_io_Serializable_h
#include "sidl_io_Serializable.h"
#endif
#ifndef included_sidl_MemAllocException_h
#include "sidl_MemAllocException.h"
#endif
#ifndef included_sidl_NotImplementedException_h
#include "sidl_NotImplementedException.h"
#endif
#include "sidl_Exception.h"

#ifndef NULL
#define NULL 0
#endif

#include "sidl_thread.h"
#ifdef HAVE_PTHREAD
static struct sidl_recursive_mutex_t sidl_rmi_ObjectDoesNotExistException__mutex= SIDL_RECURSIVE_MUTEX_INITIALIZER;
#define LOCK_STATIC_GLOBALS sidl_recursive_mutex_lock( &sidl_rmi_ObjectDoesNotExistException__mutex )
#define UNLOCK_STATIC_GLOBALS sidl_recursive_mutex_unlock( &sidl_rmi_ObjectDoesNotExistException__mutex )
/* #define HAVE_LOCKED_STATIC_GLOBALS (sidl_recursive_mutex_trylock( &sidl_rmi_ObjectDoesNotExistException__mutex )==EDEADLOCK) */
#else
#define LOCK_STATIC_GLOBALS
#define UNLOCK_STATIC_GLOBALS
/* #define HAVE_LOCKED_STATIC_GLOBALS (1) */
#endif

#define sidl_rmi_ObjectDoesNotExistException_INTERNAL 1
#include "sidl_rmi_ObjectDoesNotExistException_Module.h"
#ifndef included_sidl_rmi_ObjectDoesNotExistException_IOR_h
#include "sidl_rmi_ObjectDoesNotExistException_IOR.h"
#endif
#include "sidlObjA.h"
#include "sidlPyArrays.h"
#ifdef SIDL_HAVE_NUMPY
#include "oldnumeric.h"
#elif defined(SIDL_HAVE_NUMERIC_PYTHON)
#include "Numeric/arrayobject.h"
#else
#error Neither Numeric Python nor NumPy installed
#endif
#ifndef included_sidl_Loader_h
#include "sidl_Loader.h"
#endif
#ifndef included_sidl_header_h
#include "sidl_header.h"
#endif
#ifndef included_sidl_String_h
#include "sidl_String.h"
#endif
#ifndef included_sidl_Python_h
#include "sidl_Python.h"
#endif
#ifndef included_sidl_interface_IOR_h
#include "sidl_interface_IOR.h"
#endif
#include "sidl_rmi_NetworkException_Module.h"
#include "sidl_BaseClass_Module.h"
#include "sidl_BaseException_Module.h"
#include "sidl_BaseInterface_Module.h"
#include "sidl_ClassInfo_Module.h"
#include "sidl_RuntimeException_Module.h"
#include "sidl_SIDLException_Module.h"
#include "sidl_io_Deserializer_Module.h"
#include "sidl_io_IOException_Module.h"
#include "sidl_io_Serializable_Module.h"
#include "sidl_io_Serializer_Module.h"
#include "sidl_rmi_Call_Module.h"
#include "sidl_rmi_Return_Module.h"
#include "sidl_rmi_Ticket_Module.h"
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <stdio.h>

/*
 * lang_inited is a boolean value showing if we have already imported all the nescessary modules
 */

static int lang_inited = 0;

static void _loadDependentMods(void) {
  PyGILState_STATE _gstate;
#if (PY_VERSION_HEX >= 0x02040000)
  _gstate = PyGILState_Ensure();
  sidl_Python_LogGILEnsure(__func__, __FILE__, __LINE__, (int)_gstate);
#endif /* Python 2.4 or later */
  sidl_BaseClass__import();
  sidl_BaseException__import();
  sidl_BaseInterface__import();
  sidl_ClassInfo__import();
  sidl_RuntimeException__import();
  sidl_SIDLException__import();
  sidl_io_Deserializer__import();
  sidl_io_IOException__import();
  sidl_io_Serializable__import();
  sidl_io_Serializer__import();
  sidl_rmi_NetworkException__import();
  sidl_rmi_ObjectDoesNotExistException__import();
  sidl_rmi_Ticket__import();
#if (PY_VERSION_HEX >= 0x02040000)
  PyGILState_Release(_gstate);
  sidl_Python_LogGILRelease(__func__, __FILE__, __LINE__, (int)_gstate);
#endif /* Python 2.4 or later */
}

#define LANG_SPECIFIC_INIT() if(!lang_inited) { \
  lang_inited = 1; \
  _loadDependentMods(); \
}

#ifdef WITH_RMI

/**
 * RMI connector function for the class. (no addref)
 */
struct sidl_rmi_ObjectDoesNotExistException__object*
sidl_rmi_ObjectDoesNotExistException__connectI(const char * url, sidl_bool ar,\
  struct sidl_BaseInterface__object **_ex);


#endif /*WITH_RMI*/

/* Static variables to hold version of IOR */
static const int32_t s_IOR_MAJOR_VERSION = 2;
static const int32_t s_IOR_MINOR_VERSION = 0;

/* Static variables for managing EPV initialization. */
static int s_remote_initialized = 0;

static struct sidl_rmi_ObjectDoesNotExistException__epv                       \
  s_rem_epv__sidl_rmi_objectdoesnotexistexception;

static struct sidl_BaseClass__epv  s_rem_epv__sidl_baseclass;

static struct sidl_BaseException__epv  s_rem_epv__sidl_baseexception;

static struct sidl_BaseInterface__epv  s_rem_epv__sidl_baseinterface;

static struct sidl_RuntimeException__epv  s_rem_epv__sidl_runtimeexception;

static struct sidl_SIDLException__epv  s_rem_epv__sidl_sidlexception;

static struct sidl_io_IOException__epv  s_rem_epv__sidl_io_ioexception;

static struct sidl_io_Serializable__epv  s_rem_epv__sidl_io_serializable;

static struct sidl_rmi_NetworkException__epv                                  \
  s_rem_epv__sidl_rmi_networkexception;

#ifdef WITH_RMI


/* REMOTE CAST: dynamic type casting for remote objects. */
static void* remote_sidl_rmi_ObjectDoesNotExistException__cast(
  struct sidl_rmi_ObjectDoesNotExistException__object* self,
  const char* name, sidl_BaseInterface* _ex)
{
  int cmp;
  void* cast = NULL;
  *_ex = NULL; /* default to no exception */
  cmp = strcmp(name, "sidl.SIDLException");
  if (!cmp) {
    (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
    cast = ((struct sidl_SIDLException__object*)self);
    return cast;
  }
  else if (cmp < 0) {
    cmp = strcmp(name, "sidl.BaseInterface");
    if (!cmp) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = &((                                                              \
        *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_baseclass.d_sidl_baseinterface);
      return cast;
    }
    else if (cmp < 0) {
      cmp = strcmp(name, "sidl.BaseException");
      if (!cmp) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = &((                                                            \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_baseexception);
        return cast;
      }
      else if (cmp < 0) {
        cmp = strcmp(name, "sidl.BaseClass");
        if (!cmp) {
          (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
          cast = ((struct sidl_BaseClass__object*)self);
          return cast;
        }
      }
    }
    else if (cmp > 0) {
      cmp = strcmp(name, "sidl.RuntimeException");
      if (!cmp) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = &((                                                            \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_runtimeexception);
        return cast;
      }
    }
  }
  else if (cmp > 0) {
    cmp = strcmp(name, "sidl.rmi.NetworkException");
    if (!cmp) {
      (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
      cast = ((struct sidl_rmi_NetworkException__object*)self);
      return cast;
    }
    else if (cmp < 0) {
      cmp = strcmp(name, "sidl.io.Serializable");
      if (!cmp) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = &((                                                            \
          *self).d_sidl_rmi_networkexception.d_sidl_io_ioexception.d_sidl_sidlexception.d_sidl_io_serializable);
        return cast;
      }
      else if (cmp < 0) {
        cmp = strcmp(name, "sidl.io.IOException");
        if (!cmp) {
          (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
          cast = ((struct sidl_io_IOException__object*)self);
          return cast;
        }
      }
    }
    else if (cmp > 0) {
      cmp = strcmp(name, "sidl.rmi.ObjectDoesNotExistException");
      if (!cmp) {
        (*self->d_epv->f_addRef)(self, _ex); SIDL_CHECK(*_ex);
        cast = ((struct sidl_rmi_ObjectDoesNotExistException__object*)self);
        return cast;
      }
    }
  }
  if ((*self->d_epv->f_isType)(self,name, _ex)) {
    void* (*func)(struct sidl_rmi_InstanceHandle__object*, struct             \
      sidl_BaseInterface__object**) = 
      (void* (*)(struct sidl_rmi_InstanceHandle__object*, struct              \
        sidl_BaseInterface__object**)) 
      sidl_rmi_ConnectRegistry_getConnect(name, _ex);SIDL_CHECK(*_ex);
    cast =  (*func)(((struct                                                  \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih, _ex);
  }

  return cast;
  EXIT:
  return NULL;
}

/* REMOTE DELETE: call the remote destructor for the object. */
static void remote_sidl_rmi_ObjectDoesNotExistException__delete(
  struct sidl_rmi_ObjectDoesNotExistException__object* self,
  struct sidl_BaseInterface__object* *_ex)
{
  *_ex = NULL;
  free((void*) self);
}

/* REMOTE GETURL: call the getURL function for the object. */
static char* remote_sidl_rmi_ObjectDoesNotExistException__getURL(
  struct sidl_rmi_ObjectDoesNotExistException__object* self, struct           \
    sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi_InstanceHandle__object *conn = ((struct                     \
    sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
  *_ex = NULL;
  if(conn != NULL) {
    return sidl_rmi_InstanceHandle_getObjectURL(conn, _ex);
  }
  return NULL;
}

/* REMOTE ADDREF: For internal babel use only! Remote addRef. */
static void remote_sidl_rmi_ObjectDoesNotExistException__raddRef(
  struct sidl_rmi_ObjectDoesNotExistException__object* self,struct            \
    sidl_BaseInterface__object* *_ex)
{
  struct sidl_BaseException__object* netex = NULL;
  /* initialize a new invocation */
  struct sidl_BaseInterface__object* _throwaway = NULL;
  struct sidl_rmi_InstanceHandle__object *_conn = ((struct                    \
    sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
  sidl_rmi_Response _rsvp = NULL;
  sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation( _conn, \
    "addRef", _ex ); SIDL_CHECK(*_ex);
  /* send actual RMI request */
  _rsvp = sidl_rmi_Invocation_invokeMethod(_inv,_ex);SIDL_CHECK(*_ex);
  /* Check for exceptions */
  netex = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);
  if(netex != NULL) {
    *_ex = (struct sidl_BaseInterface__object*)netex;
    return;
  }

  /* cleanup and return */
  EXIT:
  if(_inv) { sidl_rmi_Invocation_deleteRef(_inv,&_throwaway); }
  if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp,&_throwaway); }
  return;
}

/* REMOTE ISREMOTE: returns true if this object is Remote (it is). */
static sidl_bool
remote_sidl_rmi_ObjectDoesNotExistException__isRemote(
    struct sidl_rmi_ObjectDoesNotExistException__object* self, 
    struct sidl_BaseInterface__object* *_ex) {
  *_ex = NULL;
  return TRUE;
}

/* REMOTE METHOD STUB:_set_hooks */
static void
remote_sidl_rmi_ObjectDoesNotExistException__set_hooks(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ sidl_bool enable,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_hooks", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "enable", enable, _ex);SIDL_CHECK(    \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException._set_hooks.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* Contract enforcement has not been implemented for remote use. */
/* REMOTE METHOD STUB:_set_contracts */
static void
remote_sidl_rmi_ObjectDoesNotExistException__set_contracts(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ sidl_bool enable,
  /* in */ const char* enfFilename,
  /* in */ sidl_bool resetCounters,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_set_contracts", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packBool( _inv, "enable", enable, _ex);SIDL_CHECK(    \
      *_ex);
    sidl_rmi_Invocation_packString( _inv, "enfFilename", enfFilename,         \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packBool( _inv, "resetCounters", resetCounters,       \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException._set_contracts.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* Contract enforcement has not been implemented for remote use. */
/* REMOTE METHOD STUB:_dump_stats */
static void
remote_sidl_rmi_ObjectDoesNotExistException__dump_stats(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ const char* filename,
  /* in */ const char* prefix,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "_dump_stats", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "filename", filename,               \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packString( _inv, "prefix", prefix, _ex);SIDL_CHECK(  \
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException._dump_stats.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EXEC: call the exec function for the object. */
static void remote_sidl_rmi_ObjectDoesNotExistException__exec(
  struct sidl_rmi_ObjectDoesNotExistException__object* self,const char*       \
    methodName,
  sidl_rmi_Call inArgs,
  sidl_rmi_Return outArgs,
  struct sidl_BaseInterface__object* *_ex)
{
  *_ex = NULL;
}

/* REMOTE METHOD STUB:getHopCount */
static int32_t
remote_sidl_rmi_ObjectDoesNotExistException_getHopCount(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getHopCount", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.getHopCount.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:setErrno */
static void
remote_sidl_rmi_ObjectDoesNotExistException_setErrno(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ int32_t err,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "setErrno", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packInt( _inv, "err", err, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.setErrno.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:getErrno */
static int32_t
remote_sidl_rmi_ObjectDoesNotExistException_getErrno(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    int32_t _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getErrno", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.getErrno.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackInt( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK( \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:addRef */
static void
remote_sidl_rmi_ObjectDoesNotExistException_addRef(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi_ObjectDoesNotExistException__remote* r_obj = (struct      \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount++;
#ifdef SIDL_DEBUG_REFCOUNT
    fprintf(stderr, "babel: addRef %p new count %d (type %s)\n",
      r_obj, r_obj->d_refcount, 
      "sidl.rmi.ObjectDoesNotExistException Remote Stub");
#endif /* SIDL_DEBUG_REFCOUNT */ 
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:deleteRef */
static void
remote_sidl_rmi_ObjectDoesNotExistException_deleteRef(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    struct sidl_rmi_ObjectDoesNotExistException__remote* r_obj = (struct      \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data;
    LOCK_STATIC_GLOBALS;
    r_obj->d_refcount--;
#ifdef SIDL_DEBUG_REFCOUNT
    fprintf(stderr, "babel: deleteRef %p new count %d (type %s)\n",r_obj, r_obj->d_refcount, "sidl.rmi.ObjectDoesNotExistException Remote Stub");
#endif /* SIDL_DEBUG_REFCOUNT */ 
    if(r_obj->d_refcount == 0) {
      sidl_rmi_InstanceHandle_deleteRef(r_obj->d_ih, _ex);
      free(r_obj);
      free(self);
    }
    UNLOCK_STATIC_GLOBALS;
  }
}

/* REMOTE METHOD STUB:isSame */
static sidl_bool
remote_sidl_rmi_ObjectDoesNotExistException_isSame(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ struct sidl_BaseInterface__object* iobj,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isSame", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(iobj){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)iobj,       \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "iobj", _url, _ex);SIDL_CHECK(    \
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "iobj", NULL, _ex);SIDL_CHECK(    \
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.isSame.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:isType */
static sidl_bool
remote_sidl_rmi_ObjectDoesNotExistException_isType(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ const char* name,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    sidl_bool _retval = FALSE;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "isType", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "name", name, _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.isType.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackBool( _rsvp, "_retval", &_retval, _ex);SIDL_CHECK(\
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getClassInfo */
static struct sidl_ClassInfo__object*
remote_sidl_rmi_ObjectDoesNotExistException_getClassInfo(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char*_retval_str = NULL;
    struct sidl_ClassInfo__object* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getClassInfo", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.getClassInfo.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval_str,           \
      _ex);SIDL_CHECK(*_ex);
    _retval = sidl_ClassInfo__connectI(_retval_str, FALSE, _ex);SIDL_CHECK(   \
      *_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:getNote */
static char*
remote_sidl_rmi_ObjectDoesNotExistException_getNote(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getNote", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.getNote.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:setNote */
static void
remote_sidl_rmi_ObjectDoesNotExistException_setNote(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ const char* message,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "setNote", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "message", message, _ex);SIDL_CHECK(\
      *_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.setNote.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:getTrace */
static char*
remote_sidl_rmi_ObjectDoesNotExistException_getTrace(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    char* _retval = 0;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "getTrace", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.getTrace.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* extract return value */
    sidl_rmi_Response_unpackString( _rsvp, "_retval", &_retval,               \
      _ex);SIDL_CHECK(*_ex);

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return _retval;
  }
}

/* REMOTE METHOD STUB:addLine */
static void
remote_sidl_rmi_ObjectDoesNotExistException_addLine(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ const char* traceline,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "addLine", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "traceline", traceline,             \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.addLine.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:add */
static void
remote_sidl_rmi_ObjectDoesNotExistException_add(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ const char* filename,
  /* in */ int32_t lineno,
  /* in */ const char* methodname,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "add", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    sidl_rmi_Invocation_packString( _inv, "filename", filename,               \
      _ex);SIDL_CHECK(*_ex);
    sidl_rmi_Invocation_packInt( _inv, "lineno", lineno, _ex);SIDL_CHECK(     \
      *_ex);
    sidl_rmi_Invocation_packString( _inv, "methodname", methodname,           \
      _ex);SIDL_CHECK(*_ex);

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.add.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:packObj */
static void
remote_sidl_rmi_ObjectDoesNotExistException_packObj(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ struct sidl_io_Serializer__object* ser,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "packObj", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(ser){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)ser,        \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "ser", _url, _ex);SIDL_CHECK(     \
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "ser", NULL, _ex);SIDL_CHECK(     \
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.packObj.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE METHOD STUB:unpackObj */
static void
remote_sidl_rmi_ObjectDoesNotExistException_unpackObj(
  /* in */ struct sidl_rmi_ObjectDoesNotExistException__object*self ,
  /* in */ struct sidl_io_Deserializer__object* des,
  /* out */ struct sidl_BaseInterface__object **_ex)
{
  LANG_SPECIFIC_INIT();
  *_ex = NULL;
  {
    /* initialize a new invocation */
    struct sidl_BaseInterface__object* _throwaway = NULL;
    sidl_BaseException _be = NULL;
    sidl_rmi_Response _rsvp = NULL;
    struct sidl_rmi_InstanceHandle__object * _conn = ((struct                 \
      sidl_rmi_ObjectDoesNotExistException__remote*)self->d_data)->d_ih;
    sidl_rmi_Invocation _inv = sidl_rmi_InstanceHandle_createInvocation(      \
      _conn, "unpackObj", _ex ); SIDL_CHECK(*_ex);

    /* pack in and inout arguments */
    if(des){
      char* _url = sidl_BaseInterface__getURL((sidl_BaseInterface)des,        \
        _ex);SIDL_CHECK(*_ex);
      sidl_rmi_Invocation_packString( _inv, "des", _url, _ex);SIDL_CHECK(     \
        *_ex);
      free((void*)_url);
    } else {
      sidl_rmi_Invocation_packString( _inv, "des", NULL, _ex);SIDL_CHECK(     \
        *_ex);
    }

    /* send actual RMI request */
    _rsvp = sidl_rmi_Invocation_invokeMethod(_inv, _ex);SIDL_CHECK(*_ex);

    _be = sidl_rmi_Response_getExceptionThrown(_rsvp, _ex);SIDL_CHECK(*_ex);
    if (_be != NULL) {
      struct sidl_BaseInterface__object* throwaway_exception = NULL;
      sidl_BaseException_addLine(_be, 
      "Exception unserialized from sidl.rmi.ObjectDoesNotExistException.unpackObj.",
        &throwaway_exception);
      *_ex = (struct sidl_BaseInterface__object*) sidl_BaseInterface__cast(   \
        _be,&throwaway_exception);
      goto EXIT;
    }

    /* unpack out and inout arguments */

    /* cleanup and return */
    EXIT:
    if(_inv) { sidl_rmi_Invocation_deleteRef(_inv, &_throwaway); }
    if(_rsvp) { sidl_rmi_Response_deleteRef(_rsvp, &_throwaway); }
    return;
  }
}

/* REMOTE EPV: create remote entry point vectors (EPVs). */
static void sidl_rmi_ObjectDoesNotExistException__init_remote_epv(void)
{
  /* assert( HAVE_LOCKED_STATIC_GLOBALS ); */
  struct sidl_rmi_ObjectDoesNotExistException__epv* epv =                     \
    &s_rem_epv__sidl_rmi_objectdoesnotexistexception;
  struct sidl_BaseClass__epv*                       e0  =                     \
    &s_rem_epv__sidl_baseclass;
  struct sidl_BaseException__epv*                   e1  =                     \
    &s_rem_epv__sidl_baseexception;
  struct sidl_BaseInterface__epv*                   e2  =                     \
    &s_rem_epv__sidl_baseinterface;
  struct sidl_RuntimeException__epv*                e3  =                     \
    &s_rem_epv__sidl_runtimeexception;
  struct sidl_SIDLException__epv*                   e4  =                     \
    &s_rem_epv__sidl_sidlexception;
  struct sidl_io_IOException__epv*                  e5  =                     \
    &s_rem_epv__sidl_io_ioexception;
  struct sidl_io_Serializable__epv*                 e6  =                     \
    &s_rem_epv__sidl_io_serializable;
  struct sidl_rmi_NetworkException__epv*            e7  =                     \
    &s_rem_epv__sidl_rmi_networkexception;

  epv->f__cast               =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__cast;
  epv->f__delete             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__delete;
  epv->f__exec               =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__exec;
  epv->f__getURL             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__getURL;
  epv->f__raddRef            =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__raddRef;
  epv->f__isRemote           =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__isRemote;
  epv->f__set_hooks          =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__set_hooks;
  epv->f__set_contracts      =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__set_contracts;
  epv->f__dump_stats         =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException__dump_stats;
  epv->f__ctor               = NULL;
  epv->f__ctor2              = NULL;
  epv->f__dtor               = NULL;
  epv->f_getHopCount         =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_getHopCount;
  epv->f_setErrno            =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_setErrno;
  epv->f_getErrno            =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_getErrno;
  epv->f_addRef              =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_addRef;
  epv->f_deleteRef           =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_deleteRef;
  epv->f_isSame              =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_isSame;
  epv->f_isType              =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_isType;
  epv->f_getClassInfo        =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_getClassInfo;
  epv->f_getNote             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_getNote;
  epv->f_setNote             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_setNote;
  epv->f_getTrace            =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_getTrace;
  epv->f_addLine             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_addLine;
  epv->f_add                 =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_add;
  epv->f_packObj             =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_packObj;
  epv->f_unpackObj           =                                                \
    remote_sidl_rmi_ObjectDoesNotExistException_unpackObj;

  e0->f__cast          = (void* (*)(struct sidl_BaseClass__object*, const     \
    char*, struct sidl_BaseInterface__object**)) epv->f__cast;
  e0->f__delete        = (void (*)(struct sidl_BaseClass__object*, struct     \
    sidl_BaseInterface__object**)) epv->f__delete;
  e0->f__getURL        = (char* (*)(struct sidl_BaseClass__object*, struct    \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e0->f__raddRef       = (void (*)(struct sidl_BaseClass__object*, struct     \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e0->f__isRemote      = (sidl_bool (*)(struct sidl_BaseClass__object*,       \
    struct sidl_BaseInterface__object**)) epv->f__isRemote;
  e0->f__set_hooks     = (void (*)(struct sidl_BaseClass__object*, sidl_bool, \
    struct sidl_BaseInterface__object**)) epv->f__set_hooks;
  e0->f__set_contracts = (void (*)(struct sidl_BaseClass__object*, sidl_bool, \
    const char*, sidl_bool, struct sidl_BaseInterface__object**))             \
    epv->f__set_contracts;
  e0->f__dump_stats    = (void (*)(struct sidl_BaseClass__object*, const      \
    char*, const char*, struct sidl_BaseInterface__object**))                 \
    epv->f__dump_stats;
  e0->f__exec          = (void (*)(struct sidl_BaseClass__object*,const char*,\
    struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct      \
    sidl_BaseInterface__object **)) epv->f__exec;
  e0->f_addRef         = (void (*)(struct sidl_BaseClass__object*,struct      \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e0->f_deleteRef      = (void (*)(struct sidl_BaseClass__object*,struct      \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e0->f_isSame         = (sidl_bool (*)(struct sidl_BaseClass__object*,struct \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e0->f_isType         = (sidl_bool (*)(struct sidl_BaseClass__object*,const  \
    char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e0->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(struct           \
    sidl_BaseClass__object*,struct sidl_BaseInterface__object **))            \
    epv->f_getClassInfo;

  e1->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e1->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e1->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e1->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e1->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e1->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e1->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e1->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e1->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e1->f_getNote        = (char* (*)(void*,struct sidl_BaseInterface__object   \
    **)) epv->f_getNote;
  e1->f_setNote        = (void (*)(void*,const char*,struct                   \
    sidl_BaseInterface__object **)) epv->f_setNote;
  e1->f_getTrace       = (char* (*)(void*,struct sidl_BaseInterface__object   \
    **)) epv->f_getTrace;
  e1->f_addLine        = (void (*)(void*,const char*,struct                   \
    sidl_BaseInterface__object **)) epv->f_addLine;
  e1->f_add            = (void (*)(void*,const char*,int32_t,const char*,     \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e1->f_packObj        = (void (*)(void*,struct sidl_io_Serializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e1->f_unpackObj      = (void (*)(void*,struct sidl_io_Deserializer__object*,\
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e1->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e1->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e1->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e1->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e1->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e2->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e2->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e2->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e2->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e2->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e2->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e2->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e2->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e2->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e2->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e2->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e2->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e2->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e2->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e3->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e3->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e3->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e3->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e3->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e3->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e3->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e3->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e3->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e3->f_getNote        = (char* (*)(void*,struct sidl_BaseInterface__object   \
    **)) epv->f_getNote;
  e3->f_setNote        = (void (*)(void*,const char*,struct                   \
    sidl_BaseInterface__object **)) epv->f_setNote;
  e3->f_getTrace       = (char* (*)(void*,struct sidl_BaseInterface__object   \
    **)) epv->f_getTrace;
  e3->f_addLine        = (void (*)(void*,const char*,struct                   \
    sidl_BaseInterface__object **)) epv->f_addLine;
  e3->f_add            = (void (*)(void*,const char*,int32_t,const char*,     \
    struct sidl_BaseInterface__object **)) epv->f_add;
  e3->f_packObj        = (void (*)(void*,struct sidl_io_Serializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e3->f_unpackObj      = (void (*)(void*,struct sidl_io_Deserializer__object*,\
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e3->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e3->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e3->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e3->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e3->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e4->f__cast          = (void* (*)(struct sidl_SIDLException__object*, const \
    char*, struct sidl_BaseInterface__object**)) epv->f__cast;
  e4->f__delete        = (void (*)(struct sidl_SIDLException__object*, struct \
    sidl_BaseInterface__object**)) epv->f__delete;
  e4->f__getURL        = (char* (*)(struct sidl_SIDLException__object*,       \
    struct sidl_BaseInterface__object**)) epv->f__getURL;
  e4->f__raddRef       = (void (*)(struct sidl_SIDLException__object*, struct \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e4->f__isRemote      = (sidl_bool (*)(struct sidl_SIDLException__object*,   \
    struct sidl_BaseInterface__object**)) epv->f__isRemote;
  e4->f__set_hooks     = (void (*)(struct sidl_SIDLException__object*,        \
    sidl_bool, struct sidl_BaseInterface__object**)) epv->f__set_hooks;
  e4->f__set_contracts = (void (*)(struct sidl_SIDLException__object*,        \
    sidl_bool, const char*, sidl_bool, struct sidl_BaseInterface__object**))  \
    epv->f__set_contracts;
  e4->f__dump_stats    = (void (*)(struct sidl_SIDLException__object*, const  \
    char*, const char*, struct sidl_BaseInterface__object**))                 \
    epv->f__dump_stats;
  e4->f__exec          = (void (*)(struct sidl_SIDLException__object*,const   \
    char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,      \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e4->f_addRef         = (void (*)(struct sidl_SIDLException__object*,struct  \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e4->f_deleteRef      = (void (*)(struct sidl_SIDLException__object*,struct  \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e4->f_isSame         = (sidl_bool (*)(struct sidl_SIDLException__object*,   \
    struct sidl_BaseInterface__object*,struct sidl_BaseInterface__object **)) \
    epv->f_isSame;
  e4->f_isType         = (sidl_bool (*)(struct sidl_SIDLException__object*,   \
    const char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e4->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(struct           \
    sidl_SIDLException__object*,struct sidl_BaseInterface__object **))        \
    epv->f_getClassInfo;
  e4->f_getNote        = (char* (*)(struct sidl_SIDLException__object*,struct \
    sidl_BaseInterface__object **)) epv->f_getNote;
  e4->f_setNote        = (void (*)(struct sidl_SIDLException__object*,const   \
    char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e4->f_getTrace       = (char* (*)(struct sidl_SIDLException__object*,struct \
    sidl_BaseInterface__object **)) epv->f_getTrace;
  e4->f_addLine        = (void (*)(struct sidl_SIDLException__object*,const   \
    char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e4->f_add            = (void (*)(struct sidl_SIDLException__object*,const   \
    char*,int32_t,const char*,struct sidl_BaseInterface__object **))          \
    epv->f_add;
  e4->f_packObj        = (void (*)(struct sidl_SIDLException__object*,struct  \
    sidl_io_Serializer__object*,struct sidl_BaseInterface__object **))        \
    epv->f_packObj;
  e4->f_unpackObj      = (void (*)(struct sidl_SIDLException__object*,struct  \
    sidl_io_Deserializer__object*,struct sidl_BaseInterface__object **))      \
    epv->f_unpackObj;

  e5->f__cast          = (void* (*)(struct sidl_io_IOException__object*,      \
    const char*, struct sidl_BaseInterface__object**)) epv->f__cast;
  e5->f__delete        = (void (*)(struct sidl_io_IOException__object*,       \
    struct sidl_BaseInterface__object**)) epv->f__delete;
  e5->f__getURL        = (char* (*)(struct sidl_io_IOException__object*,      \
    struct sidl_BaseInterface__object**)) epv->f__getURL;
  e5->f__raddRef       = (void (*)(struct sidl_io_IOException__object*,       \
    struct sidl_BaseInterface__object**)) epv->f__raddRef;
  e5->f__isRemote      = (sidl_bool (*)(struct sidl_io_IOException__object*,  \
    struct sidl_BaseInterface__object**)) epv->f__isRemote;
  e5->f__set_hooks     = (void (*)(struct sidl_io_IOException__object*,       \
    sidl_bool, struct sidl_BaseInterface__object**)) epv->f__set_hooks;
  e5->f__set_contracts = (void (*)(struct sidl_io_IOException__object*,       \
    sidl_bool, const char*, sidl_bool, struct sidl_BaseInterface__object**))  \
    epv->f__set_contracts;
  e5->f__dump_stats    = (void (*)(struct sidl_io_IOException__object*, const \
    char*, const char*, struct sidl_BaseInterface__object**))                 \
    epv->f__dump_stats;
  e5->f__exec          = (void (*)(struct sidl_io_IOException__object*,const  \
    char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,      \
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e5->f_addRef         = (void (*)(struct sidl_io_IOException__object*,struct \
    sidl_BaseInterface__object **)) epv->f_addRef;
  e5->f_deleteRef      = (void (*)(struct sidl_io_IOException__object*,struct \
    sidl_BaseInterface__object **)) epv->f_deleteRef;
  e5->f_isSame         = (sidl_bool (*)(struct sidl_io_IOException__object*,  \
    struct sidl_BaseInterface__object*,struct sidl_BaseInterface__object **)) \
    epv->f_isSame;
  e5->f_isType         = (sidl_bool (*)(struct sidl_io_IOException__object*,  \
    const char*,struct sidl_BaseInterface__object **)) epv->f_isType;
  e5->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(struct           \
    sidl_io_IOException__object*,struct sidl_BaseInterface__object **))       \
    epv->f_getClassInfo;
  e5->f_getNote        = (char* (*)(struct sidl_io_IOException__object*,      \
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e5->f_setNote        = (void (*)(struct sidl_io_IOException__object*,const  \
    char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e5->f_getTrace       = (char* (*)(struct sidl_io_IOException__object*,      \
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e5->f_addLine        = (void (*)(struct sidl_io_IOException__object*,const  \
    char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e5->f_add            = (void (*)(struct sidl_io_IOException__object*,const  \
    char*,int32_t,const char*,struct sidl_BaseInterface__object **))          \
    epv->f_add;
  e5->f_packObj        = (void (*)(struct sidl_io_IOException__object*,struct \
    sidl_io_Serializer__object*,struct sidl_BaseInterface__object **))        \
    epv->f_packObj;
  e5->f_unpackObj      = (void (*)(struct sidl_io_IOException__object*,struct \
    sidl_io_Deserializer__object*,struct sidl_BaseInterface__object **))      \
    epv->f_unpackObj;

  e6->f__cast          = (void* (*)(void*, const char*, struct                \
    sidl_BaseInterface__object**)) epv->f__cast;
  e6->f__delete        = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__delete;
  e6->f__getURL        = (char* (*)(void*, struct                             \
    sidl_BaseInterface__object**)) epv->f__getURL;
  e6->f__raddRef       = (void (*)(void*, struct                              \
    sidl_BaseInterface__object**)) epv->f__raddRef;
  e6->f__isRemote      = (sidl_bool (*)(void*, struct                         \
    sidl_BaseInterface__object**)) epv->f__isRemote;
  e6->f__set_hooks     = (void (*)(void*, sidl_bool, struct                   \
    sidl_BaseInterface__object**)) epv->f__set_hooks;
  e6->f__set_contracts = (void (*)(void*, sidl_bool, const char*, sidl_bool,  \
    struct sidl_BaseInterface__object**)) epv->f__set_contracts;
  e6->f__dump_stats    = (void (*)(void*, const char*, const char*, struct    \
    sidl_BaseInterface__object**)) epv->f__dump_stats;
  e6->f__exec          = (void (*)(void*,const char*,struct                   \
    sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,struct             \
    sidl_BaseInterface__object **)) epv->f__exec;
  e6->f_packObj        = (void (*)(void*,struct sidl_io_Serializer__object*,  \
    struct sidl_BaseInterface__object **)) epv->f_packObj;
  e6->f_unpackObj      = (void (*)(void*,struct sidl_io_Deserializer__object*,\
    struct sidl_BaseInterface__object **)) epv->f_unpackObj;
  e6->f_addRef         = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_addRef;
  e6->f_deleteRef      = (void (*)(void*,struct sidl_BaseInterface__object    \
    **)) epv->f_deleteRef;
  e6->f_isSame         = (sidl_bool (*)(void*,struct                          \
    sidl_BaseInterface__object*,struct sidl_BaseInterface__object **))        \
    epv->f_isSame;
  e6->f_isType         = (sidl_bool (*)(void*,const char*,struct              \
    sidl_BaseInterface__object **)) epv->f_isType;
  e6->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(void*,struct     \
    sidl_BaseInterface__object **)) epv->f_getClassInfo;

  e7->f__cast          = (void* (*)(struct sidl_rmi_NetworkException__object*,\
    const char*, struct sidl_BaseInterface__object**)) epv->f__cast;
  e7->f__delete        = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_BaseInterface__object**)) epv->f__delete;
  e7->f__getURL        = (char* (*)(struct sidl_rmi_NetworkException__object*,\
    struct sidl_BaseInterface__object**)) epv->f__getURL;
  e7->f__raddRef       = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_BaseInterface__object**)) epv->f__raddRef;
  e7->f__isRemote      = (sidl_bool (*)(struct                                \
    sidl_rmi_NetworkException__object*, struct sidl_BaseInterface__object**)) \
    epv->f__isRemote;
  e7->f__set_hooks     = (void (*)(struct sidl_rmi_NetworkException__object*, \
    sidl_bool, struct sidl_BaseInterface__object**)) epv->f__set_hooks;
  e7->f__set_contracts = (void (*)(struct sidl_rmi_NetworkException__object*, \
    sidl_bool, const char*, sidl_bool, struct sidl_BaseInterface__object**))  \
    epv->f__set_contracts;
  e7->f__dump_stats    = (void (*)(struct sidl_rmi_NetworkException__object*, \
    const char*, const char*, struct sidl_BaseInterface__object**))           \
    epv->f__dump_stats;
  e7->f__exec          = (void (*)(struct sidl_rmi_NetworkException__object*, \
    const char*,struct sidl_rmi_Call__object*,struct sidl_rmi_Return__object*,\
    struct sidl_BaseInterface__object **)) epv->f__exec;
  e7->f_getHopCount    = (int32_t (*)(struct                                  \
    sidl_rmi_NetworkException__object*,struct sidl_BaseInterface__object **)) \
    epv->f_getHopCount;
  e7->f_setErrno       = (void (*)(struct sidl_rmi_NetworkException__object*, \
    int32_t,struct sidl_BaseInterface__object **)) epv->f_setErrno;
  e7->f_getErrno       = (int32_t (*)(struct                                  \
    sidl_rmi_NetworkException__object*,struct sidl_BaseInterface__object **)) \
    epv->f_getErrno;
  e7->f_addRef         = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_BaseInterface__object **)) epv->f_addRef;
  e7->f_deleteRef      = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_BaseInterface__object **)) epv->f_deleteRef;
  e7->f_isSame         = (sidl_bool (*)(struct                                \
    sidl_rmi_NetworkException__object*,struct sidl_BaseInterface__object*,    \
    struct sidl_BaseInterface__object **)) epv->f_isSame;
  e7->f_isType         = (sidl_bool (*)(struct                                \
    sidl_rmi_NetworkException__object*,const char*,struct                     \
    sidl_BaseInterface__object **)) epv->f_isType;
  e7->f_getClassInfo   = (struct sidl_ClassInfo__object* (*)(struct           \
    sidl_rmi_NetworkException__object*,struct sidl_BaseInterface__object **)) \
    epv->f_getClassInfo;
  e7->f_getNote        = (char* (*)(struct sidl_rmi_NetworkException__object*,\
    struct sidl_BaseInterface__object **)) epv->f_getNote;
  e7->f_setNote        = (void (*)(struct sidl_rmi_NetworkException__object*, \
    const char*,struct sidl_BaseInterface__object **)) epv->f_setNote;
  e7->f_getTrace       = (char* (*)(struct sidl_rmi_NetworkException__object*,\
    struct sidl_BaseInterface__object **)) epv->f_getTrace;
  e7->f_addLine        = (void (*)(struct sidl_rmi_NetworkException__object*, \
    const char*,struct sidl_BaseInterface__object **)) epv->f_addLine;
  e7->f_add            = (void (*)(struct sidl_rmi_NetworkException__object*, \
    const char*,int32_t,const char*,struct sidl_BaseInterface__object **))    \
    epv->f_add;
  e7->f_packObj        = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_io_Serializer__object*,struct sidl_BaseInterface__object **)) \
    epv->f_packObj;
  e7->f_unpackObj      = (void (*)(struct sidl_rmi_NetworkException__object*, \
    struct sidl_io_Deserializer__object*,struct sidl_BaseInterface__object    \
    **)) epv->f_unpackObj;

  s_remote_initialized = 1;
}

/* Create an instance that connects to an existing remote object. */
static struct sidl_rmi_ObjectDoesNotExistException__object*
sidl_rmi_ObjectDoesNotExistException__remoteConnect(const char *url,          \
  sidl_bool ar, struct sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi_ObjectDoesNotExistException__object* self = NULL;

  struct sidl_rmi_ObjectDoesNotExistException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_ObjectDoesNotExistException__remote* r_obj = NULL;
  sidl_rmi_InstanceHandle instance = NULL;
  char* objectID = NULL;
  objectID = NULL;
  *_ex = NULL;
  if(url == NULL) {return NULL;}
  objectID = sidl_rmi_ServerRegistry_isLocalObject(url, _ex);
  if(objectID) {
    struct sidl_rmi_ObjectDoesNotExistException__object* retobj = NULL;
    struct sidl_BaseInterface__object *throwaway_exception;
    sidl_BaseInterface bi = (                                                 \
      sidl_BaseInterface)sidl_rmi_InstanceRegistry_getInstanceByString(       \
      objectID, _ex); SIDL_CHECK(*_ex);
    (*bi->d_epv->f_deleteRef)(bi->d_object, &throwaway_exception);
    retobj = (struct sidl_rmi_ObjectDoesNotExistException__object*) (         \
      *bi->d_epv->f__cast)(bi->d_object,                                      \
      "sidl.rmi.ObjectDoesNotExistException", _ex);
    if(!ar) { 
      (*bi->d_epv->f_deleteRef)(bi->d_object, &throwaway_exception);
    }
    return retobj;
  }
  instance = sidl_rmi_ProtocolFactory_connectInstance(url,                    \
    "sidl.rmi.ObjectDoesNotExistException", ar, _ex ); SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct sidl_rmi_ObjectDoesNotExistException__object*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__object));

  r_obj =
    (struct sidl_rmi_ObjectDoesNotExistException__remote*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__remote));

  if(!self || !r_obj) {
    sidl_MemAllocException ex = sidl_MemAllocException_getSingletonException( \
      _ex);
    SIDL_CHECK(*_ex);
    sidl_MemAllocException_setNote(ex, "Out of memory.", _ex); SIDL_CHECK(    \
      *_ex);
    sidl_MemAllocException_add(ex, __FILE__, __LINE__,                        \
      "sidl.rmi.ObjectDoesNotExistException.EPVgeneration", _ex);
    SIDL_CHECK(*_ex);
    *_ex = (struct sidl_BaseInterface__object*)ex;
    goto EXIT;
  }

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                                self;
  s1 =                                                                        \
    &s0->d_sidl_rmi_networkexception;
  s2 =                                                                        \
    &s1->d_sidl_io_ioexception;
  s3 =                                                                        \
    &s2->d_sidl_sidlexception;
  s4 =                                                &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_ObjectDoesNotExistException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_objectdoesnotexistexception;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  if(self) { free(self); }
  if(r_obj) { free(r_obj); }
  return NULL;
}
/* Create an instance that uses an already existing  */
/* InstanceHandle to connect to an existing remote object. */
static struct sidl_rmi_ObjectDoesNotExistException__object*
sidl_rmi_ObjectDoesNotExistException__IHConnect(sidl_rmi_InstanceHandle       \
  instance, struct sidl_BaseInterface__object* *_ex)
{
  struct sidl_rmi_ObjectDoesNotExistException__object* self = NULL;

  struct sidl_rmi_ObjectDoesNotExistException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_ObjectDoesNotExistException__remote* r_obj = NULL;
  self =
    (struct sidl_rmi_ObjectDoesNotExistException__object*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__object));

  r_obj =
    (struct sidl_rmi_ObjectDoesNotExistException__remote*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__remote));

  if(!self || !r_obj) {
    sidl_MemAllocException ex = sidl_MemAllocException_getSingletonException( \
      _ex);
    SIDL_CHECK(*_ex);
    sidl_MemAllocException_setNote(ex, "Out of memory.", _ex); SIDL_CHECK(    \
      *_ex);
    sidl_MemAllocException_add(ex, __FILE__, __LINE__,                        \
      "sidl.rmi.ObjectDoesNotExistException.EPVgeneration", _ex);
    SIDL_CHECK(*_ex);
    *_ex = (struct sidl_BaseInterface__object*)ex;
    goto EXIT;
  }

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                                self;
  s1 =                                                                        \
    &s0->d_sidl_rmi_networkexception;
  s2 =                                                                        \
    &s1->d_sidl_io_ioexception;
  s3 =                                                                        \
    &s2->d_sidl_sidlexception;
  s4 =                                                &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_ObjectDoesNotExistException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_objectdoesnotexistexception;

  self->d_data = (void*) r_obj;

  sidl_rmi_InstanceHandle_addRef(instance,_ex);SIDL_CHECK(*_ex);
  return self;
  EXIT:
  if(self) { free(self); }
  if(r_obj) { free(r_obj); }
  return NULL;
}
/* REMOTE: generate remote instance given URL string. */
static struct sidl_rmi_ObjectDoesNotExistException__object*
sidl_rmi_ObjectDoesNotExistException__remoteCreate(const char *url, struct    \
  sidl_BaseInterface__object **_ex)
{
  struct sidl_BaseInterface__object* _throwaway_exception = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object* self = NULL;

  struct sidl_rmi_ObjectDoesNotExistException__object* s0;
  struct sidl_rmi_NetworkException__object* s1;
  struct sidl_io_IOException__object* s2;
  struct sidl_SIDLException__object* s3;
  struct sidl_BaseClass__object* s4;

  struct sidl_rmi_ObjectDoesNotExistException__remote* r_obj = NULL;
  sidl_rmi_InstanceHandle instance = sidl_rmi_ProtocolFactory_createInstance( \
    url, "sidl.rmi.ObjectDoesNotExistException", _ex ); SIDL_CHECK(*_ex);
  if ( instance == NULL) { return NULL; }
  self =
    (struct sidl_rmi_ObjectDoesNotExistException__object*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__object));

  r_obj =
    (struct sidl_rmi_ObjectDoesNotExistException__remote*) malloc(
      sizeof(struct sidl_rmi_ObjectDoesNotExistException__remote));

  if(!self || !r_obj) {
    sidl_MemAllocException ex = sidl_MemAllocException_getSingletonException( \
      _ex);
    SIDL_CHECK(*_ex);
    sidl_MemAllocException_setNote(ex, "Out of memory.", _ex); SIDL_CHECK(    \
      *_ex);
    sidl_MemAllocException_add(ex, __FILE__, __LINE__,                        \
      "sidl.rmi.ObjectDoesNotExistException.EPVgeneration", _ex);
    SIDL_CHECK(*_ex);
    *_ex = (struct sidl_BaseInterface__object*)ex;
    goto EXIT;
  }

  r_obj->d_refcount = 1;
  r_obj->d_ih = instance;
  s0 =                                                self;
  s1 =                                                                        \
    &s0->d_sidl_rmi_networkexception;
  s2 =                                                                        \
    &s1->d_sidl_io_ioexception;
  s3 =                                                                        \
    &s2->d_sidl_sidlexception;
  s4 =                                                &s3->d_sidl_baseclass;

  LOCK_STATIC_GLOBALS;
  if (!s_remote_initialized) {
    sidl_rmi_ObjectDoesNotExistException__init_remote_epv();
  }
  UNLOCK_STATIC_GLOBALS;

  s4->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
  s4->d_sidl_baseinterface.d_object = (void*) self;

  s4->d_data = (void*) r_obj;
  s4->d_epv  = &s_rem_epv__sidl_baseclass;

  s3->d_sidl_baseexception.d_epv    = &s_rem_epv__sidl_baseexception;
  s3->d_sidl_baseexception.d_object = (void*) self;

  s3->d_sidl_io_serializable.d_epv    = &s_rem_epv__sidl_io_serializable;
  s3->d_sidl_io_serializable.d_object = (void*) self;

  s3->d_data = (void*) r_obj;
  s3->d_epv  = &s_rem_epv__sidl_sidlexception;

  s2->d_sidl_runtimeexception.d_epv    = &s_rem_epv__sidl_runtimeexception;
  s2->d_sidl_runtimeexception.d_object = (void*) self;

  s2->d_data = (void*) r_obj;
  s2->d_epv  = &s_rem_epv__sidl_io_ioexception;

  s1->d_data = (void*) r_obj;
  s1->d_epv  = &s_rem_epv__sidl_rmi_networkexception;

  s0->d_data = (void*) r_obj;
  s0->d_epv  = &s_rem_epv__sidl_rmi_objectdoesnotexistexception;

  self->d_data = (void*) r_obj;

  return self;
  EXIT:
  if(instance) { sidl_rmi_InstanceHandle_deleteRef(instance,                  \
    &_throwaway_exception); }
  if(self) { free(self); }
  if(r_obj) { free(r_obj); }
  return NULL;
}
/*
 * RMI connector function for the class.
 */

struct sidl_rmi_ObjectDoesNotExistException__object*
sidl_rmi_ObjectDoesNotExistException__connectI(const char* url, sidl_bool ar, \
  struct sidl_BaseInterface__object **_ex)
{
  return sidl_rmi_ObjectDoesNotExistException__remoteConnect(url, ar, _ex);
}


#endif /*WITH_RMI*/
#ifdef WITH_RMI

static PyObject *
pStub_ObjectDoesNotExistException__connect(PyObject *_ignored, PyObject       \
  *_args, PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object* self = NULL;
  char* url = NULL;
  struct sidl_BaseInterface__object *_exception = NULL;
  static char *_kwlist[] = {
    "url",
    NULL
  };
  int _okay;
  _okay = PyArg_ParseTupleAndKeywords(
    _args, _kwdict, 
    "z", _kwlist,
    &url);
  if (_okay) {
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    self = sidl_rmi_ObjectDoesNotExistException__remoteConnect(url,1,         \
      &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    if (_exception) {
      struct sidl_rmi_NetworkException__object *_ex0;
      if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
      sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
        struct sidl_BaseInterface__object *throwaway_exception;
        PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
        PyObject *_eargs = PyTuple_New(1);
        PyTuple_SetItem(_eargs, 0, _obj);
        _obj = PyObject_CallObject(sidl_rmi_NetworkException__type, _eargs);
        PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
        Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_BEGIN_ALLOW_THREADS
        sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
        (*(_exception->d_epv->f_deleteRef))(_exception->d_object,             \
          &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
        Py_END_ALLOW_THREADS
        sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
        Py_XDECREF(_eargs);
      }
    }
    else {
      _return_value = Py_BuildValue(
        "O&",
        (void *)sidl_rmi_ObjectDoesNotExistException__wrap, self);
    }
  }
  return _return_value;
}


#endif /*WITH_RMI*/
staticforward PyTypeObject _sidl_rmi_ObjectDoesNotExistExceptionType;

static const struct sidl_rmi_ObjectDoesNotExistException__external *_implEPV  \
  = NULL;

static PyObject *
pStub_ObjectDoesNotExistException__exec(PyObject *_self, PyObject *_args,     \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object *_self_ior =
    ((struct sidl_rmi_ObjectDoesNotExistException__object *)
     sidl_Cast(_self, "sidl.rmi.ObjectDoesNotExistException"));
  if (_self_ior) {
    char* methodName = NULL;
    struct sidl_rmi_Call__object* inArgs = NULL;
    struct sidl_rmi_Return__object* outArgs = NULL;
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      "methodName",
      "inArgs",
      "outArgs",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    sidl_rmi_Call__import();
    sidl_rmi_Return__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "zO&O&", _kwlist,
      &methodName,
      (void *)sidl_rmi_Call__convert, &inArgs,
      (void *)sidl_rmi_Return__convert, &outArgs);
    if (_okay) {
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f__exec))(_self_ior, methodName, inArgs, outArgs,  \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      sidl_rmi_Call_deref(inArgs);
      sidl_rmi_Return_deref(outArgs);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ObjectDoesNotExistException");
  }
  return _return_value;
}

static PyObject *
pStub_ObjectDoesNotExistException__getURL(PyObject *_self, PyObject *_args,   \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object *_self_ior =
    ((struct sidl_rmi_ObjectDoesNotExistException__object *)
     sidl_Cast(_self, "sidl.rmi.ObjectDoesNotExistException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      char* _return = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f__getURL))(_self_ior, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "z",
          _return);
        free((void *)_return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ObjectDoesNotExistException");
  }
  return _return_value;
}

static PyObject *
pStub_ObjectDoesNotExistException__isLocal(PyObject *_self, PyObject *_args,  \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object *_self_ior =
    ((struct sidl_rmi_ObjectDoesNotExistException__object *)
     sidl_Cast(_self, "sidl.rmi.ObjectDoesNotExistException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = !(*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ObjectDoesNotExistException");
  }
  return _return_value;
}

static PyObject *
pStub_ObjectDoesNotExistException__isRemote(PyObject *_self, PyObject *_args, \
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object *_self_ior =
    ((struct sidl_rmi_ObjectDoesNotExistException__object *)
     sidl_Cast(_self, "sidl.rmi.ObjectDoesNotExistException"));
  if (_self_ior) {
    struct sidl_BaseInterface__object *_exception = NULL;
    static char *_kwlist[] = {
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "", _kwlist);
    if (_okay) {
      sidl_bool _return = (sidl_bool) 0;
      int _proxy__return;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _return = (*(_self_ior->d_epv->f__isRemote))(_self_ior, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      _proxy__return = _return;
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_BuildValue(
          "i",
          _proxy__return);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ObjectDoesNotExistException");
  }
  return _return_value;
}

static PyObject *
pStub_ObjectDoesNotExistException__set_hooks(PyObject *_self, PyObject *_args,\
  PyObject *_kwdict) {
  PyObject *_return_value = NULL;
  struct sidl_rmi_ObjectDoesNotExistException__object *_self_ior =
    ((struct sidl_rmi_ObjectDoesNotExistException__object *)
     sidl_Cast(_self, "sidl.rmi.ObjectDoesNotExistException"));
  if (_self_ior) {
    sidl_bool enable = (sidl_bool) 0;
    struct sidl_BaseInterface__object *_exception = NULL;
    int _proxy_enable;
    static char *_kwlist[] = {
      "enable",
      NULL
    };
    int _okay;
    sidl_RuntimeException__import();
    _okay = PyArg_ParseTupleAndKeywords(
      _args, _kwdict, 
      "i", _kwlist,
      &_proxy_enable);
    if (_okay) {
      enable = (_proxy_enable ? (TRUE) : (FALSE));
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f__set_hooks))(_self_ior, enable, &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        struct sidl_RuntimeException__object *_ex0;
        if ((_ex0 = (struct sidl_RuntimeException__object *)
        sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
          struct sidl_BaseInterface__object *throwaway_exception;
          PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
          PyObject *_eargs = PyTuple_New(1);
          PyTuple_SetItem(_eargs, 0, _obj);
          _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
          PyErr_SetObject(sidl_RuntimeException__type, _obj);
          Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_BEGIN_ALLOW_THREADS
          sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          (*(_exception->d_epv->f_deleteRef))(_exception->d_object,           \
            &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
          Py_END_ALLOW_THREADS
          sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
          Py_XDECREF(_eargs);
        }
      }
      else {
        _return_value = Py_None;
        Py_INCREF(_return_value);
      }
    }
    {
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*(_self_ior->d_epv->f_deleteRef))(_self_ior, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
  }
  else {
    PyErr_SetString(PyExc_TypeError, 
      "self pointer is not a sidl.rmi.ObjectDoesNotExistException");
  }
  return _return_value;
}

static int
sidl_rmi_ObjectDoesNotExistException_createCast(PyObject *self, PyObject      \
  *args, PyObject *kwds) {
  struct sidl_rmi_ObjectDoesNotExistException__object *optarg = NULL;
  char* url = NULL;
  PyObject * implObj = NULL;
  static char *_kwlist[] = {"sobj",  "url", "impl", NULL };
  int _okay = PyArg_ParseTupleAndKeywords(args, kwds, "|O&zO", _kwlist, (void \
    *)sidl_rmi_ObjectDoesNotExistException__convert, &optarg, &url, &implObj);
  if (_okay) {
    if (!optarg && !url && !implObj) {
      struct sidl_BaseInterface__object *_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      optarg = (*(_implEPV->createObject))(NULL,&_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_eargs = PyTuple_New(1);
            PyTuple_SetItem(_eargs, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_BEGIN_ALLOW_THREADS
            sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_END_ALLOW_THREADS
            sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            Py_XDECREF(_eargs);
          }
          return -1;
        }
      }
    }
    else if (!optarg && !url && implObj) {
      struct sidl_BaseInterface__object *_exception;
      Py_INCREF(implObj);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      optarg = (*(_implEPV->createObject))((void*)implObj,&_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        sidl_RuntimeException__import();
        {
          struct sidl_RuntimeException__object *_ex0;
          if ((_ex0 = (struct sidl_RuntimeException__object *)
          sidl_PyExceptionCast(_exception, "sidl.RuntimeException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_RuntimeException__wrap(_ex0);
            PyObject *_eargs = PyTuple_New(1);
            PyTuple_SetItem(_eargs, 0, _obj);
            _obj = PyObject_CallObject(sidl_RuntimeException__type, _eargs);
            PyErr_SetObject(sidl_RuntimeException__type, _obj);
            Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_BEGIN_ALLOW_THREADS
            sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_END_ALLOW_THREADS
            sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            Py_XDECREF(_eargs);
          }
          return -1;
        }
      }
    }

#ifdef WITH_RMI

    else if(url && !optarg && !implObj) {
      struct sidl_BaseInterface__object *_exception = NULL;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      optarg = sidl_rmi_ObjectDoesNotExistException__remoteCreate(url,        \
        &_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      if (_exception) {
        sidl_rmi_NetworkException__import();
        {
          struct sidl_rmi_NetworkException__object *_ex0;
          if ((_ex0 = (struct sidl_rmi_NetworkException__object *)
          sidl_PyExceptionCast(_exception, "sidl.rmi.NetworkException"))) {
            struct sidl_BaseInterface__object *throwaway_exception;
            PyObject *_obj = sidl_rmi_NetworkException__wrap(_ex0);
            PyObject *_eargs = PyTuple_New(1);
            PyTuple_SetItem(_eargs, 0, _obj);
            _obj = PyObject_CallObject(sidl_rmi_NetworkException__type,       \
              _eargs);
            PyErr_SetObject(sidl_rmi_NetworkException__type, _obj);
            Py_XDECREF(_obj);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_BEGIN_ALLOW_THREADS
            sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            (*(_exception->d_epv->f_deleteRef))(_exception->d_object,         \
              &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_END_ALLOW_THREADS
            sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            Py_XDECREF(_eargs);
          }
          }
        return -1;
      }
    }

#endif /*WITH_RMI*/

    /* OK, but fall though */
    else if(!url && optarg && !implObj) {}
    /* Error case. */
    else {
      return -1;
    }
    return sidl_Object_Init(
      (SPObject *)self,
      (struct sidl_BaseInterface__object *)optarg,
      sidl_PyStealRef);
  }
  return -1;
}

static PyMethodDef _ObjectDoesNotExistExceptionModuleMethods[] = {

#ifdef WITH_RMI

  { "_connect", (PyCFunction)pStub_ObjectDoesNotExistException__connect,
  (METH_VARARGS | METH_KEYWORDS),
"\
_connect( in string url)\n\
RETURNS\n\
   ( out sidl.rmi.ObjectDoesNotExistException self)\n\
RAISES\n\
    sidl.rmi.NetworkException\n\
"
   },

#endif /*WITH_RMI*/

  { NULL, NULL }
};

static PyMethodDef _ObjectDoesNotExistExceptionObjectMethods[] = {
  { "_exec", (PyCFunction)pStub_ObjectDoesNotExistException__exec,
  (METH_VARARGS | METH_KEYWORDS),
"\
_exec( in string methodName,\n\
       in sidl.rmi.Call inArgs,\n\
       in sidl.rmi.Return outArgs)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Select and execute a method by name"
   },
  { "_getURL", (PyCFunction)pStub_ObjectDoesNotExistException__getURL,
  (METH_VARARGS | METH_KEYWORDS),
"\
_getURL()\n\
RETURNS\n\
   (string _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Get the URL of the Implementation of this object (for RMI)"
   },
  { "_isLocal", (PyCFunction)pStub_ObjectDoesNotExistException__isLocal,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isLocal()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is local, false if remote"
   },
  { "_isRemote", (PyCFunction)pStub_ObjectDoesNotExistException__isRemote,
  (METH_VARARGS | METH_KEYWORDS),
"\
_isRemote()\n\
RETURNS\n\
   (bool _return)\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
TRUE if this object is remote, false if local"
   },
  { "_set_hooks", (PyCFunction)pStub_ObjectDoesNotExistException__set_hooks,
  (METH_VARARGS | METH_KEYWORDS),
"\
_set_hooks( in bool enable)\n\
RETURNS\n\
    None\n\
RAISES\n\
    sidl.RuntimeException\n\
\n\
\
Method to enable/disable method hooks invocation."
   },
  { NULL, NULL }
};

static PyTypeObject _sidl_rmi_ObjectDoesNotExistExceptionType = {
  PyObject_HEAD_INIT(NULL)
  0,      /* ob_size */
  "sidl.rmi.ObjectDoesNotExistException.ObjectDoesNotExistException", /*      \
    tp_name */
  0,      /* tp_basicsize */
  0,      /* tp_itemsize */
  0,      /* tp_dealloc */
  0,      /* tp_print */
  0,      /* tp_getattr */
  0,      /* tp_setattr */
  0,      /* tp_compare */
  0,      /* tp_repr */
  0,      /* tp_as_number */
  0,      /* tp_as_sequence */
  0,      /* tp_as_mapping */
  0,      /* tp_hash  */
  0,      /* tp_call */
  0,      /* tp_str */
  0,      /* tp_getattro */
  0,      /* tp_setattro */
  0,      /* tp_as_buffer */
  Py_TPFLAGS_DEFAULT, /* tp_flags */
  "\
\
This exception is thrown by a server when a passed in object \n\
id does not match any known object. ", /* tp_doc */
  0,      /* tp_traverse */
  0,       /* tp_clear */
  0,       /* tp_richcompare */
  0,       /* tp_weaklistoffset */
  0,       /* tp_iter */
  0,       /* tp_iternext */
  _ObjectDoesNotExistExceptionObjectMethods, /* tp_methods */
  0,       /* tp_members */
  0,       /* tp_getset */
  0,       /* tp_base */
  0,       /* tp_dict */
  0,       /* tp_descr_get */
  0,       /* tp_descr_set */
  0,       /* tp_dictoffset */
  sidl_rmi_ObjectDoesNotExistException_createCast,   /* tp_init */
  0,       /* tp_alloc */
  0,       /* tp_new */
};

sidl_rmi_ObjectDoesNotExistException__wrap_RETURN
sidl_rmi_ObjectDoesNotExistException__wrap                                    \
  sidl_rmi_ObjectDoesNotExistException__wrap_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ObjectDoesNotExistExceptionType.tp_new(                \
      &_sidl_rmi_ObjectDoesNotExistExceptionType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyStealRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ObjectDoesNotExistException__weakRef_RETURN
sidl_rmi_ObjectDoesNotExistException__weakRef                                 \
  sidl_rmi_ObjectDoesNotExistException__weakRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ObjectDoesNotExistExceptionType.tp_new(                \
      &_sidl_rmi_ObjectDoesNotExistExceptionType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyWeakRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ObjectDoesNotExistException_deref_RETURN
sidl_rmi_ObjectDoesNotExistException_deref                                    \
  sidl_rmi_ObjectDoesNotExistException_deref_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_deleteRef))(sidlobj, &throwaway_exception);
  }
}

sidl_rmi_ObjectDoesNotExistException__newRef_RETURN
sidl_rmi_ObjectDoesNotExistException__newRef                                  \
  sidl_rmi_ObjectDoesNotExistException__newRef_PROTO {
  PyObject *result;
  if (sidlobj) {
    result = _sidl_rmi_ObjectDoesNotExistExceptionType.tp_new(                \
      &_sidl_rmi_ObjectDoesNotExistExceptionType, NULL, NULL);
    if (result) {
      if (sidl_Object_Init(
        (SPObject *)result,
        (struct sidl_BaseInterface__object *)(sidlobj),
        sidl_PyNewRef))
      {
        Py_DECREF(result);
        result = NULL;
      }
    }
  }
  else {
    result = Py_None;
    Py_INCREF(result);
  }
  return result;
}

sidl_rmi_ObjectDoesNotExistException__addRef_RETURN
sidl_rmi_ObjectDoesNotExistException__addRef                                  \
  sidl_rmi_ObjectDoesNotExistException__addRef_PROTO {
  if (sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
    (*(sidlobj->d_epv->f_addRef))(sidlobj, &throwaway_exception);
  }
}

sidl_rmi_ObjectDoesNotExistException_PyType_RETURN
sidl_rmi_ObjectDoesNotExistException_PyType                                   \
  sidl_rmi_ObjectDoesNotExistException_PyType_PROTO {
  Py_INCREF(&_sidl_rmi_ObjectDoesNotExistExceptionType);
  return &_sidl_rmi_ObjectDoesNotExistExceptionType;
}

sidl_rmi_ObjectDoesNotExistException__convert_RETURN
sidl_rmi_ObjectDoesNotExistException__convert                                 \
  sidl_rmi_ObjectDoesNotExistException__convert_PROTO {
  if (*sidlobj) {
    struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    (*((*sidlobj)->d_epv->f_deleteRef))((*sidlobj), &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
  }
  *sidlobj = sidl_Cast(obj, "sidl.rmi.ObjectDoesNotExistException");
  if ((!(*sidlobj)) && (obj != Py_None)) {
    PyErr_SetString(PyExc_TypeError, 
      "argument is not a(n) sidl.rmi.ObjectDoesNotExistException");
    return 0;
  }
  return 1;
}

static int
_convertPython(void *sidlarray, const int *ind, PyObject *pyobj)
{
  struct sidl_rmi_ObjectDoesNotExistException__object *sidlobj = NULL;
  if (sidl_rmi_ObjectDoesNotExistException__convert(pyobj, &sidlobj)) {
    sidl_interface__array_set((struct sidl_interface__array *)sidlarray,
    ind, (struct sidl_BaseInterface__object *)sidlobj);
    if (sidlobj) {
      struct sidl_BaseInterface__object *asInt = (struct                      \
        sidl_BaseInterface__object *)sidlobj;
      struct sidl_BaseInterface__object *throwaway_exception;
#if (PY_VERSION_HEX >= 0x02040000)
      Py_BEGIN_ALLOW_THREADS
      sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
      (*asInt->d_epv->f_deleteRef)(asInt->d_object, &throwaway_exception);
#if (PY_VERSION_HEX >= 0x02040000)
      Py_END_ALLOW_THREADS
      sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    }
    return FALSE;
  }
  return TRUE;
}

sidl_rmi_ObjectDoesNotExistException__convert_python_array_RETURN
sidl_rmi_ObjectDoesNotExistException__convert_python_array                    \
  sidl_rmi_ObjectDoesNotExistException__convert_python_array_PROTO {
  int result = 0;
  if (*sidlarray) {
#if (PY_VERSION_HEX >= 0x02040000)
    Py_BEGIN_ALLOW_THREADS
    sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    sidl__array_deleteRef((struct sidl__array *)*sidlarray);
#if (PY_VERSION_HEX >= 0x02040000)
    Py_END_ALLOW_THREADS
    sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
    *sidlarray = NULL;
  }
  if (obj == Py_None) {
    result = TRUE;
  }
  else {
    PyObject *pya = PyArray_FromObject(obj, PyArray_OBJECT, 0, 0);
    if (pya) {
      if (PyArray_OBJECT == ((PyArrayObject *)pya)->descr->type_num) {
        int dimen, lower[SIDL_MAX_ARRAY_DIMENSION],
          upper[SIDL_MAX_ARRAY_DIMENSION],
          stride[SIDL_MAX_ARRAY_DIMENSION];
        if (sidl_array__extract_python_info
          (pya, &dimen, lower, upper, stride))
        {
            *sidlarray = (struct                                              \
              sidl_rmi_ObjectDoesNotExistException__array*)sidl_interface__array_createRow
            (dimen, lower, upper);
          result = sidl_array__convert_python
            (pya, dimen, *sidlarray, _convertPython);
          if (*sidlarray && !result) {
#if (PY_VERSION_HEX >= 0x02040000)
            Py_BEGIN_ALLOW_THREADS
            sidl_Python_LogUnlock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            sidl_interface__array_deleteRef(
              (struct  sidl_interface__array *)*sidlarray);
#if (PY_VERSION_HEX >= 0x02040000)
            Py_END_ALLOW_THREADS
            sidl_Python_LogRelock(__func__, __FILE__, __LINE__);
#endif /* Python 2.4 or later */
            *sidlarray = NULL;
          }
        }
      }
      Py_DECREF(pya);
    }
  }
  return result;
}

static int
_convertSIDL(void *sidlarray, const int *ind, PyObject **dest)
{
  struct sidl_rmi_ObjectDoesNotExistException__object *sidlobj = (struct      \
    sidl_rmi_ObjectDoesNotExistException__object*)
  sidl_interface__array_get((struct sidl_interface__array *)
    sidlarray, ind);
  *dest = sidl_rmi_ObjectDoesNotExistException__wrap(sidlobj);
  return (*dest == NULL);
}

sidl_rmi_ObjectDoesNotExistException__convert_sidl_array_RETURN
sidl_rmi_ObjectDoesNotExistException__convert_sidl_array                      \
  sidl_rmi_ObjectDoesNotExistException__convert_sidl_array_PROTO {
  PyObject *pya = NULL;
  if (sidlarray) {
    const int dimen = sidlArrayDim(sidlarray);
    int numelem[7];
    int32_t start[7];
#if SIZEOF_INT != 4
    int lower[7];
    int upper[7];
    int32_t s_numelem[7];
#else
    int * const lower = (int *)(sidlarray->d_lower);
    int * const upper = (int *)(sidlarray->d_upper);
    int32_t * const s_numelem = numelem;
#endif
    int i;
    for(i = 0; i < dimen; ++i) {
      start[i] = sidlLower(sidlarray, i);
#if SIZEOF_INT != 4
      lower[i] = sidlLower(sidlarray, i);
      upper[i] = sidlUpper(sidlarray, i);
      s_numelem[i] = sidlLength(sidlarray, i);
#endif
      numelem[i] = 1 + upper[i] - lower[i];
    }
    pya = PyArray_FromDims(dimen, numelem, PyArray_OBJECT);
    if (pya) {
      if (!sidl_array__convert_sidl(pya, dimen, start,
        sidlarray->d_upper,
        s_numelem, sidlarray, _convertSIDL))
      {
        Py_DECREF(pya);
        pya = NULL;
      }
    }
  }
  else {
    Py_INCREF(Py_None);
    pya = Py_None;
  }
  return pya;
}

void
initObjectDoesNotExistException(void) {
  PyObject *module, *dict, *c_api;
  PyObject *_exceptionBases, *_exceptionDict, *_exceptionName;
  static void *ExternalAPI[sidl_rmi_ObjectDoesNotExistException__API_NUM];
  struct sidl_BaseInterface__object *throwaway_exception;
  module = Py_InitModule3("ObjectDoesNotExistException",                      \
    _ObjectDoesNotExistExceptionModuleMethods, "\
\
This exception is thrown by a server when a passed in object \n\
id does not match any known object. "
  );
  dict = PyModule_GetDict(module);
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__wrap_NUM] = (             \
    void*)sidl_rmi_ObjectDoesNotExistException__wrap;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__convert_NUM] = (          \
    void*)sidl_rmi_ObjectDoesNotExistException__convert;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__convert_python_array_NUM] \
    = (void*)sidl_rmi_ObjectDoesNotExistException__convert_python_array;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__convert_sidl_array_NUM] = \
    (void*)sidl_rmi_ObjectDoesNotExistException__convert_sidl_array;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__weakRef_NUM] = (          \
    void*)sidl_rmi_ObjectDoesNotExistException__weakRef;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException_deref_NUM] = (             \
    void*)sidl_rmi_ObjectDoesNotExistException_deref;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__newRef_NUM] = (           \
    void*)sidl_rmi_ObjectDoesNotExistException__newRef;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__addRef_NUM] = (           \
    void*)sidl_rmi_ObjectDoesNotExistException__addRef;
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException_PyType_NUM] = (            \
    void*)sidl_rmi_ObjectDoesNotExistException_PyType;
#ifdef WITH_RMI
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__connectI_NUM] = (         \
    void*)sidl_rmi_ObjectDoesNotExistException__connectI;
#endif /*WITH_RMI*/
  import_SIDLObjA();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlObjA module.");
  }
  /* Initialize to temporary value. */
  Py_INCREF(Py_None);
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__type_NUM] = Py_None;
  c_api = PyCObject_FromVoidPtr((void *)ExternalAPI, NULL);
  PyDict_SetItemString(dict, "_C_API", c_api);
  Py_XDECREF(c_api);
  import_SIDLPyArrays();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing sidlPyArrays module.");
  }
  import_array();
  if (PyErr_Occurred()) {
    Py_FatalError("Error importing Numeric Python module.");
  }
  sidl_rmi_NetworkException__import();
  _sidl_rmi_ObjectDoesNotExistExceptionType.tp_base =                         \
    sidl_rmi_NetworkException_PyType();
  _sidl_rmi_ObjectDoesNotExistExceptionType.tp_bases = PyTuple_New(1);
  PyTuple_SetItem(_sidl_rmi_ObjectDoesNotExistExceptionType.tp_bases,0, (     \
    PyObject *)sidl_rmi_NetworkException_PyType());
  if (PyType_Ready(&_sidl_rmi_ObjectDoesNotExistExceptionType) < 0) {
    PyErr_Print();
    fprintf(stderr, "PyType_Ready on sidl.rmi.ObjectDoesNotExistException     \
      failed.\n");
    return;
  }
  Py_INCREF(&_sidl_rmi_ObjectDoesNotExistExceptionType);
  PyDict_SetItemString(dict, "ObjectDoesNotExistException", (PyObject         \
    *)&_sidl_rmi_ObjectDoesNotExistExceptionType);
  _exceptionBases = PyTuple_New(1);
  Py_INCREF(sidl_rmi_NetworkException__type);
  PyTuple_SetItem(_exceptionBases, 0, sidl_rmi_NetworkException__type);
  _exceptionDict = PyDict_New();
  PyDict_SetItemString(_exceptionDict, "__module__",
    PyString_InternFromString("sidl.rmi.ObjectDoesNotExistException"));
  _exceptionName = PyString_InternFromString("_Exception");
  sidl_rmi_ObjectDoesNotExistException__type = PyClass_New(_exceptionBases,   \
    _exceptionDict, _exceptionName);
  Py_XDECREF(_exceptionBases);
  Py_XDECREF(_exceptionDict);
  Py_XDECREF(_exceptionName);
  Py_XINCREF(sidl_rmi_ObjectDoesNotExistException__type);
  PyDict_SetItemString(dict, "_Exception",                                    \
    sidl_rmi_ObjectDoesNotExistException__type);
  ExternalAPI[sidl_rmi_ObjectDoesNotExistException__type_NUM] =               \
    sidl_rmi_ObjectDoesNotExistException__type;
  /*
   * If it's safe, add "Exception" for backward compatibility
   * with Babel 0.10.2 (and previous).
   */

  if (!PyDict_GetItemString(dict, "Exception")) {
    Py_XINCREF(sidl_rmi_ObjectDoesNotExistException__type);
    PyDict_SetItemString(dict, "Exception",                                   \
      sidl_rmi_ObjectDoesNotExistException__type);
  }
  _implEPV = sidl_rmi_ObjectDoesNotExistException__externals();
  if (PyErr_Occurred()) {
    Py_FatalError("Cannot initialize Python module sidl.rmi.ObjectDoesNotExistException.");
  }

#ifdef WITH_RMI


  sidl_rmi_ConnectRegistry_registerConnect(                                   \
    "sidl.rmi.ObjectDoesNotExistException", (                                 \
    void*)sidl_rmi_ObjectDoesNotExistException__IHConnect,                    \
    &throwaway_exception);

#endif /*WITH_RMI*/

}
