//
// File:        PythonClientC.java
// Package:     gov.llnl.babel.backend.python
// Copyright:   (c) 2007 Lawrence Livermore National Security, LLC
// Release:     $Name$
// Revision:    @(#) $Revision: 6201 $
// Date:        $Date: 2007-10-25 23:15:35 -0700 (Thu, 25 Oct 2007) $
// Description: Basic shared capabilities for writing to C
// 

package gov.llnl.babel.backend.python;
import gov.llnl.babel.Context;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Symbol;
import java.util.HashSet;
import java.util.Set;


public class PythonClientC {
  
  /**
   * A writer for the C source file.
   */
  protected LanguageWriterForC d_lw = null;

  protected Context d_context;

  protected Symbol d_sym = null;

  protected String d_shortName = null;

  private Set                d_includedFiles;

  public PythonClientC(Symbol sym, Context context) {
    d_sym = sym;
    d_shortName = sym.getSymbolID().getShortName();
    d_includedFiles = new HashSet();
    d_context = context;
  }

  final public String getName() {
    return d_shortName;
  }

  protected void addInclude(String filename, boolean useGuard) {
    if (!d_includedFiles.contains(filename)) {
      d_includedFiles.add(filename);
      d_lw.generateInclude(filename, useGuard);
    }
  }

  /**
   * Write a comment explaining the contents of the source file to 
   * anyone who might happen to read it.
   */
  public void explainExtensionSource() {
    d_lw.beginBlockComment(false);
    d_lw.println("THIS CODE IS AUTOMATICALLY GENERATED BY THE BABEL");
    d_lw.println("COMPILER. DO NOT EDIT THIS!");
    d_lw.println();
    d_lw.println("This file contains the implementation of a Python C");
    d_lw.println("extension type (i.e. a Python type implemented in C).");
    d_lw.println("This extension type provides Python interface to the");
    d_lw.print("sidl type ");
    d_lw.print(d_sym.getFullName());
    d_lw.println(".");
    d_lw.endBlockComment(false);
    d_lw.println();
  }

  public void pythonDocComment()
  {
    if ((d_sym.getComment() != null) && 
        (d_sym.getComment().getComment() != null)) {
      copyComment(d_sym.getComment());
    }
    else {
      d_lw.printlnUnformatted("SIDL wrapper for the " +
                   d_sym.getFullName() + " type.\\");
    }
  }

  /**
   * Convert a comment into a C string.
   *
   * @param c   the comment to convert
   */
  public void copyComment(Comment c) {
    if (c != null) {
      final String [] lines = c.getComment();
      if (lines != null) {
        int i = 0;
        d_lw.printlnUnformatted("\\");
        while (i < lines.length) {
          d_lw.printUnformatted
            (LanguageWriterForC.toSafeString(lines[i]));
          if (++i < lines.length) {
            d_lw.printlnUnformatted("\\n\\");
          }
        }
      }
    }
  }

}
