# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import map_error

from .. import models


class FileOperations(object):
    """FileOperations operations.

    You should not instantiate directly this class, but create a Client instance that will create it for you and attach it as attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar x_ms_type: Dummy constant parameter, file type can only be file. Constant value: "file".
    :ivar x_ms_copy_action: . Constant value: "abort".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self._config = config
        self.x_ms_type = "file"
        self.x_ms_copy_action = "abort"

    def create(self, file_content_length, file_attributes="none", file_creation_time="now", file_last_write_time="now", timeout=None, metadata=None, file_permission="inherit", file_permission_key=None, file_http_headers=None, lease_access_conditions=None, cls=None, **kwargs):
        """Creates a new file or replaces a file. Note it only initializes the
        file with no content.

        :param file_content_length: Specifies the maximum size for the file,
         up to 1 TB.
        :type file_content_length: long
        :param file_attributes: If specified, the provided file attributes
         shall be set. Default value: ‘Archive’ for file and ‘Directory’ for
         directory. ‘None’ can also be specified as default.
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory.
         Default value: Now.
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory.
         Default value: Now.
        :type file_last_write_time: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage
         object.
        :type metadata: str
        :param file_permission: If specified the permission (security
         descriptor) shall be set for the directory/file. This header can be
         used if Permission size is <= 8KB, else x-ms-file-permission-key
         header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the
         x-ms-file-permission or x-ms-file-permission-key should be specified.
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the
         directory/file. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified.
        :type file_permission_key: str
        :param file_http_headers: Additional parameters for the operation
        :type file_http_headers:
         ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        file_content_type = None
        if file_http_headers is not None:
            file_content_type = file_http_headers.file_content_type
        file_content_encoding = None
        if file_http_headers is not None:
            file_content_encoding = file_http_headers.file_content_encoding
        file_content_language = None
        if file_http_headers is not None:
            file_content_language = file_http_headers.file_content_language
        file_cache_control = None
        if file_http_headers is not None:
            file_cache_control = file_http_headers.file_cache_control
        file_content_md5 = None
        if file_http_headers is not None:
            file_content_md5 = file_http_headers.file_content_md5
        file_content_disposition = None
        if file_http_headers is not None:
            file_content_disposition = file_http_headers.file_content_disposition
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        # Construct URL
        url = self.create.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        header_parameters['x-ms-content-length'] = self._serialize.header("file_content_length", file_content_length, 'long')
        header_parameters['x-ms-type'] = self._serialize.header("self.x_ms_type", self.x_ms_type, 'str')
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        if file_permission is not None:
            header_parameters['x-ms-file-permission'] = self._serialize.header("file_permission", file_permission, 'str')
        if file_permission_key is not None:
            header_parameters['x-ms-file-permission-key'] = self._serialize.header("file_permission_key", file_permission_key, 'str')
        header_parameters['x-ms-file-attributes'] = self._serialize.header("file_attributes", file_attributes, 'str')
        header_parameters['x-ms-file-creation-time'] = self._serialize.header("file_creation_time", file_creation_time, 'str')
        header_parameters['x-ms-file-last-write-time'] = self._serialize.header("file_last_write_time", file_last_write_time, 'str')
        if file_content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("file_content_type", file_content_type, 'str')
        if file_content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("file_content_encoding", file_content_encoding, 'str')
        if file_content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("file_content_language", file_content_language, 'str')
        if file_cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("file_cache_control", file_cache_control, 'str')
        if file_content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("file_content_md5", file_content_md5, 'bytearray')
        if file_content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("file_content_disposition", file_content_disposition, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
                'x-ms-file-permission-key': self._deserialize('str', response.headers.get('x-ms-file-permission-key')),
                'x-ms-file-attributes': self._deserialize('str', response.headers.get('x-ms-file-attributes')),
                'x-ms-file-creation-time': self._deserialize('str', response.headers.get('x-ms-file-creation-time')),
                'x-ms-file-last-write-time': self._deserialize('str', response.headers.get('x-ms-file-last-write-time')),
                'x-ms-file-change-time': self._deserialize('str', response.headers.get('x-ms-file-change-time')),
                'x-ms-file-id': self._deserialize('str', response.headers.get('x-ms-file-id')),
                'x-ms-file-parent-id': self._deserialize('str', response.headers.get('x-ms-file-parent-id')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    create.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def download(self, timeout=None, range=None, range_get_content_md5=None, lease_access_conditions=None, cls=None, **kwargs):
        """Reads or downloads a file from the system, including its metadata and
        properties.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param range: Return file data only from the specified byte range.
        :type range: str
        :param range_get_content_md5: When this header is set to true and
         specified together with the Range header, the service returns the MD5
         hash for the range, as long as the range is less than or equal to 4 MB
         in size.
        :type range_get_content_md5: bool
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: object or the result of cls(response)
        :rtype: Generator
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        # Construct URL
        url = self.download.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/xml'
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if range is not None:
            header_parameters['x-ms-range'] = self._serialize.header("range", range, 'str')
        if range_get_content_md5 is not None:
            header_parameters['x-ms-range-get-content-md5'] = self._serialize.header("range_get_content_md5", range_get_content_md5, 'bool')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 206]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = response.stream_download(self._client._pipeline)
            header_dict = {
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-meta': self._deserialize('{str}', response.headers.get('x-ms-meta')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Content-MD5': self._deserialize('bytearray', response.headers.get('Content-MD5')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-copy-completion-time': self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time')),
                'x-ms-copy-status-description': self._deserialize('str', response.headers.get('x-ms-copy-status-description')),
                'x-ms-copy-id': self._deserialize('str', response.headers.get('x-ms-copy-id')),
                'x-ms-copy-progress': self._deserialize('str', response.headers.get('x-ms-copy-progress')),
                'x-ms-copy-source': self._deserialize('str', response.headers.get('x-ms-copy-source')),
                'x-ms-copy-status': self._deserialize(models.CopyStatusType, response.headers.get('x-ms-copy-status')),
                'x-ms-content-md5': self._deserialize('bytearray', response.headers.get('x-ms-content-md5')),
                'x-ms-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-server-encrypted')),
                'x-ms-file-attributes': self._deserialize('str', response.headers.get('x-ms-file-attributes')),
                'x-ms-file-creation-time': self._deserialize('str', response.headers.get('x-ms-file-creation-time')),
                'x-ms-file-last-write-time': self._deserialize('str', response.headers.get('x-ms-file-last-write-time')),
                'x-ms-file-change-time': self._deserialize('str', response.headers.get('x-ms-file-change-time')),
                'x-ms-file-permission-key': self._deserialize('str', response.headers.get('x-ms-file-permission-key')),
                'x-ms-file-id': self._deserialize('str', response.headers.get('x-ms-file-id')),
                'x-ms-file-parent-id': self._deserialize('str', response.headers.get('x-ms-file-parent-id')),
                'x-ms-lease-duration': self._deserialize(models.LeaseDurationType, response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize(models.LeaseStateType, response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize(models.LeaseStatusType, response.headers.get('x-ms-lease-status')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
        if response.status_code == 206:
            deserialized = response.stream_download(self._client._pipeline)
            header_dict = {
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-meta': self._deserialize('{str}', response.headers.get('x-ms-meta')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'Content-Range': self._deserialize('str', response.headers.get('Content-Range')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Content-MD5': self._deserialize('bytearray', response.headers.get('Content-MD5')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Accept-Ranges': self._deserialize('str', response.headers.get('Accept-Ranges')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-copy-completion-time': self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time')),
                'x-ms-copy-status-description': self._deserialize('str', response.headers.get('x-ms-copy-status-description')),
                'x-ms-copy-id': self._deserialize('str', response.headers.get('x-ms-copy-id')),
                'x-ms-copy-progress': self._deserialize('str', response.headers.get('x-ms-copy-progress')),
                'x-ms-copy-source': self._deserialize('str', response.headers.get('x-ms-copy-source')),
                'x-ms-copy-status': self._deserialize(models.CopyStatusType, response.headers.get('x-ms-copy-status')),
                'x-ms-content-md5': self._deserialize('bytearray', response.headers.get('x-ms-content-md5')),
                'x-ms-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-server-encrypted')),
                'x-ms-file-attributes': self._deserialize('str', response.headers.get('x-ms-file-attributes')),
                'x-ms-file-creation-time': self._deserialize('str', response.headers.get('x-ms-file-creation-time')),
                'x-ms-file-last-write-time': self._deserialize('str', response.headers.get('x-ms-file-last-write-time')),
                'x-ms-file-change-time': self._deserialize('str', response.headers.get('x-ms-file-change-time')),
                'x-ms-file-permission-key': self._deserialize('str', response.headers.get('x-ms-file-permission-key')),
                'x-ms-file-id': self._deserialize('str', response.headers.get('x-ms-file-id')),
                'x-ms-file-parent-id': self._deserialize('str', response.headers.get('x-ms-file-parent-id')),
                'x-ms-lease-duration': self._deserialize(models.LeaseDurationType, response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize(models.LeaseStateType, response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize(models.LeaseStatusType, response.headers.get('x-ms-lease-status')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    download.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def get_properties(self, sharesnapshot=None, timeout=None, lease_access_conditions=None, cls=None, **kwargs):
        """Returns all user-defined metadata, standard HTTP properties, and system
        properties for the file. It does not return the content of the file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime
         value that, when present, specifies the share snapshot to query.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        # Construct URL
        url = self.get_properties.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if sharesnapshot is not None:
            query_parameters['sharesnapshot'] = self._serialize.query("sharesnapshot", sharesnapshot, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.head(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-meta': self._deserialize('{str}', response.headers.get('x-ms-meta')),
                'x-ms-type': self._deserialize('str', response.headers.get('x-ms-type')),
                'Content-Length': self._deserialize('long', response.headers.get('Content-Length')),
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Content-MD5': self._deserialize('bytearray', response.headers.get('Content-MD5')),
                'Content-Encoding': self._deserialize('str', response.headers.get('Content-Encoding')),
                'Cache-Control': self._deserialize('str', response.headers.get('Cache-Control')),
                'Content-Disposition': self._deserialize('str', response.headers.get('Content-Disposition')),
                'Content-Language': self._deserialize('str', response.headers.get('Content-Language')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-copy-completion-time': self._deserialize('rfc-1123', response.headers.get('x-ms-copy-completion-time')),
                'x-ms-copy-status-description': self._deserialize('str', response.headers.get('x-ms-copy-status-description')),
                'x-ms-copy-id': self._deserialize('str', response.headers.get('x-ms-copy-id')),
                'x-ms-copy-progress': self._deserialize('str', response.headers.get('x-ms-copy-progress')),
                'x-ms-copy-source': self._deserialize('str', response.headers.get('x-ms-copy-source')),
                'x-ms-copy-status': self._deserialize(models.CopyStatusType, response.headers.get('x-ms-copy-status')),
                'x-ms-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-server-encrypted')),
                'x-ms-file-attributes': self._deserialize('str', response.headers.get('x-ms-file-attributes')),
                'x-ms-file-creation-time': self._deserialize('str', response.headers.get('x-ms-file-creation-time')),
                'x-ms-file-last-write-time': self._deserialize('str', response.headers.get('x-ms-file-last-write-time')),
                'x-ms-file-change-time': self._deserialize('str', response.headers.get('x-ms-file-change-time')),
                'x-ms-file-permission-key': self._deserialize('str', response.headers.get('x-ms-file-permission-key')),
                'x-ms-file-id': self._deserialize('str', response.headers.get('x-ms-file-id')),
                'x-ms-file-parent-id': self._deserialize('str', response.headers.get('x-ms-file-parent-id')),
                'x-ms-lease-duration': self._deserialize(models.LeaseDurationType, response.headers.get('x-ms-lease-duration')),
                'x-ms-lease-state': self._deserialize(models.LeaseStateType, response.headers.get('x-ms-lease-state')),
                'x-ms-lease-status': self._deserialize(models.LeaseStatusType, response.headers.get('x-ms-lease-status')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    get_properties.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def delete(self, timeout=None, lease_access_conditions=None, cls=None, **kwargs):
        """removes the file from the storage account.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        # Construct URL
        url = self.delete.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    delete.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def set_http_headers(self, file_attributes="none", file_creation_time="now", file_last_write_time="now", timeout=None, file_content_length=None, file_permission="inherit", file_permission_key=None, file_http_headers=None, lease_access_conditions=None, cls=None, **kwargs):
        """Sets HTTP headers on the file.

        :param file_attributes: If specified, the provided file attributes
         shall be set. Default value: ‘Archive’ for file and ‘Directory’ for
         directory. ‘None’ can also be specified as default.
        :type file_attributes: str
        :param file_creation_time: Creation time for the file/directory.
         Default value: Now.
        :type file_creation_time: str
        :param file_last_write_time: Last write time for the file/directory.
         Default value: Now.
        :type file_last_write_time: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param file_content_length: Resizes a file to the specified size. If
         the specified byte value is less than the current size of the file,
         then all ranges above the specified byte value are cleared.
        :type file_content_length: long
        :param file_permission: If specified the permission (security
         descriptor) shall be set for the directory/file. This header can be
         used if Permission size is <= 8KB, else x-ms-file-permission-key
         header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the
         x-ms-file-permission or x-ms-file-permission-key should be specified.
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the
         directory/file. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified.
        :type file_permission_key: str
        :param file_http_headers: Additional parameters for the operation
        :type file_http_headers:
         ~azure.storage.fileshare.models.FileHTTPHeaders
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        file_content_type = None
        if file_http_headers is not None:
            file_content_type = file_http_headers.file_content_type
        file_content_encoding = None
        if file_http_headers is not None:
            file_content_encoding = file_http_headers.file_content_encoding
        file_content_language = None
        if file_http_headers is not None:
            file_content_language = file_http_headers.file_content_language
        file_cache_control = None
        if file_http_headers is not None:
            file_cache_control = file_http_headers.file_cache_control
        file_content_md5 = None
        if file_http_headers is not None:
            file_content_md5 = file_http_headers.file_content_md5
        file_content_disposition = None
        if file_http_headers is not None:
            file_content_disposition = file_http_headers.file_content_disposition
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "properties"

        # Construct URL
        url = self.set_http_headers.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if file_content_length is not None:
            header_parameters['x-ms-content-length'] = self._serialize.header("file_content_length", file_content_length, 'long')
        if file_permission is not None:
            header_parameters['x-ms-file-permission'] = self._serialize.header("file_permission", file_permission, 'str')
        if file_permission_key is not None:
            header_parameters['x-ms-file-permission-key'] = self._serialize.header("file_permission_key", file_permission_key, 'str')
        header_parameters['x-ms-file-attributes'] = self._serialize.header("file_attributes", file_attributes, 'str')
        header_parameters['x-ms-file-creation-time'] = self._serialize.header("file_creation_time", file_creation_time, 'str')
        header_parameters['x-ms-file-last-write-time'] = self._serialize.header("file_last_write_time", file_last_write_time, 'str')
        if file_content_type is not None:
            header_parameters['x-ms-content-type'] = self._serialize.header("file_content_type", file_content_type, 'str')
        if file_content_encoding is not None:
            header_parameters['x-ms-content-encoding'] = self._serialize.header("file_content_encoding", file_content_encoding, 'str')
        if file_content_language is not None:
            header_parameters['x-ms-content-language'] = self._serialize.header("file_content_language", file_content_language, 'str')
        if file_cache_control is not None:
            header_parameters['x-ms-cache-control'] = self._serialize.header("file_cache_control", file_cache_control, 'str')
        if file_content_md5 is not None:
            header_parameters['x-ms-content-md5'] = self._serialize.header("file_content_md5", file_content_md5, 'bytearray')
        if file_content_disposition is not None:
            header_parameters['x-ms-content-disposition'] = self._serialize.header("file_content_disposition", file_content_disposition, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
                'x-ms-file-permission-key': self._deserialize('str', response.headers.get('x-ms-file-permission-key')),
                'x-ms-file-attributes': self._deserialize('str', response.headers.get('x-ms-file-attributes')),
                'x-ms-file-creation-time': self._deserialize('str', response.headers.get('x-ms-file-creation-time')),
                'x-ms-file-last-write-time': self._deserialize('str', response.headers.get('x-ms-file-last-write-time')),
                'x-ms-file-change-time': self._deserialize('str', response.headers.get('x-ms-file-change-time')),
                'x-ms-file-id': self._deserialize('str', response.headers.get('x-ms-file-id')),
                'x-ms-file-parent-id': self._deserialize('str', response.headers.get('x-ms-file-parent-id')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    set_http_headers.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def set_metadata(self, timeout=None, metadata=None, lease_access_conditions=None, cls=None, **kwargs):
        """Updates user-defined metadata for the specified file.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage
         object.
        :type metadata: str
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "metadata"

        # Construct URL
        url = self.set_metadata.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    set_metadata.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def acquire_lease(self, timeout=None, duration=None, proposed_lease_id=None, request_id=None, cls=None, **kwargs):
        """[Update] The Lease File operation establishes and manages a lock on a
        file for write and delete operations.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or
         negative one (-1) for a lease that never expires. A non-infinite lease
         can be between 15 and 60 seconds. A lease duration cannot be changed
         using renew or change.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format.
         The File service returns 400 (Invalid request) if the proposed lease
         ID is not in the correct format. See Guid Constructor (String) for a
         list of valid GUID string formats.
        :type proposed_lease_id: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        comp = "lease"
        action = "acquire"

        # Construct URL
        url = self.acquire_lease.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        if duration is not None:
            header_parameters['x-ms-lease-duration'] = self._serialize.header("duration", duration, 'int')
        if proposed_lease_id is not None:
            header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-lease-id': self._deserialize('str', response.headers.get('x-ms-lease-id')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    acquire_lease.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def release_lease(self, lease_id, timeout=None, request_id=None, cls=None, **kwargs):
        """[Update] The Lease File operation establishes and manages a lock on a
        file for write and delete operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        comp = "lease"
        action = "release"

        # Construct URL
        url = self.release_lease.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    release_lease.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def change_lease(self, lease_id, timeout=None, proposed_lease_id=None, request_id=None, cls=None, **kwargs):
        """[Update] The Lease File operation establishes and manages a lock on a
        file for write and delete operations.

        :param lease_id: Specifies the current lease ID on the resource.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format.
         The File service returns 400 (Invalid request) if the proposed lease
         ID is not in the correct format. See Guid Constructor (String) for a
         list of valid GUID string formats.
        :type proposed_lease_id: str
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        comp = "lease"
        action = "change"

        # Construct URL
        url = self.change_lease.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')
        if proposed_lease_id is not None:
            header_parameters['x-ms-proposed-lease-id'] = self._serialize.header("proposed_lease_id", proposed_lease_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-lease-id': self._deserialize('str', response.headers.get('x-ms-lease-id')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    change_lease.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def break_lease(self, timeout=None, request_id=None, lease_access_conditions=None, cls=None, **kwargs):
        """[Update] The Lease File operation establishes and manages a lock on a
        file for write and delete operations.

        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param request_id: Provides a client-generated, opaque value with a 1
         KB character limit that is recorded in the analytics logs when storage
         analytics logging is enabled.
        :type request_id: str
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "lease"
        action = "break"

        # Construct URL
        url = self.break_lease.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if request_id is not None:
            header_parameters['x-ms-client-request-id'] = self._serialize.header("request_id", request_id, 'str')
        header_parameters['x-ms-lease-action'] = self._serialize.header("action", action, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-lease-id': self._deserialize('str', response.headers.get('x-ms-lease-id')),
                'x-ms-client-request-id': self._deserialize('str', response.headers.get('x-ms-client-request-id')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    break_lease.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def upload_range(self, range, content_length, file_range_write="update", optionalbody=None, timeout=None, content_md5=None, lease_access_conditions=None, cls=None, **kwargs):
        """Upload a range of bytes to a file.

        :param range: Specifies the range of bytes to be written. Both the
         start and end of the range must be specified. For an update operation,
         the range can be up to 4 MB in size. For a clear operation, the range
         can be up to the value of the file's full size. The File service
         accepts only a single byte range for the Range and 'x-ms-range'
         headers, and the byte range must be specified in the following format:
         bytes=startByte-endByte.
        :type range: str
        :param file_range_write: Specify one of the following options: -
         Update: Writes the bytes specified by the request body into the
         specified range. The Range and Content-Length headers must match to
         perform the update. - Clear: Clears the specified range and releases
         the space used in storage for that range. To clear a range, set the
         Content-Length header to zero, and set the Range header to a value
         that indicates the range to clear, up to maximum file size. Possible
         values include: 'update', 'clear'
        :type file_range_write: str or
         ~azure.storage.fileshare.models.FileRangeWriteType
        :param content_length: Specifies the number of bytes being transmitted
         in the request body. When the x-ms-write header is set to clear, the
         value of this header must be set to zero.
        :type content_length: long
        :param optionalbody: Initial data.
        :type optionalbody: Generator
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param content_md5: An MD5 hash of the content. This hash is used to
         verify the integrity of the data during transport. When the
         Content-MD5 header is specified, the File service compares the hash of
         the content that has arrived with the header value that was sent. If
         the two hashes do not match, the operation will fail with error code
         400 (Bad Request).
        :type content_md5: bytearray
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "range"

        # Construct URL
        url = self.upload_range.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/octet-stream'
        header_parameters['x-ms-range'] = self._serialize.header("range", range, 'str')
        header_parameters['x-ms-write'] = self._serialize.header("file_range_write", file_range_write, 'FileRangeWriteType')
        header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long')
        if content_md5 is not None:
            header_parameters['Content-MD5'] = self._serialize.header("content_md5", content_md5, 'bytearray')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct body

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, stream_content=optionalbody)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'Content-MD5': self._deserialize('bytearray', response.headers.get('Content-MD5')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    upload_range.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def upload_range_from_url(self, range, copy_source, content_length, timeout=None, source_range=None, source_content_crc64=None, source_modified_access_conditions=None, lease_access_conditions=None, cls=None, **kwargs):
        """Upload a range of bytes to a file where the contents are read from a
        URL.

        :param range: Writes data to the specified byte range in the file.
        :type range: str
        :param copy_source: Specifies the URL of the source file or blob, up
         to 2 KB in length. To copy a file to another file within the same
         storage account, you may use Shared Key to authenticate the source
         file. If you are copying a file from another storage account, or if
         you are copying a blob from the same storage account or another
         storage account, then you must authenticate the source file or blob
         using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a
         share snapshot can also be specified as a copy source.
        :type copy_source: str
        :param content_length: Specifies the number of bytes being transmitted
         in the request body. When the x-ms-write header is set to clear, the
         value of this header must be set to zero.
        :type content_length: long
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param source_range: Bytes of source data in the specified range.
        :type source_range: str
        :param source_content_crc64: Specify the crc64 calculated for the
         range of bytes that must be read from the copy source.
        :type source_content_crc64: bytearray
        :param source_modified_access_conditions: Additional parameters for
         the operation
        :type source_modified_access_conditions:
         ~azure.storage.fileshare.models.SourceModifiedAccessConditions
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        source_if_match_crc64 = None
        if source_modified_access_conditions is not None:
            source_if_match_crc64 = source_modified_access_conditions.source_if_match_crc64
        source_if_none_match_crc64 = None
        if source_modified_access_conditions is not None:
            source_if_none_match_crc64 = source_modified_access_conditions.source_if_none_match_crc64
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "range"

        # Construct URL
        url = self.upload_range_from_url.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-range'] = self._serialize.header("range", range, 'str')
        header_parameters['x-ms-copy-source'] = self._serialize.header("copy_source", copy_source, 'str')
        if source_range is not None:
            header_parameters['x-ms-source-range'] = self._serialize.header("source_range", source_range, 'str')
        header_parameters['x-ms-write'] = self._serialize.header("self._config.file_range_write_from_url", self._config.file_range_write_from_url, 'str')
        header_parameters['Content-Length'] = self._serialize.header("content_length", content_length, 'long')
        if source_content_crc64 is not None:
            header_parameters['x-ms-source-content-crc64'] = self._serialize.header("source_content_crc64", source_content_crc64, 'bytearray')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if source_if_match_crc64 is not None:
            header_parameters['x-ms-source-if-match-crc64'] = self._serialize.header("source_if_match_crc64", source_if_match_crc64, 'bytearray')
        if source_if_none_match_crc64 is not None:
            header_parameters['x-ms-source-if-none-match-crc64'] = self._serialize.header("source_if_none_match_crc64", source_if_none_match_crc64, 'bytearray')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-content-crc64': self._deserialize('bytearray', response.headers.get('x-ms-content-crc64')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-request-server-encrypted': self._deserialize('bool', response.headers.get('x-ms-request-server-encrypted')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    upload_range_from_url.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def get_range_list(self, sharesnapshot=None, timeout=None, range=None, lease_access_conditions=None, cls=None, **kwargs):
        """Returns the list of valid ranges for a file.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime
         value that, when present, specifies the share snapshot to query.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param range: Specifies the range of bytes over which to list ranges,
         inclusively.
        :type range: str
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: list or the result of cls(response)
        :rtype: list[~azure.storage.fileshare.models.Range]
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "rangelist"

        # Construct URL
        url = self.get_range_list.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if sharesnapshot is not None:
            query_parameters['sharesnapshot'] = self._serialize.query("sharesnapshot", sharesnapshot, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/xml'
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if range is not None:
            header_parameters['x-ms-range'] = self._serialize.header("range", range, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('[Range]', response)
            header_dict = {
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'x-ms-content-length': self._deserialize('long', response.headers.get('x-ms-content-length')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    get_range_list.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def start_copy(self, copy_source, timeout=None, metadata=None, file_permission="inherit", file_permission_key=None, copy_file_smb_info=None, lease_access_conditions=None, cls=None, **kwargs):
        """Copies a blob or file to a destination file within the storage account.

        :param copy_source: Specifies the URL of the source file or blob, up
         to 2 KB in length. To copy a file to another file within the same
         storage account, you may use Shared Key to authenticate the source
         file. If you are copying a file from another storage account, or if
         you are copying a blob from the same storage account or another
         storage account, then you must authenticate the source file or blob
         using a shared access signature. If the source is a public blob, no
         authentication is required to perform the copy operation. A file in a
         share snapshot can also be specified as a copy source.
        :type copy_source: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage
         object.
        :type metadata: str
        :param file_permission: If specified the permission (security
         descriptor) shall be set for the directory/file. This header can be
         used if Permission size is <= 8KB, else x-ms-file-permission-key
         header shall be used. Default value: Inherit. If SDDL is specified as
         input, it must have owner, group and dacl. Note: Only one of the
         x-ms-file-permission or x-ms-file-permission-key should be specified.
        :type file_permission: str
        :param file_permission_key: Key of the permission to be set for the
         directory/file. Note: Only one of the x-ms-file-permission or
         x-ms-file-permission-key should be specified.
        :type file_permission_key: str
        :param copy_file_smb_info: Additional parameters for the operation
        :type copy_file_smb_info:
         ~azure.storage.fileshare.models.CopyFileSmbInfo
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        file_permission_copy_mode = None
        if copy_file_smb_info is not None:
            file_permission_copy_mode = copy_file_smb_info.file_permission_copy_mode
        ignore_read_only = None
        if copy_file_smb_info is not None:
            ignore_read_only = copy_file_smb_info.ignore_read_only
        file_attributes = None
        if copy_file_smb_info is not None:
            file_attributes = copy_file_smb_info.file_attributes
        file_creation_time = None
        if copy_file_smb_info is not None:
            file_creation_time = copy_file_smb_info.file_creation_time
        file_last_write_time = None
        if copy_file_smb_info is not None:
            file_last_write_time = copy_file_smb_info.file_last_write_time
        set_archive_attribute = None
        if copy_file_smb_info is not None:
            set_archive_attribute = copy_file_smb_info.set_archive_attribute
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        # Construct URL
        url = self.start_copy.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if metadata is not None:
            header_parameters['x-ms-meta'] = self._serialize.header("metadata", metadata, 'str')
        header_parameters['x-ms-copy-source'] = self._serialize.header("copy_source", copy_source, 'str')
        if file_permission is not None:
            header_parameters['x-ms-file-permission'] = self._serialize.header("file_permission", file_permission, 'str')
        if file_permission_key is not None:
            header_parameters['x-ms-file-permission-key'] = self._serialize.header("file_permission_key", file_permission_key, 'str')
        if file_permission_copy_mode is not None:
            header_parameters['x-ms-file-permission-copy-mode'] = self._serialize.header("file_permission_copy_mode", file_permission_copy_mode, 'PermissionCopyModeType')
        if ignore_read_only is not None:
            header_parameters['x-ms-file-copy-ignore-read-only'] = self._serialize.header("ignore_read_only", ignore_read_only, 'bool')
        if file_attributes is not None:
            header_parameters['x-ms-file-attributes'] = self._serialize.header("file_attributes", file_attributes, 'str')
        if file_creation_time is not None:
            header_parameters['x-ms-file-creation-time'] = self._serialize.header("file_creation_time", file_creation_time, 'str')
        if file_last_write_time is not None:
            header_parameters['x-ms-file-last-write-time'] = self._serialize.header("file_last_write_time", file_last_write_time, 'str')
        if set_archive_attribute is not None:
            header_parameters['x-ms-file-copy-set-archive'] = self._serialize.header("set_archive_attribute", set_archive_attribute, 'bool')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'ETag': self._deserialize('str', response.headers.get('ETag')),
                'Last-Modified': self._deserialize('rfc-1123', response.headers.get('Last-Modified')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-copy-id': self._deserialize('str', response.headers.get('x-ms-copy-id')),
                'x-ms-copy-status': self._deserialize(models.CopyStatusType, response.headers.get('x-ms-copy-status')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    start_copy.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def abort_copy(self, copy_id, timeout=None, lease_access_conditions=None, cls=None, **kwargs):
        """Aborts a pending Copy File operation, and leaves a destination file
        with zero length and full metadata.

        :param copy_id: The copy identifier provided in the x-ms-copy-id
         header of the original Copy File operation.
        :type copy_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param lease_access_conditions: Additional parameters for the
         operation
        :type lease_access_conditions:
         ~azure.storage.fileshare.models.LeaseAccessConditions
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        lease_id = None
        if lease_access_conditions is not None:
            lease_id = lease_access_conditions.lease_id

        comp = "copy"

        # Construct URL
        url = self.abort_copy.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['copyid'] = self._serialize.query("copy_id", copy_id, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-copy-action'] = self._serialize.header("self.x_ms_copy_action", self.x_ms_copy_action, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')
        if lease_id is not None:
            header_parameters['x-ms-lease-id'] = self._serialize.header("lease_id", lease_id, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    abort_copy.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def list_handles(self, marker=None, maxresults=None, timeout=None, sharesnapshot=None, cls=None, **kwargs):
        """Lists handles for file.

        :param marker: A string value that identifies the portion of the list
         to be returned with the next list operation. The operation returns a
         marker value within the response body if the list returned was not
         complete. The marker value may then be used in a subsequent call to
         request the next set of list items. The marker value is opaque to the
         client.
        :type marker: str
        :param maxresults: Specifies the maximum number of entries to return.
         If the request does not specify maxresults, or specifies a value
         greater than 5,000, the server will return up to 5,000 items.
        :type maxresults: int
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime
         value that, when present, specifies the share snapshot to query.
        :type sharesnapshot: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: ListHandlesResponse or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ListHandlesResponse
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        comp = "listhandles"

        # Construct URL
        url = self.list_handles.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if marker is not None:
            query_parameters['marker'] = self._serialize.query("marker", marker, 'str')
        if maxresults is not None:
            query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', minimum=1)
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if sharesnapshot is not None:
            query_parameters['sharesnapshot'] = self._serialize.query("sharesnapshot", sharesnapshot, 'str')
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/xml'
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        header_dict = {}
        deserialized = None
        if response.status_code == 200:
            deserialized = self._deserialize('ListHandlesResponse', response)
            header_dict = {
                'Content-Type': self._deserialize('str', response.headers.get('Content-Type')),
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }

        if cls:
            return cls(response, deserialized, header_dict)

        return deserialized
    list_handles.metadata = {'url': '/{shareName}/{directory}/{fileName}'}

    def force_close_handles(self, handle_id, timeout=None, marker=None, sharesnapshot=None, cls=None, **kwargs):
        """Closes all handles open for given file.

        :param handle_id: Specifies handle ID opened on the file or directory
         to be closed. Asterix (‘*’) is a wildcard that specifies all handles.
        :type handle_id: str
        :param timeout: The timeout parameter is expressed in seconds. For
         more information, see <a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>
        :type timeout: int
        :param marker: A string value that identifies the portion of the list
         to be returned with the next list operation. The operation returns a
         marker value within the response body if the list returned was not
         complete. The marker value may then be used in a subsequent call to
         request the next set of list items. The marker value is opaque to the
         client.
        :type marker: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime
         value that, when present, specifies the share snapshot to query.
        :type sharesnapshot: str
        :param callable cls: A custom type or function that will be passed the
         direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises:
         :class:`StorageErrorException<azure.storage.fileshare.models.StorageErrorException>`
        """
        error_map = kwargs.pop('error_map', None)
        comp = "forceclosehandles"

        # Construct URL
        url = self.force_close_handles.metadata['url']
        path_format_arguments = {
            'url': self._serialize.url("self._config.url", self._config.url, 'str', skip_quote=True)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int', minimum=0)
        if marker is not None:
            query_parameters['marker'] = self._serialize.query("marker", marker, 'str')
        if sharesnapshot is not None:
            query_parameters['sharesnapshot'] = self._serialize.query("sharesnapshot", sharesnapshot, 'str')
        query_parameters['comp'] = self._serialize.query("comp", comp, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['x-ms-handle-id'] = self._serialize.header("handle_id", handle_id, 'str')
        header_parameters['x-ms-version'] = self._serialize.header("self._config.version", self._config.version, 'str')

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise models.StorageErrorException(response, self._deserialize)

        if cls:
            response_headers = {
                'x-ms-request-id': self._deserialize('str', response.headers.get('x-ms-request-id')),
                'x-ms-version': self._deserialize('str', response.headers.get('x-ms-version')),
                'Date': self._deserialize('rfc-1123', response.headers.get('Date')),
                'x-ms-marker': self._deserialize('str', response.headers.get('x-ms-marker')),
                'x-ms-number-of-handles-closed': self._deserialize('int', response.headers.get('x-ms-number-of-handles-closed')),
                'x-ms-number-of-handles-failed': self._deserialize('int', response.headers.get('x-ms-number-of-handles-failed')),
                'x-ms-error-code': self._deserialize('str', response.headers.get('x-ms-error-code')),
            }
            return cls(response, None, response_headers)
    force_close_handles.metadata = {'url': '/{shareName}/{directory}/{fileName}'}
