/*
 * Atom-4 triboard celltype wrapper
 * Implementation file
 *
 * $Id$
 */

#include "color4.h"


int color4::colortype() {
  if (val=='a' || val=='h') return 0;
  if (val=='b' || val=='c' || val=='e')
    return 1;				// additive
  if (val=='d' || val=='f' || val=='g')
    return 2;				// subtractive

  return -1;				// invalid color
}

color4 color4::propagator(int type) {
  switch(type) {
  case 1:	return color4('h');
  case 2:	return color4('a');
  default:	return BAD_CELL;
  }
}

color4 color4::mix(color4 c) {
  if (c.colortype() < 0) return c;	// c cannot be affected

  switch(colortype()) {
  case 1:				// additive
    return color4(((c.val-'a') | (val-'a')) + 'a');
  case 2:
    return color4(((c.val-'a') & (val-'a')) + 'a');
  default:
    return c;
  }
}

color4 color4::rotl() {
  int rawval = val-'a';
  return color4(( ((rawval<<1)&7) | ((rawval>>2)&1) ) + 'a' );
}

color4 color4::rotr() {
  int rawval = val-'a';
  return color4(( (rawval>>1) | ((rawval&1)<<2) ) + 'a');
}
