subroutine nmceta(modele, numedd, mate, carele, comref,&
                  compor, lischa, carcri, fonact, sdstat,&
                  defico, sdpilo, iterat, sdnume, valinc,&
                  solalg, veelem, veasse, sdtime, sddisc,&
                  nbeffe, irecli, proeta, offset, rho,&
                  etaf, ldccvg, pilcvg, residu, matass)
!
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: mickael.abbas at edf.fr
!
! aslint: disable=W1504
    implicit none
#include "jeveux.h"
#include "asterc/r8maem.h"
#include "asterc/r8vide.h"
#include "asterfort/assert.h"
#include "asterfort/infdbg.h"
#include "asterfort/jedema.h"
#include "asterfort/jemarq.h"
#include "asterfort/jeveuo.h"
#include "asterfort/nmcere.h"
#include "asterfort/nmcese.h"
    integer :: fonact(*)
    logical :: irecli
    integer :: iterat, nbeffe
    integer :: ldccvg, pilcvg
    real(kind=8) :: etaf, proeta(2), rho, offset, residu
    character(len=19) :: lischa, sdnume, sdpilo, matass
    character(len=24) :: modele, numedd, mate, carele, comref, compor
    character(len=24) :: carcri, defico
    character(len=24) :: sdstat, sdtime
    character(len=19) :: veelem(*), veasse(*)
    character(len=19) :: solalg(*), valinc(*)
!
! ----------------------------------------------------------------------
!
! ROUTINE MECA_NON_LINE (ALGORITHME - PILOTAGE)
!
! CHOIX DU PARAMETRE DE PILOTAGE
!
! ----------------------------------------------------------------------
!
!
! IN  MODELE : MODELE
! IN  NUMEDD : NUME_DDL
! IN  MATE   : CHAMP MATERIAU
! IN  CARELE : CARACTERISTIQUES DES ELEMENTS DE STRUCTURE
! IN  COMREF : VARI_COM DE REFERENCE
! IN  COMPOR : COMPORTEMENT
! IN  LISCHA : LISTE DES CHARGES
! IN  SDPILO : SD PILOTAGE
! IN  SDNUME : SD NUMEROTATION
! IN  CARCRI : PARAMETRES DES METHODES D'INTEGRATION LOCALES
! IN  FONACT : FONCTIONNALITES ACTIVEES
! IN  DEFICO : SD DEFINITION CONTACT
! IN  SDSTAT : SD STATISTIQUES
! IN  VALINC : VARIABLE CHAPEAU POUR INCREMENTS VARIABLES
! IN  SOLALG : VARIABLE CHAPEAU POUR INCREMENTS SOLUTIONS
! IN  ITERAT : NUMERO D'ITERATION DE NEWTON
! IN  VEELEM : VARIABLE CHAPEAU POUR NOM DES VECT_ELEM
! IN  VEASSE : VARIABLE CHAPEAU POUR NOM DES VECT_ASSE
! IN  OFFSET : DECALAGE DE ETA_PILOTAGE EN FONCTION DE RHO
! IN  IRECLI : VRAI SI RECH LIN (ON VEUT LE RESIDU)
! IN  SDTIME : SD TIMER
! IN  SDDISC : SD DISCRETISATION
! OUT ETAF   : PARAMETRE DE PILOTAGE
! I/O PILCVG : CODE DE CONVERGENCE POUR LE PILOTAGE
!                -1 : PAS DE CALCUL DU PILOTAGE
!                 0 : CAS DU FONCTIONNEMENT NORMAL
!                 1 : PAS DE SOLUTION
!                 2 : BORNE ATTEINTE -> FIN DU CALCUL
! OUT LDCCVG : CODE RETOUR DE L'INTEGRATION DU COMPORTEMENT
!                -1 : PAS D'INTEGRATION DU COMPORTEMENT
!                 0 : CAS DU FONCTIONNEMENT NORMAL
!                 1 : ECHEC DE L'INTEGRATION DE LA LDC
!                 3 : SIZZ PAS NUL POUR C_PLAN DEBORST
! OUT RESIDU : RESIDU OPTIMAL SI L'ON A CHOISI LE RESIDU
! IN  MATASS : SD MATRICE ASSEMBLEE
!
!
!
!
    logical :: bormin, bormax
    integer :: jpltk, jplir, j, i
    integer :: licite(2)
    real(kind=8) :: infini
    real(kind=8) :: etamin, etamax, conmin, conmax
    real(kind=8) :: eta(2)
    character(len=24) :: projbo, typsel
    character(len=19) :: sddisc
    integer :: ifm, niv
!
! ----------------------------------------------------------------------
!
    call jemarq()
    call infdbg('PILOTAGE', ifm, niv)
!
! --- AFFICHAGE
!
    if (niv .ge. 2) then
        write (ifm,*) '<PILOTAGE> ...... SELECTION DU ETA_PILOTAGE'
    endif
!
! --- LE CALCUL DE PILOTAGE A FORCEMENT ETE REALISE
!
    call assert(pilcvg.ge.0)
!
! --- INITIALISATIONS
!
    licite(1) = 0
    licite(2) = 0
    infini = r8maem()
!
! --- LECTURE DONNEES PILOTAGE
!
    call jeveuo(sdpilo(1:19)//'.PLTK', 'L', jpltk)
    call jeveuo(sdpilo(1:19)//'.PLIR', 'L', jplir)
    projbo = zk24(jpltk+4)
    typsel = zk24(jpltk+5)
!
    if (zr(jplir+1) .ne. r8vide()) then
        etamax = zr(jplir+1)
        bormax = .true.
    else
        etamax = r8vide()
        bormax = .false.
    endif
!
    if (zr(jplir+2) .ne. r8vide()) then
        etamin = zr(jplir+2)
        bormin = .true.
    else
        etamin = r8vide()
        bormin = .false.
    endif
!
    if (zr(jplir+3) .ne. r8vide()) then
        conmax = zr(jplir+3)
    else
        conmax = infini
    endif
!
    if (zr(jplir+4) .ne. r8vide()) then
        conmin = zr(jplir+4)
    else
        conmin = -infini
    endif
!
! --- INTERSECTION AVEC L'INTERVALLE DE CONTROLE ETA_PILO_R_*
!
    j=0
    do 20 i = 1, nbeffe
        if (proeta(i) .ge. conmin .and. proeta(i) .le. conmax) then
            j = j+1
            eta(j) = proeta(i)
            licite(j) = licite(i)
        endif
20  end do
    nbeffe = j
!
    if (nbeffe .eq. 0) then
        pilcvg = 1
        goto 9999
    endif
!
! --- INTERSECTION AVEC L'INTERVALLE ETA_PILO_*
!      - SI PROJ_BORNE = 'OUI', ON PROJETE ETA SUR L'INTERVALLE
!      - DANS TOUS LES CAS, LICITE = -1 INDIQUE QU'ON A FRANCHI LES
!        BORNES
!
    do 50 i = 1, nbeffe
        if (bormax) then
            if (eta(i) .gt. etamax) then
                if (projbo .eq. 'OUI') eta(i) = etamax
                licite(i) = 2
            endif
        endif
        if (bormin) then
            if (eta(i) .lt. etamin) then
                if (projbo .eq. 'OUI') eta(i) = etamin
                licite(i) = 2
            endif
        endif
50  end do
!
! --- SELECTION DU PARAMETRE DE PILOTAGE ETAF
!     S'IL EXISTE DEUX ETA SOLUTIONS :
!        - ON DEMANDE A NMCESE DE CHOISIR
    if (nbeffe .eq. 2) then
        call nmcese(modele, numedd, mate, carele, comref,&
                    compor, lischa, carcri, fonact, sdstat,&
                    defico, iterat, sdnume, sdpilo, valinc,&
                    solalg, veelem, veasse, sdtime, offset,&
                    typsel, sddisc, licite, rho, eta,&
                    etaf, residu, ldccvg, pilcvg, matass)
    else if (nbeffe.eq.1) then
        etaf = eta(1)
        pilcvg = licite(1)
    else
        call assert(.false.)
    endif
!
! --- CALCUL DU RESIDU POUR LA RECHERCHE LINEAIRE
!
    if (irecli) then
! ----- CETTE ETAPE EST SAUTEE SI LE RESIDU EST DEJA CALCULE DANS NMCESE
        if (typsel .eq. 'RESIDU' .and. nbeffe .eq. 2)     continue
        call nmcere(modele, numedd, mate, carele, comref,&
                    compor, lischa, carcri, fonact, sdstat,&
                    defico, iterat, sdnume, valinc, solalg,&
                    veelem, veasse, sdtime, offset, rho,&
                    etaf, residu, ldccvg, matass)
    endif
!
! --- AFFICHAGE
!
    if (niv .ge. 2) then
        write (ifm,*) '<PILOTAGE> ...... ETA_PILOTAGE: ',etaf
        write (ifm,*) '<PILOTAGE> ...... RESIDU OPTI.: ',residu
    endif
!
9999  continue
!
! --- LE CALCUL DE PILOTAGE A FORCEMENT ETE REALISE
!
    call assert(pilcvg.ge.0)
!
    call jedema()
end subroutine
