/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.updater;

import com.sun.tdk.signaturetest.updater.AddClass;
import com.sun.tdk.signaturetest.updater.AddMember;
import com.sun.tdk.signaturetest.updater.ChangeMember;
import com.sun.tdk.signaturetest.updater.Command;
import com.sun.tdk.signaturetest.updater.RemoveClass;
import com.sun.tdk.signaturetest.updater.RemoveMember;
import com.sun.tdk.signaturetest.updater.RemovePackage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Updater
extends DefaultHandler {
    private UpdateRecord ur;
    private LinkedList commands;
    private String lastData;
    private PrintWriter log;

    public boolean perform(String updFile, String fromFile, String toFile, PrintWriter log) {
        if (log != null) {
            this.log = log;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(updFile, (DefaultHandler)this);
            return this.applyUpdate(fromFile, toFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void startDocument() throws SAXException {
        this.commands = new LinkedList();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("update")) {
            this.ur = new UpdateRecord();
            this.fillUR(this.ur, attributes);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastData = this.lastData == null ? new String(ch, start, length) : this.lastData + new String(ch, start, length);
        if (this.lastData != null) {
            this.lastData = this.lastData.trim();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Command c = null;
        if (this.ur != null) {
            if (this.ur.atype.equalsIgnoreCase("removeclass")) {
                RemoveClass rc = new RemoveClass(this.log);
                rc.comments = this.ur.acomments;
                rc.id = this.ur.aid;
                rc.className = this.ur.aclassname;
                c = rc;
            } else if (this.ur.atype.equalsIgnoreCase("removepackage")) {
                RemovePackage rp = new RemovePackage(this.log);
                rp.comments = this.ur.acomments;
                rp.id = this.ur.aid;
                rp.packageName = this.ur.apackagename;
                c = rp;
            } else if (this.ur.atype.equalsIgnoreCase("addclass")) {
                AddClass ac = new AddClass(this.log);
                ac.comments = this.ur.acomments;
                ac.id = this.ur.aid;
                ac.className = this.ur.aclassname;
                ac.body = this.lastData;
                c = ac;
            } else if (this.ur.atype.equalsIgnoreCase("removemember")) {
                RemoveMember rm = new RemoveMember(this.log);
                rm.comments = this.ur.acomments;
                rm.id = this.ur.aid;
                rm.className = this.ur.aclassname;
                rm.memberName = this.ur.amember;
                c = rm;
            } else if (this.ur.atype.equalsIgnoreCase("addmember")) {
                AddMember am = new AddMember(this.log);
                am.comments = this.ur.acomments;
                am.id = this.ur.aid;
                am.className = this.ur.aclassname;
                am.memberName = this.ur.amember;
                c = am;
            } else if (this.ur.atype.equalsIgnoreCase("changemember")) {
                ChangeMember cm = new ChangeMember(this.log);
                cm.comments = this.ur.acomments;
                cm.id = this.ur.aid;
                cm.className = this.ur.aclassname;
                cm.memberName = this.ur.amember;
                cm.newMemberName = this.ur.anewmember;
                c = cm;
            }
            if (c == null) {
                throw new IllegalArgumentException("Unknown type \"" + this.ur.atype + "\" for update");
            }
            ((Command)c).validate();
            this.commands.add(c);
        }
        this.ur = null;
        this.lastData = null;
    }

    private void fillUR(UpdateRecord ur, Attributes attributes) {
        Field[] fs = UpdateRecord.class.getDeclaredFields();
        try {
            for (int i = 0; i < fs.length; ++i) {
                Field f = fs[i];
                String fName = f.getName();
                if (!fName.startsWith("a")) continue;
                f.set(ur, attributes.getValue(fName.substring(1)));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void processCommands(Collection commands, SigList sl) {
        Iterator it = commands.iterator();
        while (it.hasNext()) {
            ((Command)it.next()).perform(sl);
        }
    }

    private boolean applyUpdate(String from, String to) {
        try {
            SigList sl = this.readInput(from);
            this.processCommands(this.commands, sl);
            this.commands.clear();
            sl.pack();
            this.writeOut(to, sl);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void writeOut(String to, SigList sl) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(to));
        Iterator it = sl.iterator();
        while (it.hasNext()) {
            pw.write((String)it.next() + '\n');
        }
        pw.close();
    }

    private SigList readInput(String from) throws IOException {
        String s;
        LineNumberReader r = new LineNumberReader(new BufferedReader(new FileReader(from)));
        SigList sl = new SigList();
        while ((s = r.readLine()) != null) {
            sl.add(s);
        }
        r.close();
        return sl;
    }

    private class UpdateRecord {
        String atype;
        String aclassname;
        String aid;
        String acomments;
        String apackagename;
        String amember;
        String anewmember;

        private UpdateRecord() {
        }
    }

    class SigList
    extends ArrayList {
        private int startPos = -1;

        SigList() {
        }

        public boolean findClass(String className) {
            this.startPos = -1;
            for (int i = 0; i < this.size(); ++i) {
                String l = (String)this.get(i);
                if (!l.startsWith("CLSS ") || !l.endsWith(" " + className)) continue;
                this.startPos = i;
                return true;
            }
            return false;
        }

        public void removeCurrentClass() {
            if (this.startPos >= 0) {
                while (!"".equals(((String)this.get(this.startPos)).trim())) {
                    this.remove(this.startPos);
                }
            }
        }

        public void addText(String body) {
            StringTokenizer st = new StringTokenizer(body, "\n");
            this.add("");
            while (st.hasMoreTokens()) {
                this.add(st.nextToken().trim());
            }
            this.add("");
        }

        public boolean findPackageMember(String packageName) {
            this.startPos = -1;
            String pSig = " " + packageName + ".";
            for (int i = 0; i < this.size(); ++i) {
                String l = (String)this.get(i);
                if (!l.startsWith("CLSS ")) continue;
                int x = l.indexOf(60);
                int y = l.indexOf(pSig);
                if (y <= 0 || y >= x && x != -1) continue;
                this.startPos = i;
                return true;
            }
            return false;
        }

        public boolean removeMember(String memberName) {
            if (this.startPos >= 0) {
                for (int i = this.startPos; i < this.size(); ++i) {
                    String l = ((String)this.get(i)).trim();
                    if (memberName.equals(l)) {
                        this.remove(i);
                        return true;
                    }
                    if ("".equals(l)) break;
                }
            }
            return false;
        }

        public boolean changeMember(String oldMember, String newMember) {
            if (this.startPos >= 0) {
                for (int i = this.startPos; i < this.size(); ++i) {
                    String l = ((String)this.get(i)).trim();
                    if (oldMember.equals(l)) {
                        this.set(i, newMember);
                        return true;
                    }
                    if ("".equals(l)) break;
                }
            }
            return false;
        }

        public void pack() {
            boolean empty = false;
            for (int i = 0; i < this.size(); ++i) {
                String l = (String)this.get(i);
                if ("".equals(l.trim())) {
                    if (empty) {
                        this.remove(i--);
                        continue;
                    }
                    empty = true;
                    continue;
                }
                empty = false;
            }
        }

        public boolean addMember(String memberName) {
            if (this.startPos >= 0) {
                for (int i = this.startPos + 1; i < this.size(); ++i) {
                    String l = ((String)this.get(i)).trim();
                    if (l.startsWith("anno")) continue;
                    this.add(i, memberName);
                    return true;
                }
            }
            return false;
        }
    }
}

