/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.AttributeFactory;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.classfile.attribute.AnnotationsAttr;
import org.cojen.classfile.attribute.ConstantValueAttr;
import org.cojen.classfile.attribute.DeprecatedAttr;
import org.cojen.classfile.attribute.RuntimeInvisibleAnnotationsAttr;
import org.cojen.classfile.attribute.RuntimeVisibleAnnotationsAttr;
import org.cojen.classfile.attribute.SignatureAttr;
import org.cojen.classfile.attribute.SyntheticAttr;
import org.cojen.classfile.constant.ConstantUTFInfo;

public class FieldInfo {
    private ClassFile mParent;
    private ConstantPool mCp;
    private String mName;
    private TypeDesc mType;
    private Modifiers mModifiers;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;
    private List<Attribute> mAttributes = new ArrayList<Attribute>(2);
    private ConstantValueAttr mConstant;

    FieldInfo(ClassFile parent, Modifiers modifiers, String name, TypeDesc type) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = name;
        this.mType = type;
        this.mModifiers = modifiers;
        this.mNameConstant = this.mCp.addConstantUTF(name);
        this.mDescriptorConstant = this.mCp.addConstantUTF(type.getDescriptor());
    }

    private FieldInfo(ClassFile parent, int modifier, ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        this.mParent = parent;
        this.mCp = parent.getConstantPool();
        this.mName = nameConstant.getValue();
        this.mType = TypeDesc.forDescriptor(descConstant.getValue());
        this.mModifiers = Modifiers.getInstance(modifier);
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
    }

    public ClassFile getClassFile() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public TypeDesc getType() {
        return this.mType;
    }

    public Modifiers getModifiers() {
        return this.mModifiers;
    }

    public void setModifiers(Modifiers modifiers) {
        this.mModifiers = modifiers;
    }

    public ConstantUTFInfo getNameConstant() {
        return this.mNameConstant;
    }

    public ConstantUTFInfo getDescriptorConstant() {
        return this.mDescriptorConstant;
    }

    public ConstantInfo getConstantValue() {
        if (this.mConstant == null) {
            return null;
        }
        return this.mConstant.getConstant();
    }

    public boolean isSynthetic() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SyntheticAttr)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof DeprecatedAttr)) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getRuntimeInvisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation[] getRuntimeVisibleAnnotations() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof RuntimeVisibleAnnotationsAttr)) continue;
            return ((AnnotationsAttr)attr).getAnnotations();
        }
        return new Annotation[0];
    }

    public Annotation addRuntimeInvisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeInvisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeInvisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public Annotation addRuntimeVisibleAnnotation(TypeDesc type) {
        AnnotationsAttr attr = null;
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute a = this.mAttributes.get(i);
            if (!(a instanceof RuntimeVisibleAnnotationsAttr)) continue;
            attr = (AnnotationsAttr)a;
        }
        if (attr == null) {
            attr = new RuntimeVisibleAnnotationsAttr(this.mCp);
            this.addAttribute(attr);
        }
        Annotation ann = new Annotation(this.mCp);
        ann.setType(type);
        attr.addAnnotation(ann);
        return ann;
    }

    public SignatureAttr getSignatureAttr() {
        int i = this.mAttributes.size();
        while (--i >= 0) {
            Attribute attr = this.mAttributes.get(i);
            if (!(attr instanceof SignatureAttr)) continue;
            return (SignatureAttr)attr;
        }
        return null;
    }

    public void setConstantValue(int value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, this.mCp.addConstantInteger(value)));
    }

    public void setConstantValue(float value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, this.mCp.addConstantFloat(value)));
    }

    public void setConstantValue(long value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, this.mCp.addConstantLong(value)));
    }

    public void setConstantValue(double value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, this.mCp.addConstantDouble(value)));
    }

    public void setConstantValue(String value) {
        this.addAttribute(new ConstantValueAttr(this.mCp, this.mCp.addConstantString(value)));
    }

    public void markSynthetic() {
        this.addAttribute(new SyntheticAttr(this.mCp));
    }

    public void markDeprecated() {
        this.addAttribute(new DeprecatedAttr(this.mCp));
    }

    public void addAttribute(Attribute attr) {
        if (attr instanceof ConstantValueAttr) {
            if (this.mConstant != null) {
                this.mAttributes.remove(this.mConstant);
            }
            this.mConstant = (ConstantValueAttr)attr;
        }
        this.mAttributes.add(attr);
    }

    public Attribute[] getAttributes() {
        return this.mAttributes.toArray(new Attribute[this.mAttributes.size()]);
    }

    public int getLength() {
        int length = 8;
        int size = this.mAttributes.size();
        for (int i = 0; i < size; ++i) {
            length += this.mAttributes.get(i).getLength();
        }
        return length;
    }

    public void writeTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mModifiers.getBitmask());
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
        int size = this.mAttributes.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            Attribute attr = this.mAttributes.get(i);
            attr.writeTo(dout);
        }
    }

    public String toString() {
        String modStr = this.mModifiers.toString();
        if (modStr.length() == 0) {
            return this.mType.getFullName() + ' ' + this.getName();
        }
        return modStr + ' ' + this.mType.getFullName() + ' ' + this.getName();
    }

    static FieldInfo readFrom(ClassFile parent, DataInput din, AttributeFactory attrFactory) throws IOException {
        ConstantPool cp = parent.getConstantPool();
        int modifier = din.readUnsignedShort();
        int index = din.readUnsignedShort();
        ConstantUTFInfo nameConstant = (ConstantUTFInfo)cp.getConstant(index);
        index = din.readUnsignedShort();
        ConstantUTFInfo descConstant = (ConstantUTFInfo)cp.getConstant(index);
        FieldInfo info = new FieldInfo(parent, modifier, nameConstant, descConstant);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            info.addAttribute(Attribute.readFrom(cp, din, attrFactory));
        }
        return info;
    }
}

